/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.core.impl.oz;

import com.sun.netstorage.array.mgmt.cfg.core.ErrorCode;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.impl.oz.CommandProcessor;
import devmgr.versioned.jrpc.RPCError;
import devmgr.versioned.jrpc.XDRType;
import devmgr.versioned.symbol.CandidateSelectionType;
import devmgr.versioned.symbol.CandidateSelectionTypeData;
import devmgr.versioned.symbol.PhysicalDriveType;
import devmgr.versioned.symbol.RAIDLevel;
import devmgr.versioned.symbol.VolumeCandidate;
import devmgr.versioned.symbol.VolumeCandidateList;
import devmgr.versioned.symbol.VolumeCandidateRequest;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VolumeCandidateFetcher {
    public static final int[] RAID_LEVELS = new int[]{0, 1, 3, 5};
    static /* synthetic */ Class class$com$sun$netstorage$array$mgmt$cfg$core$impl$oz$VolumeCandidateFetcher;

    public static Map loadAllVolumeCandidates(String arrayId) throws ConfigMgmtException {
        String METHOD = "loadNewVolumeCandidates";
        Trace.methodBegin(class$com$sun$netstorage$array$mgmt$cfg$core$impl$oz$VolumeCandidateFetcher == null ? (class$com$sun$netstorage$array$mgmt$cfg$core$impl$oz$VolumeCandidateFetcher = VolumeCandidateFetcher.class$("com.sun.netstorage.array.mgmt.cfg.core.impl.oz.VolumeCandidateFetcher")) : class$com$sun$netstorage$array$mgmt$cfg$core$impl$oz$VolumeCandidateFetcher, "loadNewVolumeCandidates");
        HashMap<Integer, List<VolumeCandidate>> allVolumeCandidates = new HashMap<Integer, List<VolumeCandidate>>();
        CommandProcessor command = null;
        try {
            command = new CommandProcessor(arrayId);
        }
        catch (RPCError e) {
            Trace.error(class$com$sun$netstorage$array$mgmt$cfg$core$impl$oz$VolumeCandidateFetcher == null ? (class$com$sun$netstorage$array$mgmt$cfg$core$impl$oz$VolumeCandidateFetcher = VolumeCandidateFetcher.class$("com.sun.netstorage.array.mgmt.cfg.core.impl.oz.VolumeCandidateFetcher")) : class$com$sun$netstorage$array$mgmt$cfg$core$impl$oz$VolumeCandidateFetcher, (Throwable)e);
            throw new ConfigMgmtException(ErrorCode.ERROR_COMMUNICATING_WITH_ARRAY.getKey(), e.getMessage());
        }
        catch (IOException e) {
            Trace.error(class$com$sun$netstorage$array$mgmt$cfg$core$impl$oz$VolumeCandidateFetcher == null ? (class$com$sun$netstorage$array$mgmt$cfg$core$impl$oz$VolumeCandidateFetcher = VolumeCandidateFetcher.class$("com.sun.netstorage.array.mgmt.cfg.core.impl.oz.VolumeCandidateFetcher")) : class$com$sun$netstorage$array$mgmt$cfg$core$impl$oz$VolumeCandidateFetcher, (Throwable)e);
            throw new ConfigMgmtException(ErrorCode.ERROR_COMMUNICATING_WITH_ARRAY.getKey(), e.getMessage());
        }
        CandidateSelectionTypeData selection = new CandidateSelectionTypeData();
        CandidateSelectionType type = new CandidateSelectionType();
        type.setValue(3);
        selection.setCandidateSelectionType(type);
        for (int j = 0; j < RAID_LEVELS.length; ++j) {
            VolumeCandidate[] vCand = null;
            try {
                vCand = VolumeCandidateFetcher.getVolumeCandidates(selection, RAID_LEVELS[j], arrayId, 0, command);
            }
            catch (ConfigMgmtException cme) {
                Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$core$impl$oz$VolumeCandidateFetcher == null ? VolumeCandidateFetcher.class$("com.sun.netstorage.array.mgmt.cfg.core.impl.oz.VolumeCandidateFetcher") : class$com$sun$netstorage$array$mgmt$cfg$core$impl$oz$VolumeCandidateFetcher, "loadNewVolumeCandidates", "There are no volume candidates for RAID level = " + RAID_LEVELS[j] + " on array = " + arrayId);
            }
            if (vCand != null) {
                List<VolumeCandidate> newCands = Arrays.asList(vCand);
                allVolumeCandidates.put(new Integer(RAID_LEVELS[j]), newCands);
            }
            if (!Trace.isTraceEnabled(class$com$sun$netstorage$array$mgmt$cfg$core$impl$oz$VolumeCandidateFetcher == null ? VolumeCandidateFetcher.class$("com.sun.netstorage.array.mgmt.cfg.core.impl.oz.VolumeCandidateFetcher") : class$com$sun$netstorage$array$mgmt$cfg$core$impl$oz$VolumeCandidateFetcher)) continue;
            StringBuffer buf = new StringBuffer("\nVolume Candidates:");
            int length = vCand != null ? vCand.length : 0;
            for (int i = 0; i < length; ++i) {
                buf.append("\n\tRAID: " + vCand[i].getRaidLevel().getValue());
                buf.append("  drive count: " + vCand[i].getDriveCount());
                buf.append("  useable size: " + vCand[i].getUsableSize());
            }
            Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$core$impl$oz$VolumeCandidateFetcher == null ? VolumeCandidateFetcher.class$("com.sun.netstorage.array.mgmt.cfg.core.impl.oz.VolumeCandidateFetcher") : class$com$sun$netstorage$array$mgmt$cfg$core$impl$oz$VolumeCandidateFetcher, "loadNewVolumeCandidates", buf.toString());
        }
        return allVolumeCandidates;
    }

    public static VolumeCandidate[] getVolumeCandidates(CandidateSelectionTypeData selection, int volumeRaidLevel, String arrayWwn, int driveType, CommandProcessor command) throws ConfigMgmtException {
        String METHOD_NAME = "getVolumeCandidates";
        Trace.methodBegin(class$com$sun$netstorage$array$mgmt$cfg$core$impl$oz$VolumeCandidateFetcher == null ? (class$com$sun$netstorage$array$mgmt$cfg$core$impl$oz$VolumeCandidateFetcher = VolumeCandidateFetcher.class$("com.sun.netstorage.array.mgmt.cfg.core.impl.oz.VolumeCandidateFetcher")) : class$com$sun$netstorage$array$mgmt$cfg$core$impl$oz$VolumeCandidateFetcher, "getVolumeCandidates");
        VolumeCandidateList candidateList = new VolumeCandidateList();
        VolumeCandidate[] candidates = null;
        VolumeCandidateRequest request = new VolumeCandidateRequest();
        request.setCandidateSelectionType(selection);
        request.setRaidLevel(new RAIDLevel(volumeRaidLevel));
        request.setPhyDriveType(new PhysicalDriveType(driveType));
        command.execute(6, (XDRType)request, (XDRType)candidateList, false);
        candidates = candidateList.getVolumeCandidate();
        if (candidates == null || candidates.length == 0) {
            throw new ConfigMgmtException("error.no.volume.candidates", "There is no volume candidates available.");
        }
        return candidates;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

