/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.core.impl.oz;

import com.sun.netstorage.array.mgmt.cfg.util.Convert;
import devmgr.versioned.symbol.AccessVolume;
import devmgr.versioned.symbol.Battery;
import devmgr.versioned.symbol.ComponentBundle;
import devmgr.versioned.symbol.ConsistencyGroup;
import devmgr.versioned.symbol.Controller;
import devmgr.versioned.symbol.Drive;
import devmgr.versioned.symbol.DriveChannel;
import devmgr.versioned.symbol.Esm;
import devmgr.versioned.symbol.Fan;
import devmgr.versioned.symbol.FeatureParams;
import devmgr.versioned.symbol.FreeExtent;
import devmgr.versioned.symbol.Gbic;
import devmgr.versioned.symbol.HLVolumeBundle;
import devmgr.versioned.symbol.HostSpecificValues;
import devmgr.versioned.symbol.IOInterfaceTypeData;
import devmgr.versioned.symbol.InventoryItem;
import devmgr.versioned.symbol.MetadataVolume;
import devmgr.versioned.symbol.Minihub;
import devmgr.versioned.symbol.MirrorProxyVolume;
import devmgr.versioned.symbol.NetInterfaceTypeData;
import devmgr.versioned.symbol.ObjectBundle;
import devmgr.versioned.symbol.PhysicalDriveType;
import devmgr.versioned.symbol.PowerSupply;
import devmgr.versioned.symbol.PremiumFeature;
import devmgr.versioned.symbol.RemoteVolume;
import devmgr.versioned.symbol.SACache;
import devmgr.versioned.symbol.SAData;
import devmgr.versioned.symbol.SYMbolAPIClientV1;
import devmgr.versioned.symbol.SegmentSizeTransition;
import devmgr.versioned.symbol.Sfp;
import devmgr.versioned.symbol.SnapshotVolume;
import devmgr.versioned.symbol.StagedFirmware;
import devmgr.versioned.symbol.StorageArray;
import devmgr.versioned.symbol.ThermalSensor;
import devmgr.versioned.symbol.Tray;
import devmgr.versioned.symbol.UnicodeTranslator;
import devmgr.versioned.symbol.Ups;
import devmgr.versioned.symbol.UserAssignedLabel;
import devmgr.versioned.symbol.Volume;
import devmgr.versioned.symbol.VolumeCache;
import devmgr.versioned.symbol.VolumeCopy;
import devmgr.versioned.symbol.VolumeGroup;
import devmgr.versioned.symbol.VolumePerms;
import devmgr.versioned.symbol.VolumeUsageHint;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;

public class DebugUtil {
    static boolean hex = true;

    static void Usage() {
        DebugUtil.putln("java com.sun.netstorage.array.mgmt.cfg.core.impl.oz.DebugUtil [-d] [-i|o] <ip-addr>");
        DebugUtil.putln("  -d        => use decimal instead of hex for numeric output");
        DebugUtil.putln("  -i        => read object from file name <ip-addr>.bin");
        DebugUtil.putln("  -o        => save object to file name <ip-addr>.bin");
        DebugUtil.putln("  <ip-addr> => IP address of array controller to query");
        System.exit(1);
    }

    public static void main(String[] args) {
        try {
            int argc;
            boolean useDecimal = false;
            boolean getFromFile = false;
            boolean saveToFile = false;
            int n = argc = args == null ? 0 : args.length;
            if (argc == 0 || argc > 3) {
                DebugUtil.Usage();
            }
            for (int i = 0; i < argc - 1; ++i) {
                if (args[i].equals("-d")) {
                    useDecimal = true;
                    continue;
                }
                if (args[i].equals("-i")) {
                    getFromFile = true;
                    continue;
                }
                if (args[i].equals("-o")) {
                    saveToFile = true;
                    continue;
                }
                DebugUtil.Usage();
            }
            if (getFromFile && saveToFile) {
                DebugUtil.Usage();
            }
            String ipAddr = args[argc - 1];
            if (useDecimal) {
                hex = false;
            }
            if (getFromFile) {
                ObjectBundle restored_b = null;
                FileInputStream istream = new FileInputStream(ipAddr + ".bin");
                ObjectInputStream in = new ObjectInputStream(istream);
                restored_b = (ObjectBundle)in.readObject();
                in.close();
                DebugUtil.dumpObjectBundle(restored_b);
            } else {
                InetAddress arrayIP = InetAddress.getByName(ipAddr);
                SYMbolAPIClientV1 sym = new SYMbolAPIClientV1(arrayIP, 2463, true);
                ObjectBundle b = sym.getObjectGraph();
                if (saveToFile) {
                    FileOutputStream ostream = new FileOutputStream(ipAddr + ".bin");
                    ObjectOutputStream p = new ObjectOutputStream(ostream);
                    p.writeObject(b);
                    p.flush();
                    ostream.close();
                } else {
                    DebugUtil.dumpObjectBundle(b);
                }
            }
        }
        catch (Exception e) {
            DebugUtil.putln(e.getMessage());
        }
    }

    static void put(String label, int value) {
        if (hex) {
            System.out.print(label + "0x" + Integer.toHexString(value));
        } else {
            System.out.print(value);
        }
    }

    static void putln(String label, int value) {
        DebugUtil.put(label, value);
        System.out.println();
    }

    static void put(String label, long value) {
        if (hex) {
            System.out.print(label + "0x" + Long.toHexString(value));
        } else {
            System.out.print(label + value);
        }
    }

    static void putln(String label, long value) {
        DebugUtil.put(label, value);
        System.out.println();
    }

    static void put(String label, byte[] value) {
        System.out.print(label + Convert.bytesToString(value));
    }

    static void putln(String label, byte[] value) {
        System.out.println(label + Convert.bytesToString(value));
    }

    static void put(String label, String value) {
        System.out.print(label + value);
    }

    static void putln(String label, String value) {
        System.out.println(label + value);
    }

    static void put(String label, boolean value) {
        System.out.print(label + value);
    }

    static void putln(String label, boolean value) {
        System.out.println(label + value);
    }

    static void put(int i) {
        if (hex) {
            System.out.print("0x" + Integer.toHexString(i));
        } else {
            System.out.print(i);
        }
    }

    static void putln(int i) {
        DebugUtil.put(i);
        System.out.println();
    }

    static void put(byte[] b) {
        System.out.print(Convert.bytesToString(b));
    }

    static void putln(byte[] b) {
        DebugUtil.put(b);
        System.out.println();
    }

    static void put(String s) {
        System.out.print(s);
    }

    static void putln(String s) {
        System.out.println(s);
    }

    static void newline() {
        System.out.println();
    }

    static void dumpIOInterfaces(int which, IOInterfaceTypeData[] di) {
        int length = di == null ? 0 : di.length;
        for (int i = 0; i < length; ++i) {
            if (which == 0) {
                DebugUtil.putln("HOST INTERFACE - ", di[i].hashCode());
            } else {
                DebugUtil.putln("DRIVE INTERFACE - ", di[i].hashCode());
            }
            DebugUtil.putln(" interface     : ", di[i].getInterfaceType().getValue());
            int kind = di[i].getInterfaceType().getValue();
            if (kind == 2) {
                DebugUtil.putln(" channel       : ", di[i].getFibre().getChannel());
                DebugUtil.putln(" loopId        : ", di[i].getFibre().getLoopID());
                DebugUtil.putln(" topology      : ", di[i].getFibre().getTopology().getValue());
                DebugUtil.putln(" speed         : ", di[i].getFibre().getSpeed());
                DebugUtil.putln(" hardAddr      : ", di[i].getFibre().getHardAddress());
                DebugUtil.putln(" nodeName      : ", di[i].getFibre().getNodeName());
                DebugUtil.putln(" portName      : ", di[i].getFibre().getPortName());
                DebugUtil.putln(" portId        : ", di[i].getFibre().getPortId());
                DebugUtil.put(" part/rev      : ", di[i].getFibre().getPart());
                DebugUtil.putln("/", di[i].getFibre().getRevision());
                DebugUtil.putln(" chanMiswire   : ", di[i].getFibre().getChanMiswire());
                DebugUtil.putln(" esmMiswire    : ", di[i].getFibre().getEsmMiswire());
                DebugUtil.putln(" linkStatus    : ", di[i].getFibre().getLinkStatus().getValue());
                DebugUtil.putln(" maxSpeed      : ", di[i].getFibre().getMaxSpeed());
                DebugUtil.putln(" speedControl  : ", di[i].getFibre().getSpeedControl().getValue());
                DebugUtil.putln(" speedNegError : ", di[i].getFibre().getSpeedNegError());
                continue;
            }
            if (kind == 3) {
                DebugUtil.putln(" channel       : ", di[i].getSata().getChannel());
                DebugUtil.putln(" currentSpeed  : ", di[i].getSata().getCurrentInterfaceSpeed().getValue());
                DebugUtil.put(" part/rev      : ", di[i].getSata().getPart());
                DebugUtil.putln("/", di[i].getFibre().getRevision());
                DebugUtil.putln(" maximumSpeed  : ", di[i].getSata().getMaximumInterfaceSpeed().getValue());
                DebugUtil.putln(" speedControl  : ", di[i].getSata().getSpeedControl().getValue());
                continue;
            }
            if (kind != 1) continue;
            DebugUtil.putln(" channel       : ", di[i].getScsi().getChannel());
            DebugUtil.putln(" scsiID        : ", di[i].getScsi().getScsiID());
            DebugUtil.put(" part/rev      : ", di[i].getScsi().getPart());
            DebugUtil.putln("/", di[i].getFibre().getRevision());
            DebugUtil.putln(" speed         : ", di[i].getScsi().getSpeed());
            DebugUtil.putln(" scsiType      : ", di[i].getScsi().getScsiType().getValue());
            DebugUtil.putln(" width         : ", di[i].getScsi().getWidth());
        }
    }

    static void dumpNetInterfaces(NetInterfaceTypeData[] ni) {
        int length = ni == null ? 0 : ni.length;
        for (int i = 0; i < length; ++i) {
            DebugUtil.putln("NET INTERFACE - ", ni[i].hashCode());
            DebugUtil.putln(" device name : ", ni[i].getEthernet().getInterfaceName());
            DebugUtil.putln(" macAddr     : ", ni[i].getEthernet().getMacAddr());
            DebugUtil.putln(" alias       : ", ni[i].getEthernet().getAlias());
            DebugUtil.putln(" channel     : ", ni[i].getEthernet().getChannel());
            DebugUtil.putln(" speed       : ", ni[i].getEthernet().getSpeed());
            DebugUtil.putln(" ip          : ", ni[i].getEthernet().getIp());
            DebugUtil.putln(" Gateway ip  : ", ni[i].getEthernet().getGatewayIp());
            DebugUtil.putln(" Subnet mask : ", ni[i].getEthernet().getSubnetMask());
            DebugUtil.putln(" bootp used  : ", ni[i].getEthernet().getBootpUsed());
            DebugUtil.putln(" remote login: ", ni[i].getEthernet().getRloginEnabled());
        }
    }

    static void dumpInventory(InventoryItem[] item) {
        int length = item == null ? 0 : item.length;
        DebugUtil.putln("INVENTORY - ", item[0].hashCode());
        for (int i = 0; i < length; ++i) {
            DebugUtil.putln(" " + item[i].getItemName() + "\t\t: ", item[i].getItemVersion());
        }
    }

    static void dumpControllers(Controller[] c) {
        int length = c == null ? 0 : c.length;
        for (int i = 0; i < length; ++i) {
            DebugUtil.putln("CONTROLLER - ", c[i].hashCode());
            DebugUtil.putln(" active          : ", c[i].getActive());
            DebugUtil.putln(" quiesced        : ", c[i].getQuiesced());
            DebugUtil.putln(" status          : ", c[i].getStatus().getValue());
            DebugUtil.put(" processor/cache : ", c[i].getProcessorMemorySize());
            DebugUtil.putln("/", c[i].getCacheMemorySize());
            DebugUtil.putln(" appVersion      : ", c[i].getAppVersion());
            DebugUtil.putln(" bootVersion     : ", c[i].getBootVersion());
            DebugUtil.putln(" productRevLevel : ", c[i].getProductRevLevel());
            DebugUtil.putln(" manufacturer    : ", c[i].getManufacturer());
            DebugUtil.putln(" productID       : ", c[i].getProductID());
            DebugUtil.putln(" serialNumber    : ", c[i].getSerialNumber());
            DebugUtil.putln(" boardID         : ", c[i].getBoardID());
            DebugUtil.putln(" manufactureDate : ", c[i].getManufacturerDate());
            DebugUtil.putln(" tray/slot       : ", c[i].getPhysicalLocation().getSlot());
            DebugUtil.putln(" controllerRef   : ", c[i].getControllerRef().getRefToken());
            DebugUtil.dumpIOInterfaces(0, c[i].getHostInterfaces());
            DebugUtil.dumpIOInterfaces(1, c[i].getDriveInterfaces());
            DebugUtil.dumpNetInterfaces(c[i].getNetInterfaces());
            DebugUtil.dumpInventory(c[i].getInventory());
        }
    }

    static void dumpFans(Fan[] f) {
        int length = f == null ? 0 : f.length;
        for (int i = 0; i < length; ++i) {
            DebugUtil.putln("FAN - ", f[i].hashCode());
            DebugUtil.putln(" status   : ", f[i].getStatus().getValue());
            DebugUtil.putln(" tray/slot: ", f[i].getPhysicalLocation().getSlot());
            DebugUtil.putln(" trayRef  : ", f[i].getPhysicalLocation().getTrayRef().getRefToken());
            DebugUtil.putln(" fanRef   : ", f[i].getFanRef().getRefToken());
        }
    }

    static void dumpBattery(Battery[] b) {
        int length = b == null ? 0 : b.length;
        for (int i = 0; i < length; ++i) {
            DebugUtil.putln("BATTERY - ", b[i].hashCode());
            DebugUtil.putln(" status       : ", b[i].getStatus().getValue());
            DebugUtil.putln(" tray/slot    : ", b[i].getPhysicalLocation().getSlot());
            DebugUtil.putln(" trayRef      : ", b[i].getPhysicalLocation().getTrayRef().getRefToken());
            DebugUtil.putln(" batteryRef   : ", b[i].getBatteryRef().getRefToken());
            DebugUtil.putln(" batteryAge   : ", b[i].getBatteryAge());
            DebugUtil.putln(" life left    : ", b[i].getBatteryLifeRemaining());
            DebugUtil.putln(" controllerRef: ", b[i].getBatteryTypeData().getParentController().getRefToken());
        }
    }

    static void dumpPowerSupply(PowerSupply[] ps) {
        int length = ps == null ? 0 : ps.length;
        for (int i = 0; i < length; ++i) {
            DebugUtil.putln("POWER SUPPLY - ", ps[i].hashCode());
            DebugUtil.putln(" status         : ", ps[i].getStatus().getValue());
            DebugUtil.putln(" tray/slot      : ", ps[i].getPhysicalLocation().getSlot());
            DebugUtil.putln(" trayRef        : ", ps[i].getPhysicalLocation().getTrayRef().getRefToken());
            DebugUtil.putln(" powerSupplyRef : ", ps[i].getPowerSupplyRef().getRefToken());
            DebugUtil.putln(" partNumber     : ", ps[i].getPartNumber());
            DebugUtil.putln(" serialNumber   : ", ps[i].getSerialNumber());
            DebugUtil.putln(" vendorName     : ", ps[i].getVendorName());
            DebugUtil.putln(" manufactureDate: ", ps[i].getManufacturerDate());
            DebugUtil.putln(" fruType        : ", ps[i].getFruType());
        }
    }

    static void dumpThermalSensor(ThermalSensor[] ts) {
        int length = ts == null ? 0 : ts.length;
        for (int i = 0; i < length; ++i) {
            DebugUtil.putln("THERMAL SENSOR - ", ts[i].hashCode());
            DebugUtil.putln(" status          : ", ts[i].getStatus().getValue());
            DebugUtil.putln(" tray/slot       : ", ts[i].getPhysicalLocation().getSlot());
            DebugUtil.putln(" trayRef         : ", ts[i].getPhysicalLocation().getTrayRef().getRefToken());
            DebugUtil.putln(" thermalSensorRef: ", ts[i].getThermalSensorRef().getRefToken());
        }
    }

    static void dumpESM(Esm[] e) {
        int length = e == null ? 0 : e.length;
        for (int i = 0; i < length; ++i) {
            DebugUtil.putln("ESM - ", e[i].hashCode());
            DebugUtil.putln(" status            : ", e[i].getStatus().getValue());
            DebugUtil.putln(" tray/slot         : ", e[i].getPhysicalLocation().getSlot());
            DebugUtil.putln(" trayRef           : ", e[i].getPhysicalLocation().getTrayRef().getRefToken());
            DebugUtil.putln(" esmRef            : ", e[i].getEsmRef().getRefToken());
            DebugUtil.putln(" nonRedundantAccess: ", e[i].getNonRedundantAccess());
            DebugUtil.putln(" partNumber        : ", e[i].getPartNumber());
            DebugUtil.putln(" serialNumber      : ", e[i].getSerialNumber());
            DebugUtil.putln(" manufactureDate   : ", e[i].getManufacturerDate());
            DebugUtil.putln(" manufacturer      : ", e[i].getManufacturer());
            DebugUtil.putln(" fruType           : ", e[i].getFruType());
            DebugUtil.putln(" software version  : ", e[i].getSoftwareVersion());
            DebugUtil.putln(" product ID        : ", e[i].getProductID());
            DebugUtil.putln(" interface type    : ", e[i].getEsmInterfaceData().getIoInterfaceType().getValue());
            DebugUtil.putln(" currentSpeed      : ", e[i].getCurrentSpeed().getValue());
            DebugUtil.putln(" maxSpeed          : ", e[i].getMaxSpeed().getValue());
        }
    }

    static void dumpSFP(Sfp[] s) {
        int length = s == null ? 0 : s.length;
        for (int i = 0; i < length; ++i) {
            DebugUtil.putln("SFP - ", s[i].hashCode());
            DebugUtil.putln(" status            : ", s[i].getStatus().getValue());
            DebugUtil.putln(" tray/slot         : ", s[i].getPhysicalLocation().getSlot());
            DebugUtil.putln(" trayRef           : ", s[i].getPhysicalLocation().getTrayRef().getRefToken());
            DebugUtil.putln(" sfpRef            : ", s[i].getSfpRef().getRefToken());
            DebugUtil.putln(" type/port         : ", s[i].getSfpPort().getValue());
            DebugUtil.putln(" connector         : ", s[i].getSfpType().getSfpConnectType().getValue());
            DebugUtil.putln(" link length type  : ", s[i].getSfpType().getSfpLinkLType().getValue());
            DebugUtil.putln(" transmitter type  : ", s[i].getSfpType().getSfpTransmitterType().getValue());
            DebugUtil.putln(" speed capability  : ", s[i].getSfpType().getSfpSpeed().getValue());
            DebugUtil.putln(" transmission media: ", s[i].getSfpType().getSfpTransmissionMedia().getValue());
            DebugUtil.putln(" vendorName        : ", s[i].getSfpType().getVendorName());
            DebugUtil.putln(" vendorOUI         : ", s[i].getSfpType().getVendorOUI());
            DebugUtil.putln(" vendorPN          : ", s[i].getSfpType().getVendorPN());
            DebugUtil.putln(" vendorRev         : ", s[i].getSfpType().getVendorRev());
            DebugUtil.putln(" vendorSN          : ", s[i].getSfpType().getVendorSN());
            DebugUtil.putln(" manufactureDate   : ", s[i].getSfpType().getManufacturerDate());
            DebugUtil.putln(" parent type       : ", s[i].getParentData().getSfpParentType().getValue());
            DebugUtil.putln(" esmRef            : ", "TBD");
        }
    }

    static void dumpMinihub(Minihub[] m) {
        int length = m == null ? 0 : m.length;
        for (int i = 0; i < length; ++i) {
            DebugUtil.putln("MINIHUB - ", m[i].hashCode());
            DebugUtil.putln(" channel           : ", m[i].getChannel());
            DebugUtil.putln(" fruType           : ", m[i].getFruType());
            DebugUtil.putln(" manufactureDate   : ", m[i].getManufacturerDate());
            DebugUtil.putln(" PartNumber        : ", m[i].getPartNumber());
            DebugUtil.putln(" serialNumber      : ", m[i].getSerialNumber());
            DebugUtil.putln(" vendor            : ", m[i].getVendorName());
            DebugUtil.putln(" currentSpeed      : ", m[i].getCurrentSpeed().getValue());
            DebugUtil.putln(" maxSpeed          : ", m[i].getMaxSpeed().getValue());
            DebugUtil.putln(" MinihubRef        : ", m[i].getMinihubRef().getRefToken());
            DebugUtil.putln(" slot              : ", m[i].getPhysicalLocation().getSlot());
            DebugUtil.putln(" status            : ", m[i].getStatus().getValue());
        }
    }

    static void dumpUps(Ups[] u) {
        int length = u == null ? 0 : u.length;
        for (int i = 0; i < length; ++i) {
            DebugUtil.putln("UPS - ", u[i].hashCode());
            DebugUtil.putln(" status            : ", u[i].getStatus().getValue());
            DebugUtil.putln(" slot              : ", u[i].getPhysicalLocation().getSlot());
            DebugUtil.putln(" UpsRef            : ", u[i].getUpsRef().getRefToken());
        }
    }

    static void dumpGbic(Gbic[] g) {
        int length = g == null ? 0 : g.length;
        for (int i = 0; i < length; ++i) {
            DebugUtil.putln("GBIC - ", g[i].hashCode());
            DebugUtil.putln(" status            : ", g[i].getStatus().getValue());
            DebugUtil.putln(" GbicPort          : ", g[i].getGbicPort().getValue());
            DebugUtil.putln(" GbicRef           : ", g[i].getGbicRef().getRefToken());
            DebugUtil.putln(" slot              : ", g[i].getPhysicalLocation().getSlot());
            DebugUtil.putln(" type              : ", g[i].getGbicType().getValue());
        }
    }

    static void dumpComponentBundle(ComponentBundle c) {
        DebugUtil.dumpFans(c.getFan());
        DebugUtil.dumpBattery(c.getBattery());
        DebugUtil.dumpPowerSupply(c.getPowerSupply());
        DebugUtil.dumpThermalSensor(c.getThermalSensor());
        DebugUtil.dumpESM(c.getEsm());
        DebugUtil.dumpSFP(c.getSfp());
        DebugUtil.dumpUps(c.getUps());
        DebugUtil.dumpMinihub(c.getMinihub());
        DebugUtil.dumpGbic(c.getGbic());
    }

    static void dumpVolumeCache(VolumeCache cache) {
        DebugUtil.put(" cache         : ");
        if (cache.getCwob()) {
            DebugUtil.put("CWOB ");
        }
        if (cache.getEnterpriseCacheDump()) {
            DebugUtil.put("ECD ");
        }
        if (cache.getMirrorActive()) {
            DebugUtil.put("CMA ");
        }
        if (cache.getMirrorEnable()) {
            DebugUtil.put("CME ");
        }
        if (cache.getReadCacheActive()) {
            DebugUtil.put("RCA ");
        }
        if (cache.getReadCacheEnable()) {
            DebugUtil.put("RCE ");
        }
        if (cache.getWriteCacheActive()) {
            DebugUtil.put("WCA ");
        }
        if (cache.getWriteCacheEnable()) {
            DebugUtil.put("WCE ");
        }
        DebugUtil.newline();
        DebugUtil.putln(" cache modifier: ", cache.getCacheFlushModifier().getValue());
        DebugUtil.putln(" readAheadMult : ", cache.getReadAheadMultiplier());
    }

    static void dumpVolumePerms(VolumePerms perms) {
        DebugUtil.put(" permissions   : MAP=", perms.getMapToLUN() ? "Y" : "N");
        DebugUtil.put(", SNAP=", perms.getSnapShot() ? "Y" : "N");
        DebugUtil.putln(", FORMAT=", perms.getFormat() ? "Y" : "N");
        DebugUtil.put("               : RECONFIG=", perms.getReconfigure() ? "Y" : "N");
        DebugUtil.put(", READ=", perms.getReadable() ? "Y" : "N");
        DebugUtil.putln(", WRITE=", perms.getWritable() ? "Y" : "N");
        DebugUtil.put("               : MIRROR PRIMARY=", perms.getMirrorPrimary() ? "Y" : "N");
        DebugUtil.putln(", MIRROR SECONDARY=", perms.getMirrorSecondary() ? "Y" : "N");
        DebugUtil.put("               : COPY SOURCE=", perms.getCopySource() ? "Y" : "N");
        DebugUtil.putln(", COPY TARGET=", perms.getCopyTarget() ? "Y" : "N");
    }

    static void dumpVolumes(Volume[] v) {
        int length = v == null ? 0 : v.length;
        for (int i = 0; i < length; ++i) {
            DebugUtil.putln("VOLUME - ", v[i].hashCode());
            DebugUtil.putln(" volumeHandle  : ", v[i].getVolumeHandle());
            DebugUtil.putln(" raidLevel     : ", v[i].getRaidLevel().getValue());
            DebugUtil.putln(" offline       : ", v[i].getOffline());
            DebugUtil.putln(" sectorOffset  : ", v[i].getSectorOffset());
            DebugUtil.put(" blk/segSize   : ", v[i].getBlkSize());
            DebugUtil.putln("/", v[i].getSegmentSize());
            DebugUtil.putln(" capacity      : ", v[i].getCapacity());
            DebugUtil.putln(" reconPriority : ", v[i].getReconPriority());
            DebugUtil.putln(" media scan    : ", v[i].getMediaScan().getEnable());
            DebugUtil.put(" status/action : ", v[i].getStatus().getValue());
            DebugUtil.putln("/", v[i].getAction().getValue());
            DebugUtil.dumpVolumeCache(v[i].getCache());
            DebugUtil.putln(" WWN           : ", v[i].getWorldWideName());
            DebugUtil.putln(" volumeGroupRef: ", v[i].getVolumeGroupRef().getRefToken());
            DebugUtil.putln(" volumeRef     : ", v[i].getVolumeRef().getRefToken());
            DebugUtil.putln(" currentMgr    : ", v[i].getCurrentManager().getRefToken());
            DebugUtil.putln(" preferredMgr  : ", v[i].getPreferredManager().getRefToken());
            DebugUtil.putln(" label         : ", v[i].getLabel().getValue());
            DebugUtil.putln(" label         : ", UnicodeTranslator.getString((byte[])v[i].getLabel().getValue()));
            DebugUtil.dumpVolumePerms(v[i].getPerms());
        }
    }

    static void dumpDrives(Drive[] d) {
        int length = d == null ? 0 : d.length;
        for (int i = 0; i < length; ++i) {
            DebugUtil.putln("DRIVE - ", d[i].hashCode());
            DebugUtil.put(" Off/GHS/Rmvd/Avlb  : ", d[i].getOffline());
            DebugUtil.put("/", d[i].getHotSpare());
            DebugUtil.put("/", d[i].getInvalidDriveData());
            DebugUtil.putln("/", d[i].getAvailable());
            DebugUtil.putln(" uncertified        : ", d[i].getUncertified());
            DebugUtil.putln(" Pfa                : ", d[i].getPfa());
            DebugUtil.putln(" status             : ", d[i].getStatus().getValue());
            DebugUtil.putln(" cause              : ", d[i].getCause().getValue());
            DebugUtil.putln(" vgIndex            : ", d[i].getVolumeGroupIndex());
            DebugUtil.putln(" inquiry info       : ", d[i].getManufacturer());
            DebugUtil.putln(" serialNumber       : ", d[i].getSerialNumber());
            DebugUtil.putln(" blkSize            : ", d[i].getBlkSize());
            DebugUtil.put(" raw/usable caps    : ", d[i].getRawCapacity());
            DebugUtil.putln("/", d[i].getUsableCapacity());
            DebugUtil.putln(" interfaceType      : ", d[i].getInterfaceType().getDriveType().getValue());
            DebugUtil.putln(" tray/slot          : ", d[i].getPhysicalLocation().getSlot());
            DebugUtil.putln(" manufactureDate    : ", d[i].getManufacturerDate());
            DebugUtil.putln(" currentVolGrpRef   : ", d[i].getCurrentVolumeGroupRef().getRefToken());
            DebugUtil.putln(" driveRef           : ", d[i].getDriveRef().getRefToken());
            DebugUtil.putln(" sparedForDriveRef  : ", d[i].getSparedForDriveRef().getRefToken());
            DebugUtil.putln(" mirrorDriveRef     : ", d[i].getMirrorDrive().getRefToken());
            DebugUtil.putln(" WWN                : ", d[i].getWorldWideName());
            DebugUtil.putln(" nonRedundantAccess : ", d[i].getNonRedundantAccess());
            DebugUtil.putln(" hasDegradedChannel : ", d[i].getHasDegradedChannel());
            DebugUtil.putln(" currentSpeed       : ", d[i].getCurrentSpeed().getValue());
            DebugUtil.putln(" phyDriveType       : ", d[i].getPhyDriveType().getValue());
            DebugUtil.putln(" spindleSpeed       : ", d[i].getSpindleSpeed());
        }
    }

    static void dumpVolumeGroups(VolumeGroup[] vg) {
        int length = vg == null ? 0 : vg.length;
        for (int i = 0; i < length; ++i) {
            DebugUtil.putln("VOLUME GROUP - ", vg[i].hashCode());
            DebugUtil.putln(" sequenceNum        : ", vg[i].getSequenceNum());
            DebugUtil.putln(" offline            : ", vg[i].getOffline());
            DebugUtil.putln(" raidLevel          : ", vg[i].getRaidLevel().getValue());
            DebugUtil.putln(" trayLossProtection : ", vg[i].getTrayLossProtection());
            DebugUtil.putln(" volumeGroupRef     : ", vg[i].getVolumeGroupRef().getRefToken());
            DebugUtil.putln(" WWN                : ", vg[i].getWorldWideName());
        }
    }

    static void dumpFreeExtents(FreeExtent[] f) {
        int length = f == null ? 0 : f.length;
        for (int i = 0; i < length; ++i) {
            DebugUtil.putln("FREE EXTENT - ", f[i].hashCode());
            DebugUtil.putln(" sectorOffset       : ", f[i].getSectorOffset());
            DebugUtil.putln(" rawCapacity        : ", f[i].getRawCapacity());
            DebugUtil.putln(" raidLevel          : ", f[i].getRaidLevel().getValue());
            DebugUtil.putln(" volumeGroupRef     : ", f[i].getVolumeGroupRef().getRefToken());
            DebugUtil.putln(" freeExtentRef      : ", f[i].getFreeExtentRef().getRefToken());
        }
    }

    static void dumpTrays(Tray[] t) {
        int length = t == null ? 0 : t.length;
        for (int i = 0; i < length; ++i) {
            DebugUtil.putln("TRAY - ", t[i].hashCode());
            DebugUtil.putln(" type               : ", t[i].getType().getValue());
            DebugUtil.put(" slots(C/D)         : ", t[i].getNumControllerSlots());
            DebugUtil.putln("/", t[i].getNumDriveSlots());
            DebugUtil.putln(" trayID             : ", t[i].getTrayId());
            DebugUtil.putln(" orientation        : ", t[i].getOrientation().getValue());
            DebugUtil.putln(" trayRef            : ", t[i].getTrayRef().getRefToken());
            DebugUtil.putln(" nonRedundantAccess : ", t[i].getNonRedundantAccess());
            DebugUtil.putln(" partNumber         : ", t[i].getPartNumber());
            DebugUtil.putln(" serialNumber       : ", t[i].getSerialNumber());
            DebugUtil.putln(" vendorName         : ", t[i].getVendorName());
            DebugUtil.putln(" manufactureDate    : ", t[i].getManufacturerDate());
            DebugUtil.putln(" fruType            : ", t[i].getFruType());
            DebugUtil.putln(" trayIDMismatch     : ", t[i].getTrayIDMismatch());
            DebugUtil.putln(" trayIDConflict     : ", t[i].getTrayIDConflict());
            DebugUtil.putln(" esmVersionMismatch : ", t[i].getEsmVersionMismatch());
            DebugUtil.putln(" esmMiswire         : ", t[i].getEsmMiswire());
            DebugUtil.putln(" drvMHSpeedMismatch : ", t[i].getDrvMHSpeedMismatch());
            DebugUtil.putln(" unsupppportedTray  : ", t[i].getUnsupportedTray());
            DebugUtil.putln(" maxSpeed           : ", t[i].getMaxSpeed().getValue());
            DebugUtil.putln(" trayTechnologyType : ", t[i].getTrayTechnologyType().getValue());
        }
    }

    static void dumpPremiumFeatures(PremiumFeature[] pf) {
        int length = pf == null ? 0 : pf.length;
        for (int i = 0; i < length; ++i) {
            DebugUtil.putln("PREMIUM FEATURES - ", pf[i].hashCode());
            DebugUtil.putln(" capability      : ", pf[i].getCapability().getValue());
            DebugUtil.putln(" isEnabled       : ", pf[i].getIsEnabled());
            DebugUtil.putln(" isCompliant     : ", pf[i].getIsCompliant());
            DebugUtil.putln(" isWithinLimits  : ", pf[i].getIsWithinLimits());
        }
    }

    static void dumpSAData(SAData s) {
        DebugUtil.putln("SADATA - ", s.hashCode());
        DebugUtil.put(" attention/fixing: ", s.getNeedsAttention());
        DebugUtil.putln("/", s.getFixing());
        DebugUtil.putln(" bootTime        : ", s.getBootTime());
        DebugUtil.putln(" label           : ", UnicodeTranslator.getString((byte[])s.getStorageArrayLabel().getValue()));
        DebugUtil.putln(" saID            : ", s.getSaId().getWorldWideName());
        DebugUtil.putln(" javaClass       : ", s.getClass().getName());
        DebugUtil.putln(" nvsramVersion   : ", s.getNvsramVersion());
        DebugUtil.putln(" fwPrefix        : ", s.getFwPrefix());
        DebugUtil.putln(" fwVersion       : ", UnicodeTranslator.getString((byte[])s.getFwVersion()));
        DebugUtil.putln(" appVersion      : ", UnicodeTranslator.getString((byte[])s.getAppVersion()));
        DebugUtil.putln(" bootVersion     : ", UnicodeTranslator.getString((byte[])s.getBootVersion()));
        DebugUtil.putln(" attribute       : ", s.getArrayAttributes().length);
    }

    static void dumpStagedFirmware(StagedFirmware s) {
        DebugUtil.putln("STAGED FIRMWARE - ", s.hashCode());
        DebugUtil.putln(" isValid         : ", s.getStagedFwValid());
        DebugUtil.putln(" fwVersion       : ", s.getFwVersion());
        DebugUtil.putln(" appVersion      : ", s.getAppVersion());
        DebugUtil.putln(" bootVersion     : ", s.getBootVersion());
        DebugUtil.putln(" nvsramVersion   : ", s.getNvsramVersion());
        DebugUtil.putln(" Timestamp       : " + s.getTimeStamp());
    }

    static void dumpSACache(SACache s) {
        DebugUtil.putln("SACACHE - ", s.hashCode());
        DebugUtil.putln(" cacheBlkSize    : ", s.getCacheBlkSize());
        DebugUtil.put(" flush thresh/amt: ", s.getDemandFlushThreshold());
        DebugUtil.putln("/", s.getDemandFlushAmount());
    }

    static void dumpAccessVolume(AccessVolume av) {
        DebugUtil.putln("ACCESS VOLUME - ", av.hashCode());
        DebugUtil.putln(" enabled         : ", av.getEnabled());
        DebugUtil.putln(" volumeHandle    : ", av.getVolumeHandle());
        DebugUtil.putln(" capacity        : ", av.getCapacity());
        DebugUtil.putln(" accessVolumeRef : ", av.getAccessVolumeRef().getRefToken());
    }

    static void dumpFeatureParams(FeatureParams fp) {
        DebugUtil.putln("FEATURE PARAMS - ", fp.hashCode());
        DebugUtil.putln(" maxHotSpares          : ", fp.getMaxHotSpares());
        DebugUtil.putln(" maxDCEDrives          : ", fp.getMaxDCEDrives());
        DebugUtil.putln(" minScanPeriod         : ", fp.getMinMediaScanPeriod());
        DebugUtil.putln(" maxScanPeriod         : ", fp.getMaxMediaScanPeriod());
        DebugUtil.putln(" maxPartitionCount     : ", fp.getMaxPartitionCount());
        DebugUtil.putln(" maxMappingsPerVolume  : ", fp.getMaxMappingsPerVolume());
        DebugUtil.putln(" maxVolumes            : ", fp.getMaxVolumes());
        DebugUtil.putln(" maxSnapshots          : ", fp.getMaxSnapshots());
        DebugUtil.putln(" maxSnapshotsPerBase   : ", fp.getMaxSnapshotsPerBase());
        DebugUtil.putln(" minRepositorySize     : ", fp.getMinRepositorySize());
        DebugUtil.putln(" maxMirrors            : ", fp.getMaxMirrors());
        DebugUtil.putln(" currentMaxMirrors     : ", fp.getCurrentMaxMirrors());
        DebugUtil.putln(" maxVolCopys           : ", fp.getMaxVolCopys());
        DebugUtil.putln(" maxConcurrentBgCopys  : ", fp.getMaxConcurrentBackgroundCopys());
        DebugUtil.putln(" maxUtmLunValue        : ", fp.getMaxUtmLunValue());
        DebugUtil.putln(" maxReadAheadMult      : ", fp.getMaxReadAheadMultiplier());
        DebugUtil.putln(" maxVolumesPerGroup    : ", fp.getMaxVolumesPerGroup());
        DebugUtil.putln(" mappableLUNCount      : ", fp.getMappableLUNCount());
        DebugUtil.putln(" battery_not_in_config : ", fp.getBattery_not_in_configuration());
        DebugUtil.put(" cacheBlockSizes       :");
        int[] cbs = fp.getCacheBlockSizes();
        for (int i = 0; i < cbs.length; ++i) {
            DebugUtil.put(" ", cbs[i]);
        }
        DebugUtil.newline();
        DebugUtil.put(" supportedDriveTypes   :");
        PhysicalDriveType[] sdt = fp.getSupportedDriveTypes();
        for (int i = 0; i < sdt.length; ++i) {
            DebugUtil.put(" ", sdt[i].getValue());
        }
        DebugUtil.newline();
        DebugUtil.put(" segSizes              :");
        SegmentSizeTransition[] sst = fp.getSegTransitions();
        for (int i = 0; i < sst.length; ++i) {
            DebugUtil.put(" ", sst[i].getValue());
        }
        DebugUtil.newline();
        DebugUtil.putln(" numStandardSegSizes   : ", fp.getNumStandardSegSizes());
    }

    static void dumpDriveChannels(DriveChannel[] dc) {
        int length = dc == null ? 0 : dc.length;
        for (int i = 0; i < length; ++i) {
            DebugUtil.put("Chan: " + dc[i].getChannel());
            DebugUtil.putln(" State: " + dc[i].getState().getValue());
            DebugUtil.putln(" Ctl: <A>  LinkStatus " + dc[i].getStatsControllerA().getLinkStatus().getValue());
            DebugUtil.putln(" Start Time: " + dc[i].getStatsControllerA().getStartTimeStamp());
            DebugUtil.putln("   End Time: " + dc[i].getStatsControllerA().getEndTimeStamp());
            DebugUtil.put(" TotoalIoErr: " + dc[i].getStatsControllerA().getTotalIoErrorCount());
            DebugUtil.put(" IoCount: " + dc[i].getStatsControllerA().getTotalIoCount());
            DebugUtil.putln(" PercentError: ");
            DebugUtil.putln(" Ctl: <B>  LinkStatus " + dc[i].getStatsControllerB().getLinkStatus().getValue());
            DebugUtil.putln(" Start Time: " + dc[i].getStatsControllerB().getStartTimeStamp());
            DebugUtil.putln("   End Time: " + dc[i].getStatsControllerB().getEndTimeStamp());
            DebugUtil.put(" TotoalIoErr: " + dc[i].getStatsControllerB().getTotalIoErrorCount());
            DebugUtil.put(" IoCount: " + dc[i].getStatsControllerB().getTotalIoCount());
            DebugUtil.putln(" PercentError: ");
        }
    }

    static void dumpHostSpecificRegions(HostSpecificValues[] h) {
        DebugUtil.putln("HOST SPECIFIC REGIONS - ", h[0].hashCode());
        int length = h == null ? 0 : h.length;
        for (int i = 0; i < length; ++i) {
            DebugUtil.putln(" Region " + i);
            DebugUtil.putln("  offset Name                                              Value");
            DebugUtil.putln("  --------------------------------------------------------------");
            DebugUtil.putln("  0x00   Host Type String                                : ", h[i].getHostPortType().getValue());
            DebugUtil.putln("  0x10   Wait For Download                               : ", h[i].getWaitForDownload());
            DebugUtil.putln("  0x11   Inquiry Unconfigure Device Type                 : ", h[i].getInquiryUnconfiguredDeviceType());
            DebugUtil.putln("  0x12   Not Ready Sense For Quiescence In Progress      : ", h[i].getNotReadySenseForQuiescenceInProgress());
            DebugUtil.putln("  0x13   Not Ready Sense For Quiescence In Progress 2    : ", h[i].getNotReadySenseForQuiescenceInProgress2());
            DebugUtil.putln("  0x14   Check Condition For Vendor Unique UA Conditions : ", h[i].getCheckConditionForVendorUniqueUAConditions());
            DebugUtil.putln("  0x15   Report Deferred Errors                          : ", h[i].getReportDeferredErrors());
            DebugUtil.putln("  0x16   Inquiry Unowned Device Type                     : ", h[i].getInquiryUnownedDeviceType());
            DebugUtil.putln("  0x17   Ignore Force Unit Access                        : ", h[i].getIgnoreForceUnitAccess());
            DebugUtil.putln("  0x18   Ignore Write Cache Disable                      : ", h[i].getIgnoreWriteCacheDisable());
            DebugUtil.putln("  0x19   Allow Reservation On Unowned LUNs               : ", h[i].getAllowReservationOnUnownedLUNs());
            DebugUtil.putln("  0x1A   World Wide Name In Standard Inquiry             : ", h[i].getWorldWideNameInStandardInquiry());
            DebugUtil.putln("  0x1B   Propagate Host Bus Resets                       : ", h[i].getPropagateHostBusResets());
            DebugUtil.putln("  0x1C   Report SCC Device Enable                        : ", h[i].getReportSCCDeviceEnable());
            DebugUtil.putln("  0x1D   Conditional FC Logout                           : ", h[i].getConditionalFCLogout());
            DebugUtil.putln("  0x1F   Force SCSI 2                                    : ", h[i].getForceSCSI2());
            DebugUtil.putln("  0x20   Report Unconfigured LUNs                        : ", h[i].getReportUnconfiguredLUNs());
            DebugUtil.putln("  0x21   Ignore Sync Cache                               : ", h[i].getIgnoreSyncCache());
            DebugUtil.putln("  0x22   Ignore UTM Lun Ownership                        : ", h[i].getIgnoreUTMLunOwnership());
            DebugUtil.putln("  0x23   Report LUN Preferred Path In Standard Inquiry   : ", h[i].getReportLUNPreferredPathInStandardInquiry());
            DebugUtil.putln("  0x24   Auto LUN Transfer Enabled                       : ", h[i].getAutoLUNTransfer());
            DebugUtil.putln("  0x25   Unowned Block 0 Read                            : ", h[i].getUnownedBlock0Read());
            DebugUtil.putln("  0x27   Retain Logins (bit 0)                           : ", h[i].getRetainLogins());
            DebugUtil.putln("  0x27   Restricted LUN Access                           : ", h[i].getMaxRestrictedLUNs());
        }
    }

    static void dumpUsageHints(VolumeUsageHint[] v) {
        DebugUtil.putln("USAGE HINTS - ", v[0].hashCode());
        int length = v == null ? 0 : v.length;
        for (int i = 0; i < length; ++i) {
            DebugUtil.putln(" usage hint     : ", v[i].getUsageHint().getValue());
            DebugUtil.putln(" segment size   : ", v[i].getSegmentSize());
            DebugUtil.putln(" read ahead     : ", v[i].getReadAhead());
        }
    }

    static void dumpHostPorts(UserAssignedLabel[] l) {
        DebugUtil.putln("Host Ports");
        int length = l == null ? 0 : l.length;
        for (int i = 0; i < length; ++i) {
            DebugUtil.putln(" ", UnicodeTranslator.getString((byte[])l[i].getValue()));
        }
    }

    static void dumpStorageArray(StorageArray sa) {
        DebugUtil.putln("STORAGE ARRAY - ", sa.hashCode());
        DebugUtil.putln(" capabilities            : ");
        DebugUtil.putln(" mediascan period        : ", sa.getMediaScanPeriod());
        DebugUtil.putln(" defined partition count : ", sa.getDefinedPartitionCount());
        DebugUtil.putln(" default host port type  : ", sa.getDefaultHostPortTypeIndex());
        DebugUtil.putln(" SAFE ID                 : ", sa.getSafeId().getWorldWideName());
        DebugUtil.putln(" remote access ID        : ", sa.getRemoteAccessID());
        DebugUtil.putln(" trayPositions           : ");
        DebugUtil.putln(" compatable firmware     : ");
        DebugUtil.dumpPremiumFeatures(sa.getPremiumFeatures());
        DebugUtil.dumpSAData(sa.getSaData());
        DebugUtil.dumpStagedFirmware(sa.getStagedFirmware());
        DebugUtil.dumpSACache(sa.getCache());
        DebugUtil.dumpAccessVolume(sa.getAccessVolume());
        DebugUtil.dumpFeatureParams(sa.getFeatureParameters());
        DebugUtil.dumpDriveChannels(sa.getDriveChannels());
        DebugUtil.dumpHostSpecificRegions(sa.getHostSpecificVals());
        DebugUtil.dumpUsageHints(sa.getUsageHints());
        DebugUtil.putln(" volXferAlertDelayPeriod = ", sa.getVolXferAlertDelayPeriod());
        DebugUtil.dumpHostPorts(sa.getHostPortType());
    }

    static void dumpConsistencyGroup(ConsistencyGroup[] cg) {
        DebugUtil.putln("CONSISTENCY GROUP - ", cg[0].hashCode());
        int length = cg == null ? 0 : cg.length;
        for (int i = 0; i < length; ++i) {
            DebugUtil.put(" Group #", i);
            DebugUtil.putln(" ref: ", cg[i].getGroupRef().getRefToken());
        }
    }

    static void dumpSnapshotVols(SnapshotVolume[] snaps) {
        int length = snaps == null ? 0 : snaps.length;
        for (int i = 0; i < length; ++i) {
            DebugUtil.putln("SNAPSHOT - ", snaps[i].hashCode());
            DebugUtil.putln(" volumeHandle       : ", snaps[i].getVolumeHandle());
            DebugUtil.putln(" WWN                : ", snaps[i].getWorldWideName());
            DebugUtil.putln(" snapshotRef        : ", snaps[i].getSnapshotRef().getRefToken());
            DebugUtil.putln(" label              : ", snaps[i].getLabel().getValue());
            DebugUtil.putln(" label              : ", UnicodeTranslator.getString((byte[])snaps[i].getLabel().getValue()));
            DebugUtil.put(" status/action      : ", snaps[i].getStatus().getValue());
            DebugUtil.putln("/" + snaps[i].getAction().getValue());
            DebugUtil.putln(" currentMgr         : ", snaps[i].getCurrentManager().getRefToken());
            DebugUtil.putln(" baseVolume         : ", snaps[i].getBaseVolume().getRefToken());
            DebugUtil.putln(" repositoryVolume   : ", snaps[i].getRepositoryVolume().getRefToken());
            DebugUtil.putln(" fullWarnThreshold  : ", snaps[i].getFullWarnThreshold());
            DebugUtil.putln(" overWarnThreshold  : ", snaps[i].getOverWarnThreshold());
            DebugUtil.putln(" repositoryFull     : ", snaps[i].getRepositoryFull());
            DebugUtil.putln(" repFullPolicy      : ", snaps[i].getRepFullPolicy().getValue());
            DebugUtil.putln(" rollbackPriority   : ", snaps[i].getRollbackPriority());
            DebugUtil.putln(" extentStart        : ", snaps[i].getExtentStart());
            DebugUtil.putln(" extentSize         : ", snaps[i].getExtentSize());
            DebugUtil.putln(" snapshotTime       : ", snaps[i].getSnapshotTime());
            DebugUtil.putln(" childrenInactive   : ", snaps[i].getChildrenInactive());
            DebugUtil.dumpVolumePerms(snaps[i].getPerms());
        }
    }

    static void dumpMetadataVols(MetadataVolume[] meta) {
        int length = meta == null ? 0 : meta.length;
        for (int i = 0; i < length; ++i) {
            DebugUtil.putln("METADTA VOLUME - ", meta[i].hashCode());
            DebugUtil.putln(" metadataRef        : ", meta[i].getMetadataVolRef().getRefToken());
            DebugUtil.putln(" metadata type      : ", meta[i].getMetadataVolType().getValue());
            DebugUtil.putln(" associatedVolume   : ", meta[i].getAssociatedVolume().getRefToken());
            DebugUtil.putln(" preferredManager   : ", meta[i].getPreferredManager().getRefToken());
            DebugUtil.dumpVolumePerms(meta[i].getPerms());
        }
    }

    static void dumpMirrorVols(MirrorProxyVolume[] mirror) {
        int length = mirror == null ? 0 : mirror.length;
        for (int i = 0; i < length; ++i) {
            DebugUtil.putln("MIRROR PROXY VOLUME - ", mirror[i].hashCode());
            DebugUtil.putln(" usableCapacity     : ", mirror[i].getUsableCapacity());
            DebugUtil.putln(" volumeHandle       : ", mirror[i].getVolumeHandle());
            DebugUtil.putln(" action             : ", mirror[i].getAction().getValue());
            DebugUtil.putln(" autoResync         : ", mirror[i].getAutoResync());
            DebugUtil.putln(" baseVolume         : ", mirror[i].getBaseVolume().getRefToken());
            DebugUtil.putln(" consistencyGroupRef: ", mirror[i].getConsistencyGroupRef().getRefToken());
            DebugUtil.putln(" currentManager     : ", mirror[i].getCurrentManager().getRefToken());
            DebugUtil.putln(" localMirrorStatus  : ", mirror[i].getLocalMirrorStatus().getValue());
            DebugUtil.putln(" localPriority      : ", mirror[i].getLocalPriority().getValue());
            DebugUtil.putln(" localRole          : ", mirror[i].getLocalRole().getValue());
            DebugUtil.putln(" localWriteMode     : ", mirror[i].getLocalWriteMode().getValue());
            DebugUtil.putln(" mirrorProxyRef     : ", mirror[i].getMirrorProxyRef().getRefToken());
            DebugUtil.putln(" peerPriority       : ", mirror[i].getPeerPriority().getValue());
            DebugUtil.putln(" remoteMirrorStatus : ", mirror[i].getRemoteMirrorStatus().getValue());
            DebugUtil.putln(" remoteRole         : ", mirror[i].getRemoteRole().getValue());
            DebugUtil.putln(" remoteVolRef       : ", mirror[i].getRemoteVolRef().getRefToken());
            DebugUtil.putln(" WWN                : ", mirror[i].getWorldWideName());
        }
    }

    static void dumpRemoteVols(RemoteVolume[] remote) {
        int length = remote == null ? 0 : remote.length;
        for (int i = 0; i < length; ++i) {
            DebugUtil.putln("REMOTE VOLUME - ", remote[i].hashCode());
            DebugUtil.putln(" remoteVolCapacity  : ", remote[i].getRemoteVolCapacity());
            DebugUtil.putln(" volumeHandle       : ", remote[i].getVolumeHandle());
            DebugUtil.putln(" manager            : ", remote[i].getManager().getRefToken());
            DebugUtil.putln(" remoteArrayId      : ", remote[i].getRemoteArrayId().getWorldWideName());
            DebugUtil.putln(" remoteNodeWWN      : ", remote[i].getRemoteNodeWWN());
            DebugUtil.putln(" remoteVolRef       : ", remote[i].getRemoteVolRef().getRefToken());
            DebugUtil.putln(" remoteVolState     : ", remote[i].getRemoteVolState().getValue());
            DebugUtil.putln(" remoteVolUserLabel : ", UnicodeTranslator.getString((byte[])remote[i].getRemoteVolUserLabel().getValue()));
            DebugUtil.putln(" WWN                : ", remote[i].getWorldWideName());
            DebugUtil.dumpVolumePerms(remote[i].getPerms());
        }
    }

    static void dumpVolumeCopies(VolumeCopy[] vc) {
        int length = vc == null ? 0 : vc.length;
        for (int i = 0; i < length; ++i) {
            DebugUtil.putln("VOLUME COPY - ", vc[i].hashCode());
            DebugUtil.putln(" volcopyRef         : ", vc[i].getVolcopyRef().getRefToken());
            DebugUtil.putln(" volcopyHandle      : ", vc[i].getVolcopyHandle());
            DebugUtil.putln(" sourceVolume       : ", vc[i].getSourceVolume().getRefToken());
            DebugUtil.putln(" targetVolume       : ", vc[i].getTargetVolume().getRefToken());
            DebugUtil.putln(" currentManager     : ", vc[i].getCurrentManager().getRefToken());
            DebugUtil.putln(" copyPriority       : ", vc[i].getCopyPriority().getValue());
            DebugUtil.putln(" idleTargetWriteProt: ", vc[i].getIdleTargetWriteProt());
            DebugUtil.putln(" status             : ", vc[i].getStatus().getValue());
            DebugUtil.putln(" copyStartTime      : ", vc[i].getCopyStartTime());
            DebugUtil.putln(" copyCompleteTime   : ", vc[i].getCopyCompleteTime());
        }
    }

    static void dumpHighLevelBundle(HLVolumeBundle hlb) {
        DebugUtil.dumpSnapshotVols(hlb.getSnapshotVol());
        DebugUtil.dumpMetadataVols(hlb.getMetadataVol());
        DebugUtil.dumpMirrorVols(hlb.getMirrorVol());
        DebugUtil.dumpRemoteVols(hlb.getRemoteVol());
        DebugUtil.dumpVolumeCopies(hlb.getVolumeCopy());
    }

    public static void dumpObjectBundle(ObjectBundle b) {
        DebugUtil.putln("OBJECT BUNDLE - ", b.hashCode());
        DebugUtil.putln("cfgGeneration : ", b.getConfigGeneration());
        DebugUtil.dumpControllers(b.getController());
        DebugUtil.dumpVolumes(b.getVolume());
        DebugUtil.dumpDrives(b.getDrive());
        DebugUtil.dumpComponentBundle(b.getComponentBundle());
        DebugUtil.dumpVolumeGroups(b.getVolumeGroup());
        DebugUtil.dumpFreeExtents(b.getFreeExtent());
        DebugUtil.dumpTrays(b.getTray());
        DebugUtil.dumpStorageArray(b.getSa());
        DebugUtil.dumpConsistencyGroup(b.getConsistencyGroupBundle().getConsistencyGroup());
        DebugUtil.dumpHighLevelBundle(b.getHighLevelVolBundle());
    }

    public static void doit(String ctrlIP) {
        try {
            InetAddress arrayIP = InetAddress.getByName(ctrlIP);
            SYMbolAPIClientV1 sym = new SYMbolAPIClientV1(arrayIP, 2463, true);
            ObjectBundle b = sym.getObjectGraph();
            DebugUtil.dumpObjectBundle(b);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

