/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.core.impl.oz;

import com.sun.netstorage.array.mgmt.cfg.core.ErrorCode;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.SEItemNotFoundException;
import com.sun.netstorage.array.mgmt.cfg.core.impl.ArrayReg;
import com.sun.netstorage.array.mgmt.cfg.core.impl.ArrayRegManager;
import com.sun.netstorage.array.mgmt.cfg.core.ini.Repository;
import com.sun.netstorage.array.mgmt.cfg.util.Convert;
import com.sun.netstorage.array.mgmt.cfg.util.Poolable;
import devmgr.versioned.jrpc.RPCAuthGenerator;
import devmgr.versioned.jrpc.RPCError;
import devmgr.versioned.symbol.AccessibleController;
import devmgr.versioned.symbol.ChangeQueryDescriptor;
import devmgr.versioned.symbol.ChangeState;
import devmgr.versioned.symbol.Controller;
import devmgr.versioned.symbol.ControllerDescriptor;
import devmgr.versioned.symbol.ControllerRef;
import devmgr.versioned.symbol.DiscoveryResponse;
import devmgr.versioned.symbol.NetInterfaceTypeData;
import devmgr.versioned.symbol.ObjectBundle;
import devmgr.versioned.symbol.SAData;
import devmgr.versioned.symbol.SAIdentifier;
import devmgr.versioned.symbol.SYMbolAPIClientV1;
import devmgr.versioned.symbol.SYMbolAuthGenerator;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class Connection
implements Poolable {
    public static String ARRAY_RESPONSE_WAIT_PARAM = "array-response-wait";
    String arrayId;
    ArrayReg arrayReg = null;
    String password = "";
    String connectedToController;
    String connectedToIp;
    SYMbolAPIClientV1 sym;
    long lastConfigGenNumber = -1L;
    private long latestCriticalMel = -1L;
    int listId;
    int arrayMaxWait = 5000;

    public Connection(String arrayWwn) {
        String methodName = "Connection";
        this.arrayId = arrayWwn;
        this.arrayReg = ArrayRegManager.getInstance().getArrayRegistration(this.arrayId);
        if (this.arrayReg != null) {
            this.password = this.arrayReg.getPassword();
        }
        if (Repository.getRepository().getProperty(ARRAY_RESPONSE_WAIT_PARAM) != null) {
            try {
                this.arrayMaxWait = Integer.parseInt((String)Repository.getRepository().getProperty(ARRAY_RESPONSE_WAIT_PARAM));
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        try {
            this.sym = this.getClient(this.arrayReg);
            this.lastConfigGenNumber = -1L;
        }
        catch (SEItemNotFoundException e) {
            Trace.error((Object)this, "Connection", (ConfigMgmtException)e);
        }
        catch (RPCError e) {
            Trace.error((Object)this, "Connection", (Throwable)e);
        }
        catch (IOException e) {
            Trace.error((Object)this, "Connection", (Throwable)e);
        }
    }

    public Object getHandle() {
        String methodName = "getHandle";
        if (this.sym != null && this.isConnectionStale(this.sym)) {
            this.sym = null;
        }
        if (this.sym == null) {
            try {
                this.sym = this.getClient(this.arrayReg);
            }
            catch (SEItemNotFoundException e) {
                Trace.error((Object)this, "getHandle", (ConfigMgmtException)e);
                this.sym = null;
            }
            catch (RPCError e) {
                Trace.error((Object)this, "getHandle", (Throwable)e);
                this.sym = null;
            }
            catch (IOException e) {
                Trace.error((Object)this, "getHandle", (Throwable)e);
                this.sym = null;
            }
        }
        return this.sym;
    }

    private boolean isConnectionStale(SYMbolAPIClientV1 s1) {
        String methodName = "isConnectionStale";
        Trace.methodBegin(this, "isConnectionStale");
        boolean isStale = false;
        try {
            SAData sadata = s1.getSAData();
            if (sadata == null || sadata.getSaId() == null) {
                isStale = true;
            }
        }
        catch (RPCError e) {
            Trace.verbose((Object)this, "isConnectionStale", "RPCError validating connection:" + e.getMessage());
            isStale = true;
        }
        catch (IOException e) {
            Trace.verbose((Object)this, "isConnectionStale", "IOException validating connection:" + e.getMessage());
            isStale = true;
        }
        catch (Exception e) {
            Trace.verbose((Object)this, "isConnectionStale", "Exception validating connection:" + e.getMessage());
            isStale = true;
        }
        Trace.verbose((Object)this, "isConnectionStale", "returning isStale info...");
        return isStale;
    }

    public String getCurrentControllerRef() {
        return this.connectedToController;
    }

    public SYMbolAPIClientV1 getHandleToOtherController() throws ConfigMgmtException {
        String methodName = "getHandleToOtherController";
        try {
            if (this.sym == null || this.isConnectionStale(this.sym)) {
                String currCtrl = this.getCurrentControllerRef();
                this.sym = this.getClient(this.arrayReg);
                if (this.sym == null) {
                    throw new ConfigMgmtException(ErrorCode.ERROR_COMMUNICATING_WITH_ARRAY.getKey(), "Cannot connect to any controller on the array");
                }
                if (currCtrl != null && !currCtrl.equals(this.getCurrentControllerRef())) {
                    return this.sym;
                }
            }
            Trace.verbose((Object)this, "getHandleToOtherController", "Currently Connected to controller ip:" + this.sym.getDestinationIP().getHostAddress());
            ObjectBundle bundle = this.sym.getObjectGraph();
            String ctIP = this.getAlternateControllerIP(this.connectedToController, bundle);
            if (this.sym != null) {
                try {
                    this.sym.close();
                    this.sym = null;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            Trace.verbose((Object)this, "getHandleToOtherController", "Connect to new controller:" + ctIP);
            this.sym = this.getClient(this.arrayReg.getIps(), ctIP);
            if (this.sym == null) {
                Trace.verbose((Object)this, "getHandleToOtherController", "Could not connect to other controller - throw exception");
                throw new ConfigMgmtException(ErrorCode.ERROR_COMMUNICATING_WITH_ARRAY.getKey(), "Cannot connect to alternate controller");
            }
            Trace.verbose((Object)this, "getHandleToOtherController", "Now Connected to controller ip:" + this.sym.getDestinationIP().getHostAddress());
        }
        catch (SEItemNotFoundException e) {
            Trace.error((Object)this, "getHandleToOtherController", (ConfigMgmtException)e);
        }
        catch (RPCError e) {
            Trace.error((Object)this, "getHandleToOtherController", (Throwable)e);
            Trace.error((Object)this, "getHandleToOtherController", "retrying connection");
            this.sym = null;
            try {
                String currCtrl = this.getCurrentControllerRef();
                this.sym = this.getClient(this.arrayReg);
                if (this.sym == null) {
                    throw new ConfigMgmtException(ErrorCode.ERROR_COMMUNICATING_WITH_ARRAY.getKey(), "Cannot connect to any controller on the array");
                }
                if (currCtrl != null && !currCtrl.equals(this.getCurrentControllerRef())) {
                    return this.sym;
                }
                ObjectBundle bundle = this.sym.getObjectGraph();
                String ctIP = this.getAlternateControllerIP(this.connectedToController, bundle);
                if (this.sym != null) {
                    try {
                        this.sym.close();
                        this.sym = null;
                    }
                    catch (Exception symex) {
                        // empty catch block
                    }
                }
                this.sym = this.getClient(this.arrayReg.getIps(), ctIP);
            }
            catch (Exception ex) {
                this.sym = null;
                Trace.error((Object)this, "getHandleToOtherController", (Throwable)ex);
                throw new ConfigMgmtException(ErrorCode.ERROR_COMMUNICATING_WITH_ARRAY.getKey(), "Cannot connect to alternate controller during retry - RPCError");
            }
        }
        catch (IOException e) {
            Trace.error((Object)this, "getHandleToOtherController", (Throwable)e);
        }
        return this.sym;
    }

    private SYMbolAPIClientV1 getClient(ArrayReg arrayReg) throws RPCError, IOException, SEItemNotFoundException {
        String methodName = "getClient";
        Trace.methodBegin(this, "getClient");
        String[] ips = arrayReg.getIps();
        boolean connected = false;
        SYMbolAPIClientV1 sym = null;
        for (int i = 0; i < ips.length && !connected; ++i) {
            sym = this.connectFromThread(ips[i]);
            if (sym == null) {
                Trace.verbose((Object)this, "getClient", "Could not connect to ip:" + ips[i]);
                continue;
            }
            DiscoveryResponse dr = sym.discoverControllers();
            if (!dr.getResponseFromAgent()) {
                connected = true;
                this.connectedToController = Convert.bytesToString(dr.getControllers()[0].getThisController().getRefToken());
                this.connectedToIp = ips[i];
            } else {
                connected = this.processAgentResponse(null, connected, sym, dr);
            }
            if (connected) continue;
            Trace.verbose((Object)this, "getClient", "Not connected to right array/controller - close current connection");
            try {
                sym.close();
                sym = null;
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        Trace.verbose((Object)this, "getClient", "Done");
        if (!connected) {
            throw new SEItemNotFoundException(this.arrayId);
        }
        return sym;
    }

    private SYMbolAPIClientV1 connectFromThread(String ip) throws UnknownHostException {
        String methodName = "connectFromThread";
        Trace.methodBegin(this, "connectFromThread");
        InetAddress inet = InetAddress.getByName(ip);
        SimpleThreadConnect stc = new SimpleThreadConnect(inet);
        try {
            stc.start();
            stc.join(this.arrayMaxWait);
        }
        catch (InterruptedException e) {
            Trace.error((Object)this, "connectFromThread", "Interupted connecting to ip:" + ip);
            return null;
        }
        if (!stc.isDone()) {
            Trace.verbose((Object)this, "connectFromThread", "thread not done, kill");
            stc.interrupt();
        }
        if (!stc.isConnected()) {
            Trace.verbose((Object)this, "connectFromThread", "Could not connect within 5 seconds - not a valid IP");
            return null;
        }
        this.sym = stc.getSym();
        if (this.sym == null) {
            Trace.verbose((Object)this, "connectFromThread", "SYM is null? - should not happen");
            return null;
        }
        return this.sym;
    }

    public String getAlternateControllerIP(String notThisController, ObjectBundle bundle) {
        String methodName = "getAlternateController";
        String contrRef = notThisController;
        String contrIP = null;
        Controller[] c = bundle.getController();
        if (c != null) {
            for (int i = 0; i < c.length; ++i) {
                contrRef = Convert.bytesToString(c[i].getControllerRef().getRefToken());
                if (contrRef.equals(notThisController)) continue;
                contrIP = this.getIPFromController(c[i]);
                this.connectedToController = contrRef;
                break;
            }
        }
        return contrIP;
    }

    public SYMbolAPIClientV1 getClient(String[] allIPs, String ip) throws RPCError, IOException, ConfigMgmtException {
        int i;
        String methodName = "getClient";
        Trace.methodBegin(this, "getClient");
        boolean connected = false;
        SYMbolAPIClientV1 sym = null;
        boolean controllerAccessible = false;
        Trace.verbose((Object)this, "getClient", "Attempt direct connection to this IP");
        sym = this.connectFromThread(ip);
        if (sym == null) {
            Trace.verbose((Object)this, "getClient", "Failed connecting to specified IP, check if it is registered.");
            for (i = 0; i < allIPs.length && !controllerAccessible; ++i) {
                Trace.verbose((Object)this, "getClient", "Registered IP:" + allIPs[i]);
                if (!ip.equals(allIPs[i])) continue;
                Trace.verbose((Object)this, "getClient", "Found ip in list of registrations");
                controllerAccessible = true;
            }
            if (controllerAccessible) {
                Trace.error((Object)this, "getClient", "Could not connect to ip although it is registered (return null):" + ip);
                throw new ConfigMgmtException(ErrorCode.ERROR_COMMUNICATING_WITH_ARRAY.getKey(), "Could not connect to ip:" + ip);
            }
            Trace.warn((Object)this, "getClient", "Could not connect to the controller IP address and could not find that IP address in the registration list:" + ip);
            Trace.warn((Object)this, "getClient", "If force connection to IP is set, connection may be invalid. ");
        } else {
            connected = true;
        }
        for (i = 0; i < allIPs.length && !connected; ++i) {
            sym = this.connectFromThread(allIPs[i]);
            if (sym == null) {
                Trace.verbose((Object)this, "getClient", "Could not connect to ip:" + allIPs[i]);
                continue;
            }
            DiscoveryResponse dr = sym.discoverControllers();
            if (dr.getResponseFromAgent()) {
                connected = this.processAgentResponse(this.connectedToController, connected, sym, dr);
            } else {
                connected = true;
                this.connectedToController = Convert.bytesToString(dr.getControllers()[0].getThisController().getRefToken());
                this.connectedToIp = allIPs[i];
            }
            if (connected || sym == null) continue;
            try {
                sym.close();
                sym = null;
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (!connected) {
            throw new ConfigMgmtException(ErrorCode.ERROR_COMMUNICATING_WITH_ARRAY.getKey(), "");
        }
        Trace.verbose((Object)this, "getClient", "Done connected to IP:" + sym.getDestinationIP().getHostAddress());
        return sym;
    }

    private void bindToController(SYMbolAPIClientV1 sym, Controller[] cons, int x) throws RPCError, IOException {
        ControllerDescriptor cd = new ControllerDescriptor();
        cd.setControllerRef(cons[x].getControllerRef());
        SAIdentifier said = sym.getSAData().getSaId();
        cd.setSaId(said);
        sym.bindToController(cd);
    }

    private boolean processAgentResponse(String controllerRef, boolean connected, SYMbolAPIClientV1 sym, DiscoveryResponse dr) throws RPCError, IOException {
        AccessibleController[] acs = dr.getControllers();
        int sz = acs == null ? 0 : acs.length;
        for (int x = 0; x < sz && !connected; ++x) {
            ControllerRef cr = acs[x].getThisController();
            SAIdentifier said = acs[x].getSaId();
            if (said.getWorldWideName() == null || !Convert.bytesToString(said.getWorldWideName()).equalsIgnoreCase(this.arrayId) || controllerRef != null && !Convert.bytesToString(cr.getRefToken()).equals(controllerRef)) continue;
            ControllerDescriptor cd = new ControllerDescriptor();
            cd.setControllerRef(cr);
            cd.setSaId(said);
            sym.bindToController(cd);
            connected = true;
        }
        return connected;
    }

    private String getIPFromController(Controller controller) {
        String ip = null;
        NetInterfaceTypeData[] netData = controller.getNetInterfaces();
        for (int i = 0; i < netData.length && ip == null; ++i) {
            if (netData[i].getInterfaceType().getValue() != 1) continue;
            ip = Convert.getIpStrFromInt(netData[i].getEthernet().getIp());
        }
        return ip;
    }

    public SYMbolAPIClientV1 authorize() throws IOException, RPCError {
        String methodName = "authorize";
        this.lastConfigGenNumber = this.getCurrentConfigNumber();
        Trace.verbose((Object)this, "authorize", "got config number");
        this.sym.setTimeout(0);
        SYMbolAuthGenerator symbolAuthGenerator = new SYMbolAuthGenerator(this.sym.getLocalAddress(), this.sym.getSAData().getSaId());
        Trace.verbose((Object)this, "authorize", "got generator");
        symbolAuthGenerator.setConfigGeneration(this.lastConfigGenNumber);
        symbolAuthGenerator.setPassword(this.password);
        Trace.verbose((Object)this, "authorize", "set auth gen");
        this.sym.setAuthGenerator((RPCAuthGenerator)symbolAuthGenerator);
        Trace.verbose((Object)this, "authorize", "Done");
        return this.sym;
    }

    private long getCurrentConfigNumber() throws IOException, RPCError {
        String methodName = "getCurrentConfigNumber";
        ChangeQueryDescriptor chgQuery = new ChangeQueryDescriptor();
        chgQuery.getLastKnown().setConfigGeneration(this.lastConfigGenNumber);
        chgQuery.getLastKnown().setLastCriticalMelSeqNumber(this.latestCriticalMel);
        chgQuery.setMaxWait(0);
        this.sym.setTimeout(10);
        Trace.verbose((Object)this, "getCurrentConfigNumber", "GetChangeState");
        ChangeState chgState = this.sym.getChangeState(chgQuery);
        Trace.verbose((Object)this, "getCurrentConfigNumber", "got state");
        this.latestCriticalMel = chgState.getLastCriticalMelSeqNumber();
        return chgState.getConfigGeneration();
    }

    public int getListId() {
        return this.listId;
    }

    public void setListId(int ind) {
        this.listId = ind;
    }

    class SimpleThreadConnect
    extends Thread {
        boolean isDone;
        boolean isConnected = false;
        InetAddress arrayIP;
        SYMbolAPIClientV1 sym = null;

        public SimpleThreadConnect(InetAddress ip) {
            this.arrayIP = ip;
        }

        public void run() {
            try {
                Trace.verbose((Object)this, "run", "Attempt connection to ip:" + this.arrayIP.getHostAddress());
                this.sym = new SYMbolAPIClientV1(this.arrayIP, 2463, true);
                Trace.verbose((Object)this, "run", "Connected!");
                this.isConnected = true;
            }
            catch (Exception e) {
                Trace.error((Object)this, (Throwable)e);
            }
            this.isDone = true;
        }

        public boolean isConnected() {
            return this.isConnected;
        }

        public boolean isDone() {
            return this.isDone;
        }

        public SYMbolAPIClientV1 getSym() {
            return this.sym;
        }
    }
}

