/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.core.impl.mr3;

import com.sun.netstorage.array.mgmt.cfg.core.CIMOMHandleWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.StorageHealthInterface;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.impl.mr3.PhysicalPackageKeyBuilder;
import java.util.Vector;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.UnsignedInt16;

public class StorageHealth
implements StorageHealthInterface {
    private ConfigContext context;
    private CIMOMHandleWrapper client;
    private int state;
    private int downCount;
    private int criticalCount;
    private int majorCount;
    private int minorCount;
    private CIMInstance instance;
    public static final String[] PROPERTY_NAMES = new String[]{"OperationalStatus", "Tag", "CreationClassName", "DownCount", "CriticalCount", "MajorCount", "MinorCount"};

    public void init(ConfigContext context) throws ConfigMgmtException {
        Trace.methodBegin(this, "init");
        this.context = context;
        this.client = context.getClient();
        PhysicalPackageKeyBuilder ppkb = new PhysicalPackageKeyBuilder();
        this.instance = ppkb.newInstance(this.client, PROPERTY_NAMES);
        Trace.verbose((Object)this, "init", "The instance we've got is: " + this.instance);
        this.setCurrentState();
        this.setCounts();
    }

    public int getCurrentState() {
        return this.state;
    }

    public int getDownCount() {
        return this.downCount;
    }

    public int getCriticalCount() {
        return this.criticalCount;
    }

    public int getMajorCount() {
        return this.majorCount;
    }

    public int getMinorCount() {
        return this.minorCount;
    }

    public void reload() throws ConfigMgmtException {
        Trace.methodBegin(this, "reload");
        if (this.instance != null) {
            try {
                Trace.verbose((Object)this, "reload", "Instance's CIMObjectPath is: " + this.instance.getObjectPath());
                CIMInstance ci = this.client.getInstance(this.instance.getObjectPath(), false, true, false, PROPERTY_NAMES);
                Trace.verbose((Object)this, "reload", "Fresh CIMInstance we've got: " + ci);
                this.instance = ci;
                this.setCurrentState();
                this.setCounts();
            }
            catch (ConfigMgmtException cme) {
                Trace.error((Object)this, "reload", "Failed: " + cme.getMessage());
                throw cme;
            }
        } else {
            Trace.verbose((Object)this, "reload", "CIMInstance instance member variable not initialized.");
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "CIMInstance instance member variable not initialized.");
        }
    }

    private void setCurrentState() throws ConfigMgmtException {
        Trace.methodBegin(this, "setCurrentState");
        try {
            Vector operationalStatus = (Vector)this.instance.getProperty(PROPERTY_NAMES[0]).getValue().getValue();
            this.state = ((UnsignedInt16)operationalStatus.get(0)).intValue();
            Trace.verbose((Object)this, "setCurrentState", "State is: " + this.state);
        }
        catch (NullPointerException npe) {
            Trace.verbose((Object)this, "setCurrentState", "NullPointerException - When trying to get the overall StorageHealth value.");
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "Problems trying to get overall StorageHealth value.", npe);
        }
    }

    private void setCounts() throws ConfigMgmtException {
        Trace.methodBegin(this, "setCounts");
        try {
            UnsignedInt16 down = (UnsignedInt16)this.instance.getProperty("DownCount").getValue().getValue();
            this.downCount = down.intValue();
            Trace.verbose((Object)this, "setCounts", "Down error count is: " + this.downCount);
            UnsignedInt16 critical = (UnsignedInt16)this.instance.getProperty("CriticalCount").getValue().getValue();
            this.criticalCount = critical.intValue();
            Trace.verbose((Object)this, "setCounts", "Critical error count is: " + this.criticalCount);
            UnsignedInt16 major = (UnsignedInt16)this.instance.getProperty("MajorCount").getValue().getValue();
            this.majorCount = major.intValue();
            Trace.verbose((Object)this, "setCounts", "Major error count is: " + this.majorCount);
            UnsignedInt16 minor = (UnsignedInt16)this.instance.getProperty("MinorCount").getValue().getValue();
            this.minorCount = minor.intValue();
            Trace.verbose((Object)this, "setCounts", "Minor error count is: " + this.minorCount);
        }
        catch (NullPointerException npe) {
            Trace.verbose((Object)this, "setCounts", "NullPointerException - When trying to get the error counts.");
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "Problems trying to get error counts.", npe);
        }
    }
}

