/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.core.impl.mr3;

import com.sun.netstorage.array.mgmt.cfg.core.CIMOMHandleWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.ProductInfoInterface;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.impl.CIMObjectWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.impl.MapElement;
import com.sun.netstorage.array.mgmt.cfg.core.impl.mr3.PhysicalPackageKeyBuilder;
import com.sun.netstorage.array.mgmt.cfg.core.impl.mr3.StorageHealth;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import javax.wbem.cim.CIMInstance;

public class ProductInfo
implements ProductInfoInterface {
    private ConfigContext context;
    private CIMOMHandleWrapper handle;
    private String name;
    private String idNumber;
    private CIMInstance productInstance;
    private ArrayList fieldMap;
    public static final String[] PROPERTY_NAMES = new String[]{"Name", "IdentifyingNumber", "Version", "Vendor"};

    public void init(ConfigContext context) throws ConfigMgmtException {
        Trace.methodBegin(this, "init");
        this.context = context;
        this.handle = context.getClient();
        this.productInstance = this.newInstance(this.handle, PROPERTY_NAMES);
        CIMObjectWrapper.populate(this, this.getFieldMap(), this.productInstance);
        Trace.verbose((Object)this, "init", this.toString());
    }

    public CIMInstance newInstance(CIMOMHandleWrapper handle, String[] propertyNames) throws ConfigMgmtException {
        Trace.methodBegin(this, "newInstance");
        try {
            Trace.verbose((Object)this, "newInstance", "Trying to get PhysicalPackage CIMObjectPath...");
            PhysicalPackageKeyBuilder ppkb = new PhysicalPackageKeyBuilder();
            CIMInstance ppInstance = ppkb.singleton(handle, StorageHealth.PROPERTY_NAMES);
            Enumeration e = handle.associators(ppInstance.getObjectPath(), "SunStorEdge_6x20ProductPhysicalElements", "SunStorEdge_6x20Product", "Component", "Product", true, false, propertyNames);
            Trace.verbose((Object)this, "newInstance", "Came back from CIMOM.");
            while (e.hasMoreElements()) {
                Object o = e.nextElement();
                if (!(o instanceof CIMInstance)) continue;
                Trace.verbose((Object)this, "newInstance", "We got the Product instance.");
                return (CIMInstance)o;
            }
            Trace.verbose((Object)this, "newInstance", "No instance returned for Product class.");
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "No instance returned for Product class in ProductInfo.");
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "newInstance", "Failed: " + cme.getMessage());
            throw cme;
        }
    }

    public String getName() {
        return this.name;
    }

    public String getIdNumber() {
        return this.idNumber;
    }

    public void setIdNumber(String idNumber) {
        this.idNumber = idNumber;
    }

    public void setName(String name) {
        this.name = name;
    }

    protected Collection getFieldMap() {
        Trace.methodBegin(this, "getFieldMap");
        if (null == this.fieldMap) {
            this.fieldMap = new ArrayList();
            this.fieldMap.add(new MapElement("name", "Name", true, false));
            this.fieldMap.add(new MapElement("idNumber", "IdentifyingNumber", true, false));
        }
        return this.fieldMap;
    }

    public String toString() {
        String thisObject = "ProductInfo with:";
        thisObject = thisObject + "\n CIMInstance: " + this.productInstance;
        thisObject = thisObject + "\n name: " + this.name;
        thisObject = thisObject + "\n idNumber: " + this.idNumber;
        return thisObject;
    }

    public void reload() throws ConfigMgmtException {
        Trace.methodBegin(this, "reload");
        if (this.productInstance != null) {
            try {
                Trace.verbose((Object)this, "reload", "Instance's CIMObjectPath is: " + this.productInstance.getObjectPath());
                CIMInstance ci = this.handle.getInstance(this.productInstance.getObjectPath(), false, true, false, PROPERTY_NAMES);
                Trace.verbose((Object)this, "reload", "Fresh CIMInstance we've got: " + ci);
                this.productInstance = ci;
                CIMObjectWrapper.populate(this, this.getFieldMap(), this.productInstance);
            }
            catch (ConfigMgmtException cme) {
                Trace.error((Object)this, "reload", "Failed: " + cme.getMessage());
                throw cme;
            }
        } else {
            Trace.verbose((Object)this, "reload", "CIMInstance instance member variable not initialized.");
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "CIMInstance instance member variable not initialized.");
        }
    }
}

