/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.core.impl;

import com.sun.netstorage.array.mgmt.cfg.core.ErrorCode;
import com.sun.netstorage.array.mgmt.cfg.core.ErrorCodeType;
import com.sun.netstorage.array.mgmt.cfg.core.ErrorDescriptor;
import com.sun.netstorage.array.mgmt.cfg.core.MethodCallStatus;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.SEItemNotFoundException;
import com.sun.netstorage.array.mgmt.cfg.core.impl.ArrayReg;
import com.sun.netstorage.array.mgmt.cfg.core.impl.StoradeProxy;
import com.sun.netstorage.array.mgmt.cfg.core.ini.Repository;
import com.sun.netstorage.array.mgmt.cfg.util.CryptoUtility;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ArrayRegManager {
    public static final String REG_FILE = "array-reg-file";
    private static String DEFAULT_REG_FILE = "/var/opt/SUNWse6130ui/local_data/array_registration.xml";
    private static final String XML_ARRAY_NODE = "array";
    private static final String XML_ARRAY_WWN = "wwn";
    private static final String XML_ARRAY_TYPE = "type";
    private static final String XML_ARRAY_PASSWORD = "password";
    private static final String XML_ARRAY_IP = "ip";
    private static final String XML_DATA = "data";
    private static final String DEPRECATED_ARRAY_TYPE = "OZ";
    private static final String XML_ARRAY_REG_KEY = "registrationEntryKey";
    private Map registeredArrays;
    private Map arrayByWWN;
    private List allRegisteredArrayWWNs;
    private static ArrayRegManager _instance;
    private boolean useStorade = false;

    private ArrayRegManager() {
        if (Repository.getRepository().getProperty("STORADE_SWITCH") != null && "true".equals((String)Repository.getRepository().getProperty("STORADE_SWITCH"))) {
            this.useStorade = true;
        }
        this.loadRegistrationData();
    }

    public static synchronized ArrayRegManager getInstance() {
        if (_instance == null) {
            _instance = new ArrayRegManager();
        }
        return _instance;
    }

    public void loadRegistrationData() {
        block4: {
            block3: {
                String methodName = "loadRegistrationData";
                Trace.methodBegin(this, "loadRegistrationData");
                this.registeredArrays = new HashMap();
                this.allRegisteredArrayWWNs = new ArrayList();
                this.arrayByWWN = new HashMap();
                if (this.useStorade) break block3;
                Document document = this.getRegistrationDocument();
                if (document == null) break block4;
                Element root = document.getDocumentElement();
                NodeList arrayNodes = root.getElementsByTagName(XML_ARRAY_NODE);
                int size = arrayNodes == null ? 0 : arrayNodes.getLength();
                for (int i = 0; i < size; ++i) {
                    Element arrayEl = (Element)arrayNodes.item(i);
                    this.addArrayReg(arrayEl);
                }
                break block4;
            }
            Trace.verbose((Object)this, "loadRegistrationData", "Get registration data for local cache from StorADE");
            try {
                this.loadRegsFromStorADE();
            }
            catch (ConfigMgmtException e) {
                Trace.error((Object)this, "loadRegistrationData", "Error loading registratiooons from StorADE");
                Trace.error((Object)this, "loadRegistrationData", e);
            }
        }
    }

    private void loadRegsFromStorADE() throws ConfigMgmtException {
        String methodName = "loadRegsFromStorADE";
        Trace.methodBegin(this, "loadRegsFromStorADE");
        List arrayReg = StoradeProxy.getArrayRegistrations("6130");
        if (arrayReg != null) {
            Trace.verbose((Object)this, "loadRegsFromStorADE", "Got data from storade:" + arrayReg.size());
            int sz = arrayReg.size();
            for (int i = 0; i < sz; ++i) {
                ArrayList<ArrayReg> regs;
                ArrayReg ar = (ArrayReg)arrayReg.get(i);
                if (Trace.isTraceEnabled(this)) {
                    Trace.verbose((Object)this, "loadRegsFromStorADE", "Registration entry obtained:" + ar);
                }
                if ((regs = (ArrayList<ArrayReg>)this.registeredArrays.get(ar.type)) == null) {
                    regs = new ArrayList<ArrayReg>();
                }
                regs.add(ar);
                if (ar.wwn != null) {
                    this.allRegisteredArrayWWNs.add(ar.wwn.toUpperCase());
                    this.arrayByWWN.put(ar.wwn.toUpperCase(), ar);
                }
                this.registeredArrays.put(ar.type, regs);
            }
        }
        if (Trace.isTraceEnabled(this)) {
            Trace.verbose((Object)this, "loadRegsFromStorADE", "Total number of cached entries:" + this.registeredArrays.size());
        }
        Trace.verbose((Object)this, "loadRegsFromStorADE", "Data cached");
    }

    private Document getRegistrationDocument() {
        String regFile = (String)Repository.getRepository().getProperty(REG_FILE);
        if (regFile == null) {
            regFile = DEFAULT_REG_FILE;
        }
        Trace.verbose((Object)this, "getRegistrationDocument", "read file");
        File file = new File(regFile);
        try {
            if (!file.exists()) {
                Trace.verbose((Object)this, "getRegistrationDoc", "No file - create it");
                file.createNewFile();
                Trace.verbose((Object)this, "getRegistrationDocument", "New file created");
                FileWriter fw = new FileWriter(file, true);
                fw.write("<data>\n</data>\n");
                fw.flush();
                file = new File(regFile);
            }
        }
        catch (IOException e1) {
            Trace.error((Object)this, (Throwable)e1);
        }
        Trace.verbose((Object)this, "getRegostrationDocument", "Parse file");
        DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
        Document document = null;
        try {
            DocumentBuilder builder = dbfactory.newDocumentBuilder();
            document = builder.parse(file);
        }
        catch (ParserConfigurationException e) {
            Trace.error((Object)this, (Throwable)e);
        }
        catch (SAXException e) {
            Trace.error((Object)this, (Throwable)e);
        }
        catch (IOException e) {
            Trace.error((Object)this, (Throwable)e);
        }
        return document;
    }

    private void addArrayReg(Element arrayEl) {
        NodeList ips;
        int num;
        ArrayReg a = new ArrayReg();
        a.type = arrayEl.getAttribute(XML_ARRAY_TYPE);
        if (a.type.equals(DEPRECATED_ARRAY_TYPE)) {
            a.type = "6130";
        }
        int n = num = (ips = arrayEl.getElementsByTagName(XML_ARRAY_IP)) == null ? 0 : ips.getLength();
        if (num > 0) {
            a.ips = new String[num];
            for (int i = 0; i < num; ++i) {
                a.ips[i] = ((Element)ips.item(i)).getFirstChild().getNodeValue();
                Trace.verbose((Object)this, "addArrayReg", "Registering IP:" + a.ips[i]);
            }
        }
        a.wwn = arrayEl.getAttribute(XML_ARRAY_WWN);
        if (a.wwn == null || a.wwn.trim().equals("")) {
            Trace.error((Object)this, "addArrayReg", "WWN not found as an attribute of array registration - remove and add this array registration:" + a.ips[0]);
            ArrayList<String> l = new ArrayList<String>(1);
            l.add(a.ips[0]);
            this.removeRegistration(l);
            Trace.error((Object)this, "addArrayReg", "Invalid registration removed.");
            return;
        }
        a.wwn = a.wwn.toUpperCase();
        Trace.verbose((Object)this, "addArrayReg", "Array wwn = " + a.wwn);
        a.registrationEntryKey = arrayEl.getAttribute(XML_ARRAY_REG_KEY);
        if (a.registrationEntryKey == null || a.registrationEntryKey.trim().equals("")) {
            Trace.error((Object)this, "addArrayReg", "registrationEntryKey not found as an attribute of array registration - remove and add this array registration:" + a.ips[0]);
            ArrayList<String> l = new ArrayList<String>(1);
            l.add(a.ips[0]);
            this.removeRegistration(l);
            Trace.error((Object)this, "addArrayReg", "Invalid registration removed.");
            return;
        }
        Trace.verbose((Object)this, "addArrayReg", "Array registrationEntryKey = " + a.registrationEntryKey);
        a.password = this.decryptPassword(arrayEl.getAttribute(XML_ARRAY_PASSWORD));
        ArrayList<ArrayReg> regs = (ArrayList<ArrayReg>)this.registeredArrays.get(a.type);
        if (regs == null) {
            regs = new ArrayList<ArrayReg>();
        }
        regs.add(a);
        if (a.wwn != null) {
            this.allRegisteredArrayWWNs.add(a.wwn.toUpperCase());
            this.arrayByWWN.put(a.wwn.toUpperCase(), a);
        }
        this.registeredArrays.put(a.type, regs);
    }

    private String decryptPassword(String encPass) {
        if (encPass == null || encPass.trim().equals("")) {
            return encPass;
        }
        String[] r = encPass.split("\\%");
        byte[] b = new byte[r.length];
        BigInteger y = new BigInteger("4294967296");
        for (int i = 0; i < r.length; ++i) {
            if (r[i].length() > 2) {
                BigInteger x = new BigInteger(r[i], 16);
                r[i] = x.subtract(y).toString();
                b[i] = x.byteValue();
                continue;
            }
            b[i] = (byte)Integer.parseInt(r[i], 16);
        }
        byte[] retrieved = null;
        try {
            retrieved = CryptoUtility.doEncryption(1, b);
        }
        catch (Exception e) {
            Trace.error((Object)this, "decryptPassword", "failed to decrypt password");
            Trace.error((Object)this, (Throwable)e);
        }
        return new String(retrieved);
    }

    public ArrayReg getArrayRegistration(String[] ips) {
        ArrayReg reg = null;
        Collection regLists = this.registeredArrays.values();
        Iterator it = regLists.iterator();
        while (it.hasNext() && reg == null) {
            List l = (List)it.next();
            reg = this.findRegInList(l, ips);
        }
        return reg;
    }

    public synchronized ArrayReg getArrayRegistration(String wwn) {
        if (wwn == null) {
            return null;
        }
        return (ArrayReg)this.arrayByWWN.get(wwn.toUpperCase());
    }

    public ArrayReg getArrayRegistration(String[] ips, String type) {
        ArrayReg reg = null;
        reg = this.findRegInList(this.getRegisteredArrays(type), ips);
        return reg;
    }

    public synchronized List getRegisteredArrays(String arrayType) {
        String methodName = "getRegisteredArrays";
        ArrayList ra = null;
        if (this.useStorade) {
            Trace.verbose((Object)this, "getRegisteredArrays", "Refresh the cache from StorADE");
            this.loadRegistrationData();
        }
        if ((ra = (ArrayList)this.registeredArrays.get(arrayType)) == null) {
            ra = new ArrayList(0);
        }
        return ra;
    }

    public synchronized Map getAllRegisteredArrays() {
        String methodName = "getAllRegisteredArrays";
        if (this.useStorade) {
            Trace.verbose((Object)this, "getAllRegisteredArrays", "Refresh the cache from StorADE");
            this.loadRegistrationData();
        }
        return this.registeredArrays;
    }

    public boolean isRegistered(InetAddress inet, String type) {
        boolean isReg = false;
        List lt = this.getRegisteredArrays(type);
        int size = lt == null ? 0 : lt.size();
        String ip = inet.getHostAddress();
        for (int i = 0; i < size && !isReg; ++i) {
            ArrayReg tmp = (ArrayReg)lt.get(i);
            int sz = tmp.ips == null ? 0 : tmp.ips.length;
            for (int j = 0; j < sz && !isReg; ++j) {
                if (tmp.ips[j] == null || !tmp.ips[j].equals(ip)) continue;
                Trace.verbose((Object)this, "isRegistered", "IT is registered");
                isReg = true;
            }
        }
        return isReg;
    }

    public boolean isRegistered(String arrayWWN) {
        if (arrayWWN == null) {
            return false;
        }
        return this.allRegisteredArrayWWNs.contains(arrayWWN.toUpperCase());
    }

    private ArrayReg findRegInList(Collection arList, String[] ips) {
        int size;
        ArrayReg reg = null;
        int n = size = arList == null ? 0 : arList.size();
        if (ips == null) {
            return null;
        }
        ArrayList<String> inIps = new ArrayList<String>();
        for (int i = 0; i < ips.length; ++i) {
            inIps.add(ips[i]);
        }
        boolean found = false;
        Iterator it = arList.iterator();
        while (it.hasNext() && !found) {
            ArrayReg tmp = (ArrayReg)it.next();
            if (tmp.ips == null) continue;
            for (int i = 0; i < tmp.ips.length && !found; ++i) {
                if (!inIps.contains(tmp.ips[i])) continue;
                found = true;
                reg = tmp;
                Trace.verbose((Object)this, "findRegInList", "Found registration!");
            }
        }
        return reg;
    }

    public MethodCallStatus registerArrays(Collection l) {
        String methodName = "registerArrays";
        MethodCallStatus mcs = new MethodCallStatus();
        if (l == null) {
            ErrorDescriptor ed = new ErrorDescriptor(ErrorCode.EMPTY_LIST);
            mcs.addErrorDescriptor(ed);
            return mcs;
        }
        Trace.methodBegin(this, "registerArrays");
        ArrayList registrationCandidates = new ArrayList(l);
        if (Trace.isTraceEnabled(this)) {
            for (int i = 0; i < registrationCandidates.size(); ++i) {
                ArrayReg ar = (ArrayReg)registrationCandidates.get(i);
                Trace.verbose((Object)this, "registerArrays", "New registration for wwn:" + ar.wwn);
            }
        }
        if (this.useStorade) {
            this.registerWithStorade(registrationCandidates, mcs);
        } else {
            this.registerLocaly(registrationCandidates);
        }
        this.loadRegistrationData();
        return mcs;
    }

    private void registerWithStorade(List regCandidates, MethodCallStatus mcs) {
        String methodName = "registerWithStorade";
        Trace.methodBegin(this, "registerWithStorade");
        int sz = regCandidates == null ? 0 : regCandidates.size();
        for (int i = 0; i < sz; ++i) {
            ArrayReg ar = (ArrayReg)regCandidates.get(i);
            if (Trace.isTraceEnabled(this)) {
                Trace.verbose((Object)this, "registerWithStorade", "Adding registration for:" + ar);
            }
            try {
                StoradeProxy.addRegistration(ar);
                continue;
            }
            catch (ConfigMgmtException e) {
                Trace.error((Object)this, "registerWithStorade", "Error adding registration to storade");
                Trace.error((Object)this, "registerWithStorade", "registration data:" + ar);
                Trace.error((Object)this, "registerWithStorade", e);
                ErrorDescriptor ed = new ErrorDescriptor(new ErrorCode(e.getExceptionKey(), ErrorCode.ERROR_STORADE_GENERAL.getErrorCode(), ErrorCodeType.ERROR));
                ed.setMsg(e.getExceptionMsg());
                ed.setI18nParams(new String[]{ar.ips[0]});
                mcs.addErrorDescriptor(ed);
            }
        }
    }

    private void registerLocaly(ArrayList registrationCandidates) {
        String methodName = "registerLocaly";
        Trace.methodBegin(this, "registerLocaly");
        Document document = this.getRegistrationDocument();
        Element root = null;
        if (document != null) {
            int i;
            root = document.getDocumentElement();
            List allregIPS = this.getAllRegIPs(root);
            NodeList arrayNodes = root.getElementsByTagName(XML_ARRAY_NODE);
            int sz = arrayNodes == null ? 0 : arrayNodes.getLength();
            for (i = 0; i < sz; ++i) {
                Element el = (Element)arrayNodes.item(i);
                String wwn = el.getAttribute(XML_ARRAY_WWN);
                Trace.verbose((Object)this, "registerLocaly", "Check if we need to update wwn:" + wwn);
                int sz1 = registrationCandidates.size();
                boolean found = false;
                for (int x = 0; x < sz1 && !found; ++x) {
                    ArrayReg ar = (ArrayReg)registrationCandidates.get(x);
                    String canWwn = ar.wwn;
                    if (!wwn.equalsIgnoreCase(canWwn)) continue;
                    Trace.verbose((Object)this, "registerLocaly", "Update registration for wwn:" + wwn);
                    int sz2 = ar.ips == null ? 0 : ar.ips.length;
                    for (int y = 0; y < sz2 && !found; ++y) {
                        if (allregIPS != null && allregIPS.contains(ar.ips[y])) continue;
                        Trace.verbose((Object)this, "registerLocaly", "Add ip:" + ar.ips[y]);
                        this.addIPNode(document, ar.ips[y], el);
                    }
                    found = true;
                    registrationCandidates.remove(x);
                }
            }
            sz = registrationCandidates == null ? 0 : registrationCandidates.size();
            for (i = 0; i < sz; ++i) {
                ArrayReg ar = (ArrayReg)registrationCandidates.get(i);
                Element newArReg = document.createElement(XML_ARRAY_NODE);
                newArReg.setAttribute(XML_ARRAY_TYPE, ar.type);
                newArReg.setAttribute(XML_ARRAY_WWN, ar.wwn);
                newArReg.setAttribute(XML_ARRAY_REG_KEY, ar.registrationEntryKey);
                String encPass = this.encryptPassword(ar.password);
                newArReg.setAttribute(XML_ARRAY_PASSWORD, encPass);
                for (int j = 0; j < ar.ips.length; ++j) {
                    if (ar.ips[j] == null) continue;
                    this.addIPNode(document, ar.ips[j], newArReg);
                }
                root.appendChild(newArReg);
            }
        }
        this.saveDocument(root);
    }

    public MethodCallStatus removeRegistration(List wwnList) {
        MethodCallStatus mcs = new MethodCallStatus();
        mcs.setReturnCode(ErrorCode.SUCCESS.getErrorCode());
        if (wwnList == null || wwnList.isEmpty()) {
            mcs.addErrorDescriptor(new ErrorDescriptor(ErrorCode.EMPTY_LIST));
        } else {
            if (this.useStorade) {
                this.removeFromStorade(wwnList, mcs);
            } else {
                this.removeLocaly(wwnList, mcs);
            }
            this.loadRegistrationData();
        }
        return mcs;
    }

    private void removeFromStorade(List wwnList, MethodCallStatus mcs) {
        String methodName = "removeFromStorade";
        Trace.methodBegin(this, "removeFromStorade");
        int sz = wwnList == null ? 0 : wwnList.size();
        this.loadRegistrationData();
        for (int i = 0; i < sz; ++i) {
            String wwn = (String)wwnList.get(i);
            ArrayReg ar = this.getArrayRegistration(wwn);
            if (ar != null) {
                if (Trace.isTraceEnabled(this)) {
                    Trace.verbose((Object)this, "removeFromStorade", "Remove registration:" + ar);
                }
                try {
                    StoradeProxy.removeRegistration(ar);
                }
                catch (ConfigMgmtException e) {
                    Trace.error((Object)this, "removeFromStorade", "Error removing registration:" + ar);
                    Trace.error((Object)this, "removeFromStorade", e);
                    ErrorDescriptor ed = new ErrorDescriptor(ErrorCode.ERROR_STORADE_GENERAL);
                    ed.setI18nParams(new String[]{wwn});
                    mcs.addErrorDescriptor(ed);
                }
                continue;
            }
            ErrorDescriptor ed = new ErrorDescriptor(ErrorCode.ITEM_NOT_FOUND);
            ed.setI18nParams(new String[]{wwn});
            mcs.addErrorDescriptor(ed);
        }
    }

    private void removeLocaly(List wwnList, MethodCallStatus mcs) {
        NodeList nl;
        Document document = this.getRegistrationDocument();
        Element root = null;
        if (document != null) {
            root = document.getDocumentElement();
        }
        if (Trace.isTraceEnabled(this)) {
            for (int i = 0; i < wwnList.size(); ++i) {
                Trace.verbose((Object)this, "removeRegistration", "WWN to remove:" + wwnList.get(i));
            }
        }
        int size = (nl = root.getElementsByTagName(XML_ARRAY_NODE)) == null ? 0 : nl.getLength();
        for (int i = 0; i < size; ++i) {
            Element el = (Element)nl.item(i);
            if (el == null) continue;
            String wwn = el.getAttribute(XML_ARRAY_WWN).toUpperCase();
            Trace.verbose((Object)this, "removeRegistration", "Is this wwn in list:" + wwn);
            if (wwnList.contains(wwn)) {
                Trace.verbose((Object)this, "removeRegistration", "wwn Found");
                root.removeChild(el);
                --i;
                --size;
                continue;
            }
            Trace.verbose((Object)this, "removeRegistration", "Not in list");
        }
        this.saveDocument(root);
    }

    public void updateRegistration(ArrayReg ar) throws SEItemNotFoundException, ConfigMgmtException {
        if (ar == null || ar.wwn == null || ar.ips == null || ar.ips.length == 0 || ar.ips[0] == null) {
            throw new SEItemNotFoundException("null");
        }
        if (!this.useStorade) {
            NodeList nl;
            Document document = this.getRegistrationDocument();
            Element root = null;
            if (document != null) {
                root = document.getDocumentElement();
            }
            int size = (nl = root.getElementsByTagName(XML_ARRAY_NODE)) == null ? 0 : nl.getLength();
            boolean found = false;
            for (int i = 0; i < size && !found; ++i) {
                int x;
                String wwn;
                Element el = (Element)nl.item(i);
                if (el == null || !ar.wwn.equalsIgnoreCase(wwn = el.getAttribute(XML_ARRAY_WWN))) continue;
                Trace.verbose((Object)this, "updateRegistration", "wwn Found");
                found = true;
                NodeList nips = el.getElementsByTagName(XML_ARRAY_IP);
                int sz = nips == null ? 0 : nips.getLength();
                for (x = 0; x < sz; ++x) {
                    el.removeChild(nips.item(0));
                }
                for (x = 0; x < ar.ips.length; ++x) {
                    this.addIPNode(document, ar.ips[x], el);
                }
                el.setAttribute(XML_ARRAY_PASSWORD, this.encryptPassword(ar.password));
            }
            if (!found) {
                throw new SEItemNotFoundException(ar.wwn);
            }
            this.saveDocument(root);
            this.loadRegistrationData();
        } else {
            StoradeProxy.updateRegistration(ar);
        }
    }

    private String encryptPassword(String pass) {
        StringBuffer newPass = new StringBuffer("");
        try {
            byte[] newPassBytes = CryptoUtility.doEncryption(0, pass.getBytes());
            for (int i = 0; i < newPassBytes.length; ++i) {
                newPass.append(Integer.toHexString(newPassBytes[i])).append("%");
            }
        }
        catch (Exception e) {
            Trace.error((Object)this, "registerArrays", "Failed to encrypt password, password will not be stored");
            Trace.error((Object)this, (Throwable)e);
        }
        return newPass.toString();
    }

    private void addIPNode(Document document, String ip, Element parent) {
        Element ipEl = document.createElement(XML_ARRAY_IP);
        ipEl.appendChild(document.createTextNode(ip));
        parent.appendChild(ipEl);
    }

    private void saveDocument(Element root) {
        if (root != null) {
            String regFile;
            StringBuffer doc = new StringBuffer("");
            doc.append("<").append(XML_DATA).append(">\n");
            NodeList anl = root.getElementsByTagName(XML_ARRAY_NODE);
            int size = anl == null ? 0 : anl.getLength();
            Trace.verbose((Object)this, "saveDocument", "saving:" + size + " entries");
            for (int i = 0; i < size; ++i) {
                Element ael = (Element)anl.item(i);
                doc.append("  <").append(XML_ARRAY_NODE).append(" ");
                doc.append(XML_ARRAY_TYPE).append("=\"").append(ael.getAttribute(XML_ARRAY_TYPE));
                doc.append("\"\n\t ").append(XML_ARRAY_WWN).append("=\"").append(ael.getAttribute(XML_ARRAY_WWN).toUpperCase());
                doc.append("\"\n\t ").append(XML_ARRAY_PASSWORD).append("=\"").append(ael.getAttribute(XML_ARRAY_PASSWORD));
                doc.append("\"\n\t ").append(XML_ARRAY_REG_KEY).append("=\"").append(ael.getAttribute(XML_ARRAY_REG_KEY));
                doc.append("\" >\n");
                NodeList ips = ael.getElementsByTagName(XML_ARRAY_IP);
                for (int j = 0; j < ips.getLength(); ++j) {
                    doc.append("    <").append(XML_ARRAY_IP).append(">").append(((Element)ips.item(j)).getFirstChild().getNodeValue());
                    doc.append("</").append(XML_ARRAY_IP).append(">\n");
                }
                doc.append("  </").append(XML_ARRAY_NODE).append(">\n");
            }
            doc.append("</").append(XML_DATA).append(">\n");
            if (Trace.isTraceEnabled(this)) {
                Trace.verbose((Object)this, "saveDocument", doc.toString());
            }
            if ((regFile = (String)Repository.getRepository().getProperty(REG_FILE)) == null) {
                regFile = DEFAULT_REG_FILE;
            }
            try {
                File file = new File(regFile);
                FileWriter fw = new FileWriter(file, false);
                fw.write(doc.toString());
                fw.flush();
            }
            catch (IOException e) {
                Trace.error((Object)this, "saveDocument", (Throwable)e);
            }
        } else {
            Trace.error((Object)this, "saveDocument", "Nothing to save");
        }
    }

    private List getAllRegIPs(Element root) {
        ArrayList<String> allIPs = new ArrayList<String>();
        if (root != null) {
            NodeList ipNodes = root.getElementsByTagName(XML_ARRAY_IP);
            int size = ipNodes == null ? 0 : ipNodes.getLength();
            for (int i = 0; i < size; ++i) {
                allIPs.add(((Element)ipNodes.item(i)).getFirstChild().getNodeValue());
            }
        }
        return allIPs;
    }
}

