/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.core.exception;

import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.InvalidStorageArrayPassword;
import com.sun.netstorage.array.mgmt.cfg.core.exception.StorageArrayTimeoutException;
import javax.wbem.cim.CIMException;

public class CIMExceptionJudge {
    private Exception thrown = null;
    private ConfigMgmtException resultException = null;
    private boolean shouldRetry = false;
    private boolean needsNewCIMOMHandleWrapper = false;
    public static final String INVALID_STORAGE_ARRAY_PASSWORD_DESC = "Invalid HTTP credentials.";
    public static final String ARRAY_ALREADY_EXISTS_DESC = "Attempt to create duplicate array.";
    public static final String TIMEOUT_EXCEPTION_DESC = "Connection Timeout";

    public CIMExceptionJudge(int numTries, Exception thrown) {
        Trace.constructor(this);
        this.thrown = thrown;
        if (numTries < 4) {
            this.shouldRetry = true;
        }
        if (this.shouldRetry) {
            this.makeJudgement();
        } else {
            Trace.verbose((Object)this, "constructor", "Maximum attempts already tried. No retry.");
            this.resultException = new ConfigMgmtException(thrown);
        }
    }

    private void makeJudgement() {
        String METHOD = "makeJudgement";
        if (!(this.thrown instanceof CIMException)) {
            Trace.verbose((Object)this, "makeJudgement", "Questioned for non-CIMException.");
            this.shouldRetry = false;
            this.resultException = new ConfigMgmtException(this.thrown);
            return;
        }
        CIMException cime = (CIMException)((Object)this.thrown);
        String reason = cime.getID();
        if (reason == null) {
            Trace.verbose((Object)this, "makeJudgement", "Have null reason.");
            this.shouldRetry = false;
            this.resultException = new ConfigMgmtException((Exception)((Object)cime));
        } else if ("CIM_ERR_FAILED".equals(reason)) {
            String desc = cime.getDescription();
            if (INVALID_STORAGE_ARRAY_PASSWORD_DESC.equals(desc)) {
                Trace.verbose((Object)this, "makeJudgement", "Invalid Storage Array Password.");
                this.shouldRetry = false;
                this.resultException = new InvalidStorageArrayPassword("INVALID_STORAGE_ARRAY_PASSWORD_EXCEPTION", "Invalid storage array password.", (Exception)((Object)cime));
            } else if (ARRAY_ALREADY_EXISTS_DESC.equals(desc)) {
                Trace.verbose((Object)this, "makeJudgement", "Array with specified ip already exists.");
                this.shouldRetry = false;
                this.resultException = new ConfigMgmtException("array.already.exists", "Array already exists.", (Exception)((Object)cime));
            } else if (desc != null && desc.indexOf(TIMEOUT_EXCEPTION_DESC) > -1) {
                Trace.verbose((Object)this, "makeJudgement", "Timeout with Storage Array.");
                this.shouldRetry = false;
                this.resultException = new StorageArrayTimeoutException("STORAGE_ARRAY_TIMEOUT_EXCEPTION", "Connection time out with storage array", (Exception)((Object)cime));
            } else {
                Trace.verbose((Object)this, "makeJudgement", "Have CIMException with description: " + desc);
                this.shouldRetry = false;
                this.resultException = new ConfigMgmtException((Exception)((Object)cime));
            }
        } else if (reason.equals("CHECKSUM_ERROR") || reason.equals("NOT_HELLO") || reason.equals("NOT_RESPONSE") || reason.equals("RMIERROR")) {
            Trace.verbose((Object)this, "makeJudgement", "Need new CIMOMHandleWrapper after getting: " + reason);
            this.needsNewCIMOMHandleWrapper = true;
        } else if (reason.equals("CIM_ERR_ACCESS_DENIED")) {
            Trace.verbose((Object)this, "makeJudgement", "Not authorized to do this.");
            this.shouldRetry = false;
            this.resultException = new ConfigMgmtException("CIM_ERR_ACCESS_DENIED", "CIM_ERR_ACCESS_DENIED", (Exception)((Object)cime));
        } else {
            Trace.verbose((Object)this, "makeJudgement", "Not expected exception for re-trying, so will not retry.");
            this.shouldRetry = false;
            this.resultException = new ConfigMgmtException((Exception)((Object)cime));
        }
    }

    public boolean shouldRetry() {
        return this.shouldRetry;
    }

    public boolean needsNewCIMOMHandleWrapper() {
        return this.needsNewCIMOMHandleWrapper;
    }

    public ConfigMgmtException getResultException() {
        return this.resultException;
    }
}

