/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.core;

import com.sun.netstorage.array.mgmt.cfg.core.Runner;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import java.lang.reflect.InvocationTargetException;

public class TimedRun {
    Object result = null;
    InvocationTargetException exception = null;
    boolean isDone = false;

    public Runnable getRunnable(final Runner runner) {
        return new Runnable(){

            public void run() {
                try {
                    TimedRun.this.setResult(runner.doRun());
                }
                catch (Throwable t) {
                    TimedRun.this.setException(t);
                }
            }
        };
    }

    private synchronized void setResult(Object o) {
        this.result = o;
        this.isDone = true;
        this.notify();
    }

    private synchronized void setException(Throwable t) {
        this.exception = new InvocationTargetException(t);
        this.isDone = true;
        this.notify();
    }

    public synchronized Object getResult() throws InvocationTargetException {
        if (this.exception != null) {
            throw this.exception;
        }
        return this.result;
    }

    public synchronized Object getResultWithTimeLimit(long limit) throws InterruptedException, InvocationTargetException {
        String METHOD = "getResultWithTimeLimit";
        Trace.methodBegin(this, "getResultWithTimeLimit");
        if (this.isDone) {
            return this.getResult();
        }
        if (limit <= 0L) {
            throw new InterruptedException("Timed out.");
        }
        this.wait(limit);
        if (this.isDone) {
            return this.getResult();
        }
        Trace.verbose((Object)this, "getResultWithTimeLimit", "Execution timed out after waiting: " + limit);
        throw new InterruptedException("Waited and Timed out.");
    }

    public synchronized void reset() {
        this.isDone = false;
        this.exception = null;
        this.result = null;
    }
}

