/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.core;

import EDU.oswego.cs.dl.util.concurrent.Channel;
import EDU.oswego.cs.dl.util.concurrent.LinkedQueue;
import EDU.oswego.cs.dl.util.concurrent.PooledExecutor;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.ini.Repository;

public class ThreadPool {
    private static PooledExecutor threadPool;
    private static int DEFAULT_MAX_POOL_SIZE;
    private static final String REPOSITORY_KEY_MAX_POOL_SIZE = "ThreadPoolMaxThreads";
    private static final ThreadPool INSTANCE;

    private ThreadPool() {
        int maxPoolSize = DEFAULT_MAX_POOL_SIZE;
        String size = (String)Repository.getRepository().getProperty(REPOSITORY_KEY_MAX_POOL_SIZE);
        if (size != null) {
            try {
                maxPoolSize = Integer.parseInt(size);
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            Trace.error((Object)this, "Constructor", "Failed to retrieve max thread pool size (ThreadPoolMaxThreads) from repository.");
        }
        threadPool = new PooledExecutor((Channel)new LinkedQueue(), maxPoolSize);
    }

    public void execute(Runnable task) throws InterruptedException {
        String METHOD_NAME = "put";
        threadPool.execute(task);
        if (Trace.isTraceEnabled(this)) {
            Trace.verbose((Object)this, "put", this.getPoolSize() + " threads in ThreadPool.");
        }
    }

    public int getPoolSize() {
        return threadPool.getPoolSize();
    }

    public int getMaximumPoolSize() {
        return threadPool.getMaximumPoolSize();
    }

    public static ThreadPool getInstance() {
        return INSTANCE;
    }

    static {
        DEFAULT_MAX_POOL_SIZE = 10;
        INSTANCE = new ThreadPool();
    }
}

