/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.core;

import com.sun.netstorage.array.mgmt.cfg.core.ErrorCode;
import com.sun.netstorage.array.mgmt.cfg.core.ErrorCodeType;
import com.sun.netstorage.array.mgmt.cfg.core.ErrorDescriptor;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.jobs.business.JobCompletionInterface;
import com.sun.netstorage.array.mgmt.cfg.jobs.business.JobInterface;
import java.util.ArrayList;
import java.util.List;

public class MethodCallStatus {
    private int returnCode = 0;
    private String errorDesc;
    private ArrayList jobs = new ArrayList();
    private ArrayList completionTasks = new ArrayList();
    private ArrayList errorDescList = new ArrayList();

    public MethodCallStatus() {
        Trace.constructor(this);
    }

    public MethodCallStatus(int returnCode, ArrayList jobs) {
        Trace.constructor(this);
        this.returnCode = returnCode;
        this.jobs = jobs;
    }

    public List getErrorDescList() {
        return this.errorDescList;
    }

    public void addErrorDescriptor(ErrorDescriptor ed) {
        this.errorDescList.add(ed);
        ErrorCode errorCode = ed.getErrCode();
        if (errorCode != null) {
            ErrorCodeType type = errorCode.getErrorCodeType();
            if (type.equals(ErrorCodeType.ERROR)) {
                this.setReturnCode(2);
            } else if (type.equals(ErrorCodeType.WARNING) && this.getReturnCode() != 2) {
                this.setReturnCode(1);
            }
        }
    }

    public void addErrorDescriptorList(List edList) {
        int sz = edList == null ? 0 : edList.size();
        for (int i = 0; i < sz; ++i) {
            this.addErrorDescriptor((ErrorDescriptor)edList.get(i));
        }
    }

    public ArrayList getJobs() {
        return this.jobs;
    }

    public ArrayList getCompletionTasks() {
        return this.completionTasks;
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    public void setJobs(List jobs) {
        this.jobs = new ArrayList(jobs);
    }

    public void setReturnCode(int returnCode) {
        this.returnCode = returnCode;
    }

    public void addJobToList(JobInterface job) {
        Trace.methodBegin(this, "addJobToList");
        if (this.jobs != null) {
            this.jobs.add(job);
        } else {
            this.jobs = new ArrayList();
            this.jobs.add(job);
        }
    }

    public void addTaskToList(JobCompletionInterface task) {
        Trace.methodBegin(this, "addTaskToList");
        if (this.completionTasks != null) {
            this.completionTasks.add(task);
        } else {
            this.completionTasks = new ArrayList();
            this.completionTasks.add(task);
        }
    }

    public void removeJobFromList(JobInterface job) {
        Trace.methodBegin(this, "removeJobFromList");
        if (this.jobs != null) {
            this.jobs.remove(job);
        }
    }

    public void removeTaskFromList(JobCompletionInterface task) {
        Trace.methodBegin(this, "removeTaskFromList");
        if (this.completionTasks != null) {
            this.completionTasks.remove(task);
        }
    }
}

