/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.core;

import com.sun.netstorage.array.mgmt.cfg.core.CIMOMHandleWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.CIMTraceInfo;
import com.sun.netstorage.array.mgmt.cfg.core.Runner;
import com.sun.netstorage.array.mgmt.cfg.core.TimedRun;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.CIMExceptionJudge;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.InvalidCredentials;
import com.sun.netstorage.array.mgmt.cfg.core.ini.Repository;
import java.lang.reflect.InvocationTargetException;
import java.security.Principal;
import java.util.Enumeration;
import javax.wbem.cim.CIMArgument;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMNameSpace;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMValue;
import javax.wbem.client.CIMClient;

public class CIMClientWrapper
implements CIMOMHandleWrapper {
    private CIMClient realCIM = null;
    private CIMNameSpace cimNamespace = null;
    private Principal cimPrincipal = null;
    private Object cimCredential = null;
    private String cimProtocol = "cim-rmi";
    private static final long SLEEP_INTERVAL = 3000L;
    private boolean CONST_INCLQUALIFIERS = false;
    private boolean CONST_INCLCLASSORIGINS = false;
    private static String INCL_CLASS_ORIGINS_PARAM = "cim-include-class-origins";

    public CIMClientWrapper(CIMNameSpace name, Principal principal, Object credential) throws ConfigMgmtException {
        this.cimNamespace = name;
        this.cimPrincipal = principal;
        this.cimCredential = credential;
        if (Repository.getRepository().getProperty(INCL_CLASS_ORIGINS_PARAM) != null && "true".equals((String)Repository.getRepository().getProperty(INCL_CLASS_ORIGINS_PARAM))) {
            this.CONST_INCLCLASSORIGINS = true;
        }
        this.getCIMClient();
    }

    public CIMClientWrapper(CIMNameSpace name, Principal principal, Object credential, String protocol) throws ConfigMgmtException {
        this.cimNamespace = name;
        this.cimPrincipal = principal;
        this.cimCredential = credential;
        this.cimProtocol = protocol;
        if (Repository.getRepository().getProperty(INCL_CLASS_ORIGINS_PARAM) != null && "true".equals((String)Repository.getRepository().getProperty(INCL_CLASS_ORIGINS_PARAM))) {
            this.CONST_INCLCLASSORIGINS = true;
        }
        this.getCIMClient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getCIMClient() throws ConfigMgmtException {
        this.realCIM = null;
        int retry = 0;
        while (this.realCIM == null && retry < 4) {
            try {
                this.realCIM = new CIMClient(this.cimNamespace, this.cimPrincipal, this.cimCredential, this.cimProtocol);
            }
            catch (CIMException cime) {
                Trace.verbose((Object)this, "getCIMClient", "Failed to get CIM connection: " + cime.getID());
                String reason = cime.getID();
                if (reason.equals("NO_SUCH_PRINCIPAL") || reason.equals("INVALID_CREDENTIAL")) {
                    throw new InvalidCredentials("INVALID_CREDENTIAL", "Invalid user name or password.", (Exception)((Object)cime));
                }
                if (reason.equals("UNKNOWNHOST")) {
                    throw new ConfigMgmtException("UNKNOWN_HOST", "Host unknown.", (Exception)((Object)cime));
                }
                if (reason.equals("NO_CIMOM") || reason.equals("RMIERROR")) {
                    if (retry >= 3) {
                        throw new ConfigMgmtException("UNABLE_TO_CONNECT_TO_CIMOM", "Host unknown.", (Exception)((Object)cime));
                    }
                    Trace.verbose((Object)this, "getCIMClient", "UNABLE TO CONNECT TO CIMOM:" + reason);
                    this.realCIM = null;
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException ie) {}
                    continue;
                }
                throw new ConfigMgmtException("CIM_UNKNOWN_ERROR", "Unknown CIM error.", (Exception)((Object)cime));
            }
            finally {
                ++retry;
            }
        }
        if (this.realCIM == null) {
            Trace.verbose((Object)this, "getCIMClient", "Failed to get connection in unexpected way.");
            throw new ConfigMgmtException("CIM_UNKNOWN_ERROR", "Unknown CIM error.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object doTimedWork(TimedRun tr, Runnable r, long limit, String threadName, CIMTraceInfo traceInfo) throws ConfigMgmtException {
        String METHOD = "doTimedWork";
        int numTries = 1;
        if (traceInfo == null) {
            traceInfo = new CIMTraceInfo(new Object[]{""});
        }
        while (numTries <= 4) {
            block17: {
                tr.reset();
                Thread t = new Thread(r, threadName + ": " + numTries);
                t.start();
                try {
                    Object object = tr.getResultWithTimeLimit(limit);
                    return object;
                }
                catch (InterruptedException ie) {
                    t.interrupt();
                    Trace.error((Object)this, "doTimedWork", "Request CIMClient action timed out. " + traceInfo.toString());
                    throw new ConfigMgmtException("CIM_TIMEOUT_EXCEPTION", "CIMClientWrapper.doTimedWork timed out performing action.");
                }
                catch (InvocationTargetException ite) {
                    Throwable cause = ite.getCause();
                    if (Trace.isTraceEnabled(this)) {
                        Trace.verbose((Object)this, "doTimedWork\nRunnable threw exception with starting info: " + traceInfo.toString(), cause);
                    }
                    CIMExceptionJudge judge = null;
                    if (cause instanceof Exception) {
                        judge = new CIMExceptionJudge(numTries, (Exception)cause);
                    }
                    if (judge != null && judge.shouldRetry()) {
                        Trace.verbose((Object)this, "doTimedWork", "Will retry.");
                        if (judge.needsNewCIMOMHandleWrapper()) {
                            Trace.verbose((Object)this, "doTimedWork", "Needs new CIMClient.");
                            this.getCIMClient();
                        }
                        break block17;
                    }
                    if (judge != null) {
                        Trace.verbose((Object)this, "doTimedWork", "Will not retry.");
                        ConfigMgmtException cme = judge.getResultException();
                        cme.addExceptionContext(traceInfo);
                        if (cme != null) {
                            throw cme;
                        }
                        if (cause instanceof Exception) {
                            throw new ConfigMgmtException((Exception)cause);
                        }
                        throw new ConfigMgmtException("CIM_UNKNOWN_ERROR", "Unknown error: " + cause.getMessage());
                    }
                    Trace.verbose((Object)this, "doTimedWork", "Will not retry. And didn't get Exception.");
                    ConfigMgmtException cme = new ConfigMgmtException("CIM_UNKNOWN_ERROR", "Unknown error: " + cause.getMessage());
                    cme.addExceptionContext(traceInfo);
                    throw cme;
                }
                finally {
                    ++numTries;
                }
            }
            try {
                Trace.verbose((Object)this, "doTimedWork", "Before trying again, sleep for: 3000");
                Thread.sleep(3000L);
            }
            catch (InterruptedException ie2) {}
        }
        return null;
    }

    public synchronized void close() {
        try {
            this.realCIM.close();
        }
        catch (CIMException ce) {
            Trace.verbose((Object)this, "Failed to close", (Throwable)ce);
        }
    }

    public synchronized void deleteInstance(final CIMObjectPath path) throws ConfigMgmtException {
        String METHOD = "deleteInstance";
        TimedRun tr = new TimedRun();
        Runnable r = tr.getRunnable(new Runner(){

            public Object doRun() throws Exception {
                CIMClientWrapper.this.realCIM.deleteInstance(path);
                return null;
            }
        });
        CIMTraceInfo traceInfo = new CIMTraceInfo(new Object[]{"deleteInstance", path});
        Object ignoreMe = this.doTimedWork(tr, r, 300000L, "deleteInstance", traceInfo);
    }

    public Enumeration enumerateClasses(CIMObjectPath path) throws ConfigMgmtException {
        return this.enumerateClasses(path, false, true, true, false);
    }

    public Enumeration enumerateClasses(CIMObjectPath path, boolean deep) throws ConfigMgmtException {
        return this.enumerateClasses(path, deep, true, true, false);
    }

    public Enumeration enumerateClasses(CIMObjectPath path, boolean deep, boolean localOnly) throws ConfigMgmtException {
        return this.enumerateClasses(path, deep, localOnly, true, false);
    }

    public Enumeration enumerateClasses(CIMObjectPath path, boolean deep, boolean localOnly, boolean includeQualifiers) throws ConfigMgmtException {
        return this.enumerateClasses(path, deep, localOnly, includeQualifiers, false);
    }

    public synchronized Enumeration enumerateClasses(final CIMObjectPath path, final boolean deep, final boolean localOnly, final boolean includeQualifiers, final boolean includeClassOrigin) throws ConfigMgmtException {
        String METHOD = "enumerateClasses";
        TimedRun tr = new TimedRun();
        Runnable r = tr.getRunnable(new Runner(){

            public Object doRun() throws Exception {
                return CIMClientWrapper.this.realCIM.enumerateClasses(path, deep, localOnly, includeQualifiers & CIMClientWrapper.this.CONST_INCLQUALIFIERS, includeClassOrigin | CIMClientWrapper.this.CONST_INCLCLASSORIGINS);
            }
        });
        CIMTraceInfo traceInfo = new CIMTraceInfo(new Object[]{"enumerateClasses", path, new Boolean(deep), new Boolean(localOnly), new Boolean(includeQualifiers & this.CONST_INCLQUALIFIERS), new Boolean(includeClassOrigin | this.CONST_INCLCLASSORIGINS)});
        return (Enumeration)this.doTimedWork(tr, r, 300000L, "enumerateClasses", traceInfo);
    }

    public Enumeration enumerateClassNames(CIMObjectPath path) throws ConfigMgmtException {
        return this.enumerateClassNames(path, false);
    }

    public synchronized Enumeration enumerateClassNames(final CIMObjectPath path, final boolean deep) throws ConfigMgmtException {
        String METHOD = "enumerateClassNames";
        TimedRun tr = new TimedRun();
        Runnable r = tr.getRunnable(new Runner(){

            public Object doRun() throws Exception {
                return CIMClientWrapper.this.realCIM.enumerateClassNames(path, deep);
            }
        });
        CIMTraceInfo traceInfo = new CIMTraceInfo(new Object[]{"enumerateClassNames", path, new Boolean(deep)});
        return (Enumeration)this.doTimedWork(tr, r, 300000L, "enumerateClassNames", traceInfo);
    }

    public synchronized Enumeration enumerateInstanceNames(final CIMObjectPath path) throws ConfigMgmtException {
        String METHOD = "enumerateInstanceNames";
        TimedRun tr = new TimedRun();
        Runnable r = tr.getRunnable(new Runner(){

            public Object doRun() throws Exception {
                return CIMClientWrapper.this.realCIM.enumerateInstanceNames(path);
            }
        });
        CIMTraceInfo traceInfo = new CIMTraceInfo(new Object[]{"enumerateInstanceNames", path});
        return (Enumeration)this.doTimedWork(tr, r, 300000L, "enumerateInstanceNames", traceInfo);
    }

    public Enumeration enumerateInstances(CIMObjectPath path) throws ConfigMgmtException {
        return this.enumerateInstances(path, true, true, false, false, null);
    }

    public Enumeration enumerateInstances(CIMObjectPath path, boolean deep) throws ConfigMgmtException {
        return this.enumerateInstances(path, deep, true, false, false, null);
    }

    public Enumeration enumerateInstances(CIMObjectPath path, boolean deep, boolean localOnly) throws ConfigMgmtException {
        return this.enumerateInstances(path, deep, localOnly, false, false, null);
    }

    public Enumeration enumerateInstances(CIMObjectPath path, boolean deep, boolean localOnly, boolean includeQualifiers) throws ConfigMgmtException {
        return this.enumerateInstances(path, deep, localOnly, includeQualifiers, false, null);
    }

    public Enumeration enumerateInstances(CIMObjectPath path, boolean deep, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin) throws ConfigMgmtException {
        return this.enumerateInstances(path, deep, localOnly, includeQualifiers, includeClassOrigin, null);
    }

    public synchronized Enumeration enumerateInstances(final CIMObjectPath path, final boolean deep, final boolean localOnly, final boolean includeQualifiers, final boolean includeClassOrigin, final String[] propertyList) throws ConfigMgmtException {
        String METHOD = "enumerateInstances";
        TimedRun tr = new TimedRun();
        Runnable r = tr.getRunnable(new Runner(){

            public Object doRun() throws Exception {
                return CIMClientWrapper.this.realCIM.enumerateInstances(path, deep, localOnly, includeQualifiers & CIMClientWrapper.this.CONST_INCLQUALIFIERS, includeClassOrigin | CIMClientWrapper.this.CONST_INCLCLASSORIGINS, propertyList);
            }
        });
        CIMTraceInfo traceInfo = new CIMTraceInfo(new Object[]{"enumerateInstances", path, new Boolean(deep), new Boolean(localOnly), new Boolean(includeQualifiers), new Boolean(includeClassOrigin | this.CONST_INCLCLASSORIGINS), propertyList});
        return (Enumeration)this.doTimedWork(tr, r, 300000L, "enumerateInstances", traceInfo);
    }

    public CIMClass getClass(CIMObjectPath name) throws ConfigMgmtException {
        return this.getClass(name, true, true, false, null);
    }

    public CIMClass getClass(CIMObjectPath name, boolean localOnly) throws ConfigMgmtException {
        return this.getClass(name, localOnly, true, false, null);
    }

    public CIMClass getClass(CIMObjectPath name, boolean localOnly, boolean includeQualifiers) throws ConfigMgmtException {
        return this.getClass(name, localOnly, includeQualifiers, false, null);
    }

    public CIMClass getClass(CIMObjectPath name, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin) throws ConfigMgmtException {
        return this.getClass(name, localOnly, includeQualifiers, includeClassOrigin, null);
    }

    public synchronized CIMClass getClass(final CIMObjectPath name, final boolean localOnly, final boolean includeQualifiers, final boolean includeClassOrigin, final String[] propertyList) throws ConfigMgmtException {
        String METHOD = "getClass";
        TimedRun tr = new TimedRun();
        Runnable r = tr.getRunnable(new Runner(){

            public Object doRun() throws Exception {
                return CIMClientWrapper.this.realCIM.getClass(name, localOnly, includeQualifiers & CIMClientWrapper.this.CONST_INCLQUALIFIERS, includeClassOrigin | CIMClientWrapper.this.CONST_INCLCLASSORIGINS, propertyList);
            }
        });
        CIMTraceInfo traceInfo = new CIMTraceInfo(new Object[]{"getClass", name, new Boolean(localOnly), new Boolean(includeQualifiers), new Boolean(includeClassOrigin | this.CONST_INCLCLASSORIGINS), propertyList});
        return (CIMClass)this.doTimedWork(tr, r, 300000L, "getClass", traceInfo);
    }

    public CIMInstance getInstance(CIMObjectPath name) throws ConfigMgmtException {
        return this.getInstance(name, true, false, false, null);
    }

    public CIMInstance getInstance(CIMObjectPath name, boolean localOnly) throws ConfigMgmtException {
        return this.getInstance(name, localOnly, false, false, null);
    }

    public CIMInstance getInstance(CIMObjectPath name, boolean localOnly, boolean includeQualifiers) throws ConfigMgmtException {
        return this.getInstance(name, localOnly, includeQualifiers, false, null);
    }

    public CIMInstance getInstance(CIMObjectPath name, boolean localOnly, boolean includeQualifiers, boolean includeClassOrigin) throws ConfigMgmtException {
        return this.getInstance(name, localOnly, includeQualifiers, includeClassOrigin, null);
    }

    public synchronized CIMInstance getInstance(final CIMObjectPath name, final boolean localOnly, final boolean includeQualifiers, final boolean includeClassOrigin, final String[] propertyList) throws ConfigMgmtException {
        String METHOD = "getInstance";
        TimedRun tr = new TimedRun();
        Runnable r = tr.getRunnable(new Runner(){

            public Object doRun() throws Exception {
                return CIMClientWrapper.this.realCIM.getInstance(name, localOnly, includeQualifiers & CIMClientWrapper.this.CONST_INCLQUALIFIERS, includeClassOrigin | CIMClientWrapper.this.CONST_INCLCLASSORIGINS, propertyList);
            }
        });
        CIMTraceInfo traceInfo = new CIMTraceInfo(new Object[]{"getInstance", name, new Boolean(localOnly), new Boolean(includeQualifiers), new Boolean(includeClassOrigin | this.CONST_INCLCLASSORIGINS), propertyList});
        return (CIMInstance)this.doTimedWork(tr, r, 300000L, "getInstance", traceInfo);
    }

    public CIMValue invokeMethod(final CIMObjectPath name, final String methodName, final CIMArgument[] inArgs, final CIMArgument[] outArgs) throws ConfigMgmtException {
        String METHOD = "invokeMethod";
        TimedRun tr = new TimedRun();
        Runnable r = tr.getRunnable(new Runner(){

            public Object doRun() throws Exception {
                return CIMClientWrapper.this.realCIM.invokeMethod(name, methodName, inArgs, outArgs);
            }
        });
        CIMTraceInfo traceInfo = new CIMTraceInfo(new Object[]{"invokeMethod", name, methodName, inArgs, outArgs});
        return (CIMValue)this.doTimedWork(tr, r, 300000L, "invokeMethod", traceInfo);
    }

    public synchronized CIMObjectPath createInstance(final CIMObjectPath name, final CIMInstance ci) throws ConfigMgmtException {
        String METHOD = "createInstance";
        TimedRun tr = new TimedRun();
        Runnable r = tr.getRunnable(new Runner(){

            public Object doRun() throws Exception {
                return CIMClientWrapper.this.realCIM.createInstance(name, ci);
            }
        });
        CIMTraceInfo traceInfo = new CIMTraceInfo(new Object[]{"createInstance", name, ci});
        return (CIMObjectPath)this.doTimedWork(tr, r, 300000L, "createInstance", traceInfo);
    }

    public synchronized void setInstance(CIMObjectPath name, CIMInstance ci) throws ConfigMgmtException {
        this.setInstance(name, ci, true, null);
    }

    public void setInstance(final CIMObjectPath name, final CIMInstance ci, final boolean includeQualifiers, final String[] propertyList) throws ConfigMgmtException {
        String METHOD = "setInstance";
        TimedRun tr = new TimedRun();
        Runnable r = tr.getRunnable(new Runner(){

            public Object doRun() throws Exception {
                CIMClientWrapper.this.realCIM.setInstance(name, ci, includeQualifiers & CIMClientWrapper.this.CONST_INCLQUALIFIERS, propertyList);
                return null;
            }
        });
        CIMTraceInfo traceInfo = new CIMTraceInfo(new Object[]{"setInstance", name, ci, new Boolean(includeQualifiers), propertyList});
        Object ignoreMe = this.doTimedWork(tr, r, 600000L, "setInstance", traceInfo);
    }

    public synchronized CIMValue getProperty(final CIMObjectPath name, final String propertyName) throws ConfigMgmtException {
        String METHOD = "getProperty";
        TimedRun tr = new TimedRun();
        Runnable r = tr.getRunnable(new Runner(){

            public Object doRun() throws Exception {
                return CIMClientWrapper.this.realCIM.getProperty(name, propertyName);
            }
        });
        CIMTraceInfo traceInfo = new CIMTraceInfo(new Object[]{"getProperty", name, propertyName});
        return (CIMValue)this.doTimedWork(tr, r, 300000L, "getProperty", traceInfo);
    }

    public synchronized void setProperty(final CIMObjectPath name, final String propertyName, final CIMValue newValue) throws ConfigMgmtException {
        String METHOD = "setProperty";
        TimedRun tr = new TimedRun();
        Runnable r = tr.getRunnable(new Runner(){

            public Object doRun() throws Exception {
                CIMClientWrapper.this.realCIM.setProperty(name, propertyName, newValue);
                return null;
            }
        });
        CIMTraceInfo traceInfo = new CIMTraceInfo(new Object[]{"setProperty", name, propertyName, newValue});
        Object ignore = this.doTimedWork(tr, r, 300000L, "setProperty", traceInfo);
    }

    public synchronized void setProperty(CIMObjectPath name, String propertyName) throws ConfigMgmtException {
        this.setProperty(name, propertyName, null);
    }

    public synchronized Enumeration execQuery(final CIMObjectPath name, final String query, final String ql) throws ConfigMgmtException {
        String METHOD = "execQuery";
        TimedRun tr = new TimedRun();
        Runnable r = tr.getRunnable(new Runner(){

            public Object doRun() throws Exception {
                return CIMClientWrapper.this.realCIM.execQuery(name, query, ql);
            }
        });
        CIMTraceInfo traceInfo = new CIMTraceInfo(new Object[]{"execQuery", name, query, ql});
        return (Enumeration)this.doTimedWork(tr, r, 300000L, "execQuery", traceInfo);
    }

    public Enumeration associators(CIMObjectPath objectName) throws ConfigMgmtException {
        return this.associators(objectName, null, null, null, null, true, false, null);
    }

    public Enumeration associators(final CIMObjectPath objectName, final String assocClass, final String resultClass, final String role, final String resultRole, final boolean includeQualifiers, final boolean includeClassOrigin, final String[] propertyList) throws ConfigMgmtException {
        String METHOD = "associators";
        TimedRun tr = new TimedRun();
        Runnable r = tr.getRunnable(new Runner(){

            public Object doRun() throws Exception {
                return CIMClientWrapper.this.realCIM.associators(objectName, assocClass, resultClass, role, resultRole, includeQualifiers & CIMClientWrapper.this.CONST_INCLQUALIFIERS, includeClassOrigin | CIMClientWrapper.this.CONST_INCLCLASSORIGINS, propertyList);
            }
        });
        CIMTraceInfo traceInfo = new CIMTraceInfo(new Object[]{"associators", objectName, assocClass, resultClass, role, resultRole, new Boolean(includeQualifiers), new Boolean(includeClassOrigin | this.CONST_INCLCLASSORIGINS), propertyList});
        return (Enumeration)this.doTimedWork(tr, r, 300000L, "associators", traceInfo);
    }

    public Enumeration associatorNames(CIMObjectPath objectName) throws ConfigMgmtException {
        return this.associatorNames(objectName, null, null, null, null);
    }

    public Enumeration associatorNames(final CIMObjectPath objectName, final String assocClass, final String resultClass, final String role, final String resultRole) throws ConfigMgmtException {
        String METHOD = "associatorNames";
        TimedRun tr = new TimedRun();
        Runnable r = tr.getRunnable(new Runner(){

            public Object doRun() throws Exception {
                return CIMClientWrapper.this.realCIM.associatorNames(objectName, assocClass, resultClass, role, resultRole);
            }
        });
        CIMTraceInfo traceInfo = new CIMTraceInfo(new Object[]{"associatorNames", objectName, assocClass, resultClass, role, resultRole});
        return (Enumeration)this.doTimedWork(tr, r, 300000L, "associatorNames", traceInfo);
    }

    public Enumeration references(final CIMObjectPath objectName, final String resultClass, final String role, final boolean includeQualifiers, final boolean includeClassOrigin, final String[] propertyList) throws ConfigMgmtException {
        String METHOD = "references";
        TimedRun tr = new TimedRun();
        Runnable r = tr.getRunnable(new Runner(){

            public Object doRun() throws Exception {
                return CIMClientWrapper.this.realCIM.references(objectName, resultClass, role, includeQualifiers & CIMClientWrapper.this.CONST_INCLQUALIFIERS, includeClassOrigin | CIMClientWrapper.this.CONST_INCLCLASSORIGINS, propertyList);
            }
        });
        CIMTraceInfo traceInfo = new CIMTraceInfo(new Object[]{"references", objectName, resultClass, role, new Boolean(includeQualifiers), new Boolean(includeClassOrigin | this.CONST_INCLCLASSORIGINS), propertyList});
        return (Enumeration)this.doTimedWork(tr, r, 300000L, "references", traceInfo);
    }

    public Enumeration references(CIMObjectPath objectName) throws ConfigMgmtException {
        return this.references(objectName, null, null, true, false, null);
    }

    public Enumeration referenceNames(final CIMObjectPath objectName, final String resultClass, final String role) throws ConfigMgmtException {
        String METHOD = "referenceNames";
        TimedRun tr = new TimedRun();
        Runnable r = tr.getRunnable(new Runner(){

            public Object doRun() throws Exception {
                return CIMClientWrapper.this.realCIM.referenceNames(objectName, resultClass, role);
            }
        });
        CIMTraceInfo traceInfo = new CIMTraceInfo(new Object[]{"referenceNames", objectName, resultClass, role});
        return (Enumeration)this.doTimedWork(tr, r, 300000L, "referenceNames", traceInfo);
    }

    public Enumeration referenceNames(CIMObjectPath objectName) throws ConfigMgmtException {
        return this.referenceNames(objectName, null, null);
    }
}

