/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.admin.business.impl.test;

import com.sun.netstorage.array.mgmt.cfg.admin.business.ArrayRegistration;
import com.sun.netstorage.array.mgmt.cfg.admin.business.ManageArrayRegistrationsInterface;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.logic.SearchFilter;
import java.util.ArrayList;
import java.util.List;

public class ManageArrayRegistrations
implements ManageArrayRegistrationsInterface {
    private ArrayList arrayRegList;
    private ConfigContext context;

    public void init(ConfigContext context) throws ConfigMgmtException {
        Trace.methodBegin(this, "init");
        this.context = context;
        this.arrayRegList = new ArrayList();
        for (int i = 0; i < 5; ++i) {
            this.createArrayRegistration("127.0.0." + i, "testpw" + i);
        }
        Trace.verbose((Object)this, "init", "number of ArrayRegistration in list: " + this.arrayRegList.size());
    }

    public void init(ConfigContext context, SearchFilter filter) throws ConfigMgmtException {
        Trace.methodBegin(this, "init");
        this.context = context;
        this.arrayRegList = new ArrayList();
        for (int i = 0; i < 5; ++i) {
            this.createArrayRegistration("127.0.0." + i, "testpw" + i);
        }
        Trace.verbose((Object)this, "init", "number of ArrayRegistration in list: " + this.arrayRegList.size());
    }

    public List getItemList() throws ConfigMgmtException {
        return this.arrayRegList;
    }

    public void create(ConfigContext context, ArrayRegistration regData) throws ConfigMgmtException {
        Trace.methodBegin(this, "create");
        String ip = regData.getIPAddress();
        String pw = regData.getPassword();
        this.createArrayRegistration(ip, pw);
    }

    public int changePassword(ConfigContext context, ArrayRegistration arrayReg, String newPassword) throws ConfigMgmtException {
        Trace.methodBegin(this, "changePassword");
        boolean savedData = false;
        Trace.verbose((Object)this, "changePassword", "change password method is called to  change Array Registration data");
        for (int i = 0; i < this.arrayRegList.size(); ++i) {
            ArrayRegistration ar = (ArrayRegistration)this.arrayRegList.get(i);
            if (!ar.getIPAddress().equals(arrayReg.getIPAddress())) continue;
            ar.setPassword(newPassword);
            savedData = true;
            break;
        }
        if (!savedData) {
            Trace.verbose((Object)this, "changePassword", "No matching IP address found");
            throw new ConfigMgmtException("DATA_INCONSISTENCY", "IP Address cannot be located.");
        }
        return 2;
    }

    public void save(ConfigContext context, ArrayRegistration arrayReg) throws ConfigMgmtException {
        Trace.methodBegin(this, "save");
        Trace.verbose((Object)this, "save", "Save method is called to save Array Registration data");
        String ip = arrayReg.getIPAddress();
        String pw = arrayReg.getPassword();
        boolean savedData = false;
        for (int i = 0; i < this.arrayRegList.size(); ++i) {
            ArrayRegistration ar = (ArrayRegistration)this.arrayRegList.get(i);
            if (!ar.getIPAddress().equals(ip)) continue;
            ar.setPassword(ip);
            savedData = true;
            break;
        }
        if (!savedData) {
            Trace.verbose((Object)this, "save", "No matching IP address found");
            throw new ConfigMgmtException("DATA_INCONSISTENCY", "IP Address cannot be located.");
        }
    }

    public void remove(ConfigContext context, ArrayRegistration arrayReg) throws ConfigMgmtException {
        Trace.methodBegin(this, "remove");
        Trace.verbose((Object)this, "remove", "Remove method is called to remove Array Registration data");
        String ip = arrayReg.getIPAddress();
        String pw = arrayReg.getPassword();
        boolean removedData = false;
        for (int i = 0; i < this.arrayRegList.size(); ++i) {
            ArrayRegistration ar = (ArrayRegistration)this.arrayRegList.get(i);
            if (!ar.getIPAddress().equals(ip)) continue;
            this.arrayRegList.remove(i);
            removedData = true;
            break;
        }
        if (!removedData) {
            Trace.verbose((Object)this, "remove", "No matching IP address found");
            throw new ConfigMgmtException("DATA_INCONSISTENCY", "IP Address cannot be located.");
        }
    }

    public void reload() throws ConfigMgmtException {
        Trace.methodBegin(this, "reload");
        Trace.verbose((Object)this, "reload", "Reload method is called to reloads the Array Registration data");
    }

    public void reload(ArrayRegistration array) throws ConfigMgmtException {
        Trace.methodBegin(this, "reload");
        Trace.verbose((Object)this, "reload", "Reload method is called to reloads the Array Registration data");
    }

    private void createArrayRegistration(String ipAddress, String rootPassword) throws ConfigMgmtException {
        Trace.methodBegin(this, "createArrayRegistration");
        ArrayRegistration arrayReg = new ArrayRegistration();
        arrayReg.setIPAddress(ipAddress);
        arrayReg.setPassword(rootPassword);
        this.arrayRegList.add(arrayReg);
    }

    public ArrayRegistration getArrayRegByIP(ConfigContext context, String ip) {
        Trace.methodBegin(this, "getArrayRegByIP");
        ArrayRegistration arrayReg = new ArrayRegistration();
        arrayReg.setIPAddress(ip);
        arrayReg.setHealthStatus(0);
        arrayReg.setPassword("test");
        ArrayList<ArrayRegistration> arrayRegList = new ArrayList<ArrayRegistration>();
        arrayRegList.add(arrayReg);
        return arrayReg;
    }
}

