/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.admin.business.impl.mr3;

import com.sun.netstorage.array.mgmt.cfg.admin.business.ArrayRegistration;
import com.sun.netstorage.array.mgmt.cfg.admin.business.ManageArrayRegistrationsInterface;
import com.sun.netstorage.array.mgmt.cfg.core.CIMOMHandleWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.impl.CIMObjectWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.impl.MapElement;
import com.sun.netstorage.array.mgmt.cfg.core.impl.MapStringArrayToString;
import com.sun.netstorage.array.mgmt.cfg.core.logic.SearchFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.wbem.cim.CIMArgument;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;

public class ManageArrayRegistrations
implements ManageArrayRegistrationsInterface {
    private static final String[] ACCT_PROPERTIES = new String[]{"Name", "UserPassword", "PersistPassword", "SystemCreationClassName", "SystemName", "CreationClassName", "OperationalStatus"};
    private ArrayList arrayRegList;
    private ConfigContext context;
    private SearchFilter filter;
    private CIMOMHandleWrapper handle;
    private static ArrayList accountPropMapList;

    public ManageArrayRegistrations() {
        Trace.constructor(this);
    }

    public void init(ConfigContext context, SearchFilter filter) throws ConfigMgmtException {
        String methodName = "init";
        Trace.methodBegin(this, methodName);
        this.context = context;
        this.handle = context.getClient();
        this.filter = filter;
        this.arrayRegList = new ArrayList();
        try {
            Trace.verbose((Object)this, methodName, "Going to CIMOM to get Account Class ObjectPath!");
            CIMObjectPath accountOP = new CIMObjectPath("SunStorEdge_6120Account");
            Trace.verbose((Object)this, methodName, "Getting an enumeration of Account CIM Instance objects!!");
            Enumeration accountEnum = this.handle.enumerateInstances(accountOP, false, false, true, false, null);
            Trace.verbose((Object)this, methodName, "Account Enumeration is NULL: " + (accountEnum == null));
            while (accountEnum.hasMoreElements()) {
                CIMInstance acctCimInstance = (CIMInstance)accountEnum.nextElement();
                Trace.verbose((Object)this, methodName, "Got the CIM Account instance!!");
                if (filter == null || filter.isEmpty() || filter.passesFilter(acctCimInstance)) {
                    Trace.verbose((Object)this, methodName, "Either search filter is not null or CIM Cluster instance passes filter: loading Account object with properties!!");
                    this.loadAccountProperty(acctCimInstance);
                    continue;
                }
                Trace.verbose((Object)this, methodName, "Account CIMInstance did not pass filter: ArrayRegistration object is NOT being created!!");
            }
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, methodName, "Failed: " + cme.getMessage());
            throw cme;
        }
        catch (NullPointerException ne) {
            Trace.verbose((Object)this, "Null value returned while loading up ArrayReg objects", (Throwable)ne);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "Null value returned error.", ne);
        }
        if (Trace.isTraceEnabled(this)) {
            Trace.verbose((Object)this, methodName, "finished init ArrayReg: number of ArrayReg in list: " + this.arrayRegList.size());
            for (int j = 0; j < this.arrayRegList.size(); ++j) {
                Trace.verbose((Object)this, methodName, "ArrayReg " + j + ": name: " + ((ArrayRegistration)this.arrayRegList.get(j)).getIPAddress());
            }
        }
    }

    public List getItemList() throws ConfigMgmtException {
        Trace.methodBegin(this, "getItemList()");
        return this.arrayRegList;
    }

    public void create(ConfigContext context, ArrayRegistration regData) throws ConfigMgmtException {
        String methodName = "create";
        Trace.methodBegin(this, methodName);
        String ip = regData.getIPAddress();
        String pw = regData.getPassword();
        boolean persist = regData.getPersistPassword();
        this.createArrayRegistration(context, ip, pw, persist);
    }

    public void save(ConfigContext context, ArrayRegistration arrayReg) throws ConfigMgmtException {
        String methodName = "save";
        Trace.methodBegin(this, methodName);
        Trace.verbose((Object)this, methodName, "Trying to save array reg: " + arrayReg.toString());
        if (this.handle == null) {
            Trace.verbose((Object)this, methodName, "Handle is null, trying to get handle from config context");
            this.handle = context.getClient();
        }
        try {
            CIMInstance acctInstance = this.handle.getInstance(arrayReg.getObjectPath(), false, true, false, ACCT_PROPERTIES);
            if (accountPropMapList == null) {
                accountPropMapList = (ArrayList)this.generateAccountMapElements();
            }
            CIMObjectWrapper.save(arrayReg, accountPropMapList, acctInstance, this.handle);
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, methodName, "Failed: " + cme.getMessage());
            throw cme;
        }
        Trace.verbose((Object)this, methodName, "Object saved: " + arrayReg.toString());
    }

    public void remove(ConfigContext context, ArrayRegistration arrayReg) throws ConfigMgmtException {
        String methodName = "remove";
        Trace.methodBegin(this, methodName);
        Trace.verbose((Object)this, methodName, "Trying to remove array reg = " + arrayReg.toString());
        try {
            if (this.handle == null) {
                Trace.verbose((Object)this, methodName, "Handle is null, trying to get handle from config context");
                this.handle = context.getClient();
            }
            this.handle.deleteInstance(arrayReg.getObjectPath());
            Trace.verbose((Object)this, methodName, "ArrayRegistration successfully removed.");
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, methodName, "Failed: " + cme.getMessage());
            throw cme;
        }
    }

    public int changePassword(ConfigContext context, ArrayRegistration array, String newPassword) throws ConfigMgmtException {
        String methodName = "changePassword";
        Trace.methodBegin(this, methodName);
        try {
            if (this.handle == null) {
                Trace.verbose((Object)this, methodName, "Handle is null, trying to get handle from config context");
                this.handle = context.getClient();
            }
            CIMArgument[] inArgs = new CIMArgument[]{new CIMArgument("newPassword", new CIMValue((Object)newPassword))};
            Trace.verbose((Object)this, methodName, "Arguments created.");
            CIMValue returnValue = this.handle.invokeMethod(array.getObjectPath(), "setPassword", inArgs, null);
            Trace.verbose((Object)this, methodName, "setPassword method invoked.");
            int result = (Integer)returnValue.getValue();
            Trace.verbose((Object)this, methodName, "Result of password change: " + result);
            return result;
        }
        catch (NullPointerException npe) {
            Trace.verbose((Object)this, methodName, "Null value returned.");
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - Returned value is  null in changePassword method.", npe);
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, methodName, "Failed: " + cme.getMessage());
            throw cme;
        }
    }

    public void reload() throws ConfigMgmtException {
        Trace.methodBegin(this, "reload");
        Trace.verbose((Object)this, "reload", "Reload method is called to reloads the Array Registration data");
    }

    public void reload(ArrayRegistration ar) throws ConfigMgmtException {
        String methodName = "reload";
        Trace.methodBegin(this, methodName);
        Trace.verbose((Object)this, methodName, "Reload method is called to reloads the Array Registration data");
        try {
            Trace.verbose((Object)this, methodName, "Getting a new Account CIMInstance!!");
            CIMInstance newAcctInstance = this.handle.getInstance(ar.getObjectPath(), false, true, false, ACCT_PROPERTIES);
            if (accountPropMapList == null) {
                accountPropMapList = (ArrayList)this.generateAccountMapElements();
            }
            CIMObjectWrapper.populate(ar, accountPropMapList, newAcctInstance);
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, methodName, "Failed: " + cme.getMessage());
            throw cme;
        }
    }

    private void loadAccountProperty(CIMInstance acctCimInstance) throws ConfigMgmtException {
        String methodName = "loadAccountProperty";
        Trace.methodBegin(this, methodName);
        ArrayRegistration aReg = new ArrayRegistration();
        aReg.setObjectPath(acctCimInstance.getObjectPath());
        Trace.verbose((Object)this, methodName, "calling methods to load up map elements from Account");
        if (accountPropMapList == null) {
            accountPropMapList = (ArrayList)this.generateAccountMapElements();
        }
        Trace.verbose((Object)this, methodName, "calling populate method to load up the ArrayRegistration object from Account");
        CIMObjectWrapper.populate(aReg, accountPropMapList, acctCimInstance);
        if (Trace.isTraceEnabled(this)) {
            Trace.verbose((Object)this, methodName, "Account prop loaded: " + aReg.toString());
        }
        this.arrayRegList.add(aReg);
        Trace.verbose((Object)this, methodName, "An ArrayReg just added to list");
    }

    private synchronized Collection generateAccountMapElements() {
        String methodName = "generateAccountMapElements";
        Trace.methodBegin(this, methodName);
        ArrayList<MapElement> cimJavaMapElementList = new ArrayList<MapElement>();
        Trace.verbose((Object)this, methodName, "adding CIM Account and ArrayReg prop names mapping to MapElement list!");
        cimJavaMapElementList.add(new MapElement("IPAddress", "Name", true, false));
        cimJavaMapElementList.add(new MapStringArrayToString("password", "UserPassword", false, true, 0));
        cimJavaMapElementList.add(new MapElement("persistPassword", "PersistPassword", false, false));
        cimJavaMapElementList.add(new MapElement("healthStatus", "OperationalStatus", true, false, 0));
        Trace.verbose((Object)this, methodName, "ArrayReg map element list from Account contains " + cimJavaMapElementList.size() + " properties");
        if (Trace.isTraceEnabled(this)) {
            for (int j = 0; j < cimJavaMapElementList.size(); ++j) {
                Trace.verbose((Object)this, methodName, "Java property: " + ((MapElement)cimJavaMapElementList.get(j)).getJavaField());
                Trace.verbose((Object)this, methodName, "cim property: " + ((MapElement)cimJavaMapElementList.get(j)).getCimProperty());
                Trace.verbose((Object)this, methodName, "isReadOnly? " + ((MapElement)cimJavaMapElementList.get(j)).isReadOnly());
                Trace.verbose((Object)this, methodName, "************************");
            }
        }
        return cimJavaMapElementList;
    }

    private void createArrayRegistration(ConfigContext context, String ipAddress, String rootPassword, boolean persist) throws ConfigMgmtException {
        String methodName = "createArrayRegistration";
        Trace.methodBegin(this, methodName);
        Trace.verbose((Object)this, methodName, "Tyring to create array reg:  IP Addr: " + ipAddress + " persist password: " + persist);
        if (this.handle == null) {
            this.handle = context.getClient();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", ipAddress);
        if (rootPassword == null || "".equals(rootPassword)) {
            Trace.verbose((Object)this, methodName, "rootPassword given is null, set to empty string");
            rootPassword = "";
        }
        Vector<String> passwords = new Vector<String>();
        passwords.add(rootPassword);
        map.put("SystemCreationClassName", "SunStorEdge_6x20ApplicationServer");
        passwords.add(rootPassword);
        map.put("UserPassword", passwords);
        map.put("PersistPassword", new Boolean(persist));
        Vector propVector = CIMObjectWrapper.instanceKeyBuilder(map);
        CIMObjectPath acctPath = CIMObjectWrapper.createInstance(this.handle, propVector, "SunStorEdge_6120Account");
        Trace.verbose((Object)this, methodName, "The CIMObjectPath of created Account: " + acctPath);
        try {
            CIMInstance acctInstance = this.handle.getInstance(acctPath, false, true, false, ACCT_PROPERTIES);
            if (Trace.isTraceEnabled(this)) {
                Trace.verbose((Object)this, methodName, "Got back from CIMOM with instance: " + acctInstance.getObjectPath());
            }
            this.buildArrayRegistration(acctInstance, acctPath);
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, methodName, "Failed: " + cme.getMessage());
            cme.setExceptionKey("ARRAY_REGISTRATION_CREATE_ERROR");
            throw cme;
        }
    }

    public ArrayRegistration getArrayRegByIP(ConfigContext context, String ipAddress) throws ConfigMgmtException {
        String methodName = "ipAddress";
        Trace.methodBegin(this, methodName);
        Trace.verbose((Object)this, methodName, "Trying to get array reg with ip: " + ipAddress);
        CIMObjectPath path = new CIMObjectPath("SunStorEdge_6120Account");
        Vector<CIMProperty> keys = new Vector<CIMProperty>();
        CIMProperty prop = new CIMProperty("SystemCreationClassName", new CIMValue((Object)"SunStorEdge_6x20ApplicationServer"));
        keys.addElement(prop);
        prop = new CIMProperty("CreationClassName", new CIMValue((Object)"SunStorEdge_6120Account"));
        keys.addElement(prop);
        prop = new CIMProperty("Name", new CIMValue((Object)ipAddress));
        keys.addElement(prop);
        path.setKeys(keys);
        Trace.verbose((Object)this, methodName, "Object path built = " + path);
        if (this.handle == null) {
            this.handle = context.getClient();
        }
        try {
            CIMInstance acctInstance = this.handle.getInstance(path, false, true, false, ACCT_PROPERTIES);
            if (Trace.isTraceEnabled(this)) {
                Trace.verbose((Object)this, methodName, "Got back from CIMOM with instance: " + acctInstance.getObjectPath());
            }
            return this.buildArrayRegistration(acctInstance, path);
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, methodName, "Failed: " + cme.getMessage());
            cme.setExceptionKey("ARRAY_REGISTRATION_FIND_ERROR");
            throw cme;
        }
    }

    private ArrayRegistration buildArrayRegistration(CIMInstance account, CIMObjectPath path) throws ConfigMgmtException {
        String methodName = "buildArrayRegistration";
        Trace.methodBegin(this, methodName);
        ArrayRegistration ar = new ArrayRegistration();
        try {
            ar.setObjectPath(path);
            if (accountPropMapList == null) {
                accountPropMapList = (ArrayList)this.generateAccountMapElements();
            }
            Trace.verbose((Object)this, methodName, "calling populate method to load up the ArrayRegistration object");
            CIMObjectWrapper.populate(ar, accountPropMapList, account);
            Trace.verbose((Object)this, methodName, "ArrayRegistration build: " + ar.toString());
        }
        catch (ConfigMgmtException cme) {
            Trace.verbose((Object)this, methodName, (Throwable)cme);
            throw new ConfigMgmtException("ARRAY_REGISTRATION_CREATE_ERROR", "Rethrown ConfigMgmtException in createArrayRegistration.", cme);
        }
        return ar;
    }
}

