/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.admin.business.impl.mr3;

import com.sun.netstorage.array.mgmt.cfg.admin.business.GeneralAdminInterface;
import com.sun.netstorage.array.mgmt.cfg.admin.business.impl.mr3.ComputerSystem;
import com.sun.netstorage.array.mgmt.cfg.admin.business.impl.mr3.PhysicalPackage;
import com.sun.netstorage.array.mgmt.cfg.admin.business.impl.mr3.PowerSupply;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Constants;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageT4sFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageT4sInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.T4Interface;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class GeneralAdmin
implements GeneralAdminInterface,
Constants.ComputerSystemProperties {
    private ConfigContext configContext;
    private PhysicalPackage physicalPackage;
    private ComputerSystem computerSystem;
    private PowerSupply powerSupply;

    public void fullShutDown() throws ConfigMgmtException {
        Trace.methodBegin(this, "fullShutDown");
        this.makeT4sDormant();
        this.computerSystem.setOperationalStatus(new Integer(15));
        this.computerSystem.savePower();
    }

    private void makeT4sDormant() throws ConfigMgmtException {
        Trace.methodBegin(this, "makeT4sDormant");
        Iterator iterator = this.getT4Collection().iterator();
        while (iterator.hasNext()) {
            T4Interface t4 = (T4Interface)iterator.next();
            t4.shutdown();
        }
    }

    private void makeT4sLive() throws ConfigMgmtException {
        Trace.methodBegin(this, "makeT4sLive");
        Iterator iterator = this.getT4Collection().iterator();
        while (iterator.hasNext()) {
            T4Interface t4 = (T4Interface)iterator.next();
            t4.powerUp();
        }
    }

    private Collection getT4Collection() throws ConfigMgmtException {
        Trace.methodBegin(this, "getT4Collection");
        ManageT4sInterface manageT4s = ManageT4sFactory.getManager();
        manageT4s.init(this.configContext, null);
        List collection = manageT4s.getItemList();
        return collection;
    }

    public void partialShutdown() throws ConfigMgmtException {
        Trace.methodBegin(this, "partialShutdown");
        if (!this.powerSupply.isAvailable()) {
            throw new ConfigMgmtException("partial.shutdown.no.power.supply", "Partial Shutdown Called with no power supply object available");
        }
        this.makeT4sDormant();
        this.powerSupply.setOperationalStatus(new Integer(15));
        this.powerSupply.save();
    }

    public void startUp() throws ConfigMgmtException {
        Trace.methodBegin(this, "startUp");
        this.powerSupply.setOperationalStatus(new Integer(2));
        this.powerSupply.save();
        this.makeT4sLive();
    }

    public void save() throws ConfigMgmtException {
        Trace.methodBegin(this, "save");
        this.getComputerSystem().save();
    }

    public void init(ConfigContext configContext) throws ConfigMgmtException {
        Trace.methodBegin(this, "init");
        this.configContext = configContext;
        this.physicalPackage = new PhysicalPackage(configContext);
        this.computerSystem = new ComputerSystem(configContext);
        this.powerSupply = new PowerSupply(configContext);
    }

    public ComputerSystem getComputerSystem() {
        return this.computerSystem;
    }

    public PhysicalPackage getPhysicalPackage() {
        return this.physicalPackage;
    }

    public String getContactEmail() {
        return this.getComputerSystem().getContactEmail();
    }

    public String getDescription() {
        return this.getComputerSystem().getDescription();
    }

    public String getHostName() {
        return this.getComputerSystem().getHostName();
    }

    public String getMaseratiId() {
        return this.getComputerSystem().getMaseratiId();
    }

    public String getModel() {
        return this.getPhysicalPackage().getModel();
    }

    public String getVendor() {
        return this.getPhysicalPackage().getVendor();
    }

    public void setContactEmail(String contactEmail) {
        this.getComputerSystem().setContactEmail(contactEmail);
    }

    public void setDescription(String description) {
        this.getComputerSystem().setDescription(description);
    }

    public void setMaseratiId(String masaratiId) {
        this.getComputerSystem().setMaseratiId(masaratiId);
    }

    public int getStatus() {
        Trace.methodBegin(this, "getStatus");
        if (this.powerSupply.isAvailable()) {
            Trace.verbose((Object)this, "getStatus", "Power supply is available, status is " + this.powerSupply.getOperationalStatus());
            switch (this.powerSupply.getOperationalStatus()) {
                case 2: {
                    return 2;
                }
                case 15: {
                    return 1;
                }
                case 0: {
                    return 4;
                }
                case 13: {
                    return 4;
                }
            }
            return 4;
        }
        Trace.verbose((Object)this, "getStatus", "Power supply is NOT available, oper status is " + this.computerSystem.getOperationalStatus());
        switch (this.computerSystem.getOperationalStatus()) {
            case 2: {
                return 2;
            }
            case 15: {
                return 1;
            }
        }
        return 3;
    }

    public void reload() throws ConfigMgmtException {
        this.init(this.configContext);
    }

    public void setMaseratiId(Integer masaratiId) {
        this.setMaseratiId(masaratiId.toString());
    }

    public boolean isPartialShutdownAvailable() {
        return this.powerSupply.isAvailable();
    }

    void setComputerSystem(ComputerSystem computerSystem) {
        this.computerSystem = computerSystem;
    }

    void setPhysicalPackage(PhysicalPackage physicalPackage) {
        this.physicalPackage = physicalPackage;
    }

    void setPowerSupply(PowerSupply powerSupply) {
        this.powerSupply = powerSupply;
    }
}

