/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.admin.business.impl.mr3;

import com.sun.netstorage.array.mgmt.cfg.admin.business.FirewallRuleInterface;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Constants;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.impl.CIMObjectWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.impl.MapElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;

public class EntryInFilterList
implements FirewallRuleInterface,
Constants.MR3ObjectNames,
Constants.FirewallPortServices,
Constants.FilterEntryProperties,
Constants.AssociationPropertyNames {
    private ConfigContext configContext;
    private boolean enabled = false;
    private Boolean openPortOnSave;
    private String direction;
    private String serviceName;
    private int port;
    private boolean readOnly;
    private CIMObjectPath associationPath;
    static /* synthetic */ Class class$com$sun$netstorage$array$mgmt$cfg$admin$business$impl$mr3$EntryInFilterList;

    public EntryInFilterList(ConfigContext configContext, String serviceName, String direction, int port, boolean open) {
        this.configContext = configContext;
        this.direction = direction;
        this.serviceName = serviceName;
        this.port = port;
        this.enabled = open;
    }

    public EntryInFilterList(ConfigContext configContext) {
        Trace.constructor(this);
        this.configContext = configContext;
    }

    public void populate(CIMInstance instance) throws ConfigMgmtException {
        Trace.methodBegin(this, "populate");
        CIMObjectWrapper.populate(this, this.getFieldMap(), instance);
    }

    public ConfigContext getConfigContext() {
        return this.configContext;
    }

    private void openPort() throws ConfigMgmtException {
        Trace.methodBegin(this, "closePort");
        String objectClass = "SunStorEdge_6x20EntriesInFilterList";
        CIMObjectPath cop = new CIMObjectPath(objectClass);
        CIMClass theClass = this.getConfigContext().getClient().getClass(cop, false, false, false, null);
        CIMInstance associationInstance = theClass.newInstance();
        try {
            associationInstance.setProperty("GroupComponent", new CIMValue((Object)EntryInFilterList.createFilterListObjectPath(this.getDirection())));
            associationInstance.setProperty("PartComponent", new CIMValue((Object)this.createFilterEntryObjectPath()));
        }
        catch (CIMException ce) {
            Trace.verbose((Object)this, "openPort", "Set Property Failed.");
            throw new ConfigMgmtException("CIM_SET_PROPERTY_FAILED", "Set Property Failed.", (Exception)((Object)ce));
        }
        Trace.verbose((Object)this, "activate", " new association instance  is " + associationInstance);
        CIMObjectPath result = this.getConfigContext().getClient().createInstance(cop, associationInstance);
        Trace.verbose((Object)this, "activate", " result of create is " + result);
    }

    private void closePort() throws ConfigMgmtException {
        Trace.methodBegin(this, "deactivate");
        this.getConfigContext().getClient().deleteInstance(this.getAssociationPath());
    }

    public CIMObjectPath getAssociationPath() {
        Trace.methodBegin(this, "getAssociationPath");
        if (null == this.associationPath) {
            this.associationPath = this.createAssociationObjectPath();
        }
        return this.associationPath;
    }

    public String getDirection() {
        return this.direction;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public boolean isOpen() {
        return this.enabled;
    }

    public void setOpen(boolean open) {
        Trace.verbose((Object)this, "setOpen", "Open = " + open);
        this.openPortOnSave = new Boolean(open);
    }

    public void save() throws ConfigMgmtException {
        Trace.methodBegin(this, "save");
        if (null == this.openPortOnSave) {
            return;
        }
        try {
            if (this.isReadOnly()) {
                Trace.error((Object)this, "save", "Attempting save on read only filter: " + this.getServiceName());
                throw new ConfigMgmtException("CIM_ERR_ACCESS_DENIED", "CIM_ERR_ACCESS_DENIED");
            }
            boolean openPort = this.openPortOnSave;
            Trace.verbose((Object)this, "save", "openPortOnSave =" + openPort);
            if (this.enabled == openPort) {
                Trace.verbose((Object)this, "save", "No work to perform since state is already as requested.");
                return;
            }
            if (openPort) {
                this.openPort();
            } else {
                this.closePort();
            }
            this.enabled = openPort;
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "save", cme);
            throw cme;
        }
    }

    private CIMObjectPath createAssociationObjectPath() {
        Trace.methodBegin(this, "createAssociationObjectPath");
        CIMObjectPath path = new CIMObjectPath("SunStorEdge_6x20EntriesInFilterList");
        Vector<CIMProperty> keys = new Vector<CIMProperty>();
        keys.addElement(this.createFilterListProperty());
        keys.addElement(this.createFilterEntryProperty());
        path.setKeys(keys);
        return path;
    }

    private CIMProperty createFilterEntryProperty() {
        Trace.methodBegin(this, "createFilterEntryProperty");
        return new CIMProperty("PartComponent", new CIMValue((Object)this.createFilterEntryObjectPath()));
    }

    private CIMProperty createFilterListProperty() {
        Trace.methodBegin(this, "createFilterListProperty");
        return new CIMProperty("GroupComponent", new CIMValue((Object)EntryInFilterList.createFilterListObjectPath(this.getDirection())));
    }

    public static CIMObjectPath createFilterListObjectPath(String direction) {
        Trace.methodBegin(class$com$sun$netstorage$array$mgmt$cfg$admin$business$impl$mr3$EntryInFilterList == null ? (class$com$sun$netstorage$array$mgmt$cfg$admin$business$impl$mr3$EntryInFilterList = EntryInFilterList.class$("com.sun.netstorage.array.mgmt.cfg.admin.business.impl.mr3.EntryInFilterList")) : class$com$sun$netstorage$array$mgmt$cfg$admin$business$impl$mr3$EntryInFilterList, "createFilterListObjectPath");
        CIMObjectPath path = new CIMObjectPath("SunStorEdge_6x20FilterList");
        Vector<CIMProperty> keys = new Vector<CIMProperty>();
        CIMProperty prop = new CIMProperty("SystemCreationClassName", new CIMValue((Object)"SunStorEdge_6x20ApplicationServer"));
        keys.addElement(prop);
        prop = new CIMProperty("SystemName", new CIMValue((Object)"1"));
        keys.addElement(prop);
        prop = new CIMProperty("CreationClassName", new CIMValue((Object)"SunStorEdge_6x20FilterList"));
        keys.addElement(prop);
        prop = new CIMProperty("Name", new CIMValue((Object)direction));
        keys.addElement(prop);
        path.setKeys(keys);
        return path;
    }

    private CIMObjectPath createFilterEntryObjectPath() {
        Trace.methodBegin(this, "createFilterEntryObjectPath");
        CIMObjectPath path = new CIMObjectPath("SunStorEdge_6x20IPHeadersFilter");
        Vector<CIMProperty> keys = new Vector<CIMProperty>();
        CIMProperty prop = new CIMProperty("SystemCreationClassName", new CIMValue((Object)"SunStorEdge_6x20ApplicationServer"));
        keys.addElement(prop);
        prop = new CIMProperty("SystemName", new CIMValue((Object)"1"));
        keys.addElement(prop);
        prop = new CIMProperty("CreationClassName", new CIMValue((Object)"SunStorEdge_6x20IPHeadersFilter"));
        keys.addElement(prop);
        prop = new CIMProperty("Name", new CIMValue((Object)this.getServiceName()));
        keys.addElement(prop);
        path.setKeys(keys);
        return path;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setDirection(String direction) {
        this.direction = direction;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    private List getFieldMap() {
        ArrayList<MapElement> elements = new ArrayList<MapElement>();
        elements.add(new MapElement("serviceName", "Name", true, false));
        elements.add(new MapElement("port", "HdrSrcPortStart", true, false));
        elements.add(new MapElement("readOnly", "ReadOnly", true, false));
        elements.add(new MapElement("direction", "Direction", true, false));
        return elements;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

