/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.admin.business;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class Role {
    private String key;
    private static Map allRoleMap = new HashMap();
    private static Map unmodifiableRoleMap;
    public static final String PREFIX = "admin.role.";
    public static final Role GUEST;
    public static final Role ADMIN;
    public static final Role STORAGE;
    public static final Role ROOT;

    public static Map getAllRoles() {
        if (null == unmodifiableRoleMap) {
            unmodifiableRoleMap = Collections.unmodifiableMap(allRoleMap);
        }
        return unmodifiableRoleMap;
    }

    public static Role forShortKey(String shortKey) {
        return (Role)Role.getAllRoles().get(PREFIX + shortKey);
    }

    public static Role forKey(String key) {
        return (Role)Role.getAllRoles().get(key);
    }

    private Role(String key) {
        this.key = PREFIX + key;
        allRoleMap.put(this.key, this);
    }

    public String getKey() {
        return this.key;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Role) {
            return this.getKey().equals(((Role)obj).getKey());
        }
        return false;
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }

    public String toString() {
        return this.key.substring(PREFIX.length());
    }

    static {
        GUEST = new Role("guest");
        ADMIN = new Role("admin");
        STORAGE = new Role("storage");
        ROOT = new Role("root");
    }
}

