/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.access.business.impl.oz;

import com.sun.netstorage.array.mgmt.cfg.access.business.ManageHostPortsInterface;
import com.sun.netstorage.array.mgmt.cfg.access.business.impl.oz.HostPort;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.ErrorCode;
import com.sun.netstorage.array.mgmt.cfg.core.ErrorDescriptor;
import com.sun.netstorage.array.mgmt.cfg.core.ManagerInterface;
import com.sun.netstorage.array.mgmt.cfg.core.MethodCallStatus;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.BadParameterException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.SEItemNotFoundException;
import com.sun.netstorage.array.mgmt.cfg.core.impl.ObjectBundleManager;
import com.sun.netstorage.array.mgmt.cfg.core.impl.oz.CommandProcessor;
import com.sun.netstorage.array.mgmt.cfg.core.impl.oz.OZErrorCode;
import com.sun.netstorage.array.mgmt.cfg.core.logic.Scope;
import com.sun.netstorage.array.mgmt.cfg.core.logic.SearchFilter;
import com.sun.netstorage.array.mgmt.cfg.util.Convert;
import com.sun.netstorage.array.mgmt.logger.LogAPI;
import devmgr.versioned.jrpc.RPCError;
import devmgr.versioned.jrpc.XDRType;
import devmgr.versioned.symbol.Host;
import devmgr.versioned.symbol.HostPortCreationDescriptor;
import devmgr.versioned.symbol.HostPortName;
import devmgr.versioned.symbol.HostPortRenameDescriptor;
import devmgr.versioned.symbol.HostPortTypeUpdateDescriptor;
import devmgr.versioned.symbol.ObjectBundle;
import devmgr.versioned.symbol.ReturnCode;
import devmgr.versioned.symbol.ReturnCodeWithRef;
import devmgr.versioned.symbol.SYMbolRef;
import devmgr.versioned.symbol.SYMbolRefPair;
import devmgr.versioned.symbol.UnicodeTranslator;
import devmgr.versioned.symbol.UnlabeledHostPorts;
import devmgr.versioned.symbol.UserAssignedLabel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

public class ManageHostPorts
implements ManageHostPortsInterface {
    ConfigContext cfgctx;
    Scope scope;
    SearchFilter filter;
    static final String UNKNOWN_NAME = "name.unknown";
    static final int MAX_HOST_PORTS = 256;

    public void create(Properties props) throws ConfigMgmtException, SEItemNotFoundException {
        Trace.methodBegin(this, "create");
        this.validateProps(props);
        String arrayKey = Convert.scopeToArrayKey(this.scope);
        String newHP = (String)props.get("name");
        String wwn = (String)props.get("wwn");
        String hostName = (String)props.get("hostName");
        String hostPortType = (String)props.get("hostOSType");
        String dotWWN = wwn;
        wwn = wwn.replaceAll("\\:", "").trim();
        try {
            ObjectBundleManager.getInstance().stopMonitoringThread(arrayKey);
            CommandProcessor command = new CommandProcessor(arrayKey);
            ObjectBundle bundle = new ObjectBundle();
            command.execute(40, null, (XDRType)bundle, false);
            Host host = this.getHostContainer(hostName, bundle);
            if (host == null) {
                throw new SEItemNotFoundException((String)props.get("hostName"));
            }
            HostPortName hpn = this.getHostPortName(wwn);
            UserAssignedLabel ual = new UserAssignedLabel();
            ual.setValue(UnicodeTranslator.getBytes((String)newHP));
            this.createNewHostPort(hostPortType, command, host, hpn, ual);
            LogAPI.staticLog((String)"INITIATOR_CREATE_SUCCESS", (String[])new String[]{newHP}, (String[])new String[0]);
        }
        catch (RPCError e) {
            LogAPI.staticLog((String)"INITIATOR_CREATE_ERROR", (String[])new String[]{newHP}, (String[])new String[0]);
            Trace.error((Object)this, "create", (Throwable)e);
            throw new ConfigMgmtException(ErrorCode.ERROR_RPC.getKey(), e.getMessage(), (Exception)((Object)e));
        }
        catch (IOException e) {
            LogAPI.staticLog((String)"INITIATOR_CREATE_ERROR", (String[])new String[]{newHP}, (String[])new String[0]);
            Trace.error((Object)this, "create", (Throwable)e);
            throw new ConfigMgmtException(ErrorCode.ERROR_COMMUNICATING_WITH_ARRAY.getKey(), e.getMessage(), e);
        }
        catch (NumberFormatException nfe) {
            Trace.verbose((Object)this, "create", "Error converting wwn - bad entry");
            throw new BadParameterException(wwn, ErrorCode.INVALID_WWN.getKey());
        }
        finally {
            ObjectBundleManager.getInstance().forceBundleReload(arrayKey);
        }
        Trace.verbose((Object)this, "create", "Create completed");
    }

    private void createNewHostPort(String hostPortType, CommandProcessor command, Host host, HostPortName hpn, UserAssignedLabel ual) throws RPCError, IOException, ConfigMgmtException {
        HostPortCreationDescriptor hpcd = new HostPortCreationDescriptor();
        hpcd.setLabel(ual);
        hpcd.setHostRef(host.getHostRef());
        hpcd.setHostPortName(hpn);
        hpcd.setHostPortTypeIndex(Integer.parseInt(hostPortType));
        ReturnCodeWithRef rcr = new ReturnCodeWithRef();
        command.execute(73, (XDRType)hpcd, (XDRType)rcr, true);
        Trace.verbose((Object)this, "create", "Return code:" + rcr.getReturnCode().getValue());
        if (rcr.getReturnCode().getValue() != 1) {
            throw new ConfigMgmtException("error.reason." + (OZErrorCode.ERROR_CODE_MIN + rcr.getReturnCode().getValue()), "Create failed");
        }
    }

    private void modifyHostPortAttributes(CommandProcessor command, devmgr.versioned.symbol.HostPort hp, String wwn, String oldHostPortName, String newHostPortName, String oldHostName, String newHostName, String oldHostPortType, String newHostPortType, boolean unlabeled) throws RPCError, IOException, ConfigMgmtException {
        String methodName = "modifyHostPortAttributes";
        Trace.methodBegin(this, "modifyHostPortAttributes");
        if (newHostPortName != null && !newHostPortName.equals(oldHostPortName)) {
            Trace.verbose((Object)this, "modifyHostPortAttributes", "Set initiator name to:" + newHostPortName);
            hp = this.modifyHostPortName(command, wwn, oldHostPortName, newHostPortName, hp);
        }
        Trace.verbose((Object)this, "modifyHostPortAttributes", "Found modified host port");
        if (newHostName != null && !newHostName.equals(oldHostName)) {
            hp = this.moveHostPort(command, wwn, newHostName, hp);
        }
        if (newHostPortType != oldHostPortType && !newHostPortType.equals(oldHostPortType)) {
            this.updateHostPortType(command, newHostPortType, hp);
        }
    }

    private void updateHostPortType(CommandProcessor command, String newHostPortType, devmgr.versioned.symbol.HostPort hp) throws ConfigMgmtException, RPCError, IOException, SEItemNotFoundException {
        String methodName = "updateHostPortType";
        HostPortTypeUpdateDescriptor hptud = new HostPortTypeUpdateDescriptor();
        if (hp == null) {
            Trace.error((Object)this, "updateHostPortType", "Cannot find host port that was renamed?");
            throw new SEItemNotFoundException("null");
        }
        hptud.setHostPortRef(hp.getHostPortRef());
        hptud.setHostPortTypeIndex(Integer.parseInt(newHostPortType));
        ReturnCode rc = new ReturnCode();
        command.execute(80, (XDRType)hptud, (XDRType)rc, true);
        if (rc.getValue() != 1) {
            Trace.error((Object)this, "updateHostPortType", "Error moving host port to host. Error code:" + rc.getValue());
            throw new ConfigMgmtException("error.reason." + (OZErrorCode.ERROR_CODE_MIN + rc.getValue()), "Modify host port failed");
        }
    }

    private devmgr.versioned.symbol.HostPort moveHostPort(CommandProcessor command, String wwn, String newHostName, devmgr.versioned.symbol.HostPort hp) throws RPCError, IOException, SEItemNotFoundException, ConfigMgmtException {
        String methodName = "moveHostPort";
        if (hp == null) {
            Trace.error((Object)this, "moveHostPort", "Cannot find host port");
            throw new SEItemNotFoundException("null");
        }
        ObjectBundle bundle = new ObjectBundle();
        command.execute(40, null, (XDRType)bundle, false);
        Host host = this.getHostContainer(newHostName, bundle);
        if (host == null) {
            throw new SEItemNotFoundException(newHostName);
        }
        SYMbolRefPair srp = new SYMbolRefPair();
        srp.setItemRef((SYMbolRef)hp.getHostPortRef());
        srp.setContainerRef((SYMbolRef)host.getHostRef());
        ReturnCode rc = new ReturnCode();
        command.execute(76, (XDRType)srp, (XDRType)rc, true);
        if (rc.getValue() != 1) {
            Trace.error((Object)this, "moveHostPort", "Error moving host port to host. Error code:" + rc.getValue());
            throw new ConfigMgmtException("error.reason." + (OZErrorCode.ERROR_CODE_MIN + rc.getValue()), "Modify host port failed");
        }
        command.execute(40, null, (XDRType)bundle, false);
        hp = this.findHostPort(bundle, wwn);
        return hp;
    }

    private devmgr.versioned.symbol.HostPort modifyHostPortName(CommandProcessor command, String wwn, String oldHostPortName, String newHostPortName, devmgr.versioned.symbol.HostPort hp) throws ConfigMgmtException, SEItemNotFoundException, RPCError, IOException {
        String methodName = "modifyHostPortName";
        Trace.methodBegin(this, "modifyHostPortName");
        if (hp != null) {
            HostPortRenameDescriptor hprd = new HostPortRenameDescriptor();
            hprd.setHostPortName(this.getHostPortName(wwn));
            hprd.setHostPortRef(hp.getHostPortRef());
            UserAssignedLabel ual = new UserAssignedLabel();
            ual.setValue(UnicodeTranslator.getBytes((String)newHostPortName));
            hprd.setLabel(ual);
            ReturnCode rc = new ReturnCode();
            command.execute(75, (XDRType)hprd, (XDRType)rc, true);
            if (rc.getValue() != 1) {
                Trace.error((Object)this, "modifyHostPortName", "Error renaming host port. Error code:" + rc.getValue());
                throw new ConfigMgmtException("error.reason." + (OZErrorCode.ERROR_CODE_MIN + rc.getValue()), "Modify host port name failed");
            }
        } else {
            Trace.verbose((Object)this, "modifyHostPortName", "host port is null?");
            throw new SEItemNotFoundException(oldHostPortName);
        }
        Trace.verbose((Object)this, "modifyHostPortName", "HostPort name modified");
        ObjectBundle bundle = new ObjectBundle();
        command.execute(40, null, (XDRType)bundle, false);
        Trace.verbose((Object)this, "modifyHostPortName", "Find modified...");
        hp = this.findHostPort(bundle, wwn);
        return hp;
    }

    private devmgr.versioned.symbol.HostPort findHostPort(ObjectBundle bundle, String hpnWWN) throws SEItemNotFoundException {
        String cleanWWN = hpnWWN.replaceAll("\\:", "");
        devmgr.versioned.symbol.HostPort[] hps = bundle.getStoragePoolBundle().getHostPort();
        devmgr.versioned.symbol.HostPort hp = null;
        for (int i = 0; i < hps.length && hp == null; ++i) {
            String name = Convert.bytesToString(hps[i].getHostPortName().getValue()).replaceAll("\\:", "");
            if (!name.equals(cleanWWN)) continue;
            hp = hps[i];
        }
        return hp;
    }

    private HostPortName getHostPortName(String wwn) {
        HostPortName hpn = new HostPortName();
        String cleanWWN = wwn.replaceAll("\\:", "");
        char[] cwwn = cleanWWN.toCharArray();
        byte[] n1 = new byte[8];
        int j = 0;
        for (int i = 0; i < cwwn.length; ++i) {
            n1[j++] = (byte)Integer.decode("0x" + cwwn[i] + cwwn[++i]).intValue();
        }
        hpn.setValue(n1);
        return hpn;
    }

    private Host getHostContainer(String hostName, ObjectBundle bundle) throws RPCError, IOException {
        Host host = null;
        Host[] hosts = bundle.getStoragePoolBundle().getHost();
        int size = hosts == null ? 0 : hosts.length;
        for (int i = 0; i < size && host == null; ++i) {
            String cn = UnicodeTranslator.getString((byte[])hosts[i].getLabel().getValue());
            if (!hostName.equals(cn)) continue;
            host = hosts[i];
        }
        return host;
    }

    public MethodCallStatus delete(List list) throws ConfigMgmtException {
        String methodName = "delete";
        Trace.methodBegin(this, "delete");
        List keyMapList = Convert.listOfStringKeysToMap(list);
        int size = keyMapList == null ? 0 : keyMapList.size();
        MethodCallStatus mcs = new MethodCallStatus();
        String arrayID = Convert.scopeToArrayKey(this.scope);
        if (list == null || list.isEmpty()) {
            throw new ConfigMgmtException(ErrorCode.EMPTY_LIST.getKey(), "Empty list passed in delete method");
        }
        ObjectBundle bundle = ObjectBundleManager.getInstance().getObjectBundle(arrayID);
        String InitiatorName = "";
        try {
            CommandProcessor command = new CommandProcessor(arrayID);
            ObjectBundleManager.getInstance().stopMonitoringThread(arrayID);
            for (int i = 0; i < size; ++i) {
                Map m = (Map)keyMapList.get(i);
                String wwn = (String)m.get("hostPortWWN");
                if (wwn == null) {
                    this.setErrorDescriptor(mcs, m, ErrorDescriptor.ERROR_ITEM_NOT_FOUND, ErrorDescriptor.ERROR_ITEM_NOT_FOUND_KEY);
                    continue;
                }
                devmgr.versioned.symbol.HostPort hp = this.findHostPort(bundle, wwn);
                if (hp != null) {
                    Trace.verbose((Object)this, "delete", "delete");
                    InitiatorName = UnicodeTranslator.getString((byte[])hp.getLabel().getValue());
                    ReturnCode ret = new ReturnCode();
                    command.execute(74, (XDRType)hp.getHostPortRef(), (XDRType)ret, true);
                    if (ret.getValue() != 1) {
                        LogAPI.staticLog((String)"INITIATOR_DELETE_ERROR", (String[])new String[]{InitiatorName}, (String[])new String[0]);
                        Trace.verbose((Object)this, "delete", "Delete failed with error:" + ret.getValue() + " for host port:" + m.get("name"));
                        this.setErrorDescriptor(mcs, m, OZErrorCode.ERROR_CODE_MIN + ret.getValue(), "error.hostPort.delete");
                        continue;
                    }
                    LogAPI.staticLog((String)"INITIATOR_DELETE_SUCCESS", (String[])new String[]{InitiatorName}, (String[])new String[0]);
                    Trace.verbose((Object)this, "delete", "delete successfull for host port:" + m.get("name"));
                    this.setErrorDescriptor(mcs, m, ErrorDescriptor.ERROR_SUCCESS, "success");
                    continue;
                }
                this.setErrorDescriptor(mcs, m, ErrorDescriptor.ERROR_ITEM_NOT_FOUND, ErrorDescriptor.ERROR_ITEM_NOT_FOUND_KEY);
            }
        }
        catch (RPCError e) {
            LogAPI.staticLog((String)"INITIATOR_DELETE_ERROR", (String[])new String[]{InitiatorName}, (String[])new String[0]);
            Trace.error((Object)this, (Throwable)e);
            throw new ConfigMgmtException(ErrorCode.ERROR_RPC.getKey(), "RPC Error:" + e.getMessage());
        }
        catch (IOException e) {
            LogAPI.staticLog((String)"INITIATOR_DELETE_ERROR", (String[])new String[]{InitiatorName}, (String[])new String[0]);
            Trace.error((Object)this, (Throwable)e);
            throw new ConfigMgmtException(ErrorCode.ERROR_COMMUNICATING_WITH_ARRAY.getKey(), "IOException:" + e.getMessage());
        }
        finally {
            ObjectBundleManager.getInstance().forceBundleReload(arrayID);
        }
        return mcs;
    }

    private void setErrorDescriptor(MethodCallStatus mcs, Map m, int ret, String ikey) {
        ErrorDescriptor ed = new ErrorDescriptor();
        ed.setErrorCode(ret);
        ed.setI18nkey(ikey);
        String[] params = new String[]{(String)m.get("hostPortWWN")};
        ed.setI18nParams(params);
        ed.setMsg("Failed to delete initiator:" + params[0]);
        mcs.addErrorDescriptor(ed);
    }

    public int getMaxObjects() {
        return 256;
    }

    public void init(ConfigContext ctx, Scope s, SearchFilter f) throws ConfigMgmtException {
        this.cfgctx = ctx;
        this.scope = s;
        this.filter = f;
    }

    public List getItemList() throws ConfigMgmtException {
        String methodName = "getItemList";
        ArrayList itemList = new ArrayList();
        Collection bundles = this.getScopedBundles();
        String filterHostName = this.getHostNameFromScope();
        Iterator iter = bundles.iterator();
        while (iter.hasNext()) {
            ObjectBundle bundle = (ObjectBundle)iter.next();
            devmgr.versioned.symbol.HostPort[] ozHostPorts = bundle.getStoragePoolBundle().getHostPort();
            int ozHostsLength = ozHostPorts == null ? 0 : ozHostPorts.length;
            String arrayName = UnicodeTranslator.getString((byte[])bundle.getSa().getSaData().getStorageArrayLabel().getValue());
            String arrayWWN = Convert.bytesToString(bundle.getSa().getSaData().getSaId().getWorldWideName());
            Map hostMap = this.mapHosts(bundle.getStoragePoolBundle().getHost());
            this.createHostPortList(itemList, filterHostName, ozHostPorts, ozHostsLength, arrayName, arrayWWN, hostMap);
        }
        return itemList;
    }

    public List getUnlabeledHostPorts() throws ConfigMgmtException {
        ArrayList itemList = new ArrayList();
        Collection bundles = this.getScopedBundles();
        String filterHostName = this.getHostNameFromScope();
        Iterator iter = bundles.iterator();
        while (iter.hasNext()) {
            ObjectBundle bundle = (ObjectBundle)iter.next();
            String arrayName = UnicodeTranslator.getString((byte[])bundle.getSa().getSaData().getStorageArrayLabel().getValue());
            String arrayWWN = Convert.bytesToString(bundle.getSa().getSaData().getSaId().getWorldWideName());
            try {
                CommandProcessor command = new CommandProcessor(arrayWWN);
                UnlabeledHostPorts uhps = new UnlabeledHostPorts();
                command.execute(79, null, (XDRType)uhps, false);
                devmgr.versioned.symbol.HostPort[] uhp = uhps.getValue();
                int ozHostsLength = uhp == null ? 0 : uhp.length;
                this.createHostPortList(itemList, filterHostName, uhp, ozHostsLength, arrayName, arrayWWN, new HashMap());
            }
            catch (RPCError e) {
                Trace.error((Object)this, (Throwable)e);
                throw new ConfigMgmtException(ErrorCode.ERROR_RPC.getKey(), "RPC Error:" + e.getMessage());
            }
            catch (IOException e) {
                Trace.error((Object)this, (Throwable)e);
                throw new ConfigMgmtException(ErrorCode.ERROR_COMMUNICATING_WITH_ARRAY.getKey(), "IOException:" + e.getMessage());
            }
        }
        return itemList;
    }

    private void createHostPortList(List itemList, String filterHostName, devmgr.versioned.symbol.HostPort[] ozHostPorts, int ozHostsLength, String arrayName, String arrayWWN, Map hostMap) {
        String methodName = "createHostPortList";
        String hostScope = this.getHostScope();
        List osTypeNames = null;
        try {
            osTypeNames = this.getSupportedHostTypes();
        }
        catch (Exception e) {
            Trace.error((Object)this, "createHostPortList", (Throwable)e);
        }
        for (int i = 0; i < ozHostsLength; ++i) {
            HostPort ini = new HostPort();
            ini.setArrayName(arrayName);
            ini.setArrayWWN(arrayWWN);
            int osType = ozHostPorts[i].getHostPortTypeIndex();
            ini.setHostOSType(osType);
            ini.setHostOSTypeName((String)osTypeNames.get(osType));
            Trace.verbose((Object)this, "createHostPortList", "Set OS Type to:" + ini.getHostOSType());
            String hostRef = Convert.bytesToStringRaw(ozHostPorts[i].getHostRef().getRefToken());
            String hostPortRef = Convert.bytesToStringRaw(ozHostPorts[i].getHostPortRef().getRefToken());
            ini.setWwn(Convert.bytesToString(ozHostPorts[i].getHostPortName().getValue()));
            ini.setObjectItemType("initiator");
            Host ozHost = (Host)hostMap.get(hostRef);
            if (ozHost != null && ozHost.getLabel() != null && ozHost.getLabel().getValue() != null) {
                ini.setHostName(UnicodeTranslator.getString((byte[])ozHost.getLabel().getValue()));
            } else {
                ini.setHostName(UNKNOWN_NAME);
            }
            if (!this.isIniInScope(ini, hostScope)) continue;
            if (ozHostPorts[i] != null && ozHostPorts[i].getLabel() != null && ozHostPorts[i].getLabel().getValue() != null) {
                ini.setName(UnicodeTranslator.getString((byte[])ozHostPorts[i].getLabel().getValue()));
            }
            if (ini.getName() == null || ini.getName().trim().equals("")) {
                ini.setName(UNKNOWN_NAME);
            }
            if (!(this.filter == null || this.filter.getSearchField().equals("keyAsString") && this.filter.getSearchString().indexOf(ini.getWwn()) >= 0 || this.filter.getSearchField().equals("name") && this.filter.passesFilter(ini.getName())) && (!this.filter.getSearchField().equals("wwn") || !this.filter.passesFilter(ini.getWwn()))) continue;
            Trace.verbose((Object)this, "createHostPortList", "Filter Passed");
            HashMap<String, String> keyMap = new HashMap<String, String>(2);
            keyMap.put("array", arrayWWN);
            keyMap.put("hostPortWWN", ini.getWwn());
            ini.setKey(keyMap);
            itemList.add(ini);
        }
    }

    private boolean isIniInScope(HostPort ini, String hostScope) {
        return hostScope == null || hostScope.equals(ini.getHostName());
    }

    private String getHostScope() {
        String hostScope = null;
        Object hostScopeKey = this.scope.getAttribute("host");
        if (hostScopeKey != null) {
            hostScope = hostScopeKey instanceof Map ? (String)((Map)hostScopeKey).get("name") : (String)Convert.keyAsStringToMap((String)hostScopeKey).get("name");
        }
        return hostScope;
    }

    private Collection getScopedBundles() throws ConfigMgmtException {
        ArrayList<ObjectBundle> bundles = null;
        if (this.scope != null) {
            String arrayWWN = Convert.scopeToArrayKey(this.scope);
            ArrayList<ObjectBundle> bl = new ArrayList<ObjectBundle>(1);
            ObjectBundle ob = ObjectBundleManager.getInstance().getObjectBundle(arrayWWN);
            bl.add(ob);
            bundles = bl;
        } else {
            bundles = ObjectBundleManager.getInstance().getObjectBundles();
        }
        return bundles;
    }

    private Map mapHosts(Host[] hosts) {
        HashMap<String, Host> groupMap = new HashMap<String, Host>();
        int size = hosts == null ? 0 : hosts.length;
        for (int i = 0; i < size; ++i) {
            String key = Convert.bytesToStringRaw(hosts[i].getHostRef().getRefToken());
            groupMap.put(key, hosts[i]);
        }
        return groupMap;
    }

    private String getHostNameFromScope() {
        String hName = null;
        Object key = this.scope.getAttribute("host");
        if (key != null) {
            Map map = null;
            map = key instanceof Map ? (Map)key : Convert.keyAsStringToMap((String)key);
            hName = (String)map.get("name");
            Trace.verbose((Object)this, "getHostNameFormScope", hName);
        }
        return hName;
    }

    public int getItemCount() throws ConfigMgmtException {
        int numOfItems = 0;
        List il = this.getItemList();
        numOfItems = il == null ? 0 : il.size();
        return numOfItems;
    }

    public boolean isOperationSupported(String operation) {
        return false;
    }

    public void modify(Object key, Properties props) throws ConfigMgmtException {
        String methodName = "modify";
        Trace.methodBegin(this, "modify");
        Map map = null;
        if (key == null) {
            throw new ConfigMgmtException(ErrorCode.ERROR_INCOMPLETE_KEY.getKey(), "Key is required for modify operation");
        }
        map = key instanceof Map ? (Map)key : Convert.keyAsStringToMap((String)key);
        String arrayKey = Convert.scopeToArrayKey(this.scope);
        String newHostPortName = (String)props.get("name");
        String wwn = (String)map.get("hostPortWWN");
        String newHostName = (String)props.get("hostName");
        String newHostPortType = (String)props.get("hostOSType");
        if (arrayKey == null) {
            LogAPI.staticLog((String)"INITIATOR_MODIFY_ERROR", (String[])new String[]{newHostPortName}, (String[])new String[0]);
            throw new ConfigMgmtException(ErrorCode.ERROR_SCOPE_REQUIRED.getKey(), "Scope is required for modify operation");
        }
        if (wwn == null || wwn.trim().length() == 0) {
            LogAPI.staticLog((String)"INITIATOR_MODIFY_ERROR", (String[])new String[]{newHostPortName}, (String[])new String[0]);
            throw new ConfigMgmtException(ErrorCode.ERROR_WWN_REQUIRED.getKey(), "WWN name is a required parameter");
        }
        if (newHostPortType != null && newHostPortType.trim().equals("")) {
            LogAPI.staticLog((String)"INITIATOR_MODIFY_ERROR", (String[])new String[]{newHostPortName}, (String[])new String[0]);
            throw new ConfigMgmtException(ErrorCode.ERROR_HOST_TYPE_REQUIRED.getKey(), "Host type cannot be empty string");
        }
        Trace.verbose((Object)this, "modify", "Modifying initiator with wwn:" + wwn);
        String oldHostPortName = "";
        String oldHostName = "";
        String oldHostPortType = "";
        ObjectBundle bundle = ObjectBundleManager.getInstance().getObjectBundle(arrayKey);
        devmgr.versioned.symbol.HostPort hp = this.findHostPort(bundle, wwn);
        if (hp != null) {
            Trace.verbose((Object)this, "modify", "Host port found");
            byte[] oldVal = hp.getLabel().getValue();
            if (oldVal != null) {
                oldHostPortName = UnicodeTranslator.getString((byte[])oldVal);
            }
            oldHostPortType = "" + hp.getHostPortTypeIndex();
            Map hostMap = this.mapHosts(bundle.getStoragePoolBundle().getHost());
            Host ozHost = (Host)hostMap.get(Convert.bytesToStringRaw(hp.getHostRef().getRefToken()));
            oldHostName = ozHost != null && ozHost.getLabel() != null && ozHost.getLabel().getValue() != null ? UnicodeTranslator.getString((byte[])ozHost.getLabel().getValue()) : UNKNOWN_NAME;
        } else {
            LogAPI.staticLog((String)"INITIATOR_MODIFY_ERROR", (String[])new String[]{newHostPortName}, (String[])new String[0]);
            Trace.verbose((Object)this, "modify", "Host port NOT found");
            throw new SEItemNotFoundException(wwn);
        }
        try {
            CommandProcessor command = new CommandProcessor(arrayKey);
            ObjectBundleManager.getInstance().stopMonitoringThread(arrayKey);
            this.modifyHostPortAttributes(command, hp, wwn, oldHostPortName, newHostPortName, oldHostName, newHostName, oldHostPortType, newHostPortType, false);
            LogAPI.staticLog((String)"INITIATOR_MODIFY_SUCCESS", (String[])new String[]{newHostPortName}, (String[])new String[0]);
        }
        catch (RPCError e) {
            LogAPI.staticLog((String)"INITIATOR_MODIFY_ERROR", (String[])new String[]{newHostPortName}, (String[])new String[0]);
            Trace.error((Object)this, (Throwable)e);
            throw new ConfigMgmtException(ErrorCode.ERROR_RPC.getKey(), e.getMessage());
        }
        catch (IOException e) {
            LogAPI.staticLog((String)"INITIATOR_MODIFY_ERROR", (String[])new String[]{newHostPortName}, (String[])new String[0]);
            Trace.error((Object)this, (Throwable)e);
            throw new ConfigMgmtException(ErrorCode.ERROR_COMMUNICATING_WITH_ARRAY.getKey(), e.getMessage());
        }
        catch (ConfigMgmtException cme) {
            LogAPI.staticLog((String)"INITIATOR_MODIFY_ERROR", (String[])new String[]{newHostPortName}, (String[])new String[0]);
            throw cme;
        }
        finally {
            ObjectBundleManager.getInstance().forceBundleReload(arrayKey);
        }
    }

    private void validateProps(Properties props) throws ConfigMgmtException {
        if (this.scope == null) {
            throw new ConfigMgmtException(ErrorCode.ERROR_SCOPE_REQUIRED.getKey(), "Scope is required for modify operation");
        }
        String arrayKey = Convert.scopeToArrayKey(this.scope);
        String newHP = (String)props.get("name");
        String wwn = (String)props.get("wwn");
        String hostName = (String)props.get("hostName");
        String hostPortType = (String)props.get("hostOSType");
        if (arrayKey == null) {
            throw new ConfigMgmtException(ErrorCode.ERROR_SCOPE_REQUIRED.getKey(), "Scope is required for modify operation");
        }
        if (newHP == null || newHP.trim().length() == 0) {
            throw new ConfigMgmtException(ErrorCode.ERROR_NAME_REQUIRED.getKey(), "Name is a required parameter");
        }
        if (wwn == null || wwn.trim().length() == 0) {
            throw new ConfigMgmtException(ErrorCode.ERROR_WWN_REQUIRED.getKey(), "WWN name is a required parameter");
        }
        wwn = wwn.replaceAll("\\:", "").trim();
        Trace.verbose((Object)this, "validateProps", "WWN:" + wwn);
        if (wwn.toCharArray().length != 16) {
            throw new ConfigMgmtException(ErrorCode.ERROR_WWN_REQUIRED_LENGTH.getKey(), "required length for WWN is 16");
        }
        if (hostName == null || hostName.trim().length() == 0) {
            throw new ConfigMgmtException("host.name.required", "Host name is a required parameter");
        }
        if (hostPortType == null || hostPortType.trim().length() == 0) {
            throw new ConfigMgmtException(ErrorCode.ERROR_HOST_TYPE_REQUIRED.getKey(), "Host type is a required parameter");
        }
    }

    public List getSupportedHostTypes() throws ConfigMgmtException {
        Vector<String> ht = new Vector<String>();
        Collection bundles = this.getScopedBundles();
        if (bundles != null) {
            Iterator it = bundles.iterator();
            ObjectBundle bundle = (ObjectBundle)it.next();
            UserAssignedLabel[] ual = bundle.getSa().getHostPortType();
            int size = ual == null ? 0 : ual.length;
            for (int i = 0; i < size; ++i) {
                Trace.verbose((Object)this, "", UnicodeTranslator.getString((byte[])ual[i].getValue()));
                ht.add("host.type." + UnicodeTranslator.getString((byte[])ual[i].getValue()));
            }
        }
        return ht;
    }

    public static interface SearchType
    extends ManagerInterface.CommonSearchTypes {
        public static final String WWN = "wwn";
    }

    public static interface KeyMap
    extends ManagerInterface.ArrayScope {
        public static final String HOST_PORT_WWN = "hostPortWWN";
        public static final String KEY_NAME = "HostPortKey";
    }

    public static interface ModifyProps {
        public static final String NAME = "name";
        public static final String HOST_NAME = "hostName";
        public static final String HOST_TYPE = "hostOSType";
    }

    public static interface CreateProps {
        public static final String NAME = "name";
        public static final String WWN = "wwn";
        public static final String HOST_NAME = "hostName";
        public static final String HOST_TYPE = "hostOSType";
    }
}

