/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.access.business.impl.mr3;

import com.sun.netstorage.array.mgmt.cfg.access.business.VolumeGroupInterface;
import com.sun.netstorage.array.mgmt.cfg.access.business.impl.mr3.StorageAccessUtil;
import com.sun.netstorage.array.mgmt.cfg.core.CIMOMHandleWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.MultipleMembershipNotAllowed;
import com.sun.netstorage.array.mgmt.cfg.core.impl.CIMObjectWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.impl.MapElement;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageVolumesFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageVolumeInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.mr3.StorageVolume;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.wbem.cim.CIMArgument;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt32;

public class VolumeGroup
implements VolumeGroupInterface {
    private ConfigContext context;
    private CIMOMHandleWrapper handle;
    private String name;
    private String systemName;
    private ArrayList volumes;
    private CIMInstance instance;
    private CIMObjectPath volumeGroupPath;
    private ArrayList fieldMap;
    private String t4Name;
    public static final String[] PROPERTY_NAMES = new String[]{"ElementName", "DefaultGlobalAccess", "DeviceID", "CreationClassName", "SystemCreationClassName", "SystemName", "MaxNumberControlled", "OtherIdentifyingInfo"};

    public void init(ConfigContext context) throws ConfigMgmtException {
        Trace.methodBegin(this, "init");
        this.context = context;
        this.handle = context.getClient();
        this.volumes = new ArrayList();
        if (this.handle == null) {
            Trace.verbose((Object)this, "init", "CIMOMHandleWrapper value is null.");
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "CIMOMHandleWrapper value is null.");
        }
    }

    public void save() throws ConfigMgmtException {
        Trace.methodBegin(this, "save");
    }

    public void delete() throws ConfigMgmtException {
        Trace.methodBegin(this, "delete");
        try {
            CIMArgument[] inArgs = new CIMArgument[]{new CIMArgument("Controller", new CIMValue((Object)this.getInstance().getObjectPath()))};
            CIMValue returnValue = this.handle.invokeMethod(this.getPortSCSIControllerPath(), "DeleteViewWithCleanup", inArgs, null);
            int result = ((UnsignedInt32)returnValue.getValue()).intValue();
            if (result != 0) {
                Trace.verbose((Object)this, "delete", "Return code for DeleteViewWithCleanup() method is not success, it is " + result);
                throw new ConfigMgmtException("EXTRINSIC_CIM_METHOD_EXCEPTION", "Return code for DeleteViewWithCleanup() method is not success, it is " + result);
            }
        }
        catch (NullPointerException npe) {
            Trace.verbose((Object)this, "delete", "Returned value is null when deleting the VolumeGroup." + npe);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - Returned value is  null in delete VolumeGroup method.", npe);
        }
        catch (ConfigMgmtException cme) {
            cme.addExceptionContext(this);
            Trace.error((Object)this, "delete", "Failed delete--current state: " + this.toString());
            throw cme;
        }
    }

    private CIMObjectPath getPortSCSIControllerPath() throws ConfigMgmtException {
        Trace.methodBegin(this, "getPortSCSIControllerPath");
        try {
            Enumeration enumeration = CIMObjectWrapper.execQuery(this.handle, "Select * from SunStorEdge_6120PortSCSIController where SystemName = '" + this.systemName + "'");
            if (enumeration != null && enumeration.hasMoreElements()) {
                CIMObjectPath controllerPath = ((CIMInstance)enumeration.nextElement()).getObjectPath();
                if (Trace.isTraceEnabled(this)) {
                    Trace.verbose((Object)this, "getPortSCSIControllerPath", "PortSCSIController object path is: " + controllerPath);
                }
                return controllerPath;
            }
            Trace.verbose((Object)this, "getPortSCSIControllerPath", "No enumeration returned when trying to obtain PortSCSIController.");
            throw new ConfigMgmtException("ZERO_CIM_INSTANCE_RETURNED", "No enumeration returned when trying to obtain PortSCSIController.");
        }
        catch (ConfigMgmtException cme) {
            cme.addExceptionContext(this);
            Trace.error((Object)this, "getPortSCSIControllerPath", "Failed--current state: " + this.toString());
            throw cme;
        }
    }

    public void reload() throws ConfigMgmtException {
        Trace.methodBegin(this, "reload");
        CIMInstance ci = this.handle.getInstance(this.volumeGroupPath, false, true, false, PROPERTY_NAMES);
        Trace.verbose((Object)this, "reload", "Object path of the fresh CIMInstance: " + ci.getObjectPath());
        this.setInstance(ci);
        CIMObjectWrapper.populate(this, this.getFieldMap(), ci);
        this.volumes = new ArrayList();
        this.t4Name = null;
        Trace.verbose((Object)this, "reload", "Object reloaded: " + this.toString());
    }

    public String getName() {
        return this.name;
    }

    public List getVolumes() throws ConfigMgmtException {
        Trace.methodBegin(this, "getVolumes");
        if (this.instance != null) {
            this.volumes = new ArrayList();
            try {
                Enumeration enumeration = this.handle.associators(this.instance.getObjectPath(), "SunStorEdge_6120MappedProtocolControllerForUnit", "SunStorEdge_6120StorageVolume", "Antecedent", "Dependent", true, false, StorageVolume.PROPERTY_NAMES);
                if (enumeration != null && enumeration.hasMoreElements()) {
                    while (enumeration.hasMoreElements()) {
                        CIMInstance ci = (CIMInstance)enumeration.nextElement();
                        StorageVolume sv = new StorageVolume();
                        sv.init(this.context);
                        sv.setInstance(ci);
                        CIMObjectWrapper.populate(sv, sv.getFieldMap(), ci);
                        this.volumes.add(sv);
                        Trace.verbose((Object)this, "getVolumes", "Volume added: " + sv.toString());
                    }
                    Collections.sort(this.volumes, ManageStorageVolumesFactory.getManager().getVolumeComparator(this.context.getLocale()));
                }
                return this.volumes;
            }
            catch (ConfigMgmtException cme) {
                cme.addExceptionContext(this);
                Trace.error((Object)this, "getVolumes", "Failed--current state: " + this.toString());
                throw cme;
            }
        }
        Trace.verbose((Object)this, "getInitiatorGroups", "CIMInstance instance member variable not initialized.");
        throw new ConfigMgmtException("NULL_VALUE_RETURNED", "CIMInstance instance member variable not initialized.");
    }

    public String getT4Name() throws ConfigMgmtException {
        Trace.methodBegin(this, "getT4Name");
        if (this.t4Name == null) {
            this.t4Name = StorageAccessUtil.t4NameLookup(this.handle, this.instance, "SunStorEdge_6120AuthViewSystemDevice", "PartComponent", "GroupComponent");
        }
        return this.t4Name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSystemName(String systemName) {
        this.systemName = systemName;
    }

    public void addVolumeToGroup(StorageVolumeInterface volume) throws ConfigMgmtException, MultipleMembershipNotAllowed {
        Trace.methodBegin(this, "addVolumeToGroup");
        if (volume != null && volume instanceof StorageVolume && ((StorageVolume)volume).isAlreadyMember()) {
            Trace.verbose((Object)this, "addVolumeToGroup", "Volume can be a member of only one volume group.");
            throw new MultipleMembershipNotAllowed("MULTIPLE_MEMBERSHIP_NOT_ALLOWED", "Volume can be a member of only one volume group.");
        }
        try {
            CIMArgument[] inArgs = new CIMArgument[]{new CIMArgument("Device", new CIMValue((Object)volume.getInstance().getObjectPath())), new CIMArgument("DeviceNumber", null)};
            Trace.verbose((Object)this, "addVolumeToGroup", "Arguments created.");
            CIMValue returnValue = this.handle.invokeMethod(this.getInstance().getObjectPath(), "AttachDevice", inArgs, null);
            Trace.verbose((Object)this, "addVolumeToGroup", "AttachDevice method invoked.");
            int result = ((UnsignedInt32)returnValue.getValue()).intValue();
            if (result != 0) {
                String message = "Return code for AttachDevice to VolumeGroup " + this.getInstance().getObjectPath() + " is not success, it is " + result;
                Trace.verbose((Object)this, "addVolumeToGroup", message);
                throw new ConfigMgmtException("EXTRINSIC_CIM_METHOD_EXCEPTION", message);
            }
            Trace.verbose((Object)this, "addVolumeToGroup", "StorageVolume: " + volume + " successfully added to the " + "VolumeGroup: " + this.toString());
        }
        catch (NullPointerException npe) {
            Trace.verbose((Object)this, "addVolumeToGroup", "Null value returned.");
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - Returned value is  null in addVolumeToGroup method.", npe);
        }
        catch (ConfigMgmtException cme) {
            cme.addExceptionContext(this);
            Trace.error((Object)this, "addVolumeToGroup", "Failed--current state: " + this.toString());
            throw cme;
        }
    }

    public void deleteVolumeFromGroup(StorageVolumeInterface volume) throws ConfigMgmtException {
        Trace.methodBegin(this, "deleteVolumeFromGroup");
        try {
            int result;
            CIMArgument[] inArgs = new CIMArgument[]{new CIMArgument("Device", new CIMValue((Object)volume.getInstance().getObjectPath()))};
            CIMValue returnValue = this.handle.invokeMethod(this.getInstance().getObjectPath(), "RemoveDevice", inArgs, null);
            if (returnValue != null && (result = ((UnsignedInt32)returnValue.getValue()).intValue()) != 0) {
                String message = "Return code for RemoveDevice to VolumeGroup " + this.getInstance().getObjectPath() + " is not success, it is " + result;
                Trace.verbose((Object)this, "deleteVolumeFromGroup", message);
                throw new ConfigMgmtException("EXTRINSIC_CIM_METHOD_EXCEPTION", message);
            }
            Trace.verbose((Object)this, "deleteVolumeFromGroup", "StorageVolume: " + volume + " successfully removed from the " + "VolumeGroup: " + this.toString());
        }
        catch (NullPointerException npe) {
            Trace.verbose((Object)this, "deleteVolumeFromGroup", "Null value returned. " + npe);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - Returned value is  null in deleteVolumeFromGroup method.", npe);
        }
        catch (ConfigMgmtException cme) {
            cme.addExceptionContext(this);
            Trace.error((Object)this, "deleteVolumeFromGroup", "Failed--current state: " + this.toString());
            throw cme;
        }
    }

    public CIMInstance getInstance() {
        return this.instance;
    }

    public void setInstance(CIMInstance instance) {
        this.instance = instance;
        if (this.volumeGroupPath == null) {
            this.volumeGroupPath = instance.getObjectPath();
        }
    }

    public Collection getFieldMap() {
        Trace.methodBegin(this, "getFieldMap");
        if (null == this.fieldMap) {
            this.fieldMap = new ArrayList();
            this.fieldMap.add(new MapElement("name", "ElementName", true, false));
            this.fieldMap.add(new MapElement("systemName", "SystemName", true, false));
        }
        return this.fieldMap;
    }

    public String toString() {
        StringBuffer thisObject = new StringBuffer("VolumeGroup with:");
        thisObject.append("\n CIMObjectPath: " + this.instance.getObjectPath());
        thisObject.append("\n name: " + this.name);
        thisObject.append("\n number of volumes: " + this.volumes.size());
        return thisObject.toString();
    }

    public void setObjectPath(CIMObjectPath path) {
        this.volumeGroupPath = path;
    }

    public Collection getKey() {
        Vector keys = new Vector();
        if (this.volumeGroupPath != null) {
            keys = this.volumeGroupPath.getKeys();
        }
        return keys;
    }
}

