/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.access.business.impl.mr3;

import com.sun.netstorage.array.mgmt.cfg.access.business.InitiatorGroupInterface;
import com.sun.netstorage.array.mgmt.cfg.access.business.ManageBindingsFactory;
import com.sun.netstorage.array.mgmt.cfg.access.business.ManageBindingsInterface;
import com.sun.netstorage.array.mgmt.cfg.access.business.ManageVolumeGroupsInterface;
import com.sun.netstorage.array.mgmt.cfg.access.business.VolumeGroupInterface;
import com.sun.netstorage.array.mgmt.cfg.access.business.impl.mr3.VolumeGroup;
import com.sun.netstorage.array.mgmt.cfg.core.CIMOMHandleWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.impl.CIMObjectWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.logic.SearchFilter;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.InstanceWrapper;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageT4sFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageT4sInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageVolumeInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.T4Interface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.mr3.T4;
import java.text.CollationKey;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.wbem.cim.CIMArgument;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt32;

public class ManageVolumeGroups
implements ManageVolumeGroupsInterface {
    private ConfigContext context;
    private CIMOMHandleWrapper handle;
    private SearchFilter filter;
    private InstanceWrapper scope;
    private ArrayList volumeGroups;
    static /* synthetic */ Class class$com$sun$netstorage$array$mgmt$cfg$access$business$impl$mr3$ManageVolumeGroups;

    public void init(ConfigContext context, SearchFilter filter) throws ConfigMgmtException {
        Trace.methodBegin(this, "init");
        this.context = context;
        this.filter = filter;
        this.handle = context.getClient();
        if (this.handle == null) {
            Trace.verbose((Object)this, "init", "CIMOMHandleWrapper object is null.");
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "CIMOMHandleWrapper object is null.");
        }
        this.volumeGroups = new ArrayList();
        Enumeration enumeration = null;
        if (this.scope != null) {
            if (this.scope instanceof StorageVolumeInterface) {
                Trace.verbose((Object)this, "init", "Scope is StorageVolume: " + this.scope);
                enumeration = this.allVolumeGroupsPerVolume();
            } else if (this.scope instanceof T4Interface) {
                Trace.verbose((Object)this, "init", "Scope is T4: " + this.scope);
                enumeration = this.allVolumeGroupsPerT4(((T4Interface)this.scope).getClusterName());
            } else {
                Trace.verbose((Object)this, "init", "Wrong scope set: " + this.scope);
                new ConfigMgmtException("error.scope.required", "Wrong scope set: " + this.scope);
            }
        } else {
            Trace.verbose((Object)this, "init", "Scope is not set.");
            enumeration = this.allVolumeGroups();
        }
        if (enumeration != null && enumeration.hasMoreElements()) {
            while (enumeration.hasMoreElements()) {
                CIMInstance ci = (CIMInstance)enumeration.nextElement();
                if (!ManageVolumeGroups.isVolumeGroup(ci) || filter != null && !filter.isEmpty() && !filter.passesFilter(ci)) continue;
                VolumeGroup vg = new VolumeGroup();
                vg.setInstance(ci);
                vg.init(context);
                CIMObjectWrapper.populate(vg, vg.getFieldMap(), ci);
                this.volumeGroups.add(vg);
            }
            Trace.verbose((Object)this, "createItemList", "Sort the volume group list");
            Collections.sort(this.volumeGroups, new VGComparator(context.getLocale()));
        } else {
            Trace.verbose((Object)this, "init", "No instance returned when trying to obtain the list of VolumeGroups.");
        }
    }

    public static boolean isVolumeGroup(CIMInstance ci) throws ConfigMgmtException {
        Trace.methodBegin(class$com$sun$netstorage$array$mgmt$cfg$access$business$impl$mr3$ManageVolumeGroups == null ? (class$com$sun$netstorage$array$mgmt$cfg$access$business$impl$mr3$ManageVolumeGroups = ManageVolumeGroups.class$("com.sun.netstorage.array.mgmt.cfg.access.business.impl.mr3.ManageVolumeGroups")) : class$com$sun$netstorage$array$mgmt$cfg$access$business$impl$mr3$ManageVolumeGroups, "isVolumeGroup");
        try {
            Vector otherInfoV;
            boolean globalAccess = (Boolean)ci.getProperty("DefaultGlobalAccess").getValue().getValue();
            String otherInfo = null;
            CIMProperty otherInfoCP = ci.getProperty("OtherIdentifyingInfo");
            if (otherInfoCP != null && otherInfoCP.getValue() != null && (otherInfoV = (Vector)otherInfoCP.getValue().getValue()) != null) {
                otherInfo = (String)otherInfoV.get(0);
            }
            return !globalAccess && otherInfo == null;
        }
        catch (NullPointerException npe) {
            String message = "DefaultGlobalAccess property is null.";
            Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$access$business$impl$mr3$ManageVolumeGroups == null ? (class$com$sun$netstorage$array$mgmt$cfg$access$business$impl$mr3$ManageVolumeGroups = ManageVolumeGroups.class$("com.sun.netstorage.array.mgmt.cfg.access.business.impl.mr3.ManageVolumeGroups")) : class$com$sun$netstorage$array$mgmt$cfg$access$business$impl$mr3$ManageVolumeGroups, "isVolumeGroup", message);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", message, npe);
        }
    }

    private Enumeration allVolumeGroupsPerVolume() throws ConfigMgmtException {
        Trace.methodBegin(this, "allVolumeGroupsPerVolume");
        try {
            Enumeration enumeration = this.handle.associators(this.scope.getInstance().getObjectPath(), "SunStorEdge_6120MappedProtocolControllerForUnit", "SunStorEdge_6120AuthorizationViewSCSIController", "Dependent", "Antecedent", true, false, VolumeGroup.PROPERTY_NAMES);
            Trace.verbose((Object)this, "allVolumeGroupsPerVolume", "Came back from enumerating VolumeGroups.");
            return enumeration;
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "allVolumeGroupsPerVolume", "Failed--message: " + cme.getMessage());
            throw cme;
        }
    }

    private Enumeration allVolumeGroupsPerT4(String ipAddr) throws ConfigMgmtException {
        Trace.methodBegin(this, "allVolumeGroupsPerT4");
        try {
            Enumeration enumeration = CIMObjectWrapper.execQuery(this.handle, "Select * from SunStorEdge_6120AuthorizationViewSCSIController where SystemName = '" + ipAddr + "'");
            Trace.verbose((Object)this, "allVolumeGroupsPerT4", "Came back from enumerating VolumeGroups.");
            return enumeration;
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "allVolumeGroupsPerT4", "Failed--message: " + cme.getMessage());
            throw cme;
        }
    }

    private Enumeration allVolumeGroups() throws ConfigMgmtException {
        Trace.methodBegin(this, "allVolumeGroups");
        try {
            Enumeration enumeration = this.handle.enumerateInstances(new CIMObjectPath("SunStorEdge_6120AuthorizationViewSCSIController"), false, false, true, false, VolumeGroup.PROPERTY_NAMES);
            Trace.verbose((Object)this, "allVolumeGroups", "Came back from enumerating VolumeGroups.");
            return enumeration;
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "allVolumeGroups", "Failed--message: " + cme.getMessage());
            throw cme;
        }
    }

    public List getItemList() throws ConfigMgmtException {
        return this.volumeGroups;
    }

    public void createVolumeGroup(String name, String desc, String t4Name, List volumes) throws ConfigMgmtException {
        String methodName = "createVolumeGroup(system1-merge version)";
        Trace.methodBegin(this, methodName);
        try {
            T4Interface t4 = null;
            SearchFilter t4Filter = new SearchFilter("Name", t4Name);
            ManageT4sInterface mT4s = ManageT4sFactory.getManager();
            mT4s.init(this.context, t4Filter);
            ArrayList t4s = (ArrayList)mT4s.getItemList();
            if (t4s.size() == 1) {
                t4 = (T4Interface)t4s.get(0);
                Trace.verbose((Object)this, methodName, "We got T4 object.");
            }
            this.createVolumeGroup(name, t4, volumes, new ArrayList(), new ArrayList());
        }
        catch (NullPointerException npe) {
            Trace.verbose((Object)this, "createVolumeGroup", "Returned value is null in createVolumeGroup method." + npe);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - Returned value is  null in createVolumeGroup method.", npe);
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "createVolumeGroup", "Failed--message: " + cme.getMessage());
            throw cme;
        }
    }

    public void createVolumeGroup(String name, T4Interface t4, List volumes, List initiatorGroups, List accessRights) throws ConfigMgmtException {
        Trace.methodBegin(this, "createVolumeGroup");
        try {
            InitiatorGroupInterface initiatorGroup = null;
            String access = null;
            CIMArgument[] inArgs = new CIMArgument[]{new CIMArgument("ElementName", new CIMValue((Object)name)), new CIMArgument("Ports", null)};
            CIMArgument[] outArgs = new CIMArgument[]{new CIMArgument("View", null)};
            CIMValue returnValue = this.handle.invokeMethod(T4.getPortSCSIController(this.handle, t4.getClusterName()).getObjectPath(), "CreateViewWithName", inArgs, outArgs);
            int result = ((UnsignedInt32)returnValue.getValue()).intValue();
            Trace.verbose((Object)this, "createVolumeGroup", "Result is: " + result);
            if (result != 0) {
                Trace.verbose((Object)this, "createVolumeGroup", "Return code for CreateView() method is not success, it is " + result);
                throw new ConfigMgmtException("VOLUME_GRP_CREATE_ERROR", "Return code for CreateView() method is not success, it is " + result);
            }
            CIMInstance vgInstance = this.handle.getInstance((CIMObjectPath)outArgs[0].getValue().getValue(), false, true, false, VolumeGroup.PROPERTY_NAMES);
            VolumeGroup volumeGroup = new VolumeGroup();
            volumeGroup.init(this.context);
            volumeGroup.setInstance(vgInstance);
            CIMObjectWrapper.populate(volumeGroup, volumeGroup.getFieldMap(), vgInstance);
            if (volumes != null) {
                for (int i = 0; i < volumes.size(); ++i) {
                    volumeGroup.addVolumeToGroup((StorageVolumeInterface)volumes.get(i));
                }
            }
            if (initiatorGroups != null && accessRights != null) {
                ManageBindingsInterface mb = ManageBindingsFactory.getManager();
                mb.setScope(volumeGroup);
                mb.init(this.context, null);
                for (int i = 0; i < initiatorGroups.size(); ++i) {
                    initiatorGroup = (InitiatorGroupInterface)initiatorGroups.get(i);
                    access = (String)accessRights.get(i);
                    mb.addBinding(t4, volumeGroup, initiatorGroup, access);
                    Trace.verbose((Object)this, "createVolumeGroup", "Binding added contains: InitiatorGroup: " + initiatorGroup.getName() + " VolumeGroup: " + volumeGroup.getName() + " with access: " + access);
                }
            }
        }
        catch (NullPointerException npe) {
            Trace.verbose((Object)this, "createVolumeGroup", "Returned value is null in createVolumeGroup method." + npe);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - Returned value is  null in createVolumeGroup method.", npe);
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "createVolumeGroup", "Failed--message: " + cme.getMessage());
            throw cme;
        }
    }

    public void setScope(InstanceWrapper scope) {
        this.scope = scope;
    }

    public void delete(Collection key) throws ConfigMgmtException {
        List vl = (List)key;
        VolumeGroup vg = (VolumeGroup)this.getByKey(key);
        Trace.verbose((Object)this, "delete", "Delete volume:" + vg.getName());
        vg.delete();
    }

    public VolumeGroupInterface getByKey(Collection key) throws ConfigMgmtException {
        String methodName = "getByKey";
        Trace.methodBegin(this, methodName);
        Trace.verbose((Object)this, methodName, "Trying to create object path from key");
        CIMObjectPath path = new CIMObjectPath("SunStorEdge_6120AuthorizationViewSCSIController", new Vector(key));
        Trace.verbose((Object)this, methodName, "After creating object path");
        VolumeGroup vg = new VolumeGroup();
        vg.setObjectPath(path);
        vg.init(this.context);
        vg.reload();
        Trace.verbose((Object)this, methodName, "Got volume by key = " + vg.getName());
        return vg;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class VGComparator
    implements Comparator {
        Collator collator = null;

        VGComparator(Locale loc) {
            this.collator = loc != null ? Collator.getInstance(loc) : Collator.getInstance();
        }

        public int compare(Object element1, Object element2) {
            CollationKey key1 = null;
            CollationKey key2 = null;
            if (element1 instanceof VolumeGroup && element2 instanceof VolumeGroup) {
                key1 = this.collator.getCollationKey(((VolumeGroup)element1).getName());
                key2 = this.collator.getCollationKey(((VolumeGroup)element2).getName());
            } else {
                key1 = this.collator.getCollationKey(element1.toString());
                key2 = this.collator.getCollationKey(element2.toString());
            }
            return key1.compareTo(key2);
        }
    }
}

