/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.access.business.impl.mr3;

import com.sun.netstorage.array.mgmt.cfg.access.business.InitiatorGroupInterface;
import com.sun.netstorage.array.mgmt.cfg.access.business.InitiatorInterface;
import com.sun.netstorage.array.mgmt.cfg.access.business.impl.mr3.Initiator;
import com.sun.netstorage.array.mgmt.cfg.access.business.impl.mr3.ManageBindings;
import com.sun.netstorage.array.mgmt.cfg.access.business.impl.mr3.StorageAccessUtil;
import com.sun.netstorage.array.mgmt.cfg.core.CIMOMHandleWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.MultipleMembershipNotAllowed;
import com.sun.netstorage.array.mgmt.cfg.core.impl.CIMObjectWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.impl.MapElement;
import com.sun.netstorage.array.mgmt.cfg.util.IPUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;

public class InitiatorGroup
implements InitiatorGroupInterface {
    private ConfigContext context;
    private CIMOMHandleWrapper handle;
    private String name;
    private ArrayList initiators;
    private CIMInstance instance;
    private CIMObjectPath initiatorGroupPath;
    private ArrayList fieldMap;
    private String t4Name;
    public static final String[] PROPERTY_NAMES = new String[]{"ElementName", "InstanceID"};
    static /* synthetic */ Class class$com$sun$netstorage$array$mgmt$cfg$access$business$impl$mr3$InitiatorGroup;

    public void init(ConfigContext context) throws ConfigMgmtException {
        Trace.methodBegin(this, "init");
        this.context = context;
        this.handle = context.getClient();
        this.initiators = new ArrayList();
        if (this.handle == null) {
            Trace.verbose((Object)this, "init", "CIMOMHandleWrapper value is null.");
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "CIMOMHandleWrapper value is null.");
        }
    }

    public void save() throws ConfigMgmtException {
        Trace.methodBegin(this, "save");
    }

    public void delete() throws ConfigMgmtException {
        Trace.methodBegin(this, "delete");
        ArrayList allInitiators = this.getInitiators();
        for (int i = 0; i < allInitiators.size(); ++i) {
            Initiator initiator = (Initiator)allInitiators.get(i);
            this.deleteInitiatorFromGroup(initiator);
            Trace.verbose((Object)this, "delete", "Initiator removed from the group: " + initiator);
        }
        Trace.verbose((Object)this, "delete", "All Initiators removed from the InitiatorGroup.");
        ManageBindings mb = new ManageBindings();
        mb.removeAllBindings(this.context, this);
        Trace.verbose((Object)this, "delete", "All Bindings removed for the InitiatorGroup.");
        try {
            this.handle.deleteInstance(this.instance.getObjectPath());
            Trace.verbose((Object)this, "delete", "InitiatorGroup successfully removed.");
        }
        catch (ConfigMgmtException cme) {
            cme.addExceptionContext(this);
            Trace.error((Object)this, "delete", "Failed delete--current state: " + this.toString());
            throw cme;
        }
    }

    public void reload() throws ConfigMgmtException {
        Trace.methodBegin(this, "reload");
        CIMInstance ci = this.handle.getInstance(this.initiatorGroupPath, false, true, false, PROPERTY_NAMES);
        Trace.verbose((Object)this, "reload", "Object path of the fresh CIMInstance: " + ci.getObjectPath());
        this.setInstance(ci);
        CIMObjectWrapper.populate(this, this.getFieldMap(), ci);
        this.initiators = new ArrayList();
        this.t4Name = null;
        Trace.verbose((Object)this, "reload", "Object reloaded: " + this.toString());
    }

    public String getName() {
        return this.name;
    }

    public ArrayList getInitiators() throws ConfigMgmtException {
        Trace.methodBegin(this, "getInitiators");
        if (this.instance != null) {
            this.initiators = new ArrayList();
            try {
                Enumeration enumeration = this.handle.associators(this.instance.getObjectPath(), "SunStorEdge_6120MemberOfCollection", "SunStorEdge_6120StorageHardwareID", "Collection", "Member", true, false, Initiator.PROPERTY_NAMES);
                if (enumeration != null && enumeration.hasMoreElements()) {
                    while (enumeration.hasMoreElements()) {
                        CIMInstance ci = (CIMInstance)enumeration.nextElement();
                        Initiator i = new Initiator();
                        i.init(this.context);
                        i.setInstance(ci);
                        CIMObjectWrapper.populate(i, i.getFieldMap(), ci);
                        this.initiators.add(i);
                        Trace.verbose((Object)this, "getInitiators", "Initiator added: " + i.toString());
                    }
                }
                return this.initiators;
            }
            catch (ConfigMgmtException cme) {
                cme.addExceptionContext(this);
                Trace.error((Object)this, "getInitiators", "Failed--current state: " + this.toString());
                throw cme;
            }
        }
        Trace.verbose((Object)this, "getInitiators", "CIMInstance instance member variable not initialized.");
        throw new ConfigMgmtException("NULL_VALUE_RETURNED", "CIMInstance instance member variable not initialized.");
    }

    public CIMInstance getInstance() {
        return this.instance;
    }

    public String getT4Name() throws ConfigMgmtException {
        Trace.methodBegin(this, "getT4Name");
        if (this.t4Name == null) {
            this.t4Name = StorageAccessUtil.t4NameLookup(this.handle, this.instance, "SunStorEdge_6120HostedCollection", "Dependent", "Antecedent");
        }
        return this.t4Name;
    }

    public Collection getKey() {
        Vector key = new Vector();
        if (this.initiatorGroupPath != null) {
            key = this.initiatorGroupPath.getKeys();
        }
        return key;
    }

    public String getStorageDomainName() {
        return "Test Domain";
    }

    public void setName(String name) throws ConfigMgmtException {
        this.name = name;
    }

    public void setInstance(CIMInstance instance) {
        this.instance = instance;
        if (this.initiatorGroupPath == null) {
            this.initiatorGroupPath = instance.getObjectPath();
        }
    }

    public void setInitiatorGroupPath(CIMObjectPath initiatorGroupPath) {
        this.initiatorGroupPath = initiatorGroupPath;
    }

    public void addInitiatorToGroup(InitiatorInterface initiator) throws ConfigMgmtException, MultipleMembershipNotAllowed {
        Trace.methodBegin(this, "addInitiatorToGroup");
        if (this.instance == null) {
            Trace.verbose((Object)this, "addInitiatorToGroup", "CIMInstance instance member variable not initialized.");
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "CIMInstance instance member variable not initialized.");
        }
        HashMap<String, CIMObjectPath> map = new HashMap<String, CIMObjectPath>();
        map.put("Collection", this.instance.getObjectPath());
        map.put("Member", ((Initiator)initiator).getInstance().getObjectPath());
        Vector keys = CIMObjectWrapper.instanceKeyBuilder(map);
        CIMObjectPath associationPath = CIMObjectWrapper.createInstance(this.handle, keys, "SunStorEdge_6120MemberOfCollection");
        Trace.verbose((Object)this, "addInitiatorToGroup", "Object path of the MemberOfCollection association created is: " + associationPath);
    }

    public void deleteInitiatorFromGroup(InitiatorInterface initiator) throws ConfigMgmtException {
        Trace.methodBegin(this, "deleteInitiatorFromGroup");
        if (this.instance == null) {
            Trace.verbose((Object)this, "deleteInitiatorFromGroup", "CIMInstance instance member variable not initialized.");
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "CIMInstance instance member variable not initialized.");
        }
        HashMap<String, CIMObjectPath> map = new HashMap<String, CIMObjectPath>();
        map.put("Collection", this.instance.getObjectPath());
        map.put("Member", ((Initiator)initiator).getInstance().getObjectPath());
        Vector keys = CIMObjectWrapper.instanceKeyBuilder(map);
        CIMObjectWrapper.deleteInstance(this.handle, keys, "SunStorEdge_6120MemberOfCollection");
        Trace.verbose((Object)this, "deleteInitiatorFromGroup", "Removed Initiator: " + initiator.getWWN() + " from InitiatorGroup: " + this.name);
    }

    protected Collection getFieldMap() {
        Trace.methodBegin(this, "getFieldMap");
        if (null == this.fieldMap) {
            this.fieldMap = new ArrayList();
            this.fieldMap.add(new MapElement("name", "ElementName", true, false));
        }
        return this.fieldMap;
    }

    protected static String createInitiatorGroupInstanceID(String t4Name, String initiatorGroupName) {
        Trace.methodBegin(class$com$sun$netstorage$array$mgmt$cfg$access$business$impl$mr3$InitiatorGroup == null ? (class$com$sun$netstorage$array$mgmt$cfg$access$business$impl$mr3$InitiatorGroup = InitiatorGroup.class$("com.sun.netstorage.array.mgmt.cfg.access.business.impl.mr3.InitiatorGroup")) : class$com$sun$netstorage$array$mgmt$cfg$access$business$impl$mr3$InitiatorGroup, "createInitiatorGroupInstanceID");
        String instanceID = "StorEdge 6120_";
        instanceID = instanceID + IPUtil.lookUpIP(t4Name);
        instanceID = instanceID + "_";
        instanceID = instanceID + initiatorGroupName;
        Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$access$business$impl$mr3$InitiatorGroup == null ? (class$com$sun$netstorage$array$mgmt$cfg$access$business$impl$mr3$InitiatorGroup = InitiatorGroup.class$("com.sun.netstorage.array.mgmt.cfg.access.business.impl.mr3.InitiatorGroup")) : class$com$sun$netstorage$array$mgmt$cfg$access$business$impl$mr3$InitiatorGroup, "createInitiatorGroupInstanceID", "Created InstanceID value is: " + instanceID);
        return instanceID;
    }

    public boolean equals(Object obj) {
        boolean result = super.equals(obj);
        if (obj != null && obj instanceof InitiatorGroup) {
            InitiatorGroup igToCompare = (InitiatorGroup)obj;
            if (this.getName() != null && this.getName().equals(igToCompare.getName())) {
                result = true;
            }
        }
        return result;
    }

    public String toString() {
        StringBuffer thisObject = new StringBuffer("InitiatorGroup with:");
        thisObject.append("\n CIMObjectPath: " + this.instance.getObjectPath());
        thisObject.append("\n name: " + this.name);
        thisObject.append("\n t4Name: " + this.t4Name);
        thisObject.append("\n number of initiators: " + this.initiators.size());
        return thisObject.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

