/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.access.business.impl.mr3;

import com.sun.netstorage.array.mgmt.cfg.access.business.BindingInterface;
import com.sun.netstorage.array.mgmt.cfg.access.business.InitiatorGroupInterface;
import com.sun.netstorage.array.mgmt.cfg.access.business.VolumeGroupInterface;
import com.sun.netstorage.array.mgmt.cfg.access.business.impl.mr3.ManageBindings;
import com.sun.netstorage.array.mgmt.cfg.core.CIMOMHandleWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.impl.CIMObjectWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.impl.MapStringArrayToString;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Vector;
import javax.wbem.cim.CIMArgument;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt32;

public class Binding
implements BindingInterface {
    private ConfigContext context;
    private CIMOMHandleWrapper handle;
    private VolumeGroupInterface volumeGroup;
    private InitiatorGroupInterface initiatorGroup;
    private String access;
    private ArrayList fieldMap;
    private CIMInstance aciInstance;
    private CIMObjectPath aciPath;
    public static final String[] PROPERTY_NAMES = new String[]{"AccessType", "SystemCreationClassName", "SystemName", "CreationClassName", "Name"};

    public void init(ConfigContext context) throws ConfigMgmtException {
        Trace.methodBegin(this, "init");
        this.context = context;
        this.handle = context.getClient();
        if (this.handle == null) {
            Trace.verbose((Object)this, "init", "CIMOMHandleWrapper object is null.");
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "CIMOMHandleWrapper object is null.");
        }
    }

    public void save() throws ConfigMgmtException {
        Trace.methodBegin(this, "save");
        if (this.aciInstance == null) {
            String message = "aciInstance variable not, initialized for Binding: " + this.toString() + " and access can not be changed.";
            Trace.verbose((Object)this, "save", message);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", message);
        }
        this.aciPath = this.aciInstance.getObjectPath();
        CIMObjectWrapper.save(this, this.getFieldMap(), this.aciInstance, this.handle);
        this.reload();
        Trace.verbose((Object)this, "save", "The Binding successfully saved.");
    }

    public void delete() throws ConfigMgmtException {
        Trace.methodBegin(this, "delete");
        try {
            Vector<String> aciVector = new Vector<String>();
            aciVector.add(this.aciInstance.getObjectPath().toString());
            Vector<String> targetVector = new Vector<String>();
            targetVector.add(this.volumeGroup.getInstance().getObjectPath().toString());
            CIMArgument[] inArgs = new CIMArgument[]{new CIMArgument("Subject", new CIMValue((Object)this.initiatorGroup.getInstance().getObjectPath())), new CIMArgument("Access", new CIMValue(aciVector)), new CIMArgument("Target", new CIMValue(targetVector))};
            CIMValue returnValue = this.handle.invokeMethod(ManageBindings.getAuthorizationServiceObjectPath(this.handle, this.getT4ObjectPath(this.initiatorGroup)), "RemoveAccess", inArgs, null);
            int result = ((UnsignedInt32)returnValue.getValue()).intValue();
            if (result != 0) {
                String message = "Removing Binding: " + this.toString() + " failed with return code: " + result;
                Trace.verbose((Object)this, "delete", message);
                throw new ConfigMgmtException("EXTRINSIC_CIM_METHOD_EXCEPTION", message);
            }
            Trace.verbose((Object)this, "delete", "Binding " + this.toString() + " removed successfully.");
        }
        catch (ConfigMgmtException cme) {
            cme.addExceptionContext(this);
            Trace.error((Object)this, "delete", "Failed delete--current state: " + this.toString());
            throw cme;
        }
    }

    private CIMObjectPath getT4ObjectPath(InitiatorGroupInterface initiatorGroup) throws ConfigMgmtException {
        Trace.methodBegin(this, "getT4ObjectPath");
        String message = "";
        try {
            Enumeration enumeration = this.handle.associatorNames(initiatorGroup.getInstance().getObjectPath(), "SunStorEdge_6120HostedCollection", "SunStorEdge_6120Cluster", "Dependent", "Antecedent");
            if (enumeration == null) {
                message = "Null returned when trying to get Cluster CIMObjectPath.";
                Trace.verbose((Object)this, "getT4ObjectPath", message);
                throw new ConfigMgmtException("NULL_VALUE_RETURNED", message);
            }
            if (!enumeration.hasMoreElements()) {
                message = "No instance returned when trying to get Cluster CIMObjectPath.";
                Trace.verbose((Object)this, "getT4ObjectPath", message);
                throw new ConfigMgmtException("ZERO_CIM_INSTANCE_RETURNED", message);
            }
            CIMObjectPath t4Path = (CIMObjectPath)enumeration.nextElement();
            if (t4Path != null) {
                Trace.verbose((Object)this, "getT4ObjectPath", "The CIMObjectPath we got is: " + t4Path);
                return t4Path;
            }
            message = "The T4 instance returned is null.";
            Trace.verbose((Object)this, "getT4ObjectPath", message);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", message);
        }
        catch (ConfigMgmtException cme) {
            cme.addExceptionContext(this);
            Trace.error((Object)this, "getT4ObjectPath", "Failed--current state: " + this.toString());
            throw cme;
        }
    }

    public void reload() throws ConfigMgmtException {
        if (this.aciPath != null) {
            try {
                Trace.verbose((Object)this, "reload", "Instance's CIMObjectPath is: " + this.aciPath);
                this.aciInstance = this.handle.getInstance(this.aciPath, false, true, false, PROPERTY_NAMES);
                Trace.verbose((Object)this, "reload", "Fresh CIMInstance we've got: " + this.aciInstance);
            }
            catch (ConfigMgmtException cme) {
                cme.addExceptionContext(this);
                Trace.error((Object)this, "reload", "Failed--current state: " + this.toString());
                throw cme;
            }
        } else {
            Trace.verbose((Object)this, "reload", "ACI CIMObjectPath is null.");
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "ACI CIMObjectPath is null.");
        }
    }

    public String getAccess() {
        return this.access;
    }

    public InitiatorGroupInterface getInitiatorGroup() {
        return this.initiatorGroup;
    }

    public VolumeGroupInterface getVolumeGroup() {
        return this.volumeGroup;
    }

    public CIMInstance getAciInstance() {
        return this.aciInstance;
    }

    public void setAccess(String access) {
        this.access = access;
    }

    public void setInitiatorGroup(InitiatorGroupInterface initiatorGroup) {
        this.initiatorGroup = initiatorGroup;
    }

    public void setVolumeGroup(VolumeGroupInterface volumeGroup) {
        this.volumeGroup = volumeGroup;
    }

    public void setAciInstance(CIMInstance aciInstance) {
        this.aciInstance = aciInstance;
    }

    protected Collection getFieldMap() {
        Trace.methodBegin(this, "getFieldMap");
        if (null == this.fieldMap) {
            this.fieldMap = new ArrayList();
            this.fieldMap.add(new MapStringArrayToString("access", "AccessType", false, false, 0));
        }
        return this.fieldMap;
    }

    public String toString() {
        return "Binding with:\n ACI CIMInstance: " + this.aciInstance + "\n InitiatorGroup path: " + this.initiatorGroup.getInstance().getObjectPath() + "\n VolumeGroup path: " + this.volumeGroup.getInstance().getObjectPath() + "\n access: " + this.access;
    }
}

