/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.access.business.impl.ent1;

import com.sun.netstorage.array.mgmt.cfg.access.business.InitiatorInterface;
import com.sun.netstorage.array.mgmt.cfg.access.business.ManageInitiatorsInterface;
import com.sun.netstorage.array.mgmt.cfg.access.business.impl.ent1.Initiator;
import com.sun.netstorage.array.mgmt.cfg.core.CIMOMHandleWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.ConstantsEnt;
import com.sun.netstorage.array.mgmt.cfg.core.MethodCallStatus;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.BadParameterException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.impl.CIMObjectWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.logic.SearchFilter;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.InstanceWrapper;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.T4Interface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.ServiceFinder;
import com.sun.netstorage.array.mgmt.cfg.util.ItemNotFoundException;
import java.text.CollationKey;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.wbem.cim.CIMArgument;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt16;

public class ManageInitiators
implements ManageInitiatorsInterface {
    private ConfigContext context;
    private CIMOMHandleWrapper handle;

    public void init(ConfigContext context, SearchFilter filter) throws ConfigMgmtException {
        Trace.methodBegin(this, "init");
        if (context == null) {
            Trace.error((Object)this, "init", "ConfigContext object is null.");
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "ConfigContext object is null.");
        }
        this.context = context;
        this.handle = context.getClient();
        if (this.handle == null) {
            Trace.error((Object)this, "init", "CIMOMHandleWrapper object is null.");
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "CIMOMHandleWrapper object is null.");
        }
    }

    private ArrayList enumToList(Enumeration enumeration) throws ConfigMgmtException {
        Trace.methodBegin(this, "enumToList");
        Trace.verbose((Object)this, "enumToList", "Converting CIM Instances to Java Objects");
        ArrayList<Initiator> enumToList = new ArrayList<Initiator>();
        if (enumeration != null && enumeration.hasMoreElements()) {
            while (enumeration.hasMoreElements()) {
                CIMInstance ci = (CIMInstance)enumeration.nextElement();
                Initiator i = new Initiator();
                i.setInstance(ci);
                i.init(this.context);
                CIMObjectWrapper.populate(i, i.getFieldMap(), ci);
                i.loadKeys();
                enumToList.add(i);
                if (!Trace.isTraceEnabled(this)) continue;
                Trace.verbose((Object)this, "enumToList", "The instance added to the list: " + i);
            }
            Trace.verbose((Object)this, "enumToList", "Sorting the Initiator objects");
            Collections.sort(enumToList, new InitiatorComparator(this.context.getLocale()));
        }
        Trace.verbose((Object)this, "enumToList", "Returning Initiator objects");
        return enumToList;
    }

    public ArrayList getItemsBySystem() throws ConfigMgmtException {
        Trace.methodBegin(this, "getItemsBySystem");
        ArrayList initiators = new ArrayList();
        try {
            Trace.verbose((Object)this, "getItemsBySystem", "Querying CIM for StorageHardwareID Instances");
            Enumeration enumeration = this.handle.enumerateInstances(new CIMObjectPath("SunStorEdge_DSPStorageHardwareID"), false, false, true, false, ConstantsEnt.StorageHardwareIDProperties.PROPERTY_NAMES);
            Trace.verbose((Object)this, "getItemsBySystem", "Returned from querying CIM for StorageHardwareID Instances");
            if (enumeration != null && enumeration.hasMoreElements()) {
                Trace.verbose((Object)this, "getItemsBySystem", "StorageHardwareID Instances found.");
                initiators = this.enumToList(enumeration);
            } else {
                Trace.verbose((Object)this, "getItemsBySystem", "No instance returned when trying to obtain the list of Initiators");
            }
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "getItemsBySystem", "Failed: " + cme);
            throw cme;
        }
        catch (NullPointerException npe) {
            Trace.error((Object)this, "getItemsBySystem", "NullPointerException - Null returned when trying to obtain all the Initiator instances: " + npe);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - Problems getting all the Initiator instances.", npe);
        }
        catch (Exception e) {
            Trace.error((Object)this, "getItemsBySystem", "Exception - Exception thrown when trying to obtain all the Initiator instances: " + e);
            throw new ConfigMgmtException("error.systemError", "Exception - Problems getting all the Initiator instances.", e);
        }
        Trace.verbose((Object)this, "getItemsBySystem", "Returning Initiator Objects");
        return initiators;
    }

    public ArrayList getItemsByStorageDomain(String name) throws ConfigMgmtException, ItemNotFoundException {
        Trace.methodBegin(this, "getItemsByStorageDomain");
        ArrayList initiators = new ArrayList();
        try {
            Trace.verbose((Object)this, "getItemsByStorageDomain", "Checking if StorageDomain exists.");
            Enumeration domains = CIMObjectWrapper.execQuery(this.context.getClient(), "Select * from SunStorEdge_DSPStorageDomain where ElementName = '" + name + "'");
            if (domains == null || !domains.hasMoreElements()) {
                Trace.error((Object)this, "getItemsByStorageDomain", "StorageDomain : " + name + " not found.");
                throw new ItemNotFoundException(name);
            }
            Trace.verbose((Object)this, "getItemsByStorageDomain", "Querying CIM for StorageHardwareIDs with SD matching: " + name);
            Enumeration enumeration = CIMObjectWrapper.execQuery(this.context.getClient(), "Select * from SunStorEdge_DSPStorageHardwareID where StorageDomain = '" + name + "'");
            Trace.verbose((Object)this, "getItemsByStorageDomain", "Returned from querying CIM for StorageHardwareIDs with SD matching: " + name);
            if (enumeration != null && enumeration.hasMoreElements()) {
                Trace.verbose((Object)this, "getItemsByStorageDomain", "StorageHardwareID instances found.");
                initiators = this.enumToList(enumeration);
            }
        }
        catch (ItemNotFoundException infe) {
            Trace.error((Object)this, "getItemsByStorageDomain", "ItemNotFound: " + infe);
            throw infe;
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "getItemsByStorageDomain", "Failed: " + cme);
            throw cme;
        }
        catch (NullPointerException npe) {
            Trace.error((Object)this, "getItemsByStorageDomain", "NullPointerException - Null returned when trying to obtain the Initiators in StorageDomain: " + name + " :" + npe);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - Problems getting the Initiators in StorageDomain: " + name, npe);
        }
        catch (Exception e) {
            Trace.error((Object)this, "getItemsByStorageDomain", "Exception - Exception thrown when trying to obtain the Initiators in StorageDomain: " + name + " :" + e);
            throw new ConfigMgmtException("error.systemError", "Exception - Problems getting the Initiators in StorageDomain: " + name, e);
        }
        return initiators;
    }

    public ArrayList getItemsByFCPort(String name) throws ConfigMgmtException, ItemNotFoundException {
        Trace.methodBegin(this, "getItemsByFCPort");
        ArrayList initiators = new ArrayList();
        try {
            Enumeration enumInitiators;
            Trace.verbose((Object)this, "getItemsByFCPort", "Querying CIM for FiberChannelPort matching: " + name);
            Enumeration enumeration = CIMObjectWrapper.execQuery(this.context.getClient(), "Select * from SunStorEdge_DSPFCPort where ElementName = '" + name + "'");
            Trace.verbose((Object)this, "getItemsByFCPort", "Returned from querying CIM for FiberChannelPort matching: " + name);
            if (enumeration != null && enumeration.hasMoreElements()) {
                Trace.verbose((Object)this, "getItemsByFCPort", "FiberChannelPort instance found.");
                CIMInstance fcPort = (CIMInstance)enumeration.nextElement();
                enumInitiators = this.handle.associators(fcPort.getObjectPath(), "SunStorEdge_DSPAssignedIdentity", "SunStorEdge_DSPStorageHardwareID", "ManagedElement", "IdentityInfo", true, false, null);
                if (enumInitiators == null || !enumInitiators.hasMoreElements()) {
                    Trace.verbose((Object)this, "getItemsByFCPort", "No Initiators found for FCPort: " + name);
                    return new ArrayList();
                }
            } else {
                Trace.error((Object)this, "getItemsByFCPort", "FCPort " + name + " not found.");
                throw new ItemNotFoundException(name);
            }
            Trace.verbose((Object)this, "getItemsByFCPort", "Converting CIMInstances to Initiator Objects.");
            initiators = this.enumToList(enumInitiators);
        }
        catch (ItemNotFoundException infe) {
            Trace.error((Object)this, "getItemsByFCPort", "ItemNotFound: " + infe);
            throw infe;
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "getItemsByFCPort", "Failed: " + cme);
            throw cme;
        }
        catch (NullPointerException npe) {
            Trace.error((Object)this, "getItemsByFCPort", "NullPointerException - Null returned when trying to obtain the Initiators for FCPort: " + name + " :" + npe);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - Problems getting the Initiators for FCPort: " + name, npe);
        }
        catch (Exception e) {
            Trace.error((Object)this, "getItemsByFCPort", "Exception - Exception thrown when trying to obtain the Initiators for FCPort: " + name + " :" + e);
            throw new ConfigMgmtException("error.systemError", "Exception - Problems getting the Initiators for FCPort: " + name, e);
        }
        return initiators;
    }

    public ArrayList getItemsByInitiatorGroup(String name) throws ConfigMgmtException, ItemNotFoundException {
        Trace.methodBegin(this, "getItemsByInitiatorGroup");
        return new ArrayList();
    }

    public InitiatorInterface getItemByName(String name) throws ConfigMgmtException {
        Trace.methodBegin(this, "getItemByName");
        Initiator i = null;
        try {
            Trace.verbose((Object)this, "getItemByName", "Querying CIM for StorageHardwareIDs matching: " + name);
            Enumeration enumeration = CIMObjectWrapper.execQuery(this.context.getClient(), "Select * from SunStorEdge_DSPStorageHardwareID where ElementName = '" + name + "'");
            Trace.verbose((Object)this, "getItemByName", "Returned from querying CIM for StorageHardwareIDs matching: " + name);
            if (enumeration != null && enumeration.hasMoreElements()) {
                while (enumeration.hasMoreElements()) {
                    Trace.verbose((Object)this, "getItemByName", "Found instance, creating Initiator object.");
                    CIMInstance ci = (CIMInstance)enumeration.nextElement();
                    i = new Initiator();
                    i.setInstance(ci);
                    i.init(this.context);
                    CIMObjectWrapper.populate(i, i.getFieldMap(), ci);
                    i.loadKeys();
                    Trace.verbose((Object)this, "getItemByName", "Finished creating Initiator object.");
                }
            }
            if (i == null) {
                Trace.verbose((Object)this, "getItemByName", "No Initiator found with name: " + name);
                return null;
            }
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "getItemByName", "Failed: " + cme);
            throw cme;
        }
        catch (NullPointerException npe) {
            Trace.error((Object)this, "getItemByName", "NullPointerException - Null returned when trying to obtain Initiator: " + name + " :" + npe);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - Problems getting Initiator: " + name, npe);
        }
        catch (Exception e) {
            Trace.error((Object)this, "getItemByName", "Exception - Exception thrown when trying to obtain Initiator: " + name + " :" + e);
            throw new ConfigMgmtException("error.systemError", "Exception - Problems getting Initiator: " + name, e);
        }
        Trace.verbose((Object)this, "getItemByName", "Returning Initiator Object: " + i.getName());
        return i;
    }

    public InitiatorInterface getItemByWwn(String wwn) throws ConfigMgmtException {
        Trace.methodBegin(this, "getItemByWwn");
        Initiator i = null;
        try {
            Trace.verbose((Object)this, "getItemByWwn", "Querying CIM for StorageHardwareIDs matching: " + wwn);
            Enumeration enumeration = CIMObjectWrapper.execQuery(this.context.getClient(), "Select * from SunStorEdge_DSPStorageHardwareID where StorageID = '" + wwn + "'");
            Trace.verbose((Object)this, "getItemByWwn", "Returned from querying CIM for StorageHardwareIDs matching: " + wwn);
            if (enumeration != null && enumeration.hasMoreElements()) {
                while (enumeration.hasMoreElements()) {
                    Trace.verbose((Object)this, "getItemByWwn", "Found instance, creating Initiator object.");
                    CIMInstance ci = (CIMInstance)enumeration.nextElement();
                    i = new Initiator();
                    i.setInstance(ci);
                    i.init(this.context);
                    CIMObjectWrapper.populate(i, i.getFieldMap(), ci);
                    i.loadKeys();
                    Trace.verbose((Object)this, "getItemByWwn", "Finished creating Initiator object.");
                }
            }
            if (i == null) {
                Trace.verbose((Object)this, "getItemByWwn", "No Initiator found with wwn: " + wwn);
                return null;
            }
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "getItemByWwn", "Failed: " + cme);
            throw cme;
        }
        catch (NullPointerException npe) {
            Trace.error((Object)this, "getItemByWwn", "NullPointerException - Null returned when trying to obtain Initiator: " + wwn + " :" + npe);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - Problems getting Initiator: " + wwn, npe);
        }
        catch (Exception e) {
            Trace.error((Object)this, "getItemByWwn", "Exception - Exception thrown when trying to obtain Initiator: " + wwn + " :" + e);
            throw new ConfigMgmtException("error.systemError", "Exception - Problems getting Initiator: " + wwn, e);
        }
        Trace.verbose((Object)this, "getItemByWwn", "Returning Initiator Object: " + i.getWWN());
        return i;
    }

    public InitiatorInterface getItemByInstanceID(String wwn) throws ConfigMgmtException {
        Trace.methodBegin(this, "getItemByWwn");
        Initiator i = null;
        try {
            Trace.verbose((Object)this, "getItemByInstanceID", "Querying CIM for StorageHardwareIDs matching: " + wwn);
            Enumeration enumeration = CIMObjectWrapper.execQuery(this.context.getClient(), "Select * from SunStorEdge_DSPStorageHardwareID where InstanceID = '" + wwn + "'");
            Trace.verbose((Object)this, "getItemByInstanceID", "Returned from querying CIM for StorageHardwareIDs matching: " + wwn);
            if (enumeration != null && enumeration.hasMoreElements()) {
                while (enumeration.hasMoreElements()) {
                    Trace.verbose((Object)this, "getItemByInstanceID", "Found instance, creating Initiator object.");
                    CIMInstance ci = (CIMInstance)enumeration.nextElement();
                    i = new Initiator();
                    i.setInstance(ci);
                    i.init(this.context);
                    CIMObjectWrapper.populate(i, i.getFieldMap(), ci);
                    i.loadKeys();
                    Trace.verbose((Object)this, "getItemByInstanceID", "Finished creating Initiator object.");
                }
            }
            if (i == null) {
                Trace.verbose((Object)this, "getItemByInstanceID", "No Initiator found with wwn: " + wwn);
                return null;
            }
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "getItemByInstanceID", "Failed: " + cme);
            throw cme;
        }
        catch (NullPointerException npe) {
            Trace.error((Object)this, "getItemByInstanceID", "NullPointerException - Null returned when trying to obtain Initiator: " + wwn + " :" + npe);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - Problems getting Initiator: " + wwn, npe);
        }
        catch (Exception e) {
            Trace.error((Object)this, "getItemByInstanceID", "Exception - Exception thrown when trying to obtain Initiator: " + wwn + " :" + e);
            throw new ConfigMgmtException("error.systemError", "Exception - Problems getting Initiator: " + wwn, e);
        }
        Trace.verbose((Object)this, "getItemByInstanceID", "Returning Initiator Object: " + i.getWWN());
        return i;
    }

    public InitiatorInterface getByKey(Collection props) throws ConfigMgmtException {
        Trace.methodBegin(this, "getByKey");
        Initiator i = null;
        try {
            if (props != null) {
                CIMObjectPath objPath = new CIMObjectPath("SunStorEdge_DSPStorageHardwareID", new Vector(props));
                Trace.verbose((Object)this, "getByKey", "Querying CIM for StorageHardwareID matching key");
                CIMInstance ci = this.handle.getInstance(objPath, false, true, false, ConstantsEnt.StorageHardwareIDProperties.PROPERTY_NAMES);
                Trace.verbose((Object)this, "getByKey", "Returned from querying CIM for StorageHardwareID matching key");
                if (ci != null) {
                    Trace.verbose((Object)this, "getByKey", "Found instance, creating Initiator object");
                    i = new Initiator();
                    i.setInstance(ci);
                    i.init(this.context);
                    CIMObjectWrapper.populate(i, i.getFieldMap(), ci);
                    i.loadKeys();
                    Trace.verbose((Object)this, "getByKey", "Finished creating Initiator object");
                }
            } else {
                Trace.error((Object)this, "getByKey", "Key object is null.");
                throw new ConfigMgmtException("NULL_VALUE_RETURNED", "Key object is null.");
            }
            if (i == null) {
                Trace.verbose((Object)this, "getByKey", "No Initiator found matching key(s).");
                return null;
            }
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "getByKey", "Failed: " + cme);
            throw cme;
        }
        catch (NullPointerException npe) {
            Trace.error((Object)this, "getByKey", "NullPointerException - Null returned when trying to obtain the Initiator instance matching key(s): " + npe);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - Problems getting the Initiator instance matching key(s).", npe);
        }
        catch (Exception e) {
            Trace.error((Object)this, "getByKey", "Exception - Exception thrown when trying to obtain the Initiator instance matching key(s): " + e);
            throw new ConfigMgmtException("error.systemError", "Exception - Problems getting the Initiator instance matching key(s).", e);
        }
        Trace.verbose((Object)this, "getByKey", "Returning the Initiator Object matching key(s)");
        return i;
    }

    public String getNextAvailableName() throws ConfigMgmtException {
        Trace.methodBegin(this, "getNextAvailableName");
        String nextAvailableName = "server1";
        try {
            for (int i = 2; i < 1024; ++i) {
                Enumeration enumeration = CIMObjectWrapper.execQuery(this.context.getClient(), "Select * from SunStorEdge_DSPStorageHardwareID where ElementName = '" + nextAvailableName + "'");
                if (!enumeration.hasMoreElements()) {
                    return nextAvailableName;
                }
                Integer num = new Integer(i);
                nextAvailableName = "server" + num.toString();
            }
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "getNextAvailableName", "Failed: " + cme);
            throw cme;
        }
        catch (NullPointerException npe) {
            Trace.error((Object)this, "getNextAvailableName", "NullPointerException - Null returned when trying to obtain the next available Initiator name: " + npe);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - Problems getting the next available Initiator name.", npe);
        }
        catch (Exception e) {
            Trace.error((Object)this, "getNextAvailableName", "Exception - Exception thrown when trying to obtain the next available creation name: " + e);
            throw new ConfigMgmtException("error.systemError", "Exception - Problems getting the next available creation name.", e);
        }
        return null;
    }

    public MethodCallStatus create(String name, String wwn, String desc, int osType, String storageDomainName) throws ConfigMgmtException, BadParameterException, ItemNotFoundException {
        Trace.methodBegin(this, "create");
        MethodCallStatus methodCallStatus = new MethodCallStatus();
        try {
            Trace.verbose((Object)this, "create", "Validating name, description and os type");
            this.validateName(name);
            this.validateDescription(desc);
            if (wwn.length() != 16) {
                Trace.error((Object)this, "create", "WWN: " + wwn + " is malformed, must be 16 characters.");
                throw new BadParameterException(wwn, "error.bizobj.initiatorInvalidWwn");
            }
            if (osType != 4 && osType != 32768 && osType != 2) {
                Trace.error((Object)this, "create", "OS Type:  " + osType + " is invalid.");
                throw new BadParameterException(new Integer(osType).toString(), "error.bizobj.osTypeInvalid");
            }
            Trace.verbose((Object)this, "create", "Finding Proper StorageClientSettingData Instance");
            Trace.verbose((Object)this, "create", "Querying CIM for StorageClientSettingData Instances");
            Enumeration enumeration = this.handle.enumerateInstances(new CIMObjectPath("SunStorEdge_DSPStorageClientSettingData"), false, false, true, false, null);
            Trace.verbose((Object)this, "create", "Returned from querying CIM for StorageClientSettingData Instances");
            CIMInstance setting = null;
            if (enumeration != null && enumeration.hasMoreElements()) {
                while (enumeration.hasMoreElements()) {
                    UnsignedInt16 os;
                    Trace.verbose((Object)this, "create", "StorageClientSettingData Instances Found");
                    CIMInstance instance = (CIMInstance)enumeration.nextElement();
                    Trace.verbose((Object)this, "create", "Getting OS Type information");
                    CIMValue cv = instance.getProperty("ClientTypes").getValue();
                    Vector osTypes = new Vector();
                    if (cv != null) {
                        osTypes = (Vector)cv.getValue();
                    } else {
                        Trace.error((Object)this, "create", "Errors retrieving StorageClientSettingData 'ClientTypes'.");
                    }
                    Trace.verbose((Object)this, "create", "Searching for correct OS Type");
                    if (osTypes.size() == 0 || !(os = (UnsignedInt16)osTypes.get(0)).equals((Object)new UnsignedInt16(osType))) continue;
                    Trace.verbose((Object)this, "create", "Correct StorageClientSettingData found with OS: " + osType);
                    setting = instance;
                    break;
                }
            }
            CIMObjectPath settingPath = null;
            if (setting != null) {
                settingPath = setting.getObjectPath();
            }
            CIMArgument[] inArgs = new CIMArgument[]{new CIMArgument("ElementName", new CIMValue((Object)name)), new CIMArgument("StorageID", new CIMValue((Object)wwn)), new CIMArgument("IDType", new CIMValue((Object)new UnsignedInt16(2))), new CIMArgument("OtherIDType", new CIMValue(null)), new CIMArgument("Setting", new CIMValue((Object)settingPath))};
            CIMArgument[] outArgs = new CIMArgument[1];
            Trace.verbose((Object)this, "create", "Attempting to get the StorageHardwareIDManagementService");
            CIMObjectPath confServiceObjectPath = ServiceFinder.getService(this.handle, storageDomainName, 3);
            Trace.verbose((Object)this, "create", "StorageHardwareIDManagementService object path is: " + confServiceObjectPath);
            Trace.verbose((Object)this, "create", "Calling CreateStorageHardwareID");
            CIMValue returnCodeValue = this.handle.invokeMethod(confServiceObjectPath, "CreateStorageHardwareID", inArgs, outArgs);
            Trace.verbose((Object)this, "create", "Returned from CreateStorageHardwareID");
            int retVal = (Integer)returnCodeValue.getValue();
            methodCallStatus.setReturnCode(retVal);
            if (retVal == 0) {
                Initiator newInitiator = (Initiator)this.getItemByName(name);
                if (newInitiator != null) {
                    Trace.verbose((Object)this, "create", "Setting description: " + desc);
                    newInitiator.setDescription(desc);
                    newInitiator.save();
                } else {
                    Trace.verbose((Object)this, "create", "Could not set description, Initiator: " + name + " not found.");
                }
            }
        }
        catch (BadParameterException bpe) {
            Trace.error((Object)this, "create", "Invalid Parameter: " + bpe);
            throw bpe;
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "create", "Failed: " + cme);
            throw cme;
        }
        catch (NullPointerException npe) {
            Trace.error((Object)this, "create", "NullPointerException - Null returned when trying to create the Initiator instance: " + npe);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - Problems creating the Initiator instance.", npe);
        }
        catch (Exception e) {
            Trace.error((Object)this, "create", "Exception - Exception thrown when trying to create Initiator: " + e);
            throw new ConfigMgmtException("error.systemError", "Exception - Problems creating Initiator.", e);
        }
        return methodCallStatus;
    }

    public MethodCallStatus delete(Collection key) throws ConfigMgmtException, ItemNotFoundException {
        Trace.methodBegin(this, "delete");
        MethodCallStatus methodCallStatus = new MethodCallStatus();
        try {
            Trace.verbose((Object)this, "delete", "Attempting to retrieve Initiator by key(s)");
            Initiator initiator = (Initiator)this.getByKey(key);
            if (initiator == null) {
                Trace.error((Object)this, "delete", "Initiator matching key(s) not found.");
                throw new ItemNotFoundException("Initiator");
            }
            CIMArgument[] inArgs = new CIMArgument[]{new CIMArgument("HardwareID", new CIMValue((Object)initiator.getInstance().getObjectPath()))};
            CIMArgument[] outArgs = new CIMArgument[1];
            Trace.verbose((Object)this, "delete", "Attempting to get the StorageHardwareIDManagementService");
            CIMObjectPath confServiceObjectPath = ServiceFinder.getService(this.handle, initiator.getStorageDomain(), 3);
            Trace.verbose((Object)this, "delete", "StorageHardwareIDManagementService object path is: " + confServiceObjectPath);
            Trace.verbose((Object)this, "delete", "Calling DeleteStorageHardwareID");
            CIMValue returnCodeValue = this.handle.invokeMethod(confServiceObjectPath, "DeleteStorageHardwareID", inArgs, outArgs);
            Trace.verbose((Object)this, "delete", "Returned from DeleteStorageHardwareID");
            int retVal = (Integer)returnCodeValue.getValue();
            methodCallStatus.setReturnCode(retVal);
            Trace.verbose((Object)this, "delete", "Deletion completed, return code: " + retVal);
        }
        catch (ItemNotFoundException infe) {
            Trace.error((Object)this, "delete", "Initiator not found.");
            throw infe;
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "delete", "Failed: " + cme);
            throw cme;
        }
        catch (NullPointerException npe) {
            Trace.error((Object)this, "delete", "NullPointerException - Null returned when trying to delete the Initiator instance: " + npe);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - Problems deleting the Initiator instance.", npe);
        }
        catch (Exception e) {
            Trace.error((Object)this, "delete", "Exception - Exception thrown when trying to delete Initiator: " + e);
            throw new ConfigMgmtException("error.systemError", "Exception - Problems deleting Initiator.", e);
        }
        return methodCallStatus;
    }

    protected int modifyOS(Initiator ini, int osType) throws ConfigMgmtException {
        String METHOD = "modifyOS";
        Trace.methodBegin(this, "modifyOS");
        if (osType != 4) {
            if (osType != 32768) {
                if (osType != 2) {
                    Trace.error((Object)this, "modifyOS", "OS Type:  " + osType + " is invalid.");
                    throw new BadParameterException(new Integer(osType).toString(), "error.bizobj.osTypeInvalid");
                }
            }
        }
        Trace.verbose((Object)this, "modifyOS", "Querying CIM for StorageClientSettingData Instances");
        Enumeration enumeration = this.handle.enumerateInstances(new CIMObjectPath("SunStorEdge_DSPStorageClientSettingData"), false, false, true, false, null);
        Trace.verbose((Object)this, "modifyOS", "Returned from querying CIM for StorageClientSettingData Instances");
        CIMInstance setting = null;
        int retVal = -1;
        if (enumeration != null && enumeration.hasMoreElements()) {
            while (enumeration.hasMoreElements()) {
                UnsignedInt16 os;
                Trace.verbose((Object)this, "modifyOS", "StorageClientSettingData Instances Found");
                CIMInstance instance = (CIMInstance)enumeration.nextElement();
                Trace.verbose((Object)this, "modifyOS", "Getting OS Type information");
                CIMValue cv = instance.getProperty("ClientTypes").getValue();
                Vector osTypes = new Vector();
                if (cv != null) {
                    osTypes = (Vector)cv.getValue();
                } else {
                    Trace.error((Object)this, "modifyOS", "Errors retrieving StorageClientSettingData 'ClientTypes'.");
                }
                Trace.verbose((Object)this, "modifyOS", "Searching for correct OS Type");
                if (osTypes.size() == 0 || !(os = (UnsignedInt16)osTypes.get(0)).equals((Object)new UnsignedInt16(osType))) continue;
                Trace.verbose((Object)this, "modifyOS", "Correct StorageClientSettingData found with OS: " + osType);
                setting = instance;
                break;
            }
            CIMObjectPath settingPath = null;
            if (setting != null) {
                settingPath = setting.getObjectPath();
            }
            CIMArgument[] inArgs = new CIMArgument[]{new CIMArgument("ElementName", new CIMValue((Object)ini.getName())), new CIMArgument("StorageID", new CIMValue((Object)ini.getWWN())), new CIMArgument("IDType", new CIMValue((Object)new UnsignedInt16(2))), new CIMArgument("OtherIDType", new CIMValue(null)), new CIMArgument("Setting", new CIMValue((Object)settingPath))};
            CIMArgument[] outArgs = new CIMArgument[1];
            Trace.verbose((Object)this, "modifyOS", "Attempting to get the StorageHardwareIDManagementService");
            CIMObjectPath confServiceObjectPath = ServiceFinder.getService(this.handle, ini.getStorageDomain(), 3);
            Trace.verbose((Object)this, "modifyOS", "StorageHardwareIDManagementService object path is: " + confServiceObjectPath);
            Trace.verbose((Object)this, "modifyOS", "Calling CreateStorageHardwareID");
            CIMValue returnCodeValue = this.handle.invokeMethod(confServiceObjectPath, "CreateStorageHardwareID", inArgs, outArgs);
            Trace.verbose((Object)this, "modifyOS", "Returned from CreateStorageHardwareID");
            retVal = (Integer)returnCodeValue.getValue();
        }
        Trace.methodEnd(this, "modifyOS");
        return retVal;
    }

    public Comparator getInitiatorComparator(Locale loc) {
        return new InitiatorComparator(loc);
    }

    public void validateName(String name) throws ConfigMgmtException, BadParameterException {
        Trace.methodBegin(this, "validateName");
        if (name != null) {
            if (name.length() > 16) {
                Trace.error((Object)this, "validateName", "Name: " + name + " is too long.");
                throw new BadParameterException(name, "error.bizobj.nameTooLong");
            }
            if (!Pattern.matches("[A-Za-z0-9\\_\\-]+", name)) {
                Trace.error((Object)this, "validateName", "Name: " + name + " contains invalid characters.");
                throw new BadParameterException(name, "error.bizobj.invalidCharacter");
            }
            Initiator initiator = (Initiator)this.getItemByName(name);
            if (initiator != null) {
                Trace.error((Object)this, "validateName", "Name: " + name + " already exists.");
                throw new BadParameterException(name, "error.objectAlreadyExists");
            }
        } else {
            Trace.error((Object)this, "validateName", "Name is null.");
            throw new BadParameterException(name, "error.bizobj.noName");
        }
    }

    public void validateDescription(String description) throws BadParameterException {
        Trace.methodBegin(this, "validateDescription");
        if (description != null) {
            if (description.length() > 64) {
                Trace.error((Object)this, "validateDescription", "Description: " + description + " is too long.");
                throw new BadParameterException(description, "error.bizobj.descriptionTooLong");
            }
            if (!Pattern.matches("[A-Za-z0-9\\_\\-\\.\\:\\,\\%\\(\\)\\{\\}\\[\\]\\`\\~\\| ]*", description)) {
                Trace.error((Object)this, "validateDescription", "Description: " + description + " contains invalid characters.");
                throw new BadParameterException(description, "error.bizobj.invalidDescCharacter");
            }
        }
    }

    public void setRestriction(int restriction) {
        Trace.methodBegin(this, "setRestriction");
    }

    public List getItemList() throws ConfigMgmtException {
        Trace.methodBegin(this, "getItemList");
        return null;
    }

    public void createInitiator(T4Interface t4, String wwn, String description, List initiatorGroups) throws ConfigMgmtException {
        Trace.methodBegin(this, "createInitiator");
    }

    public void setScope(InstanceWrapper scope) {
        Trace.methodBegin(this, "setScope");
    }

    public class InitiatorComparator
    implements Comparator {
        Collator collator = null;

        InitiatorComparator(Locale loc) {
            this.collator = loc != null ? Collator.getInstance(loc) : Collator.getInstance();
        }

        public int compare(Object element1, Object element2) {
            CollationKey key1 = null;
            CollationKey key2 = null;
            if (element1 instanceof Initiator && element2 instanceof Initiator) {
                key1 = this.collator.getCollationKey(((Initiator)element1).getWWN());
                key2 = this.collator.getCollationKey(((Initiator)element2).getWWN());
            } else {
                key1 = this.collator.getCollationKey(element1.toString());
                key2 = this.collator.getCollationKey(element2.toString());
            }
            return key1.compareTo(key2);
        }
    }
}

