/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.access.business.impl.ent1;

import com.sun.netstorage.array.mgmt.cfg.access.business.InitiatorInterface;
import com.sun.netstorage.array.mgmt.cfg.access.business.impl.ent1.ManageInitiators;
import com.sun.netstorage.array.mgmt.cfg.core.CIMOMHandleWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.ConstantsEnt;
import com.sun.netstorage.array.mgmt.cfg.core.ErrorCode;
import com.sun.netstorage.array.mgmt.cfg.core.ErrorDescriptor;
import com.sun.netstorage.array.mgmt.cfg.core.MethodCallStatus;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.BadParameterException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.impl.CIMObjectWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.impl.MapElement;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.InitiatorVolumeMappingInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageVolumeInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.InitiatorVolumeMapping;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.ServiceFinder;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.StorageVolume;
import com.sun.netstorage.array.mgmt.cfg.util.ItemNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.wbem.cim.CIMArgument;
import javax.wbem.cim.CIMDataType;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt16;

public class Initiator
implements InitiatorInterface {
    private ConfigContext context;
    private CIMOMHandleWrapper handle;
    private CIMInstance instance;
    private Collection keyProperties;
    private String instanceID;
    private String name;
    private String WWN;
    private String description;
    private String storageDomainName;
    private int state;
    private int status;
    private int osType = 0;
    private ArrayList mappingList;
    private ArrayList fieldMap;
    private Vector luns = null;

    public Initiator() {
        Trace.constructor(this);
    }

    public void init(ConfigContext context) throws ConfigMgmtException {
        Trace.methodBegin(this, "init");
        if (context == null) {
            Trace.error((Object)this, "init", "ConfigContext object is null.");
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "ConfigContext object is null.");
        }
        this.context = context;
        this.handle = context.getClient();
        if (this.handle == null) {
            Trace.error((Object)this, "init", "CIMOMHandleWrapper value is null.");
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "CIMOMHandleWrapper value is null.");
        }
    }

    public void save() throws ConfigMgmtException {
        Trace.methodBegin(this, "save");
        CIMObjectWrapper.save(this, this.getFieldMap(), this.instance, this.handle);
        if (Trace.isTraceEnabled(this)) {
            Trace.verbose((Object)this, "save", "Object saved: " + this.toString());
        }
    }

    public void reload() throws ConfigMgmtException {
        Trace.methodBegin(this, "reload");
        CIMInstance ci = this.handle.getInstance(this.instance.getObjectPath(), false, true, false, ConstantsEnt.StorageHardwareIDProperties.PROPERTY_NAMES);
        this.setInstance(ci);
        CIMObjectWrapper.populate(this, this.getFieldMap(), ci);
        this.loadKeys();
        if (Trace.isTraceEnabled(this)) {
            Trace.verbose((Object)this, "reload", "Object reloaded: " + this.toString());
        }
    }

    public String getName() {
        Trace.methodBegin(this, "getName");
        if (this.name == null) {
            return "";
        }
        return this.name;
    }

    public String getWWN() {
        Trace.methodBegin(this, "getWWN");
        if (this.WWN == null) {
            return "";
        }
        return this.WWN;
    }

    public String getDescription() {
        Trace.methodBegin(this, "getDescription");
        if (this.description == null) {
            return "";
        }
        return this.description;
    }

    public String getStorageDomain() {
        Trace.methodBegin(this, "getStorageDomain");
        if (this.storageDomainName == null) {
            return "";
        }
        return this.storageDomainName;
    }

    public int getState() {
        Trace.methodBegin(this, "getState");
        return this.state;
    }

    public int getStatus() {
        Trace.methodBegin(this, "getStatus");
        return this.status;
    }

    public String getGroupName() {
        Trace.methodBegin(this, "getGroupName");
        return null;
    }

    public int getOSType() {
        Trace.methodBegin(this, "getOSType");
        return this.osType;
    }

    public ArrayList getVolumeMappings() throws ConfigMgmtException {
        Trace.methodBegin(this, "getVolumeMappings");
        return this.getMappingsHelper(null);
    }

    public InitiatorVolumeMappingInterface getVolumeMapping(String volName) throws ConfigMgmtException, ItemNotFoundException {
        Trace.methodBegin(this, "getVolumeMapping");
        ArrayList results = this.getMappingsHelper(volName);
        if (!results.isEmpty()) {
            return (InitiatorVolumeMappingInterface)results.get(0);
        }
        Trace.error((Object)this, "getVolumeMapping", "StorageVolume not found to be mapped");
        throw new ItemNotFoundException(volName);
    }

    public Collection getKey() {
        Trace.methodBegin(this, "getKey");
        return this.keyProperties;
    }

    public String getPopname() {
        Trace.methodBegin(this, "getPopname");
        if (this.name == null) {
            return "";
        }
        return this.name;
    }

    public int getPoptype() {
        Trace.methodBegin(this, "getPoptype");
        return this.osType;
    }

    public CIMInstance getInstance() {
        Trace.methodBegin(this, "getInstance");
        return this.instance;
    }

    public String getInstanceID() {
        Trace.methodBegin(this, "getInstanceID");
        return this.instanceID;
    }

    public void setName(String name) throws ConfigMgmtException, BadParameterException {
        Trace.methodBegin(this, "setName");
        Trace.verbose((Object)this, "setName", "Validating name: " + name);
        ManageInitiators mi = new ManageInitiators();
        mi.init(this.context, null);
        mi.validateName(name);
        Trace.verbose((Object)this, "setName", "Name: " + name + " validated, setting...");
        this.name = name;
    }

    public void setGroupName(String groupName) {
        Trace.methodBegin(this, "setGroupName");
    }

    public void setDescription(String description) throws BadParameterException {
        Trace.methodBegin(this, "setDescription");
        Trace.verbose((Object)this, "setDescription", "Validating description: " + description);
        ManageInitiators mi = new ManageInitiators();
        mi.validateDescription(this.name);
        Trace.verbose((Object)this, "setDescription", "Description: " + description + " validated, setting...");
        this.description = description;
    }

    public void setOSType(int osType) throws ConfigMgmtException, BadParameterException {
        String METHOD = "setOSType";
        Trace.methodBegin(this, "setOSType");
        ManageInitiators mi = new ManageInitiators();
        mi.init(this.context, null);
        int retVal = mi.modifyOS(this, osType);
        if (retVal != 0 && retVal != 4096) {
            Trace.error((Object)this, "setOSType", "Error modifying OSType: " + retVal);
            throw new ConfigMgmtException(new ErrorDescriptor(ErrorCode.CIM_ERROR, retVal, null, "Error code returned: " + retVal), 300);
        }
        this.osType = osType;
        Trace.methodEnd(this, "setOSType");
    }

    public void setWWN(String WWN) {
        Trace.methodBegin(this, "setWWN");
        this.WWN = WWN;
    }

    public void setState(int state) {
        Trace.methodBegin(this, "setState");
        this.state = state;
    }

    public void setStatus(int status) {
        Trace.methodBegin(this, "setStatus");
        this.status = status;
    }

    public void setKey(Collection keyProperties) {
        Trace.methodBegin(this, "setKey");
        this.keyProperties = keyProperties;
    }

    public void setInstanceID(String instanceID) {
        Trace.methodBegin(this, "setInstanceID");
        this.instanceID = instanceID;
    }

    public void setInstance(CIMInstance instance) {
        Trace.methodBegin(this, "setInstance");
        this.instance = instance;
    }

    public void setStorageDomainName(String storageDomainName) {
        Trace.methodBegin(this, "setStorageDomainName");
        this.storageDomainName = storageDomainName;
    }

    public void setPopname(String popname) {
        Trace.methodBegin(this, "setPopname");
        this.name = popname;
    }

    public void setPoptype(int poptype) {
        Trace.methodBegin(this, "setPoptype");
        this.osType = poptype;
    }

    private ArrayList getMappingsHelper(String search) throws ConfigMgmtException {
        Trace.methodBegin(this, "getMappingsHelper");
        ArrayList<InitiatorVolumeMapping> mappings = new ArrayList<InitiatorVolumeMapping>();
        try {
            Trace.verbose((Object)this, "getMappingsHelper", "Querying CIM for Privilige Instances");
            Enumeration enumPrivileges = this.handle.associators(this.instance.getObjectPath(), "SunStorEdge_DSPAuthorizedSubject", "SunStorEdge_DSPPrivilege", "PrivilegedElement", "Privilege", false, false, null);
            Trace.verbose((Object)this, "getMappingsHelper", "Returned from querying CIM for Privilige Instances");
            if (enumPrivileges != null && enumPrivileges.hasMoreElements()) {
                while (enumPrivileges.hasMoreElements()) {
                    Trace.verbose((Object)this, "getMappingsHelper", "Privilige Instances Found");
                    CIMInstance privilege = (CIMInstance)enumPrivileges.nextElement();
                    Trace.verbose((Object)this, "getMappingsHelper", "Querying CIM for SCSIProtocolController Instances");
                    Enumeration enumSCSI = this.handle.associators(privilege.getObjectPath(), "SunStorEdge_DSPAuthorizedTarget", "SunStorEdge_DSPSCSIProtocolController", "Privilege", "TargetElement", false, false, null);
                    Trace.verbose((Object)this, "getMappingsHelper", "Returned from querying CIM for SCSIProtocolController Instances");
                    if (enumSCSI == null || !enumSCSI.hasMoreElements()) continue;
                    Trace.verbose((Object)this, "getMappingsHelper", "SCSIProtocolController Instance Found");
                    CIMInstance scsi = (CIMInstance)enumSCSI.nextElement();
                    if (!scsi.getClassName().equals("SunStorEdge_DSPSCSIProtocolController")) continue;
                    CIMProperty inUseLuns = scsi.getProperty("InUseLuns");
                    if (inUseLuns == null) {
                        Trace.verbose((Object)this, "getMappingsHelper", "Mapped luns not found, returning.");
                        return new ArrayList();
                    }
                    this.luns = (Vector)inUseLuns.getValue().getValue();
                    CIMProperty volumePermissions = scsi.getProperty("VolumePermissions");
                    if (volumePermissions == null) {
                        Trace.verbose((Object)this, "getMappingsHelper", "Mapped permissions not found, returning.");
                        return new ArrayList();
                    }
                    Vector permissions = (Vector)volumePermissions.getValue().getValue();
                    CIMProperty mappedVolumes = scsi.getProperty("MappedVolumes");
                    if (mappedVolumes == null) {
                        Trace.verbose((Object)this, "getMappingsHelper", "Mapped volumes not found, returning.");
                        return new ArrayList();
                    }
                    Vector volumes = (Vector)mappedVolumes.getValue().getValue();
                    CIMProperty cp_mapStates = scsi.getProperty("MapState");
                    Vector v_mapStates = null;
                    if (cp_mapStates != null && (v_mapStates = (Vector)cp_mapStates.getValue().getValue()).size() != this.luns.size()) {
                        v_mapStates = null;
                    }
                    CIMValue c_systemName = scsi.getProperty("SystemName").getValue();
                    int l_size = this.luns.size();
                    for (int x = 0; x < l_size; ++x) {
                        if (Trace.isTraceEnabled(this)) {
                            Trace.verbose((Object)this, "getMappingsHelper", "Querying CIM for StorageVolume matching: " + volumes.get(x));
                        }
                        CIMObjectPath volPath = new CIMObjectPath("SunStorEdge_DSPStorageVolume");
                        volPath.addKey("SystemCreationClassName", new CIMValue((Object)"SunStorEdge_DSPStorageDomain"));
                        volPath.addKey("CreationClassName", new CIMValue((Object)"SunStorEdge_DSPStorageVolume"));
                        volPath.addKey("SystemName", c_systemName);
                        volPath.addKey("DeviceID", new CIMValue(volumes.get(x)));
                        if (Trace.isTraceEnabled(this)) {
                            Trace.verbose((Object)this, "getMappingsHelper", "Returned from querying CIM for StorageVolume matching: " + volumes.get(x));
                        }
                        CIMInstance volumeInstance = this.handle.getInstance(volPath, false, true, false, null);
                        StorageVolume sv = new StorageVolume();
                        if (volumeInstance == null) {
                            Trace.error((Object)this, "getMappingsHelper", "Volume not found matching: " + volumes.get(x));
                            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "Problems obtaining StorageVolume mappings at volume discovery stage.");
                        }
                        sv = new StorageVolume();
                        sv.setInstance(volumeInstance);
                        sv.init(this.context);
                        CIMObjectWrapper.populate(sv, sv.getFieldMap(), volumeInstance);
                        sv.loadKeys();
                        Trace.verbose((Object)this, "getMappingsHelper", "Creating InitiatorVolumeMapping Object");
                        HashSet<Integer> perms = new HashSet<Integer>();
                        if (((UnsignedInt16)permissions.get(x)).intValue() == 5) {
                            perms.add(new Integer("5"));
                        } else {
                            perms.add(new Integer("5"));
                            perms.add(new Integer("6"));
                        }
                        InitiatorVolumeMapping ivm = new InitiatorVolumeMapping(((UnsignedInt16)this.luns.get(x)).toString(), perms, sv);
                        if (v_mapStates != null) {
                            String m_value = (String)v_mapStates.get(x);
                            ivm.setState(m_value);
                        }
                        mappings.add(ivm);
                        Trace.verbose((Object)this, "getMappingsHelper", "Finished creating InitiatorVolumeMapping Object");
                    }
                }
            }
            if (search != null) {
                Trace.verbose((Object)this, "getMappingsHelper", "Retrieving Specific Mapping for: " + search);
                InitiatorVolumeMappingInterface ivmi = new InitiatorVolumeMapping();
                StorageVolumeInterface svi = new StorageVolume();
                for (int i = 0; i < mappings.size(); ++i) {
                    ivmi = (InitiatorVolumeMappingInterface)mappings.get(i);
                    svi = (StorageVolumeInterface)ivmi.getObject();
                    if (!svi.getName().equals(search)) continue;
                    Trace.verbose((Object)this, "getMappingsHelper", "Mapping for: " + search + " found.");
                    ArrayList searchResult = new ArrayList();
                    searchResult.add(mappings.get(i));
                    return searchResult;
                }
                return new ArrayList();
            }
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "getMappingsHelper", "Failed: " + cme);
            throw cme;
        }
        catch (NullPointerException npe) {
            Trace.error((Object)this, "getMappingsHelper", "NullPointerException - Null returned when trying obtain StorageVolume mappings: " + npe);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - Problems obtaining StorageVolume mappings.", npe);
        }
        catch (Exception e) {
            Trace.error((Object)this, "getMappingsHelper", "Exception - Exception thrown when trying to obtain StorageVolume mappings: " + e);
            throw new ConfigMgmtException("error.systemError", "Exception - Problems obtaining StorageVolume mappings.", e);
        }
        Trace.verbose((Object)this, "getMappingsHelper", "Returning Mappings");
        return mappings;
    }

    public MethodCallStatus mappingCreationHelper(String lun, Set permissions, CIMInstance volume, CIMInstance initiator) throws ConfigMgmtException {
        Trace.methodBegin(this, "mappingCreationHelper");
        MethodCallStatus methodCallStatus = new MethodCallStatus();
        CIMObjectPath rwPrivilege = null;
        CIMObjectPath roPrivilege = null;
        CIMObjectPath pcController = null;
        this.luns = null;
        try {
            CIMValue returnCodeValue;
            CIMArgument[] outArgs;
            CIMArgument[] inArgs;
            Trace.verbose((Object)this, "mappingCreationHelper", "Getting associated PrivilegeManagementService");
            CIMObjectPath privilegeServiceObjectPath = ServiceFinder.getService(this.handle, this.getStorageDomain(), 2);
            Trace.verbose((Object)this, "mappingCreationHelper", "PrivilegeManagementService object path is: " + privilegeServiceObjectPath);
            Trace.verbose((Object)this, "mappingCreationHelper", "Getting associated ControllerConfigurationService");
            CIMObjectPath controllerConfigurationServiceObjectPath = ServiceFinder.getService(this.handle, this.getStorageDomain(), 1);
            Trace.verbose((Object)this, "mappingCreationHelper", "ControllerConfigurationService object path is: " + controllerConfigurationServiceObjectPath);
            Trace.verbose((Object)this, "mappingCreationHelper", "Querying CIM for Privilege Instances");
            Enumeration enumPrivileges = this.handle.associators(initiator.getObjectPath(), "SunStorEdge_DSPAuthorizedSubject", "SunStorEdge_DSPPrivilege", "PrivilegedElement", "Privilege", true, false, null);
            Trace.verbose((Object)this, "mappingCreationHelper", "Returned from querying CIM for Privilege Instances");
            if (enumPrivileges == null || !enumPrivileges.hasMoreElements()) {
                Trace.verbose((Object)this, "mappingCreationHelper", "Privilege Instances Not Found");
                Trace.verbose((Object)this, "mappingCreationHelper", "Creating mapping base structure");
                Trace.verbose((Object)this, "mappingCreationHelper", "Creating R/W Privilege");
                Enumeration enumTemplatePriv = this.handle.associators(privilegeServiceObjectPath, "SunStorEdge_DSPHostedDependency", "SunStorEdge_DSPPrivilege", "Antecedent", "Dependent", true, false, null);
                if (enumTemplatePriv == null || !enumTemplatePriv.hasMoreElements()) {
                    Vector<UnsignedInt16> privs = new Vector<UnsignedInt16>();
                    privs.add(new UnsignedInt16("5"));
                    privs.add(new UnsignedInt16("6"));
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("InstanceID", new Date().getTime() + "");
                    rwPrivilege = CIMObjectWrapper.createInstance(this.handle, CIMObjectWrapper.instanceKeyBuilder(map), "SunStorEdge_DSPPrivilege");
                    CIMInstance privInstance = this.handle.getInstance(rwPrivilege, false, true, false, null);
                    privInstance.setProperty("Activities", new CIMValue(privs, new CIMDataType(16)));
                    this.handle.setInstance(rwPrivilege, privInstance);
                } else {
                    CIMInstance templatePriv = (CIMInstance)enumTemplatePriv.nextElement();
                    rwPrivilege = templatePriv.getObjectPath();
                }
                Trace.verbose((Object)this, "mappingCreationHelper", "Creating Protocol Controller");
                Trace.verbose((Object)this, "mappingCreationHelper", "Creating SCSIProtocolController");
                CIMArgument[] inArgs2 = new CIMArgument[]{new CIMArgument("ElementName", new CIMValue((Object)this.name)), new CIMArgument("Ports", new CIMValue(null)), new CIMArgument("Protocol", new CIMValue((Object)new UnsignedInt16(2))), new CIMArgument("Privilege", new CIMValue((Object)rwPrivilege)), new CIMArgument("Identity", new CIMValue((Object)this.instance.getObjectPath()))};
                CIMArgument[] outArgs2 = new CIMArgument[1];
                Trace.verbose((Object)this, "mappingCreationHelper", "Calling CreateProtocolControllerWithPorts");
                CIMValue returnCodeValue2 = this.handle.invokeMethod(controllerConfigurationServiceObjectPath, "CreateProtocolControllerWithPorts", inArgs2, outArgs2);
                pcController = (CIMObjectPath)outArgs2[0].getValue().getValue();
                Trace.verbose((Object)this, "mappingCreationHelper", "Returned from calling CreateProtocolControllerWithPorts");
                int returnVal = (Integer)returnCodeValue2.getValue();
                if (returnVal != 0) {
                    Trace.verbose((Object)this, "mappingCreationHelper", "CreateProtocolControllerWithPorts Failed");
                    methodCallStatus.setReturnCode(returnVal);
                    return methodCallStatus;
                }
            } else {
                while (enumPrivileges.hasMoreElements()) {
                    CIMInstance privilege = (CIMInstance)enumPrivileges.nextElement();
                    Trace.verbose((Object)this, "mappingCreationHelper", "Querying CIM for SCSIProtocolController Instances");
                    Enumeration enumSCSI = this.handle.associators(privilege.getObjectPath(), "SunStorEdge_DSPAuthorizedTarget", "SunStorEdge_DSPSCSIProtocolController", "Privilege", "TargetElement", true, false, null);
                    Trace.verbose((Object)this, "mappingCreationHelper", "Returned from querying CIM for SCSIProtocolController Instances");
                    if (enumSCSI == null || !enumSCSI.hasMoreElements()) continue;
                    CIMInstance scsi = (CIMInstance)enumSCSI.nextElement();
                    if (scsi.getClassName().equals("SunStorEdge_DSPSCSIProtocolController")) {
                        Trace.verbose((Object)this, "mappingCreationHelper", "SCSIProtocolController Instance Found");
                        rwPrivilege = privilege.getObjectPath();
                        pcController = scsi.getObjectPath();
                        continue;
                    }
                    roPrivilege = privilege.getObjectPath();
                }
            }
            Trace.verbose((Object)this, "mappingCreationHelper", "Attaching Device Properly");
            if (permissions.size() == 1) {
                if (roPrivilege == null) {
                    Trace.verbose((Object)this, "mappingCreationHelper", "Creating RO Privilege");
                    Vector<UnsignedInt16> privs = new Vector<UnsignedInt16>();
                    privs.add(new UnsignedInt16("5"));
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("InstanceID", new Date().getTime() + "");
                    roPrivilege = CIMObjectWrapper.createInstance(this.handle, CIMObjectWrapper.instanceKeyBuilder(map), "SunStorEdge_DSPPrivilege");
                    CIMInstance privInstance = this.handle.getInstance(roPrivilege, false, true, false, null);
                    privInstance.setProperty("Activities", new CIMValue(privs, new CIMDataType(16)));
                    this.handle.setInstance(roPrivilege, privInstance);
                }
                inArgs = new CIMArgument[]{new CIMArgument("Subject", new CIMValue((Object)this.instance.getObjectPath())), new CIMArgument("PrivilegeGranted", new CIMValue(null)), new CIMArgument("Activities", new CIMValue(null)), new CIMArgument("ActivityQualifiers", new CIMValue(null)), new CIMArgument("QualifierFormats", new CIMValue(null)), new CIMArgument("Target", new CIMValue((Object)volume.getObjectPath())), new CIMArgument("Privilege", new CIMValue((Object)roPrivilege))};
                outArgs = new CIMArgument[1];
                Trace.verbose((Object)this, "mappingCreationHelper", "Calling AssignAccess");
                returnCodeValue = this.handle.invokeMethod(privilegeServiceObjectPath, "AssignAccess", inArgs, outArgs);
                Trace.verbose((Object)this, "mappingCreationHelper", "Returned from calling AssignAccess");
                int returnVal = (Integer)returnCodeValue.getValue();
                if (returnVal != 0) {
                    Trace.verbose((Object)this, "mappingCreationHelper", "AssignAccess Failed");
                    methodCallStatus.setReturnCode(returnVal);
                    return methodCallStatus;
                }
            }
            Trace.verbose((Object)this, "mappingCreationHelper", "Attaching Device");
            inArgs = new CIMArgument[3];
            inArgs[0] = new CIMArgument("ProtocolController", new CIMValue(pcController));
            inArgs[1] = new CIMArgument("Device", new CIMValue((Object)volume.getObjectPath()));
            lun = Integer.toHexString(Integer.parseInt(lun));
            inArgs[2] = new CIMArgument("DeviceNumber", new CIMValue((Object)lun));
            outArgs = new CIMArgument[1];
            Trace.verbose((Object)this, "mappingCreationHelper", "Calling AttachDevice");
            returnCodeValue = this.handle.invokeMethod(controllerConfigurationServiceObjectPath, "AttachDevice", inArgs, outArgs);
            Trace.verbose((Object)this, "mappingCreationHelper", "Returned from calling AttachDevice");
            methodCallStatus.setReturnCode((Integer)returnCodeValue.getValue());
            return methodCallStatus;
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "mappingCreationHelper", "Failed: " + cme);
            throw cme;
        }
        catch (NullPointerException npe) {
            Trace.error((Object)this, "mappingCreationHelper", "NullPointerException - Null returned when trying create StorageVolume mappings: " + npe);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - Problems creating StorageVolume mappings.", npe);
        }
        catch (Exception e) {
            Trace.error((Object)this, "mappingCreationHelper", "Exception - Exception thrown when trying to create StorageVolume mappings: " + e);
            throw new ConfigMgmtException("error.systemError", "Exception - Problems creating StorageVolume mappings.", e);
        }
    }

    public MethodCallStatus createMapping(InitiatorVolumeMappingInterface mapping) throws ConfigMgmtException {
        Trace.methodBegin(this, "createMapping");
        MethodCallStatus methodCallStatus = this.mappingCreationHelper(mapping.getLun(), mapping.getPermissions(), ((StorageVolume)mapping.getObject()).getInstance(), this.instance);
        return methodCallStatus;
    }

    public MethodCallStatus createMapping(int lun, Set permissions, StorageVolumeInterface volume) throws ConfigMgmtException {
        Trace.methodBegin(this, "createMapping");
        Integer newLun = new Integer(lun);
        MethodCallStatus methodCallStatus = this.mappingCreationHelper(newLun.toString(), permissions, volume.getInstance(), this.instance);
        return methodCallStatus;
    }

    public MethodCallStatus createMapping(Set permissions, StorageVolumeInterface volume) throws ConfigMgmtException {
        Trace.methodBegin(this, "createMapping");
        MethodCallStatus methodCallStatus = this.mappingCreationHelper(new Integer(this.getNextAvailableLUN()).toString(), permissions, volume.getInstance(), this.instance);
        return methodCallStatus;
    }

    public MethodCallStatus removeMapping(StorageVolumeInterface volume) throws ConfigMgmtException, ItemNotFoundException {
        Trace.methodBegin(this, "removeMapping");
        ArrayList mappings = new ArrayList();
        MethodCallStatus methodCallStatus = new MethodCallStatus();
        this.luns = null;
        try {
            Trace.verbose((Object)this, "removeMapping", "Querying CIM for SCSIProtocolController Instance");
            Enumeration enumSCSI = this.handle.associators(volume.getInstance().getObjectPath(), "SunStorEdge_DSPProtocolControllerForUnit", "SunStorEdge_DSPSCSIProtocolController", "Dependent", "Antecedent", true, false, null);
            Trace.verbose((Object)this, "removeMapping", "Returned from querying CIM for SCSIProtocolController Instance");
            if (enumSCSI != null && enumSCSI.hasMoreElements()) {
                while (enumSCSI.hasMoreElements()) {
                    Trace.verbose((Object)this, "removeMapping", "SCSIProtocolController Instance Found");
                    CIMInstance scsi = (CIMInstance)enumSCSI.nextElement();
                    CIMValue initiatorName = scsi.getProperty("AssociatedInitiator").getValue();
                    String curName = new String();
                    if (initiatorName != null) {
                        curName = (String)initiatorName.getValue();
                    } else {
                        Trace.error((Object)this, "removeMapping", "Errors retrieving SCSIProtocolController 'AssignedInitiator'");
                    }
                    if (!curName.equals(this.getInstanceID())) continue;
                    if (Trace.isTraceEnabled(this)) {
                        Trace.verbose((Object)this, "removeMapping", "Found correct Initiator, Detaching Device: " + volume.getName());
                    }
                    CIMArgument[] inArgs = new CIMArgument[2];
                    CIMArgument[] outArgs = new CIMArgument[1];
                    inArgs[0] = new CIMArgument("ProtocolController", new CIMValue((Object)scsi.getObjectPath()));
                    inArgs[1] = new CIMArgument("Device", new CIMValue((Object)volume.getInstance().getObjectPath()));
                    outArgs = new CIMArgument[1];
                    Trace.verbose((Object)this, "removeMapping", "Getting associated StorageDomain");
                    CIMObjectPath controllerConfigurationServiceObjectPath = ServiceFinder.getService(this.handle, this.getStorageDomain(), 1);
                    Trace.verbose((Object)this, "removeMapping", "ControllerConfigurationService object path is: " + controllerConfigurationServiceObjectPath);
                    Trace.verbose((Object)this, "removeMapping", "Calling DetachDevice");
                    CIMValue returnCodeValue = this.handle.invokeMethod(controllerConfigurationServiceObjectPath, "DetachDevice", inArgs, outArgs);
                    Trace.verbose((Object)this, "removeMapping", "Returned from calling DetachDevice");
                    int retVal = (Integer)returnCodeValue.getValue();
                    methodCallStatus.setReturnCode(retVal);
                    Trace.verbose((Object)this, "removeMapping", "DetachDevice return code: " + retVal);
                    return methodCallStatus;
                }
            }
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "removeMapping", "Failed: " + cme);
            throw cme;
        }
        catch (NullPointerException npe) {
            Trace.error((Object)this, "removeMapping", "NullPointerException - Null returned when trying to remove mapping: " + npe);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - Problems removing mapping.", npe);
        }
        catch (Exception e) {
            Trace.error((Object)this, "removeMapping", "Exception - Exception thrown when trying to remove mapping: " + e);
            throw new ConfigMgmtException("error.systemError", "Exception - Problems removing mapping.", e);
        }
        Trace.error((Object)this, "removeMapping", "StorageVolume: " + volume.getName() + " not found as mapped.");
        throw new ItemNotFoundException(volume.getName());
    }

    public int getNextAvailableLUN() throws ConfigMgmtException {
        Trace.methodBegin(this, "getNextAvailableLUN");
        try {
            if (this.luns == null) {
                Trace.verbose((Object)this, "getNextAvailableLUN", "Querying CIM for Privilige Instances");
                Enumeration enumPrivileges = this.handle.associators(this.instance.getObjectPath(), "SunStorEdge_DSPAuthorizedSubject", "SunStorEdge_DSPPrivilege", "PrivilegedElement", "Privilege", true, false, null);
                Trace.verbose((Object)this, "getNextAvailableLUN", "Returned from querying CIM for Privilige Instances");
                if (enumPrivileges != null && enumPrivileges.hasMoreElements()) {
                    while (enumPrivileges.hasMoreElements()) {
                        Trace.verbose((Object)this, "getNextAvailableLUN", "Privilige Instances Found");
                        CIMInstance privilege = (CIMInstance)enumPrivileges.nextElement();
                        Trace.verbose((Object)this, "getNextAvailableLUN", "Querying CIM for SCSIProtocolController Instances");
                        Enumeration enumSCSI = this.handle.associators(privilege.getObjectPath(), "SunStorEdge_DSPAuthorizedTarget", "SunStorEdge_DSPSCSIProtocolController", "Privilege", "TargetElement", true, false, null);
                        Trace.verbose((Object)this, "getNextAvailableLUN", "Returned from querying CIM for SCSIProtocolController Instances");
                        if (enumSCSI == null || !enumSCSI.hasMoreElements()) continue;
                        Trace.verbose((Object)this, "getNextAvailableLUN", "SCSIProtocolController Instance Found");
                        CIMInstance scsi = (CIMInstance)enumSCSI.nextElement();
                        CIMProperty inUseLuns = scsi.getProperty("InUseLuns");
                        if (inUseLuns != null) {
                            this.luns = (Vector)inUseLuns.getValue().getValue();
                            continue;
                        }
                        Trace.verbose((Object)this, "getNextAvailableLUN", "Mapped luns not found, returning.");
                    }
                }
            }
            if (this.luns == null) {
                return 0;
            }
            ArrayList<Integer> lunList = new ArrayList<Integer>();
            for (int i = 0; i < 256; ++i) {
                lunList.add(new Integer(i));
            }
            Trace.verbose((Object)this, "getNextAvailableLUN", "Returning next available LUNs");
            for (int j = 0; j < this.luns.size(); ++j) {
                lunList.remove(new Integer(((UnsignedInt16)this.luns.get(j)).toString()));
            }
            return (Integer)lunList.get(0);
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "getNextAvailableLUN", "Failed: " + cme);
            throw cme;
        }
        catch (NullPointerException npe) {
            Trace.error((Object)this, "getNextAvailableLUN", "NullPointerException - Null returned when trying to get next available LUN: " + npe);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - Problems getting next available LUN.", npe);
        }
        catch (Exception e) {
            Trace.error((Object)this, "getNextAvailableLUN", "Exception - Exception thrown when trying to get next available LUN: " + e);
            throw new ConfigMgmtException("error.systemError", "Exception - Problems getting next available LUN.", e);
        }
    }

    public ArrayList getAllLUNs() throws ConfigMgmtException {
        Trace.methodBegin(this, "getAllLUNs");
        try {
            if (this.luns == null) {
                Trace.verbose((Object)this, "getAllLUNs", "Querying CIM for Privilige Instances");
                Enumeration enumPrivileges = this.handle.associators(this.instance.getObjectPath(), "SunStorEdge_DSPAuthorizedSubject", "SunStorEdge_DSPPrivilege", "PrivilegedElement", "Privilege", true, false, null);
                Trace.verbose((Object)this, "getAllLUNs", "Returned from querying CIM for Privilige Instances");
                if (enumPrivileges != null && enumPrivileges.hasMoreElements()) {
                    while (enumPrivileges.hasMoreElements()) {
                        Trace.verbose((Object)this, "getAllLUNs", "Privilige Instances Found");
                        CIMInstance privilege = (CIMInstance)enumPrivileges.nextElement();
                        Trace.verbose((Object)this, "getAllLUNs", "Querying CIM for SCSIProtocolController Instances");
                        Enumeration enumSCSI = this.handle.associators(privilege.getObjectPath(), "SunStorEdge_DSPAuthorizedTarget", "SunStorEdge_DSPSCSIProtocolController", "Privilege", "TargetElement", true, false, null);
                        Trace.verbose((Object)this, "getAllLUNs", "Returned from querying CIM for SCSIProtocolController Instances");
                        if (enumSCSI == null || !enumSCSI.hasMoreElements()) continue;
                        Trace.verbose((Object)this, "getAllLUNs", "SCSIProtocolController Instance Found");
                        CIMInstance scsi = (CIMInstance)enumSCSI.nextElement();
                        CIMProperty inUseLuns = scsi.getProperty("InUseLuns");
                        if (inUseLuns != null) {
                            this.luns = (Vector)inUseLuns.getValue().getValue();
                            continue;
                        }
                        Trace.verbose((Object)this, "getAllLUNs", "Mapped luns not found, returning.");
                    }
                }
            }
            ArrayList<Integer> lunList = new ArrayList<Integer>();
            for (int i = 0; i < 256; ++i) {
                lunList.add(new Integer(i));
            }
            if (this.luns == null) {
                return lunList;
            }
            Trace.verbose((Object)this, "getAllLUNs", "Returning available LUNs");
            for (int j = 0; j < this.luns.size(); ++j) {
                lunList.remove(new Integer(((UnsignedInt16)this.luns.get(j)).toString()));
            }
            return lunList;
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "getAllLUNs", "Failed: " + cme);
            throw cme;
        }
        catch (NullPointerException npe) {
            Trace.error((Object)this, "getAllLUNs", "NullPointerException - Null returned when trying to get available LUNs: " + npe);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - Problems getting available LUNs.", npe);
        }
        catch (Exception e) {
            Trace.error((Object)this, "getAllLUNs", "Exception - Exception thrown when trying to get available LUNs: " + e);
            throw new ConfigMgmtException("error.systemError", "Exception - Problems getting available LUNs.", e);
        }
    }

    public Collection getFieldMap() throws ConfigMgmtException {
        Trace.methodBegin(this, "getFieldMap");
        if (null == this.fieldMap) {
            this.fieldMap = new ArrayList();
            this.fieldMap.add(new MapElement("popname", "ElementName", false, true));
            this.fieldMap.add(new MapElement("WWN", "StorageID", true, false));
            this.fieldMap.add(new MapElement("instanceID", "InstanceID", true, false));
            this.fieldMap.add(new MapElement("description", "Description", false, true));
            this.fieldMap.add(new MapElement("state", "InitiatorState", true, true));
            this.fieldMap.add(new MapElement("status", "InitiatorStatus", true, true));
            this.fieldMap.add(new MapElement("storageDomainName", "StorageDomain", true, false));
            this.fieldMap.add(new MapElement("poptype", "OSType", true, false));
        }
        return this.fieldMap;
    }

    public void loadKeys() {
        Trace.methodBegin(this, "loadKeys");
        ArrayList<CIMProperty> prop = new ArrayList<CIMProperty>();
        prop.add(new CIMProperty("InstanceID", new CIMValue((Object)this.getInstanceID())));
        this.setKey(prop);
    }

    public String toString() {
        Trace.methodBegin(this, "toString");
        if (Trace.isTraceEnabled(this)) {
            String thisObject = "\nInitiator with:";
            thisObject = thisObject + "\n\tCIMObjectPath: " + this.instance.getObjectPath();
            thisObject = thisObject + "\n\tName: " + this.getName();
            thisObject = thisObject + "\n\tKey: " + this.getInstanceID();
            thisObject = thisObject + "\n\tWWN: " + this.getWWN();
            thisObject = thisObject + "\n\tDescription: " + this.getDescription();
            thisObject = thisObject + "\n\tStorage Domain: " + this.getStorageDomain();
            thisObject = this.state == 1 ? thisObject + "\n\tState: Allocated" : (this.state == 3 ? thisObject + "\n\tState: Free" : thisObject + "\n\tState: " + this.getState());
            thisObject = this.status == 1 ? thisObject + "\n\tStatus: Online\n\n" : (this.status == 2 ? thisObject + "\n\tStatus: Offline\n\n" : thisObject + "\n\tStatus: " + this.getStatus() + "\n\n");
            return thisObject;
        }
        return "";
    }

    public void delete() throws ConfigMgmtException {
        Trace.methodBegin(this, "delete");
    }

    public String getT4Name() throws ConfigMgmtException {
        Trace.methodBegin(this, "getT4Name");
        return null;
    }

    private CIMObjectPath getT4ObjectPath() throws ConfigMgmtException {
        return null;
    }

    private void removeFromAllGroups() throws ConfigMgmtException {
        Trace.methodBegin(this, "removeFromAllGroups");
    }

    public List getInitiatorGroups() throws ConfigMgmtException {
        Trace.methodBegin(this, "getInitiatorGroups");
        return null;
    }

    public List getVolumeGroups() throws ConfigMgmtException {
        Trace.methodBegin(this, "getVolumeGroups");
        return null;
    }
}

