/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.util;

import java.util.Locale;
import java.util.TimeZone;

public class TimeZoneUtil {
    public static final int MILLIS_PER_MIN = 60000;
    public static final int MILLIS_PER_HOUR = 3600000;

    public static String[] getTimeZoneIDsForOffset(int milliseconds) {
        int MILLIS_PER_MIN = 60000;
        int MILLIS_PER_HOUR = 3600000;
        String[] availableIDs = TimeZone.getAvailableIDs(milliseconds);
        return availableIDs;
    }

    public static String[] getTimeZoneDisplayNamesForOffset(int GMTOffset, Locale userLocale) {
        String[] ids = TimeZoneUtil.getTimeZoneIDsForOffset(GMTOffset);
        String[] displayNames = new String[ids.length];
        TimeZone timeZone = TimeZone.getDefault();
        for (int i = 0; i < ids.length; ++i) {
            timeZone.setID(ids[i]);
            displayNames[i] = timeZone.getDisplayName(userLocale);
        }
        return displayNames;
    }

    public static String getGMTOffsetFromRawOffset(int rawOffset) {
        int offsetHours = rawOffset / 3600000;
        String key = "gmt";
        if (offsetHours < 0) {
            key = key + offsetHours;
        } else if (offsetHours > 0) {
            key = key + "+" + offsetHours;
        }
        return key;
    }

    public static int getRawOffsetFromGMTOffset(String gmtOffset) {
        int gmtInt = 0;
        try {
            gmtOffset = gmtOffset.charAt(3) == '+' ? gmtOffset.substring(4) : gmtOffset.substring(3);
            gmtInt = Integer.parseInt(gmtOffset);
        }
        catch (Exception e) {
            return 0;
        }
        return gmtInt * 3600000;
    }
}

