/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.util;

import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.util.Poolable;
import com.sun.netstorage.array.mgmt.cfg.util.PooledObjectsFactory;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

public class ObjectPool {
    private static ObjectPool objectPool;
    private Hashtable freeObjects = new Hashtable();
    private Hashtable lockedObjects = new Hashtable();

    private ObjectPool() {
    }

    public static synchronized ObjectPool getInstance() {
        if (objectPool == null) {
            objectPool = new ObjectPool();
        }
        return objectPool;
    }

    public synchronized Poolable checkOut(Object key, Object type) {
        String methodName = "checkOut";
        if (key == null) {
            return null;
        }
        ArrayList freeList = (ArrayList)this.freeObjects.get(key);
        if (freeList == null) {
            freeList = new ArrayList();
            this.freeObjects.put(key, freeList);
        }
        Poolable objForCheckOut = null;
        if (freeList.isEmpty()) {
            Trace.verbose((Object)this, "checkOut", "No free objects - create one");
            objForCheckOut = PooledObjectsFactory.createObject(key, type);
        } else {
            objForCheckOut = (Poolable)freeList.get(0);
            freeList.remove(0);
        }
        ArrayList<Poolable> lockedList = (ArrayList<Poolable>)this.lockedObjects.get(key);
        if (lockedList == null) {
            lockedList = new ArrayList<Poolable>();
            this.lockedObjects.put(key, lockedList);
        }
        lockedList.add(objForCheckOut);
        Trace.verbose((Object)this, "checkOut", "Free objects:" + freeList.size());
        Trace.verbose((Object)this, "checkOut", "Locked objects:" + lockedList.size());
        return objForCheckOut;
    }

    public synchronized void checkIn(Object key, Poolable objForCheckIn) {
        String methodName = "checkIn";
        Trace.methodBegin(this, "checkIn");
        if (key == null) {
            return;
        }
        ArrayList<Poolable> freeList = (ArrayList<Poolable>)this.freeObjects.get(key);
        if (freeList == null) {
            freeList = new ArrayList<Poolable>();
            this.freeObjects.put(key, freeList);
        }
        Trace.verbose((Object)this, "checkIn", "Free list size:" + freeList.size());
        freeList.add(objForCheckIn);
        ArrayList lockedList = (ArrayList)this.lockedObjects.get(key);
        if (lockedList == null) {
            lockedList = new ArrayList();
            this.lockedObjects.put(key, lockedList);
        } else {
            lockedList.remove(objForCheckIn);
        }
        Trace.verbose((Object)this, "checkIn", "Free objects:" + freeList.size());
        Trace.verbose((Object)this, "checkIn", "Locked objects:" + lockedList.size());
    }

    public synchronized void remove(Object key, Poolable objForRemove) {
        String methodName = "remove";
        if (key == null) {
            return;
        }
        List freeList = (List)this.freeObjects.get(key);
        List lockedList = (List)this.lockedObjects.get(key);
        if (freeList != null && freeList.contains(objForRemove)) {
            Trace.verbose((Object)this, "remove", "Removed from free list");
            freeList.remove(objForRemove);
        } else if (lockedList != null && lockedList.contains(objForRemove)) {
            Trace.verbose((Object)this, "remove", "Removed from locked list");
            lockedList.remove(objForRemove);
        }
    }

    public synchronized void flush(Object key) {
        String methodName = "remove";
        if (key == null) {
            return;
        }
        this.freeObjects.remove(key);
        this.lockedObjects.remove(key);
    }

    public synchronized int getPoolSize(Object type) {
        List freeList;
        int size = 0;
        if (this.freeObjects != null && (freeList = (List)this.freeObjects.get(type)) != null) {
            size = freeList.size();
        }
        return size;
    }
}

