/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.util;

import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;

public class MessageResources {
    private static ResourceBundle rb;
    Locale loadedLocale = null;
    String resource = null;
    ClassLoader loader;

    public MessageResources(String resourceName, Locale argLocale, ClassLoader argLoader) {
        this.loadLocale(resourceName, argLocale, argLoader);
    }

    public String getMessage(String key, Locale locale) {
        return this.getMessage(locale, key, null);
    }

    public String getMessage(Locale locale, String key) {
        return this.getMessage(locale, key, null);
    }

    public synchronized String getMessage(Locale locale, String key, String[] params) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (!this.loadedLocale.equals(locale)) {
            Trace.verbose((Object)this, "getMessage", "Load locale:" + locale);
            this.loadLocale(this.resource, locale, this.loader);
        }
        String localized = key;
        localized = rb.getString(key);
        if (params != null) {
            localized = MessageFormat.format(localized, params);
        }
        return localized;
    }

    private void loadLocale(String resourceName, Locale locale, ClassLoader argLoader) {
        rb = ResourceBundle.getBundle(resourceName, locale, argLoader);
        this.loadedLocale = locale;
        this.resource = resourceName;
        this.loader = argLoader;
    }
}

