/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.util;

import com.sun.netstorage.array.mgmt.cfg.core.impl.oz.LicenseParser;
import com.sun.netstorage.array.mgmt.cfg.util.Base64;
import com.sun.netstorage.array.mgmt.cfg.util.Convert;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class BinaryConverter {
    private InputStream in = null;
    private OutputStream out = null;
    private int breakup = 0;
    public boolean inParts = false;
    public boolean xml = false;
    public boolean binary = false;
    public String arrayID = null;
    public String controllerID = null;
    public String enablerID = null;
    ObjectInputStream OIS = null;

    public BinaryConverter(InputStream in, OutputStream out) {
        this.in = in;
        this.out = out;
    }

    public void convert() throws IOException, ClassNotFoundException {
        if (this.inParts || this.xml) {
            this.convertToText();
        } else {
            this.convertBase64();
        }
    }

    private void convertToText() throws IOException, ClassNotFoundException {
        int version = 0;
        byte[] digestBytes = null;
        String digest = null;
        String capabilityCode = null;
        this.OIS = new ObjectInputStream(this.in);
        String header = (String)this.OIS.readObject();
        System.out.println("HEADER : " + header);
        version = this.OIS.readInt();
        int numEntries = this.OIS.readInt();
        ArrayList<LicenseParser.SingleLicense> entryList = new ArrayList<LicenseParser.SingleLicense>();
        LicenseParser.SingleLicense sl = null;
        for (int i = 0; i < numEntries; ++i) {
            version = this.OIS.readInt();
            capabilityCode = this.codeFromInt(this.OIS.readInt());
            byte[] wwn = (byte[])this.OIS.readObject();
            digestBytes = (byte[])this.OIS.readObject();
            digest = BinaryConverter.bytesToStringNoDot(digestBytes);
            sl = new LicenseParser.SingleLicense();
            sl.version = Integer.toString(version).trim();
            sl.capability = capabilityCode.trim();
            sl.digest = digest.trim();
            entryList.add(sl);
        }
        if (this.inParts) {
            this.writeInParts(entryList);
        } else {
            this.writeXML(entryList);
        }
        this.out.flush();
        this.out.close();
    }

    private void writeXML(List entryList) throws IOException {
        LicenseParser lp = new LicenseParser();
        lp.setArrayID(this.arrayID);
        lp.setControllerID(this.controllerID);
        lp.setEnablerID(this.enablerID);
        lp.setLicenses(entryList);
        String xml = lp.generateXML();
        this.out.write(xml.getBytes());
    }

    private void writeInParts(List entryList) throws IOException {
        StringBuffer output = new StringBuffer();
        output.append("ArrayID      : ").append(this.arrayID).append("\n").append("ControllerID : ").append(this.controllerID).append("\n").append("EnablerID    : ").append(this.enablerID).append("\n\n");
        if (null != entryList) {
            Iterator iter = entryList.iterator();
            LicenseParser.SingleLicense sl = null;
            while (iter.hasNext()) {
                sl = (LicenseParser.SingleLicense)iter.next();
                output.append("Version        : ").append(sl.version).append("\n").append("CapabilityCode : ").append(sl.capability).append("\n").append("Digest         : ").append(sl.digest).append("\n\n");
            }
        }
        this.out.write(output.toString().getBytes());
    }

    private void convertBase64() throws IOException {
        ByteArrayOutputStream BAOS = new ByteArrayOutputStream();
        int count = 0;
        boolean done = false;
        int intByteRef = 0;
        while (!done) {
            intByteRef = this.in.read();
            if (-1 == intByteRef) {
                done = true;
                break;
            }
            ++count;
            BAOS.write(intByteRef);
        }
        byte[] bytes = BAOS.toByteArray();
        byte[] trimedBytes = new byte[count];
        System.arraycopy(bytes, 0, trimedBytes, 0, count);
        String outString = Base64.byteArrayToBase64(trimedBytes);
        System.out.println(outString);
        outString = this.formatString(outString);
        System.out.println(BinaryConverter.trimString(outString));
        System.out.println("");
        this.out.write(outString.getBytes());
        this.out.flush();
        System.out.println("");
        System.out.println(outString);
    }

    private String formatString(String outString) {
        if (this.breakup < 1) {
            return outString;
        }
        int times = outString.length() / this.breakup;
        StringBuffer SB = new StringBuffer(outString);
        for (int incertpoint = this.breakup; incertpoint < SB.length(); incertpoint += this.breakup) {
            SB.insert(incertpoint, "\n");
        }
        String output = SB.toString();
        return SB.toString();
    }

    public static String trimString(String inString) {
        StringBuffer output = new StringBuffer(inString.length());
        String[] tokens = inString.split("\\s");
        for (int i = 0; i < tokens.length; ++i) {
            output.append(tokens[i]);
        }
        return output.toString().trim();
    }

    static String bytesToStringNoDot(byte[] data) {
        StringBuffer sbuf = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            sbuf.append(Convert.toHex(data[i], 2));
        }
        return sbuf.toString().toUpperCase();
    }

    String codeFromInt(int code) {
        String name = null;
        switch (code) {
            case 1: {
                name = new String("CAPABILITY_SHARED_VOLUME");
                break;
            }
            case 8: {
                name = "StorageDomain2";
                break;
            }
            case 2: {
                name = "StorageDomain4";
                break;
            }
            case 7: {
                name = "StorageDomain8";
                break;
            }
            case 11: {
                name = "StorageDomain16";
                break;
            }
            case 10: {
                name = "StorageDomain64";
                break;
            }
            case 9: {
                name = "StorageDomainMax";
                break;
            }
            case 4: {
                name = "AutoSync";
                break;
            }
            case 5: {
                name = "AutoLunTransfer";
                break;
            }
            case 3: {
                name = "MixedRaidLevel";
                break;
            }
            case 12: {
                name = "Snapshot";
                break;
            }
            case 6: {
                name = "SubLunsAllowed";
                break;
            }
            case 14: {
                name = "VolumeCopy";
                break;
            }
            case 13: {
                name = "ReplicationSet";
                break;
            }
            default: {
                name = "Unknown";
            }
        }
        return name;
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            BinaryConverter.usage();
            System.exit(100);
        }
        try {
            boolean inParts = false;
            boolean xml = false;
            File input = new File(args[0]);
            File output = null;
            boolean breakpoint = false;
            if (!input.exists()) {
                System.out.println("Input file does not exist");
                System.exit(100);
            }
            String arrayID = null;
            String enablerID = null;
            String controllerID = null;
            for (int i = 1; i < args.length; ++i) {
                if (args[i].equals("-p")) {
                    inParts = true;
                    continue;
                }
                if (args[i].equals("-x")) {
                    xml = true;
                    continue;
                }
                if (args[i].equals("-o")) {
                    output = new File(args[++i]);
                    continue;
                }
                if (args[i].equals("-A")) {
                    arrayID = args[++i];
                    continue;
                }
                if (args[i].equals("-E")) {
                    enablerID = args[++i];
                    continue;
                }
                if (!args[i].equals("-C")) continue;
                controllerID = args[++i];
            }
            if (null == output) {
                output = new File(args[0] + ".output");
            }
            FileInputStream FIS = new FileInputStream(input);
            FileOutputStream FOS = new FileOutputStream(output);
            BinaryConverter BC = new BinaryConverter(FIS, FOS);
            BC.arrayID = arrayID;
            BC.enablerID = enablerID;
            BC.controllerID = controllerID;
            if (xml) {
                BC.xml = true;
            } else if (inParts) {
                BC.inParts = true;
            }
            BC.convert();
            FOS.close();
            System.out.println("All Done - Output written to " + output.getAbsolutePath());
        }
        catch (Exception e) {
            System.out.println("Exception Caught " + e.getMessage());
            System.exit(100);
        }
    }

    public static void usage() {
        System.out.println("BinaryConverter inputfile [-p | -x] [-o outputfile] [-A arrayID] [-E enabler id] [-C controller id]");
        System.out.println("Notes: ");
        System.out.println("-- Inputfile must be the first argument, all other arguments can be in any order");
        System.out.println("-- If neither -p or -x is supplied the input file will be converted the old base64 way");
        System.out.println("-- If both -p and -x are specific, -p will win (sorry)");
        System.out.println("-- If -o is omitted an outputfile will be generated by adding .output to the input files name");
        System.out.println("-- Output fille will overrite any existing file of the same name");
        System.out.println("-- -A -E -C are not required, but if not supplied will show up as \"null\"");
    }
}

