/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.test;

import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Constants;
import com.sun.netstorage.array.mgmt.cfg.core.MethodCallStatus;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.DiskInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageRaidGroupsFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageRaidGroupsInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageT4sFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageT4sInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.RaidGroupInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageProfile;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.T4Interface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.TrayInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.PoolBreakdownForTray;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.test.ManageDisks;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.test.RaidGroup;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.wbem.cim.CIMInstance;

public class Tray
implements TrayInterface,
Constants.SupportedFeature {
    private ConfigContext context;
    private List raidGroups;
    private List diskList;
    private String id;
    private String description;
    private String T4Name;
    private BigInteger driveCapacity;
    private int numberOfDrives;
    private int numberOfHotSpare = 1;
    private CIMInstance trayCimInstance;
    private int trayType = 17;
    private String status;
    private int state = -1;
    private String role;
    private ArrayList contigDiskList = new ArrayList();
    private T4Interface t4Interface;

    public Tray() {
        Trace.constructor(this);
    }

    public void init(ConfigContext context) {
        this.context = context;
    }

    public void setConfigContext(ConfigContext ctx) {
        this.context = ctx;
    }

    public ConfigContext getConfigContext() {
        return this.context;
    }

    public void reload() {
        Trace.verbose((Object)this, "reload", "This method should reload the Tray object to its original state");
    }

    public MethodCallStatus cloneFrom(TrayInterface sourceTray) throws ConfigMgmtException {
        Trace.methodBegin(this, "cloneFrom");
        Trace.verbose((Object)this, "cloneFrom", "Tray: " + this.id + " is now being cloned.....");
        Trace.verbose((Object)this, "cloneFrom", "The source Tray id is: " + sourceTray.getId());
        return new MethodCallStatus();
    }

    public void save() throws ConfigMgmtException {
        Trace.methodBegin(this, "save");
        Trace.verbose((Object)this, "save", "Tray: " + this.id + " is now saving.....");
    }

    public String getId() {
        return this.id;
    }

    public String getIdOneBased() {
        return this.id;
    }

    public int getNumberOfHotSpare() {
        return this.numberOfHotSpare;
    }

    public int getHotSpareDriveUsage() throws ConfigMgmtException {
        return 0;
    }

    public int getNumberOfDrives() {
        return this.numberOfDrives;
    }

    public String getT4Name() {
        return this.T4Name;
    }

    public String getT4IPAddress() {
        return this.T4Name;
    }

    public BigInteger getDriveCapacity() {
        return this.driveCapacity;
    }

    public int getTrayType() {
        return this.trayType;
    }

    public void setRaidGroups(List raidGroups) {
        this.raidGroups = raidGroups;
    }

    public List getRaidGroups() throws ConfigMgmtException {
        if (this.raidGroups != null) {
            return this.raidGroups;
        }
        ManageRaidGroupsInterface manageRaidGroups = ManageRaidGroupsFactory.getManager();
        manageRaidGroups.setScope(this);
        manageRaidGroups.init(this.context, null);
        this.raidGroups = manageRaidGroups.getItemList();
        return this.raidGroups;
    }

    public CIMInstance getInstance() {
        return this.trayCimInstance;
    }

    public ArrayList getMaxContigDrive(RaidGroupInterface theRaidGroup) throws ConfigMgmtException {
        for (int i = 1; i < 6; ++i) {
            this.contigDiskList.add(new Integer(i));
        }
        return this.contigDiskList;
    }

    public int getMaxContigDrive() throws ConfigMgmtException {
        return 5;
    }

    public String getRole() throws ConfigMgmtException {
        return this.role;
    }

    public int getState() throws ConfigMgmtException {
        return this.state;
    }

    public String getStatus() throws ConfigMgmtException {
        return this.status;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setT4Name(String T4Name) {
        this.T4Name = T4Name;
    }

    public void setDriveCapacity(BigInteger driveCapacity) {
        this.driveCapacity = driveCapacity;
    }

    public void setNumberOfDrives(int numberOfDrives) {
        this.numberOfDrives = numberOfDrives;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public void setState(int state) {
        this.state = state;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    private void createNewRaidGroup(int raidLevel, int numberOfDrives, int useHotSpare, String name) throws ConfigMgmtException {
        Trace.methodBegin(this, "createNewRaidGroup");
        RaidGroup aRaidGroup = new RaidGroup();
        aRaidGroup.setRaidLevel(raidLevel);
        aRaidGroup.setNumberOfDrives(numberOfDrives);
        aRaidGroup.setTotalCapacity(new BigInteger("2000000000"));
        aRaidGroup.setAvailableCapacity(new BigInteger("1500000000"));
        aRaidGroup.setName(name == null ? "new_pool_1" : name);
        aRaidGroup.setUseHotSpare(useHotSpare);
        if (this.raidGroups == null) {
            this.raidGroups = new ArrayList();
        }
        this.raidGroups.add(aRaidGroup);
    }

    public boolean isDepop() throws Exception {
        String methodName = "isDepop";
        Trace.methodBegin(this, methodName);
        Trace.verbose((Object)this, methodName, "Number of drives in tray = " + this.getNumberOfDrives());
        if (this.getNumberOfDrives() < 14) {
            Trace.verbose((Object)this, methodName, "Tray number of drives is < max drives; this is DEPOP!");
            return true;
        }
        Trace.verbose((Object)this, methodName, "Tray is NOT DEPOP");
        return false;
    }

    public boolean areAllDisksHealthy() throws ConfigMgmtException {
        String methodName = "arrAllDisksHealthy";
        Trace.methodBegin(this, methodName);
        return true;
    }

    public void enable(boolean enable) throws ConfigMgmtException {
        Trace.methodBegin(this, "enable");
        Trace.verbose((Object)this, "enable", "Enabling the tray: " + this.id);
    }

    public void unconfigure() throws ConfigMgmtException {
        Trace.methodBegin(this, "unconfigure");
        Trace.verbose((Object)this, "unconfigure", "Unconfiguring the tray: " + this.id);
    }

    public List getDiskList() throws ConfigMgmtException {
        Trace.methodBegin(this, "getDiskList");
        if (this.diskList == null) {
            ManageDisks md = new ManageDisks();
            md.setTrayId(this.id);
            this.diskList = md.getItemList();
        }
        return this.diskList;
    }

    public void setDiskList(List diskList) {
        this.diskList = diskList;
    }

    public void setTrayType(int trayType) {
        this.trayType = trayType;
    }

    public int getNumberOfDisksInRole(String role) throws ConfigMgmtException {
        if (!("unassigned".equals(role) || "dataDisk".equals(role) || "standbyDisk".equals(role) || "globalStandbyDisk".equals(role))) {
            Trace.verbose((Object)this, "getNumberOfDisksInRole(String)", "Got unhandled disk role: " + role);
            throw new ConfigMgmtException("ACTION_NOT_SUPPORTED", "Role: " + role + " not supported disk role.");
        }
        int val = 0;
        List l = this.getDiskList();
        for (int i = 0; i < l.size(); ++i) {
            DiskInterface d = (DiskInterface)l.get(i);
            if (!d.getRole().equals(role)) continue;
            ++val;
        }
        return val;
    }

    public List getDisksAvailableForPool(boolean usesHotSpare) throws ConfigMgmtException {
        Trace.methodBegin(this, "getDisksAvailableForPool");
        List disks = this.getDiskList();
        Iterator iDisks = disks.iterator();
        ArrayList<DiskInterface> disksForPool = null;
        DiskInterface backupdisk = null;
        int lastSlot = -1;
        while (iDisks.hasNext() && disksForPool == null) {
            DiskInterface disk = (DiskInterface)iDisks.next();
            if (!disk.getRole().equals("unassigned")) continue;
            disksForPool = new ArrayList();
            disksForPool.add(disk);
            Trace.verbose((Object)this, "getDisksAvailableForPool", "First avail disk is in slot: " + disk.getSlotNumber());
            boolean doneWithDataDisks = false;
            lastSlot = disk.getSlotNumber();
            while (iDisks.hasNext() && !doneWithDataDisks) {
                disk = (DiskInterface)iDisks.next();
                if (disk.getRole().equals("unassigned") && disk.getSlotNumber() == lastSlot + 1) {
                    disksForPool.add(disk);
                    lastSlot = disk.getSlotNumber();
                    Trace.verbose((Object)this, "getDisksAvailableForPool", "Added slot: " + lastSlot + " to list.");
                    continue;
                }
                Trace.verbose((Object)this, "getDisksAvailableForPool", "Found gap or assigned disk in slot: " + disk.getSlotNumber());
                doneWithDataDisks = true;
                backupdisk = disk;
            }
            if (!usesHotSpare || !this.getT4Interface().isFeatureSupported(4)) continue;
            boolean foundSpare = false;
            while (backupdisk != null || iDisks.hasNext() && !foundSpare) {
                if (backupdisk != null) {
                    disk = backupdisk;
                    backupdisk = null;
                } else {
                    disk = (DiskInterface)iDisks.next();
                }
                Trace.verbose((Object)this, "getDisksAvailableForPool", " looking for dedicated spare. Examining disk in slot: " + disk.getSlotNumber());
                if (!disk.getRole().equals("unassigned")) continue;
                foundSpare = true;
                Trace.verbose((Object)this, "getDisksAvailableForPool", "Found spare at slot: " + disk.getSlotNumber());
            }
            if (foundSpare) continue;
            if (disksForPool != null && disksForPool.size() > 0) {
                disksForPool.remove(disksForPool.size() - 1);
                Trace.verbose((Object)this, "getDisksAvailableForPool", "Removing one data drive for hot spare use.");
                continue;
            }
            Trace.verbose((Object)this, "getDisksAvailableForPool", "can't find hot spare in this scenario");
            disksForPool = null;
        }
        if (usesHotSpare && !this.getT4Interface().isFeatureSupported(4) && disksForPool != null && disksForPool.size() > 0) {
            DiskInterface ldisk = (DiskInterface)disksForPool.remove(disksForPool.size() - 1);
            if (ldisk.getSlotNumber() != 14) {
                disksForPool.add(ldisk);
                boolean foundSlot14 = false;
                for (int i = disks.size() - 1; !foundSlot14 && i >= 0; --i) {
                    DiskInterface disk = (DiskInterface)disks.get(i);
                    if (disk.getSlotNumber() != 14) continue;
                    foundSlot14 = true;
                    if ("unassigned".equals(disk.getRole()) || "standbyDisk".equals(disk.getRole())) continue;
                    disksForPool = null;
                    Trace.verbose((Object)this, "getDisksAvailableForPool", "firmware 3.0--Slot 14 not available, so no disks are returned.");
                }
                if (!foundSlot14) {
                    disksForPool = null;
                    Trace.verbose((Object)this, "getDisksAvailableForPool", "firmware 3.0--Slot 14 not installed, so no disks are returned.");
                }
            } else {
                Trace.verbose((Object)this, "getDisksAvailableForPool", "firmware 3.0--Removed disk in slot 14 from data disks.");
            }
        }
        return disksForPool == null ? new ArrayList<DiskInterface>() : disksForPool;
    }

    public PoolBreakdownForTray getPoolBreakdownForTray(int numPools, int numDataDrives, int raidLevel, boolean useDedicatedSpare) throws ConfigMgmtException {
        return new PoolBreakdownForTray(this, numPools, numDataDrives, raidLevel, useDedicatedSpare);
    }

    public boolean equals(Object o) {
        boolean result = super.equals(o);
        if (o != null && o instanceof Tray) {
            Tray tray = (Tray)o;
            result = tray.getId() != null && tray.getId().equals(this.getId());
        }
        return result;
    }

    public MethodCallStatus createRAIDGroup(String poolName, List disks, StorageProfile profile, boolean usesHotSpare) throws ConfigMgmtException {
        Trace.methodBegin(this, "createStoragePool");
        this.createNewRaidGroup(5, 7, 1, "test_pool");
        return new MethodCallStatus();
    }

    public boolean isDedicatedHotSpareAvailable(BigInteger effectiveDiskSize) throws ConfigMgmtException {
        return false;
    }

    public T4Interface getT4Interface() throws ConfigMgmtException {
        Trace.methodBegin(this, "getT4Interface");
        if (this.t4Interface == null) {
            ManageT4sInterface mt4s = ManageT4sFactory.getManager();
            mt4s.init(this.context, null);
            List t4s = mt4s.getItemList();
            if (!t4s.isEmpty()) {
                this.t4Interface = (T4Interface)t4s.get(0);
            }
        }
        return this.t4Interface;
    }

    public void setT4Interface(T4Interface t4Interface) {
        this.t4Interface = t4Interface;
    }

    public int getNumRequestedAndExistingRaidGroups() throws ConfigMgmtException {
        List rGroups = this.getRaidGroups();
        if (rGroups != null) {
            return rGroups.size();
        }
        return 0;
    }

    public boolean areDisksCompatible(TrayInterface dest) throws ConfigMgmtException {
        String METHOD = "areDisksCompatible";
        Trace.methodBegin(this, "areDisksCompatible");
        boolean result = false;
        List srcDisks = this.getDiskList();
        if (dest != null) {
            if (dest.getT4Interface().getClusterName().equals(this.getT4Interface().getClusterName()) && dest.getId().equals(this.getId())) {
                Trace.verbose((Object)this, "areDisksCompatible", "Not compatible: Same tray on same array.");
                return result;
            }
            List destDisks = dest.getDiskList();
            if (destDisks.size() != srcDisks.size()) {
                Trace.verbose((Object)this, "areDisksCompatible", "Not compatible: Different number of disks on tray.");
                return result;
            }
            for (int i = 0; i < srcDisks.size(); ++i) {
                DiskInterface sDisk = (DiskInterface)srcDisks.get(i);
                DiskInterface dDisk = (DiskInterface)destDisks.get(i);
                if (sDisk.getCapacity().compareTo(dDisk.getCapacity()) == 0) continue;
                Trace.verbose((Object)this, "areDisksCompatible", "Not compatible: Different disk capacity on tray.");
                return result;
            }
            result = true;
        }
        return result;
    }
}

