/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.test;

import com.sun.netstorage.array.mgmt.cfg.core.CIMOMHandleWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.BadParameterException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageProfileInterface;
import java.util.ArrayList;
import java.util.Collection;
import javax.wbem.cim.CIMInstance;

public class StorageProfile
implements StorageProfileInterface {
    private ConfigContext context;
    private CIMOMHandleWrapper handle;
    private ArrayList fieldMap;
    private CIMInstance instance;
    private String name;
    private String instanceID;
    private String productVersion;
    private String description;
    private int segmentSize;
    private int accessDirectionHint;
    private int accessBandwidthWeight;
    private int numberOfDisks;
    private int dataRedundancy;
    private int packageRedundancy;
    private boolean noSinglePointOfFailure;
    private int raidLevel;
    private boolean hotSpare;
    private Collection keyProperties;

    public void init(ConfigContext context) throws ConfigMgmtException {
        Trace.methodBegin(this, "init");
    }

    public void save() throws ConfigMgmtException {
        Trace.methodBegin(this, "save");
    }

    public void reload() throws ConfigMgmtException {
        Trace.methodBegin(this, "reload");
    }

    public String getName() {
        Trace.methodBegin(this, "getName");
        if (this.name == null) {
            return "";
        }
        return this.name;
    }

    public String getDescription() {
        Trace.methodBegin(this, "getDescription");
        if (this.description == null) {
            return "";
        }
        return this.description;
    }

    public String getPopname() {
        Trace.methodBegin(this, "getPopname");
        if (this.name == null) {
            return "";
        }
        return this.name;
    }

    public int getSegmentSize() {
        Trace.methodBegin(this, "getSegmentSize");
        return this.segmentSize;
    }

    public boolean isReadAheadEnabled() {
        Trace.methodBegin(this, "isReadAheadEnabled");
        return this.accessDirectionHint <= 5;
    }

    public int getRAIDLevel() {
        Trace.methodBegin(this, "getRAIDLevel");
        return this.raidLevel;
    }

    public int getArrayType() {
        Trace.methodBegin(this, "getArrayType");
        if (this.accessBandwidthWeight == 0 || this.accessBandwidthWeight == 1) {
            return 2;
        }
        if (this.accessBandwidthWeight == 2 || this.accessBandwidthWeight == 3) {
            return 5;
        }
        if (this.accessBandwidthWeight == 4 || this.accessBandwidthWeight == 5) {
            return 3;
        }
        if (this.accessBandwidthWeight == 6 || this.accessBandwidthWeight == 7) {
            return 0;
        }
        if (this.accessBandwidthWeight == 8 || this.accessBandwidthWeight == 9) {
            return 4;
        }
        if (this.accessBandwidthWeight == 10) {
            return 1;
        }
        return -1;
    }

    public int getNumberOfDisks() {
        Trace.methodBegin(this, "getNumberOfDisks");
        return this.numberOfDisks;
    }

    public int getVirtualizationStrategy() {
        Trace.methodBegin(this, "getVirtualizationStrategy");
        return -1;
    }

    public int getStripeSize() {
        Trace.methodBegin(this, "getStripeSize");
        return -1;
    }

    public boolean dedicatedSpareExists() {
        Trace.methodBegin(this, "dedicatedSpareExists");
        return this.hotSpare;
    }

    public boolean isInUse() throws ConfigMgmtException {
        Trace.methodBegin(this, "isInUse");
        return true;
    }

    public boolean isFactoryProfile() {
        Trace.methodBegin(this, "isFactoryProfile");
        return false;
    }

    public ArrayList getAssocPools() throws ConfigMgmtException {
        Trace.methodBegin(this, "getAssocPools");
        ArrayList pools = new ArrayList();
        return pools;
    }

    public ArrayList getAssocVolumes() throws ConfigMgmtException {
        String METHOD = "getAssocVolumes";
        Trace.methodBegin(this, "getAssocVolumes");
        ArrayList volumes = new ArrayList();
        return volumes;
    }

    public Collection getKey() {
        Trace.methodBegin(this, "getKey");
        return this.keyProperties;
    }

    public String getProductVersion() {
        Trace.methodBegin(this, "getProductVersion");
        return this.productVersion;
    }

    public int getAccessDirectionHint() {
        Trace.methodBegin(this, "getAccessDirectionHint");
        return this.accessDirectionHint;
    }

    public int getAccessBandwidthWeight() {
        Trace.methodBegin(this, "getAccessBandwidthWeight");
        return this.accessBandwidthWeight;
    }

    public int getSnapshotPoolPercent() {
        Trace.methodBegin(this, "getSnapshotPoolPercent");
        return -1;
    }

    public int getDataRedundancy() {
        Trace.methodBegin(this, "getDataRedundancy");
        return this.dataRedundancy;
    }

    public int getPackageRedundancy() {
        Trace.methodBegin(this, "getPackageRedundancy");
        return this.packageRedundancy;
    }

    public boolean getNoSinglePointOfFailure() {
        Trace.methodBegin(this, "getNoSinglePointOfFailure");
        return this.noSinglePointOfFailure;
    }

    public String getInstanceID() {
        Trace.methodBegin(this, "getInstanceID");
        return this.instanceID;
    }

    public CIMInstance getInstance() {
        Trace.methodBegin(this, "getInstance");
        return this.instance;
    }

    public void setName(String name) throws ConfigMgmtException, BadParameterException {
        Trace.methodBegin(this, "setName");
        this.name = name;
    }

    public void setDescription(String description) throws BadParameterException {
        Trace.methodBegin(this, "setDescription");
        this.description = description;
    }

    public void setSegmentSize(int segmentSize) throws BadParameterException {
        Trace.methodBegin(this, "setSegmentSize");
        if (segmentSize == 2 || segmentSize == 3 || segmentSize == 0 || segmentSize == 4 || segmentSize == 1) {
            this.segmentSize = segmentSize;
            return;
        }
        Trace.error((Object)this, "setSegmentSize", "Invalid Segment Size specified: " + segmentSize);
        throw new BadParameterException(new Integer(segmentSize).toString(), "error.bizobj.segmentSizeInvalid");
    }

    public void setReadAhead(boolean readAheadEnabled) {
        Trace.methodBegin(this, "setReadAhead");
        this.accessDirectionHint = readAheadEnabled ? 0 : 10;
    }

    public void setRAIDLevel(int raidLevel) throws BadParameterException {
        Trace.methodBegin(this, "setRAIDLevel");
        if (raidLevel == 0 || raidLevel == 1 || raidLevel == 5) {
            this.raidLevel = raidLevel;
            return;
        }
        Trace.error((Object)this, "setRAIDLevel", "Invalid RAID Level specified: " + raidLevel);
        throw new BadParameterException(new Integer(raidLevel).toString(), "error.bizobj.raidLevelInvalid");
    }

    public void setArrayType(int arrayType) throws BadParameterException {
        Trace.methodBegin(this, "setArrayType");
        if (arrayType == 2) {
            this.accessBandwidthWeight = 0;
            return;
        }
        if (arrayType == 5) {
            this.accessBandwidthWeight = 2;
            return;
        }
        if (arrayType == 3) {
            this.accessBandwidthWeight = 4;
            return;
        }
        if (arrayType == 0) {
            this.accessBandwidthWeight = 6;
            return;
        }
        if (arrayType == 4) {
            this.accessBandwidthWeight = 8;
            return;
        }
        if (arrayType == 1) {
            this.accessBandwidthWeight = 10;
            return;
        }
        Trace.error((Object)this, "setArrayType", "Invalid Array Type specified: " + arrayType);
        throw new BadParameterException(new Integer(arrayType).toString(), "error.bizobj.arrayTypeInvalid");
    }

    public void setNumberOfDisks(int numberOfDisks) throws BadParameterException {
        Trace.methodBegin(this, "setNumberOfDisks");
        if (numberOfDisks == 0 || numberOfDisks == 2 || numberOfDisks == 3 || numberOfDisks == 4 || numberOfDisks == 5 || numberOfDisks == 6 || numberOfDisks == 7 || numberOfDisks == 8 || numberOfDisks == 9 || numberOfDisks == 10 || numberOfDisks == 11 || numberOfDisks == 12 || numberOfDisks == 13 || numberOfDisks == 14) {
            this.numberOfDisks = numberOfDisks;
            return;
        }
        Trace.error((Object)this, "setNumberOfDisks", "Invalid Number of Disks specified: " + numberOfDisks);
        throw new BadParameterException(new Integer(numberOfDisks).toString(), "error.bizobj.numDisksInvalid");
    }

    public void setVirtualizationStrategy(int virtualizationStrategy) throws BadParameterException {
        Trace.methodBegin(this, "setVirtualizationStrategy");
        Trace.error((Object)this, "setVirtualizationStrategy", "not supported in midrange");
        throw new BadParameterException(new Integer(virtualizationStrategy).toString(), "error.bizobj.virtStrategyInvalid");
    }

    public void setStripeSize(int stripeSize) throws BadParameterException {
        Trace.methodBegin(this, "setStripeSize");
        Trace.error((Object)this, "setStripeSize", "Stripe Size not supported in midrange.");
        throw new BadParameterException(new Integer(stripeSize).toString(), "error.bizobj.stripeSizeInvalid");
    }

    public void setDedicatedSpare(boolean dedicatedSpareExists) {
        Trace.methodBegin(this, "setDedicatedSpare");
        this.hotSpare = dedicatedSpareExists;
    }

    public void setPopname(String popname) {
        Trace.methodBegin(this, "setPopname");
        this.name = popname;
    }

    public void setInstanceID(String instanceID) {
        Trace.methodBegin(this, "setInstanceID");
        this.instanceID = instanceID;
    }

    public void setProductVersion(String productVersion) {
        Trace.methodBegin(this, "setProductVersion");
        this.productVersion = productVersion;
    }

    public void setAccessDirectionHint(int accessDirectionHint) {
        Trace.methodBegin(this, "setAccessDirectionHint");
        this.accessDirectionHint = accessDirectionHint;
    }

    public void setAccessBandwidthWeight(int accessBandwidthWeight) {
        Trace.methodBegin(this, "setAccessBandwidthWeight");
        this.accessBandwidthWeight = accessBandwidthWeight;
    }

    public void setSnapshotPoolPercent(int snapshotPoolPercent) {
        Trace.methodBegin(this, "setSnapshotPoolPercent");
    }

    public void setDataRedundancy(int dataRedundancy) {
        Trace.methodBegin(this, "setDataRedundancy");
        this.dataRedundancy = dataRedundancy;
    }

    public void setPackageRedundancy(int packageRedundancy) {
        Trace.methodBegin(this, "setPackageRedundancy");
        this.packageRedundancy = packageRedundancy;
    }

    public void setNoSinglePointOfFailure(boolean noSinglePointOfFailure) {
        Trace.methodBegin(this, "setNoSinglePointOfFailure");
        this.noSinglePointOfFailure = noSinglePointOfFailure;
    }

    public void setInstance(CIMInstance instance) {
        Trace.methodBegin(this, "setInstance");
        this.instance = instance;
    }

    public void setKey(Collection props) {
        Trace.methodBegin(this, "setKey");
        this.keyProperties = props;
    }

    public void setRaidLevelHelper() {
        if (!this.hotSpare && this.raidLevel == 0) {
            this.dataRedundancy = 1;
            this.packageRedundancy = 0;
            this.noSinglePointOfFailure = false;
        } else if (this.hotSpare && this.raidLevel == 1) {
            this.dataRedundancy = 2;
            this.packageRedundancy = 2;
            this.noSinglePointOfFailure = true;
        } else if (!this.hotSpare && this.raidLevel == 1) {
            this.dataRedundancy = 2;
            this.packageRedundancy = 1;
            this.noSinglePointOfFailure = true;
        } else if (this.hotSpare && this.raidLevel == 5) {
            this.dataRedundancy = 1;
            this.packageRedundancy = 2;
            this.noSinglePointOfFailure = true;
        } else if (!this.hotSpare && this.raidLevel == 5) {
            this.dataRedundancy = 1;
            this.packageRedundancy = 1;
            this.noSinglePointOfFailure = true;
        }
    }

    public int getImportStatus() {
        return -1;
    }

    public boolean equalSettings(StorageProfileInterface targetProfile) {
        return false;
    }

    public void saveFromXML(ConfigContext context) throws ConfigMgmtException, BadParameterException {
    }

    public String toXml() {
        return "";
    }

    public String toString() {
        return "\nStorageProfile with:\n    CIMObjectPath: " + (this.instance != null ? this.instance.getObjectPath() : null) + "\n    name: " + this.getName() + "\n    key(s): " + this.getInstanceID() + "\n    description: " + this.getDescription() + "\n    product version: " + this.productVersion + "\n    segment size: " + this.getSegmentSize() + "\n    read ahead: " + this.isReadAheadEnabled() + "\n    array type: " + this.getArrayType() + "\n    RAID level: " + this.getRAIDLevel() + "\n    number of disks: " + this.getNumberOfDisks() + "\n    dedicated spare: " + this.dedicatedSpareExists();
    }
}

