/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.test;

import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.MethodCallStatus;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageVolumesFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageVolumesInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.RaidGroupInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageProfile;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javax.wbem.cim.CIMInstance;

public class RaidGroup
implements RaidGroupInterface {
    private ConfigContext context;
    private ArrayList volumes;
    private int raidLevel;
    private BigInteger totalCapacity;
    private BigInteger availableCapacity;
    private int numberOfDrives;
    private String name;
    private int numberOfHotSpare;
    private String status = "online";
    private String state = "Ready";
    private CIMInstance raidGroupCimInstance;
    private int begDiskNum = 1;
    private int endDiskNum = 6;
    private String tee4Name = "auggie";

    public RaidGroup() {
        Trace.constructor(this);
    }

    public void init(ConfigContext context) {
        this.context = context;
    }

    public void reload() {
        Trace.verbose((Object)this, "reload", "This method should reload the RaidGroup object to its original state");
    }

    public void changeStatus(String status) throws ConfigMgmtException {
        this.status = status;
    }

    public void save() throws ConfigMgmtException {
        Trace.methodBegin(this, "save");
    }

    public MethodCallStatus delete() throws ConfigMgmtException {
        Trace.methodBegin(this, "delete");
        return new MethodCallStatus();
    }

    public String getT4Name() {
        return this.tee4Name;
    }

    public int getRaidLevel() {
        return this.raidLevel;
    }

    public BigInteger getTotalCapacity() {
        return this.totalCapacity;
    }

    public BigInteger getAvailableCapacity() {
        return this.availableCapacity;
    }

    public int getNumberOfDrives() {
        Trace.verbose((Object)this, "getNumberOfDrives", "Getting number of drives = " + this.numberOfDrives);
        return this.numberOfDrives;
    }

    public int getBeginDiskNumber() throws ConfigMgmtException {
        return this.begDiskNum;
    }

    public int getEndDiskNumber() throws ConfigMgmtException {
        return this.endDiskNum;
    }

    public String getName() {
        return this.name;
    }

    public int getUseHotSpare() {
        return this.numberOfHotSpare;
    }

    public String getStatus() {
        return this.status;
    }

    public String getState() {
        return this.state;
    }

    public List getVolumes() throws ConfigMgmtException {
        if (this.volumes == null) {
            this.volumes = new ArrayList();
            Trace.verbose((Object)this, "getVolumes", "Getting Volumes Manager via Factory to get Volumes!!");
            ManageStorageVolumesInterface manageStorageVols = ManageStorageVolumesFactory.getManager();
            manageStorageVols.setScope(this);
            manageStorageVols.init(this.context, null);
            this.volumes = (ArrayList)manageStorageVols.getItemList();
        }
        return this.volumes;
    }

    public CIMInstance getInstance() {
        return this.raidGroupCimInstance;
    }

    public BigInteger getEffectiveDiskSize() throws ConfigMgmtException {
        String methodName = "getEffectiveDiskSize";
        Trace.methodBegin(this, methodName);
        return new BigInteger("1000000000");
    }

    public String getProfileName() throws ConfigMgmtException {
        String methodName = "getProfileName";
        Trace.methodBegin(this, methodName);
        return "High Performance Computing";
    }

    public String getTrayId() {
        return "0";
    }

    public void setRaidLevel(int raidLevel) {
        this.raidLevel = raidLevel;
    }

    public void setNumberOfDrives(int numberOfDrives) {
        Trace.verbose((Object)this, "setNumberOfDrives", "set number of drives = " + numberOfDrives);
        this.numberOfDrives = numberOfDrives;
    }

    public void setTotalCapacity(BigInteger totalCapacity) {
        this.totalCapacity = totalCapacity;
    }

    public void setAvailableCapacity(BigInteger availableCapacity) {
        this.availableCapacity = availableCapacity;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setUseHotSpare(int numberOfHotSpare) {
        this.numberOfHotSpare = numberOfHotSpare;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setState(String state) {
        this.state = state;
    }

    public MethodCallStatus initialize() throws ConfigMgmtException {
        Trace.methodBegin(this, "initialize");
        return new MethodCallStatus(0, null);
    }

    public void applyNewProfile(StorageProfile newProfile, boolean profileNameOnly) throws ConfigMgmtException {
        Trace.methodBegin(this, "applyNewProfile");
    }
}

