/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.test;

import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.logic.SearchFilter;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.InstanceWrapper;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageRaidGroupsInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.T4Interface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.TrayInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.test.RaidGroup;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class ManageRaidGroups
implements ManageRaidGroupsInterface {
    private ArrayList raidGroupList;
    private ConfigContext context;
    private SearchFilter filter;
    private InstanceWrapper scope;

    public ManageRaidGroups() {
        Trace.constructor(this);
    }

    public void setScope(InstanceWrapper scope) {
        Trace.methodBegin(this, "setScope");
        this.scope = scope;
    }

    public void init(ConfigContext context, SearchFilter filter) throws ConfigMgmtException {
        Trace.methodBegin(this, "init");
        this.context = context;
        this.filter = filter;
        this.raidGroupList = new ArrayList();
        boolean okayToLoad = true;
        int numOfRaidGroups = 0;
        if (this.scope == null && filter == null) {
            numOfRaidGroups = 16;
        } else if (this.scope == null && filter != null) {
            numOfRaidGroups = 43;
        } else if (this.scope instanceof T4Interface && filter == null) {
            numOfRaidGroups = 12;
        } else if (this.scope instanceof T4Interface && filter != null) {
            numOfRaidGroups = 9;
        } else if (this.scope instanceof TrayInterface && filter == null) {
            numOfRaidGroups = 2;
        } else if (this.scope instanceof TrayInterface && filter != null) {
            numOfRaidGroups = 1;
        } else {
            okayToLoad = false;
        }
        if (okayToLoad) {
            for (int i = 1; i < numOfRaidGroups; ++i) {
                this.createNewRaidGroup(1, 5, new BigInteger("2000000000"), new BigInteger("1500000000"), "sp04876" + i, 0, "online", "Ready");
            }
        }
        Trace.verbose((Object)this, "init", "number of RAID group in list: " + this.raidGroupList.size());
    }

    public List getItemList() throws ConfigMgmtException {
        return this.raidGroupList;
    }

    private void createNewRaidGroup(int raidLevel, int numberOfDrives, BigInteger totalCapacity, BigInteger availableCapacity, String name, int useHotSpare, String status, String state) throws ConfigMgmtException {
        Trace.methodBegin(this, "createNewRaidGroup");
        RaidGroup aRaidGroup = new RaidGroup();
        aRaidGroup.setRaidLevel(raidLevel);
        aRaidGroup.setNumberOfDrives(numberOfDrives);
        aRaidGroup.setTotalCapacity(totalCapacity);
        aRaidGroup.setAvailableCapacity(availableCapacity);
        aRaidGroup.setName(name);
        aRaidGroup.setUseHotSpare(useHotSpare);
        aRaidGroup.setStatus(status);
        aRaidGroup.setState(state);
        this.raidGroupList.add(aRaidGroup);
    }
}

