/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz;

import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.MethodCallStatus;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.FeatureNotSupportedException;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.FiberChannelPortInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.T4Interface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.TrayInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.QueuedPoolData;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.FiberChannelPort;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ManageTrays;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;

public class T4
implements T4Interface {
    private ConfigContext context;
    private ArrayList trays;
    private ArrayList raidGroups;
    private String name = "Array101";
    private String description = "Array101 description";
    private int healthStatus = 2;
    private int readaheadMode = 0;
    private int blockSize = 16384;
    private int diskReconRate = 1;
    private String cacheMode = "auto";
    private String failoverMode = "mpxio";
    private CIMInstance cimInstance;
    private int configType = 8;
    FiberChannelPort fiberChannelPort;
    private int connectivityStatus;
    private int ahsPoolSize = 3;
    private boolean diskScrubbing;
    private String firmwareVersion;
    HashSet m_features;

    public T4() {
        Trace.constructor(this);
    }

    public ConfigContext getContext() {
        return this.context;
    }

    public void setConfigContext(ConfigContext ctx) {
        this.context = ctx;
    }

    public void init(ConfigContext context) {
        this.context = context;
    }

    public ConfigContext getConfigContext() {
        return this.context;
    }

    public void powerUp() throws ConfigMgmtException {
        Trace.methodBegin(this, "powerUp");
        Trace.verbose((Object)this, "powerUp", "T4 is powering up .....");
    }

    public void shutdown() throws ConfigMgmtException {
        Trace.methodBegin(this, "shutdown");
        Trace.verbose((Object)this, "shutdown", "T4 is shutting down.....");
    }

    public void reboot() throws ConfigMgmtException {
        Trace.methodBegin(this, "reboot");
        Trace.verbose((Object)this, "reboot", "T4 is rebooting ....");
    }

    public void resetLabels(boolean waitUntilFinished) throws ConfigMgmtException {
        Trace.methodBegin(this, "resetLabels");
        Trace.verbose((Object)this, "resetLabels", "Running 'boot -w' on the T4....");
    }

    public void reload() {
        Trace.methodBegin(this, "reload");
        Trace.verbose((Object)this, "reload", "This method should reload the T4 object to its original state");
    }

    public MethodCallStatus cloneFrom(T4Interface sourceT4) throws ConfigMgmtException {
        Trace.methodBegin(this, "cloneFrom");
        Trace.verbose((Object)this, "cloneFrom", "T4: " + this.name + " is now being cloned by the source T4: " + sourceT4.getName());
        return new MethodCallStatus();
    }

    public void save() throws ConfigMgmtException {
        Trace.methodBegin(this, "save");
        Trace.verbose((Object)this, "save", "T4: " + this.name + " is now saving.....");
    }

    public String getName() {
        return this.name;
    }

    public String getClusterName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public int getHealthStatus() throws ConfigMgmtException {
        return this.healthStatus;
    }

    public int getDiskReconRate() {
        return this.diskReconRate;
    }

    public String getFailoverMode() {
        return this.failoverMode;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public int getReadaheadMode() {
        return this.readaheadMode;
    }

    public String getCacheMode() {
        return this.cacheMode;
    }

    public List getTrays() throws ConfigMgmtException {
        if (this.trays == null) {
            ManageTrays manageTrays = new ManageTrays();
            this.trays = (ArrayList)manageTrays.getItemList();
        }
        return this.trays;
    }

    public void setTrays(ArrayList trays) {
        this.trays = trays;
    }

    public List getRaidGroups() throws ConfigMgmtException {
        return new ArrayList();
    }

    public CIMInstance getInstance() {
        return this.cimInstance;
    }

    public int getMaxNumberOfVolumes() throws ConfigMgmtException {
        Trace.methodBegin(this, "getMaxNumberOfVolumes");
        return 64;
    }

    public int getConnectivity() {
        return this.connectivityStatus;
    }

    public int getAhsPoolSize() throws ConfigMgmtException {
        String methodName = "getAhsPoolSize";
        Trace.methodBegin(this, methodName);
        return this.ahsPoolSize;
    }

    public int getMaxAhsPoolSizeAllowed() throws ConfigMgmtException {
        String methodName = "getMaxAhsPoolSizeAllowed";
        Trace.methodBegin(this, methodName);
        return 8;
    }

    public boolean isDiskScrubbing() {
        String methodName = "isDiskScrubbing";
        Trace.methodBegin(this, methodName);
        return this.diskScrubbing;
    }

    public int getArrayConfigurationType() throws ConfigMgmtException {
        Trace.methodBegin(this, "getArrayConfigurationType");
        return this.configType;
    }

    public void setArrayConfigurationType(int type) {
        this.configType = type;
    }

    public boolean isFeatureSupported(int feature) {
        boolean forReturn = true;
        if (this.m_features != null) {
            return this.m_features.contains(new Integer(feature));
        }
        return forReturn;
    }

    public void setFeatureSupported(int feature) {
        if (this.m_features == null) {
            this.m_features = new HashSet();
        }
        this.m_features.add(new Integer(feature));
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setBlockSize(int blockSize) {
        this.blockSize = blockSize;
    }

    public void setDiskReconRate(int diskReconRate) {
        this.diskReconRate = diskReconRate;
    }

    public void setReadaheadMode(int readaheadMode) {
        this.readaheadMode = readaheadMode;
    }

    public void setFailoverMode(String failoverMode) {
        this.failoverMode = failoverMode;
    }

    public void setCacheMode(String cacheMode) {
        this.cacheMode = cacheMode;
    }

    public void setConnectivity(int status) {
        this.connectivityStatus = status;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setHealthStatus(int healthStatus) {
        this.healthStatus = healthStatus;
    }

    public FiberChannelPortInterface getFiberChannelPort() throws ConfigMgmtException {
        if (null == this.fiberChannelPort) {
            this.fiberChannelPort = new FiberChannelPort();
        }
        return this.fiberChannelPort;
    }

    public void refreshProviderCache() throws ConfigMgmtException {
        Trace.methodBegin(this, "refreshProviderCache");
        Trace.verbose((Object)this, "refreshProviderCache", "Trying to refresh provider cache...");
    }

    public void setAhsPoolSize(int ahsPoolSize) {
        String methodName = "setAhsPoolSize";
        Trace.methodBegin(this, methodName);
        this.ahsPoolSize = ahsPoolSize;
    }

    public void setDiskScrubbing(boolean diskScrubbing) {
        String methodName = "setDiskScrubbing";
        Trace.methodBegin(this, methodName);
        this.diskScrubbing = diskScrubbing;
    }

    public QueuedPoolData getQueuedPoolData() throws ConfigMgmtException {
        return null;
    }

    public boolean isDuplicateCandidate(T4Interface cand) throws ConfigMgmtException {
        String METHOD = "isDuplicateCandidate";
        Trace.methodBegin(this, "isDuplicateCandidate");
        List srcTrays = this.getTrays();
        if (cand.getClusterName().equals(this.getClusterName())) {
            Trace.verbose((Object)this, "isDuplicateCandidate", "Same array is not a candidate: " + cand.getName());
            return false;
        }
        if (cand.getHealthStatus() != 2) {
            Trace.verbose((Object)this, "isDuplicateCandidate", "Skipping unhealthy array: " + cand.getName());
            return false;
        }
        if (this.isFeatureSupported(3) == cand.isFeatureSupported(3) && this.isFeatureSupported(4) == cand.isFeatureSupported(4)) {
            Trace.verbose((Object)this, "isDuplicateCandidate", "Skipping array with different firmware version: " + cand.getName());
            return false;
        }
        List destTrays = cand.getTrays();
        if (destTrays.size() != srcTrays.size()) {
            Trace.verbose((Object)this, "isDuplicateCandidate", "Different number of trays: " + cand.getName());
            return false;
        }
        for (int j = 0; j < srcTrays.size(); ++j) {
            TrayInterface sTray = (TrayInterface)srcTrays.get(j);
            TrayInterface dTray = (TrayInterface)destTrays.get(j);
            if (sTray.getTrayType() != dTray.getTrayType()) {
                Trace.verbose((Object)this, "isDuplicateCandidate", "Different types of trays: " + cand.getName());
                return false;
            }
            if (sTray.areDisksCompatible(dTray)) continue;
            Trace.verbose((Object)this, "isDuplicateCandidate", "Incompatible disks: " + cand.getName());
            return false;
        }
        return true;
    }

    public String getOndgMode() {
        return "befit";
    }

    public void setOndgMode(String befit) throws FeatureNotSupportedException {
    }

    public Collection getKeys() {
        Trace.methodBegin(this, "getKeys");
        ArrayList<CIMProperty> kl = new ArrayList<CIMProperty>();
        kl.add(new CIMProperty("TEST", new CIMValue((Object)"TEST")));
        return kl;
    }

    public CIMObjectPath getPrimordialPoolPath() {
        return new CIMObjectPath("SunStorEdge_6120PrimordialPool");
    }

    public BigInteger getStorageCapacity() throws ConfigMgmtException {
        return new BigInteger("100000000");
    }

    public BigInteger getUnallocatedCapacity() throws ConfigMgmtException {
        return new BigInteger("50000000");
    }

    public int getConfigType() {
        return this.configType;
    }

    public void setConfigType(int configType) {
        this.configType = configType;
    }

    public int getConnectivityStatus() {
        return this.connectivityStatus;
    }

    public void setConnectivityStatus(int connectivityStatus) {
        this.connectivityStatus = connectivityStatus;
    }

    public String getFirmwareVersion() {
        return this.firmwareVersion;
    }

    public void setFirmwareVersion(String firmwareVersion) {
        this.firmwareVersion = firmwareVersion;
    }

    public void setContext(ConfigContext context) {
        this.context = context;
    }

    public void setFiberChannelPort(FiberChannelPort fiberChannelPort) {
        this.fiberChannelPort = fiberChannelPort;
    }

    public void setRaidGroups(ArrayList raidGroups) {
        this.raidGroups = raidGroups;
    }

    public boolean hasConfiguredStorage() {
        return false;
    }

    public int getMaxDisksAvailNoRedun() {
        return 0;
    }

    public int getMaxDisksAvailWithRedun() {
        return 0;
    }
}

