/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz;

import com.sun.netstorage.array.mgmt.cfg.core.ErrorCode;
import com.sun.netstorage.array.mgmt.cfg.core.ErrorDescriptor;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.BadParameterException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.SEItemNotFoundException;
import com.sun.netstorage.array.mgmt.cfg.core.impl.ObjectBundleManager;
import com.sun.netstorage.array.mgmt.cfg.core.ini.Repository;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.StorageProfileCommon;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.Profile;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ProfileData;
import com.sun.netstorage.array.mgmt.cfg.util.XMLUtils;
import devmgr.versioned.jrpc.RPCError;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ProfileDataManager {
    public static final String PRODUCT_VERSION = "20040630";
    public static final String DEFAULT_DATA_FILE_NAME = "profiles6130.xml";
    public static final String DEFAULT_DATA_DIR_NAME = "/opt/SUNWse6130ui/resources";
    public static final String DEFAULT_PROFILES_FILE_PROP = "factory-defined-profiles";
    static final String XML_DATA = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    static final String TAG_TOP_LEVEL = "sscs_storage_profiles";
    static final String TAG_PROFILE = "sscs_storage_profile";
    static final String ATT_KEY = "key";
    static final String TAG_NAME = "profile_name";
    static final String TAG_VERSION = "product_version";
    static final String TAG_DESC = "profile_description";
    static final String TAG_RAID = "raid_level";
    static final String TAG_SEG_SIZE = "segment_size";
    static final String TAG_READ_AHEAD = "read_ahead_mode";
    static final String TAG_DRIVE_TYPE = "drive_type";
    static final String TAG_NUM_DISKS = "number_of_disks";
    static final String TAG_FACTORY_PROFILE = "factory_profile";
    String _arrayId = null;
    ObjectBundleManager _obm = null;
    static /* synthetic */ Class class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager;

    public ProfileDataManager(String arrayId) {
        this._arrayId = arrayId;
        this._obm = ObjectBundleManager.getInstance();
    }

    public Map getRawProfileMap() throws SEItemNotFoundException, ConfigMgmtException {
        Map rpm;
        block2: {
            rpm = new HashMap();
            try {
                rpm = (Map)this._obm.getProfileData(this._arrayId);
            }
            catch (ConfigMgmtException cme) {
                if ("error.reason.100218".equals(cme.getExceptionKey()) || "error.reason.100029".equals(cme.getExceptionKey()) || "error.reason.100030".equals(cme.getExceptionKey())) break block2;
                throw cme;
            }
        }
        return rpm;
    }

    public Collection getRawProfiles() throws SEItemNotFoundException, ConfigMgmtException {
        Collection rawData = this.getRawProfileMap().values();
        return rawData;
    }

    public Profile getProfile(String profileId) throws SEItemNotFoundException, ConfigMgmtException {
        Map rpm = this.getRawProfileMap();
        return (Profile)rpm.get(profileId);
    }

    public void saveData(Collection profiles) throws SEItemNotFoundException, ConfigMgmtException, RPCError, IOException {
        if (profiles == null) {
            return;
        }
        this._obm.stopMonitoringThread(this._arrayId);
        this._obm.setProfileData(this._arrayId, profiles);
        this._obm.forceBundleReload(this._arrayId);
    }

    public static Profile populateProfileFromElement(Element profileEl) throws ConfigMgmtException {
        return ProfileDataManager.populateProfileDataFromElement(profileEl).getProfile();
    }

    private static ProfileData populateProfileDataFromElement(Element profileEl) throws ConfigMgmtException {
        String METHOD = "populateProfileDataFromElement";
        ProfileData p = new ProfileData();
        try {
            p.profileKeyString = URLDecoder.decode(profileEl.getAttribute(ATT_KEY), "UTF-8");
            p.profileKey = new HashMap();
            p.profileKey.put("id", p.profileKeyString);
            p.profileName = URLDecoder.decode(XMLUtils.getElementValue(XMLUtils.findElement(profileEl, TAG_NAME)), "UTF-8");
            ProfileDataManager.validateName(p.profileName);
            String elem = "";
            elem = XMLUtils.getElementValue(XMLUtils.findElement(profileEl, TAG_VERSION));
            elem = elem == null ? "-" : elem;
            p.productVersion = URLDecoder.decode(elem, "UTF-8");
            elem = XMLUtils.getElementValue(XMLUtils.findElement(profileEl, TAG_DESC));
            elem = elem == null ? "-" : elem;
            p.profileDesc = URLDecoder.decode(elem, "UTF-8");
            ProfileDataManager.validateDescription(p.profileDesc);
            p.raidLevel = Integer.parseInt(URLDecoder.decode(XMLUtils.getElementValue(XMLUtils.findElement(profileEl, TAG_RAID)), "UTF-8"));
            ProfileDataManager.validateRaidLevel(p.raidLevel);
            p.segmentSize = ProfileDataManager.getSegmentSizeInt(URLDecoder.decode(XMLUtils.getElementValue(XMLUtils.findElement(profileEl, TAG_SEG_SIZE)), "UTF-8"));
            ProfileDataManager.validateSegmentSize(p.segmentSize);
            String s_ra = URLDecoder.decode(XMLUtils.getElementValue(XMLUtils.findElement(profileEl, TAG_READ_AHEAD)), "UTF-8");
            if (!s_ra.equalsIgnoreCase("on") && !s_ra.equalsIgnoreCase("off")) {
                throw new ConfigMgmtException(ErrorCode.ERROR_PROFILE_INVALID_XML_FOR_IMPORT.getKey(), "unexpected value for read ahead: " + s_ra);
            }
            p.readAhead = StorageProfileCommon.getBooleanFromOnOrOff(s_ra);
            p.driveType = ProfileDataManager.getDriveTypeInt(URLDecoder.decode(XMLUtils.getElementValue(XMLUtils.findElement(profileEl, TAG_DRIVE_TYPE)), "UTF-8"));
            ProfileDataManager.validateDriveType(p.driveType);
            String elNumDisks = URLDecoder.decode(XMLUtils.getElementValue(XMLUtils.findElement(profileEl, TAG_NUM_DISKS)), "UTF-8");
            if (elNumDisks.equalsIgnoreCase("variable")) {
                elNumDisks = "0";
            }
            p.numDisks = Integer.parseInt(elNumDisks);
            String elFactoryProfile = URLDecoder.decode(XMLUtils.getElementValue(XMLUtils.findElement(profileEl, TAG_FACTORY_PROFILE)), "UTF-8");
            p.factoryProfile = elFactoryProfile.equals(profileEl) ? false : StorageProfileCommon.getBooleanFromYesOrNo(XMLUtils.getElementValue(XMLUtils.findElement(profileEl, TAG_FACTORY_PROFILE)));
        }
        catch (Exception e) {
            Trace.error(class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager == null ? (class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager = ProfileDataManager.class$("com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ProfileDataManager")) : class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager, "populateProfileDataFromElement", (Throwable)e);
            if (e instanceof ConfigMgmtException) {
                throw (ConfigMgmtException)e;
            }
            throw new ConfigMgmtException(ErrorCode.ERROR_PROFILE_INVALID_XML_FOR_IMPORT.getKey(), e.getMessage(), e);
        }
        return p;
    }

    public static List getXmlContentsForImport(String xml) throws ConfigMgmtException {
        String METHOD = "getXmlContentsForImport";
        Trace.methodBegin(class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager == null ? (class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager = ProfileDataManager.class$("com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ProfileDataManager")) : class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager, "getXmlContentsForImport");
        ArrayList<Profile> forReturn = new ArrayList<Profile>();
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = builder.parse(new InputSource(new StringReader(xml)));
            if (document == null) {
                Trace.error(class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager == null ? (class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager = ProfileDataManager.class$("com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ProfileDataManager")) : class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager, "getXmlContentsForImport", "no data provided.");
                throw new ConfigMgmtException(ErrorCode.ERROR_PROFILE_INVALID_XML_FOR_IMPORT.getKey(), "no data provided");
            }
            Element root = document.getDocumentElement();
            NodeList profileNodes = root.getElementsByTagName(TAG_PROFILE);
            int size = profileNodes == null ? 0 : profileNodes.getLength();
            for (int i = 0; i < size; ++i) {
                Element profileEl = (Element)profileNodes.item(i);
                forReturn.add(ProfileDataManager.populateProfileFromElement(profileEl));
            }
        }
        catch (ParserConfigurationException e) {
            Trace.error(class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager == null ? (class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager = ProfileDataManager.class$("com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ProfileDataManager")) : class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager, (Throwable)e);
            throw new ConfigMgmtException(ErrorCode.ERROR_PROFILE_INVALID_XML_FOR_IMPORT.getKey(), "Failed to create a parser.", e);
        }
        catch (SAXException e) {
            Trace.error(class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager == null ? (class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager = ProfileDataManager.class$("com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ProfileDataManager")) : class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager, (Throwable)e);
            throw new ConfigMgmtException(ErrorCode.ERROR_PROFILE_INVALID_XML_FOR_IMPORT.getKey(), "SAXException", e);
        }
        catch (IOException e) {
            Trace.error(class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager == null ? (class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager = ProfileDataManager.class$("com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ProfileDataManager")) : class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager, (Throwable)e);
            throw new ConfigMgmtException(ErrorCode.ERROR_PROFILE_INVALID_XML_FOR_IMPORT.getKey(), "IOException", e);
        }
        return forReturn;
    }

    public static String getXMLFromProfile(Profile p) {
        return ProfileDataManager.getXMLFromProfileData(new ProfileData(p));
    }

    private static String getXMLFromProfileData(ProfileData p) {
        String encKey = null;
        String encName = null;
        String encVersion = null;
        String encDesc = null;
        String encRaidLevel = null;
        String encSegSize = null;
        String encReadAhead = null;
        String encDriveType = null;
        String encNumDisks = null;
        String encFactoryProfile = null;
        try {
            String driveType;
            String segSize;
            if (p.profileKeyString != null) {
                encKey = URLEncoder.encode(p.profileKeyString, "UTF-8");
            }
            if (p.profileName != null) {
                encName = URLEncoder.encode(p.profileName, "UTF-8");
            }
            if (p.productVersion != null) {
                encVersion = URLEncoder.encode(p.productVersion, "UTF-8");
            }
            if (p.profileDesc != null) {
                encDesc = URLEncoder.encode(p.profileDesc, "UTF-8");
            }
            if ((segSize = ProfileDataManager.getSegmentSizeString(p.segmentSize)) != null) {
                encSegSize = URLEncoder.encode(segSize);
            }
            if ((driveType = ProfileDataManager.getDriveTypeString(p.driveType)) != null) {
                encDriveType = URLEncoder.encode(driveType, "UTF-8");
            }
            encReadAhead = URLEncoder.encode(p.readAhead ? "on" : "off", "UTF-8");
            encRaidLevel = URLEncoder.encode(Integer.toString(p.raidLevel), "UTF-8");
            encNumDisks = URLEncoder.encode(Integer.toString(p.numDisks), "UTF-8");
            encFactoryProfile = URLEncoder.encode(p.factoryProfile ? "yes" : "no", "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            Trace.error(class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager == null ? (class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager = ProfileDataManager.class$("com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ProfileDataManager")) : class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager, "getXMLFromProfileData", (Throwable)e);
        }
        StringBuffer sb = new StringBuffer();
        sb.append("  <").append(TAG_PROFILE).append(" ").append(ATT_KEY).append("=\"").append(encKey).append("\">\n");
        sb.append("    <").append(TAG_NAME).append(">").append(encName).append("</").append(TAG_NAME).append(">\n");
        sb.append("    <").append(TAG_VERSION).append(">").append(encVersion).append("</").append(TAG_VERSION).append(">\n");
        sb.append("    <").append(TAG_DESC).append(">").append(encDesc).append("</").append(TAG_DESC).append(">\n");
        sb.append("    <").append(TAG_RAID).append(">").append(encRaidLevel).append("</").append(TAG_RAID).append(">\n");
        sb.append("    <").append(TAG_SEG_SIZE).append(">").append(encSegSize).append("</").append(TAG_SEG_SIZE).append(">\n");
        sb.append("    <").append(TAG_READ_AHEAD).append(">").append(encReadAhead).append("</").append(TAG_READ_AHEAD).append(">\n");
        sb.append("    <").append(TAG_DRIVE_TYPE).append(">").append(encDriveType).append("</").append(TAG_DRIVE_TYPE).append(">\n");
        sb.append("    <").append(TAG_NUM_DISKS).append(">").append(encNumDisks).append("</").append(TAG_NUM_DISKS).append(">\n");
        sb.append("    <").append(TAG_FACTORY_PROFILE).append(">").append(encFactoryProfile).append("</").append(TAG_FACTORY_PROFILE).append(">\n");
        sb.append("  </").append(TAG_PROFILE).append(">\n");
        return sb.toString();
    }

    public static String getDriveTypeString(int driveType) {
        if (driveType == 0) {
            return "ANY";
        }
        if (driveType == 1) {
            return "SATA";
        }
        if (driveType == 2) {
            return "FC";
        }
        return null;
    }

    public static int getDriveTypeInt(String driveType) {
        if (driveType.equalsIgnoreCase("ANY") || driveType.equalsIgnoreCase("null")) {
            return 0;
        }
        if (driveType.equalsIgnoreCase("SATA")) {
            return 1;
        }
        if (driveType.equalsIgnoreCase("FC")) {
            return 2;
        }
        return -1;
    }

    public static int getSegmentSizeInt(String segmentSize) {
        if ("4K".equalsIgnoreCase(segmentSize)) {
            return 0;
        }
        if ("8K".equalsIgnoreCase(segmentSize)) {
            return 1;
        }
        if ("16K".equalsIgnoreCase(segmentSize)) {
            return 2;
        }
        if ("32K".equalsIgnoreCase(segmentSize)) {
            return 3;
        }
        if ("64K".equalsIgnoreCase(segmentSize)) {
            return 4;
        }
        if ("128K".equalsIgnoreCase(segmentSize)) {
            return 5;
        }
        if ("256K".equalsIgnoreCase(segmentSize)) {
            return 6;
        }
        if ("512K".equalsIgnoreCase(segmentSize)) {
            return 7;
        }
        return -1;
    }

    public static String getSegmentSizeString(int segmentSize) {
        if (segmentSize == 0) {
            return "4K";
        }
        if (segmentSize == 1) {
            return "8K";
        }
        if (segmentSize == 2) {
            return "16K";
        }
        if (segmentSize == 3) {
            return "32K";
        }
        if (segmentSize == 4) {
            return "64K";
        }
        if (segmentSize == 5) {
            return "128K";
        }
        if (segmentSize == 6) {
            return "256K";
        }
        if (segmentSize == 7) {
            return "512K";
        }
        return null;
    }

    public static int convertSegSizeBytesToProfileSegSize(int segSizeBytes) {
        int returnVal = -1;
        if (segSizeBytes == 4096) {
            returnVal = 0;
        } else if (segSizeBytes == 8192) {
            returnVal = 1;
        } else if (segSizeBytes == 16384) {
            returnVal = 2;
        } else if (segSizeBytes == 32768) {
            returnVal = 3;
        } else if (segSizeBytes == 65536) {
            returnVal = 4;
        } else if (segSizeBytes == 131072) {
            returnVal = 5;
        } else if (segSizeBytes == 262144) {
            returnVal = 6;
        } else if (segSizeBytes == 524288) {
            returnVal = 7;
        }
        return returnVal;
    }

    public static int convertProfileSegSizeToBytes(int profileSegSize) {
        int returnVal = -1;
        if (profileSegSize == 0) {
            returnVal = 4096;
        } else if (profileSegSize == 1) {
            returnVal = 8192;
        } else if (profileSegSize == 2) {
            returnVal = 16384;
        } else if (profileSegSize == 3) {
            returnVal = 32768;
        } else if (profileSegSize == 4) {
            returnVal = 65536;
        } else if (profileSegSize == 5) {
            returnVal = 131072;
        } else if (profileSegSize == 6) {
            returnVal = 262144;
        } else if (profileSegSize == 7) {
            returnVal = 524288;
        }
        return returnVal;
    }

    public static int convert6130DriveTypeToProfileDriveType(int dt6130) {
        int forReturn = -1;
        if (dt6130 == 2) {
            forReturn = 2;
        } else if (dt6130 == 3) {
            forReturn = 1;
        } else if (dt6130 == 0) {
            forReturn = 0;
        }
        return forReturn;
    }

    public static int convertProfileDriveTypeTo6130DriveType(int profDt) {
        int forReturn = -1;
        if (profDt == 2) {
            forReturn = 2;
        } else if (profDt == 1) {
            forReturn = 3;
        } else if (profDt == 0) {
            forReturn = 0;
        }
        return forReturn;
    }

    public static boolean nameIsUnique(String newName, List profiles) {
        String METHOD = "nameIsUnqiue";
        Trace.methodBegin(class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager == null ? (class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager = ProfileDataManager.class$("com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ProfileDataManager")) : class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager, "nameIsUnqiue");
        boolean result = true;
        if (newName == null) {
            return false;
        }
        if (profiles == null) {
            Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager == null ? (class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager = ProfileDataManager.class$("com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ProfileDataManager")) : class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager, "nameIsUnqiue", "No existing profiles, so true.");
            return true;
        }
        int sz = profiles.size();
        for (int i = 0; i < sz; ++i) {
            Profile p = (Profile)profiles.get(i);
            if (!p.getName().equalsIgnoreCase(newName)) continue;
            Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager == null ? ProfileDataManager.class$("com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ProfileDataManager") : class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager, "nameIsUnqiue", "Found duplicate name: " + newName);
            result = false;
        }
        return result;
    }

    public static void validateName(String name) throws ConfigMgmtException {
        String METHOD = "validateName";
        if (name != null) {
            if (name.length() > 32) {
                Trace.error(class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager == null ? (class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager = ProfileDataManager.class$("com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ProfileDataManager")) : class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager, "validateName", "Name: " + name + " is too long.");
                throw new BadParameterException(name, "error.bizobj.nameTooLong");
            }
            if (name.trim().length() == 0) {
                Trace.error(class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager == null ? (class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager = ProfileDataManager.class$("com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ProfileDataManager")) : class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager, "validateName", "Empty pool names are not allowed.");
                throw new BadParameterException("", "error.bizobj.noName");
            }
        } else {
            String msg = "Name is null.";
            Trace.error(class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager == null ? (class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager = ProfileDataManager.class$("com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ProfileDataManager")) : class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager, "validateName", msg);
            throw new BadParameterException(name, "error.bizobj.noName");
        }
        Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager == null ? (class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager = ProfileDataManager.class$("com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ProfileDataManager")) : class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager, "validateName", "name: " + name);
    }

    public static void validateDescription(String description) throws ConfigMgmtException {
        if (description != null && description.length() > 256) {
            String msg = "Description: " + description + " is too long.";
            Trace.error(class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager == null ? (class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager = ProfileDataManager.class$("com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ProfileDataManager")) : class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager, "validateDescription", msg);
            throw new ConfigMgmtException("error.bizobj.descriptionTooLong", new String[]{description}, msg, null);
        }
    }

    public static void validateSegmentSize(int segSize) throws ConfigMgmtException {
        switch (segSize) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            default: {
                String msg = "Invalid segment size: " + segSize;
                Trace.error(class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager == null ? (class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager = ProfileDataManager.class$("com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ProfileDataManager")) : class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager, "validateSegmentSize", msg);
                throw new ConfigMgmtException("INVALID_PROFILE_SEGMENT_SIZE", msg);
            }
        }
    }

    public static void validateArrayType(int arrayType) throws ConfigMgmtException {
        switch (arrayType) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            default: {
                String msg = "Invalid array type: " + arrayType;
                Trace.error(class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager == null ? (class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager = ProfileDataManager.class$("com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ProfileDataManager")) : class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager, "validateArrayType", msg);
                throw new ConfigMgmtException("INVALID_PROFILE_ARRAY_TYPE", msg);
            }
        }
    }

    public static void validateDriveType(int driveType) throws ConfigMgmtException {
        switch (driveType) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                String msg = "Invalid drive type: " + driveType;
                Trace.error(class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager == null ? (class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager = ProfileDataManager.class$("com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ProfileDataManager")) : class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager, "validateDriveType", msg);
                throw new ConfigMgmtException("INVALID_PROFILE_DRIVE_TYPE", msg);
            }
        }
    }

    public static void validateRaidLevel(int raidLevel) throws ConfigMgmtException {
        switch (raidLevel) {
            case 0: 
            case 1: 
            case 3: 
            case 5: {
                break;
            }
            default: {
                String msg = "Invalid raid level: " + raidLevel;
                Trace.error(class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager == null ? (class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager = ProfileDataManager.class$("com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ProfileDataManager")) : class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager, "validateRAIDLevel", msg);
                throw new ConfigMgmtException("INVALID_PROFILE_RAID_LEVEL", msg);
            }
        }
    }

    public static void validateConsistency(Profile profile) throws ConfigMgmtException {
        String METHOD = "validateConsistency";
        if (0 > profile.getNumberOfDisks() || profile.getNumberOfDisks() > 30) {
            String msg = "Invalid number of drives: " + profile.getNumberOfDisks();
            Trace.error(class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager == null ? (class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager = ProfileDataManager.class$("com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ProfileDataManager")) : class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager, "validateConsistency", msg);
            throw new ConfigMgmtException("INVALID_PROFILE_NUMBER_OF_DRIVES", msg);
        }
        if (profile.getNumberOfDisks() != 0) {
            if (profile.getNumberOfDisks() < 3 && (profile.getRaidLevel() == 3 || profile.getRaidLevel() == 5)) {
                String msg = "Must have at least 3 disks when using RAID 3 or 5, requested: " + profile.getNumberOfDisks();
                Trace.error(class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager == null ? (class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager = ProfileDataManager.class$("com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ProfileDataManager")) : class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager, "validateConsistency", msg);
                throw new ConfigMgmtException("storage.mgmt.profile.error.rl5.nd2", new String[]{"" + profile.getRaidLevel()}, msg, null);
            }
            if (profile.getRaidLevel() == 1 && profile.getNumberOfDisks() % 2 != 0) {
                String msg = "Must use an even number of disks, or variable, when using RAID 1, requested: " + profile.getNumberOfDisks();
                Trace.error(class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager == null ? (class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager = ProfileDataManager.class$("com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ProfileDataManager")) : class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager, "validateConsistency", msg);
                throw new ConfigMgmtException("storage.mgmt.profile.error.raid1.odd.disks", msg);
            }
        }
    }

    public static Collection getFactoryProfiles() throws ConfigMgmtException {
        String METHOD = "getFactoryProfiles";
        Document document = ProfileDataManager.getFactoryProfileDocument();
        if (document == null) {
            Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager == null ? (class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager = ProfileDataManager.class$("com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ProfileDataManager")) : class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager, "getFactoryProfiles", "No factory profiles");
            throw new ConfigMgmtException(ErrorDescriptor.ERROR_ITEM_NOT_FOUND_KEY, "No factory profiles");
        }
        Map map = new HashMap();
        try {
            map = ProfileDataManager.getProfilesFromDoc(document);
        }
        catch (Exception e) {
            Trace.error(class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager == null ? (class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager = ProfileDataManager.class$("com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ProfileDataManager")) : class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager, (Throwable)e);
            ConfigMgmtException cme = null;
            cme = e instanceof ConfigMgmtException ? (ConfigMgmtException)e : new ConfigMgmtException(e);
            throw cme;
        }
        return map.values();
    }

    private static Map getProfilesFromDoc(Document document) throws ConfigMgmtException {
        NodeList profileNodes;
        HashMap<String, Profile> map = new HashMap<String, Profile>();
        Element root = document.getDocumentElement();
        NodeList profileNL = root.getElementsByTagName(TAG_TOP_LEVEL);
        Element profileRoot = (Element)profileNL.item(0);
        if (profileRoot == null) {
            profileRoot = root;
        }
        int size = (profileNodes = profileRoot.getElementsByTagName(TAG_PROFILE)) == null ? 0 : profileNodes.getLength();
        for (int i = 0; i < size; ++i) {
            Element profileEl = (Element)profileNodes.item(i);
            ProfileData p = ProfileDataManager.populateProfileDataFromElement(profileEl);
            String profileId = (String)p.profileKey.get("id");
            map.put(profileId, p.getProfile());
        }
        return map;
    }

    public static Map getProfilesFromXMLString(String xml) throws ConfigMgmtException {
        String methodName = "getProfilesFromXMLString";
        Map map = new HashMap();
        try {
            map = ProfileDataManager.getProfilesFromDoc(ProfileDataManager.getDocFromString(xml));
        }
        catch (IOException e) {
            Trace.error(class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager == null ? (class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager = ProfileDataManager.class$("com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ProfileDataManager")) : class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager, "getProfilesFromXMLString", (Throwable)e);
            throw new ConfigMgmtException(ErrorDescriptor.ERROR_IO_KEY, xml);
        }
        catch (FactoryConfigurationError e) {
            Trace.error(class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager == null ? (class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager = ProfileDataManager.class$("com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ProfileDataManager")) : class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager, "getProfilesFromXMLString", e.getMessage());
            Trace.error(class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager == null ? (class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager = ProfileDataManager.class$("com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ProfileDataManager")) : class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager, "getProfilesFromXMLString", "Data to process:" + xml);
            throw new ConfigMgmtException("error.invalid.profile.data", xml);
        }
        catch (ParserConfigurationException e) {
            Trace.error(class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager == null ? (class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager = ProfileDataManager.class$("com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ProfileDataManager")) : class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager, "getProfilesFromXMLString", e.getMessage());
            Trace.error(class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager == null ? (class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager = ProfileDataManager.class$("com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ProfileDataManager")) : class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager, "getProfilesFromXMLString", "Data to process:" + xml);
            throw new ConfigMgmtException("error.invalid.profile.data", xml);
        }
        catch (SAXException e) {
            Trace.error(class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager == null ? (class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager = ProfileDataManager.class$("com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ProfileDataManager")) : class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager, "getProfilesFromXMLString", e.getMessage());
            Trace.error(class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager == null ? (class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager = ProfileDataManager.class$("com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ProfileDataManager")) : class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager, "getProfilesFromXMLString", "Data to process:" + xml);
            throw new ConfigMgmtException("error.invalid.profile.data", xml);
        }
        return map;
    }

    private static Document getFactoryProfileDocument() throws ConfigMgmtException {
        String methodName = "getFactoryProfileDocument";
        Trace.methodBegin(class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager == null ? (class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager = ProfileDataManager.class$("com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ProfileDataManager")) : class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager, "getFactoryProfileDocument");
        String defaultFileName = "/opt/SUNWse6130ui/resources/profiles6130.xml";
        String fileName = null;
        fileName = Repository.getRepository().getProperty(DEFAULT_PROFILES_FILE_PROP) != null ? (String)Repository.getRepository().getProperty(DEFAULT_PROFILES_FILE_PROP) : defaultFileName;
        StringBuffer buf = new StringBuffer();
        Document preDoc = null;
        try {
            File file = null;
            FileReader fr = null;
            try {
                file = new File(fileName);
                fr = new FileReader(file);
            }
            catch (FileNotFoundException fnf) {
                Trace.error(class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager == null ? (class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager = ProfileDataManager.class$("com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ProfileDataManager")) : class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager, "getFactoryProfileDocument", "File not found:" + fileName);
                if (!defaultFileName.equals(fileName)) {
                    Trace.error(class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager == null ? (class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager = ProfileDataManager.class$("com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ProfileDataManager")) : class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager, "getFactoryProfileDocument", "Attempt to read from default location:" + defaultFileName);
                    file = new File(defaultFileName);
                    fr = new FileReader(file);
                }
                throw new ConfigMgmtException(ErrorDescriptor.ERROR_FILE_NOT_FOUND_KEY, fileName);
            }
            BufferedReader dis = new BufferedReader(fr);
            String line = null;
            while ((line = dis.readLine()) != null) {
                buf.append(line).append("\n");
            }
            preDoc = ProfileDataManager.getDocFromString(buf.toString());
        }
        catch (FileNotFoundException e) {
            Trace.error(class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager == null ? (class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager = ProfileDataManager.class$("com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ProfileDataManager")) : class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager, "getFactoryProfileDocument", (Throwable)e);
            throw new ConfigMgmtException(ErrorDescriptor.ERROR_FILE_NOT_FOUND_KEY, fileName);
        }
        catch (IOException e) {
            Trace.error(class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager == null ? (class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager = ProfileDataManager.class$("com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ProfileDataManager")) : class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager, "getFactoryProfileDocument", (Throwable)e);
            throw new ConfigMgmtException(ErrorDescriptor.ERROR_IO_KEY, fileName);
        }
        catch (FactoryConfigurationError e) {
            Trace.error(class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager == null ? (class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager = ProfileDataManager.class$("com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ProfileDataManager")) : class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager, "getFactoryProfileDocument", e.getMessage());
            throw new ConfigMgmtException(ErrorDescriptor.ERROR_FILE_NOT_FOUND_KEY, fileName);
        }
        catch (ParserConfigurationException e) {
            Trace.error(class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager == null ? (class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager = ProfileDataManager.class$("com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ProfileDataManager")) : class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager, "getFactoryProfileDocument", (Throwable)e);
            throw new ConfigMgmtException(ErrorDescriptor.ERROR_FILE_NOT_FOUND_KEY, fileName);
        }
        catch (SAXException e) {
            Trace.error(class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager == null ? (class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager = ProfileDataManager.class$("com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ProfileDataManager")) : class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ProfileDataManager, "getFactoryProfileDocument", (Throwable)e);
            throw new ConfigMgmtException(ErrorDescriptor.ERROR_FILE_NOT_FOUND_KEY, fileName);
        }
        return preDoc;
    }

    private static Document getDocFromString(String xml) throws FactoryConfigurationError, ParserConfigurationException, SAXException, IOException {
        Document preDoc = null;
        if (xml != null) {
            DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = dbfactory.newDocumentBuilder();
            preDoc = builder.parse(new InputSource(new StringReader(xml)));
        }
        return preDoc;
    }

    public static Object preprocessStoredProfiles(Object storedData) throws ConfigMgmtException {
        Map o = ProfileDataManager.getProfilesFromXMLString((String)storedData);
        return o;
    }

    public static Object preprocessProfilesToStore(Object profilesData) {
        Collection list = null;
        list = profilesData instanceof Collection ? (Collection)profilesData : ((Map)profilesData).values();
        StringBuffer sb = new StringBuffer("<");
        sb.append(TAG_TOP_LEVEL).append(">\n");
        int sz = list == null ? 0 : list.size();
        Iterator it = list.iterator();
        while (it.hasNext()) {
            sb.append(ProfileDataManager.getXMLFromProfile((Profile)it.next()));
        }
        sb.append("</").append(TAG_TOP_LEVEL).append(">\n");
        return sb.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

