/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz;

import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.impl.ObjectBundleManager;
import com.sun.netstorage.array.mgmt.cfg.core.logic.Scope;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ManageVDisks;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.Profile;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ProfileDataManager;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.VDisk;
import devmgr.versioned.symbol.VolumeCandidate;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PoolCapacityHelper {
    ConfigContext context = null;
    private Map volumeCandidatesOnNewDisksByRaid = new HashMap();
    private HashMap existingVDisksByRaid = new HashMap();

    public PoolCapacityHelper(ConfigContext context, String arrayScope) throws ConfigMgmtException {
        this.context = context;
        this.loadVDisksByRAID(arrayScope);
        this.loadNewVolumeCandidates(arrayScope);
    }

    private void loadVDisksByRAID(String arrayScope) throws ConfigMgmtException {
        String METHOD = "loadVDisksByRAID";
        Trace.methodBegin(this, "loadVDisksByRAID");
        ManageVDisks mgr = new ManageVDisks();
        Scope scope = new Scope();
        scope.setAttribute("array", arrayScope);
        mgr.init(this.context, scope, null);
        List vDisksList = mgr.getItemList();
        int vDisksSize = vDisksList == null ? 0 : vDisksList.size();
        Trace.verbose((Object)this, "loadVDisksByRAID", "Number of vDisks to examine for array(" + arrayScope + ") is: " + vDisksSize);
        Iterator iter = vDisksList.iterator();
        while (iter.hasNext()) {
            VDisk vDisk = (VDisk)iter.next();
            if (vDisk.getVDiskDiskStatus() != 1) continue;
            Integer raidLevel = new Integer(vDisk.getRaidLevel());
            ArrayList<VDisk> l = (ArrayList<VDisk>)this.existingVDisksByRaid.get(raidLevel);
            if (l == null) {
                l = new ArrayList<VDisk>();
                l.add(vDisk);
                this.existingVDisksByRaid.put(raidLevel, l);
                continue;
            }
            l.add(vDisk);
        }
    }

    private void loadNewVolumeCandidates(String arrayScope) throws ConfigMgmtException {
        String METHOD = "loadNewVolumeCandidates";
        Trace.methodBegin(this, "loadNewVolumeCandidates");
        this.volumeCandidatesOnNewDisksByRaid = ObjectBundleManager.getInstance().getAllVolumeCandidatesByRaid(arrayScope);
    }

    public PoolCapacityData getCapacities(Profile prof) {
        BigInteger maxNewVolumeSize = BigInteger.ZERO;
        BigInteger availCap = BigInteger.ZERO;
        List vDisks = (List)this.existingVDisksByRaid.get(new Integer(prof.getRaidLevel()));
        if (vDisks != null) {
            Iterator iter = vDisks.iterator();
            while (iter.hasNext()) {
                VDisk vd = (VDisk)iter.next();
                if (!this.meetsSettings(prof.getDriveType(), vd.getTypeOfDisks(), prof.getNumberOfDisks(), vd.getNumberOfDisks())) continue;
                BigInteger newCap = vd.getTotalCapacity().subtract(vd.getConfiguredCapacity());
                availCap = availCap.add(newCap);
                BigInteger maxSize = vd.getMaxVolumeSize();
                if (maxSize == null) continue;
                maxNewVolumeSize = maxNewVolumeSize.max(maxSize);
            }
        }
        List vCands = (List)this.volumeCandidatesOnNewDisksByRaid.get(new Integer(prof.getRaidLevel()));
        BigInteger bigGuy = BigInteger.ZERO;
        if (vCands != null) {
            Iterator iter = vCands.iterator();
            while (iter.hasNext()) {
                VolumeCandidate cand = (VolumeCandidate)iter.next();
                if (!this.meetsSettings(prof.getDriveType(), cand.getPhyDriveType().getValue(), prof.getNumberOfDisks(), cand.getDriveCount())) continue;
                BigInteger newSize = new BigInteger("" + cand.getUsableSize());
                maxNewVolumeSize = maxNewVolumeSize.max(newSize);
                bigGuy = bigGuy.max(newSize);
            }
        }
        availCap = availCap.add(bigGuy);
        return new PoolCapacityData(maxNewVolumeSize, availCap);
    }

    private boolean meetsSettings(int profileDiskType, int firmwareDiskType, int profileNumDisks, int vDiskNumDisks) {
        return !(profileDiskType != 0 && profileDiskType != ProfileDataManager.convert6130DriveTypeToProfileDriveType(firmwareDiskType) || profileNumDisks != 0 && profileNumDisks != vDiskNumDisks);
    }

    class PoolCapacityData {
        BigInteger maximumVolumeSize;
        BigInteger availableCapacity;

        PoolCapacityData(BigInteger maximumVolumeSize, BigInteger availableCapacity) {
            this.maximumVolumeSize = maximumVolumeSize;
            this.availableCapacity = availableCapacity;
        }

        public BigInteger getMaximumVolumeSize() {
            return this.maximumVolumeSize;
        }

        public BigInteger getAvailableCapacity() {
            return this.availableCapacity;
        }
    }
}

