/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz;

import com.sun.netstorage.array.mgmt.cfg.core.ErrorCode;
import com.sun.netstorage.array.mgmt.cfg.core.impl.CoreManagedObject;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.PerfStatsDataInterface;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

abstract class PerfData
extends CoreManagedObject
implements PerfStatsDataInterface,
Cloneable {
    public static final int ONE_KILOBYTE = 1024;
    public static final long ONE_MEGABYTE = 0x100000L;
    protected double averageReadSize = 0.0;
    protected double averageWriteSize = 0.0;
    protected double averageBytesReadPerSec = 0.0;
    protected double averageBytesWrittenPerSec = 0.0;
    protected double averageTotalIOPs = 0.0;
    private double totalIOPs = 0.0;
    private double peakTotalIOPs = 0.0;
    protected double readPercentage = 0.0;
    protected double writePercentage = 0.0;
    protected double cacheReadHitPercentage = 0.0;
    protected double totalDataTransferredPerSecond = 0.0;
    private double bytesReadPerSecond = 0.0;
    private double peakBytesReadPerSecond = 0.0;
    private double bytesWrittenPerSecond = 0.0;
    private double peakBytesWrittenPerSecond = 0.0;
    private ArrayList errorCodes = new ArrayList();
    protected static final double NOT_AVAILABLE = -1.0;

    public PerfData(String objectName, Map keyMap) {
        this.setName(objectName);
        this.setKey(keyMap);
    }

    public Double getAverageReadSize() {
        return new Double(this.averageReadSize);
    }

    public void setAverageReadSize(double averageReadSize) {
        this.averageReadSize = averageReadSize;
    }

    public Double getRunAverageReadsPerSec() {
        return new Double(this.averageBytesReadPerSec);
    }

    public void setRunAverageReadsPerSec(double averageBytesReadPerSec) {
        this.averageBytesReadPerSec = averageBytesReadPerSec;
    }

    public Double getRunAverageTotalIOPs() {
        return new Double(this.averageTotalIOPs);
    }

    public void setRunAverageTotalIOPs(double averageTotalIOPs) {
        this.averageTotalIOPs = averageTotalIOPs;
    }

    public Double getAverageWriteSize() {
        return new Double(this.averageWriteSize);
    }

    public void setAverageWriteSize(double averageWriteSize) {
        this.averageWriteSize = averageWriteSize;
    }

    public Double getRunAverageWritesPerSec() {
        return new Double(this.averageBytesWrittenPerSec);
    }

    public void setRunAverageWritesPerSec(double averageBytesWrittenPerSec) {
        this.averageBytesWrittenPerSec = averageBytesWrittenPerSec;
    }

    public Double getCacheReadHitPercentage() {
        return new Double(this.cacheReadHitPercentage);
    }

    public void setCacheReadHitPercentage(double cacheReadHitPercentage) {
        this.cacheReadHitPercentage = cacheReadHitPercentage;
    }

    public Double getCacheWriteHitPercentage() {
        return null;
    }

    public Double getPeakValueReadsPerSec() {
        return new Double(this.peakBytesReadPerSecond);
    }

    public Double getPeakValueTotalIOPs() {
        return new Double(this.peakTotalIOPs);
    }

    public Double getPeakValueWritesPerSec() {
        return new Double(this.peakBytesWrittenPerSecond);
    }

    public Long getQDepth() {
        return null;
    }

    public Double getReadPercentage() {
        return new Double(this.readPercentage);
    }

    public void setReadPercentage(double readPercentage) {
        this.readPercentage = readPercentage;
    }

    public Double getReadsPerSec() {
        return new Double(this.bytesReadPerSecond);
    }

    protected void setReadsPerSec(double bytesReadPerSecond) {
        this.bytesReadPerSecond = bytesReadPerSecond;
        if (bytesReadPerSecond > this.peakBytesReadPerSecond) {
            this.peakBytesReadPerSecond = bytesReadPerSecond;
        }
    }

    public Double getResponseTime() {
        return null;
    }

    public Double getTotalDataTransPerSec() {
        if (this.bytesReadPerSecond == -1.0 || this.bytesWrittenPerSecond == -1.0) {
            return new Double(-1.0);
        }
        return new Double(this.bytesReadPerSecond + this.bytesWrittenPerSecond);
    }

    public Double getTotalIOPs() {
        return new Double(this.totalIOPs);
    }

    protected void setTotalIOPs(double totalIOPs) {
        this.totalIOPs = totalIOPs;
        if (totalIOPs > this.peakTotalIOPs) {
            this.peakTotalIOPs = totalIOPs;
        }
    }

    public Double getWritePercentage() {
        return new Double(this.writePercentage);
    }

    public void setWritePercentage(double writePercentage) {
        this.writePercentage = writePercentage;
    }

    public Double getWritesPerSec() {
        return new Double(this.bytesWrittenPerSecond);
    }

    protected void setWritesPerSec(double bytesWrittenPerSecond) {
        this.bytesWrittenPerSecond = bytesWrittenPerSecond;
        if (bytesWrittenPerSecond > this.peakBytesWrittenPerSecond) {
            this.peakBytesWrittenPerSecond = bytesWrittenPerSecond;
        }
    }

    protected void markDataAsNotAvailable() {
        this.averageBytesReadPerSec = -1.0;
        this.averageBytesWrittenPerSec = -1.0;
        this.averageTotalIOPs = -1.0;
        this.averageReadSize = -1.0;
        this.averageWriteSize = -1.0;
        this.totalIOPs = -1.0;
        this.readPercentage = -1.0;
        this.writePercentage = -1.0;
        this.cacheReadHitPercentage = -1.0;
        this.totalDataTransferredPerSecond = -1.0;
        this.bytesReadPerSecond = -1.0;
        this.bytesWrittenPerSecond = -1.0;
    }

    protected void addErrorCode(ErrorCode errorCode) {
        if (this.errorCodes == null) {
            this.errorCodes = new ArrayList();
        } else if (this.errorCodes.contains(errorCode)) {
            return;
        }
        this.errorCodes.add(errorCode);
    }

    protected void addErrorCodes(ErrorCode[] errorCodes) {
        for (int i = 0; i < errorCodes.length; ++i) {
            this.addErrorCode(errorCodes[i]);
        }
    }

    protected void addErrorCodes(List errorCodes) {
        if (errorCodes != null) {
            this.addErrorCodes(errorCodes.toArray(new ErrorCode[errorCodes.size()]));
        }
    }

    protected void clearAllErrors() {
        this.errorCodes = null;
    }

    public List getPerfStatsErrorCodes() {
        if (this.errorCodes == null) {
            return new ArrayList();
        }
        return this.errorCodes;
    }

    protected String getErrorCodeStr() {
        StringBuffer buf = new StringBuffer();
        if (this.errorCodes == null) {
            return "";
        }
        ErrorCode[] errors = this.errorCodes.toArray(new ErrorCode[this.errorCodes.size()]);
        for (int i = 0; i < errors.length; ++i) {
            buf.append(errors[i].toString());
            buf.append("\n");
        }
        if (buf.length() > 0) {
            buf.deleteCharAt(buf.length() - 1);
        }
        return buf.toString();
    }

    public void clear() {
        this.clearAllErrors();
        this.averageReadSize = 0.0;
        this.averageWriteSize = 0.0;
        this.averageBytesReadPerSec = 0.0;
        this.averageBytesWrittenPerSec = 0.0;
        this.averageTotalIOPs = 0.0;
        this.totalIOPs = 0.0;
        this.peakTotalIOPs = 0.0;
        this.readPercentage = 0.0;
        this.writePercentage = 0.0;
        this.cacheReadHitPercentage = 0.0;
        this.totalDataTransferredPerSecond = 0.0;
        this.bytesReadPerSecond = 0.0;
        this.peakBytesReadPerSecond = 0.0;
        this.bytesWrittenPerSecond = 0.0;
        this.peakBytesWrittenPerSecond = 0.0;
    }

    private String printHelper(Double result, DecimalFormat formatter) {
        if (result == null || result == -1.0) {
            return "N/A";
        }
        return formatter.format(result);
    }

    private Double getInKBytes(Double result) {
        if (result == null) {
            return new Double(0.0);
        }
        double value = result;
        if (value == 0.0 || value == -1.0) {
            return result;
        }
        return new Double(value / 1024.0);
    }

    String getStatsStr(String seperator, boolean vertical) {
        DecimalFormat formatter = new DecimalFormat("0.00");
        StringBuffer buf = new StringBuffer();
        if (vertical) {
            buf.append("Name =");
            buf.append(this.getName());
            buf.append(seperator);
            buf.append("IOPs                   = ");
            buf.append(this.printHelper(this.getTotalIOPs(), formatter));
            buf.append(seperator);
            buf.append("Run Average IOPs       = ");
            buf.append(this.printHelper(this.getRunAverageTotalIOPs(), formatter));
            buf.append(seperator);
            buf.append("Peak IOPs              = ");
            buf.append(this.printHelper(this.getPeakValueTotalIOPs(), formatter));
            buf.append(seperator);
            buf.append("Read %                 = ");
            buf.append(this.printHelper(this.getReadPercentage(), formatter));
            buf.append(seperator);
            buf.append("Write %                = ");
            buf.append(this.printHelper(this.getWritePercentage(), formatter));
            buf.append(seperator);
            buf.append("Cache Read Hit %       = ");
            buf.append(this.printHelper(this.getCacheReadHitPercentage(), formatter));
            buf.append(seperator);
            buf.append("Data Trans (KB/sec)    = ");
            buf.append(this.printHelper(this.getInKBytes(this.getTotalDataTransPerSec()), formatter));
            buf.append(seperator);
            buf.append("KB/sec Read            = ");
            buf.append(this.printHelper(this.getInKBytes(this.getReadsPerSec()), formatter));
            buf.append(seperator);
            buf.append("Run Aver KB/sec Read   = ");
            buf.append(this.printHelper(this.getInKBytes(this.getRunAverageReadsPerSec()), formatter));
            buf.append(seperator);
            buf.append("Peak KB/sec Read       = ");
            buf.append(this.printHelper(this.getInKBytes(this.getPeakValueReadsPerSec()), formatter));
            buf.append(seperator);
            buf.append("KB/sec Written         = ");
            buf.append(this.printHelper(this.getInKBytes(this.getWritesPerSec()), formatter));
            buf.append(seperator);
            buf.append("Run Aver KB/sec Written= ");
            buf.append(this.printHelper(this.getInKBytes(this.getRunAverageWritesPerSec()), formatter));
            buf.append(seperator);
            buf.append("Peak KB/sec Written    = ");
            buf.append(this.printHelper(this.getInKBytes(this.getPeakValueWritesPerSec()), formatter));
            buf.append(seperator);
            buf.append("Average Read Size (Bytes)  = ");
            buf.append(this.printHelper(this.getAverageReadSize(), formatter));
            buf.append(seperator);
            buf.append("Average Write Size (Bytes) = ");
            buf.append(this.printHelper(this.getAverageWriteSize(), formatter));
            buf.append(seperator);
        } else {
            String COLUMN_SEPERATOR = " ";
            buf.append(this.printHelper(this.getTotalIOPs(), formatter));
            buf.append(" ");
            buf.append(this.printHelper(this.getRunAverageTotalIOPs(), formatter));
            buf.append(" ");
            buf.append(this.printHelper(this.getPeakValueTotalIOPs(), formatter));
            buf.append(" ");
            buf.append(this.printHelper(this.getReadPercentage(), formatter));
            buf.append(" ");
            buf.append(this.printHelper(this.getWritePercentage(), formatter));
            buf.append(" ");
            buf.append(this.printHelper(this.getCacheReadHitPercentage(), formatter));
            buf.append(" ");
            buf.append(this.printHelper(this.getInKBytes(this.getTotalDataTransPerSec()), formatter));
            buf.append(" ");
            buf.append(this.printHelper(this.getInKBytes(this.getReadsPerSec()), formatter));
            buf.append(" ");
            buf.append(this.printHelper(this.getInKBytes(this.getRunAverageReadsPerSec()), formatter));
            buf.append(" ");
            buf.append(this.printHelper(this.getInKBytes(this.getPeakValueReadsPerSec()), formatter));
            buf.append(" ");
            buf.append(this.printHelper(this.getInKBytes(this.getWritesPerSec()), formatter));
            buf.append(" ");
            buf.append(this.printHelper(this.getInKBytes(this.getRunAverageWritesPerSec()), formatter));
            buf.append(" ");
            buf.append(this.printHelper(this.getInKBytes(this.getPeakValueWritesPerSec()), formatter));
            buf.append(" ");
            buf.append(this.printHelper(this.getAverageReadSize(), formatter));
            buf.append(" ");
            buf.append(this.printHelper(this.getAverageWriteSize(), formatter));
            buf.append(" ");
        }
        return buf.toString();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("[ ");
        buf.append("Key =");
        buf.append(this.getKeyAsString());
        buf.append(", (");
        buf.append(this.getStatsStr(", ", true));
        buf.append(") ]");
        return buf.toString();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cns) {
            throw new AssertionError((Object)"Assertion failure");
        }
    }
}

