/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz;

import com.sun.netstorage.array.mgmt.cfg.access.business.ManageMappingsFactory;
import com.sun.netstorage.array.mgmt.cfg.access.business.ManageMappingsInterface;
import com.sun.netstorage.array.mgmt.cfg.access.business.impl.oz.ManageMappings;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Constants;
import com.sun.netstorage.array.mgmt.cfg.core.ErrorCode;
import com.sun.netstorage.array.mgmt.cfg.core.ErrorDescriptor;
import com.sun.netstorage.array.mgmt.cfg.core.ManagerInterface;
import com.sun.netstorage.array.mgmt.cfg.core.MethodCallStatus;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.SEItemNotFoundException;
import com.sun.netstorage.array.mgmt.cfg.core.impl.ObjectBundleManager;
import com.sun.netstorage.array.mgmt.cfg.core.impl.oz.CommandProcessor;
import com.sun.netstorage.array.mgmt.cfg.core.impl.oz.OZErrorCode;
import com.sun.netstorage.array.mgmt.cfg.core.impl.oz.VolumeCandidateFetcher;
import com.sun.netstorage.array.mgmt.cfg.core.logic.Scope;
import com.sun.netstorage.array.mgmt.cfg.core.logic.SearchFilter;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.ManageDataServicesFactory;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.ManageSnapShotServicesInterface;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.impl.oz.ManageReplicationServices;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageVolumesInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ManageArrays;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ManagePools;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ManageProfiles;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ManageVDisks;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.Pool;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.PoolData;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.PoolDataManager;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.Profile;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ProfileDataManager;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.SnapShotVolume;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.VDisk;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.Volume;
import com.sun.netstorage.array.mgmt.cfg.util.Convert;
import com.sun.netstorage.array.mgmt.logger.LogAPI;
import devmgr.versioned.jrpc.RPCError;
import devmgr.versioned.jrpc.XDRType;
import devmgr.versioned.symbol.AbstractVolRef;
import devmgr.versioned.symbol.CandidateSelectionType;
import devmgr.versioned.symbol.CandidateSelectionTypeData;
import devmgr.versioned.symbol.Controller;
import devmgr.versioned.symbol.ControllerRef;
import devmgr.versioned.symbol.Drive;
import devmgr.versioned.symbol.DriveRef;
import devmgr.versioned.symbol.DriveRefList;
import devmgr.versioned.symbol.FreeExtent;
import devmgr.versioned.symbol.GhostVolume;
import devmgr.versioned.symbol.HLVolumeBundle;
import devmgr.versioned.symbol.LUNMapping;
import devmgr.versioned.symbol.LegacyVolRef;
import devmgr.versioned.symbol.MetadataVolume;
import devmgr.versioned.symbol.MirrorCandidateDescriptor;
import devmgr.versioned.symbol.MirrorProxyVolume;
import devmgr.versioned.symbol.MirrorVolumeCandidate;
import devmgr.versioned.symbol.MirrorVolumeCandidateList;
import devmgr.versioned.symbol.ObjectBundle;
import devmgr.versioned.symbol.ReturnCode;
import devmgr.versioned.symbol.SnapshotVolume;
import devmgr.versioned.symbol.StorageArray;
import devmgr.versioned.symbol.UnicodeTranslator;
import devmgr.versioned.symbol.UserAssignedLabel;
import devmgr.versioned.symbol.VolumeAttributeUpdateDescriptor;
import devmgr.versioned.symbol.VolumeCache;
import devmgr.versioned.symbol.VolumeCacheParamsUpdateDescriptor;
import devmgr.versioned.symbol.VolumeCandidate;
import devmgr.versioned.symbol.VolumeCopy;
import devmgr.versioned.symbol.VolumeCreationDescriptor;
import devmgr.versioned.symbol.VolumeExpansionDescriptor;
import devmgr.versioned.symbol.VolumeGroup;
import devmgr.versioned.symbol.VolumeLabelUpdateDescriptor;
import devmgr.versioned.symbol.VolumeMediaScanParams;
import devmgr.versioned.symbol.VolumeMediaScanParamsUpdateDescriptor;
import devmgr.versioned.symbol.VolumeOwnershipUpdateDescriptor;
import devmgr.versioned.symbol.VolumeParamsUpdateDescriptor;
import devmgr.versioned.symbol.VolumeRef;
import devmgr.versioned.symbol.VolumeSegmentSizingDescriptor;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class ManageVolumes
implements ManageVolumesInterface,
Constants.OZMethodCallStatusReturnCodes,
Constants.StorageSize,
Constants.OZVolume {
    private ConfigContext context;
    private SearchFilter filter;
    private Scope scope;
    private static final int AUTOMATIC_MODE = 0;
    private static final int MANUAL_MODE = 1;
    private static final int CREATE_MODE = 2;
    public static final int READ_AHEAD_ON = 3;
    public static final int READ_AHEAD_OFF = 0;
    public static final String INCLUDE_METADATA_VOLUMES = "INCLUDE_METADATA_VOLUMES";
    public static final String ONLY_METADATA_VOLUMES = "ONLY_METADATA_VOLUMES";
    static /* synthetic */ Class class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ManageVolumes;

    public void create(Properties props) throws ConfigMgmtException {
        String METHOD_NAME = "create";
        Trace.methodBegin(this, "create");
        String volumeName = null;
        long volumeSize = -1L;
        int creationMode = 0;
        int numberOfDisks = -1;
        String vdiskRef = null;
        DriveRefList driveRefList = null;
        int readAhead = -1;
        int segmentSize = -1;
        int raidLevel = -1;
        int profileNumberOfDisks = -1;
        int profileDiskType = -1;
        PoolData pool = null;
        devmgr.versioned.symbol.Volume volume = null;
        String arrayWwn = this.getArrayWwnFromScope();
        if (props == null || props.isEmpty()) {
            throw new ConfigMgmtException("incorrect.method.parameter", "Properties passed empty.");
        }
        ManageVolumes.validateAdditionalCreationProps(props);
        volumeName = props.getProperty("volumeName");
        if (volumeName == null) {
            throw new ConfigMgmtException("incorrect.method.parameter", "Volume name property not populated.");
        }
        String poolKeyString = props.getProperty("poolKey");
        String poolId = null;
        if (poolKeyString != null) {
            PoolDataManager pooldm = new PoolDataManager(arrayWwn);
            poolId = (String)Convert.keyAsStringToMap(poolKeyString).get("id");
            pool = pooldm.getPoolData(poolId);
            if (pool == null) {
                LogAPI.staticLog((String)"VOLUME_CREATE_ERROR", (String[])new String[]{arrayWwn, volumeName}, (String[])new String[0]);
                throw new ConfigMgmtException("incorrect.method.parameter", "Could not look up the pool with the key passed.");
            }
        } else {
            LogAPI.staticLog((String)"VOLUME_CREATE_ERROR", (String[])new String[]{arrayWwn, volumeName}, (String[])new String[0]);
            throw new ConfigMgmtException("incorrect.method.parameter", "Pool key property not populated.");
        }
        ProfileDataManager pdm = new ProfileDataManager(arrayWwn);
        Profile profile = pdm.getProfile(pool.profileId);
        readAhead = profile.isReadAheadEnabled() ? 3 : 0;
        segmentSize = ManageVolumes.convertSegmentSize(profile.getSegmentSize());
        raidLevel = profile.getRaidLevel();
        profileDiskType = ProfileDataManager.convertProfileDriveTypeTo6130DriveType(profile.getDriveType());
        numberOfDisks = profileNumberOfDisks = profile.getNumberOfDisks();
        ObjectBundle bundle = ObjectBundleManager.getInstance().getObjectBundle(arrayWwn);
        this.validateSegmentSize(bundle.getSa(), segmentSize);
        volumeSize = this.extractVolumeSizeFromProps(props, "volumeSize");
        if (volumeSize == -1L) {
            LogAPI.staticLog((String)"VOLUME_CREATE_ERROR", (String[])new String[]{arrayWwn, volumeName}, (String[])new String[0]);
            throw new ConfigMgmtException("incorrect.method.parameter", "Size property not populated.");
        }
        if (props.getProperty("vdiskKey") != null) {
            String vdiskKeyAsString = props.getProperty("vdiskKey");
            ManageVDisks vdiskManager = new ManageVDisks();
            SearchFilter vdiskKeyFilter = new SearchFilter("keyAsString", vdiskKeyAsString);
            vdiskManager.init(this.context, this.scope, vdiskKeyFilter);
            List vdisks = vdiskManager.getItemList();
            if (vdisks.size() != 1) {
                LogAPI.staticLog((String)"VOLUME_CREATE_ERROR", (String[])new String[]{arrayWwn, volumeName}, (String[])new String[0]);
                Trace.verbose((Object)this, "create", "Unable to find vdisk with key " + vdiskKeyAsString);
                throw new SEItemNotFoundException(vdiskKeyAsString);
            }
            VDisk vdisk = (VDisk)vdisks.get(0);
            ManageVolumes.validateNumberOfDisks(profileNumberOfDisks, vdisk.getNumberOfDisks());
            ManageVolumes.validateDiskType(profileDiskType, vdisk.getTypeOfDisks());
            ManageVolumes.validateRaidLevel(raidLevel, vdisk.getRaidLevel());
            if (vdisk.getNumberOfVolumes() >= bundle.getSa().getFeatureParameters().getMaxVolumesPerGroup()) {
                throw new ConfigMgmtException("error.vdisk.exceeded.volume.max", "Maximum number of volumes already created on vdisk " + vdisk.getName());
            }
            if (vdisk.getVDiskDiskStatus() != 1) {
                throw new ConfigMgmtException("error.vdisk.disk.status.not.optimal", new String[]{vdisk.getName()}, "One or more disks on a vdisk " + vdisk.getName() + " do not have an optimal status.", null);
            }
            creationMode = 1;
            vdiskRef = Convert.extractRefFromProps(props, "vdiskKey", "vdiskRef");
        } else if (props.getProperty("numberOfDisks") != null) {
            String numberOfDisksString = props.getProperty("numberOfDisks");
            creationMode = 2;
            try {
                numberOfDisks = Integer.parseInt(numberOfDisksString);
                ManageVolumes.validateNumberOfDisks(profileNumberOfDisks, numberOfDisks);
            }
            catch (NumberFormatException nfe) {
                LogAPI.staticLog((String)"VOLUME_CREATE_ERROR", (String[])new String[]{arrayWwn, volumeName}, (String[])new String[0]);
                throw new ConfigMgmtException("incorrect.method.parameter", "Number of disks property not in expected format.");
            }
        } else if (props.getProperty("listOfDiskKeys") != null) {
            creationMode = 2;
            String listOfDiskKeys = props.getProperty("listOfDiskKeys");
            String[] diskKeysAsStrings = Convert.commaStringToArray(listOfDiskKeys);
            driveRefList = ManageVolumes.createDriveRefList(diskKeysAsStrings, profileNumberOfDisks, profileDiskType, bundle.getDrive());
        }
        if (Trace.isTraceEnabled(this)) {
            Trace.verbose((Object)this, "create", "About to create volume with: \n creation mode = " + creationMode + "\n arrayId = " + arrayWwn + "\n driveRefList = " + driveRefList + "\n numberOfDisks = " + numberOfDisks + "\n vdiskRef = " + vdiskRef + "\n raidLevel = " + raidLevel + "\n volumeSize = " + volumeSize + "\n volumeName = " + volumeName + "\n segmentSize = " + segmentSize + "\n readAhead = " + readAhead);
        }
        boolean isInDefaultGroup = this.createVolume(creationMode, arrayWwn, driveRefList, numberOfDisks, vdiskRef, raidLevel, volumeSize, volumeName, segmentSize, readAhead, profileDiskType);
        Trace.verbose((Object)this, "create", "Came back from volume creation.");
        LogAPI.staticLog((String)"VOLUME_CREATE_SUCCESS", (String[])new String[]{arrayWwn, volumeName}, (String[])new String[0]);
        volume = null;
        int retryCounter = 20;
        CommandProcessor cmd = null;
        try {
            cmd = new CommandProcessor(arrayWwn);
        }
        catch (Exception e) {
            throw new ConfigMgmtException("error.communicating", "Error communicating with array");
        }
        while (retryCounter > 0) {
            --retryCounter;
            cmd.execute(40, null, (XDRType)bundle, false);
            if (bundle == null || bundle.getVolume() == null) continue;
            volume = this.getVolumeForName(bundle.getVolume(), volumeName);
            if (volume != null) break;
            Trace.verbose((Object)this, "create", "Volume is still not visible, wait a little and retry");
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException e1) {
                // empty catch block
            }
            Trace.verbose((Object)this, "create", "Retry count:" + retryCounter);
        }
        if (volume == null) {
            Trace.error((Object)this, "create", "Newly created volume cannot be retrieved....");
            throw new ConfigMgmtException("volume.lookup.error", "Unable to lookup volume with name = " + volumeName);
        }
        if (poolId != null) {
            Trace.verbose((Object)this, "create", "Update volume pool");
            this.updateVolumePool(volume, arrayWwn, poolId);
        } else {
            Trace.error((Object)this, "create", "No pool for volume ?");
        }
        if (isInDefaultGroup) {
            Map key = ManageVolumes.getVolumeKeyMap(arrayWwn, Convert.bytesToStringRaw(volume.getVolumeRef().getRefToken()), UnicodeTranslator.getString((byte[])volume.getLabel().getValue()), Convert.bytesToString(volume.getWorldWideName()));
            ArrayList<Map> mappingsToDelete = new ArrayList<Map>();
            mappingsToDelete.add(key);
            Trace.verbose((Object)this, "create", "Deleting the default mapping.");
            ManageMappings mappingManager = new ManageMappings();
            mappingManager.init(this.context, this.scope, null);
            mappingManager.delete(mappingsToDelete);
        }
    }

    static void validateAdditionalCreationProps(Properties props) throws ConfigMgmtException {
        if (props.getProperty("vdiskKey") != null && props.getProperty("numberOfDisks") != null && props.getProperty("listOfDiskKeys") != null || props.getProperty("vdiskKey") != null && props.getProperty("numberOfDisks") != null || props.getProperty("numberOfDisks") != null && props.getProperty("listOfDiskKeys") != null || props.getProperty("vdiskKey") != null && props.getProperty("listOfDiskKeys") != null) {
            throw new ConfigMgmtException("incorrect.method.parameter", "Too many creation properties set.");
        }
    }

    private long extractVolumeSizeFromProps(Properties props, String propertyName) throws ConfigMgmtException {
        long sizeInBytes = -1L;
        Object propertyValue = props.get(propertyName);
        if (propertyValue != null) {
            if (propertyValue instanceof String) {
                sizeInBytes = Convert.sizeStringToSizeInBytes((String)propertyValue);
            } else if (propertyValue instanceof BigInteger) {
                sizeInBytes = ((BigInteger)propertyValue).longValue();
            }
        }
        return sizeInBytes;
    }

    static int convertSegmentSize(int profileSegmentSize) throws ConfigMgmtException {
        switch (profileSegmentSize) {
            case 0: {
                return 4096;
            }
            case 1: {
                return 8192;
            }
            case 2: {
                return 16384;
            }
            case 3: {
                return 32768;
            }
            case 4: {
                return 65536;
            }
            case 5: {
                return 131072;
            }
            case 6: {
                return 262144;
            }
            case 7: {
                return 524288;
            }
        }
        throw new ConfigMgmtException("incorrect.method.parameter", profileSegmentSize + " is not valid profile segment size value.");
    }

    static DriveRefList createDriveRefList(String[] diskKeysAsStrings, int profileNumberOfDisks, int profileDiskType, Drive[] drives) throws ConfigMgmtException {
        int i;
        Map map = null;
        Drive drive = null;
        String driveRefString = null;
        int firstDriveType = -1;
        int diskCount = diskKeysAsStrings != null ? diskKeysAsStrings.length : 0;
        DriveRef[] driveRefs = new DriveRef[diskCount];
        ManageVolumes.validateNumberOfDisks(profileNumberOfDisks, diskCount);
        HashMap<String, Drive> driveMap = new HashMap<String, Drive>();
        int length = drives != null ? drives.length : 0;
        for (i = 0; i < length; ++i) {
            driveMap.put(Convert.bytesToStringRaw(drives[i].getDriveRef().getRefToken()), drives[i]);
        }
        for (i = 0; i < diskCount; ++i) {
            map = Convert.keyAsStringToMap(diskKeysAsStrings[i]);
            driveRefString = (String)map.get("diskRef");
            drive = (Drive)driveMap.get(driveRefString);
            if (drive != null) {
                if (firstDriveType == -1) {
                    firstDriveType = drive.getPhyDriveType().getValue();
                } else if (firstDriveType != drive.getPhyDriveType().getValue()) {
                    throw new ConfigMgmtException("volume.create.error.invalid.disk.type", "List of disks passed contains different types of disks.");
                }
                ManageVolumes.validateDiskType(profileDiskType, drive.getPhyDriveType().getValue());
                if (drive.getHotSpare() || !"00:00:00:00:00:00:00:00:00:00:00:00:00:00:00:00:00:00:00:00".equals(Convert.bytesToString(drive.getCurrentVolumeGroupRef().getRefToken()))) {
                    throw new ConfigMgmtException("volume.create.error.invalid.disk.role", "List of disks passed contains disk that is in use.");
                }
                if (drive.getOffline()) {
                    throw new ConfigMgmtException("volume.create.error.invalid.disk.state", "List of disks passed contains disk that is offline.");
                }
                if (drive.getStatus().getValue() != 1) {
                    throw new ConfigMgmtException("volume.create.error.invalid.disk.status", "List of disks passed contains disk that is not with optimal status.");
                }
            } else {
                throw new ConfigMgmtException("incorrect.method.parameter", "Disk key passed not valid.");
            }
            driveRefs[i] = drive.getDriveRef();
        }
        DriveRefList driveRefList = new DriveRefList();
        driveRefList.setDriveRef(driveRefs);
        return driveRefList;
    }

    static void validateNumberOfDisks(int profileNumberOfDisks, int vdiskNumberOfDisks) throws ConfigMgmtException {
        if (profileNumberOfDisks != 0 && profileNumberOfDisks != vdiskNumberOfDisks) {
            throw new ConfigMgmtException(ErrorCode.ERROR_CREATE_VOLUME_INVALID_NUM_DISKS.getKey(), "Profile number of disks not compatible with vdisk number of disks.");
        }
    }

    static void validateDiskType(int profileDiskType, int vdiskDiskType) throws ConfigMgmtException {
        if (profileDiskType != 0 && profileDiskType != vdiskDiskType) {
            throw new ConfigMgmtException(ErrorCode.ERROR_CREATE_VOLUME_INVALID_DISK_TYPE.getKey(), "Profile disk type not compatible with vdisk disk type.");
        }
    }

    static void validateRaidLevel(int profileRaidLevel, int vdiskRaidLevel) throws ConfigMgmtException {
        if (profileRaidLevel != vdiskRaidLevel) {
            throw new ConfigMgmtException(ErrorCode.ERROR_CREATE_VOLUME_INVALID_RAID_LEVEL.getKey(), "Profile RAID level not compatible with vdisk RAID level.");
        }
    }

    private void validateSegmentSize(StorageArray ozArray, int volumeSegmentSize) throws ConfigMgmtException {
        if (ozArray.getCache().getCacheBlkSize() > volumeSegmentSize) {
            throw new ConfigMgmtException(ErrorCode.ERROR_VOLUME_INVALID_SEGMENT_SIZE.getKey(), "Segment size can not be smaller than array cache block size.");
        }
    }

    private boolean createVolume(int creationMode, String arrayWwn, DriveRefList driveRefs, int numberOfDrives, String vdiskRef, int volumeRaidLevel, long volumeSize, String volumeName, int volumeSegmentSize, int volumeReadAhead, int driveType) throws ConfigMgmtException {
        int codeValue;
        String METHOD_NAME = "createVolume";
        Trace.methodBegin(this, "createVolume");
        int selectionType = -1;
        CandidateSelectionTypeData selection = null;
        VolumeCandidate[] candidates = null;
        VolumeCandidate candidate = null;
        VolumeCreationDescriptor descriptor = null;
        Object controller = null;
        FreeExtent[] freeExtents = null;
        ObjectBundleManager manager = ObjectBundleManager.getInstance();
        selectionType = ManageVolumes.pickSelectionType(creationMode, driveRefs, numberOfDrives);
        selection = new CandidateSelectionTypeData();
        selection.setCandidateSelectionType(new CandidateSelectionType(selectionType));
        if (selectionType == 2) {
            selection.setDriveRefList(driveRefs);
        }
        ObjectBundle bundle = manager.getObjectBundle(arrayWwn);
        freeExtents = bundle.getFreeExtent();
        CommandProcessor command = ManageVolumes.getCommandProcessor(arrayWwn);
        try {
            candidates = this.getVolumeCandidates(selection, volumeRaidLevel, arrayWwn, driveType, command);
            candidate = this.pickVolumeCandidate(creationMode, candidates, volumeSize, driveRefs, numberOfDrives, vdiskRef, freeExtents, driveType, volumeRaidLevel);
        }
        catch (ConfigMgmtException cme) {
            if (creationMode == 0) {
                creationMode = 2;
                selection = new CandidateSelectionTypeData();
                selection.setCandidateSelectionType(new CandidateSelectionType(3));
                candidates = this.getVolumeCandidates(selection, volumeRaidLevel, arrayWwn, driveType, command);
                candidate = this.pickVolumeCandidate(creationMode, candidates, volumeSize, driveRefs, numberOfDrives, vdiskRef, freeExtents, driveType, volumeRaidLevel);
            }
            throw cme;
        }
        String controllerRefString = this.getPreferedController(manager, arrayWwn);
        ControllerRef controllerRef = new ControllerRef();
        controllerRef.setRefToken(Convert.stringToBytes(controllerRefString));
        int maxPartitionCount = bundle.getSa().getFeatureParameters().getMaxPartitionCount();
        Trace.verbose((Object)this, "createVolume", "Maximum partition count: " + maxPartitionCount);
        descriptor = this.getVolumeDescriptor(candidate, controllerRef, volumeSize, volumeName, volumeSegmentSize, volumeReadAhead, maxPartitionCount);
        ReturnCode code = new ReturnCode();
        command.setPreferredController(controllerRefString);
        command.execute(7, (XDRType)descriptor, (XDRType)code, true);
        int n = codeValue = code != null ? code.getValue() : -1;
        if (codeValue == 13 || codeValue == 4) {
            Trace.verbose((Object)this, "createVolume", "Trying to create volume with alternate controller.");
            controllerRefString = this.getPreferedController(manager, arrayWwn);
            controllerRef = new ControllerRef();
            controllerRef.setRefToken(Convert.stringToBytes(controllerRefString));
            descriptor.setManager(controllerRef);
            code = new ReturnCode();
            command.setPreferredController(controllerRefString);
            command.execute(7, (XDRType)descriptor, (XDRType)code, true);
            int n2 = codeValue = code != null ? code.getValue() : -1;
        }
        if (codeValue != 1) {
            String message = "Volume creation failed with the error code: " + codeValue;
            Trace.verbose((Object)this, "createVolume", message);
            throw new ConfigMgmtException(ErrorDescriptor.ERROR_REASON_PREFIX + (OZErrorCode.ERROR_CODE_MIN + codeValue), message);
        }
        Trace.verbose((Object)this, "createVolume", "Volume successfully created.");
        return maxPartitionCount <= 0;
    }

    /*
     * WARNING - void declaration
     */
    static int pickSelectionType(int creationMode, DriveRefList driveRefs, int numberOfDrives) throws ConfigMgmtException {
        void var3_3;
        switch (creationMode) {
            case 0: 
            case 1: {
                int selectionType = 1;
                break;
            }
            case 2: {
                int selectionType;
                if (driveRefs != null) {
                    selectionType = 2;
                    break;
                }
                if (numberOfDrives != -1) {
                    selectionType = 3;
                    break;
                }
                throw new ConfigMgmtException("incorrect.method.parameter", "Incorrect creationType value passed.");
            }
            default: {
                throw new ConfigMgmtException("incorrect.method.parameter", "Incorrect creationType value passed.");
            }
        }
        return (int)var3_3;
    }

    public VolumeCandidate[] getVolumeCandidates(CandidateSelectionTypeData selection, int volumeRaidLevel, String arrayWwn, int driveType, CommandProcessor command) throws ConfigMgmtException {
        String METHOD_NAME = "getVolumeCandidates";
        Trace.methodBegin(this, "getVolumeCandidates");
        return VolumeCandidateFetcher.getVolumeCandidates(selection, volumeRaidLevel, arrayWwn, driveType, command);
    }

    private VolumeCandidate pickVolumeCandidate(int creationMode, VolumeCandidate[] candidates, long volumeSize, DriveRefList driveRefs, int numberOfDrives, String vdiskRef, FreeExtent[] freeExtents, int driveType, int raidLevel) throws ConfigMgmtException {
        VolumeCandidate candidate = null;
        block0 : switch (creationMode) {
            case 0: 
            case 2: {
                for (int i = 0; i < candidates.length; ++i) {
                    if (!this.candidateMatch(candidates[i], volumeSize, driveType, raidLevel, numberOfDrives)) continue;
                    candidate = candidates[i];
                    break block0;
                }
                break;
            }
            case 1: {
                List possibleExtents = this.filterFreeExtentsByVDisk(freeExtents, vdiskRef);
                String freeExtentRef = null;
                for (int i = 0; i < candidates.length; ++i) {
                    freeExtentRef = Convert.bytesToStringRaw(candidates[i].getFreeExtentRef().getRefToken());
                    if (!possibleExtents.contains(freeExtentRef) || !this.candidateMatch(candidates[i], volumeSize, driveType, raidLevel, numberOfDrives)) continue;
                    candidate = candidates[i];
                    break block0;
                }
                break;
            }
        }
        if (candidate == null) {
            throw new ConfigMgmtException("error.no.volume.candidates", "There is no appropriate volume candidate.");
        }
        return candidate;
    }

    private boolean candidateMatch(VolumeCandidate candidate, long volumeSize, int driveType, int raidLevel, int numberDisks) {
        int selectionDriveCount = candidate.getDriveCount();
        long selectionVolumeSize = candidate.getUsableSize();
        int selectionRaidLevel = candidate.getRaidLevel().getValue();
        int selectionDriveType = candidate.getPhyDriveType().getValue();
        if (volumeSize > selectionVolumeSize) {
            return false;
        }
        if (0 != driveType && driveType != selectionDriveType) {
            return false;
        }
        if (raidLevel != selectionRaidLevel) {
            return false;
        }
        return 0 == numberDisks || numberDisks == selectionDriveCount;
    }

    private List filterFreeExtentsByVDisk(FreeExtent[] freeExtents, String vdiskRef) throws ConfigMgmtException {
        if (freeExtents == null || freeExtents.length == 0 || vdiskRef == null) {
            throw new ConfigMgmtException("incorrect.method.parameter", "No free extents available.");
        }
        String freeExtentRef = null;
        String volumeGroupRef = null;
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < freeExtents.length; ++i) {
            volumeGroupRef = Convert.bytesToStringRaw(freeExtents[i].getVolumeGroupRef().getRefToken());
            if (!vdiskRef.equals(volumeGroupRef)) continue;
            freeExtentRef = Convert.bytesToStringRaw(freeExtents[i].getFreeExtentRef().getRefToken());
            list.add(freeExtentRef);
        }
        return list;
    }

    private String getPreferedController(ObjectBundleManager manager, String arrayWwn) throws ConfigMgmtException {
        String METHOD_NAME = "getPreferedController";
        Trace.methodBegin(this, "getPreferedController");
        String controllerRefString = null;
        String[] controllerRefStrings = manager.getControlerReferences(arrayWwn);
        int length = controllerRefStrings != null ? controllerRefStrings.length : 0;
        for (int i = 0; i < length; ++i) {
            if (controllerRefStrings[i].equals(manager.volumeCreationMap.get(arrayWwn))) continue;
            controllerRefString = controllerRefStrings[i];
            break;
        }
        if (controllerRefString == null) {
            throw new ConfigMgmtException("error.no.controller", "No controller available for volume creation.");
        }
        manager.volumeCreationMap.put(arrayWwn, controllerRefString);
        return controllerRefString;
    }

    private VolumeCreationDescriptor getVolumeDescriptor(VolumeCandidate candidate, ControllerRef controller, long volumeSize, String volumeName, int volumeSegmentSize, int volumeReadAhead, int maxPartitionCount) {
        String METHOD_NAME = "createVolume";
        Trace.methodBegin(this, "createVolume");
        VolumeCreationDescriptor descriptor = new VolumeCreationDescriptor();
        descriptor.setCandidate(candidate);
        descriptor.setCapacity(volumeSize);
        UserAssignedLabel label = new UserAssignedLabel();
        label.setValue(UnicodeTranslator.getBytes((String)volumeName));
        descriptor.setLabel(label);
        descriptor.setManager(controller);
        descriptor.setSegmentSize(volumeSegmentSize);
        descriptor.setReadAhead(volumeReadAhead);
        descriptor.setWriteZeros(false);
        if (maxPartitionCount > 0) {
            descriptor.setNoMapping(true);
        } else {
            descriptor.setNoMapping(false);
        }
        return descriptor;
    }

    static CommandProcessor getCommandProcessor(String arrayWwn) throws ConfigMgmtException {
        String METHOD_NAME = "getCommandProcessor";
        Trace.methodBegin(class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ManageVolumes == null ? (class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ManageVolumes = ManageVolumes.class$("com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ManageVolumes")) : class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ManageVolumes, "getCommandProcessor");
        try {
            return new CommandProcessor(arrayWwn);
        }
        catch (RPCError e) {
            Trace.error(class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ManageVolumes == null ? (class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ManageVolumes = ManageVolumes.class$("com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ManageVolumes")) : class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ManageVolumes, "getCommandProcessor", (Throwable)e);
            throw new ConfigMgmtException(ErrorCode.ERROR_RPC.getKey(), "RPCError trying to instantiate CommandProcessor.", (Exception)((Object)e));
        }
        catch (IOException e) {
            Trace.error(class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ManageVolumes == null ? (class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ManageVolumes = ManageVolumes.class$("com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ManageVolumes")) : class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$oz$ManageVolumes, "getCommandProcessor", (Throwable)e);
            throw new ConfigMgmtException(ErrorCode.ERROR_COMMUNICATING_WITH_ARRAY.getKey(), "IOException trying to instantiate CommandProcessor.", e);
        }
    }

    public MethodCallStatus delete(List list) throws ConfigMgmtException {
        String METHOD_NAME = "delete";
        Trace.methodBegin(this, "delete");
        String arrayWwn = this.getArrayWwnFromScope();
        if (list == null || list.size() == 0) {
            throw new ConfigMgmtException("incorrect.method.parameter", "Null or empty list passed to ManageVolumes.delete() method.");
        }
        list = Convert.listOfStringKeysToMap(list);
        MethodCallStatus mcs = new MethodCallStatus();
        ErrorDescriptor errorDesc = null;
        Map key = null;
        String volumeWwn = null;
        String volumeName = null;
        int listSize = list.size();
        devmgr.versioned.symbol.Volume volume = null;
        VolumeRef volumeRef = null;
        ReturnCode returnCode = null;
        int returnCodeValue = -1;
        String message = null;
        boolean allVolumesDeleted = true;
        ObjectBundleManager manager = ObjectBundleManager.getInstance();
        ObjectBundle bundle = manager.getObjectBundle(arrayWwn);
        devmgr.versioned.symbol.Volume[] volumes = bundle.getVolume();
        Map volumeMap = this.populateVolumeWwnVolumeMap(bundle.getVolume());
        Map missingVolumeMap = this.populateMissingVolumeWwnVolumeMap(bundle);
        ArrayList replicatedVolumes = new ArrayList();
        this.populateReplicatedVolumeRefsAndRoles(bundle.getHighLevelVolBundle(), replicatedVolumes, new HashMap(), true);
        manager.stopMonitoringThread(arrayWwn);
        CommandProcessor command = ManageVolumes.getCommandProcessor(arrayWwn);
        for (int i = 0; i < listSize; ++i) {
            try {
                MethodCallStatus repsetDeleteResult;
                ErrorDescriptor deleteResult;
                GhostVolume missingVol;
                key = (Map)list.get(i);
                volumeWwn = (String)key.get("volumeWwn");
                volume = (devmgr.versioned.symbol.Volume)volumeMap.get(volumeWwn);
                if (volume == null) {
                    missingVol = (GhostVolume)missingVolumeMap.get(volumeWwn);
                    if (missingVol != null) {
                        deleteResult = this.deleteMissingVolume(command, missingVol);
                        if (deleteResult != null) {
                            mcs.addErrorDescriptor(deleteResult);
                            allVolumesDeleted = false;
                            continue;
                        }
                        mcs.addErrorDescriptor(new ErrorDescriptor(ErrorCode.SUCCESS_DELETE_VOLUME));
                        continue;
                    }
                    ErrorDescriptor ed = new ErrorDescriptor();
                    ed.setErrorCode(ErrorDescriptor.ERROR_ITEM_NOT_FOUND);
                    ed.setI18nkey("error.volume.delete");
                    String[] params = new String[]{volumeWwn};
                    ed.setI18nParams(params);
                    ed.setMsg("Volume WWN was not found");
                    mcs.addErrorDescriptor(ed);
                    allVolumesDeleted = false;
                    continue;
                }
                missingVol = (GhostVolume)missingVolumeMap.get(volumeWwn);
                if (missingVol != null) {
                    deleteResult = this.deleteMissingVolume(command, missingVol);
                    if (deleteResult == null) continue;
                    mcs.addErrorDescriptor(deleteResult);
                    allVolumesDeleted = false;
                    continue;
                }
                volumeRef = volume.getVolumeRef();
                byte[] volumeNameBytes = volume.getLabel().getValue();
                volumeName = volumeNameBytes != null ? UnicodeTranslator.getString((byte[])volume.getLabel().getValue()) : "";
                String volumeScopeKey = "volumeWwn==" + volumeWwn;
                MethodCallStatus snapDeleteResult = this.deleteAnySnapshots(volumeScopeKey);
                if (snapDeleteResult != null && snapDeleteResult.getReturnCode() != 0) {
                    mcs.addErrorDescriptorList(snapDeleteResult.getErrorDescList());
                    allVolumesDeleted = false;
                    continue;
                }
                MethodCallStatus mapDeleteResult = this.deleteAnyMappings(volumeScopeKey);
                if (mapDeleteResult != null && mapDeleteResult.getReturnCode() != 0) {
                    mcs.addErrorDescriptorList(mapDeleteResult.getErrorDescList());
                    allVolumesDeleted = false;
                    continue;
                }
                if (replicatedVolumes.contains(Convert.bytesToStringRaw(volumeRef.getRefToken())) && (repsetDeleteResult = this.deleteReplicationSet(arrayWwn, volumeWwn)) != null) {
                    mcs.addErrorDescriptorList(repsetDeleteResult.getErrorDescList());
                    allVolumesDeleted = false;
                    continue;
                }
                returnCode = new ReturnCode();
                command.setPreferredController(Convert.bytesToString(volume.getCurrentManager().getRefToken()));
                command.execute(9, (XDRType)volumeRef, (XDRType)returnCode, true);
                int n = returnCodeValue = returnCode != null ? returnCode.getValue() : -1;
                if (allVolumesDeleted && returnCodeValue != 1) {
                    allVolumesDeleted = false;
                }
                message = "Code " + returnCodeValue + " returned when deleting the volume " + volumeName;
                Trace.verbose((Object)this, "delete", message);
                errorDesc = returnCodeValue == 1 ? new ErrorDescriptor(ErrorCode.SUCCESS_DELETE_VOLUME) : new ErrorDescriptor(OZErrorCode.getErrorCode(ErrorCode.ERROR_DELETE_VOLUME.getKey(), returnCodeValue));
                errorDesc.setMsg(message);
                LogAPI.staticLog((String)"VOLUME_DELETE_SUCCESS", (String[])new String[]{arrayWwn, volumeName}, (String[])new String[0]);
            }
            catch (ConfigMgmtException cme) {
                LogAPI.staticLog((String)"VOLUME_DELETE_ERROR", (String[])new String[]{arrayWwn, volumeName}, (String[])new String[0]);
                Trace.error((Object)this, "delete", cme);
                errorDesc = new ErrorDescriptor(ErrorCode.ERROR_DELETE_VOLUME_RPC_ERROR);
                errorDesc.setMsg("Exception when trying to delete the volume: " + volumeName);
                allVolumesDeleted = false;
            }
            if (errorDesc == null) continue;
            errorDesc.setI18nParams(new String[]{volumeName});
            mcs.addErrorDescriptor(errorDesc);
        }
        manager.forceBundleReload(arrayWwn);
        if (allVolumesDeleted) {
            mcs.setReturnCode(0);
        } else {
            mcs.setReturnCode(2);
        }
        return mcs;
    }

    private Map populateVolumeWwnVolumeMap(devmgr.versioned.symbol.Volume[] volumes) {
        HashMap<String, devmgr.versioned.symbol.Volume> volumeMap = new HashMap<String, devmgr.versioned.symbol.Volume>();
        int length = volumes == null ? 0 : volumes.length;
        for (int i = 0; i < length; ++i) {
            volumeMap.put(Convert.bytesToString(volumes[i].getWorldWideName()), volumes[i]);
        }
        return volumeMap;
    }

    private Map populateMissingVolumeWwnVolumeMap(ObjectBundle bundle) {
        HashMap<String, GhostVolume> volumeMap = new HashMap<String, GhostVolume>();
        GhostVolume[] ghostVolumes = bundle.getGhostVolBundle().getGhostVol();
        int length = ghostVolumes == null ? 0 : ghostVolumes.length;
        for (int i = 0; i < length; ++i) {
            volumeMap.put(Convert.bytesToString(ghostVolumes[i].getWorldWideName()), ghostVolumes[i]);
        }
        return volumeMap;
    }

    public static Map populateGhostVolumeRefVolumeMap(GhostVolume[] ghostVolumes) {
        HashMap<String, GhostVolume> m = new HashMap<String, GhostVolume>();
        int length = ghostVolumes != null ? ghostVolumes.length : 0;
        for (int i = 0; i < length; ++i) {
            m.put(Convert.bytesToString(ghostVolumes[i].getVolumeRef().getRefToken()), ghostVolumes[i]);
        }
        return m;
    }

    public int getMaxObjects() {
        return 0;
    }

    public void init(ConfigContext context, Scope scope, SearchFilter filter) {
        this.context = context;
        this.scope = scope;
        this.filter = filter;
    }

    public List getItemList() throws ConfigMgmtException {
        String METHOD_NAME = "getItemList";
        Trace.methodBegin(this, "getItemList");
        Trace.verbose((Object)this, "getItemList", "PROFILE: getObjectBundle");
        Collection bundles = this.getBundles();
        Trace.verbose((Object)this, "getItemList", "PROFILE: bundle retrieved");
        ArrayList volumeList = new ArrayList();
        Iterator iter = bundles.iterator();
        while (iter.hasNext()) {
            ObjectBundle bundle = (ObjectBundle)iter.next();
            volumeList.addAll(this.getVolumesFromBundle(bundle, this.filter));
        }
        Trace.verbose((Object)this, "getItemList", "Number of items in the list = " + volumeList.size());
        return volumeList;
    }

    private List getVolumesFromBundle(ObjectBundle bundle, SearchFilter filter) throws ConfigMgmtException {
        String searchField;
        String METHOD_NAME = "getVolumesFromBundle";
        Trace.methodBegin(this, "getVolumesFromBundle");
        ArrayList<Volume> volumeList = new ArrayList<Volume>();
        devmgr.versioned.symbol.Volume[] ozVols = bundle.getVolume();
        if (ozVols == null || ozVols.length == 0) {
            return volumeList;
        }
        String arrayName = "";
        byte[] arrayLabelBytes = bundle.getSa().getSaData().getStorageArrayLabel().getValue();
        if (arrayLabelBytes != null) {
            arrayName = UnicodeTranslator.getString((byte[])arrayLabelBytes);
        }
        String arrayWwn = Convert.bytesToString(bundle.getSa().getSaData().getSaId().getWorldWideName());
        String vdiskScopeRef = this.getVDiskRefFromScope();
        String poolScopeKeyAsString = (String)this.scope.getAttribute("pool");
        String scopePoolId = (String)Convert.keyAsStringToMap(poolScopeKeyAsString).get("id");
        int scopePoolInt = 0;
        if (scopePoolId != null) {
            scopePoolInt = Integer.parseInt(scopePoolId);
            Trace.verbose((Object)this, "getVolumesFromBundle", "POOL SCOPE IS SET TO:" + scopePoolInt);
        } else {
            Trace.verbose((Object)this, "getVolumesFromBundle", "NO POOL SCOPE ");
        }
        String scopeVolumesForSnapshotCreation = (String)this.scope.getAttribute("volumesForSnapshotCreation");
        if (!(filter == null || (searchField = filter.getSearchField()) != null && (searchField.equals("name") || searchField.equals("wwn") || searchField.equals("keyAsString") || searchField.equals("profileName") || searchField.equals("volumesWithoutMappings") || searchField.equals("volumesForReplicationSetPeerArrayWwn") || searchField.equals("volumesForReplicationSetVolumeWwn") || searchField.equals("volumesReplicationSetMetadataVolume") || searchField.equals("volumesNotReplicated")))) {
            Trace.warn((Object)this, "getVolumesFromBundle", "Search field not supported: " + searchField);
            throw new ConfigMgmtException("error.search.field.not.supported", "error.search.field.not.supported: " + searchField);
        }
        Map requestedVolumeKeyMap = this.getKeyMapFromKeyAsStringFilter();
        Set volumesWithMappingsRefs = new HashSet();
        volumesWithMappingsRefs = ManageVolumes.getVolumesWithMappingsRefs(bundle.getStoragePoolBundle().getLunMapping());
        HLVolumeBundle volumeBundle = bundle.getHighLevelVolBundle();
        SnapshotVolume[] snapshotVolumes = volumeBundle.getSnapshotVol();
        VolumeCopy[] volumeCopies = volumeBundle.getVolumeCopy();
        ArrayList sourceVolumeRefs = new ArrayList();
        ArrayList targetVolumeRefs = new ArrayList();
        ArrayList repositoryVolumeRefs = new ArrayList();
        HashMap numberOfSnapsMap = new HashMap();
        ArrayList replicationSetCandidates = new ArrayList();
        ArrayList volumesFilteredForRepSets = new ArrayList();
        ArrayList replicatedVolumes = new ArrayList();
        HashMap replicatedVolumeRoles = new HashMap();
        Map missingVolumeMap = this.populateMissingVolumeWwnVolumeMap(bundle);
        this.populateSourceAndTargetLists(volumeCopies, sourceVolumeRefs, targetVolumeRefs);
        this.populateRepositoryListAndNumberOfSnapsMap(snapshotVolumes, repositoryVolumeRefs, numberOfSnapsMap);
        this.populateRepSetCandidateList(bundle, arrayWwn, replicationSetCandidates);
        this.populateVolumesFilteredForRepsets(volumeBundle, ozVols, volumesFilteredForRepSets);
        this.populateReplicatedVolumeRefsAndRoles(volumeBundle, replicatedVolumes, replicatedVolumeRoles, false);
        HashMap controllerMap = new HashMap();
        HashMap vdiskMap = new HashMap();
        this.populateControllerMap(bundle.getController(), controllerMap);
        this.populateVDiskMap(bundle.getVolumeGroup(), vdiskMap);
        String vdiskRef = null;
        devmgr.versioned.symbol.Volume ozVol = null;
        String volumeRef = null;
        String volumeWwn = null;
        String volumeName = null;
        Integer role = null;
        Integer numberOfSnaps = null;
        PoolDataManager pdm = new PoolDataManager(arrayWwn);
        Map poolMap = pdm.getRawPoolMap();
        ProfileDataManager profdm = new ProfileDataManager(arrayWwn);
        Map profileMap = profdm.getRawProfileMap();
        int ozVolCount = ozVols.length;
        for (int i = 0; i < ozVolCount; ++i) {
            PoolData pd;
            ozVol = ozVols[i];
            vdiskRef = Convert.bytesToStringRaw(ozVol.getVolumeGroupRef().getRefToken());
            volumeWwn = Convert.bytesToString(ozVol.getWorldWideName());
            if (ozVol.getLabel().getValue() == null) continue;
            volumeName = UnicodeTranslator.getString((byte[])ozVol.getLabel().getValue());
            volumeRef = Convert.bytesToStringRaw(ozVol.getVolumeRef().getRefToken());
            if (!volumesFilteredForRepSets.contains(volumeRef) || scopeVolumesForSnapshotCreation != null && scopeVolumesForSnapshotCreation.equals(Boolean.TRUE.toString()) && (repositoryVolumeRefs.contains(volumeRef) || targetVolumeRefs.contains(volumeRef) || (role = (Integer)replicatedVolumeRoles.get(volumeRef)) != null && role != 0 || (numberOfSnaps = (Integer)numberOfSnapsMap.get(volumeRef)) != null && numberOfSnaps >= bundle.getSa().getFeatureParameters().getMaxSnapshotsPerBase())) continue;
            Volume newVol = new Volume();
            int vpid = ozVol.getMgmtClientAttribute();
            if (vpid != 0 && poolMap != null && (pd = (PoolData)poolMap.get("" + vpid)) != null) {
                Profile p = (Profile)profileMap.get(pd.profileId);
                newVol.setPoolName(pd.poolName);
                newVol.setPoolKeyAsString(Convert.keyToString(ManagePools.getPoolKey(pd.poolId, arrayWwn)));
                newVol.setProfileName(p.getName());
            }
            String volumeTypeScope = (String)this.scope.getAttribute("volumeType");
            if (scopePoolId != null && scopePoolInt != vpid || vdiskScopeRef != null && !vdiskScopeRef.equals(vdiskRef) || volumeTypeScope != null && (!volumeTypeScope.equals("3") || !repositoryVolumeRefs.contains(volumeRef)) && (!volumeTypeScope.equals("7") || repositoryVolumeRefs.contains(volumeRef)) || filter != null && (filter.isEmpty() || (!filter.getSearchField().equals("keyAsString") || requestedVolumeKeyMap == null || !this.checkVolumeKeyMap(requestedVolumeKeyMap, arrayWwn, volumeRef, volumeName, volumeWwn)) && (filter.getFilterValue("name") == null && (filter.getSearchField() == null || !filter.getSearchField().equals("name")) || !filter.passesFilter("name", volumeName) || repositoryVolumeRefs.contains(volumeRef) && filter.getFilterValue("includeRepositories") == null) && (!filter.getSearchField().equals("wwn") || !filter.passesFilter(volumeWwn) || repositoryVolumeRefs.contains(volumeRef)) && (!filter.getSearchField().equals("profileName") || !filter.passesFilter(newVol.getProfileName())) && filter.getFilterValue("volumesWithoutMappings") == null && (!filter.isMultipleFieldValueFilter() || filter.getFilterValue("volumesForReplicationSetPeerArrayWwn") == null || filter.getFilterValue("volumesForReplicationSetVolumeWwn") == null || !replicationSetCandidates.contains(volumeWwn)) && (!filter.getSearchField().equals("volumesReplicationSetMetadataVolume") || !volumesFilteredForRepSets.contains(volumeRef))) || filter != null && filter.getFilterValue("volumesWithoutMappings") != null && volumesWithMappingsRefs.contains(volumeRef) || filter != null && filter.getFilterValue("name") != null && !filter.passesFilter("name", volumeName)) continue;
            newVol.setName(volumeName);
            newVol.setWwn(volumeWwn);
            newVol.setVDiskReference(vdiskRef);
            newVol.setSize(BigInteger.valueOf(ozVol.getCapacity()));
            newVol.setStatus(ozVol.getOffline() ? 15 : 4);
            newVol.setCondition(ozVol.getStatus().getValue());
            if (volumesWithMappingsRefs.contains(volumeRef)) {
                newVol.setState(1);
            } else {
                newVol.setState(0);
            }
            if (missingVolumeMap.get(volumeWwn) != null) continue;
            newVol.setArrayName(arrayName);
            newVol.setSegmentSize(ozVol.getSegmentSize());
            VolumeCache ozVolCache = ozVol.getCache();
            newVol.setReadCache(ozVolCache.getReadAheadMultiplier() == 3);
            newVol.setWriteCache(ozVolCache.getWriteCacheEnable());
            newVol.setWriteCacheWithMirroring(ozVolCache.getMirrorEnable());
            newVol.setWriteCacheWithoutBatteries(ozVolCache.getCwob());
            newVol.setFlushCacheAfter(ozVolCache.getCacheFlushModifier().getValue());
            newVol.setModificationPriority(ozVol.getReconPriority());
            newVol.setRaidLevel(ozVol.getRaidLevel().getValue());
            newVol.setObjectItemType("volume");
            VolumeMediaScanParams vmsp = ozVol.getMediaScan();
            if (vmsp.getEnable()) {
                newVol.setDiskScrubbing(true);
                if (vmsp.getParityValidationEnable()) {
                    newVol.setDiskScrubbingWithRedundancy(true);
                }
            }
            if (sourceVolumeRefs.contains(volumeRef) && targetVolumeRefs.contains(volumeRef)) {
                newVol.setType(6);
                newVol.setReadOnly(!ozVol.getPerms().getWritable());
            } else if (sourceVolumeRefs.contains(volumeRef)) {
                newVol.setType(4);
                newVol.setReadOnly(!ozVol.getPerms().getWritable());
            } else if (targetVolumeRefs.contains(volumeRef)) {
                newVol.setType(5);
                newVol.setReadOnly(!ozVol.getPerms().getWritable());
            } else if (repositoryVolumeRefs.contains(volumeRef)) {
                newVol.setType(3);
            } else {
                newVol.setType(1);
            }
            if (this.isRepsetMetadataVolume(volumeBundle, volumeRef)) {
                if (volumeName.equals("CTL 0 Mirror Repository")) {
                    newVol.setName("Replication Repository #1");
                } else if (volumeName.equals("CTL 1 Mirror Repository")) {
                    newVol.setName("Replication Repository #2");
                }
                newVol.setType(8);
            }
            if (filter != null && filter.getFilterValue("volumesNotReplicated") != null && (replicatedVolumes.contains(volumeRef) || newVol.getType() == 3 || newVol.getType() == 8)) continue;
            if (replicatedVolumes.contains(volumeRef)) {
                newVol.setType(newVol.getType() + 500);
                Trace.verbose((Object)this, "getVolumesFromBundle", "Volume type set to:" + newVol.getType());
            }
            newVol.setPreferredController((String)controllerMap.get(Convert.bytesToStringRaw(ozVol.getPreferredManager().getRefToken())));
            newVol.setController((String)controllerMap.get(Convert.bytesToStringRaw(ozVol.getCurrentManager().getRefToken())));
            newVol.setVdiskName((String)vdiskMap.get(vdiskRef));
            newVol.setAction(ozVol.getAction().getValue());
            Map key = ManageVolumes.getVolumeKeyMap(arrayWwn, volumeRef, newVol.getName(), volumeWwn);
            newVol.setKey(key);
            volumeList.add(newVol);
            if (filter != null && "keyAsString".equals(filter.getSearchField())) break;
        }
        if (filter == null && vdiskScopeRef == null && scopePoolId == null && scopeVolumesForSnapshotCreation == null || filter != null && filter.getFilterValue("includeMissingWithFilter") != null) {
            GhostVolume[] ghostVolumes = bundle.getGhostVolBundle().getGhostVol();
            this.addGhostVolumes(arrayWwn, arrayName, ghostVolumes, filter, requestedVolumeKeyMap, volumeList);
        }
        return volumeList;
    }

    private Collection getBundles() throws ConfigMgmtException {
        Trace.methodBegin(this, "getBundles");
        ArrayList<ObjectBundle> bundles = null;
        if (this.scope != null) {
            String arrayWwn = Convert.scopeToArrayKey(this.scope);
            bundles = new ArrayList<ObjectBundle>(1);
            ObjectBundle ob = ObjectBundleManager.getInstance().getObjectBundle(arrayWwn);
            bundles.add(ob);
        } else {
            bundles = ObjectBundleManager.getInstance().getObjectBundles();
        }
        return bundles;
    }

    private void populateReplicatedVolumeRefsAndRoles(HLVolumeBundle volumeBundle, List replicatedVolumes, HashMap replicatedVolumeRoles, boolean includeRemoteVol) {
        MirrorProxyVolume[] mpv = volumeBundle.getMirrorVol();
        int length = mpv == null ? 0 : mpv.length;
        for (int i = 0; i < length; ++i) {
            AbstractVolRef avr = mpv[i].getBaseVolume();
            String avrRefString = Convert.bytesToStringRaw(avr.getRefToken());
            replicatedVolumes.add(avrRefString);
            replicatedVolumeRoles.put(avrRefString, new Integer(mpv[i].getLocalRole().getValue()));
            if (!includeRemoteVol) continue;
            avrRefString = Convert.bytesToStringRaw(mpv[i].getRemoteVolRef().getRefToken());
            replicatedVolumes.add(avrRefString);
            replicatedVolumeRoles.put(avrRefString, new Integer(mpv[i].getLocalRole().getValue()));
        }
        Trace.verbose((Object)this, "populateReplicatedVolumeReferences", "Total number of references:" + replicatedVolumes.size());
    }

    private void addGhostVolumes(String arrayWwn, String arrayName, GhostVolume[] ghostVolumes, SearchFilter filter, Map requestedVolumeKeyMap, List volumeList) {
        int length = ghostVolumes == null ? 0 : ghostVolumes.length;
        for (int i = 0; i < length; ++i) {
            String volumeWwn = Convert.bytesToString(ghostVolumes[i].getWorldWideName());
            String volumeRef = Convert.bytesToStringRaw(ghostVolumes[i].getVolumeRef().getRefToken());
            if (filter != null && (filter.isEmpty() || !(filter.getSearchField().equals("keyAsString") && requestedVolumeKeyMap != null && this.checkVolumeKeyMap(requestedVolumeKeyMap, arrayWwn, volumeRef, volumeWwn, volumeWwn) || (filter.getFilterValue("name") != null || filter.getSearchField() != null && filter.getSearchField().equals("name")) && filter.passesFilter("name", volumeWwn) || filter.getSearchField().equals("wwn") && filter.passesFilter(volumeWwn)) && (!filter.getSearchField().equals("volumesReplicationSetMetadataVolume") || !filter.getSearchString().equals(INCLUDE_METADATA_VOLUMES)))) continue;
            Volume missingVol = new Volume();
            missingVol.setType(1);
            missingVol.setState(2);
            missingVol.setCondition(3);
            missingVol.setWwn(volumeWwn);
            missingVol.setName(volumeWwn);
            missingVol.setKey(ManageVolumes.getVolumeKeyMap(arrayWwn, volumeRef, volumeWwn, volumeWwn));
            missingVol.setArrayName(arrayName);
            missingVol.setObjectItemType("volume");
            missingVol.setSize(BigInteger.ZERO);
            volumeList.add(missingVol);
        }
    }

    private void populateSourceAndTargetLists(VolumeCopy[] volumeCopies, List sourceVolumeRefs, List targetVolumeRefs) {
        if (volumeCopies == null || volumeCopies.length == 0) {
            return;
        }
        VolumeCopy volumeCopy = null;
        for (int i = 0; i < volumeCopies.length; ++i) {
            volumeCopy = volumeCopies[i];
            sourceVolumeRefs.add(Convert.bytesToStringRaw(volumeCopy.getSourceVolume().getRefToken()));
            targetVolumeRefs.add(Convert.bytesToStringRaw(volumeCopy.getTargetVolume().getRefToken()));
        }
    }

    private String getVDiskRefFromScope() {
        String keyAsString;
        String vdiskRef = null;
        if (this.scope != null && (keyAsString = (String)this.scope.getAttribute("vdisk")) != null) {
            Map map = Convert.keyAsStringToMap(keyAsString);
            vdiskRef = (String)map.get("vdiskRef");
        }
        return vdiskRef;
    }

    private String getVolumeWwnFromKeyAsStringFilter() {
        String keyAsString;
        String volumeWwn = null;
        if (this.filter != null && !this.filter.isEmpty() && this.filter.getSearchField().equals("keyAsString") && (keyAsString = this.filter.getSearchString()) != null) {
            Map map = Convert.keyAsStringToMap(keyAsString);
            volumeWwn = (String)map.get("volumeWwn");
        }
        return volumeWwn;
    }

    private void populateRepositoryListAndNumberOfSnapsMap(SnapshotVolume[] snapshotVolumes, List repositoryVolumeRefs, HashMap numberOfSnapsMap) {
        if (snapshotVolumes == null || snapshotVolumes.length == 0) {
            return;
        }
        SnapshotVolume snapshotVolume = null;
        Integer numberOfSnaps = null;
        String ozBaseVolumeRef = null;
        for (int i = 0; i < snapshotVolumes.length; ++i) {
            snapshotVolume = snapshotVolumes[i];
            repositoryVolumeRefs.add(Convert.bytesToStringRaw(snapshotVolume.getRepositoryVolume().getRefToken()));
            ozBaseVolumeRef = Convert.bytesToStringRaw(snapshotVolume.getBaseVolume().getRefToken());
            numberOfSnaps = (Integer)numberOfSnapsMap.get(ozBaseVolumeRef);
            if (numberOfSnaps != null) {
                numberOfSnaps = new Integer(numberOfSnaps + 1);
                numberOfSnapsMap.put(ozBaseVolumeRef, numberOfSnaps);
                continue;
            }
            numberOfSnapsMap.put(ozBaseVolumeRef, new Integer(1));
        }
    }

    private void populateRepSetCandidateList(ObjectBundle bundle, String myWwn, List replicationSetWwn) throws ConfigMgmtException {
        String METHOD_NAME = "populateRepSetCandidateList";
        Trace.methodBegin(this, "populateRepSetCandidateList");
        if (this.filter != null) {
            String peerArrayWwn = null;
            String volumeWwn = null;
            if (this.filter.isMultipleFieldValueFilter()) {
                peerArrayWwn = this.filter.getFilterValue("volumesForReplicationSetPeerArrayWwn");
                volumeWwn = this.filter.getFilterValue("volumesForReplicationSetVolumeWwn");
            }
            if (peerArrayWwn != null && volumeWwn != null) {
                StorageArray sa = bundle.getSa();
                ObjectBundle peerBundle = ObjectBundleManager.getInstance().getObjectBundle(peerArrayWwn);
                VolumeRef baseVolume = ManageVolumes.getVolumeForWwn(peerBundle.getVolume(), volumeWwn).getVolumeRef();
                MirrorCandidateDescriptor mirrorCandidateDescriptor = new MirrorCandidateDescriptor();
                mirrorCandidateDescriptor.setRemoteNodeWWN(sa.getRemoteAccessID());
                mirrorCandidateDescriptor.setBaseVolume((AbstractVolRef)baseVolume);
                MirrorVolumeCandidateList mirrorVolumeCandidateList = new MirrorVolumeCandidateList();
                try {
                    CommandProcessor command = new CommandProcessor(peerArrayWwn);
                    command.execute(109, (XDRType)mirrorCandidateDescriptor, (XDRType)mirrorVolumeCandidateList, true);
                    ReturnCode rc = mirrorVolumeCandidateList.getReturnCode();
                    if (rc.getValue() != 1) {
                        Trace.verbose((Object)this, "populateRepSetCandidateList", "Error getting the list from SYMbol:" + rc.getValue());
                        LogAPI.staticLog((String)"REPLICATION_SET_INPUT_ERROR", (String[])new String[]{ManageArrays.getArrayName(sa)}, (String[])new String[0]);
                        throw new ConfigMgmtException(ErrorDescriptor.ERROR_REASON_PREFIX + (OZErrorCode.ERROR_CODE_MIN + rc.getValue()), "getVolumeListForMirroring error");
                    }
                    MirrorVolumeCandidate[] mirrorVolumeCandidates = mirrorVolumeCandidateList.getMirrorVolumeCandidate();
                    MirrorVolumeCandidate mirrorVolumeCandidate = null;
                    for (int i = 0; i < mirrorVolumeCandidates.length; ++i) {
                        mirrorVolumeCandidate = mirrorVolumeCandidates[i];
                        replicationSetWwn.add(Convert.bytesToString(mirrorVolumeCandidate.getRemoteVolWWN()));
                    }
                }
                catch (RPCError rpc) {
                    Trace.error((Object)this, "populateRepSetCandidateList", "RPC error");
                    LogAPI.staticLog((String)"REPLICATION_SET_COMM_ERROR", (String[])new String[]{ManageArrays.getArrayName(sa)}, (String[])new String[0]);
                    throw new ConfigMgmtException(ErrorCode.ERROR_RPC.getKey(), "RPC error");
                }
                catch (IOException io) {
                    Trace.error((Object)this, "populateRepSetCandidateList", "IO error");
                    LogAPI.staticLog((String)"REPLICATION_SET_COMM_ERROR", (String[])new String[]{ManageArrays.getArrayName(sa)}, (String[])new String[0]);
                    throw new ConfigMgmtException(ErrorCode.ERROR_COMMUNICATING_WITH_ARRAY.getKey(), "IO error");
                }
                finally {
                    ObjectBundleManager.getInstance().forceBundleReload(myWwn);
                }
            }
        }
        Trace.methodEnd(this, "populateRepSetCandidateList");
    }

    private void populateVolumesFilteredForRepsets(HLVolumeBundle volumeBundle, devmgr.versioned.symbol.Volume[] ozVols, List replicationSetVolumeList) {
        String METHOD_NAME = "populateRepSetCandidateList";
        Trace.methodBegin(this, "populateRepSetCandidateList");
        if (this.filter != null) {
            if ("volumesReplicationSetMetadataVolume".equals(this.filter.getSearchField()) && this.filter.getSearchString().equals(INCLUDE_METADATA_VOLUMES)) {
                for (int i = 0; i < ozVols.length; ++i) {
                    replicationSetVolumeList.add(Convert.bytesToStringRaw(ozVols[i].getVolumeRef().getRefToken()));
                }
                return;
            }
            if ("volumesReplicationSetMetadataVolume".equals(this.filter.getSearchField()) && this.filter.getSearchString().equals(ONLY_METADATA_VOLUMES)) {
                for (int i = 0; i < ozVols.length; ++i) {
                    String volRef = Convert.bytesToStringRaw(ozVols[i].getVolumeRef().getRefToken());
                    if (!this.isRepsetMetadataVolume(volumeBundle, volRef)) continue;
                    replicationSetVolumeList.add(volRef);
                }
                return;
            }
        }
        for (int i = 0; i < ozVols.length; ++i) {
            String volRef = Convert.bytesToStringRaw(ozVols[i].getVolumeRef().getRefToken());
            if (this.isRepsetMetadataVolume(volumeBundle, volRef)) continue;
            replicationSetVolumeList.add(volRef);
        }
        Trace.methodEnd(this, "populateRepSetCandidateList");
    }

    private boolean isRepsetMetadataVolume(HLVolumeBundle volumeBundle, String volRef) {
        MetadataVolume[] mv = volumeBundle.getMetadataVol();
        if (mv != null && mv.length > 0) {
            for (int i = 0; i < mv.length; ++i) {
                String avrRefString = Convert.bytesToStringRaw(mv[i].getAssociatedVolume().getRefToken());
                if (!avrRefString.equals(volRef)) continue;
                return true;
            }
        }
        return false;
    }

    private void populateControllerMap(Controller[] controllers, Map controllerMap) throws ConfigMgmtException {
        if (controllers == null || controllers.length == 0) {
            throw new ConfigMgmtException("error.no.controller", "No controller available for listing volumes.");
        }
        Controller controller = null;
        for (int i = 0; i < controllers.length; ++i) {
            controller = controllers[i];
            controllerMap.put(Convert.bytesToStringRaw(controller.getControllerRef().getRefToken()), controller.getPhysicalLocation().getSlot() == 1 ? "A" : "B");
        }
    }

    private void populateVDiskMap(VolumeGroup[] volumeGroups, Map vdiskMap) {
        if (volumeGroups == null || volumeGroups.length == 0) {
            return;
        }
        VolumeGroup volumeGroup = null;
        for (int i = 0; i < volumeGroups.length; ++i) {
            volumeGroup = volumeGroups[i];
            vdiskMap.put(Convert.bytesToStringRaw(volumeGroup.getVolumeGroupRef().getRefToken()), volumeGroup.getSequenceNum() + "");
        }
    }

    static Set getVolumesWithMappingsRefs(LUNMapping[] lunMappings) {
        HashSet<String> volumesWithMappingsRefs = new HashSet<String>();
        int length = lunMappings == null ? 0 : lunMappings.length;
        for (int i = 0; i < length; ++i) {
            volumesWithMappingsRefs.add(Convert.bytesToStringRaw(lunMappings[i].getVolumeRef().getRefToken()));
        }
        return volumesWithMappingsRefs;
    }

    private devmgr.versioned.symbol.Volume getVolumeForName(devmgr.versioned.symbol.Volume[] volumes, String volumeName) {
        devmgr.versioned.symbol.Volume volume = null;
        String currentVolumeName = null;
        if (volumeName != null) {
            int size = volumes == null ? 0 : volumes.length;
            for (int i = 0; i < size; ++i) {
                if (volumes[i].getLabel().getValue() == null || !volumeName.equals(currentVolumeName = UnicodeTranslator.getString((byte[])volumes[i].getLabel().getValue()))) continue;
                volume = volumes[i];
                break;
            }
        }
        return volume;
    }

    public int getItemCount() throws ConfigMgmtException {
        Trace.methodBegin(this, "getItemCount");
        return this.getItemList().size();
    }

    public void modify(Object key, Properties props) throws ConfigMgmtException {
        String METHOD_NAME = "modify";
        Trace.methodBegin(this, "modify");
        if (key == null || props == null) {
            throw new ConfigMgmtException("incorrect.method.parameter", "Must supply non-null key and Properties object for modify.");
        }
        String arrayWwn = this.getArrayWwnFromScope();
        ObjectBundle bundle = ObjectBundleManager.getInstance().getObjectBundle(arrayWwn);
        String volumeWwnString = null;
        if (key instanceof Map) {
            volumeWwnString = (String)((Map)key).get("volumeWwn");
        } else if (key instanceof String) {
            volumeWwnString = (String)Convert.keyAsStringToMap((String)key).get("volumeWwn");
        }
        Map missingVolumes = this.populateMissingVolumeWwnVolumeMap(bundle);
        if (missingVolumes.get(volumeWwnString) != null) {
            Trace.error((Object)this, "modify", volumeWwnString + " Missing volume can not be modified.");
            LogAPI.staticLog((String)"VOLUME_MODIFY_ERROR", (String[])new String[]{arrayWwn, volumeWwnString}, (String[])new String[0]);
            throw new ConfigMgmtException("incorrect.method.parameter", "Missing volume can not be modified.");
        }
        devmgr.versioned.symbol.Volume volume = ManageVolumes.getVolumeForWwn(bundle.getVolume(), volumeWwnString);
        String volumeLabel = props.getProperty("name");
        if (volumeLabel == null || volumeLabel.trim().equals("")) {
            volumeLabel = UnicodeTranslator.getString((byte[])volume.getLabel().getValue());
        }
        try {
            String newModificationPriority;
            String newControllerName;
            Profile newProfile = new Profile();
            String newPoolId = this.checkProfileModification(arrayWwn, newProfile, volume, props);
            ObjectBundleManager.getInstance().stopMonitoringThread(arrayWwn);
            String newName = props.getProperty("name");
            if (newName != null) {
                String oldName = null;
                if (volume.getLabel().getValue() != null) {
                    oldName = UnicodeTranslator.getString((byte[])volume.getLabel().getValue());
                }
                if (!newName.equals(oldName)) {
                    this.setVolumeUserLabel(volume, newName, arrayWwn);
                }
            }
            if ((newControllerName = props.getProperty("controller")) != null) {
                Controller controller = this.getControllerForName(bundle.getController(), newControllerName);
                if (!Convert.bytesToStringRaw(volume.getCurrentManager().getRefToken()).equals(Convert.bytesToStringRaw(controller.getControllerRef().getRefToken()))) {
                    this.assignVolumeOwnership(volume, controller.getControllerRef(), arrayWwn);
                }
                devmgr.versioned.symbol.Volume[] volumes = this.getAllOZVolumesOnArray(arrayWwn);
                volume = ManageVolumes.getVolumeForWwn(volumes, volumeWwnString);
            }
            if ((newModificationPriority = props.getProperty("modificationPriority")) != null) {
                int newModificationPriorityInt = -1;
                try {
                    newModificationPriorityInt = Integer.parseInt(newModificationPriority);
                }
                catch (NumberFormatException nfe) {
                    LogAPI.staticLog((String)"VOLUME_MODIFY_ERROR", (String[])new String[]{arrayWwn, volumeLabel}, (String[])new String[0]);
                    Trace.error((Object)this, "modify", (Throwable)nfe);
                    throw new ConfigMgmtException("incorrect.method.parameter", "Invalid modification priority value passed.", nfe);
                }
                if (newModificationPriorityInt != volume.getReconPriority()) {
                    this.setVolumeParams(volume, newModificationPriorityInt, arrayWwn);
                }
            }
            long newVolumeSize = this.extractVolumeSizeFromProps(props, "size");
            long extensionSize = this.extractVolumeSizeFromProps(props, "extensionSize");
            if (newVolumeSize > 0L && extensionSize > 0L) {
                LogAPI.staticLog((String)"VOLUME_MODIFY_ERROR", (String[])new String[]{arrayWwn, volumeLabel}, (String[])new String[0]);
                throw new ConfigMgmtException("incorrect.method.parameter", "Both new volume size and extension size passed.");
            }
            if (newVolumeSize > volume.getCapacity()) {
                this.startVolumeExpansion(volume, newVolumeSize, arrayWwn);
            } else if (extensionSize > 0L) {
                this.startVolumeExpansion(volume, volume.getCapacity() + extensionSize, arrayWwn);
            }
            this.modifyDiskScrubbing(volume, props, arrayWwn);
            String wc = props.getProperty("writeCache");
            String wcwb = props.getProperty("writeCacheWithoutBatteries");
            String wcwm = props.getProperty("writeCacheWithMirroring");
            VolumeCache volumeCache = volume.getCache();
            boolean updateVolumeCache = false;
            boolean volumeCacheUpdated = false;
            if (wc != null && !Boolean.toString(volumeCache.getWriteCacheEnable()).equalsIgnoreCase(wc)) {
                updateVolumeCache = true;
                volumeCache.setWriteCacheEnable(!volumeCache.getWriteCacheEnable());
            }
            if (wcwm != null && !Boolean.toString(volumeCache.getMirrorEnable()).equalsIgnoreCase(wcwm)) {
                updateVolumeCache = true;
                volumeCache.setMirrorEnable(!volumeCache.getMirrorEnable());
            }
            if (wcwb != null && !Boolean.toString(volumeCache.getCwob()).equalsIgnoreCase(wcwb)) {
                updateVolumeCache = true;
                volumeCache.setCwob(!volumeCache.getCwob());
            }
            if (newPoolId != null) {
                int oldPoolId = volume.getMgmtClientAttribute();
                if (!(newPoolId == null || oldPoolId != 0 && newPoolId.equals(oldPoolId + ""))) {
                    this.matchOZVolumeWithProfile(volume, (VolumeCache)(updateVolumeCache ? volumeCache : null), newProfile, arrayWwn, newPoolId);
                    volumeCacheUpdated = true;
                }
            }
            if (updateVolumeCache && !volumeCacheUpdated) {
                Trace.verbose((Object)this, "modify", "Trying to set volume cache parameters.");
                this.setVolumeCacheParams(volume, volumeCache, arrayWwn);
            }
            LogAPI.staticLog((String)"VOLUME_MODIFY_SUCCESS", (String[])new String[]{arrayWwn, volumeLabel}, (String[])new String[0]);
        }
        catch (ConfigMgmtException cme) {
            LogAPI.staticLog((String)"VOLUME_MODIFY_ERROR", (String[])new String[]{arrayWwn, volumeLabel}, (String[])new String[0]);
            throw cme;
        }
        finally {
            ObjectBundleManager.getInstance().forceBundleReload(arrayWwn);
        }
    }

    private void modifyDiskScrubbing(devmgr.versioned.symbol.Volume volume, Properties props, String arrayWwn) throws ConfigMgmtException {
        String METHOD_NAME = "modifyDiskScrubbing";
        Trace.methodBegin(this, "modifyDiskScrubbing");
        String ds = props.getProperty("diskScrubbing");
        String dswr = props.getProperty("diskScrubbingWithRedundancy");
        if (ds == null && dswr == null) {
            return;
        }
        VolumeMediaScanParams vmsp = volume.getMediaScan();
        boolean updateMediaScan = false;
        boolean oldDiskScrubbing = false;
        boolean oldDiskScrubbingWithRedundancy = false;
        if (vmsp.getEnable()) {
            oldDiskScrubbing = true;
            if (vmsp.getParityValidationEnable()) {
                oldDiskScrubbingWithRedundancy = true;
            }
        }
        if (ds != null && !Boolean.toString(oldDiskScrubbing).equalsIgnoreCase(ds)) {
            vmsp.setEnable(!vmsp.getEnable());
            updateMediaScan = true;
        }
        if (dswr != null && vmsp.getEnable() && !Boolean.toString(oldDiskScrubbingWithRedundancy).equalsIgnoreCase(dswr)) {
            vmsp.setParityValidationEnable(!vmsp.getParityValidationEnable());
            updateMediaScan = true;
        }
        if (updateMediaScan) {
            if (!vmsp.getEnable()) {
                vmsp.setParityValidationEnable(false);
            }
            Trace.verbose((Object)this, "modifyDiskScrubbing", "Trying to update volume media scan parameters.");
            this.setVolumeMediaScanParams(volume, vmsp, arrayWwn);
        }
    }

    private String checkProfileModification(String arrayWwn, Profile prof, devmgr.versioned.symbol.Volume ozVol, Properties props) throws ConfigMgmtException {
        String METHOD_NAME = "checkProfileModification";
        ProfileDataManager pdm = new ProfileDataManager(arrayWwn);
        PoolDataManager pooldm = new PoolDataManager(arrayWwn);
        String newPoolName = props.getProperty("poolName");
        String newPoolKey = props.getProperty("poolKey");
        String newPoolId = null;
        if (newPoolName != null && !newPoolName.equals("") || newPoolKey != null && !newPoolKey.equals("")) {
            ManagePools poolManager = new ManagePools();
            if (newPoolName != null) {
                SearchFilter poolNameFilter = new SearchFilter("name", newPoolName);
                poolManager.init(this.context, this.scope, poolNameFilter);
                List pools = poolManager.getItemList();
                if (pools.size() != 1) {
                    Trace.verbose((Object)this, "checkProfileModification", "Unable to find pool with name " + newPoolName);
                    throw new SEItemNotFoundException(newPoolName);
                }
                newPoolKey = ((Pool)pools.get(0)).getKeyAsString();
            }
            if (newPoolKey != null && !newPoolKey.trim().equals("")) {
                newPoolId = (String)Convert.keyAsStringToMap(newPoolKey).get("id");
            }
            PoolData pd = pooldm.getPoolData(newPoolId);
            Profile profile = pdm.getProfile(pd.profileId);
            this.setNewProfileData(prof, profile);
        }
        return newPoolId;
    }

    private void setNewProfileData(Profile prof, Profile profile) {
        prof.setArrayType(profile.getArrayType());
        prof.setDedicatedSpare(profile.dedicatedSpareExists());
        prof.setDescription(profile.getDescription());
        prof.setDriveType(profile.getDriveType());
        prof.setFactoryProfile(profile.isFactoryProfile());
        prof.setImportStatus(profile.getImportStatus());
        prof.setInUse(profile.isInUse());
        prof.setKey(profile.getKey());
        prof.setName(profile.getName());
        prof.setNumberOfDisks(profile.getNumberOfDisks());
        prof.setObjectItemType(profile.getObjectItemType());
        prof.setRaidLevel(profile.getRaidLevel());
        prof.setReadAheadEnabled(profile.isReadAheadEnabled());
        prof.setSegmentSize(profile.getSegmentSize());
        prof.setWriteCacheEnabled(profile.isWriteCacheEnabled());
    }

    public List getAvailableLUNs(String arrayID) throws SEItemNotFoundException, ConfigMgmtException {
        return null;
    }

    public static Map getVolumeKeyMap(String arrayWwn, String volumeRef, String volumeName, String volumeWwn) {
        HashMap<String, String> key = new HashMap<String, String>(4);
        key.put("array", arrayWwn);
        key.put("volumeRef", volumeRef);
        key.put("volumeName", volumeName);
        key.put("volumeWwn", volumeWwn);
        return key;
    }

    private Map getKeyMapFromKeyAsStringFilter() {
        String keyAsString;
        Map keyMap = null;
        if (this.filter != null && !this.filter.isEmpty() && this.filter.getSearchField().equals("keyAsString") && (keyAsString = this.filter.getSearchString()) != null) {
            keyMap = Convert.keyAsStringToMap(keyAsString);
        }
        return keyMap;
    }

    private boolean checkVolumeKeyMap(Map key, String arrayWwn, String volumeRef, String volumeName, String volumeWwn) {
        return key != null && key.get("array") != null && key.get("volumeWwn") != null && ((String)key.get("array")).equals(arrayWwn) && ((String)key.get("volumeWwn")).equals(volumeWwn);
    }

    void setVolumeUserLabel(devmgr.versioned.symbol.Volume volume, String volumeName, String arrayWwn) throws ConfigMgmtException {
        String METHOD_NAME = "setVolumeUserLabel";
        Trace.methodBegin(this, "setVolumeUserLabel");
        VolumeLabelUpdateDescriptor vlud = new VolumeLabelUpdateDescriptor();
        vlud.setVolumeRef((AbstractVolRef)volume.getVolumeRef());
        UserAssignedLabel ual = new UserAssignedLabel();
        ual.setValue(UnicodeTranslator.getBytes((String)volumeName));
        vlud.setLabel(ual);
        this.modifyVolume((XDRType)vlud, arrayWwn, volume.getCurrentManager());
    }

    void startVolumeExpansion(devmgr.versioned.symbol.Volume volume, long volumeSize, String arrayWwn) throws ConfigMgmtException {
        String METHOD_NAME = "startVolumeExpansion";
        Trace.methodBegin(this, "startVolumeExpansion");
        VolumeExpansionDescriptor ved = new VolumeExpansionDescriptor();
        ved.setVolumeRef((LegacyVolRef)volume.getVolumeRef());
        ved.setNewCapacity(volumeSize);
        this.modifyVolume((XDRType)ved, arrayWwn, volume.getCurrentManager());
    }

    void startVolumeSegmentSizing(devmgr.versioned.symbol.Volume volume, int segmentSize, String arrayWwn) throws ConfigMgmtException {
        String METHOD_NAME = "startVolumeSegmentSizing";
        Trace.methodBegin(this, "startVolumeSegmentSizing");
        Trace.verbose((Object)this, "startVolumeSegmentSizing", "Trying to modify volume segment size to: " + segmentSize);
        VolumeSegmentSizingDescriptor vssd = new VolumeSegmentSizingDescriptor();
        vssd.setVolumeRef((AbstractVolRef)volume.getVolumeRef());
        vssd.setNewSegmentSize(segmentSize);
        this.modifyVolume((XDRType)vssd, arrayWwn, volume.getCurrentManager());
    }

    void setVolumeMediaScanParams(devmgr.versioned.symbol.Volume volume, VolumeMediaScanParams newVmsp, String arrayWwn) throws ConfigMgmtException {
        String METHOD_NAME = "setVolumeMediaScanParams";
        Trace.methodBegin(this, "setVolumeMediaScanParams");
        VolumeMediaScanParamsUpdateDescriptor vmspud = new VolumeMediaScanParamsUpdateDescriptor();
        vmspud.setVolumeRef((AbstractVolRef)volume.getVolumeRef());
        vmspud.setNewParams(newVmsp);
        this.modifyVolume((XDRType)vmspud, arrayWwn, volume.getCurrentManager());
    }

    void setVolumeCacheParams(devmgr.versioned.symbol.Volume volume, VolumeCache newVolumeCache, String arrayWwn) throws ConfigMgmtException {
        String METHOD_NAME = "setVolumeCacheParams";
        Trace.methodBegin(this, "setVolumeCacheParams");
        VolumeCacheParamsUpdateDescriptor vcpud = new VolumeCacheParamsUpdateDescriptor();
        vcpud.setCacheFlushModifier(newVolumeCache.getCacheFlushModifier());
        vcpud.setCwob(newVolumeCache.getCwob());
        vcpud.setMirrorEnable(newVolumeCache.getMirrorEnable());
        vcpud.setReadAheadMultiplier(newVolumeCache.getReadAheadMultiplier());
        vcpud.setVolumeRef((AbstractVolRef)volume.getVolumeRef());
        vcpud.setReadCacheEnable(newVolumeCache.getReadCacheEnable());
        vcpud.setWriteCacheEnable(newVolumeCache.getWriteCacheEnable());
        this.modifyVolume((XDRType)vcpud, arrayWwn, volume.getCurrentManager());
    }

    void assignVolumeOwnership(devmgr.versioned.symbol.Volume volume, ControllerRef newOwningControllerRef, String arrayWwn) throws ConfigMgmtException {
        String METHOD_NAME = "assignVolumeOwnership";
        Trace.methodBegin(this, "assignVolumeOwnership");
        VolumeOwnershipUpdateDescriptor voud = new VolumeOwnershipUpdateDescriptor();
        voud.setVolumeRef((AbstractVolRef)volume.getVolumeRef());
        voud.setManager(newOwningControllerRef);
        this.modifyVolume((XDRType)voud, arrayWwn, newOwningControllerRef);
    }

    void setVolumeParams(devmgr.versioned.symbol.Volume volume, int reconPriority, String arrayWwn) throws ConfigMgmtException {
        String METHOD_NAME = "setVolumeParams";
        Trace.methodBegin(this, "setVolumeParams");
        VolumeParamsUpdateDescriptor vpud = new VolumeParamsUpdateDescriptor();
        vpud.setVolumeRef((AbstractVolRef)volume.getVolumeRef());
        vpud.setReconPriority(reconPriority);
        this.modifyVolume((XDRType)vpud, arrayWwn, volume.getCurrentManager());
    }

    private void modifyVolume(XDRType modifyDescriptor, String arrayWwn, ControllerRef owningControllerRef) throws ConfigMgmtException {
        String METHOD_NAME = "modifyVolume";
        Trace.methodBegin(this, "modifyVolume");
        String modifyAction = null;
        try {
            int codeValue;
            ReturnCode code = new ReturnCode();
            CommandProcessor command = new CommandProcessor(arrayWwn);
            command.setPreferredController(Convert.bytesToString(owningControllerRef.getRefToken()));
            if (modifyDescriptor instanceof VolumeLabelUpdateDescriptor) {
                modifyAction = "Volume name update ";
                command.execute(31, modifyDescriptor, (XDRType)code, true);
            } else if (modifyDescriptor instanceof VolumeExpansionDescriptor) {
                modifyAction = "Volume expansion ";
                command.execute(95, modifyDescriptor, (XDRType)code, true);
            } else if (modifyDescriptor instanceof VolumeSegmentSizingDescriptor) {
                modifyAction = "Volume segment sizing ";
                command.execute(23, modifyDescriptor, (XDRType)code, true);
            } else if (modifyDescriptor instanceof VolumeCacheParamsUpdateDescriptor) {
                modifyAction = "Volume cache parameters update ";
                command.execute(29, modifyDescriptor, (XDRType)code, true);
            } else if (modifyDescriptor instanceof VolumeOwnershipUpdateDescriptor) {
                modifyAction = "Volume ownership update ";
                command.execute(90, modifyDescriptor, (XDRType)code, true);
            } else if (modifyDescriptor instanceof VolumeParamsUpdateDescriptor) {
                modifyAction = "Volume modification priority update ";
                command.execute(30, modifyDescriptor, (XDRType)code, true);
            } else if (modifyDescriptor instanceof VolumeAttributeUpdateDescriptor) {
                modifyAction = "move volume to pool using proc: 159";
                Trace.verbose((Object)this, "modifyVolume", "New volume attribute should be:" + ((VolumeAttributeUpdateDescriptor)modifyDescriptor).getMgmtClientAttribute());
                command.execute(159, modifyDescriptor, (XDRType)code, true);
            } else if (modifyDescriptor instanceof VolumeMediaScanParamsUpdateDescriptor) {
                modifyAction = "Volume media scan parameters update ";
                command.execute(46, modifyDescriptor, (XDRType)code, true);
            } else {
                throw new ConfigMgmtException("incorrect.method.parameter", "Object type passed not supported.");
            }
            int n = codeValue = code != null ? code.getValue() : -1;
            if (codeValue != 1) {
                String message = modifyAction + " failed with the error code: " + codeValue;
                Trace.verbose((Object)this, "modifyVolume", message);
                throw new ConfigMgmtException(ErrorDescriptor.ERROR_REASON_PREFIX + (OZErrorCode.ERROR_CODE_MIN + codeValue), message);
            }
            Trace.verbose((Object)this, "modifyVolume", modifyAction + " successfully started.");
        }
        catch (RPCError e) {
            Trace.error((Object)this, "modifyVolume", (Throwable)e);
            throw new ConfigMgmtException(ErrorCode.ERROR_RPC.getKey(), modifyAction + " failed with RPCError.", (Exception)((Object)e));
        }
        catch (IOException e) {
            Trace.error((Object)this, "modifyVolume", (Throwable)e);
            throw new ConfigMgmtException(ErrorCode.ERROR_COMMUNICATING_WITH_ARRAY.getKey(), modifyAction + " failed with IOException.", e);
        }
    }

    private Controller getAlternateController(ControllerRef controllerRef, String arrayWwn) throws ConfigMgmtException {
        Controller controller = null;
        Object currentName = null;
        Controller[] controllers = ObjectBundleManager.getInstance().getObjectBundle(arrayWwn).getController();
        if (controllerRef != null) {
            int size = controllers == null ? 0 : controllers.length;
            for (int i = 0; i < size; ++i) {
                if (Convert.bytesToStringRaw(controllerRef.getRefToken()).equals(Convert.bytesToStringRaw(controllers[i].getControllerRef().getRefToken()))) continue;
                controller = controllers[i];
                break;
            }
        }
        return controller;
    }

    private String getArrayWwnFromScope() throws ConfigMgmtException {
        if (this.scope != null) {
            return Convert.scopeToArrayKey(this.scope);
        }
        throw new ConfigMgmtException("error.scope.required", "Array scope not set before using of the volume manager.");
    }

    private Controller getControllerForName(Controller[] controllers, String controllerName) throws ConfigMgmtException {
        Controller controller = null;
        String currentName = null;
        if (controllerName != null) {
            int size = controllers == null ? 0 : controllers.length;
            for (int i = 0; i < size; ++i) {
                String string = currentName = controllers[i].getPhysicalLocation().getSlot() == 1 ? "A" : "B";
                if (!controllerName.equals(currentName)) continue;
                controller = controllers[i];
                break;
            }
        }
        if (controller == null) {
            throw new ConfigMgmtException("error.no.controller", "Unable to lookup controller with name = " + controllerName);
        }
        return controller;
    }

    static devmgr.versioned.symbol.Volume getVolumeForWwn(devmgr.versioned.symbol.Volume[] volumes, String volumeWwnString) throws ConfigMgmtException {
        devmgr.versioned.symbol.Volume volume = null;
        if (volumeWwnString != null) {
            int size = volumes == null ? 0 : volumes.length;
            for (int i = 0; i < size; ++i) {
                if (!volumeWwnString.equals(Convert.bytesToString(volumes[i].getWorldWideName()))) continue;
                volume = volumes[i];
                break;
            }
        }
        if (volume == null) {
            throw new ConfigMgmtException("volume.lookup.error", "Unable to lookup volume with wwn = " + volumeWwnString);
        }
        return volume;
    }

    private devmgr.versioned.symbol.Volume[] getAllOZVolumesOnArray(String arrayWwn) throws ConfigMgmtException {
        String METHOD_NAME = "getAllOZVolumesOnArray";
        Trace.methodBegin(this, "getAllOZVolumesOnArray");
        try {
            CommandProcessor command = new CommandProcessor(arrayWwn);
            ObjectBundle bundle = new ObjectBundle();
            command.execute(40, null, (XDRType)bundle, false);
            return bundle.getVolume();
        }
        catch (RPCError e) {
            Trace.error((Object)this, "getAllOZVolumesOnArray", (Throwable)e);
            throw new ConfigMgmtException(ErrorCode.ERROR_RPC.getKey(), "RPCError trying to get all volumes on the array.", (Exception)((Object)e));
        }
        catch (IOException e) {
            Trace.error((Object)this, "getAllOZVolumesOnArray", (Throwable)e);
            throw new ConfigMgmtException(ErrorCode.ERROR_COMMUNICATING_WITH_ARRAY.getKey(), "IOException trying to get all volumes on the array.", e);
        }
    }

    public void resetVolumeSettings(Volume volume) throws ConfigMgmtException {
        String METHOD_NAME = "resetVolumeSettings";
        Trace.methodBegin(this, "resetVolumeSettings");
        if (volume == null) {
            throw new ConfigMgmtException("incorrect.method.parameter", "Must supply a volume for: resetVolumeSettings");
        }
        if (volume.getProfileName() == null) {
            Trace.verbose((Object)this, "resetVolumeSettings", "Volume doesn't belong to a pool.");
            return;
        }
        String arrayWwn = this.getArrayWwnFromScope();
        Profile profile = null;
        ManageProfiles profileManager = new ManageProfiles();
        profileManager.init(this.context, new Scope(this.scope), new SearchFilter("name", volume.getProfileName()));
        List pl = profileManager.getItemList();
        if (pl != null && !pl.isEmpty()) {
            profile = (Profile)pl.get(0);
        }
        if (profile == null) {
            String msg = "Failed to obtain current profile from name: " + volume.getProfileName();
            Trace.verbose((Object)this, "resetVolumeSettings", msg);
            throw new ConfigMgmtException("error.systemError", msg);
        }
        ObjectBundleManager manager = ObjectBundleManager.getInstance();
        devmgr.versioned.symbol.Volume ozVolume = ManageVolumes.getVolumeForWwn(manager.getObjectBundle(arrayWwn).getVolume(), volume.getWwn());
        this.matchOZVolumeWithProfile(ozVolume, null, profile, arrayWwn, "" + ozVolume.getMgmtClientAttribute());
    }

    private void matchOZVolumeWithProfile(devmgr.versioned.symbol.Volume volume, VolumeCache newVolumeCache, Profile profile, String arrayWwn, String newPoolId) throws ConfigMgmtException {
        String METHOD_NAME = "matchOZVolumeWithProfile";
        Trace.methodBegin(this, "matchOZVolumeWithProfile");
        int readAhead = -1;
        ManagePools poolsManager = new ManagePools();
        poolsManager.init(this.context, this.scope, null);
        int volumeRaidLevel = volume.getRaidLevel().getValue();
        int volumeSegmentSize = volume.getSegmentSize();
        ManagePools.VDiskDriveInfo vddi = poolsManager.getVDiskDriveInfoForVolumeWwn(Convert.bytesToString(volume.getWorldWideName()));
        Profile volumeProfile = new Profile();
        volumeProfile.setRaidLevel(volumeRaidLevel);
        volumeProfile.setSegmentSize(ProfileDataManager.convertSegSizeBytesToProfileSegSize(volumeSegmentSize));
        volumeProfile.setDriveType(ProfileDataManager.convert6130DriveTypeToProfileDriveType(vddi.getDriveType()));
        volumeProfile.setNumberOfDisks(vddi.getNumberOfDisks());
        String poolId = volume.getMgmtClientAttribute() + "";
        List volsOnTheVdisk = null;
        ArrayList vdisksUsedByVol = new ArrayList();
        volsOnTheVdisk = poolsManager.getVolsOnVidskAndVdisksForVolume(volsOnTheVdisk, vdisksUsedByVol, volume);
        Trace.verbose((Object)this, "matchOZVolumeWithProfile", "Number of volumes on the vdisk:" + volsOnTheVdisk.size());
        List poolsCompatibleWithVolume = poolsManager.getFinalPoolListForVolume(arrayWwn, volumeProfile, volsOnTheVdisk, vdisksUsedByVol);
        poolsManager.validatePoolsProfile(volumeProfile, profile, vdisksUsedByVol, volsOnTheVdisk);
        int n = readAhead = profile.isReadAheadEnabled() ? 3 : 0;
        if (readAhead != volume.getCache().getReadAheadMultiplier() || newVolumeCache != null) {
            if (newVolumeCache == null) {
                newVolumeCache = volume.getCache();
            }
            newVolumeCache.setReadAheadMultiplier(readAhead);
            Trace.verbose((Object)this, "matchOZVolumeWithProfile", "Trying to set volume cache parameters.");
            this.setVolumeCacheParams(volume, newVolumeCache, arrayWwn);
        }
        Trace.verbose((Object)this, "matchOZVolumeWithProfile", "validateSegmentSize");
        int uiVolumeSegmentSize = ProfileDataManager.convertSegSizeBytesToProfileSegSize(volume.getSegmentSize());
        if (profile.getSegmentSize() != uiVolumeSegmentSize) {
            Trace.verbose((Object)this, "matchOZVolumeWithProfile", "Trying to set volume segment size.");
            this.startVolumeSegmentSizing(volume, ManageVolumes.convertSegmentSize(profile.getSegmentSize()), arrayWwn);
        }
        if (profile.getRaidLevel() != volumeRaidLevel) {
            ManageVDisks mVDisks = new ManageVDisks();
            mVDisks.init(this.context, this.scope, null);
            Properties prop = new Properties();
            prop.setProperty("raidLevel", "" + profile.getRaidLevel());
            Map vdiskKey = ManageVDisks.getVDiskKeyMap(arrayWwn, Convert.bytesToStringRaw(volume.getVolumeGroupRef().getRefToken()), null);
            mVDisks.modify(vdiskKey, prop);
        }
        Trace.verbose((Object)this, "matchOZVolumeWithProfile", "Update volume attribute - move it to the correct pool:" + newPoolId);
        Trace.verbose((Object)this, "matchOZVolumeWithProfile", "Current volume pool:" + volume.getMgmtClientAttribute());
        this.updateVolumePool(volume, arrayWwn, newPoolId);
        Trace.verbose((Object)this, "matchOZVolumeWithProfile", "Done!");
    }

    private void updateVolumePool(devmgr.versioned.symbol.Volume volume, String arrayWwn, String newPoolId) throws ConfigMgmtException {
        VolumeAttributeUpdateDescriptor vaud = new VolumeAttributeUpdateDescriptor();
        vaud.setMgmtClientAttribute(Integer.parseInt(newPoolId));
        vaud.setVolumeRef((AbstractVolRef)volume.getVolumeRef());
        this.modifyVolume((XDRType)vaud, arrayWwn, volume.getPreferredManager());
    }

    public static String getVolumeID(byte[] wwn) {
        StringBuffer sbuf = new StringBuffer();
        for (int i = 10; i <= 15; ++i) {
            sbuf.append(Convert.toHex(wwn[i], 2));
        }
        return sbuf.toString().toUpperCase();
    }

    public int getMinNumberOfDisksForCreation(BigInteger volumeSize, Profile profile) throws ConfigMgmtException {
        String arrayWwn = this.getArrayWwnFromScope();
        int raidLevel = profile.getRaidLevel();
        int driveType = ProfileDataManager.convertProfileDriveTypeTo6130DriveType(profile.getDriveType());
        int numberOfDisks = profile.getNumberOfDisks();
        CandidateSelectionTypeData selection = new CandidateSelectionTypeData();
        selection.setCandidateSelectionType(new CandidateSelectionType(3));
        CommandProcessor command = ManageVolumes.getCommandProcessor(arrayWwn);
        VolumeCandidate[] candidates = this.getVolumeCandidates(selection, raidLevel, arrayWwn, driveType, command);
        int minNumberOfDisks = -1;
        for (int i = 0; i < candidates.length; ++i) {
            if (!this.candidateMatch(candidates[i], volumeSize.longValue(), driveType, raidLevel, numberOfDisks) || minNumberOfDisks != -1 && minNumberOfDisks <= candidates[i].getDriveCount()) continue;
            minNumberOfDisks = candidates[i].getDriveCount();
        }
        return minNumberOfDisks;
    }

    public void validateDisksForCreation(BigInteger volumeSize, List diskKeys, Profile profile) throws ConfigMgmtException {
        if (diskKeys == null || profile == null || volumeSize == null) {
            throw new ConfigMgmtException("incorrect.method.parameter", "Null passed to the validateDisksForCreation method.");
        }
        String arrayWwn = this.getArrayWwnFromScope();
        String[] diskKeysAsStrings = new String[diskKeys.size()];
        for (int i = 0; i < diskKeys.size(); ++i) {
            diskKeysAsStrings[i] = (String)diskKeys.get(i);
        }
        ObjectBundle bundle = ObjectBundleManager.getInstance().getObjectBundle(arrayWwn);
        int raidLevel = profile.getRaidLevel();
        int driveType = ProfileDataManager.convertProfileDriveTypeTo6130DriveType(profile.getDriveType());
        int numberOfDisks = profile.getNumberOfDisks();
        DriveRefList driveRefList = ManageVolumes.createDriveRefList(diskKeysAsStrings, numberOfDisks, driveType, bundle.getDrive());
        CandidateSelectionTypeData selection = new CandidateSelectionTypeData();
        selection.setCandidateSelectionType(new CandidateSelectionType(2));
        selection.setDriveRefList(driveRefList);
        CommandProcessor command = ManageVolumes.getCommandProcessor(arrayWwn);
        VolumeCandidate[] candidates = this.getVolumeCandidates(selection, raidLevel, arrayWwn, driveType, command);
        boolean disksValid = false;
        for (int i = 0; i < candidates.length; ++i) {
            if (!this.candidateMatch(candidates[i], volumeSize.longValue(), driveType, raidLevel, numberOfDisks)) continue;
            disksValid = true;
            break;
        }
        if (!disksValid) {
            throw new ConfigMgmtException("volume.create.error.invalid.disk.size", "There is no valid volume candidate for the size specified.");
        }
    }

    public Map getMapOfMinNumberOfDisksForCreation(BigInteger volumeSize) throws ConfigMgmtException {
        String arrayWwn = this.getArrayWwnFromScope();
        CandidateSelectionTypeData selection = new CandidateSelectionTypeData();
        selection.setCandidateSelectionType(new CandidateSelectionType(3));
        CommandProcessor command = ManageVolumes.getCommandProcessor(arrayWwn);
        VolumeCandidate[] candidates = this.getVolumeCandidates(selection, -1, arrayWwn, 0, command);
        HashMap<Integer, Integer> minDisksByRaid = new HashMap<Integer, Integer>(4);
        Integer currentRaid = null;
        Integer minDisks = null;
        long volumeSizeLong = volumeSize.longValue();
        for (int i = 0; i < candidates.length; ++i) {
            if (candidates[i].getUsableSize() < volumeSizeLong) continue;
            currentRaid = new Integer(candidates[i].getRaidLevel().getValue());
            minDisks = (Integer)minDisksByRaid.get(currentRaid);
            if (minDisks != null) {
                if (minDisks <= candidates[i].getDriveCount()) continue;
                minDisksByRaid.put(currentRaid, new Integer(candidates[i].getDriveCount()));
                continue;
            }
            minDisksByRaid.put(currentRaid, new Integer(candidates[i].getDriveCount()));
        }
        return minDisksByRaid;
    }

    public boolean volNameUsed(String volName) throws ConfigMgmtException {
        devmgr.versioned.symbol.Volume volume = null;
        String arrayWwn = this.getArrayWwnFromScope();
        ObjectBundle bundle = ObjectBundleManager.getInstance().getObjectBundle(arrayWwn);
        CommandProcessor cmd = null;
        try {
            cmd = new CommandProcessor(arrayWwn);
        }
        catch (Exception e) {
            throw new ConfigMgmtException("error.communicating", "Error communicating with array");
        }
        cmd.execute(40, null, (XDRType)bundle, false);
        return bundle != null && bundle.getVolume() != null && (volume = this.getVolumeForName(bundle.getVolume(), volName)) != null;
    }

    private MethodCallStatus deleteAnyMappings(String currentVolumeKey) throws ConfigMgmtException {
        String methodName = "deleteAnyMappings";
        Scope mapScope = new Scope(this.scope);
        mapScope.setAttribute("volume", currentVolumeKey);
        mapScope.removeAttribute("host");
        mapScope.removeAttribute("hostGroup");
        ManageMappingsInterface mngMappings = ManageMappingsFactory.getManager(this.context, mapScope, null);
        MethodCallStatus result = null;
        List list = new ArrayList();
        list = mngMappings.getItemList();
        if (list.size() > 0) {
            ArrayList<String> keys = new ArrayList<String>();
            keys.add(currentVolumeKey);
            result = mngMappings.delete(keys);
        }
        mapScope.removeAttribute("volume");
        return result;
    }

    private MethodCallStatus deleteAnySnapshots(String currentVolumeKey) throws ConfigMgmtException {
        String methodName = "deleteAnySnapshots";
        Scope snapScope = new Scope(this.scope);
        snapScope.setAttribute("reference", currentVolumeKey);
        ManageSnapShotServicesInterface manager = ManageDataServicesFactory.getSnapShotServicesManager(this.context, snapScope, null);
        MethodCallStatus result = null;
        List list = new ArrayList();
        list = manager.getItemList();
        if (list.size() > 0) {
            ArrayList<String> deleteKeys = new ArrayList<String>();
            SnapShotVolume snapVol = null;
            String snapName = null;
            for (int i = 0; i < list.size(); ++i) {
                snapVol = (SnapShotVolume)list.get(i);
                snapName = snapVol.getName();
                deleteKeys.add("volumeName==" + snapName);
            }
            result = manager.delete(deleteKeys);
        }
        snapScope.removeAttribute("reference");
        return result;
    }

    private MethodCallStatus deleteReplicationSet(String arrayWwn, String volumeWwn) throws ConfigMgmtException {
        String METHOD_NAME = "deleteReplicationSet";
        Trace.methodBegin(this, "deleteReplicationSet");
        MethodCallStatus result = null;
        Scope repsetScope = new Scope(this.scope);
        repsetScope.setAttribute("array", arrayWwn);
        ManageReplicationServices manageReplicationServices = (ManageReplicationServices)ManageDataServicesFactory.getReplicationServicesManager(this.context, this.scope, null);
        HashMap<String, String> myMap = new HashMap<String, String>();
        myMap.put("array", arrayWwn);
        myMap.put("volumeWwn", volumeWwn);
        ArrayList<HashMap<String, String>> myList = new ArrayList<HashMap<String, String>>();
        myList.add(myMap);
        result = manageReplicationServices.delete(myList);
        if (result.getReturnCode() == 0) {
            return null;
        }
        Trace.methodEnd(this, "deleteReplicationSet");
        return result;
    }

    private ErrorDescriptor deleteMissingVolume(CommandProcessor command, GhostVolume missingVol) throws ConfigMgmtException {
        String METHOD_NAME = "deleteReplicationSet";
        Trace.methodBegin(this, "deleteReplicationSet");
        ErrorDescriptor result = null;
        ReturnCode rc = new ReturnCode();
        command.execute(9, (XDRType)missingVol.getVolumeRef(), (XDRType)rc, true);
        int returnCode = rc.getValue();
        String message = "Code " + returnCode + " returned when deleting the missing volume " + Convert.bytesToString(missingVol.getWorldWideName());
        if (returnCode != 1) {
            Trace.error((Object)this, "deleteReplicationSet", message);
            result = new ErrorDescriptor(OZErrorCode.getErrorCode(ErrorCode.ERROR_DELETE_VOLUME.getKey(), returnCode));
            result.setMsg(message);
        } else {
            Trace.verbose((Object)this, "deleteReplicationSet", message);
        }
        Trace.methodEnd(this, "deleteReplicationSet");
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static interface SearchType
    extends ManagerInterface.CommonSearchTypes {
        public static final String WWN = "wwn";
        public static final String PROFILE_NAME = "profileName";
        public static final String VOLUMES_WITHOUT_MAPPINGS = "volumesWithoutMappings";
        public static final String VOLUMES_FOR_REPLICATION_SET_PEER_ARRAY_WWN = "volumesForReplicationSetPeerArrayWwn";
        public static final String VOLUMES_FOR_REPLICATION_SET_VOLUME_WWN = "volumesForReplicationSetVolumeWwn";
        public static final String VOLUMES_REPLICATION_SET_METADATA_VOLUME = "volumesReplicationSetMetadataVolume";
        public static final String VOLUMES_NOT_REPLICATED = "volumesNotReplicated";
        public static final String INCLUDE_REPOSITORIES = "includeRepositories";
        public static final String INCLUDE_MISSING_VOLUMES_WITH_FILTER = "includeMissingWithFilter";
    }

    public static interface KeyMap {
        public static final String ARRAY = "array";
        public static final String VOLUME_REF = "volumeRef";
        public static final String VOLUME_NAME = "volumeName";
        public static final String VOLUME_WWN = "volumeWwn";
    }

    public static interface ModifyProps {
        public static final String NAME = "name";
        public static final String POOL_KEY = "poolKey";
        public static final String POOL_NAME = "poolName";
        public static final String SIZE = "size";
        public static final String EXTENSION_SIZE = "extensionSize";
        public static final String CONTROLLER = "controller";
        public static final String MODIFICATION_PRIORITY = "modificationPriority";
        public static final String SEGMENT_SIZE = "segmentSize";
        public static final String READ_CACHE = "readCache";
        public static final String WRITE_CACHE = "writeCache";
        public static final String WRITE_CACHE_WITH_MIRRORING = "writeCacheWithMirroring";
        public static final String WRITE_CACHE_WITHOUT_BATTERIES = "writeCacheWithoutBatteries";
        public static final String DISK_SCRUBBING = "diskScrubbing";
        public static final String DISK_SCRUBBING_WITH_REDUNDANCY = "diskScrubbingWithRedundancy";
    }

    public static interface CreateProps {
        public static final String POOL_KEY = "poolKey";
        public static final String VOLUME_SIZE = "volumeSize";
        public static final String VDISK_KEY = "vdiskKey";
        public static final String NUMBER_OF_DISKS = "numberOfDisks";
        public static final String VOLUME_NAME = "volumeName";
        public static final String LIST_OF_DISK_KEYS = "listOfDiskKeys";
    }
}

