/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz;

import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.impl.ObjectBundleManager;
import com.sun.netstorage.array.mgmt.cfg.core.logic.SearchFilter;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageT4sInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.T4Interface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.T4;
import devmgr.versioned.symbol.Drive;
import devmgr.versioned.symbol.ObjectBundle;
import devmgr.versioned.symbol.SAData;
import devmgr.versioned.symbol.StorageArray;
import devmgr.versioned.symbol.UnicodeTranslator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class ManageT4s
implements ManageT4sInterface {
    public void init(ConfigContext context, SearchFilter filter) throws ConfigMgmtException {
    }

    public List getItemList() throws ConfigMgmtException {
        Trace.methodBegin(this, "getItemsBySystem");
        Collection bundles = ObjectBundleManager.getInstance().getObjectBundles();
        ArrayList<T4> arrayList = new ArrayList<T4>();
        Iterator iter = bundles.iterator();
        while (iter.hasNext()) {
            ObjectBundle bundle = (ObjectBundle)iter.next();
            StorageArray sa = bundle.getSa();
            T4 array = new T4();
            SAData data = sa.getSaData();
            array.setName(UnicodeTranslator.getString((byte[])data.getStorageArrayLabel().getValue()));
            Trace.verbose((Object)this, "getItemsList", "ArrayName:" + array.getName());
            array.setHealthStatus(data.getNeedsAttention() ? 6 : 2);
            array.setFirmwareVersion(UnicodeTranslator.getString((byte[])data.getFwVersion()));
            array.setAhsPoolSize(this.getNumOfHS(bundle));
            arrayList.add(array);
        }
        return arrayList;
    }

    private int getNumOfHS(ObjectBundle bundle) {
        int numOfHS = 0;
        Drive[] ozDisks = bundle.getDrive();
        int size = ozDisks == null ? 0 : ozDisks.length;
        for (int i = 0; i < size; ++i) {
            if (!ozDisks[i].getHotSpare()) continue;
            ++numOfHS;
        }
        return numOfHS;
    }

    public T4Interface getT4ByName(String name) throws ConfigMgmtException {
        Trace.methodBegin(this, "getItemsBySystem");
        Collection bundles = ObjectBundleManager.getInstance().getObjectBundles();
        T4 array = null;
        Iterator iter = bundles.iterator();
        while (iter.hasNext() && array == null) {
            ObjectBundle bundle = (ObjectBundle)iter.next();
            StorageArray sa = bundle.getSa();
            String aName = UnicodeTranslator.getString((byte[])sa.getSaData().getStorageArrayLabel().getValue());
            if (!aName.equals(name)) continue;
            T4 a1 = new T4();
            SAData data = sa.getSaData();
            a1.setName(UnicodeTranslator.getString((byte[])data.getStorageArrayLabel().getValue()));
            a1.setHealthStatus(data.getNeedsAttention() ? 6 : 2);
            a1.setFirmwareVersion(UnicodeTranslator.getString((byte[])data.getFwVersion()));
            a1.setAhsPoolSize(0);
            array = a1;
        }
        return array;
    }

    public T4Interface getT4ByIP(String ip) throws ConfigMgmtException {
        return null;
    }

    public boolean areAllArraysHealthy() throws ConfigMgmtException {
        return false;
    }

    public List getPossibleDuplicateArrays(T4Interface srcT4, List possibleDestinations) throws ConfigMgmtException {
        return null;
    }

    public T4Interface getByKey(Collection key) throws ConfigMgmtException {
        return null;
    }
}

