/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz;

import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.ErrorCode;
import com.sun.netstorage.array.mgmt.cfg.core.ErrorDescriptor;
import com.sun.netstorage.array.mgmt.cfg.core.ManagerInterface;
import com.sun.netstorage.array.mgmt.cfg.core.MethodCallStatus;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.BadParameterException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.SEItemNotFoundException;
import com.sun.netstorage.array.mgmt.cfg.core.logic.Scope;
import com.sun.netstorage.array.mgmt.cfg.core.logic.SearchFilter;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageProfilesInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ProfileInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ManageArrays;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ManagePools;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.Pool;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.PoolData;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.PoolDataManager;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.Profile;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ProfileDataManager;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.StorageArray;
import com.sun.netstorage.array.mgmt.cfg.util.Convert;
import com.sun.netstorage.array.mgmt.logger.LogAPI;
import devmgr.versioned.jrpc.RPCError;
import java.io.IOException;
import java.rmi.server.UID;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class ManageProfiles
implements ManageProfilesInterface {
    Scope scope = null;
    SearchFilter filter = null;
    ConfigContext context = null;
    public static final int MAX_OZ_DISKS_FOR_PROFILE = 30;
    Map poolMap = null;

    public void init(ConfigContext context, Scope scope, SearchFilter filter) throws ConfigMgmtException {
        Trace.methodBegin(this, "init");
        this.context = context;
        this.scope = scope;
        this.filter = filter;
    }

    /*
     * Enabled aggressive block sorting
     */
    public List getItemList() throws ConfigMgmtException {
        String METHOD = "getItemList";
        String arrayId = null;
        if (this.scope == null) {
            throw new ConfigMgmtException("error.scope.required", "Scope not set");
        }
        arrayId = Convert.scopeToArrayKey(this.scope);
        Trace.verbose((Object)this, "getItemList", arrayId);
        if (this.poolMap == null) {
            this.poolMap = this.mapPools(arrayId);
        }
        ProfileDataManager pdm = new ProfileDataManager(arrayId);
        ArrayList<Profile> forReturn = new ArrayList<Profile>();
        if (this.filter != null && !this.filter.isEmpty()) {
            Profile p;
            Trace.verbose((Object)this, "getItemList", "Applying SearchFilter");
            if (this.filter.getSearchField().equals("name")) {
                forReturn = null;
                Collection possibles = pdm.getRawProfiles();
                Iterator iter = possibles.iterator();
                while (iter.hasNext()) {
                    p = (Profile)iter.next();
                    if (!this.filter.passesFilter(p.getName())) continue;
                    if (forReturn == null) {
                        forReturn = new ArrayList();
                    }
                    forReturn.add(p);
                }
            } else {
                if (!"keyAsString".equals(this.filter.getSearchField())) {
                    Trace.verbose((Object)this, "getItemList", "Search field not supported: " + this.filter.getSearchField());
                    throw new ConfigMgmtException("error.search.field.not.supported", "error.search.field.not.supported: " + this.filter.getSearchField());
                }
                Trace.verbose((Object)this, "getItemList", "Searching by key: " + this.filter.getSearchString());
                Map requestedKey = Convert.keyAsStringToMap(this.filter.getSearchString());
                String profileId = (String)requestedKey.get("id");
                p = pdm.getProfile(profileId);
                if (p == null) {
                    throw new SEItemNotFoundException(profileId);
                }
                forReturn.add(p);
            }
        } else {
            forReturn = new ArrayList(pdm.getRawProfiles());
        }
        if (forReturn == null) {
            forReturn = new ArrayList();
        }
        if (!this.poolMap.isEmpty()) {
            Iterator iter = forReturn.iterator();
            while (iter.hasNext()) {
                Profile p = (Profile)iter.next();
                String profileId = (String)p.getKey().get("id");
                if (this.poolMap.get(profileId) == null) continue;
                p.setInUse(true);
            }
        }
        return forReturn;
    }

    public int getItemCount() throws ConfigMgmtException {
        return this.getItemList().size();
    }

    private Map mapPools(String arrayId) throws ConfigMgmtException {
        PoolDataManager pdm = new PoolDataManager(arrayId);
        Collection rawPools = pdm.getRawPools();
        int sz = rawPools == null ? 0 : rawPools.size();
        this.poolMap = new HashMap();
        Iterator it = rawPools.iterator();
        while (it.hasNext()) {
            PoolData pd = (PoolData)it.next();
            ArrayList<PoolData> pml = (ArrayList<PoolData>)this.poolMap.get(pd.profileId);
            if (pml == null) {
                pml = new ArrayList<PoolData>();
            }
            pml.add(pd);
            this.poolMap.put(pd.profileId, pml);
        }
        return this.poolMap;
    }

    public void modify(Object key, Properties props) throws ConfigMgmtException {
        String METHOD = "modify";
        Trace.methodBegin(this, "modify");
        String arrayId = null;
        if (this.scope == null) {
            LogAPI.staticLog((String)"PROFILE_MODIFY_ERROR", (String[])new String[]{props.getProperty("name")}, (String[])new String[0]);
            throw new ConfigMgmtException("error.scope.required", "Scope not set");
        }
        arrayId = Convert.scopeToArrayKey(this.scope);
        Trace.verbose((Object)this, "modify", arrayId);
        if (props == null) {
            throw new ConfigMgmtException("incorrect.method.parameter", "Must supply a non-null Properties object for modify.");
        }
        List profiles = this.getItemList();
        String profileId = "";
        com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.common.Profile modifyProfile = null;
        Map requestedProfileKey = null;
        if (key instanceof Map) {
            Trace.verbose((Object)this, "modify", "Looking for profile from key.");
            requestedProfileKey = (Map)key;
        } else if (key instanceof String) {
            Trace.verbose((Object)this, "modify", "Looking for profile from string key.");
            requestedProfileKey = Convert.keyAsStringToMap((String)key);
        }
        ProfileDataManager pdm = new ProfileDataManager(arrayId);
        if (requestedProfileKey != null) {
            profileId = (String)requestedProfileKey.get("id");
            modifyProfile = pdm.getProfile(profileId);
        }
        if (modifyProfile == null) {
            Trace.verbose((Object)this, "modify", "Unable to find profile to modify, failing.");
            LogAPI.staticLog((String)"PROFILE_MODIFY_ERROR", (String[])new String[]{props.getProperty("name")}, (String[])new String[0]);
            throw new ConfigMgmtException("incorrect.method.parameter", "Must supply a valid profile for action: modify");
        }
        if (modifyProfile.isFactoryProfile()) {
            String msg = "Not allowed to modify a factory profile: " + modifyProfile.getName();
            Trace.verbose((Object)this, "modify", msg);
            LogAPI.staticLog((String)"PROFILE_MODIFY_ERROR", (String[])new String[]{props.getProperty("name")}, (String[])new String[0]);
            throw new ConfigMgmtException("error.profiles.modify.factoryprofile", msg);
        }
        this.setProfileInUseFlag(arrayId, (Profile)modifyProfile);
        if (Trace.isTraceEnabled(this)) {
            StringBuffer sb = new StringBuffer("Dumping properties: ");
            Iterator<Map.Entry<Object, Object>> entries = props.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry<Object, Object> entry = entries.next();
                sb.append("\n\t" + entry.getKey().toString() + " = " + entry.getValue().toString());
            }
            Trace.verbose((Object)this, "modify", sb.toString());
        }
        Profile cloneBeforeModification = null;
        try {
            cloneBeforeModification = (Profile)((Profile)modifyProfile).clone();
        }
        catch (CloneNotSupportedException e1) {
            Trace.error((Object)this, "modify", (Throwable)e1);
            throw new ConfigMgmtException(e1);
        }
        try {
            this.populateProfileFromProperties(arrayId, cloneBeforeModification, props, false, profiles);
        }
        catch (ConfigMgmtException cme) {
            LogAPI.staticLog((String)"PROFILE_MODIFY_ERROR", (String[])new String[]{props.getProperty("name")}, (String[])new String[0]);
            throw cme;
        }
        if (modifyProfile.isInUse() && !((Profile)modifyProfile).equalSettings(cloneBeforeModification)) {
            String msg = "Not allowed to modify a profile while in use: " + modifyProfile.getName();
            Trace.verbose((Object)this, "modify", msg);
            LogAPI.staticLog((String)"PROFILE_MODIFY_ERROR", (String[])new String[]{props.getProperty("name")}, (String[])new String[0]);
            throw new ConfigMgmtException("PROFILE_IN_USE_ERROR", msg);
        }
        Map map = pdm.getRawProfileMap();
        map.put(profileId, cloneBeforeModification);
        try {
            pdm.saveData(map.values());
            LogAPI.staticLog((String)"PROFILE_MODIFY_SUCCESS", (String[])new String[]{props.getProperty("name")}, (String[])new String[0]);
        }
        catch (RPCError e) {
            Trace.error((Object)this, "modify", (Throwable)e);
            LogAPI.staticLog((String)"PROFILE_MODIFY_ERROR", (String[])new String[]{props.getProperty("name")}, (String[])new String[0]);
            throw new ConfigMgmtException(ErrorDescriptor.ERROR_COMMUNICATING_WITH_ARRAY_KEY, e.getMessage());
        }
        catch (IOException e) {
            Trace.error((Object)this, "modify", (Throwable)e);
            LogAPI.staticLog((String)"PROFILE_MODIFY_ERROR", (String[])new String[]{props.getProperty("name")}, (String[])new String[0]);
            throw new ConfigMgmtException(ErrorDescriptor.ERROR_IO_KEY, e.getMessage());
        }
    }

    public int getMaximumNumberOfDisks() {
        return 30;
    }

    public void create(Properties props) throws ConfigMgmtException {
        String METHOD = "create";
        Trace.methodBegin(this, "create");
        String arrayId = null;
        if (this.scope == null) {
            LogAPI.staticLog((String)"PROFILE_CREATE_ERROR", (String[])new String[]{props.getProperty("name")}, (String[])new String[0]);
            throw new ConfigMgmtException("error.scope.required", "Scope not set");
        }
        arrayId = Convert.scopeToArrayKey(this.scope);
        Trace.verbose((Object)this, "create", arrayId);
        if (props == null) {
            LogAPI.staticLog((String)"PROFILE_CREATE_ERROR", (String[])new String[]{props.getProperty("name")}, (String[])new String[0]);
            throw new ConfigMgmtException("INVALID_PROFILE_NAME", "No properties provided.");
        }
        List profiles = this.getItemList();
        Profile p = new Profile();
        try {
            this.populateProfileFromProperties(arrayId, p, props, true, profiles);
        }
        catch (ConfigMgmtException cme) {
            LogAPI.staticLog((String)"PROFILE_CREATE_ERROR", (String[])new String[]{props.getProperty("name")}, (String[])new String[0]);
            throw cme;
        }
        profiles.add(p);
        try {
            ProfileDataManager pdm = new ProfileDataManager(arrayId);
            pdm.saveData(profiles);
            LogAPI.staticLog((String)"PROFILE_CREATE_SUCCESS", (String[])new String[]{props.getProperty("name")}, (String[])new String[0]);
        }
        catch (RPCError e) {
            LogAPI.staticLog((String)"PROFILE_CREATE_ERROR", (String[])new String[]{props.getProperty("name")}, (String[])new String[0]);
            Trace.error((Object)this, "create", (Throwable)e);
            throw new ConfigMgmtException(ErrorDescriptor.ERROR_COMMUNICATING_WITH_ARRAY_KEY, e.getMessage());
        }
        catch (IOException e) {
            LogAPI.staticLog((String)"PROFILE_CREATE_ERROR", (String[])new String[]{props.getProperty("name")}, (String[])new String[0]);
            Trace.error((Object)this, "create", (Throwable)e);
            throw new ConfigMgmtException(ErrorDescriptor.ERROR_IO_KEY, e.getMessage());
        }
    }

    private void populateProfileFromProperties(String arrayId, Profile p, Properties props, boolean isCreate, List profiles) throws ConfigMgmtException {
        String newVal;
        String newVal2;
        String newDescription;
        String METHOD = "populateProfileFromProperties";
        String newName = props.getProperty("name", null);
        if (newName != null && !newName.equals(p.getName())) {
            ProfileDataManager.validateName(newName);
            if (!ProfileDataManager.nameIsUnique(newName, profiles)) {
                String msg = "Name: " + newName + " already exists.";
                Trace.error((Object)this, "populateProfileFromProperties", msg);
                throw new BadParameterException(newName, "error.objectAlreadyExists");
            }
            p.setName(newName);
        }
        if ((newDescription = props.getProperty("description", null)) != null && !newDescription.equals(p.getDescription())) {
            ProfileDataManager.validateDescription(newDescription);
            p.setDescription(newDescription);
        }
        try {
            newVal2 = props.getProperty("segmentSize");
            if (isCreate || newVal2 != null) {
                p.setSegmentSize(Integer.parseInt(newVal2));
            }
            ProfileDataManager.validateSegmentSize(p.getSegmentSize());
        }
        catch (NumberFormatException e) {
            Trace.error((Object)this, "populateProfileFromProperties", (Throwable)e);
            throw new ConfigMgmtException("INVALID_PROFILE_SEGMENT_SIZE", "Invalid segment size: " + props.getProperty("segmentSize"));
        }
        try {
            newVal2 = props.getProperty("raidLevel");
            if (isCreate || newVal2 != null) {
                p.setRaidLevel(Integer.parseInt(newVal2));
            }
            ProfileDataManager.validateRaidLevel(p.getRaidLevel());
        }
        catch (NumberFormatException e2) {
            Trace.error((Object)this, "populateProfileFromProperties", (Throwable)e2);
            throw new ConfigMgmtException("INVALID_PROFILE_RAID_LEVEL", "Invalid raid level: " + props.getProperty("raidLevel"));
        }
        String ra = props.getProperty("readAheadEnabled", null);
        if (isCreate && ra == null || ra != null && !ra.equalsIgnoreCase(Boolean.TRUE.toString()) && !ra.equalsIgnoreCase(Boolean.FALSE.toString())) {
            throw new ConfigMgmtException("INVALID_PROFILE_READAHEAD_MODE", "Invalid Read ahead mode: " + ra);
        }
        if (ra != null) {
            p.setReadAheadEnabled(ra.equalsIgnoreCase(Boolean.TRUE.toString()));
        }
        try {
            newVal = props.getProperty("driveType");
            if (isCreate || newVal != null) {
                p.setDriveType(Integer.parseInt(newVal));
            }
            ProfileDataManager.validateDriveType(p.getDriveType());
        }
        catch (NumberFormatException nfe) {
            Trace.error((Object)this, "populateProfileFromProperties", (Throwable)nfe);
            throw new ConfigMgmtException("INVALID_PROFILE_DRIVE_TYPE", "Invalid drive type parameter: " + props.getProperty("driveType"));
        }
        try {
            newVal = props.getProperty("numberOfDisks");
            if (isCreate || newVal != null) {
                p.setNumberOfDisks(Integer.parseInt(newVal));
            }
        }
        catch (NumberFormatException e1) {
            Trace.error((Object)this, "populateProfileFromProperties", (Throwable)e1);
            throw new ConfigMgmtException("INVALID_PROFILE_NUMBER_OF_DRIVES", "Invalid number of disks: " + props.getProperty("numberOfDisks"));
        }
        if (isCreate) {
            HashMap<String, String> m = new HashMap<String, String>();
            m.put("id", new UID().toString());
            p.setKey(m);
        }
        ProfileDataManager.validateConsistency(p);
    }

    public MethodCallStatus delete(List list) throws ConfigMgmtException {
        ErrorDescriptor ed;
        int i;
        String METHOD = "delete";
        Trace.methodBegin(this, "delete");
        String arrayId = null;
        if (this.scope == null) {
            throw new ConfigMgmtException("error.scope.required", "Scope not set");
        }
        arrayId = Convert.scopeToArrayKey(this.scope);
        Trace.verbose((Object)this, "delete", arrayId);
        if (list == null || list.isEmpty()) {
            throw new ConfigMgmtException("incorrect.method.parameter", "Must supply a list for delete");
        }
        MethodCallStatus mcs = new MethodCallStatus();
        List profiles = this.getItemList();
        List keys = Convert.listOfStringKeysToMap(list);
        ArrayList idsToDelete = new ArrayList();
        for (int i2 = 0; i2 < keys.size(); ++i2) {
            idsToDelete.add(((Map)keys.get(i2)).get("id"));
        }
        int sz = idsToDelete.size();
        ProfileDataManager pdm = new ProfileDataManager(arrayId);
        Map rawProfileMap = pdm.getRawProfileMap();
        String[] profilesDeleted = new String[sz];
        String[] profilesNotDeleted = new String[sz];
        int profilesDeletedCnt = 0;
        int profilesNotDeletedCnt = 0;
        for (i = 0; i < sz; ++i) {
            ErrorDescriptor ed2;
            Profile p = pdm.getProfile((String)idsToDelete.get(i));
            if (p == null) {
                Trace.error((Object)this, "delete", "Could not find profile:" + idsToDelete.get(i));
                ed2 = new ErrorDescriptor();
                ed2.setI18nkey(ErrorDescriptor.ERROR_ITEM_NOT_FOUND_KEY);
                ed2.setI18nParams(new String[]{(String)idsToDelete.get(i)});
                ed2.setMsg("Could not find profile:" + idsToDelete.get(i));
                ed2.setErrorCode(ErrorDescriptor.ERROR_ITEM_NOT_FOUND);
                mcs.addErrorDescriptor(ed2);
                profilesNotDeleted[profilesNotDeletedCnt++] = "";
                continue;
            }
            if (p.isFactoryProfile()) {
                ed2 = new ErrorDescriptor(ErrorCode.ERROR_PROFILE_IS_FACTORY);
                ed2.setI18nParams(new String[]{p.getName()});
                ed2.setMsg("Not allowed to delete factory profile: " + p.getName());
                mcs.addErrorDescriptor(ed2);
                profilesNotDeleted[profilesNotDeletedCnt++] = p.getName();
                continue;
            }
            if (p.isInUse()) {
                ed2 = new ErrorDescriptor(ErrorCode.ERROR_PROFILE_IN_USE);
                ed2.setI18nParams(new String[]{p.getName()});
                ed2.setMsg("Failed to delete profile that is in use: " + p.getName());
                mcs.addErrorDescriptor(ed2);
                profilesNotDeleted[profilesNotDeletedCnt++] = p.getName();
                continue;
            }
            rawProfileMap.remove(idsToDelete.get(i));
            profilesDeleted[profilesDeletedCnt++] = p.getName();
        }
        try {
            pdm.saveData(rawProfileMap.values());
            for (i = 0; i < profilesDeletedCnt; ++i) {
                LogAPI.staticLog((String)"PROFILE_DELETE_SUCCESS", (String[])new String[]{profilesDeleted[i]}, (String[])new String[0]);
            }
            for (i = 0; i < profilesNotDeletedCnt; ++i) {
                LogAPI.staticLog((String)"PROFILE_DELETE_ERROR", (String[])new String[]{profilesNotDeleted[i]}, (String[])new String[0]);
            }
        }
        catch (RPCError e) {
            int i3;
            Trace.error((Object)this, "delete", (Throwable)e);
            ed = new ErrorDescriptor();
            ed.setI18nkey(ErrorDescriptor.ERROR_COMMUNICATING_WITH_ARRAY_KEY);
            ed.setMsg("Failed to delete profiles " + e.getMessage());
            mcs.addErrorDescriptor(ed);
            for (i3 = 0; i3 < profilesDeletedCnt; ++i3) {
                LogAPI.staticLog((String)"PROFILE_DELETE_ERROR", (String[])new String[]{profilesDeleted[i3]}, (String[])new String[0]);
            }
            for (i3 = 0; i3 < profilesNotDeletedCnt; ++i3) {
                LogAPI.staticLog((String)"PROFILE_DELETE_ERROR", (String[])new String[]{profilesNotDeleted[i3]}, (String[])new String[0]);
            }
        }
        catch (IOException e) {
            int i4;
            Trace.error((Object)this, "delete", (Throwable)e);
            ed = new ErrorDescriptor();
            ed.setI18nkey(ErrorDescriptor.ERROR_IO_KEY);
            ed.setMsg("Failed to delete profiles " + e.getMessage());
            mcs.addErrorDescriptor(ed);
            for (i4 = 0; i4 < profilesDeletedCnt; ++i4) {
                LogAPI.staticLog((String)"PROFILE_DELETE_ERROR", (String[])new String[]{profilesDeleted[i4]}, (String[])new String[0]);
            }
            for (i4 = 0; i4 < profilesNotDeletedCnt; ++i4) {
                LogAPI.staticLog((String)"PROFILE_DELETE_ERROR", (String[])new String[]{profilesNotDeleted[i4]}, (String[])new String[0]);
            }
        }
        catch (ConfigMgmtException cme) {
            int i5;
            Trace.error((Object)this, "delete", cme);
            ed = new ErrorDescriptor();
            ed.setI18nkey(cme.getExceptionKey());
            ed.setMsg("Failed to delete profiles " + cme.getMessage());
            mcs.addErrorDescriptor(ed);
            for (i5 = 0; i5 < profilesDeletedCnt; ++i5) {
                LogAPI.staticLog((String)"PROFILE_DELETE_ERROR", (String[])new String[]{profilesDeleted[i5]}, (String[])new String[0]);
            }
            for (i5 = 0; i5 < profilesNotDeletedCnt; ++i5) {
                LogAPI.staticLog((String)"PROFILE_DELETE_ERROR", (String[])new String[]{profilesNotDeleted[i5]}, (String[])new String[0]);
            }
        }
        Trace.verbose((Object)this, "delete", "END");
        return mcs;
    }

    public int getMaxObjects() {
        return Integer.MAX_VALUE;
    }

    private void setProfileInUseFlag(String arrayId, Profile p) throws ConfigMgmtException {
        if (this.poolMap == null) {
            this.poolMap = this.mapPools(arrayId);
        }
        if (this.poolMap.get((String)p.getKey().get("id")) != null) {
            p.setInUse(true);
        }
    }

    public List getXmlContentsForImport(String xml) throws ConfigMgmtException {
        String METHOD = "getXmlContentsForImport";
        List profs = ProfileDataManager.getXmlContentsForImport(xml);
        HashSet<String> importedNames = new HashSet<String>();
        List existingProfiles = this.getItemList();
        int existingProfSize = existingProfiles == null ? 0 : existingProfiles.size();
        int profSize = profs == null ? 0 : profs.size();
        for (int i = 0; i < profSize; ++i) {
            Profile prof = (Profile)profs.get(i);
            if (importedNames.contains(prof.getName())) {
                throw new ConfigMgmtException(ErrorCode.ERROR_PROFILE_INVALID_XML_FOR_IMPORT.getKey(), "duplicate name found in XML: " + prof.getName());
            }
            importedNames.add(prof.getName());
            Trace.verbose((Object)this, "getXmlContentsForImport", "examining profile for import with name: " + prof.getName());
            boolean doneChecking = false;
            for (int j = 0; j < existingProfSize && !doneChecking; ++j) {
                Profile existingProf = (Profile)existingProfiles.get(j);
                if (existingProf.getName().equals(prof.getName())) {
                    doneChecking = true;
                    if (prof.isInUse()) {
                        prof.setImportStatus(1);
                        continue;
                    }
                    if (prof.equalSettings(existingProf)) {
                        prof.setImportStatus(4);
                        continue;
                    }
                    prof.setImportStatus(3);
                    continue;
                }
                if (!prof.equalSettings(existingProf)) continue;
                prof.setImportStatus(2);
            }
            if (prof.getImportStatus() == -1) {
                prof.setImportStatus(0);
            }
            Trace.verbose((Object)this, "getXmlContentsForImport", "profile for import: " + prof.getName() + " received import status: " + prof.getImportStatus());
        }
        return profs;
    }

    public String getExportXml(List profileList) throws ConfigMgmtException {
        String METHOD = "getExportXml";
        Trace.methodBegin(this, "getExportXml");
        List profiles = profileList;
        if (profileList == null) {
            profiles = this.getItemList();
        }
        StringBuffer theXml = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        theXml.append("\n<sscs_storage_profiles>\n");
        int pSize = profiles == null ? 0 : profiles.size();
        for (int i = 0; i < pSize; ++i) {
            theXml.append(((Profile)profiles.get(i)).toXml());
        }
        theXml.append("</sscs_storage_profiles>\n");
        return theXml.toString();
    }

    public void importProfile(ProfileInterface profile) throws ConfigMgmtException {
        String METHOD = "importProfile";
        Trace.methodBegin(this, "importProfile");
        switch (profile.getImportStatus()) {
            case 0: 
            case 2: {
                this.create(profile.getPropertiesFromImport());
                break;
            }
            case 3: {
                String arrayId = null;
                if (this.scope == null) {
                    throw new ConfigMgmtException("error.scope.required", "Scope not set");
                }
                arrayId = Convert.scopeToArrayKey(this.scope);
                Trace.verbose((Object)this, "importProfile", arrayId);
                this.filter = new SearchFilter("name", profile.getName());
                List list = this.getItemList();
                Profile modifyProfile = (Profile)list.get(0);
                this.modify(modifyProfile.getKey(), profile.getPropertiesFromImport());
                break;
            }
            default: {
                String msg = "Invalid import status to perform an import: " + profile.getImportStatus();
                Trace.verbose((Object)this, "importProfile", msg);
                throw new ConfigMgmtException(ErrorCode.ERROR_PROFILE_INVALID_IMPORT_STATUS.getKey(), msg);
            }
        }
    }

    public MethodCallStatus copyProfiles(List profileKeysToCopy, List copyToArrays) throws ConfigMgmtException {
        String METHOD = "copyProfiles";
        Trace.methodBegin(this, "copyProfiles");
        ArrayList<Profile> profilesToCopy = new ArrayList<Profile>();
        MethodCallStatus mcs = new MethodCallStatus();
        String arrayId = null;
        if (this.scope == null) {
            throw new ConfigMgmtException("error.scope.required", "Scope not set");
        }
        arrayId = Convert.scopeToArrayKey(this.scope);
        List keys = Convert.listOfStringKeysToMap(profileKeysToCopy);
        ArrayList<String> idsToCopy = new ArrayList<String>();
        for (int i = 0; i < keys.size(); ++i) {
            String id = (String)((Map)keys.get(i)).get("id");
            idsToCopy.add(id);
        }
        List itemList = this.getItemList();
        int size = keys == null ? 0 : itemList.size();
        for (int i = 0; i < size; ++i) {
            Profile p = (Profile)itemList.get(i);
            String id = (String)p.getKey().get("id");
            if (!idsToCopy.contains(id)) continue;
            profilesToCopy.add(p);
        }
        String exportXml = this.getExportXml(profilesToCopy);
        ManageArrays aMgr = new ManageArrays();
        aMgr.init(this.context, null, null);
        List allArrays = aMgr.getItemList();
        Iterator iter = copyToArrays.iterator();
        while (iter.hasNext()) {
            String arrayKeyAsString = (String)iter.next();
            Scope copyScope = new Scope();
            copyScope.setAttribute("array", arrayKeyAsString);
            ManageProfiles mgr = new ManageProfiles();
            mgr.init(this.context, copyScope, null);
            String currentArrayName = null;
            try {
                Map currentArrayKeyMap = Convert.keyAsStringToMap(arrayKeyAsString);
                Iterator aIter = allArrays.iterator();
                while (aIter.hasNext() && currentArrayName == null) {
                    StorageArray sa = (StorageArray)aIter.next();
                    if (!Convert.mapsHaveEqualStringEntries(sa.getKey(), currentArrayKeyMap)) continue;
                    currentArrayName = sa.getName();
                }
                if (currentArrayName == null) {
                    currentArrayName = arrayKeyAsString;
                }
                Trace.verbose((Object)this, "copyProfiles", "Copying profiles to array: " + currentArrayName);
                List inLoopProfiles = mgr.getXmlContentsForImport(exportXml);
                Iterator pIter = inLoopProfiles.iterator();
                while (pIter.hasNext()) {
                    Profile iCand = (Profile)pIter.next();
                    if (iCand.getImportStatus() == 0 || iCand.getImportStatus() == 2) {
                        try {
                            mgr.importProfile(iCand);
                        }
                        catch (ConfigMgmtException importEx) {
                            Trace.error((Object)this, "copyProfiles", importEx);
                            ErrorDescriptor ed = new ErrorDescriptor(ErrorCode.ERROR_PROFILE_COPY_FAILED);
                            ed.setI18nParams(new String[]{iCand.getName(), currentArrayName});
                            ed.setMsg("Failed to copy profile: " + iCand.getName() + " to array: " + currentArrayName);
                            mcs.addErrorDescriptor(ed);
                        }
                        continue;
                    }
                    Trace.verbose((Object)this, "copyProfiles", "Not copying profile: " + iCand.getName() + " to array: " + currentArrayName + " because import status is: " + iCand.getImportStatus());
                    ErrorDescriptor ed = new ErrorDescriptor(ErrorCode.ERROR_PROFILE_ALREADY_EXISTS_ON_TARGET);
                    ed.setI18nParams(new String[]{iCand.getName(), currentArrayName});
                    ed.setMsg("Ignoring request to copy profile: " + iCand.getName() + " to array: " + currentArrayName + " since a profile by that name already exists there.");
                    mcs.addErrorDescriptor(ed);
                }
            }
            catch (ConfigMgmtException cme) {
                Trace.error((Object)this, "copyProfiles", cme);
                ErrorDescriptor ed = new ErrorDescriptor(ErrorCode.ERROR_PROFILE_ALL_COPIES_FAILED_TO_ARRAY);
                ed.setI18nParams(new String[]{currentArrayName});
                ed.setMsg("Failed to copy any profiles to array: " + currentArrayName);
                mcs.addErrorDescriptor(ed);
            }
        }
        return mcs;
    }

    public List getProfilesCompatibleWithPool(Pool pool) throws ConfigMgmtException {
        String METHOD_NAME = "getProfilesCompatibleWithPool";
        Trace.methodBegin(this, "getProfilesCompatibleWithPool");
        if (pool == null) {
            throw new ConfigMgmtException("incorrect.method.parameter", "Must supply a pool for: getProfilesCompatibleWithPool");
        }
        String arrayWwn = this.getArrayWwnFromScope();
        List allProfiles = this.getItemList();
        ManagePools poolManager = new ManagePools();
        poolManager.init(this.context, this.scope, null);
        PoolData pd = new PoolData();
        pd.poolId = (String)pool.getKey().get("id");
        pd.profileId = pool.getProfileId();
        Trace.verbose((Object)this, "getProfilesCompatibleWithPool", "Get volumes in pool:" + pd.poolName + " with id:" + pd.poolId);
        List volsInPool = poolManager.getVolsInPool(pd.poolId);
        if (volsInPool == null || volsInPool.isEmpty()) {
            Trace.verbose((Object)this, "getProfilesCompatibleWithPool", "No volumes in pool, all profiles good");
            return allProfiles;
        }
        Trace.verbose((Object)this, "getProfilesCompatibleWithPool", "This pool has number of volumes:" + volsInPool.size());
        List vdisksInPool = poolManager.getVDisksUsedByPool(volsInPool);
        ProfileDataManager profdm = new ProfileDataManager(this.getArrayWwnFromScope());
        Profile currentProfile = profdm.getProfile(pd.profileId);
        if (currentProfile == null) {
            String msg = "Failed to obtain current profile from id: " + pool.getProfileId();
            Trace.verbose((Object)this, "getProfilesCompatibleWithPool", msg);
            throw new ConfigMgmtException("error.systemError", msg);
        }
        ArrayList<Profile> profilesCompatibleWithPool = new ArrayList<Profile>();
        Iterator iter = allProfiles.iterator();
        while (iter.hasNext()) {
            Profile profile = (Profile)iter.next();
            try {
                poolManager.validatePoolsProfile(currentProfile, profile, vdisksInPool, volsInPool);
                profilesCompatibleWithPool.add(profile);
            }
            catch (ConfigMgmtException cme) {}
        }
        Trace.verbose((Object)this, "getProfilesCompatibleWithPool", "Number of items in the list = " + profilesCompatibleWithPool.size());
        return profilesCompatibleWithPool;
    }

    private String getArrayWwnFromScope() throws ConfigMgmtException {
        if (this.scope != null) {
            return Convert.scopeToArrayKey(this.scope);
        }
        throw new ConfigMgmtException("error.scope.required", "Array scope not set before using of the profile manager.");
    }

    public static interface KeyMap {
        public static final String ID = "id";
    }

    public static interface CreateProps {
        public static final String NAME = "name";
        public static final String DESCRIPTION = "description";
        public static final String SEGMENT_SIZE = "segmentSize";
        public static final String RAID_LEVEL = "raidLevel";
        public static final String READ_AHEAD = "readAheadEnabled";
        public static final String WRITE_CACHE = "writeCacheEnabled";
        public static final String ARRAY_TYPE = "arrayType";
        public static final String NUM_DISKS = "numberOfDisks";
        public static final String DRIVE_TYPE = "driveType";
    }

    public static interface SearchType
    extends ManagerInterface.CommonSearchTypes {
    }
}

