/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz;

import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.ErrorCode;
import com.sun.netstorage.array.mgmt.cfg.core.ErrorDescriptor;
import com.sun.netstorage.array.mgmt.cfg.core.MethodCallStatus;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.impl.ObjectBundleManager;
import com.sun.netstorage.array.mgmt.cfg.core.impl.oz.CommandProcessor;
import com.sun.netstorage.array.mgmt.cfg.core.impl.oz.LicenseParser;
import com.sun.netstorage.array.mgmt.cfg.core.impl.oz.OZErrorCode;
import com.sun.netstorage.array.mgmt.cfg.core.logic.Scope;
import com.sun.netstorage.array.mgmt.cfg.core.logic.SearchFilter;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManagePremiumFeaturesInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageVDisksFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ManageArrays;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ManageVDisks;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.PremiumFeatures;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ProfileDataManager;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.VDisk;
import com.sun.netstorage.array.mgmt.cfg.util.Base64;
import com.sun.netstorage.array.mgmt.cfg.util.Convert;
import com.sun.netstorage.array.mgmt.logger.LogAPI;
import devmgr.versioned.jrpc.RPCError;
import devmgr.versioned.jrpc.XDRType;
import devmgr.versioned.symbol.CandidateSelectionType;
import devmgr.versioned.symbol.CandidateSelectionTypeData;
import devmgr.versioned.symbol.Capability;
import devmgr.versioned.symbol.Drive;
import devmgr.versioned.symbol.DriveRef;
import devmgr.versioned.symbol.DriveRefList;
import devmgr.versioned.symbol.FeatureKey;
import devmgr.versioned.symbol.FreeExtent;
import devmgr.versioned.symbol.HLVolumeBundle;
import devmgr.versioned.symbol.MetadataVolCreationDescriptor;
import devmgr.versioned.symbol.MetadataVolType;
import devmgr.versioned.symbol.ObjectBundle;
import devmgr.versioned.symbol.PhysicalDriveType;
import devmgr.versioned.symbol.PremiumFeature;
import devmgr.versioned.symbol.RAIDLevel;
import devmgr.versioned.symbol.ReturnCode;
import devmgr.versioned.symbol.SAIdentifier;
import devmgr.versioned.symbol.SnapshotVolume;
import devmgr.versioned.symbol.StorageArray;
import devmgr.versioned.symbol.Tray;
import devmgr.versioned.symbol.UnicodeTranslator;
import devmgr.versioned.symbol.UserAssignedLabel;
import devmgr.versioned.symbol.VolumeCandidate;
import devmgr.versioned.symbol.VolumeCandidateList;
import devmgr.versioned.symbol.VolumeCandidateRequest;
import devmgr.versioned.symbol.VolumeCopy;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class ManagePremiumFeatures
implements ManagePremiumFeaturesInterface {
    ConfigContext cfgctx;
    Scope scope;
    SearchFilter filter;
    public static final int MINIMUM_REPSET_METADATA_VOL_SIZE = 276480000;
    private static final String sccs_id = "@(#)ManagePremiumFeatures.java 1.50    05/08/12 SMI";

    public void init(ConfigContext context, Scope s, SearchFilter f) throws ConfigMgmtException {
        this.cfgctx = context;
        this.scope = s;
        this.filter = f;
    }

    public void create(Properties props) throws ConfigMgmtException {
        String METHOD_NAME = "create";
        Trace.methodBegin(this, "create");
        Object symClient = null;
        ObjectBundleManager manager = null;
        long length = 0L;
        FeatureKey m_FeatureKey = null;
        String myWwn = null;
        if (props == null || props.isEmpty()) {
            Trace.error((Object)this, "create", "empty list");
            throw new ConfigMgmtException(ErrorCode.EMPTY_LIST.getKey(), "empty properties");
        }
        myWwn = props.getProperty("wwn");
        if (myWwn == null) {
            if (this.scope != null) {
                myWwn = Convert.scopeToArrayKey(this.scope);
                Trace.verbose((Object)this, "create", myWwn);
            } else {
                Trace.error((Object)this, "create", "missing wwn");
                throw new ConfigMgmtException(ErrorCode.ERROR_SCOPE_REQUIRED.getKey(), "missing wwn");
            }
        }
        String ver = props.getProperty("version");
        int versionKey = 0;
        if (ver == null) {
            Trace.error((Object)this, "create", "missing version");
            throw new ConfigMgmtException(ErrorCode.ERROR_INCOMPLETE_KEY.getKey(), "missing version key property");
        }
        try {
            versionKey = Integer.parseInt(ver);
        }
        catch (NumberFormatException nfe) {
            throw new ConfigMgmtException(ErrorDescriptor.ERROR_REASON_PREFIX + (OZErrorCode.ERROR_CODE_MIN + 94), "enable feature error: invalid version");
        }
        String capability = props.getProperty("capability");
        if (capability == null) {
            Trace.error((Object)this, "create", "missing capability");
            throw new ConfigMgmtException(ErrorCode.ERROR_INCOMPLETE_KEY.getKey(), "missing capability property");
        }
        String baseDigest = props.getProperty("digest");
        byte[] byteDigest = null;
        if (baseDigest == null) {
            Trace.error((Object)this, "create", "missing digest");
            throw new ConfigMgmtException(ErrorCode.ERROR_INCOMPLETE_KEY.getKey(), "missing digest property");
        }
        byteDigest = ManagePremiumFeatures.buildBinary(baseDigest);
        manager = ObjectBundleManager.getInstance();
        ObjectBundle bundle = ObjectBundleManager.getInstance().getObjectBundle(myWwn);
        StorageArray sa = bundle.getSa();
        m_FeatureKey = new FeatureKey();
        m_FeatureKey.setKeyVersion(versionKey);
        int count = 0;
        m_FeatureKey.setCapability(new Capability(this.getCapabilityFromName(capability, count)));
        m_FeatureKey.setDigest(byteDigest);
        manager.stopMonitoringThread(myWwn);
        try {
            m_FeatureKey.setSaId(bundle.getSa().getSafeId());
            ObjectBundleManager.getInstance().stopMonitoringThread(myWwn);
            CommandProcessor command = new CommandProcessor(myWwn);
            ReturnCode rc = new ReturnCode();
            command.execute(82, (XDRType)m_FeatureKey, (XDRType)rc, true);
            Trace.verbose((Object)this, "create", "Return code:" + rc.getValue());
            if (rc.getValue() != 1) {
                String message = "enable feature error: " + rc.getValue();
                Trace.verbose((Object)this, "create", message);
                LogAPI.staticLog((String)"PREMIUM_FEATURE_CREATE_ERROR", (String[])new String[]{capability, ManageArrays.getArrayName(sa)}, (String[])new String[0]);
                throw new ConfigMgmtException(ErrorDescriptor.ERROR_REASON_PREFIX + (OZErrorCode.ERROR_CODE_MIN + rc.getValue()), message);
            }
            Trace.verbose((Object)this, "create", "feature create successful");
            try {
                LogAPI.staticLog((String)"PREMIUM_FEATURE_CREATE", (String[])new String[]{capability, ManageArrays.getArrayName(sa)}, (String[])new String[0]);
            }
            catch (RuntimeException e) {
                // empty catch block
            }
        }
        catch (RPCError rpce) {
            Trace.error((Object)this, "create", (Throwable)rpce);
            LogAPI.staticLog((String)"PREMIUM_FEATURE_COMM_ERROR", (String[])new String[]{ManageArrays.getArrayName(sa)}, (String[])new String[0]);
            throw new ConfigMgmtException("error.rpc", "RPCError exception trying to create mapping.", (Exception)((Object)rpce));
        }
        catch (IOException ioe) {
            Trace.error((Object)this, "create", (Throwable)ioe);
            LogAPI.staticLog((String)"PREMIUM_FEATURE_COMM_ERROR", (String[])new String[]{ManageArrays.getArrayName(sa)}, (String[])new String[0]);
            throw new ConfigMgmtException("error.communication", "IOException trying to create maping.");
        }
        finally {
            ObjectBundleManager.getInstance().forceBundleReload(myWwn);
        }
    }

    public MethodCallStatus fileCreate(Properties prop) throws ConfigMgmtException {
        String METHOD_NAME = "fileCreate";
        Trace.methodBegin(this, "fileCreate");
        Object symClient = null;
        ObjectBundleManager manager = null;
        ErrorDescriptor ed = null;
        MethodCallStatus mcs = new MethodCallStatus();
        FeatureKey[] m_FeatureKeys = null;
        mcs.setReturnCode(0);
        String myWwn = null;
        myWwn = prop.getProperty("wwn");
        if (myWwn != null || this.scope == null) {
            Trace.error((Object)this, "fileCreate", "empty list");
            throw new ConfigMgmtException(ErrorCode.EMPTY_LIST.getKey(), "empty list");
        }
        myWwn = Convert.scopeToArrayKey(this.scope);
        String xmlConfig = prop.getProperty("file");
        if (xmlConfig == null) {
            Trace.error((Object)this, "fileCreate", "missing file");
            throw new ConfigMgmtException(ErrorCode.ERROR_INCOMPLETE_KEY.getKey(), "missing file property");
        }
        LicenseParser lp = new LicenseParser();
        lp.parseLicense(xmlConfig);
        List licenses = lp.getLicenses();
        m_FeatureKeys = new FeatureKey[licenses.size()];
        manager = ObjectBundleManager.getInstance();
        ObjectBundle bundle = ObjectBundleManager.getInstance().getObjectBundle(myWwn);
        StorageArray sa = bundle.getSa();
        LicenseParser.SingleLicense sl = new LicenseParser.SingleLicense();
        for (int i = 0; i < licenses.size(); ++i) {
            sl = (LicenseParser.SingleLicense)licenses.get(i);
            m_FeatureKeys[i] = new FeatureKey();
            int keyVersion = new Integer(sl.version);
            m_FeatureKeys[i].setKeyVersion(keyVersion);
            int count = 0;
            m_FeatureKeys[i].setCapability(new Capability(this.getCapabilityFromName(sl.capability, count)));
            m_FeatureKeys[i].setDigest(ManagePremiumFeatures.buildBinary(sl.digest));
            m_FeatureKeys[i].setSaId(sa.getSafeId());
            try {
                ObjectBundleManager.getInstance().stopMonitoringThread(myWwn);
                CommandProcessor command = new CommandProcessor(myWwn);
                ReturnCode rc = new ReturnCode();
                command.execute(82, (XDRType)m_FeatureKeys[i], (XDRType)rc, true);
                Trace.verbose((Object)this, "create", "Return code:" + rc.getValue());
                if (rc.getValue() != 1) {
                    String message = "Code " + rc.getValue() + " returned for file feature enable";
                    Trace.error((Object)this, "fileCreate", message);
                    LogAPI.staticLog((String)"PREMIUM_FEATURE_CREATE_ERROR", (String[])new String[]{sl.capability, ManageArrays.getArrayName(sa)}, (String[])new String[0]);
                    String localString = ErrorDescriptor.ERROR_REASON_PREFIX + (OZErrorCode.ERROR_CODE_MIN + rc.getValue());
                    ed = new ErrorDescriptor(OZErrorCode.getErrorCode(localString, rc.getValue()));
                    ed.setMsg(message);
                    mcs.addErrorDescriptor(ed);
                    continue;
                }
                Trace.verbose((Object)this, "fileCreate", "return code:" + rc.getValue());
                LogAPI.staticLog((String)"PREMIUM_FEATURE_CREATE", (String[])new String[]{sl.capability, ManageArrays.getArrayName(sa)}, (String[])new String[0]);
                continue;
            }
            catch (RPCError rpce) {
                Trace.error((Object)this, "fileCreate", (Throwable)rpce);
                LogAPI.staticLog((String)"PREMIUM_FEATURE_COMM_ERROR", (String[])new String[]{ManageArrays.getArrayName(sa)}, (String[])new String[0]);
                throw new ConfigMgmtException(ErrorCode.ERROR_RPC.getKey(), "RPC error");
            }
            catch (IOException ioe) {
                Trace.error((Object)this, "fileCreate", (Throwable)ioe);
                LogAPI.staticLog((String)"PREMIUM_FEATURE_COMM_ERROR", (String[])new String[]{ManageArrays.getArrayName(sa)}, (String[])new String[0]);
                throw new ConfigMgmtException(ErrorCode.ERROR_COMMUNICATING_WITH_ARRAY.getKey(), "IO error");
            }
            finally {
                ObjectBundleManager.getInstance().forceBundleReload(myWwn);
            }
        }
        return mcs;
    }

    public MethodCallStatus binaryCreate(Properties prop) throws ConfigMgmtException {
        String METHOD_NAME = "fileCreate";
        Trace.methodBegin(this, "fileCreate");
        Object symClient = null;
        ObjectBundleManager manager = null;
        ErrorDescriptor ed = null;
        MethodCallStatus mcs = new MethodCallStatus();
        int version = 0;
        int numEntries = 0;
        long length = 0L;
        Object byteImage = null;
        FeatureKey[] m_FeatureKeys = null;
        mcs.setReturnCode(0);
        String myWwn = null;
        StorageArray sa = null;
        myWwn = prop.getProperty("wwn");
        if (myWwn != null || this.scope == null) {
            Trace.error((Object)this, "fileCreate", "empty list");
            throw new ConfigMgmtException(ErrorCode.EMPTY_LIST.getKey(), "empty list");
        }
        myWwn = Convert.scopeToArrayKey(this.scope);
        String encodeImage = prop.getProperty("file");
        if (encodeImage == null) {
            Trace.error((Object)this, "fileCreate", "missing file");
            throw new ConfigMgmtException(ErrorCode.ERROR_INCOMPLETE_KEY.getKey(), "missing file property");
        }
        try {
            byte[] decodeImage = Base64.base64ToByteArray(encodeImage);
            ByteArrayInputStream bis = new ByteArrayInputStream(decodeImage);
            ObjectInputStream is = new ObjectInputStream(bis);
            String header = (String)is.readObject();
            version = is.readInt();
            numEntries = is.readInt();
            m_FeatureKeys = new FeatureKey[numEntries];
            manager = ObjectBundleManager.getInstance();
            ObjectBundle bundle = ObjectBundleManager.getInstance().getObjectBundle(myWwn);
            sa = bundle.getSa();
            for (int i = 0; i < numEntries; ++i) {
                m_FeatureKeys[i] = new FeatureKey();
                int keyVersion = is.readInt();
                m_FeatureKeys[i].setKeyVersion(keyVersion);
                int capabilityCode = is.readInt();
                m_FeatureKeys[i].setCapability(new Capability(capabilityCode));
                byte[] wwn = (byte[])is.readObject();
                SAIdentifier saId = new SAIdentifier();
                saId.setWorldWideName(wwn);
                m_FeatureKeys[i].setSaId(saId);
                byte[] digest = (byte[])is.readObject();
                m_FeatureKeys[i].setDigest(digest);
                try {
                    ObjectBundleManager.getInstance().stopMonitoringThread(myWwn);
                    CommandProcessor command = new CommandProcessor(myWwn);
                    ReturnCode rc = new ReturnCode();
                    command.execute(82, (XDRType)m_FeatureKeys[i], (XDRType)rc, true);
                    Trace.verbose((Object)this, "create", "Return code:" + rc.getValue());
                    if (rc.getValue() != 1) {
                        String message = "Code " + rc.getValue() + " returned for file feature enable";
                        LogAPI.staticLog((String)"PREMIUM_FEATURE_CREATE_ERROR", (String[])new String[]{this.getCapabilityFromInt(capabilityCode), ManageArrays.getArrayName(sa)}, (String[])new String[0]);
                        ed = new ErrorDescriptor(OZErrorCode.getErrorCode("error.delete.mapping", rc.getValue()));
                        ed.setMsg(message);
                        ed.setI18nkey(ErrorDescriptor.ERROR_COMMUNICATING_WITH_ARRAY_KEY);
                        mcs.addErrorDescriptor(ed);
                        continue;
                    }
                    try {
                        LogAPI.staticLog((String)"PREMIUM_FEATURE_CREATE", (String[])new String[]{this.getCapabilityFromInt(capabilityCode), ManageArrays.getArrayName(sa)}, (String[])new String[0]);
                    }
                    catch (RuntimeException e) {
                        // empty catch block
                    }
                    continue;
                }
                catch (RPCError rpce) {
                    Trace.error((Object)this, "fileCreate", (Throwable)rpce);
                    LogAPI.staticLog((String)"PREMIUM_FEATURE_COMM_ERROR", (String[])new String[]{ManageArrays.getArrayName(sa)}, (String[])new String[0]);
                    throw new ConfigMgmtException(ErrorCode.ERROR_RPC.getKey(), "RPC error");
                }
                catch (IOException ioe) {
                    Trace.error((Object)this, "fileCreate", (Throwable)ioe);
                    LogAPI.staticLog((String)"PREMIUM_FEATURE_COMM_ERROR", (String[])new String[]{ManageArrays.getArrayName(sa)}, (String[])new String[0]);
                    throw new ConfigMgmtException(ErrorCode.ERROR_COMMUNICATING_WITH_ARRAY.getKey(), "IO error");
                }
                finally {
                    ObjectBundleManager.getInstance().forceBundleReload(myWwn);
                }
            }
        }
        catch (IOException io) {
            Trace.verbose((Object)this, "fileCreate", "file read error");
            LogAPI.staticLog((String)"PREMIUM_FEATURE_INPUT_ERROR", (String[])new String[]{ManageArrays.getArrayName(sa)}, (String[])new String[0]);
            throw new ConfigMgmtException(ErrorCode.ERROR_COMMUNICATING_WITH_ARRAY.getKey(), "file error");
        }
        catch (ClassNotFoundException cnfe) {
            Trace.verbose((Object)this, "fileCreate", "class not found");
            LogAPI.staticLog((String)"PREMIUM_FEATURE_INPUT_ERROR", (String[])new String[]{ManageArrays.getArrayName(sa)}, (String[])new String[0]);
            throw new ConfigMgmtException(ErrorCode.ERROR_COMMUNICATING_WITH_ARRAY.getKey(), "class not found error");
        }
        return mcs;
    }

    private String getCapabilityFromInt(int capNum) {
        Trace.methodBegin(this, "getCapabilityFromInt");
        String name = null;
        switch (capNum) {
            case 1: {
                name = "SharedVolume";
                break;
            }
            case 8: {
                name = "StorageDomain";
                break;
            }
            case 2: {
                name = "StorageDomain";
                break;
            }
            case 7: {
                name = "StorageDomain";
                break;
            }
            case 11: {
                name = "StorageDomain";
                break;
            }
            case 10: {
                name = "StorageDomain";
                break;
            }
            case 9: {
                name = "StorageDomain";
                break;
            }
            case 4: {
                name = "AutoSync";
                break;
            }
            case 5: {
                name = "AutoLunTransfer";
                break;
            }
            case 3: {
                name = "MixedRaidLevel";
                break;
            }
            case 12: {
                name = "Snapshot";
                break;
            }
            case 6: {
                name = "SubLunsAllowed";
                break;
            }
            case 14: {
                name = "VolumeCopy";
                break;
            }
            case 13: {
                name = "ReplicationSet";
                break;
            }
            default: {
                name = "Unknown";
            }
        }
        return name;
    }

    private int getCapabilityFromName(String name, int count) {
        Trace.methodBegin(this, "getCapabilityFromName");
        int capNum = 0;
        if (name.equals("SharedVolume")) {
            capNum = 1;
        } else if (name.equals("StorageDomain")) {
            if (count == 2) {
                capNum = 8;
            } else if (count == 4) {
                capNum = 2;
            } else if (count == 8) {
                capNum = 7;
            } else if (count == 16) {
                capNum = 11;
            } else if (count == 64) {
                capNum = 10;
            }
        } else if (name.equals("StorageDomain2")) {
            capNum = 8;
        } else if (name.equals("StorageDomain4")) {
            capNum = 2;
        } else if (name.equals("StorageDomain8")) {
            capNum = 7;
        } else if (name.equals("StorageDomain16")) {
            capNum = 11;
        } else if (name.equals("StorageDomain64")) {
            capNum = 10;
        } else if (name.equals("StorageDomainMax")) {
            capNum = 9;
        } else if (name.equals("AutoSync")) {
            capNum = 4;
        } else if (name.equals("AutoLunTransfer")) {
            capNum = 5;
        } else if (name.equals("MixedRaidLevel")) {
            capNum = 3;
        } else if (name.equals("Snapshot")) {
            capNum = 12;
        } else if (name.equals("SubLunsAllowed")) {
            capNum = 6;
        } else if (name.equals("VolumeCopy")) {
            capNum = 14;
        } else if (name.equals("ReplicationSet")) {
            capNum = 13;
        } else if (name.equals("Unknown")) {
            capNum = 0;
        }
        return capNum;
    }

    public MethodCallStatus delete(List list) throws ConfigMgmtException {
        String METHOD_NAME = "delete";
        Trace.methodBegin(this, "delete");
        Object symClient = null;
        MethodCallStatus mcs = new MethodCallStatus();
        Object errorDesc = null;
        Map key = null;
        String featureRef = null;
        ErrorDescriptor ed = null;
        String myWwn = null;
        if (list == null || list.size() == 0) {
            Trace.error((Object)this, "delete", "empty list");
            throw new ConfigMgmtException(ErrorCode.EMPTY_LIST.getKey(), "empty list");
        }
        List convertedList = Convert.listOfStringKeysToMap(list);
        myWwn = (String)((Map)convertedList.get(0)).get("array");
        mcs.setReturnCode(0);
        int listSize = list.size();
        if (myWwn == null) {
            Trace.error((Object)this, "delete", "missing wwn");
            throw new ConfigMgmtException(ErrorCode.ERROR_SCOPE_REQUIRED.getKey(), "missing wwn");
        }
        ObjectBundleManager manager = ObjectBundleManager.getInstance();
        ObjectBundle bundle = ObjectBundleManager.getInstance().getObjectBundle(myWwn);
        StorageArray sa = bundle.getSa();
        int maxPartCnt = sa.getFeatureParameters().getMaxPartitionCount();
        for (int i = 0; i < listSize; ++i) {
            key = (Map)convertedList.get(i);
            featureRef = (String)key.get("featureRef");
            if (featureRef == null) {
                throw new ConfigMgmtException("incorrect.method.parameter", "Feature property missing.");
            }
            int capNum = this.getCapabilityFromName(featureRef, maxPartCnt);
            Capability cap = new Capability(capNum);
            try {
                ObjectBundleManager.getInstance().stopMonitoringThread(myWwn);
                CommandProcessor command = new CommandProcessor(myWwn);
                ReturnCode rc = new ReturnCode();
                command.execute(83, (XDRType)cap, (XDRType)rc, true);
                Trace.verbose((Object)this, "delete", "Return code:" + rc.getValue());
                if (rc.getValue() != 1) {
                    String message = "Code " + rc.getValue() + " returned for delete feature";
                    LogAPI.staticLog((String)"PREMIUM_FEATURE_CREATE_ERROR", (String[])new String[]{this.getCapabilityFromInt(capNum), ManageArrays.getArrayName(sa)}, (String[])new String[0]);
                    ed = new ErrorDescriptor(OZErrorCode.getErrorCode("error.delete.mapping", rc.getValue()));
                    ed.setMsg(message);
                    mcs.addErrorDescriptor(ed);
                    continue;
                }
                try {
                    LogAPI.staticLog((String)"PREMIUM_FEATURE_CREATE", (String[])new String[]{this.getCapabilityFromInt(capNum), ManageArrays.getArrayName(sa)}, (String[])new String[0]);
                }
                catch (RuntimeException e) {
                    // empty catch block
                }
                continue;
            }
            catch (RPCError rpce) {
                Trace.error((Object)this, "delete", (Throwable)rpce);
                LogAPI.staticLog((String)"PREMIUM_FEATURE_COMM_ERROR", (String[])new String[]{ManageArrays.getArrayName(sa)}, (String[])new String[0]);
                throw new ConfigMgmtException(ErrorCode.ERROR_RPC.getKey(), "RPC error");
            }
            catch (IOException ioe) {
                Trace.error((Object)this, "delete", (Throwable)ioe);
                LogAPI.staticLog((String)"PREMIUM_FEATURE_COMM_ERROR", (String[])new String[]{ManageArrays.getArrayName(sa)}, (String[])new String[0]);
                throw new ConfigMgmtException(ErrorCode.ERROR_COMMUNICATING_WITH_ARRAY.getKey(), "IO error");
            }
            finally {
                ObjectBundleManager.getInstance().forceBundleReload(myWwn);
            }
        }
        return mcs;
    }

    public List getFeatureList() throws ConfigMgmtException {
        String METHOD_NAME = "getFeatureList";
        Trace.methodBegin(this, "getFeatureList");
        ArrayList pfList = new ArrayList();
        Collection bundles = this.getBundles();
        Iterator iter = bundles.iterator();
        while (iter.hasNext()) {
            ObjectBundle bundle = (ObjectBundle)iter.next();
            StorageArray sa = bundle.getSa();
            Capability[] cap = sa.getCapabilities();
            if (cap == null) {
                throw new ConfigMgmtException("NULL_VALUE_RETURNED", "Null Capability[] returned to getItemList()");
            }
            for (int i = 0; i < cap.length; ++i) {
                HashMap<String, String> key = new HashMap<String, String>(2);
                String arrayRef = Convert.bytesToString(bundle.getSa().getSaData().getSaId().getWorldWideName());
                String capRef = this.getCapabilityFromInt(cap[i].getValue());
                key.put("arrayRef", arrayRef);
                key.put("featureRef", capRef);
                pfList.add(key);
            }
        }
        return pfList;
    }

    public List getItemList() throws ConfigMgmtException {
        String METHOD_NAME = "getItemList";
        Trace.methodBegin(this, "getItemList");
        ArrayList<PremiumFeatures> pfList = new ArrayList<PremiumFeatures>();
        PremiumFeatures pfObj = null;
        boolean report = false;
        int accumMaxCount = 0;
        boolean feature_VolumeCopy = false;
        boolean feature_SnapShot = false;
        boolean feature_Partitions = false;
        boolean feature_ReplicationSet = false;
        Collection bundles = this.getBundles();
        Iterator iter = bundles.iterator();
        while (iter.hasNext()) {
            ObjectBundle bundle = (ObjectBundle)iter.next();
            StorageArray sa = bundle.getSa();
            PremiumFeature[] pfa = sa.getPremiumFeatures();
            feature_VolumeCopy = false;
            feature_SnapShot = false;
            feature_Partitions = false;
            feature_ReplicationSet = false;
            accumMaxCount = 0;
            if (pfa == null) {
                throw new ConfigMgmtException("NULL_VALUE_RETURNED", "Null PremiumFeature[] returned to getItemList()");
            }
            int maxPartCnt = sa.getFeatureParameters().getMaxPartitionCount();
            for (int i = 0; i < pfa.length; ++i) {
                int capNum = pfa[i].getCapability().getValue();
                report = false;
                switch (capNum) {
                    case 1: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        break;
                    }
                    case 13: {
                        report = true;
                        feature_ReplicationSet = true;
                        pfObj = new PremiumFeatures();
                        pfObj.setQtyLicensed(sa.getFeatureParameters().getCurrentMaxMirrors());
                        pfObj.setQtyInUse(bundle.getHighLevelVolBundle().getMirrorVol().length);
                        pfObj.setLimit(sa.getFeatureParameters().getMaxMirrors());
                        break;
                    }
                    case 9: {
                        if (accumMaxCount < maxPartCnt) {
                            accumMaxCount = maxPartCnt;
                        }
                        if (!pfa[i].getIsEnabled() || feature_Partitions) break;
                        report = true;
                        feature_Partitions = true;
                        pfObj = new PremiumFeatures();
                        pfObj.setQtyLicensed(sa.getFeatureParameters().getMaxPartitionCount());
                        pfObj.setQtyInUse(sa.getDefinedPartitionCount());
                        break;
                    }
                    case 8: {
                        if (accumMaxCount < 2) {
                            accumMaxCount = 2;
                        }
                        if (!pfa[i].getIsEnabled() || maxPartCnt != 2 || feature_Partitions) break;
                        report = true;
                        feature_Partitions = true;
                        pfObj = new PremiumFeatures();
                        pfObj.setQtyLicensed(sa.getFeatureParameters().getMaxPartitionCount());
                        pfObj.setQtyInUse(sa.getDefinedPartitionCount());
                        break;
                    }
                    case 2: {
                        if (accumMaxCount < 4) {
                            accumMaxCount = 4;
                        }
                        if (!pfa[i].getIsEnabled() || maxPartCnt != 4 || feature_Partitions) break;
                        report = true;
                        feature_Partitions = true;
                        pfObj = new PremiumFeatures();
                        pfObj.setQtyLicensed(sa.getFeatureParameters().getMaxPartitionCount());
                        pfObj.setQtyInUse(sa.getDefinedPartitionCount());
                        break;
                    }
                    case 7: {
                        if (accumMaxCount < 8) {
                            accumMaxCount = 8;
                        }
                        if (!pfa[i].getIsEnabled() || maxPartCnt != 8 || feature_Partitions) break;
                        report = true;
                        feature_Partitions = true;
                        pfObj = new PremiumFeatures();
                        pfObj.setQtyLicensed(sa.getFeatureParameters().getMaxPartitionCount());
                        pfObj.setQtyInUse(sa.getDefinedPartitionCount());
                        break;
                    }
                    case 11: {
                        if (accumMaxCount < 16) {
                            accumMaxCount = 16;
                        }
                        if (!pfa[i].getIsEnabled() || maxPartCnt != 16 || feature_Partitions) break;
                        report = true;
                        feature_Partitions = true;
                        pfObj = new PremiumFeatures();
                        pfObj.setQtyLicensed(sa.getFeatureParameters().getMaxPartitionCount());
                        pfObj.setQtyInUse(sa.getDefinedPartitionCount());
                        break;
                    }
                    case 10: {
                        if (accumMaxCount < 64) {
                            accumMaxCount = 64;
                        }
                        if (!pfa[i].getIsEnabled() || maxPartCnt != 64 || feature_Partitions) break;
                        report = true;
                        feature_Partitions = true;
                        pfObj = new PremiumFeatures();
                        pfObj.setQtyLicensed(sa.getFeatureParameters().getMaxPartitionCount());
                        pfObj.setQtyInUse(sa.getDefinedPartitionCount());
                        break;
                    }
                    case 12: {
                        report = true;
                        feature_SnapShot = true;
                        pfObj = new PremiumFeatures();
                        pfObj.setQtyLicensed(sa.getFeatureParameters().getMaxSnapshots());
                        HLVolumeBundle hlvspb = bundle.getHighLevelVolBundle();
                        SnapshotVolume[] sps = hlvspb.getSnapshotVol();
                        pfObj.setQtyInUse(sps.length);
                        pfObj.setLimit(sa.getFeatureParameters().getMaxSnapshotsPerBase());
                        break;
                    }
                    case 14: {
                        report = true;
                        feature_VolumeCopy = true;
                        pfObj = new PremiumFeatures();
                        pfObj.setQtyLicensed(sa.getFeatureParameters().getMaxVolCopys());
                        HLVolumeBundle hlvcb = bundle.getHighLevelVolBundle();
                        VolumeCopy[] vcs = hlvcb.getVolumeCopy();
                        pfObj.setQtyInUse(vcs.length);
                        pfObj.setLimit(sa.getFeatureParameters().getMaxConcurrentBackgroundCopys());
                        break;
                    }
                    default: {
                        report = false;
                    }
                }
                if (!report) continue;
                this.fillDetails(pfObj, bundle, sa, pfa, i, capNum);
                pfList.add(pfObj);
            }
            this.fillEmptyLicenses(pfList, accumMaxCount, feature_VolumeCopy, feature_SnapShot, feature_Partitions, feature_ReplicationSet, bundle, sa);
        }
        return pfList;
    }

    private void fillEmptyLicenses(List pfList, int accumMaxCount, boolean feature_VolumeCopy, boolean feature_SnapShot, boolean feature_Partitions, boolean feature_ReplicationSet, ObjectBundle bundle, StorageArray sa) {
        if (!feature_VolumeCopy) {
            PremiumFeatures vcpf = this.fillDefaultVolumeCopyLicense(bundle, sa);
            pfList.add(vcpf);
        }
        if (!feature_SnapShot) {
            PremiumFeatures snpf = this.fillDefaultSnapshotLicense(bundle, sa);
            pfList.add(snpf);
        }
        if (!feature_Partitions) {
            PremiumFeatures partpf = this.fillDefaultPartitionsLicense(accumMaxCount, bundle, sa);
            pfList.add(partpf);
        }
        if (!feature_ReplicationSet) {
            PremiumFeatures repsetpf = this.fillDefaultRepSetLicense(bundle, sa);
            pfList.add(repsetpf);
        }
    }

    private PremiumFeatures fillDefaultRepSetLicense(ObjectBundle bundle, StorageArray sa) {
        PremiumFeatures repsetpf = this.buildPremiumFeature(bundle, 13);
        repsetpf.setQtyInUse(bundle.getHighLevelVolBundle().getMirrorVol().length);
        repsetpf.setLimit(sa.getFeatureParameters().getCurrentMaxMirrors());
        return repsetpf;
    }

    private PremiumFeatures fillDefaultPartitionsLicense(int accumMaxCount, ObjectBundle bundle, StorageArray sa) {
        if (accumMaxCount == 0) {
            accumMaxCount = 4;
        }
        int capNum = this.getCapabilityFromName("StorageDomain", accumMaxCount);
        PremiumFeatures partpf = this.buildPremiumFeature(bundle, capNum);
        partpf.setQtyInUse(sa.getDefinedPartitionCount());
        return partpf;
    }

    private PremiumFeatures fillDefaultSnapshotLicense(ObjectBundle bundle, StorageArray sa) {
        PremiumFeatures snpf = this.buildPremiumFeature(bundle, 12);
        HLVolumeBundle hlvspb = bundle.getHighLevelVolBundle();
        SnapshotVolume[] sps = hlvspb.getSnapshotVol();
        snpf.setQtyInUse(sps.length);
        snpf.setLimit(sa.getFeatureParameters().getMaxSnapshotsPerBase());
        return snpf;
    }

    private PremiumFeatures fillDefaultVolumeCopyLicense(ObjectBundle bundle, StorageArray sa) {
        PremiumFeatures vcpf = this.buildPremiumFeature(bundle, 14);
        HLVolumeBundle hlvcb = bundle.getHighLevelVolBundle();
        VolumeCopy[] vcs = hlvcb.getVolumeCopy();
        vcpf.setQtyInUse(vcs.length);
        vcpf.setLimit(sa.getFeatureParameters().getMaxConcurrentBackgroundCopys());
        return vcpf;
    }

    private void fillDetails(PremiumFeatures pfObj, ObjectBundle bundle, StorageArray sa, PremiumFeature[] pfa, int i, int capNum) {
        pfObj.setCapability(capNum);
        pfObj.setCapabilityName(this.getCapabilityFromInt(capNum));
        pfObj.setName(pfObj.getCapabilityName());
        pfObj.setIsCompliant(pfa[i].getIsCompliant());
        this.fillEnabledAndActiveFields(capNum, pfa[i], pfObj, bundle);
        pfObj.setIsWithinLimits(pfa[i].getIsWithinLimits());
        pfObj.setArrayWwn(Convert.bytesToString(bundle.getSa().getSaData().getSaId().getWorldWideName()));
        pfObj.setSafeId(this.bytesToIdentifier(bundle.getSa().getSafeId().getWorldWideName()));
        pfObj.setArrayName(UnicodeTranslator.getString((byte[])sa.getSaData().getStorageArrayLabel().getValue()));
        Tray[] ozTrays = bundle.getTray();
        int count = ozTrays == null ? 0 : ozTrays.length;
        for (int j = 0; j < count; ++j) {
            Tray ozTray = ozTrays[j];
            int trayType = ozTray.getType().getValue();
            if (trayType != 8) continue;
            pfObj.setTraySerialNumber(ozTray.getSerialNumber());
        }
        if (pfObj.getTraySerialNumber() == null) {
            pfObj.setTraySerialNumber("n/a");
        }
        HashMap<String, String> key = new HashMap<String, String>(2);
        String arrayRef = Convert.bytesToString(bundle.getSa().getSaData().getSaId().getWorldWideName());
        String featureRef = pfObj.getCapabilityName();
        key.put("array", arrayRef);
        key.put("featureRef", featureRef);
        pfObj.setKey(key);
    }

    private void fillEnabledAndActiveFields(int capNum, PremiumFeature pf, PremiumFeatures pfObj, ObjectBundle bundle) {
        pfObj.setIsEnabled(pf.getIsEnabled());
        if (!pfObj.isEnabled()) {
            pfObj.setQtyLicensed(0);
            if (capNum != 13) {
                pfObj.setIsActive(pfObj.getQtyInUse() > 0);
            }
        } else if (capNum != 13) {
            pfObj.setIsActive(true);
        }
        if (capNum == 13) {
            pfObj.setIsActive(bundle.getSa().getRemoteMirroringActive());
        }
    }

    private PremiumFeatures buildPremiumFeature(ObjectBundle bundle, int capNum) {
        PremiumFeatures pfObj = new PremiumFeatures();
        pfObj.setCapability(capNum);
        pfObj.setCapabilityName(this.getCapabilityFromInt(capNum));
        pfObj.setName(pfObj.getCapabilityName());
        pfObj.setIsCompliant(false);
        pfObj.setIsEnabled(false);
        pfObj.setIsActive(false);
        pfObj.setIsWithinLimits(false);
        pfObj.setArrayWwn(Convert.bytesToString(bundle.getSa().getSaData().getSaId().getWorldWideName()));
        pfObj.setSafeId(this.bytesToIdentifier(bundle.getSa().getSafeId().getWorldWideName()));
        Tray[] ozTrays = bundle.getTray();
        int count = ozTrays == null ? 0 : ozTrays.length;
        for (int j = 0; j < count; ++j) {
            Tray ozTray = ozTrays[j];
            int trayType = ozTray.getType().getValue();
            if (trayType != 8) continue;
            pfObj.setTraySerialNumber(ozTray.getSerialNumber());
        }
        if (pfObj.getTraySerialNumber() == null) {
            pfObj.setTraySerialNumber("n/a");
        }
        HashMap<String, String> key = new HashMap<String, String>(2);
        String arrayRef = Convert.bytesToString(bundle.getSa().getSaData().getSaId().getWorldWideName());
        String featureRef = pfObj.getCapabilityName();
        key.put("array", arrayRef);
        key.put("featureRef", featureRef);
        pfObj.setKey(key);
        return pfObj;
    }

    private Collection getBundles() throws ConfigMgmtException {
        Trace.methodBegin(this, "getBundles");
        ArrayList<ObjectBundle> bundles = null;
        if (this.scope != null) {
            String arrayWwn = Convert.scopeToArrayKey(this.scope);
            bundles = new ArrayList<ObjectBundle>(1);
            ObjectBundle ob = ObjectBundleManager.getInstance().getObjectBundle(arrayWwn);
            bundles.add(ob);
        } else {
            bundles = ObjectBundleManager.getInstance().getObjectBundles();
        }
        return bundles;
    }

    private String bytesToIdentifier(byte[] data) {
        StringBuffer sbuf = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            sbuf.append(Convert.toHex(data[i], 2));
        }
        return sbuf.toString().toUpperCase();
    }

    private static byte[] buildBinary(String data) {
        byte[] buffer = new byte[data.length() / 2];
        String hex = "0123456789ABCDEF";
        for (int i = 0; i < buffer.length; ++i) {
            int msb = hex.indexOf(data.charAt(i * 2));
            int lsb = hex.indexOf(data.charAt(i * 2 + 1));
            buffer[i] = (byte)(msb << 4 | lsb);
        }
        return buffer;
    }

    public boolean isOperationSupported(String operation) {
        return false;
    }

    public int getItemCount() throws ConfigMgmtException {
        return 0;
    }

    public int getMaxObjects() {
        int maxObj = 0;
        return maxObj;
    }

    public void modify(Object key, Properties props) throws ConfigMgmtException {
        Object deactivateProp;
        Object activateProp;
        String METHOD_NAME = "modify";
        Trace.methodBegin(this, "modify");
        Map myKeys = null;
        if (key instanceof Map) {
            myKeys = (Map)key;
        } else if (key instanceof String) {
            myKeys = Convert.keyAsStringToMap((String)key);
        }
        if (myKeys == null) {
            Trace.error((Object)this, "modify", "missing key obj");
            throw new ConfigMgmtException(ErrorCode.ITEM_NOT_FOUND.getKey(), "missing key obj");
        }
        String myWwn = (String)myKeys.get("array");
        if (myWwn == null) {
            if (this.scope != null) {
                myWwn = Convert.scopeToArrayKey(this.scope);
            } else {
                Trace.error((Object)this, "modify", "missing wwn");
                throw new ConfigMgmtException(ErrorCode.ERROR_SCOPE_REQUIRED.getKey(), "missing wwn");
            }
        }
        if ((activateProp = props.get("activateReplicationSet")) != null) {
            this.activateReplicationSet(myWwn, props);
        }
        if ((deactivateProp = props.get("deactivateReplicationSet")) != null) {
            this.deactivateReplicationSet(myWwn, props);
        }
        Trace.methodEnd(this, "modify");
    }

    private boolean isReplicationSetLicensed(StorageArray sa, int capNum) {
        String METHOD_NAME = "isReplicationSetLicensed";
        Trace.methodBegin(this, "isReplicationSetLicensed");
        PremiumFeature[] pfa = sa.getPremiumFeatures();
        if (pfa != null) {
            for (int i = 0; i < pfa.length; ++i) {
                int myCapNum = pfa[i].getCapability().getValue();
                if (capNum != myCapNum) continue;
                return pfa[i].getIsEnabled();
            }
        }
        Trace.verbose((Object)this, "isReplicationSetLicensed", "No license found");
        return false;
    }

    private VolumeCandidateList getCandidateList(String myWwn, StorageArray sa, VolumeCandidateRequest volumeCandidateRequest) throws ConfigMgmtException {
        String METHOD_NAME = "getCandidateList";
        Trace.methodBegin(this, "getCandidateList");
        VolumeCandidateList volumeCandidateList = new VolumeCandidateList();
        try {
            ObjectBundleManager.getInstance().stopMonitoringThread(myWwn);
            CommandProcessor command = new CommandProcessor(myWwn);
            command.execute(6, (XDRType)volumeCandidateRequest, (XDRType)volumeCandidateList, true);
            ReturnCode rc = volumeCandidateList.getReturnCode();
            if (rc.getValue() != 1) {
                Trace.error((Object)this, "getCandidateList", "getVolumeCandidates() return code:" + rc.getValue());
                LogAPI.staticLog((String)"PREMIUM_FEATURE_MODIFY_ERROR ", (String[])new String[]{ManageArrays.getArrayName(sa)}, (String[])new String[0]);
                throw new ConfigMgmtException(ErrorDescriptor.ERROR_REASON_PREFIX + (OZErrorCode.ERROR_CODE_MIN + rc.getValue()), "modify error");
            }
            try {
                LogAPI.staticLog((String)"PREMIUM_FEATURE_MODIFY ", (String[])new String[]{ManageArrays.getArrayName(sa)}, (String[])new String[0]);
            }
            catch (RuntimeException e) {}
        }
        catch (RPCError rpc) {
            Trace.error((Object)this, "getCandidateList", "RPC error");
            LogAPI.staticLog((String)"PREMIUM_FEATURE_COMM_ERROR", (String[])new String[]{ManageArrays.getArrayName(sa)}, (String[])new String[0]);
            throw new ConfigMgmtException(ErrorCode.ERROR_RPC.getKey(), "RPC error");
        }
        catch (IOException io) {
            Trace.error((Object)this, "getCandidateList", "IO error");
            LogAPI.staticLog((String)"PREMIUM_FEATURE_COMM_ERROR", (String[])new String[]{ManageArrays.getArrayName(sa)}, (String[])new String[0]);
            throw new ConfigMgmtException(ErrorCode.ERROR_COMMUNICATING_WITH_ARRAY.getKey(), "IO error");
        }
        Trace.methodBegin(this, "getCandidateList");
        return volumeCandidateList;
    }

    private Map populateFreeExtentMap(FreeExtent[] freeExtents) {
        HashMap<String, FreeExtent> freeExtentMap = new HashMap<String, FreeExtent>();
        int length = freeExtents == null ? 0 : freeExtents.length;
        for (int i = 0; i < length; ++i) {
            freeExtentMap.put(Convert.bytesToString(freeExtents[i].getFreeExtentRef().getRefToken()), freeExtents[i]);
        }
        return freeExtentMap;
    }

    private VolumeCandidate pickCandidate(VDisk vdisk, VolumeCandidate[] candidates, ObjectBundle bundle) throws ConfigMgmtException {
        String METHOD_NAME = "pickCandidate";
        Trace.methodBegin(this, "pickCandidate");
        VolumeCandidate volumeCandidate = null;
        boolean matchFound = false;
        Map freeExtentMap = this.populateFreeExtentMap(bundle.getFreeExtent());
        for (int i = 0; i < candidates.length; ++i) {
            String freeExtentVGR;
            FreeExtent freeExtent;
            volumeCandidate = candidates[i];
            if (volumeCandidate.getUsableSize() <= 276480000L || volumeCandidate.getRaidLevel().getValue() != vdisk.getRaidLevel() || volumeCandidate.getDriveCount() != vdisk.getNumberOfDisks() || volumeCandidate.getPhyDriveType().getValue() != vdisk.getTypeOfDisks() || (freeExtent = (FreeExtent)freeExtentMap.get(Convert.bytesToString(volumeCandidate.getFreeExtentRef().getRefToken()))) == null || !(freeExtentVGR = Convert.bytesToStringRaw(freeExtent.getVolumeGroupRef().getRefToken())).equals(vdisk.getVDiskReference()) || freeExtent.getRawCapacity() <= 276480000L) continue;
            matchFound = true;
            break;
        }
        if (!matchFound) {
            throw new ConfigMgmtException(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION.getKey(), null, "pickCandidate: no candidate found.", null, 100);
        }
        Trace.methodEnd(this, "pickCandidate");
        return volumeCandidate;
    }

    private VolumeCandidate getCandidateFromVDiskName(String vdiskName, String myWwn, ObjectBundle bundle, StorageArray sa) throws ConfigMgmtException {
        String METHOD_NAME = "getCandidateFromVDiskName";
        Trace.methodBegin(this, "getCandidateFromVDiskName");
        VolumeCandidate volumeCandidate = null;
        int raidLevel = 0;
        PhysicalDriveType physicalDriveType = null;
        try {
            SearchFilter filter = new SearchFilter("name", vdiskName);
            ManageVDisks mvd = (ManageVDisks)ManageVDisksFactory.getManager(this.cfgctx, this.scope, filter);
            List vDiskList = mvd.getItemList();
            VDisk vdisk = null;
            if (vDiskList.iterator().hasNext()) {
                Iterator iter = vDiskList.iterator();
                if (iter.hasNext()) {
                    vdisk = (VDisk)iter.next();
                    if (vdisk.getVDiskDiskStatus() != 1) {
                        throw new ConfigMgmtException("error.vdisk.disk.status.not.optimal", new String[]{vdisk.getName()}, "One or more disks on a vdisk " + vdisk.getName() + " do not have an optimal status.", null);
                    }
                    raidLevel = vdisk.getRaidLevel();
                    physicalDriveType = new PhysicalDriveType(vdisk.getTypeOfDisks());
                }
            } else {
                throw new ConfigMgmtException(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION.getKey(), null, "getCandidateFromVDiskName: error getting VDiskList.", null, 100);
            }
            CandidateSelectionTypeData candidateSelectionTypeData = new CandidateSelectionTypeData();
            candidateSelectionTypeData.setCandidateSelectionType(new CandidateSelectionType(1));
            VolumeCandidateRequest volumeCandidateRequest = new VolumeCandidateRequest();
            volumeCandidateRequest.setCandidateSelectionType(candidateSelectionTypeData);
            volumeCandidateRequest.setRaidLevel(new RAIDLevel(raidLevel));
            volumeCandidateRequest.setPhyDriveType(physicalDriveType);
            VolumeCandidate[] volumeCandidates = this.getCandidateList(myWwn, sa, volumeCandidateRequest).getVolumeCandidate();
            volumeCandidate = this.pickCandidate(vdisk, volumeCandidates, bundle);
        }
        catch (ConfigMgmtException cme) {
            throw cme;
        }
        catch (Exception e) {
            throw new ConfigMgmtException(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION.getKey(), null, e.getMessage(), null, 100);
        }
        Trace.methodEnd(this, "getCandidateFromVDiskName");
        return volumeCandidate;
    }

    private DriveRefList createDriveRefList(String[] diskKeysAsStrings, Drive[] drives, int typeOfDisks) throws ConfigMgmtException {
        int i;
        String METHOD_NAME = "createDriveRefList";
        Trace.methodBegin(this, "createDriveRefList");
        Map map = null;
        Drive drive = null;
        String driveRefString = null;
        int firstDriveType = -1;
        int diskCount = diskKeysAsStrings != null ? diskKeysAsStrings.length : 0;
        DriveRef[] driveRefs = new DriveRef[diskCount];
        HashMap<String, Drive> driveMap = new HashMap<String, Drive>();
        int length = drives != null ? drives.length : 0;
        for (i = 0; i < length; ++i) {
            driveMap.put(Convert.bytesToStringRaw(drives[i].getDriveRef().getRefToken()), drives[i]);
        }
        for (i = 0; i < diskCount; ++i) {
            map = Convert.keyAsStringToMap(diskKeysAsStrings[i]);
            driveRefString = (String)map.get("diskRef");
            drive = (Drive)driveMap.get(driveRefString);
            if (drive != null) {
                if (firstDriveType == -1) {
                    firstDriveType = drive.getPhyDriveType().getValue();
                } else if (firstDriveType != drive.getPhyDriveType().getValue()) {
                    Trace.error((Object)this, "createDriveRefList", "Drive type " + drive.getPhyDriveType().getValue() + " does not match first drive type: " + firstDriveType);
                    throw new ConfigMgmtException("volume.create.error.invalid.disk.type", "List of disks passed contains different types of disks.");
                }
                if (drive.getHotSpare() || !"00:00:00:00:00:00:00:00:00:00:00:00:00:00:00:00:00:00:00:00".equals(Convert.bytesToString(drive.getCurrentVolumeGroupRef().getRefToken()))) {
                    Trace.error((Object)this, "createDriveRefList", Convert.bytesToString(drive.getWorldWideName()) + ": already in use");
                    throw new ConfigMgmtException("volume.create.error.invalid.disk.role", "List of disks passed contains disk that is in use.");
                }
                if (drive.getOffline()) {
                    Trace.error((Object)this, "createDriveRefList", Convert.bytesToString(drive.getWorldWideName()) + ": is offline");
                    throw new ConfigMgmtException("volume.create.error.invalid.disk.state", "List of disks passed contains disk that is offline.");
                }
                if (drive.getStatus().getValue() != 1) {
                    Trace.error((Object)this, "createDriveRefList", Convert.bytesToString(drive.getWorldWideName()) + ": does not have optimal status.");
                    throw new ConfigMgmtException("volume.create.error.invalid.disk.status", "List of disks passed contains disk that is not with optimal status.");
                }
                if (typeOfDisks != 0 && drive.getPhyDriveType().getValue() != typeOfDisks) {
                    Trace.error((Object)this, "createDriveRefList", Convert.bytesToString(drive.getWorldWideName()) + ": type mismatch " + drive.getPhyDriveType().getValue() + " != " + typeOfDisks);
                    throw new ConfigMgmtException("volume.create.error.invalid.disk.type", "List of disks passed contains disk type mismatch.");
                }
            } else {
                throw new ConfigMgmtException("incorrect.method.parameter", "Disk key passed not valid.");
            }
            driveRefs[i] = drive.getDriveRef();
        }
        DriveRefList driveRefList = new DriveRefList();
        driveRefList.setDriveRef(driveRefs);
        Trace.methodEnd(this, "createDriveRefList");
        return driveRefList;
    }

    private VolumeCandidate getCandidateFromDiskList(String listOfDisks, int raidLevel, int typeOfDisks, String myWwn, ObjectBundle bundle, StorageArray sa) throws ConfigMgmtException {
        VolumeCandidate vc;
        block6: {
            String METHOD_NAME = "getCandidateFromDiskList";
            Trace.methodBegin(this, "getCandidateFromDiskList");
            vc = null;
            try {
                int i;
                String[] diskKeysAsStrings = Convert.commaStringToArray(listOfDisks);
                DriveRefList driveRefList = this.createDriveRefList(diskKeysAsStrings, bundle.getDrive(), typeOfDisks);
                CandidateSelectionTypeData candidateSelectionTypeData = new CandidateSelectionTypeData();
                candidateSelectionTypeData.setCandidateSelectionType(new CandidateSelectionType(2));
                candidateSelectionTypeData.setDriveRefList(driveRefList);
                PhysicalDriveType physicalDriveType = new PhysicalDriveType(typeOfDisks);
                VolumeCandidateRequest volumeCandidateRequest = new VolumeCandidateRequest();
                volumeCandidateRequest.setCandidateSelectionType(candidateSelectionTypeData);
                volumeCandidateRequest.setRaidLevel(new RAIDLevel(raidLevel));
                volumeCandidateRequest.setPhyDriveType(physicalDriveType);
                VolumeCandidate[] volumeCandidates = this.getCandidateList(myWwn, sa, volumeCandidateRequest).getVolumeCandidate();
                if (volumeCandidates.length <= 0) break block6;
                DriveRef[] drives = driveRefList.getDriveRef();
                HashMap<String, DriveRef> driveMap = new HashMap<String, DriveRef>();
                int length = drives != null ? drives.length : 0;
                for (i = 0; i < length; ++i) {
                    driveMap.put(Convert.bytesToStringRaw(drives[i].getRefToken()), drives[i]);
                }
                for (i = 0; i < volumeCandidates.length; ++i) {
                    DriveRef[] dr;
                    VolumeCandidate volumeCandidate = volumeCandidates[i];
                    if (volumeCandidate.getRaidLevel().getValue() != raidLevel || (dr = volumeCandidate.getDriveRefList().getDriveRef()).length != drives.length) continue;
                    boolean allFound = true;
                    for (int j = 0; j < dr.length; ++j) {
                        if (driveMap.get(Convert.bytesToStringRaw(dr[j].getRefToken())) != null) continue;
                        allFound = false;
                        break;
                    }
                    if (!allFound) continue;
                    vc = volumeCandidate;
                    break;
                }
            }
            catch (ConfigMgmtException cme) {
                throw cme;
            }
            catch (Exception e) {
                throw new ConfigMgmtException(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION.getKey(), null, e.getMessage(), null, 100);
            }
        }
        Trace.methodEnd(this, "getCandidateFromDiskList");
        return vc;
    }

    private VolumeCandidate getCandidateFromDiskCount(int numberOfDisks, int typeOfDisks, int raidLevel, String myWwn, StorageArray sa) throws ConfigMgmtException {
        String METHOD_NAME = "getCandidateFromDiskCount";
        Trace.methodBegin(this, "getCandidateFromDiskCount");
        VolumeCandidate vc = null;
        try {
            CandidateSelectionTypeData candidateSelectionTypeData = new CandidateSelectionTypeData();
            candidateSelectionTypeData.setCandidateSelectionType(new CandidateSelectionType(3));
            PhysicalDriveType physicalDriveType = new PhysicalDriveType(typeOfDisks);
            VolumeCandidateRequest volumeCandidateRequest = new VolumeCandidateRequest();
            volumeCandidateRequest.setCandidateSelectionType(candidateSelectionTypeData);
            volumeCandidateRequest.setRaidLevel(new RAIDLevel(raidLevel));
            volumeCandidateRequest.setPhyDriveType(physicalDriveType);
            VolumeCandidate[] volumeCandidates = this.getCandidateList(myWwn, sa, volumeCandidateRequest).getVolumeCandidate();
            for (int i = 0; i < volumeCandidates.length; ++i) {
                VolumeCandidate volumeCandidate = volumeCandidates[i];
                if (volumeCandidate.getRaidLevel().getValue() != raidLevel || volumeCandidate.getDriveCount() != numberOfDisks) continue;
                vc = volumeCandidate;
                break;
            }
        }
        catch (Exception e) {
            throw new ConfigMgmtException(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION.getKey(), null, e.getMessage(), null, 100);
        }
        Trace.methodEnd(this, "getCandidateFromDiskCount");
        return vc;
    }

    private VolumeCandidate getCandidateFromAnyVDisk(String myWwn, ObjectBundle bundle, StorageArray sa, Properties props) throws ConfigMgmtException {
        String METHOD_NAME = "getCandidateFromAnyVDisk";
        Trace.methodBegin(this, "getCandidateFromAnyVDisk");
        VolumeCandidate vc = null;
        Object physicalDriveType = null;
        try {
            int i;
            Trace.verbose((Object)this, "getCandidateFromAnyVDisk", "Checking for usable RAID1 VDisk");
            CandidateSelectionTypeData candidateSelectionTypeData = new CandidateSelectionTypeData();
            candidateSelectionTypeData.setCandidateSelectionType(new CandidateSelectionType(1));
            VolumeCandidateRequest volumeCandidateRequest = new VolumeCandidateRequest();
            volumeCandidateRequest.setCandidateSelectionType(candidateSelectionTypeData);
            volumeCandidateRequest.setRaidLevel(new RAIDLevel(1));
            VolumeCandidate[] volumeCandidates = this.getCandidateList(myWwn, sa, volumeCandidateRequest).getVolumeCandidate();
            for (i = 0; i < volumeCandidates.length; ++i) {
                if (volumeCandidates[i].getUsableSize() <= 276480000L) continue;
                vc = volumeCandidates[i];
                break;
            }
            if (vc == null) {
                Trace.verbose((Object)this, "getCandidateFromAnyVDisk", "Checking for usable RAID3 VDisk");
                volumeCandidateRequest.setRaidLevel(new RAIDLevel(3));
                volumeCandidates = this.getCandidateList(myWwn, sa, volumeCandidateRequest).getVolumeCandidate();
                for (i = 0; i < volumeCandidates.length; ++i) {
                    if (volumeCandidates[i].getUsableSize() <= 276480000L) continue;
                    vc = volumeCandidates[i];
                    break;
                }
                if (vc == null) {
                    Trace.verbose((Object)this, "getCandidateFromAnyVDisk", "Checking for usable RAID5 VDisk");
                    volumeCandidateRequest.setRaidLevel(new RAIDLevel(5));
                    volumeCandidates = this.getCandidateList(myWwn, sa, volumeCandidateRequest).getVolumeCandidate();
                    for (i = 0; i < volumeCandidates.length; ++i) {
                        if (volumeCandidates[i].getUsableSize() <= 276480000L) continue;
                        vc = volumeCandidates[i];
                        break;
                    }
                    if (vc == null) {
                        Trace.verbose((Object)this, "getCandidateFromAnyVDisk", "Last chance... try a new RAID1 VDisk");
                        vc = this.getCandidateFromDiskCount(2, this.getDiskType(props), 1, myWwn, sa);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new ConfigMgmtException(ErrorCode.ERROR_VENDOR_UNEXPECTED_CONDITION.getKey(), null, e.getMessage(), null, 100);
        }
        Trace.methodEnd(this, "getCandidateFromAnyVDisk");
        return vc;
    }

    private int getDiskType(Properties props) {
        int typeOfDisks = 0;
        Object typeOfDisksProp = props.get("typeOfDisks");
        if (typeOfDisksProp != null) {
            typeOfDisks = new Integer((String)typeOfDisksProp);
            typeOfDisks = ProfileDataManager.convertProfileDriveTypeTo6130DriveType(typeOfDisks);
        }
        return typeOfDisks;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createMetadataVolume(String myWwn, Properties props, ObjectBundle bundle, StorageArray sa) throws ConfigMgmtException {
        String METHOD_NAME = "createMetadataVolume";
        Trace.methodBegin(this, "createMetadataVolume");
        VolumeCandidate volumeCandidate = null;
        try {
            Object virtualDiskProp = props.get("virtualDisk");
            if (virtualDiskProp != null) {
                String virtualDiskName = (String)virtualDiskProp;
                Trace.verbose((Object)this, "createMetadataVolume", "VIRTUAL_DISK property = " + virtualDiskName);
                if (virtualDiskName == null) throw new ConfigMgmtException("incorrect.method.parameter", "Invalid virtual disk key.");
                volumeCandidate = this.getCandidateFromVDiskName(virtualDiskName, myWwn, bundle, sa);
            } else {
                Object listOfDisksProp = props.get("listOfDisks");
                Object raidProp = props.get("raidLevel");
                if (listOfDisksProp != null) {
                    String listOfDisksString = (String)listOfDisksProp;
                    Trace.verbose((Object)this, "createMetadataVolume", "LIST_OF_DISKS property = " + listOfDisksString);
                    if (raidProp == null) throw new ConfigMgmtException(ErrorCode.ERROR_INCOMPLETE_KEY.getKey(), "missing RAID_LEVEL key");
                    int raidLevel = (Integer)raidProp;
                    Trace.verbose((Object)this, "createMetadataVolume", "RAID_LEVEL property = " + raidLevel);
                    volumeCandidate = this.getCandidateFromDiskList(listOfDisksString, raidLevel, this.getDiskType(props), myWwn, bundle, sa);
                } else {
                    Object numberOfDisksProp = props.get("numberOfDisks");
                    if (numberOfDisksProp != null) {
                        int numberOfDisks = (Integer)numberOfDisksProp;
                        Trace.verbose((Object)this, "createMetadataVolume", "NUMBER_OF_DISKS property = " + numberOfDisks);
                        if (raidProp == null) throw new ConfigMgmtException(ErrorCode.ERROR_INCOMPLETE_KEY.getKey(), "missing RAID_LEVEL key");
                        int raidLevel = (Integer)raidProp;
                        Trace.verbose((Object)this, "createMetadataVolume", "RAID_LEVEL property = " + raidLevel);
                        volumeCandidate = this.getCandidateFromDiskCount(numberOfDisks, this.getDiskType(props), raidLevel, myWwn, sa);
                    } else {
                        Trace.verbose((Object)this, "createMetadataVolume", "No properties of interest found, going with automatic selection.");
                        volumeCandidate = this.getCandidateFromAnyVDisk(myWwn, bundle, sa, props);
                    }
                }
            }
            if (volumeCandidate == null) throw new ConfigMgmtException("error.no.volume.candidates", "No replication set metadata volume candididates were found.");
            CommandProcessor command = new CommandProcessor(myWwn);
            ReturnCode rc = new ReturnCode();
            MetadataVolCreationDescriptor metadataVolCreationDescriptor = new MetadataVolCreationDescriptor();
            metadataVolCreationDescriptor.setMetadataVolType(new MetadataVolType(1));
            UserAssignedLabel label0 = new UserAssignedLabel();
            label0.setValue(UnicodeTranslator.getBytes((String)"Replication Repository #1"));
            metadataVolCreationDescriptor.setCtl0Label(label0);
            UserAssignedLabel label1 = new UserAssignedLabel();
            label1.setValue(UnicodeTranslator.getBytes((String)"Replication Repository #2"));
            metadataVolCreationDescriptor.setCtl1Label(label1);
            metadataVolCreationDescriptor.setCandidate(volumeCandidate);
            command.execute(105, (XDRType)metadataVolCreationDescriptor, (XDRType)rc, true);
            if (rc.getValue() != 1) {
                Trace.error((Object)this, "createMetadataVolume", "createMetadataVolume() return code: " + rc.getValue());
                LogAPI.staticLog((String)"PREMIUM_FEATURE_MODIFY_ERROR ", (String[])new String[]{ManageArrays.getArrayName(sa)}, (String[])new String[0]);
                throw new ConfigMgmtException(ErrorDescriptor.ERROR_REASON_PREFIX + (OZErrorCode.ERROR_CODE_MIN + rc.getValue()), "modify error");
            }
            LogAPI.staticLog((String)"PREMIUM_FEATURE_MODIFY ", (String[])new String[]{ManageArrays.getArrayName(sa)}, (String[])new String[0]);
            return;
        }
        catch (RPCError rpc) {
            Trace.error((Object)this, "createMetadataVolume", "RPC error");
            LogAPI.staticLog((String)"PREMIUM_FEATURE_COMM_ERROR", (String[])new String[]{ManageArrays.getArrayName(sa)}, (String[])new String[0]);
            throw new ConfigMgmtException(ErrorCode.ERROR_RPC.getKey(), "RPC error");
        }
        catch (IOException io) {
            Trace.error((Object)this, "createMetadataVolume", "IO error");
            LogAPI.staticLog((String)"PREMIUM_FEATURE_COMM_ERROR", (String[])new String[]{ManageArrays.getArrayName(sa)}, (String[])new String[0]);
            throw new ConfigMgmtException(ErrorCode.ERROR_COMMUNICATING_WITH_ARRAY.getKey(), "IO error");
        }
        finally {
            ObjectBundleManager.getInstance().forceBundleReload(myWwn);
        }
    }

    private void activateReplicationSet(String myWwn, Properties props) throws ConfigMgmtException {
        String METHOD_NAME = "activateReplicationSet";
        Trace.methodBegin(this, "activateReplicationSet");
        ObjectBundle bundle = null;
        StorageArray sa = null;
        try {
            bundle = ObjectBundleManager.getInstance().getObjectBundle(myWwn);
            sa = bundle.getSa();
            if (!this.isReplicationSetLicensed(sa, 13)) {
                Trace.error((Object)this, "activateReplicationSet", "license disabled");
                throw new ConfigMgmtException(ErrorCode.ERROR_LICENSE_DISABLED.getKey(), "license disabled");
            }
            this.createMetadataVolume(myWwn, props, bundle, sa);
            ObjectBundleManager.getInstance().stopMonitoringThread(myWwn);
            CommandProcessor command = new CommandProcessor(myWwn);
            ReturnCode rc = new ReturnCode();
            command.execute(106, null, (XDRType)rc, true);
            Trace.verbose((Object)this, "activateReplicationSet", "activateMirroring() return code: " + rc.getValue());
            if (rc.getValue() != 1) {
                Trace.error((Object)this, "activateReplicationSet", "activateMirroring() return code: " + rc.getValue());
                LogAPI.staticLog((String)"PREMIUM_FEATURE_MODIFY_ERROR ", (String[])new String[]{ManageArrays.getArrayName(sa)}, (String[])new String[0]);
                throw new ConfigMgmtException(ErrorDescriptor.ERROR_REASON_PREFIX + (OZErrorCode.ERROR_CODE_MIN + rc.getValue()), "modify error");
            }
            LogAPI.staticLog((String)"PREMIUM_FEATURE_MODIFY ", (String[])new String[]{ManageArrays.getArrayName(sa)}, (String[])new String[0]);
        }
        catch (RPCError rpc) {
            Trace.error((Object)this, "activateReplicationSet", "RPC error");
            LogAPI.staticLog((String)"PREMIUM_FEATURE_COMM_ERROR", (String[])new String[]{ManageArrays.getArrayName(sa)}, (String[])new String[0]);
            throw new ConfigMgmtException(ErrorCode.ERROR_RPC.getKey(), "RPC error");
        }
        catch (IOException io) {
            Trace.error((Object)this, "activateReplicationSet", "IO error");
            LogAPI.staticLog((String)"PREMIUM_FEATURE_COMM_ERROR", (String[])new String[]{ManageArrays.getArrayName(sa)}, (String[])new String[0]);
            throw new ConfigMgmtException(ErrorCode.ERROR_COMMUNICATING_WITH_ARRAY.getKey(), "IO error");
        }
        finally {
            ObjectBundleManager.getInstance().forceBundleReload(myWwn);
        }
        Trace.methodBegin(this, "activateReplicationSet");
    }

    private void deactivateReplicationSet(String myWwn, Properties props) throws ConfigMgmtException {
        String METHOD_NAME = "deactivateRepset";
        Trace.methodBegin(this, "deactivateRepset");
        ObjectBundle bundle = null;
        StorageArray sa = null;
        try {
            bundle = ObjectBundleManager.getInstance().getObjectBundle(myWwn);
            sa = bundle.getSa();
            if (!sa.getRemoteMirroringActive()) {
                Trace.error((Object)this, "deactivateRepset", "repset license not activated.");
                throw new ConfigMgmtException(ErrorCode.ERROR_REPSET_LICENSE_NOT_ACTIVATED.getKey(), "repset license not activated");
            }
            ObjectBundleManager.getInstance().stopMonitoringThread(myWwn);
            CommandProcessor command = new CommandProcessor(myWwn);
            ReturnCode rc = new ReturnCode();
            command = new CommandProcessor(myWwn);
            command.execute(107, null, (XDRType)rc, true);
            if (rc.getValue() != 1) {
                Trace.error((Object)this, "deactivateRepset", "deactivateMirroring() return code: " + rc.getValue());
                LogAPI.staticLog((String)"PREMIUM_FEATURE_MODIFY_ERROR ", (String[])new String[]{ManageArrays.getArrayName(sa)}, (String[])new String[0]);
                throw new ConfigMgmtException(ErrorDescriptor.ERROR_REASON_PREFIX + (OZErrorCode.ERROR_CODE_MIN + rc.getValue()), "license modify error");
            }
            LogAPI.staticLog((String)"PREMIUM_FEATURE_MODIFY ", (String[])new String[]{ManageArrays.getArrayName(sa)}, (String[])new String[0]);
        }
        catch (RPCError rpc) {
            Trace.error((Object)this, "deactivateRepset", "RPC error");
            LogAPI.staticLog((String)"PREMIUM_FEATURE_COMM_ERROR", (String[])new String[]{ManageArrays.getArrayName(sa)}, (String[])new String[0]);
            throw new ConfigMgmtException(ErrorCode.ERROR_RPC.getKey(), "RPC error");
        }
        catch (IOException io) {
            Trace.error((Object)this, "deactivateRepset", "IO error");
            LogAPI.staticLog((String)"PREMIUM_FEATURE_COMM_ERROR", (String[])new String[]{ManageArrays.getArrayName(sa)}, (String[])new String[0]);
            throw new ConfigMgmtException(ErrorCode.ERROR_COMMUNICATING_WITH_ARRAY.getKey(), "IO error");
        }
        finally {
            ObjectBundleManager.getInstance().forceBundleReload(myWwn);
        }
        Trace.methodEnd(this, "deactivateRepset");
    }

    public static interface ModifyProps {
        public static final String VIRTUAL_DISK = "virtualDisk";
        public static final String LIST_OF_DISKS = "listOfDisks";
        public static final String NUMBER_OF_DISKS = "numberOfDisks";
        public static final String TYPE_OF_DISKS = "typeOfDisks";
        public static final String RAID_LEVEL = "raidLevel";
        public static final String ACTIVATE_REPLICATION_SET = "activateReplicationSet";
        public static final String DEACTIVATE_REPLICATION_SET = "deactivateReplicationSet";
    }

    public static interface KeyMap {
        public static final String ARRAY = "array";
        public static final String WWN = "wwn";
        public static final String FEATURE_REF = "featureRef";
    }

    public static interface CreateProps {
        public static final String CAPABILITY_KEY = "capability";
        public static final String VERSION_KEY = "version";
        public static final String DIGEST_KEY = "digest";
        public static final String FILE_KEY = "file";
        public static final String WWN_KEY = "wwn";
    }

    public static interface FeatureName {
        public static final String SHARED_VOLUME = "SharedVolume";
        public static final String STORAGE_POOL = "StorageDomain";
        public static final String STORAGE_POOL_2 = "StorageDomain2";
        public static final String STORAGE_POOL_4 = "StorageDomain4";
        public static final String STORAGE_POOL_8 = "StorageDomain8";
        public static final String STORAGE_POOL_16 = "StorageDomain16";
        public static final String STORAGE_POOL_64 = "StorageDomain64";
        public static final String STORAGE_POOL_MAX = "StorageDomainMax";
        public static final String AUTO_SYNC = "AutoSync";
        public static final String AUTO_LUN_XFER = "AutoLunTransfer";
        public static final String MIXED_RAIDLEVEL = "MixedRaidLevel";
        public static final String MIXED_SNAPSHOTS = "Snapshot";
        public static final String SUB_LUNS = "SubLunsAllowed";
        public static final String VOLUME_COPY = "VolumeCopy";
        public static final String REMOTE_MIRROR = "ReplicationSet";
        public static final String UNKNOWN = "Unknown";
    }
}

