/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz;

import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.ErrorCode;
import com.sun.netstorage.array.mgmt.cfg.core.ManagerInterface;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.SEItemNotFoundException;
import com.sun.netstorage.array.mgmt.cfg.core.impl.ObjectBundleManager;
import com.sun.netstorage.array.mgmt.cfg.core.impl.oz.CommandProcessor;
import com.sun.netstorage.array.mgmt.cfg.core.impl.oz.OZErrorCode;
import com.sun.netstorage.array.mgmt.cfg.core.logic.Scope;
import com.sun.netstorage.array.mgmt.cfg.core.logic.SearchFilter;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageFCPortsInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.FCPort;
import com.sun.netstorage.array.mgmt.cfg.util.Convert;
import com.sun.netstorage.array.mgmt.logger.LogAPI;
import devmgr.versioned.jrpc.RPCError;
import devmgr.versioned.jrpc.XDRType;
import devmgr.versioned.symbol.Controller;
import devmgr.versioned.symbol.ControllerRef;
import devmgr.versioned.symbol.FibreInterface;
import devmgr.versioned.symbol.IOInterfaceTypeData;
import devmgr.versioned.symbol.InterfaceUpdateDescriptor;
import devmgr.versioned.symbol.ObjectBundle;
import devmgr.versioned.symbol.ReturnCode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class ManageFCPorts
implements ManageFCPortsInterface {
    private ConfigContext cfgctx;
    private SearchFilter sf;
    private Scope scope;
    String arrayName;

    public void init(ConfigContext ctx, Scope s, SearchFilter f) throws ConfigMgmtException {
        this.cfgctx = ctx;
        this.scope = s;
        this.sf = f;
    }

    private Collection getBundles(Scope scope) throws ConfigMgmtException {
        ArrayList<ObjectBundle> bundles = null;
        if (scope != null) {
            String arrayWWN = Convert.scopeToArrayKey(scope);
            ArrayList<ObjectBundle> bl = new ArrayList<ObjectBundle>(1);
            try {
                ObjectBundle ob = ObjectBundleManager.getInstance().getObjectBundle(arrayWWN);
                bl.add(ob);
            }
            catch (SEItemNotFoundException e) {
                Trace.error((Object)this, (ConfigMgmtException)e);
            }
            bundles = bl;
        } else {
            bundles = ObjectBundleManager.getInstance().getObjectBundles();
        }
        return bundles;
    }

    public List getItemList() throws ConfigMgmtException {
        String METHOD_NAME = "getItemList";
        Trace.methodBegin(this, "getItemList");
        ArrayList<FCPort> fcPortList = new ArrayList<FCPort>();
        Collection bundles = this.getBundles(this.scope);
        Iterator iter = bundles.iterator();
        while (iter.hasNext()) {
            ObjectBundle bundle = (ObjectBundle)iter.next();
            String arrayWWN = Convert.bytesToString(bundle.getSa().getSaData().getSaId().getWorldWideName());
            Controller[] ozControllers = bundle.getController();
            int count = ozControllers == null ? 0 : ozControllers.length;
            for (int i = 0; i < count; ++i) {
                Object contRefKey;
                Controller ozController = ozControllers[i];
                String controllerRef = null;
                if (this.scope != null && (contRefKey = this.scope.getAttribute("controller")) != null) {
                    Trace.verbose((Object)this, "getItemList", "Detected controller reference key");
                    if (contRefKey instanceof Map) {
                        controllerRef = (String)((Map)contRefKey).get("controllerRef");
                    } else if (contRefKey instanceof String) {
                        controllerRef = ((String)contRefKey).indexOf(Convert.KEY_NAME_VAL_SEPARATOR) >= 0 ? (String)Convert.keyAsStringToMap((String)contRefKey).get("controllerRef") : (String)contRefKey;
                    }
                }
                Trace.verbose((Object)this, "getItemList", "Controller reference in scope:" + controllerRef);
                if (controllerRef != null && controllerRef.length() != 0 && !controllerRef.equals(Convert.bytesToString(ozController.getControllerRef().getRefToken()))) continue;
                IOInterfaceTypeData[] hostInterfaces = ozController.getHostInterfaces();
                for (int j = 0; j < hostInterfaces.length; ++j) {
                    if (2 != hostInterfaces[j].getInterfaceType().getValue()) continue;
                    FibreInterface ozFcPort = hostInterfaces[j].getFibre();
                    FCPort fcPort = new FCPort();
                    this.setProps(ozFcPort, fcPort);
                    HashMap<String, String> refKey = new HashMap<String, String>(2);
                    refKey.put("array", arrayWWN);
                    refKey.put("controllerRef", Convert.bytesToString(ozController.getControllerRef().getRefToken()));
                    refKey.put("portName", fcPort.getPortName());
                    fcPort.setKey(refKey);
                    fcPortList.add(fcPort);
                }
            }
        }
        return fcPortList;
    }

    private void setProps(FibreInterface ozFcPort, FCPort fcPort) throws ConfigMgmtException {
        fcPort.setChannel(ozFcPort.getChannel());
        fcPort.setChannelMiswire(ozFcPort.getChanMiswire());
        fcPort.setEsmMiswire(ozFcPort.getEsmMiswire());
        fcPort.setHardAddress(ozFcPort.getHardAddress());
        fcPort.setDegraded(ozFcPort.getIsDegraded());
        fcPort.setLinkStatus(ozFcPort.getLinkStatus().getValue());
        fcPort.setLoopId(ozFcPort.getLoopID());
        fcPort.setMaxSpeed(ozFcPort.getMaxSpeed());
        fcPort.setNodeName(Convert.bytesToString(ozFcPort.getNodeName()));
        fcPort.setPart(ozFcPort.getPart());
        fcPort.setPortID(Convert.bytesToString(ozFcPort.getPortId()));
        fcPort.setPortName(Convert.bytesToString(ozFcPort.getPortName()));
        fcPort.setSpeed(ozFcPort.getSpeed());
        fcPort.setSpeedControl(ozFcPort.getSpeedControl().getValue());
        fcPort.setSpeedNegError(ozFcPort.getSpeedNegError());
        fcPort.setTopology(ozFcPort.getTopology().getValue());
        fcPort.setName("" + ozFcPort.getChannel());
    }

    public int getItemCount() throws ConfigMgmtException {
        return this.getItemList().size();
    }

    public void modify(Object key, Properties props) throws ConfigMgmtException {
        String METHOD_NAME = "modify";
        Object netConfig = null;
        Map keyMap = null;
        keyMap = key instanceof Map ? (Map)key : Convert.keyAsStringToMap((String)key);
        try {
            String arraywwn = (String)keyMap.get("array");
            CommandProcessor command = new CommandProcessor(arraywwn);
            ObjectBundleManager.getInstance().stopMonitoringThread(arraywwn);
            String name = (String)keyMap.get("portName");
            FCPort fcPort = this.getFCPortByName(name);
            Enumeration<?> enumeration = props.propertyNames();
            while (enumeration.hasMoreElements()) {
                int requestedLoopID;
                String currElement = (String)enumeration.nextElement();
                Trace.verbose((Object)this, "modify", "Modify - Element: " + currElement);
                if (props.get(currElement) == null) {
                    Trace.error((Object)this, "modify", "Property value is null for property: " + currElement);
                    continue;
                }
                if (!"PREFERRED_LOOPID".equals(currElement) || (requestedLoopID = new Integer((String)props.get(currElement)).intValue()) == fcPort.getLoopId()) continue;
                InterfaceUpdateDescriptor updateDesc = new InterfaceUpdateDescriptor();
                updateDesc.setPreferredID(new Integer((String)props.get(currElement)).intValue());
                this.setPreferredId(command, keyMap, updateDesc);
            }
            ObjectBundleManager.getInstance().forceBundleReload(arraywwn);
        }
        catch (RPCError e) {
            Trace.error((Object)this, (Throwable)e);
            LogAPI.staticLog((String)"FCPORT_MODIFY_ERROR", (String[])new String[0], (String[])new String[0]);
            throw new ConfigMgmtException(ErrorCode.ERROR_RPC.getKey(), e.getMessage());
        }
        catch (IOException e) {
            Trace.error((Object)this, (Throwable)e);
            LogAPI.staticLog((String)"FCPORT_MODIFY_ERROR", (String[])new String[0], (String[])new String[0]);
            throw new ConfigMgmtException(ErrorCode.ERROR_COMMUNICATING_WITH_ARRAY.getKey(), e.getMessage());
        }
        catch (ConfigMgmtException cme) {
            LogAPI.staticLog((String)"FCPORT_MODIFY_ERROR", (String[])new String[0], (String[])new String[0]);
            throw cme;
        }
        LogAPI.staticLog((String)"FCPORT_MODIFY_SUCCESS", (String[])new String[0], (String[])new String[0]);
    }

    private void setPreferredId(CommandProcessor command, Map key, InterfaceUpdateDescriptor updateDesc) throws ConfigMgmtException {
        String METHOD_NAME = "setPreferredId";
        if (key == null) {
            throw new ConfigMgmtException("incorrect.method.parameter", "Object key is null.");
        }
        if (updateDesc == null) {
            throw new ConfigMgmtException("incorrect.method.parameter", "Update descriptor is null");
        }
        ControllerRef cRef = this.getControllerRefForKey(key.get("portName"));
        if (cRef == null) {
            String msg = new String("Unable to get controller reference");
            throw new ConfigMgmtException("error.systemError", msg);
        }
        updateDesc.setPortName(Convert.stringToBytes((String)key.get("portName")));
        updateDesc.setControllerRef(cRef);
        ReturnCode retCode = new ReturnCode();
        command.execute(35, (XDRType)updateDesc, (XDRType)retCode, true);
        if (retCode.getValue() != 1) {
            String msg = "setPreferredId operation failed: " + retCode.getValue();
            Trace.error((Object)this, "setPreferredId", msg);
            throw new ConfigMgmtException("error.reason." + (OZErrorCode.ERROR_CODE_MIN + retCode.getValue()), msg);
        }
    }

    private ControllerRef getControllerRefForKey(Object fcPortKey) throws ConfigMgmtException {
        String METHOD_NAME = "getControllerRefForKey";
        ControllerRef cRef = null;
        boolean found = false;
        Collection bundles = this.getBundles(this.scope);
        Iterator iter = bundles.iterator();
        while (iter.hasNext()) {
            ObjectBundle bundle = (ObjectBundle)iter.next();
            String arrayWWN = Convert.bytesToString(bundle.getSa().getSaData().getSaId().getWorldWideName());
            Controller[] ozControllers = bundle.getController();
            int count = ozControllers == null ? 0 : ozControllers.length;
            block1: for (int i = 0; i < count && !found; ++i) {
                Controller ozController = ozControllers[i];
                IOInterfaceTypeData[] hostInterfaces = ozController.getHostInterfaces();
                for (int j = 0; j < hostInterfaces.length; ++j) {
                    FibreInterface ozFcPort;
                    if (2 != hostInterfaces[j].getInterfaceType().getValue() || !fcPortKey.equals(Convert.bytesToString((ozFcPort = hostInterfaces[j].getFibre()).getPortName()))) continue;
                    cRef = ozController.getControllerRef();
                    found = true;
                    continue block1;
                }
            }
        }
        return cRef;
    }

    private FCPort getFCPortByName(String portName) throws ConfigMgmtException {
        FCPort port = null;
        List ports = this.getItemList();
        if (portName != null) {
            Iterator i = ports.iterator();
            while (i.hasNext()) {
                FCPort currPort = (FCPort)i.next();
                Map map = currPort.getKey();
                String currRef = (String)map.get("portName");
                if (!portName.equals(currRef)) continue;
                port = currPort;
                break;
            }
        }
        if (port == null) {
            throw new ConfigMgmtException("fcport.lookup.error", "Unable to lookup fc port with reference = " + portName);
        }
        return port;
    }

    public static interface FibreChannelPortIdValues {
        public static final int MIN_VALUE = 0;
        public static final int MAX_VALUE = 127;
    }

    public static interface ModifyProperties {
        public static final String PREFERRED_LOOPID = "PREFERRED_LOOPID";
    }

    public static interface KeyMap
    extends ManagerInterface.ArrayScope {
        public static final String CONTROLLER_REF = "controllerRef";
        public static final String FCPORT_NAME = "portName";
    }
}

