/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz;

import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.ErrorCode;
import com.sun.netstorage.array.mgmt.cfg.core.ManagerInterface;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.SEItemNotFoundException;
import com.sun.netstorage.array.mgmt.cfg.core.impl.ObjectBundleManager;
import com.sun.netstorage.array.mgmt.cfg.core.impl.oz.CommandProcessor;
import com.sun.netstorage.array.mgmt.cfg.core.impl.oz.OZErrorCode;
import com.sun.netstorage.array.mgmt.cfg.core.ini.Repository;
import com.sun.netstorage.array.mgmt.cfg.core.logic.Scope;
import com.sun.netstorage.array.mgmt.cfg.core.logic.SearchFilter;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.InstanceWrapper;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageDisksInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.Disk;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ManageVolumes;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.PoolData;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.PoolDataManager;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.Profile;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.ProfileDataManager;
import com.sun.netstorage.array.mgmt.cfg.util.Convert;
import devmgr.versioned.jrpc.RPCError;
import devmgr.versioned.jrpc.XDRType;
import devmgr.versioned.symbol.CandidateSelectionType;
import devmgr.versioned.symbol.CandidateSelectionTypeData;
import devmgr.versioned.symbol.Drive;
import devmgr.versioned.symbol.DriveRef;
import devmgr.versioned.symbol.DriveRefList;
import devmgr.versioned.symbol.DriveStatus;
import devmgr.versioned.symbol.ObjectBundle;
import devmgr.versioned.symbol.ReturnCode;
import devmgr.versioned.symbol.Tray;
import devmgr.versioned.symbol.UnicodeTranslator;
import devmgr.versioned.symbol.VolumeCandidate;
import devmgr.versioned.symbol.VolumeGroup;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class ManageDisks
implements ManageDisksInterface {
    private static final String DISK_DEFAULT_MAX_SPEED = "DISK_DEFAULT_MAX_SPEED";
    private static final String DISK_DEFAULT_CURRENT_SPEED = "DISK_DEFAULT_CURRENT_SPEED";
    public static final int ROLE_SPARE = 0;
    public static final int ROLE_DATA = 1;
    public static final String NULL_SYMBOL_REF_STRING = "00:00:00:00:00:00:00:00:00:00:00:00:00:00:00:00:00:00:00:00";
    private Collection scopeKey;
    private SearchFilter sf;
    ConfigContext cfgctx;
    Scope scope;

    public void init(ConfigContext context, SearchFilter filter) throws ConfigMgmtException {
        this.sf = filter;
    }

    public void init(ConfigContext context, Scope s, SearchFilter f) throws ConfigMgmtException {
        this.cfgctx = context;
        this.scope = s;
        this.sf = f;
    }

    public List getItemList() throws ConfigMgmtException {
        Trace.methodBegin(this, "getItemList");
        ArrayList diskList = new ArrayList();
        String ref = null;
        String arrayWWN = null;
        String trayRef = null;
        if (this.scope != null) {
            arrayWWN = Convert.scopeToArrayKey(this.scope);
            if (arrayWWN == null) {
                throw new ConfigMgmtException("unsupported.scope.exception", "Scope is not set correctly, no array scope");
            }
            String trayKey = (String)this.scope.getAttribute("tray");
            if (trayKey != null) {
                trayRef = (String)Convert.keyAsStringToMap(trayKey).get("trayRef");
            }
        }
        ObjectBundleManager man = ObjectBundleManager.getInstance();
        if (arrayWWN != null) {
            try {
                this.createDiskObjects(diskList, trayRef, man.getObjectBundle(arrayWWN));
            }
            catch (SEItemNotFoundException e) {
                Trace.error((Object)this, (ConfigMgmtException)e);
            }
        } else {
            Collection bundles = ObjectBundleManager.getInstance().getObjectBundles();
            Iterator iter = bundles.iterator();
            while (iter.hasNext()) {
                ObjectBundle bundle = (ObjectBundle)iter.next();
                this.createDiskObjects(diskList, ref, bundle);
            }
        }
        return diskList;
    }

    private HashMap hashVDisks(VolumeGroup[] ozVolGroups) {
        HashMap<String, VolumeGroup> map = new HashMap<String, VolumeGroup>();
        if (ozVolGroups != null && ozVolGroups.length != 0) {
            for (int i = 0; i < ozVolGroups.length; ++i) {
                map.put(Convert.bytesToString(ozVolGroups[i].getVolumeGroupRef().getRefToken()), ozVolGroups[i]);
            }
        }
        return map;
    }

    private void createDiskObjects(ArrayList diskList, String ref, ObjectBundle bundle) {
        String methodName = "createDiskObjects";
        String arrayName = UnicodeTranslator.getString((byte[])bundle.getSa().getSaData().getStorageArrayLabel().getValue());
        String arrayWWN = Convert.bytesToString(bundle.getSa().getSaData().getSaId().getWorldWideName());
        Drive[] ozDrives = bundle.getDrive();
        Tray[] ozTrays = bundle.getTray();
        HashMap trayMap = this.hashTrays(ozTrays);
        HashMap vdiskMap = this.hashVDisks(bundle.getVolumeGroup());
        if (this.sf != null && this.sf.getSearchField() != null && this.sf.getSearchField().equals("keyAsString")) {
            Map searchKey = Convert.keyAsStringToMap(this.sf.getSearchString());
            this.sf.setSearchFilter("diskRef", (String)searchKey.get("diskRef"));
        }
        int count = ozDrives == null ? 0 : ozDrives.length;
        for (int i = 0; i < count; ++i) {
            VolumeGroup vg;
            int maxSpeed;
            Drive ozDrive = ozDrives[i];
            int intStatus = ozDrive.getStatus().getValue();
            if (ozDrive.getPfa()) {
                intStatus = 25;
            }
            if (Trace.isTraceEnabled(this)) {
                Trace.verbose((Object)this, "createDiskObjects", "Disk[" + i + "] status:" + intStatus);
            }
            String role = "dataDisk";
            if (ozDrive.getHotSpare()) {
                role = "globalStandbyDisk";
            } else if (NULL_SYMBOL_REF_STRING.equals(Convert.bytesToString(ozDrive.getCurrentVolumeGroupRef().getRefToken()))) {
                role = "unassigned";
            }
            String state = "enabled";
            if (ozDrive.getOffline()) {
                state = "disabled";
            }
            if (this.sf != null && !this.sf.passesFilter("diskState", state)) {
                Trace.verbose((Object)this, "createDiskObjects", "Disk does not pass state filter");
                continue;
            }
            if (this.sf != null && !this.sf.passesFilter("diskStatus", Integer.toString(intStatus))) {
                Trace.verbose((Object)this, "createDiskObjects", "Disk does not pass status filter");
                continue;
            }
            if (this.sf != null && !this.sf.passesFilter("role", role)) {
                Trace.verbose((Object)this, "createDiskObjects", "Disk does not pass role filter");
                continue;
            }
            BigInteger bigintCapacity = new BigInteger("" + ozDrive.getRawCapacity());
            if (this.sf != null) {
                BigInteger bi;
                if (!this.sf.passesFilter("diskSizeExact", bigintCapacity.toString())) {
                    Trace.verbose((Object)this, "createDiskObjects", "Disk does not pass exact capacity filter");
                    continue;
                }
                String biggerThanOrEqualSize = this.sf.getFilterValue("diskSize");
                if (biggerThanOrEqualSize != null && bigintCapacity.compareTo(bi = new BigInteger(biggerThanOrEqualSize)) < 0) {
                    Trace.verbose((Object)this, "createDiskObjects", "Capacity filter not passed");
                    continue;
                }
            }
            int intSlot = ozDrive.getPhysicalLocation().getSlot();
            Tray t = (Tray)trayMap.get(new String(ozDrive.getPhysicalLocation().getTrayRef().getRefToken()));
            int intTrayId = t == null ? -1 : t.getTrayId();
            String sslot = "" + intSlot;
            if (intSlot < 10) {
                sslot = "0" + sslot;
            }
            String name = "t" + intTrayId + "d" + sslot;
            if (this.sf != null && !this.sf.passesFilter("name", name)) {
                Trace.verbose((Object)this, "createDiskObjects", "Disk does not pass name filter");
                continue;
            }
            int type = ozDrive.getPhyDriveType().getValue();
            if (this.sf != null && !this.sf.passesFilter("diskType", "" + type)) {
                Trace.verbose((Object)this, "createDiskObjects", "Filter disk type not passed");
                continue;
            }
            int currentSpeed = ozDrive.getSpindleSpeed();
            if (currentSpeed <= 0 && Repository.getRepository().getProperty(DISK_DEFAULT_CURRENT_SPEED) != null) {
                Trace.verbose((Object)this, "createDiskObjects", "Setting default speed - firmware returned current speed value:" + currentSpeed + " for disk:" + name);
                currentSpeed = Integer.parseInt((String)Repository.getRepository().getProperty(DISK_DEFAULT_CURRENT_SPEED));
            }
            if ((maxSpeed = ozDrive.getMaxSpeed().getValue()) <= 0 && Repository.getRepository().getProperty(DISK_DEFAULT_MAX_SPEED) != null) {
                Trace.verbose((Object)this, "createDiskObjects", "Setting default speed - Firmware returned max speed value:" + maxSpeed + " for disk:" + name);
                maxSpeed = Integer.parseInt((String)Repository.getRepository().getProperty(DISK_DEFAULT_MAX_SPEED));
            }
            String vDiskName = "-";
            if (ozDrive.getCurrentVolumeGroupRef() != null && (vg = (VolumeGroup)vdiskMap.get(Convert.bytesToString(ozDrive.getCurrentVolumeGroupRef().getRefToken()))) != null) {
                vDiskName = "" + vg.getSequenceNum();
            }
            Trace.verbose((Object)this, "createDiskObjects", "For disk:" + name + " VDISK name is:" + vDiskName);
            Disk disk = new Disk(name, intStatus, role, state, bigintCapacity, intSlot, intTrayId, arrayName, vDiskName, null, type, currentSpeed, maxSpeed);
            disk.setObjectItemType("disk");
            disk.setSoftwareVersion(ozDrive.getSoftwareVersion());
            disk.setSerialNumber(ozDrive.getSerialNumber());
            disk.setWwn(Convert.bytesToString(ozDrive.getWorldWideName()));
            String tRef = new String(ozDrive.getPhysicalLocation().getTrayRef().getRefToken());
            DriveStatus st = ozDrive.getStatus();
            HashMap<String, String> refKey = new HashMap<String, String>(3);
            refKey.put("array", arrayWWN);
            refKey.put("diskRef", Convert.bytesToStringRaw(ozDrive.getDriveRef().getRefToken()));
            refKey.put("volGroupRef", Convert.bytesToStringRaw(ozDrive.getCurrentVolumeGroupRef().getRefToken()));
            disk.setKey(refKey);
            if (this.sf != null && !this.sf.passesFilter("diskRef", (String)refKey.get("diskRef"))) {
                Trace.verbose((Object)this, "createDiskObjects", "Search filter by disk reference not passed for ref:" + refKey.get("diskRef"));
                continue;
            }
            if (this.sf != null && this.sf.getSearchField() != null && this.sf.getSearchField().equals("diskRef") && this.sf.passesFilter("diskRef", (String)refKey.get("diskRef"))) {
                Trace.verbose((Object)this, "createDiskObjects", "Search by reference - found return the list for ref:" + refKey.get("diskRef"));
                diskList.add(disk);
                break;
            }
            if (this.sf != null && !this.sf.passesFilter("volGroupRef", (String)refKey.get("volGroupRef"))) {
                Trace.verbose((Object)this, "createDiskObjects", "volume group reference not passed");
                continue;
            }
            if (ref != null && !ref.equals(Convert.bytesToStringRaw(ozDrive.getPhysicalLocation().getTrayRef().getRefToken())) || ozDrive.getStatus().getValue() == 6) continue;
            diskList.add(disk);
        }
    }

    private HashMap hashTrays(Tray[] ozTrays) {
        int count = ozTrays == null ? 0 : ozTrays.length;
        HashMap<String, Tray> map = new HashMap<String, Tray>(count);
        for (int i = 0; i < count; ++i) {
            Tray t = ozTrays[i];
            map.put(new String(t.getTrayRef().getRefToken()), t);
        }
        return map;
    }

    public void setScope(InstanceWrapper scope) {
    }

    public int getItemCount() throws ConfigMgmtException {
        return this.getItemList() != null ? this.getItemList().size() : 0;
    }

    private int getNumOfDisksInRole(String role, Drive[] ozDrives) {
        int itemCount = 0;
        for (int i = 0; i < ozDrives.length; ++i) {
            if (ozDrives[i].getHotSpare() && role == "spare") {
                ++itemCount;
                continue;
            }
            if (role != "data") continue;
            ++itemCount;
        }
        return itemCount;
    }

    public boolean findDisk(Object key) {
        try {
            List diskList = this.getItemList();
            for (int i = 0; i < diskList.size(); ++i) {
                Disk d = (Disk)diskList.get(i);
                if (!((Object)d.getKey()).equals(key)) continue;
                return true;
            }
        }
        catch (ConfigMgmtException ex) {
            return false;
        }
        return false;
    }

    public void modify(Object objKey, Properties props) throws ConfigMgmtException {
        String METHOD_NAME = "modify";
        Map key = null;
        key = objKey instanceof Map ? (Map)objKey : Convert.keyAsStringToMap((String)objKey);
        String dRef = (String)key.get("diskRef");
        Disk d = this.getDiskByReference(dRef);
        try {
            String arrayWWN = (String)key.get("array");
            CommandProcessor command = new CommandProcessor(arrayWWN);
            Enumeration<?> enumeration = props.propertyNames();
            while (enumeration.hasMoreElements()) {
                String currElement = (String)enumeration.nextElement();
                Trace.verbose((Object)this, "modify", "Modify - Element: " + currElement);
                if ("role".equals(currElement)) {
                    int requestedRole = Integer.valueOf((String)props.get(currElement));
                    if (requestedRole == 0 && d.getRole().equals("globalStandbyDisk") || requestedRole == 1 && !d.getRole().equals("globalStandbyDisk")) continue;
                    this.setRole(command, key, requestedRole);
                    continue;
                }
                if ("fail".equals(currElement)) {
                    this.failDrive(command, key, d);
                    continue;
                }
                if ("revive".equals(currElement)) {
                    this.reviveDrive(command, key, d);
                    continue;
                }
                if ("init".equals(currElement)) {
                    this.initDrive(command, key, d);
                    continue;
                }
                if ("reconstruct".equals(currElement)) {
                    this.reconstructDrive(command, key, arrayWWN, d);
                    continue;
                }
                String msg = new String("Unsupported modify element: " + currElement);
                Trace.error((Object)this, "modify", msg);
                throw new ConfigMgmtException("error.systemError", msg);
            }
            ObjectBundleManager.getInstance().forceBundleReload(arrayWWN);
        }
        catch (RPCError e) {
            Trace.error((Object)this, (Throwable)e);
            throw new ConfigMgmtException(ErrorCode.ERROR_RPC.getKey(), e.getMessage());
        }
        catch (IOException e) {
            Trace.error((Object)this, (Throwable)e);
            throw new ConfigMgmtException(ErrorCode.ERROR_COMMUNICATING_WITH_ARRAY.getKey(), e.getMessage());
        }
        catch (ConfigMgmtException cme) {
            throw cme;
        }
    }

    private void reconstructDrive(CommandProcessor command, Object key, String arrayWwn, Disk d) throws ConfigMgmtException {
        String methodName = "reconstructDrive";
        Drive ozDrive = this.findOZDrive(key);
        if (NULL_SYMBOL_REF_STRING.equals(Convert.bytesToString(ozDrive.getCurrentVolumeGroupRef().getRefToken()))) {
            Trace.error((Object)this, "reconstructDrive", "Error: cannot reconstruct unassigned drive");
            throw new ConfigMgmtException("error.reconstruct.unassigned", new String[]{d.getName()}, "Error: cannot reconstruct unassigned drive", null);
        }
        if (ozDrive.getStatus().getValue() != 2 && ozDrive.getStatus().getValue() != 3) {
            Trace.error((Object)this, "reconstructDrive", "Drive status must be failed or replaced to start reconstruction");
            throw new ConfigMgmtException("error.invalid.reconstruction.failed.replaced", new String[]{d.getName()}, "Drive status must be failed or replaced to reconstruct it", null);
        }
        ObjectBundle bundle = ObjectBundleManager.getInstance().getObjectBundle(arrayWwn);
        HashMap vdiskMap = this.hashVDisks(bundle.getVolumeGroup());
        VolumeGroup vg = (VolumeGroup)vdiskMap.get(Convert.bytesToString(ozDrive.getCurrentVolumeGroupRef().getRefToken()));
        if (vg.getRaidLevel().getValue() == 0) {
            Trace.error((Object)this, "reconstructDrive", "Raid level of associated Virtual Disk cannot be 0 to reconstruct the disk");
            throw new ConfigMgmtException("error.invalid.reconstruction.raid0", new String[]{d.getName()}, "Raid level of associated Virtual Disk cannot be 0 to reconstruct the disk", null);
        }
        this.execRecoveryOperation(command, ozDrive.getDriveRef(), 19);
    }

    private void initDrive(CommandProcessor command, Object key, Disk d) throws ConfigMgmtException {
        String methodName = "initDrive";
        Drive ozDrive = this.findOZDrive(key);
        if (!ozDrive.getOffline()) {
            Trace.error((Object)this, "initDrive", "Drive must be offline to initialize it");
            throw new ConfigMgmtException("error.cannot.init.online.disk", new String[]{d.getName()}, "Drive status must be offline to initialize it", null);
        }
        this.execRecoveryOperation(command, ozDrive.getDriveRef(), 13);
    }

    private void reviveDrive(CommandProcessor command, Object key, Disk d) throws ConfigMgmtException {
        String methodName = "reviveDrive";
        Drive ozDrive = this.findOZDrive(key);
        if (ozDrive.getStatus().getValue() != 2 && ozDrive.getStatus().getValue() != 3) {
            Trace.error((Object)this, "reviveDrive", "Drive status must be failed or replaced to revive it");
            throw new ConfigMgmtException("error.invalid.drive.status.not.failed", new String[]{d.getName()}, "Drive status must be failed to revive it", null);
        }
        this.execRecoveryOperation(command, ozDrive.getDriveRef(), 37);
    }

    private void failDrive(CommandProcessor command, Object key, Disk d) throws ConfigMgmtException {
        String methodName = "failDrive";
        Drive ozDrive = this.findOZDrive(key);
        if (ozDrive.getStatus().getValue() == 2) {
            Trace.error((Object)this, "failDrive", "Drive status already in failed state");
            throw new ConfigMgmtException("error.invalid.drive.status.already.failed", new String[]{d.getName()}, "Drive status already failed", null);
        }
        this.execRecoveryOperation(command, ozDrive.getDriveRef(), 11);
    }

    private void execRecoveryOperation(CommandProcessor command, DriveRef driveRef, int proc) throws ConfigMgmtException {
        String METHOD_NAME = "execRecoveryOperation";
        if (driveRef == null) {
            throw new ConfigMgmtException("incorrect.method.parameter", "Drive reference is null.");
        }
        ReturnCode retCode = new ReturnCode();
        command.execute(proc, (XDRType)driveRef, (XDRType)retCode, true);
        if (retCode.getValue() != 1 && retCode.getValue() != 14) {
            String msg = "execRecoveryOperation operation failed: " + retCode.getValue();
            Trace.error((Object)this, "execRecoveryOperation", msg);
            throw new ConfigMgmtException("error.reason." + (OZErrorCode.ERROR_CODE_MIN + retCode.getValue()), msg);
        }
    }

    private Drive findOZDrive(Object key) throws ConfigMgmtException {
        String METHOD_NAME = "findDrive";
        if (key == null) {
            throw new ConfigMgmtException("incorrect.method.parameter", "Object key is null.");
        }
        ObjectBundleManager man = ObjectBundleManager.getInstance();
        String arrayWWN = (String)((Map)key).get("array");
        String diskRef = (String)((Map)key).get("diskRef");
        Drive[] ozDrives = man.getObjectBundle(arrayWWN).getDrive();
        Drive ozDrive = null;
        for (int i = 0; i < ozDrives.length && ozDrive == null; ++i) {
            if (!Convert.bytesToStringRaw(ozDrives[i].getDriveRef().getRefToken()).equals(diskRef)) continue;
            ozDrive = ozDrives[i];
        }
        if (ozDrive == null) {
            Trace.error((Object)this, "findDrive", "Disk not found:" + diskRef);
            throw new ConfigMgmtException(ErrorCode.ITEM_NOT_FOUND.getKey(), diskRef);
        }
        return ozDrive;
    }

    private void setRole(CommandProcessor command, Object key, int role) throws ConfigMgmtException {
        String METHOD_NAME = "setRole";
        if (key == null) {
            throw new ConfigMgmtException("incorrect.method.parameter", "Object key is null.");
        }
        if (1 != role && 0 != role) {
            throw new ConfigMgmtException("incorrect.method.parameter", "Invalid role: " + role);
        }
        ObjectBundleManager man = ObjectBundleManager.getInstance();
        String arrayWWN = (String)((Map)key).get("array");
        String diskRef = (String)((Map)key).get("diskRef");
        man.getObjectBundle(arrayWWN);
        Drive[] ozDrives = man.getObjectBundle(arrayWWN).getDrive();
        for (int i = 0; i < ozDrives.length; ++i) {
            if (!Convert.bytesToStringRaw(ozDrives[i].getDriveRef().getRefToken()).equals(diskRef)) continue;
            DriveRefList refList = new DriveRefList();
            DriveRef[] refArray = new DriveRef[]{ozDrives[i].getDriveRef()};
            refList.setDriveRef(refArray);
            ReturnCode retCode = new ReturnCode();
            if (0 == role) {
                command.execute(5, (XDRType)refList, (XDRType)retCode, true);
            } else if (1 == role) {
                command.execute(8, (XDRType)refList, (XDRType)retCode, true);
            }
            if (retCode.getValue() == 1) continue;
            String msg = "setRole operation failed: " + retCode.getValue();
            Trace.error((Object)this, "setRole", msg);
            throw new ConfigMgmtException("error.reason." + (OZErrorCode.ERROR_CODE_MIN + retCode.getValue()), msg);
        }
    }

    public List getDisksForVolumeCreation(Object poolKey, BigInteger requestedSize) throws ConfigMgmtException {
        String METHOD_NAME = "getDisksForVolumeCreation";
        Trace.methodBegin(this, "getDisksForVolumeCreation");
        String arrayWwn = this.getArrayWwnFromScope();
        if (requestedSize == null) {
            throw new ConfigMgmtException("incorrect.method.parameter", "Must supply a size for: getDisksForVolumeCreation");
        }
        int profileRaidLevel = -1;
        int profileDiskType = 0;
        int profileNumberOfDisks = -1;
        if (poolKey != null) {
            Trace.verbose((Object)this, "getDisksForVolumeCreation", "Filtering by pool...");
            Map poolKeyMap = null;
            PoolData pool = null;
            if (poolKey instanceof Map) {
                poolKeyMap = (Map)poolKey;
            } else if (poolKey instanceof String) {
                poolKeyMap = Convert.keyAsStringToMap((String)poolKey);
            }
            if (poolKeyMap != null) {
                PoolDataManager pooldm = new PoolDataManager(arrayWwn);
                String poolId = (String)poolKeyMap.get("id");
                pool = pooldm.getPoolData(poolId);
                if (pool == null) {
                    throw new ConfigMgmtException("incorrect.method.parameter", "Could not look up the pool with the key passed.");
                }
            } else {
                throw new ConfigMgmtException("incorrect.method.parameter", "Must supply pool key for: getDisksForVolumeCreation");
            }
            ProfileDataManager profdm = new ProfileDataManager(arrayWwn);
            Profile profile = profdm.getProfile(pool.profileId);
            profileDiskType = ProfileDataManager.convertProfileDriveTypeTo6130DriveType(profile.getDriveType());
            profileRaidLevel = profile.getRaidLevel();
            profileNumberOfDisks = profile.getNumberOfDisks();
        }
        if (!this.hasEnoughSpace(profileRaidLevel, profileDiskType, requestedSize, arrayWwn)) {
            return new ArrayList();
        }
        List allDisks = this.getItemList();
        ArrayList<Disk> disksForVolumeCreation = new ArrayList<Disk>();
        Iterator iter = allDisks.iterator();
        while (iter.hasNext()) {
            Disk disk = (Disk)iter.next();
            try {
                if (poolKey != null) {
                    ManageVolumes.validateDiskType(profileDiskType, disk.getType());
                }
                if (!"unassigned".equals(disk.getRole()) || !"enabled".equals(disk.getState()) || 1 != disk.getStatus()) continue;
                disksForVolumeCreation.add(disk);
            }
            catch (ConfigMgmtException cme) {}
        }
        if (poolKey != null && disksForVolumeCreation.size() > 0 && !ManageDisks.areDisksEligible(profileNumberOfDisks, profileRaidLevel, disksForVolumeCreation.size())) {
            return new ArrayList();
        }
        Trace.verbose((Object)this, "getDisksForVolumeCreation", "Number of items in the list = " + disksForVolumeCreation.size());
        return disksForVolumeCreation;
    }

    public static boolean areDisksEligible(int profileNumberOfDisks, int profileRaidLevel, int numberOfDisks) {
        boolean areDisksEligible = false;
        if (profileNumberOfDisks == 0 || profileNumberOfDisks <= numberOfDisks) {
            switch (profileRaidLevel) {
                case 0: {
                    if (numberOfDisks < 1) break;
                    areDisksEligible = true;
                    break;
                }
                case 1: {
                    if (numberOfDisks < 2) break;
                    areDisksEligible = true;
                    break;
                }
                case 3: 
                case 5: {
                    if (numberOfDisks < 3) break;
                    areDisksEligible = true;
                }
            }
        }
        return areDisksEligible;
    }

    private boolean hasEnoughSpace(int requestedRaidLevel, int requestedDriveType, BigInteger requestedSize, String arrayWwn) {
        String METHOD_NAME = "hasEnoughSpace";
        Trace.methodBegin(this, "hasEnoughSpace");
        ManageVolumes mVol = new ManageVolumes();
        CandidateSelectionTypeData selection = new CandidateSelectionTypeData();
        CandidateSelectionType type = new CandidateSelectionType();
        type.setValue(3);
        selection.setCandidateSelectionType(type);
        VolumeCandidate[] vCand = null;
        try {
            vCand = mVol.getVolumeCandidates(selection, requestedRaidLevel, arrayWwn, requestedDriveType, ManageVolumes.getCommandProcessor(arrayWwn));
        }
        catch (ConfigMgmtException cme) {
            Trace.verbose((Object)this, "hasEnoughSpace", "There are no volume candidates for RAID level = " + requestedRaidLevel + " and drive type = " + requestedDriveType + " on array = " + arrayWwn);
            return false;
        }
        long requestedSizeLong = requestedSize.longValue();
        int length = vCand != null ? vCand.length : 0;
        for (int i = 0; i < length; ++i) {
            if (requestedSizeLong > vCand[i].getUsableSize()) continue;
            return true;
        }
        return false;
    }

    private String getArrayWwnFromScope() throws ConfigMgmtException {
        if (this.scope != null) {
            return Convert.scopeToArrayKey(this.scope);
        }
        throw new ConfigMgmtException("error.scope.required", "Array scope not set before using of the disk manager.");
    }

    private Disk getDiskByReference(String diskRefString) throws ConfigMgmtException {
        Disk disk = null;
        List disks = this.getItemList();
        if (diskRefString != null) {
            Iterator i = disks.iterator();
            while (i.hasNext()) {
                Disk currDisk = (Disk)i.next();
                Map map = currDisk.getKey();
                String currRef = (String)map.get("diskRef");
                if (!diskRefString.equals(currRef)) continue;
                disk = currDisk;
                break;
            }
        }
        if (disk == null) {
            throw new ConfigMgmtException("disk.lookup.error", "Unable to lookup disk with reference = " + diskRefString);
        }
        return disk;
    }

    public static interface SearchType
    extends ManagerInterface.CommonSearchTypes {
        public static final String DISK_REF = "diskRef";
        public static final String VOLGROUP_REF = "volGroupRef";
        public static final String ROLE = "role";
        public static final String DISK_TYPE = "diskType";
        public static final String DISK_STATE = "diskState";
        public static final String DISK_STATUS = "diskStatus";
        public static final String DISK_SIZE_EXACT = "diskSizeExact";
        public static final String DISK_SIZE = "diskSize";
    }

    public static interface DiskStatus {
        public static final int STATUS_OPTIMAL = 1;
        public static final int STATUS_FAILED = 2;
        public static final int STATUS_REPLACED = 3;
        public static final int STATUS_BYPASSED = 4;
        public static final int STATUS_UNRESPONSIVE = 5;
        public static final int STATUS_REMOVED = 6;
    }

    public static interface RoleProps {
        public static final int ROLE_SPARE = 0;
        public static final int ROLE_DATA = 1;
    }

    public static interface ModifyProperties {
        public static final String ROLE = "role";
        public static final String REVIVE = "revive";
        public static final String FAIL = "fail";
        public static final String INITIALIZE = "init";
        public static final String RECONSTRUCT = "reconstruct";
    }

    public static interface KeyMap
    extends ManagerInterface.ArrayScope {
        public static final String DISK_REF = "diskRef";
        public static final String VOLGROUP_REF = "volGroupRef";
    }
}

