/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz;

import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.PerfCounterData;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.oz.PerfErrorCode;

public class ControllerPerfCounterData
extends PerfCounterData {
    long time = 0L;
    double totalIOs = 0.0;
    double totalIOPs = 0.0;
    double totalReadRequests = 0.0;
    double totalWriteRequests = 0.0;
    long totalCacheReadCheckHits = 0L;
    long totalCacheReadChecks = 0L;
    double totalBytesReadPerSec = 0.0;
    double totalBytesWrittenPerSec = 0.0;
    double totalAverageReadSize = 0.0;
    double totalAverageWriteSize = 0.0;
    boolean dataValidity = true;
    boolean blockSizeValidity = true;

    public boolean isDataValid() {
        return this.dataValidity;
    }

    public void setDataValid(boolean dataValidity) {
        this.dataValidity = dataValidity;
    }

    public boolean isBlockSizeValid() {
        return this.blockSizeValidity;
    }

    public void setBlockSizeValid(boolean validity) {
        this.blockSizeValidity = validity;
    }

    public void add(ControllerPerfCounterData data) {
        if (data == null) {
            this.setDataValid(false);
            this.addErrorCode(PerfErrorCode.NO_PATH_TO_CONTROLLER);
            return;
        }
        if (!this.isDataValid()) {
            return;
        }
        this.totalIOs += data.totalIOs;
        this.totalIOPs += data.totalIOPs;
        this.totalReadRequests += data.totalReadRequests;
        this.totalWriteRequests += data.totalWriteRequests;
        this.totalCacheReadCheckHits += data.totalCacheReadCheckHits;
        this.totalCacheReadChecks += data.totalCacheReadChecks;
        if (this.isBlockSizeValid() && data.isBlockSizeValid()) {
            this.totalBytesReadPerSec += data.totalBytesReadPerSec;
            this.totalBytesWrittenPerSec += data.totalBytesWrittenPerSec;
            this.totalAverageReadSize += data.totalAverageReadSize;
            this.totalAverageWriteSize += data.totalAverageWriteSize;
        } else if (!this.isBlockSizeValid()) {
            this.setBlockSizeValid(false);
            this.addErrorCode(PerfErrorCode.VOL_BLOCKSIZE_CHANGED);
        }
    }
}

