/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.mr3;

import com.sun.netstorage.array.mgmt.cfg.core.CIMOMHandleWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Constants;
import com.sun.netstorage.array.mgmt.cfg.core.MethodCallStatus;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.TooManyCIMInstanceException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ZeroCIMInstanceReturnedException;
import com.sun.netstorage.array.mgmt.cfg.core.impl.CIMObjectWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.impl.MapElement;
import com.sun.netstorage.array.mgmt.cfg.core.impl.MapStringArrayToString;
import com.sun.netstorage.array.mgmt.cfg.core.impl.mr3.InvocationHelper;
import com.sun.netstorage.array.mgmt.cfg.core.logic.SearchFilter;
import com.sun.netstorage.array.mgmt.cfg.jobs.business.JobInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.DiskInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageRaidGroupsFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageRaidGroupsInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageT4sFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageT4sInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.RaidGroupInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageProfile;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.T4Interface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.TrayInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.PoolBreakdownForTray;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.QueuedPoolData;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.mr3.CloneTrayJobCompletion;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.mr3.Disk;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.mr3.ManageArraySpares;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.mr3.ManageDisks;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.mr3.RaidGroup;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.mr3.StorageConfigurationServiceBuilder;
import com.sun.netstorage.array.mgmt.cfg.util.IPUtil;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.wbem.cim.CIMArgument;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt16;

public class Tray
implements TrayInterface,
Comparable,
Constants.SupportedFeature {
    private static final String[] SLOT_PROP_LIST = new String[]{"Number", "Tag", "CreationClassName"};
    private static final String[] STORAGE_EXT_PROP_LIST = new String[]{"NumberOfBlocks", "BlockSize", "CreationClassName", "SystemCreationClassName", "SystemName", "DeviceID"};
    private static final String TRAY_DELIM = "u";
    private static final String DISK_DELIM = "d";
    private ConfigContext context;
    private CIMOMHandleWrapper cimClient;
    private ArrayList raidGroups;
    private String id;
    private String idOneBased;
    private String chassisTag;
    private String tee4Name;
    private String tee4NameAsIP;
    private BigInteger driveCapacity = null;
    private int numberOfDrives = -1;
    private Boolean allDrivesHealthy = null;
    private int numberOfHotSpare = -1;
    private CIMInstance trayCimInstance;
    private CIMObjectPath trayCimObjPath;
    private Collection mapElementList;
    private int trayType;
    private ManageDisks diskManager;
    private CIMObjectPath t4CimObjectPath;
    private CIMObjectPath storageConfigServiceObjPath = null;
    private int maxNumOfContigDrive = -1;
    private List contigDiskSequence;
    private String status;
    private int operationalStatus = -1;
    private int state = -1;
    private String role;
    private String unitId;
    private ArrayList fieldMap;
    private boolean cspPopulated;
    private CIMInstance csInstance;
    private T4Interface t4Interface;
    private int numRequestedAndExistingRaidGroups = -1;
    static /* synthetic */ Class class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$mr3$Tray;

    public Tray() {
        Trace.constructor(this);
    }

    public void init(ConfigContext context) throws ConfigMgmtException {
        Trace.methodBegin(this, "init");
        this.context = context;
        this.cimClient = context.getClient();
        if (this.cimClient == null) {
            Trace.verbose((Object)this, "init", "Config context returned a NULL CIMOMHandleWrapper handle in Tray object!!!");
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "Null CIMOMHandleWrapper error.");
        }
    }

    public ConfigContext getConfigContext() {
        return this.context;
    }

    public void setConfigContext(ConfigContext ctx) throws ConfigMgmtException {
        Trace.methodBegin(this, "setConfigContext");
        this.init(ctx);
    }

    public synchronized void reload() throws ConfigMgmtException {
        Trace.methodBegin(this, "reload");
        Trace.verbose((Object)this, "reload", "Resetting instance variables to initial state!!");
        this.raidGroups = null;
        this.id = null;
        this.chassisTag = null;
        this.tee4Name = null;
        this.tee4NameAsIP = null;
        this.driveCapacity = null;
        this.numberOfDrives = -1;
        this.numberOfHotSpare = -1;
        this.trayType = 0;
        this.diskManager = null;
        this.storageConfigServiceObjPath = null;
        this.maxNumOfContigDrive = -1;
        this.contigDiskSequence = null;
        this.status = null;
        this.state = -1;
        this.operationalStatus = -1;
        this.role = null;
        this.cspPopulated = false;
        this.csInstance = null;
        this.unitId = null;
        this.numRequestedAndExistingRaidGroups = -1;
        if (this.t4Interface != null) {
            this.t4Interface.reload();
        }
        this.reloadChassis();
    }

    public MethodCallStatus cloneFrom(TrayInterface sourceTray) throws ConfigMgmtException {
        Trace.methodBegin(this, "cloneFrom");
        try {
            ArrayList jobLinks = new ArrayList();
            Trace.verbose((Object)this, "cloneFrom", "==========================");
            MethodCallStatus status = this.cloneFrom(sourceTray, jobLinks, this.getT4Name());
            return status;
        }
        catch (ConfigMgmtException ce) {
            throw new ConfigMgmtException("ARRAY_DUPLICATE_TRAY_FROM_SOURCE_ERROR", "An error occurred while cloning Tray.");
        }
    }

    public MethodCallStatus cloneFrom(TrayInterface sourceTray, ArrayList jobLinks, String sourceT4Name) throws ConfigMgmtException {
        Trace.methodBegin(this, "cloneFrom");
        if (sourceTray == null) {
            Trace.verbose((Object)this, "cloneFrom", "Source tray is null!!!");
            throw new ConfigMgmtException("ARRAY_DUPLICATE_TRAY_FROM_SOURCE_ERROR", "NULL PARAMETER.");
        }
        Tray srcTray = (Tray)sourceTray;
        Trace.verbose((Object)this, "cloneFrom", "Cloning tray: " + srcTray.getId() + " on IP: " + srcTray.getT4IPAddress() + " to tray: " + this.getId() + " on IP: " + this.tee4NameAsIP);
        if (!this.areDisksCompatible(sourceTray)) {
            Trace.verbose((Object)this, "cloneFrom", "Source and Target Trays have incompatible disks!");
            throw new ConfigMgmtException("ARRAY_DUPLICATE_TRAY_FROM_SOURCE_ERROR", "Duplicate tray encountered incompatible disks in trays.");
        }
        if (this.getT4Interface().isFeatureSupported(3)) {
            Trace.verbose((Object)this, "cloneFrom", "Removing tray AHS(s).");
            ManageArraySpares manageArraySpares = new ManageArraySpares();
            manageArraySpares.init(this.context, this.getT4Interface());
            manageArraySpares.removeAllAhsDrivesOnTray(Integer.parseInt(this.getId()));
            manageArraySpares.save();
        }
        MethodCallStatus returnStatus = new MethodCallStatus();
        ArrayList sourceRaidGroups = (ArrayList)sourceTray.getRaidGroups();
        ArrayList completeTasks = new ArrayList();
        for (int i = 0; i < sourceRaidGroups.size(); ++i) {
            if (i > 0) {
                this.reload();
            }
            RaidGroup rg = (RaidGroup)sourceRaidGroups.get(i);
            int raidLevel = rg.getRaidLevel();
            boolean usesHotSpare = rg.getUseHotSpare() == 1;
            int numberOfDrives = rg.getNumberOfDrives();
            String profileName = rg.getProfileName();
            PoolBreakdownForTray pbft = this.getPoolBreakdownForTray(1, numberOfDrives, raidLevel, usesHotSpare);
            if (!pbft.canBeSupported()) {
                String message = "Cloning of the raid group <" + rg.getName() + "> to the tray <" + this.getId() + "> can not be supported.";
                Trace.verbose((Object)this, "cloneFrom", message);
                throw new ConfigMgmtException("ARRAY_DUPLICATE_TRAY_FROM_SOURCE_ERROR", message);
            }
            String raidGroupName = pbft.getSuggestedName(0);
            if (!sourceT4Name.equals(this.getT4Name())) {
                raidGroupName = rg.getName();
            }
            if (Trace.isTraceEnabled(this)) {
                Trace.verbose((Object)this, "cloneFrom", "On IP: " + this.tee4NameAsIP + " about to clone raid group with name = " + raidGroupName + "; " + "raid level = " + raidLevel + "; " + "number of drives = " + numberOfDrives + "; " + "profile name = " + profileName + "; " + "that uses hot spare = " + usesHotSpare);
            }
            try {
                Trace.verbose((Object)this, "cloneFrom", "Calling createRAIDGroupInCIMOM() to create RaidGroup!!");
                MethodCallStatus mcs = this.createRAIDGroupInCIMOM(raidGroupName, pbft.getDisksForPool(0), raidLevel, usesHotSpare, profileName, jobLinks);
                completeTasks.addAll(mcs.getCompletionTasks());
                returnStatus = this.addJobsToReturnStatus(returnStatus, mcs);
                returnStatus.setReturnCode(mcs.getReturnCode());
                continue;
            }
            catch (ConfigMgmtException ce) {
                Trace.verbose((Object)this, "cloneFrom", "Error occurred while creating RaidGroups in Trays on IP: " + this.tee4NameAsIP);
                throw new ConfigMgmtException("ARRAY_DUPLICATE_TRAY_FROM_SOURCE_ERROR", "An error occurred while cloning Tray");
            }
        }
        Trace.verbose((Object)this, "cloneFrom", "Job completion");
        CloneTrayJobCompletion jobCompletionInterface = new CloneTrayJobCompletion(this.getT4Name(), sourceTray.getT4Name(), sourceTray, this);
        jobCompletionInterface.addPrerequisiteTasks(completeTasks);
        returnStatus.addTaskToList(jobCompletionInterface);
        Trace.verbose((Object)this, "cloneFrom", "On IP: " + this.tee4NameAsIP + " jobLinks size before schedule:" + jobLinks.size());
        InvocationHelper.scheduleTasks(this.context, jobLinks, jobCompletionInterface);
        return returnStatus;
    }

    protected MethodCallStatus addJobsToReturnStatus(MethodCallStatus returnStatus, MethodCallStatus mcs) {
        String methodName = "addJobsToReturnStatus";
        Trace.methodBegin(this, methodName);
        if (returnStatus != null) {
            Trace.verbose((Object)this, methodName, "returnStatus is not null");
            ArrayList<JobInterface> jobList = returnStatus.getJobs();
            ArrayList mcsJobList = mcs.getJobs();
            if (jobList == null) {
                Trace.verbose((Object)this, methodName, "Job list from return status is null");
                jobList = new ArrayList<JobInterface>();
            }
            if (mcsJobList != null) {
                Trace.verbose((Object)this, methodName, "MCS is not null");
                Iterator it = mcsJobList.iterator();
                while (it.hasNext()) {
                    JobInterface ji = (JobInterface)it.next();
                    Trace.verbose((Object)this, methodName, "Add job:" + ji.getId());
                    jobList.add(ji);
                }
                returnStatus.setJobs(jobList);
            }
        } else {
            returnStatus = mcs;
        }
        return returnStatus;
    }

    public void save() throws ConfigMgmtException {
        Trace.methodBegin(this, "save");
    }

    public String getId() {
        Trace.methodBegin(this, "getId");
        if (this.id == null) {
            Trace.verbose((Object)this, "getId", "parsing chassis Tag to Tray ID");
            this.idOneBased = this.id = this.chassisTag.substring(this.chassisTag.indexOf(":") + 1);
            try {
                this.idOneBased = Integer.toString(Integer.parseInt(this.id) + 1);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return this.id;
    }

    public String getIdOneBased() {
        if (this.id == null) {
            this.getId();
        }
        return this.idOneBased;
    }

    public int getTrayType() {
        Trace.methodBegin(this, "getTrayType");
        return this.trayType;
    }

    public String getT4Name() {
        Trace.methodBegin(this, "getT4Name");
        if (this.tee4Name == null) {
            this.tee4Name = IPUtil.lookUpHostName(this.tee4NameAsIP);
        }
        return this.tee4Name;
    }

    public String getT4IPAddress() {
        Trace.methodBegin(this, "getT4IPAddress");
        return this.tee4NameAsIP;
    }

    public int getNumberOfDrives() throws ConfigMgmtException, TooManyCIMInstanceException, ZeroCIMInstanceReturnedException {
        Trace.methodBegin(this, "getNumberOfDrives");
        if (this.numberOfDrives == -1) {
            Trace.verbose((Object)this, "getNumberOfDrives", "number of drives is not cached: calling findAllDisksInTrayFromCIMOM() to find all the disk drives!!");
            this.findAllDisksInTrayFromCIMOM();
        }
        return this.numberOfDrives;
    }

    public ArrayList getMaxContigDrive(RaidGroupInterface theRaidGroup) throws ConfigMgmtException {
        Trace.methodBegin(this, "getMaxContigDrive");
        if (this.diskManager == null) {
            Trace.verbose((Object)this, "getMaxContigDrive", "diskManager has not been loaded yet: calling findAllDisksInTrayFromCIMOM() to find all the disks in the Tray!");
            this.findAllDisksInTrayFromCIMOM();
        }
        ArrayList<Integer> maxContigDiskList = new ArrayList<Integer>();
        List disks = this.getDiskList();
        int disksSize = disks.size();
        boolean needMoreDisks = true;
        for (int i = 0; needMoreDisks && i < disksSize; ++i) {
            Disk disk = (Disk)disks.get(i);
            if ("unassigned".equals(disk.getRole())) {
                Trace.verbose((Object)this, "getMaxContigDrive", "Adding spot for slot: " + disk.getSlotNumber());
                maxContigDiskList.add(new Integer(disk.getSlotNumber()));
                continue;
            }
            if (maxContigDiskList.size() <= 0) continue;
            needMoreDisks = false;
            Trace.verbose((Object)this, "getMaxContigDrive", "End of contig drives at slot: " + disk.getSlotNumber());
        }
        Trace.verbose((Object)this, "getMaxContigDrive", "maximum number of contiguous drives: " + maxContigDiskList.size());
        return maxContigDiskList;
    }

    public int getMaxContigDrive() throws ConfigMgmtException {
        Trace.methodBegin(this, "getMaxContigDrive");
        if (this.maxNumOfContigDrive == -1) {
            int numOfContigSequence;
            this.maxNumOfContigDrive = 0;
            Trace.verbose((Object)this, "getMaxContigDrive", "max number of contig drive not found yet...do it now.");
            if (this.contigDiskSequence == null) {
                Trace.verbose((Object)this, "getMaxContigDrive", "Contiguous drive sequence has not been computed yet.....calling getContiguousDriveSequence() now.");
                this.getContiguousDriveSequence();
            }
            if ((numOfContigSequence = this.contigDiskSequence.size()) > 0) {
                int endSlot = ((Disk)this.contigDiskSequence.get(1)).getSlotNumber();
                int beginSlot = ((Disk)this.contigDiskSequence.get(0)).getSlotNumber();
                Trace.verbose((Object)this, "getMaxContigDrive", "begin slot = " + beginSlot + "; end slot = " + endSlot);
                this.maxNumOfContigDrive = endSlot - beginSlot + 1;
            }
        }
        Trace.verbose((Object)this, "getMaxContigDrive", "Max number of contiguous drive = " + this.maxNumOfContigDrive);
        return this.maxNumOfContigDrive;
    }

    public int getNumberOfHotSpare() throws ConfigMgmtException, TooManyCIMInstanceException, ZeroCIMInstanceReturnedException {
        Trace.methodBegin(this, "getNumberOfHotSpare");
        if (this.numberOfHotSpare == -1) {
            Trace.verbose((Object)this, "getNumberOfHotSpare", "number of hot spare has not been determined: checking if diskManager is loaded!!");
            if (this.diskManager == null) {
                Trace.verbose((Object)this, "getNumberOfHotSpare", "diskManager has not been loaded yet: calling findAllDisksInTrayFromCIMOM() to find all the disks in the Tray!");
                this.findAllDisksInTrayFromCIMOM();
            }
        }
        Trace.verbose((Object)this, "getNumberOfHotSpare", "Getting number of hot spare from diskManager!");
        this.numberOfHotSpare = this.diskManager.getNumberOfHotSpare();
        Trace.verbose((Object)this, "getNumberOfHotSpare", "numberOfHotSpare=" + this.numberOfHotSpare);
        return this.numberOfHotSpare;
    }

    public int getHotSpareDriveUsage() throws ConfigMgmtException {
        int numOfHotSpareDrive;
        Trace.methodBegin(this, "getHotSpareDriveUsage");
        int hotSpareDriveUseCode = -1;
        if (this.diskManager == null) {
            Trace.verbose((Object)this, "getHotSpareDriveUsage", "diskManager has not been loaded yet: calling findAllDisksInTrayFromCIMOM() to find all the disks in the Tray!");
            this.findAllDisksInTrayFromCIMOM();
        }
        if ((numOfHotSpareDrive = this.diskManager.getNumberOfHotSpare()) > 0) {
            Trace.verbose((Object)this, "getHotSpareDriveUsage", "Hot Spare drive is installed!!!");
            if (this.raidGroups == null) {
                Trace.verbose((Object)this, "getHotSpareDriveUsage", "RaidGroups are not in cache.....get them now!!");
                this.findRaidGroups();
            }
            for (int j = 0; j < this.raidGroups.size(); ++j) {
                Trace.verbose((Object)this, "getHotSpareDriveUsage", "Checking if RaidGroup number " + (j + 1) + " is using " + "slot 14 as hot spare!");
                if (((RaidGroup)this.raidGroups.get(j)).getUseHotSpare() == 0) {
                    Trace.verbose((Object)this, "getHotSpareDriveUsage", "RaidGroup number " + (j + 1) + " is not using " + "slot 14 as hot spare!");
                    Trace.verbose((Object)this, "getHotSpareDriveUsage", "Checking if RaidGroup number " + (j + 1) + " is using " + "slot 14 as data drive!");
                    if (((RaidGroup)this.raidGroups.get(j)).getBeginDiskNumber() != 14 && ((RaidGroup)this.raidGroups.get(j)).getBeginDiskNumber() != 14) continue;
                    Trace.verbose((Object)this, "getHotSpareDriveUsage", "RaidGroup number " + (j + 1) + " is using " + "slot 14 as data drive!!");
                    hotSpareDriveUseCode = 1;
                    break;
                }
                Trace.verbose((Object)this, "getHotSpareDriveUsage", "RaidGroup number " + (j + 1) + " is using " + "slot 14 as hot spare!!");
                hotSpareDriveUseCode = 0;
                break;
            }
            if (hotSpareDriveUseCode == -1) {
                Trace.verbose((Object)this, "getHotSpareDriveUsage", "Slot 14 is not allocated to any RaidGroup!!");
                hotSpareDriveUseCode = 2;
            }
        }
        Trace.verbose((Object)this, "getHotSpareDriveUsage", "hot spare use code to return: " + hotSpareDriveUseCode);
        return hotSpareDriveUseCode;
    }

    public BigInteger getDriveCapacity() throws ConfigMgmtException, TooManyCIMInstanceException, ZeroCIMInstanceReturnedException {
        Trace.methodBegin(this, "getDriveCapacity");
        if (this.driveCapacity == null) {
            Trace.verbose((Object)this, "getDriveCapacity", "drive capacity is not cached: calling findAllDisksInTrayFromCIMOM() to find all disk drives and compute drive capacity!!");
            this.findAllDisksInTrayFromCIMOM();
        }
        Trace.verbose((Object)this, "getDriveCapacity", "drive capacity =" + this.driveCapacity);
        return this.driveCapacity;
    }

    public synchronized List getRaidGroups() throws ConfigMgmtException {
        Trace.methodBegin(this, "getRaidGroups");
        if (this.raidGroups == null) {
            Trace.verbose((Object)this, "getRaidGroups", "raidGroups list is not cached!  Need to get data from CIMOM!");
            this.findRaidGroups();
        }
        if (Trace.isTraceEnabled(this)) {
            Trace.verbose((Object)this, "getRaidGroups", "Done getting raid groups in Tray: number of raid groups in this Tray: " + this.raidGroups.size());
            for (int i = 0; i < this.raidGroups.size(); ++i) {
                Trace.verbose((Object)this, "getRaidGroups", "raid group " + i + ": name = " + ((RaidGroup)this.raidGroups.get(i)).getName());
                Trace.verbose((Object)this, "getRaidGroups", "tray " + i + ": instance id = " + ((RaidGroup)this.raidGroups.get(i)).getInstanceId());
                Trace.verbose((Object)this, "getRaidGroups", "********************");
            }
        }
        return (List)this.raidGroups.clone();
    }

    public CIMInstance getInstance() {
        Trace.methodBegin(this, "getInstance");
        return this.trayCimInstance;
    }

    public synchronized ManageDisks getDisks() throws ConfigMgmtException, TooManyCIMInstanceException, ZeroCIMInstanceReturnedException {
        Trace.methodBegin(this, "getDisks");
        if (this.diskManager == null) {
            Trace.verbose((Object)this, "getDisks", "disk list is null: calling findAllDisksInTrayFromCIMOM() to get all disks in tray from CIMOM!!");
            this.findAllDisksInTrayFromCIMOM();
        }
        return this.diskManager;
    }

    public String getRole() throws ConfigMgmtException {
        if (!this.cspPopulated) {
            this.controllerSystemPropertiesLookup();
        }
        return this.role;
    }

    public int getState() throws ConfigMgmtException {
        if (!this.cspPopulated) {
            this.controllerSystemPropertiesLookup();
        }
        return this.state;
    }

    public String getStatus() throws ConfigMgmtException {
        if (!this.cspPopulated) {
            this.controllerSystemPropertiesLookup();
        }
        if (this.getOperationalStatus() == 1 || this.getOperationalStatus() == -1) {
            if (this.status == null || "offline".equals(this.status) || "booting".equals(this.status) || "ready".equals(this.status) || "fault".equals(this.status) || "unknown".equals(this.status)) {
                return this.status;
            }
            Trace.verbose((Object)this, "getStatus", "unexpected tray status value [" + this.status + "], set to unknown");
        }
        return "unknown";
    }

    public int getOperationalStatus() throws ConfigMgmtException {
        if (!this.cspPopulated) {
            this.controllerSystemPropertiesLookup();
        }
        return this.operationalStatus;
    }

    public String getUnitId() {
        return this.unitId;
    }

    public CIMObjectPath getT4CimObjectPath() throws ConfigMgmtException {
        Trace.methodBegin(this, "getT4CimObjectPath");
        if (this.t4CimObjectPath == null) {
            this.findT4FromCIMOM();
        }
        return this.t4CimObjectPath;
    }

    public T4Interface getT4Interface() throws ConfigMgmtException {
        Trace.methodBegin(this, "getT4Interface");
        if (this.t4Interface == null) {
            this.findT4FromCIMOM();
        }
        return this.t4Interface;
    }

    public void setChassisTag(String chassisTag) {
        Trace.methodBegin(this, "setChassisTag");
        Trace.verbose((Object)this, "setChassisTag", "chassisTag passed in=" + chassisTag);
        this.chassisTag = chassisTag;
        Trace.verbose((Object)this, "setChassisTag", "parsing unitIndex to Tray id");
        int valFromTag = Integer.parseInt(chassisTag.substring(chassisTag.indexOf(":") + 1));
        this.id = Integer.toString(valFromTag);
        this.idOneBased = Integer.toString(valFromTag + 1);
        this.tee4NameAsIP = chassisTag.substring(0, chassisTag.indexOf(":"));
        Trace.verbose((Object)this, "setChassisTag", "tray id = " + this.id + " as onebased is = " + this.idOneBased + " on array with ip = " + this.tee4NameAsIP);
    }

    public void setTrayType(int trayType) {
        Trace.methodBegin(this, "setTrayType");
        Trace.verbose((Object)this, "setTrayType", "trayType passed in=" + trayType);
        this.trayType = trayType;
    }

    public void setCIMInstance(CIMInstance trayCimInstance) {
        Trace.methodBegin(this, "setCIMInstance");
        this.trayCimInstance = trayCimInstance;
        this.trayCimObjPath = trayCimInstance.getObjectPath();
    }

    public void setMapElementList(Collection mapElementList) {
        Trace.methodBegin(this, "setMapElementList");
        this.mapElementList = mapElementList;
    }

    public void setT4CimObjectPath(CIMObjectPath t4CimObjectPath) {
        Trace.methodBegin(this, "setT4CIMObjectPath");
        this.t4CimObjectPath = t4CimObjectPath;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public void setState(int state) {
        this.state = state;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setOperationalStatus(int operationalStatus) {
        this.operationalStatus = operationalStatus;
    }

    public void setUnitId(String unitId) {
        this.unitId = unitId;
    }

    public void setT4Interface(T4Interface t4Interface) {
        this.t4Interface = t4Interface;
    }

    private CIMArgument[] buildOutArgsForCreate() {
        CIMArgument[] cimOutArguments = new CIMArgument[]{new CIMArgument("Job"), new CIMArgument("Pool"), new CIMArgument("Size", new CIMValue((Object)new Integer(0)))};
        return cimOutArguments;
    }

    private CIMArgument[] buildInArgsForCreate(String poolName, CIMObjectPath storageSettingOP, Vector storageExtVector) {
        Trace.verbose((Object)this, "buildInArgsForCreate", "New poolName = <" + poolName + ">");
        int cnt = 0;
        CIMArgument[] cimInArguments = new CIMArgument[7];
        CIMArgument ca = new CIMArgument("InstanceName", new CIMValue((Object)poolName));
        cimInArguments[cnt++] = ca;
        ca = new CIMArgument("Goal", new CIMValue((Object)storageSettingOP));
        cimInArguments[cnt++] = ca;
        ca = new CIMArgument("Size", new CIMValue((Object)new Integer(0)));
        cimInArguments[cnt++] = ca;
        ca = new CIMArgument("InPool", new CIMValue(null));
        cimInArguments[cnt++] = ca;
        Vector<String> v = new Vector<String>();
        Enumeration enumeration = storageExtVector.elements();
        while (enumeration.hasMoreElements()) {
            v.add(enumeration.nextElement().toString());
        }
        ca = new CIMArgument("InExtents", new CIMValue(v));
        cimInArguments[cnt++] = ca;
        ca = new CIMArgument("Pool", new CIMValue(null));
        cimInArguments[cnt++] = ca;
        ca = new CIMArgument("Description", new CIMValue((Object)("job.description.createpool + " + poolName)));
        cimInArguments[cnt++] = ca;
        return cimInArguments;
    }

    private boolean isStatusUnknown(int cimReturnCode) {
        return cimReturnCode != 0 && cimReturnCode != 4096;
    }

    private void findRaidGroups() throws ConfigMgmtException {
        Trace.methodBegin(this, "findRaidGroups");
        this.raidGroups = new ArrayList();
        Trace.verbose((Object)this, "findRaidGroups", "Getting RaidGroup Manager via Factory to get RaidGroups!!");
        ManageRaidGroupsInterface manageRaidGroups = ManageRaidGroupsFactory.getManager();
        manageRaidGroups.setScope(this);
        manageRaidGroups.init(this.context, null);
        this.raidGroups = (ArrayList)manageRaidGroups.getItemList();
        if (Trace.isTraceEnabled(this)) {
            Trace.verbose((Object)this, "findRaidGroups", "Done getting RaidGroups in Tray: number of raid groups in this tray: " + this.raidGroups.size());
            for (int i = 0; i < this.raidGroups.size(); ++i) {
                Trace.verbose((Object)this, "findRaidGroups", "RaidGroup " + i + ": name = " + ((RaidGroup)this.raidGroups.get(i)).getName());
                Trace.verbose((Object)this, "findRaidGroups", "RaidGroup " + i + ": totalCapacity = " + ((RaidGroup)this.raidGroups.get(i)).getTotalCapacity());
                Trace.verbose((Object)this, "findRaidGroups", "*********************************");
            }
        }
    }

    private void reloadChassis() throws ConfigMgmtException {
        Trace.methodBegin(this, "reloadChassis");
        try {
            Trace.verbose((Object)this, "reloadChassis", "Getting a new Chassis CIMInstance!!");
            String[] chassisPropList = new String[]{"Tag", "ChassisTypes", "CreationClassName"};
            CIMInstance newTrayCimInstance = this.cimClient.getInstance(this.trayCimObjPath, false, true, false, chassisPropList);
            Trace.verbose((Object)this, "reloadChassis", "Setting properties from new Chassis CIMInstance to this Tray object using CIMObjectWrapper.poplate()");
            CIMObjectWrapper.populate(this, this.mapElementList, newTrayCimInstance);
            this.trayCimInstance = newTrayCimInstance;
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "reloadChassis", "Failed: " + cme.getMessage());
            throw cme;
        }
    }

    private void getContiguousDriveSequence() throws ConfigMgmtException {
        Trace.methodBegin(this, "getContiguousDriveSequence");
        if (this.diskManager == null) {
            Trace.verbose((Object)this, "getContiguousDriveSequence", "diskManager has not been loaded yet: calling findAllDisksInTrayFromCIMOM() to find all the disks in the Tray!");
            this.findAllDisksInTrayFromCIMOM();
        }
        if (this.raidGroups == null) {
            Trace.verbose((Object)this, "getContiguousDriveSequence", "RaidGroups are not loaded yet....calling getRaidGroups() to load them!");
            this.getRaidGroups();
        }
        Trace.verbose((Object)this, "getContiguousDriveSequence", "asking disk manager for contiguous drives.");
        this.contigDiskSequence = this.diskManager.getContiguousDiskChunks(this.getT4Interface().getQueuedPoolData().getAllStorageExtents());
    }

    private void findT4FromCIMOM() throws ConfigMgmtException {
        String methodName = "findT4FromCIMOM";
        Trace.methodBegin(this, methodName);
        SearchFilter t4Filter = new SearchFilter("Name", this.getT4Name());
        ManageT4sInterface mT4s = ManageT4sFactory.getManager();
        mT4s.init(this.context, t4Filter);
        ArrayList t4s = (ArrayList)mT4s.getItemList();
        if (t4s.size() != 1) {
            Trace.verbose((Object)this, methodName, "ManageT4s returned zero or more then one element.");
            if (t4s.isEmpty()) {
                throw new ConfigMgmtException("ZERO_CIM_INSTANCE_RETURNED", "ManageT4s did not return any instances.");
            }
            throw new ConfigMgmtException("TOOMANY_CIM_INSTANCE_RETURNED", "ManageT4s returned more than one instance.");
        }
        this.setT4Interface((T4Interface)t4s.get(0));
        this.setT4CimObjectPath(this.t4Interface.getInstance().getObjectPath());
        Trace.verbose((Object)this, methodName, "t4CimObjectPath = " + this.t4CimObjectPath);
    }

    private void findAllDisksInTrayFromCIMOM() throws ConfigMgmtException {
        String METHOD = "findAllDisksInTrayFromCIMOM";
        Trace.methodBegin(this, "findAllDisksInTrayFromCIMOM");
        this.diskManager = new ManageDisks();
        boolean allHealthySoFar = true;
        try {
            Trace.verbose((Object)this, "findAllDisksInTrayFromCIMOM", "Getting disks on tray.");
            this.diskManager.setScope(this);
            this.diskManager.init(this.context, null);
            List disks = this.diskManager.getItemList();
            this.numberOfDrives = disks.size();
            Iterator iDisks = disks.iterator();
            while (iDisks.hasNext()) {
                Disk d = (Disk)iDisks.next();
                this.driveCapacity = d.getCapacity();
                if (!allHealthySoFar || d.getStatus() == 2) continue;
                allHealthySoFar = false;
            }
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "findAllDisksInTrayFromCIMOM", "Failed: " + cme.getMessage());
            throw cme;
        }
        catch (NullPointerException ne) {
            Trace.verbose((Object)this, "Null value while obtaining Disks for a tray.", (Throwable)ne);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "Null value returned error.", ne);
        }
        this.allDrivesHealthy = new Boolean(allHealthySoFar);
        Trace.verbose((Object)this, "findAllDisksInTrayFromCIMOM", "Finished looping through all drives....");
    }

    public boolean isDepop() throws Exception {
        String methodName = "isDepop";
        Trace.methodBegin(this, methodName);
        Trace.verbose((Object)this, methodName, "Number of drives in tray = " + this.getNumberOfDrives());
        if (this.getNumberOfDrives() < 14) {
            Trace.verbose((Object)this, methodName, "Tray number of drives is < max drives; this is DEPOP!");
            return true;
        }
        Trace.verbose((Object)this, methodName, "Tray is NOT DEPOP");
        return false;
    }

    public boolean areAllDisksHealthy() throws ConfigMgmtException {
        String methodName = "areAllDisksHealthy";
        Trace.methodBegin(this, methodName);
        if (this.diskManager == null) {
            Trace.verbose((Object)this, methodName, "disk list is null: calling findAllDisksInTrayFromCIMOM() to get all disks in tray from CIMOM!!");
            this.findAllDisksInTrayFromCIMOM();
        }
        if (this.allDrivesHealthy != null) {
            return this.allDrivesHealthy;
        }
        return false;
    }

    public int compareTo(Object o) {
        Trace.methodBegin(this, "compareTo");
        int result = 0;
        if (o instanceof Tray) {
            Tray comparingInstance = (Tray)o;
            try {
                int comparingInt = Integer.parseInt(comparingInstance.getId());
                int thisInt = Integer.parseInt(this.getId());
                result = comparingInt - thisInt;
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        return result;
    }

    public void enable(boolean enable) throws ConfigMgmtException {
        Trace.methodBegin(this, "enable");
        if (this.getTrayType() != 17) {
            String message = "Can not enable/disable a tray without controller.";
            Trace.verbose((Object)this, "enable", message);
            throw new ConfigMgmtException("TRAY_WITHOUT_CONTROLLER_ERROR", message);
        }
        if (enable) {
            if (2 == this.getState()) {
                String message = "Traying to enable already enabled tray.";
                Trace.verbose((Object)this, "enable", message);
                throw new ConfigMgmtException("TRAY_ALREADY_ENABLED", message);
            }
            this.setRequestedStatus(2);
        } else {
            if (3 == this.getState()) {
                String message = "Traying to disable already disabled tray.";
                Trace.verbose((Object)this, "enable", message);
                throw new ConfigMgmtException("TRAY_ALREADY_DISABLED", message);
            }
            this.setRequestedStatus(3);
        }
        this.controllerSystemPropertiesLookup();
    }

    public void unconfigure() throws ConfigMgmtException {
        Trace.methodBegin(this, "unconfigure");
        if (this.getTrayType() != 17) {
            String message = "Can not unconfigure a tray without controller.";
            Trace.verbose((Object)this, "unconfigure", message);
            throw new ConfigMgmtException("TRAY_WITHOUT_CONTROLLER_ERROR", message);
        }
        if (this.getState() != 3) {
            String message = "Can not unconfigure enabled tray.";
            Trace.verbose((Object)this, "unconfigure", message);
            throw new ConfigMgmtException("CAN_NOT_UNCONFIGURE_ENABLED_TRAY_ERROR", message);
        }
        if ("offline".equals(this.getStatus())) {
            String message = "Traying to unconfigure already unconfigured tray.";
            Trace.verbose((Object)this, "unconfigure", message);
            throw new ConfigMgmtException("TRAY_ALREADY_UNCONFIGURED", message);
        }
        this.setRequestedStatus(6);
        this.controllerSystemPropertiesLookup();
    }

    private void setRequestedStatus(int status) throws ConfigMgmtException {
        Trace.methodBegin(this, "setRequestedStatus");
        if (this.csInstance == null) {
            this.controllerSystemPropertiesLookup();
        }
        String message = "RequestedStatus set to " + status + " for the tray " + this.getId();
        try {
            this.csInstance.setProperty("RequestedStatus", new CIMValue((Object)new UnsignedInt16(status)));
            this.cimClient.setInstance(this.csInstance.getObjectPath(), this.csInstance);
            Trace.verbose((Object)this, "setRequestedStatus", message);
        }
        catch (IllegalArgumentException iae) {
            Trace.verbose((Object)this, "setRequestedStatus", (Throwable)iae);
            throw new ConfigMgmtException("CIM_SET_PROPERTY_FAILED", "IllegalArgumentException when " + message, iae);
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "setRequestedStatus", "Failed: " + cme.getMessage());
            throw cme;
        }
        catch (CIMException ce) {
            Trace.verbose((Object)this, "setRequestedStatus", "Set Property Failed.");
            throw new ConfigMgmtException("CIM_SET_PROPERTY_FAILED", "Set Property Failed.", (Exception)((Object)ce));
        }
    }

    private void controllerSystemPropertiesLookup() throws ConfigMgmtException {
        Trace.methodBegin(this, "controllerSystemPropertiesLookup");
        this.cspPopulated = true;
        Enumeration enumeration = null;
        try {
            String queryString = "select * from SunStorEdge_6120ControllerSystem where ElementName = '" + this.tee4NameAsIP + "' and " + "Caption" + " = '" + this.getUnitId() + "'";
            Trace.verbose((Object)this, "controllerSystemPropertiesLookup", "Query string created: " + queryString);
            enumeration = CIMObjectWrapper.execQuery(this.cimClient, queryString);
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "controllerSystemPropertiesLookup", "Failed: " + cme.getMessage());
            throw cme;
        }
        if (enumeration != null && enumeration.hasMoreElements()) {
            Trace.verbose((Object)this, "controllerSystemPropertiesLookup", "Tray " + this.getId() + " is the controlling tray.");
            this.csInstance = (CIMInstance)enumeration.nextElement();
            if (enumeration.hasMoreElements()) {
                String message = "More than one ControllerSystem instance returned for the tray: " + this.getId();
                Trace.verbose((Object)this, "controllerSystemPropertiesLookup", message);
                throw new ConfigMgmtException("TOOMANY_CIM_INSTANCE_RETURNED", message);
            }
            CIMObjectWrapper.populate(this, this.getFieldMap(), this.csInstance);
        }
    }

    private Collection getFieldMap() {
        Trace.methodBegin(this, "getFieldMap");
        if (null == this.fieldMap) {
            this.fieldMap = new ArrayList();
            this.fieldMap.add(new MapElement("operationalStatus", "OperationalStatus", true, true, 0));
            this.fieldMap.add(new MapStringArrayToString("status", "StatusDescriptions", true, true, 0));
            this.fieldMap.add(new MapElement("state", "EnabledState", true, true));
            this.fieldMap.add(new MapStringArrayToString("role", "Roles", true, true, 0));
        }
        return this.fieldMap;
    }

    public synchronized List getDiskList() throws ConfigMgmtException {
        if (this.diskManager == null) {
            Trace.verbose((Object)this, "getDisks", "disk list is null: calling findAllDisksInTrayFromCIMOM() to get all disks in tray from CIMOM!!");
            this.findAllDisksInTrayFromCIMOM();
        }
        if (this.diskManager == null) {
            throw new ZeroCIMInstanceReturnedException("ZERO_CIM_INSTANCE_RETURNED", "Unable to find disks for Tray Id: " + this.getId());
        }
        return this.diskManager.getItemList();
    }

    public int getNumberOfDisksInRole(String role) throws ConfigMgmtException {
        if (!("unassigned".equals(role) || "dataDisk".equals(role) || "standbyDisk".equals(role) || "globalStandbyDisk".equals(role))) {
            Trace.verbose((Object)this, "getNumberOfDisksInRole(String)", "Requested an unhandled disk role: " + role);
            throw new ConfigMgmtException("ACTION_NOT_SUPPORTED", "Role: " + role + " not supported disk role.");
        }
        int val = 0;
        List l = this.getDiskList();
        int size = l.size();
        for (int i = 0; i < size; ++i) {
            DiskInterface d = (DiskInterface)l.get(i);
            if (!role.equals(d.getRole())) continue;
            ++val;
        }
        return val;
    }

    public synchronized List getDisksAvailableForPool(boolean usesHotSpare) throws ConfigMgmtException {
        List l;
        int endSlot;
        int beginSlot;
        ArrayList<DiskInterface> avail;
        block9: {
            block7: {
                block8: {
                    String METHOD = "getDisksAvailableForPool";
                    Trace.methodBegin(this, "getDisksAvailableForPool");
                    avail = new ArrayList<DiskInterface>();
                    int numGroups = this.getNumRequestedAndExistingRaidGroups();
                    if (numGroups > 1) {
                        Trace.verbose((Object)this, "getDisksAvailableForPool", "Already have 2 pools, returning empty list.");
                        return avail;
                    }
                    if (this.contigDiskSequence == null) {
                        this.getContiguousDriveSequence();
                    }
                    int chunks = this.contigDiskSequence.size();
                    beginSlot = -1;
                    endSlot = -1;
                    if (chunks == 0) {
                        Trace.verbose((Object)this, "getDisksAvailableForPool", "No chunks returning empty list.");
                        return avail;
                    }
                    beginSlot = ((DiskInterface)this.contigDiskSequence.get(0)).getSlotNumber();
                    endSlot = ((DiskInterface)this.contigDiskSequence.get(1)).getSlotNumber();
                    Trace.verbose((Object)this, "getDisksAvailableForPool", "Biggest possible chunk start: " + beginSlot + " and end: " + endSlot);
                    if (!usesHotSpare || chunks > 2) break block7;
                    if (!this.getT4Interface().isFeatureSupported(4)) break block8;
                    Trace.verbose((Object)this, "getDisksAvailableForPool", "one chunk and requesting dedicated spare so reduce it by one.");
                    --endSlot;
                    break block9;
                }
                if (endSlot != 14) break block9;
                Trace.verbose((Object)this, "getDisksAvailableForPool", "one chunk with the last slot in chunk, wants hot spare and on 3.0 so reduce it by one.");
                --endSlot;
                break block9;
            }
            if (usesHotSpare && !this.getT4Interface().isFeatureSupported(4)) {
                l = this.getDiskList();
                boolean done = false;
                for (int i = l.size() - 1; !done && i >= 0; --i) {
                    DiskInterface disk = (DiskInterface)l.get(i);
                    if (disk.getSlotNumber() != 14) continue;
                    done = true;
                    if ("unassigned".equals(disk.getRole()) || "standbyDisk".equals(disk.getRole())) continue;
                    Trace.verbose((Object)this, "getDisksAvailableForPool", "Requested hot spare in firmware 3.0, but it is not available.");
                    beginSlot = endSlot;
                }
            }
        }
        if (endSlot > beginSlot) {
            l = this.getDiskList();
            for (int i = 0; i < l.size(); ++i) {
                DiskInterface disk = (DiskInterface)l.get(i);
                int cSlot = disk.getSlotNumber();
                if (cSlot < beginSlot || cSlot > endSlot) continue;
                avail.add(disk);
            }
        }
        Trace.verbose((Object)this, "getDisksAvailableForPool", "Returning list size: " + avail.size());
        return (List)avail.clone();
    }

    public PoolBreakdownForTray getPoolBreakdownForTray(int numPools, int numDataDrives, int raidLevel, boolean useSpare) throws ConfigMgmtException {
        return new PoolBreakdownForTray(this, numPools, numDataDrives, raidLevel, useSpare);
    }

    public MethodCallStatus createRAIDGroup(String poolName, List disks, StorageProfile profile, boolean usesHotSpare) throws ConfigMgmtException {
        String methodName = "createStoragePool";
        Trace.methodBegin(this, methodName);
        if (poolName == null) {
            String message = "Pool name null.";
            Trace.verbose((Object)this, methodName, message);
            throw new ConfigMgmtException("POOL_CREATE_ERROR", message);
        }
        if (disks == null || disks.isEmpty()) {
            String message = "List of disks null or empty.";
            Trace.verbose((Object)this, methodName, message);
            throw new ConfigMgmtException("POOL_CREATE_ERROR", message);
        }
        if (profile == null) {
            String message = "StorageProfile instance null.";
            Trace.verbose((Object)this, methodName, message);
            throw new ConfigMgmtException("POOL_CREATE_ERROR", message);
        }
        if (!profile.getNumberOfDrives().equals("variable") && Integer.parseInt(profile.getNumberOfDrives()) != disks.size()) {
            String message = "Profile number of disks does not match size of the disk list passed.";
            Trace.verbose((Object)this, methodName, message);
            throw new ConfigMgmtException("POOL_CREATE_ERROR", message);
        }
        if (this.getT4Interface().isFeatureSupported(4)) {
            usesHotSpare = profile.getDedicatedHotSpare() == 1;
        }
        MethodCallStatus status = this.createRAIDGroupInCIMOM(poolName, disks, profile.getRaidLevel(), usesHotSpare, profile.getName(), new ArrayList());
        return status;
    }

    private MethodCallStatus createRAIDGroupInCIMOM(String poolName, List disks, int raidLevel, boolean usesHotSpare, String profileName, ArrayList jobLinks) throws ConfigMgmtException {
        String methodName = "createStoragePoolInCIMOM";
        Trace.methodBegin(this, methodName);
        MethodCallStatus methodCallStatus = new MethodCallStatus();
        ArrayList theJobList = new ArrayList();
        if (this.storageConfigServiceObjPath == null) {
            this.storageConfigServiceObjPath = StorageConfigurationServiceBuilder.getInstance(this.cimClient, this.getT4CimObjectPath());
        }
        try {
            CIMObjectPath storageSettingPath = Tray.getStorageSettingObjectPath(raidLevel, usesHotSpare, profileName, this.cimClient);
            Vector storageExtentsPaths = this.loadStorageExtentPaths(disks);
            CIMArgument[] cimInArguments = this.buildInArgsForCreate(poolName, storageSettingPath, storageExtentsPaths);
            CIMArgument[] cimOutArguments = this.buildOutArgsForCreate();
            InvocationHelper invokeHelper = new InvocationHelper();
            Trace.verbose((Object)this, methodName, "Calling InvocationHelper invoke method.");
            invokeHelper.invoke(null, this.context, methodCallStatus, cimInArguments, cimOutArguments, this.storageConfigServiceObjPath, "CreateOrModifyStoragePool", jobLinks);
            int cimReturnCode = methodCallStatus.getReturnCode();
            Trace.verbose((Object)this, methodName, "Extrinsic method return code: " + cimReturnCode);
            if (this.isStatusUnknown(cimReturnCode)) {
                Trace.verbose((Object)this, methodName, "CIM return code indicates failure or other unknown value");
                throw new ConfigMgmtException("POOL_CREATE_ERROR", "An error occurred while creating a StoragePool. CIM returned either a failure or unknown code: " + cimReturnCode);
            }
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, methodName, "Failed: " + cme.getMessage());
            if (!"POOL_CREATE_DISK_OFFLINE_ERROR".equals(cme.getExceptionKey())) {
                cme.setExceptionKey("POOL_CREATE_ERROR");
            }
            throw cme;
        }
        return methodCallStatus;
    }

    public static CIMObjectPath getStorageSettingObjectPath(int raidLevel, boolean usesHotSpare, String profileName, CIMOMHandleWrapper cimClient) throws ConfigMgmtException {
        String methodName = "getStorageSettingObjectPath";
        Trace.methodBegin(class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$mr3$Tray == null ? (class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$mr3$Tray = Tray.class$("com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.mr3.Tray")) : class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$mr3$Tray, methodName);
        Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$mr3$Tray == null ? (class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$mr3$Tray = Tray.class$("com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.mr3.Tray")) : class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$mr3$Tray, methodName, "raidLevel = " + raidLevel + "; usesHotSpare = " + usesHotSpare + "; profileName = " + profileName);
        CIMObjectPath storageSettingPath = null;
        HashMap propertyHash = null;
        int spindleRedundancy = 1;
        if (usesHotSpare) {
            spindleRedundancy = 2;
        }
        switch (raidLevel) {
            case 0: {
                Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$mr3$Tray == null ? (class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$mr3$Tray = Tray.class$("com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.mr3.Tray")) : class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$mr3$Tray, methodName, "Loading StorageSetting for Raid 0.");
                propertyHash = Tray.loadStorageSettingHash(false, 1, 0, profileName);
                break;
            }
            case 1: {
                Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$mr3$Tray == null ? (class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$mr3$Tray = Tray.class$("com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.mr3.Tray")) : class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$mr3$Tray, methodName, "Loading StorageSetting for Raid 1.");
                propertyHash = Tray.loadStorageSettingHash(true, 2, spindleRedundancy, profileName);
                break;
            }
            case 5: {
                Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$mr3$Tray == null ? (class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$mr3$Tray = Tray.class$("com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.mr3.Tray")) : class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$mr3$Tray, methodName, "Loading StorageSetting for Raid 5.");
                propertyHash = Tray.loadStorageSettingHash(true, 1, spindleRedundancy, profileName);
                break;
            }
            default: {
                Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$mr3$Tray == null ? (class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$mr3$Tray = Tray.class$("com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.mr3.Tray")) : class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$mr3$Tray, methodName, "Incorrect raid level passed.");
                throw new ConfigMgmtException("incorrect.method.parameter", "Incorrect raid level passed.");
            }
        }
        Vector propVector = CIMObjectWrapper.instanceKeyBuilder(propertyHash);
        storageSettingPath = CIMObjectWrapper.createInstance(cimClient, propVector, "SunStorEdge_6120StorageSetting");
        Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$mr3$Tray == null ? (class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$mr3$Tray = Tray.class$("com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.mr3.Tray")) : class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$mr3$Tray, methodName, "storageSettingPath we looked up is:" + storageSettingPath);
        return storageSettingPath;
    }

    private static HashMap loadStorageSettingHash(boolean singlePointFailure, int dataRedundancy, int spindleRedundancy, String profileName) {
        Trace.methodBegin(class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$mr3$Tray == null ? (class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$mr3$Tray = Tray.class$("com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.mr3.Tray")) : class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$mr3$Tray, "loadStorageSetting");
        HashMap<String, Object> propertyHash = new HashMap<String, Object>();
        propertyHash.put("InstanceID", String.valueOf(System.currentTimeMillis()));
        propertyHash.put("NoSinglePointOfFailure", new Boolean(singlePointFailure));
        propertyHash.put("DataRedundancyMax", new UnsignedInt16(dataRedundancy));
        propertyHash.put("DataRedundancyMin", new UnsignedInt16(dataRedundancy));
        propertyHash.put("PackageRedundancyMax", new UnsignedInt16(spindleRedundancy));
        propertyHash.put("PackageRedundancyMin", new UnsignedInt16(spindleRedundancy));
        propertyHash.put("Description", profileName);
        return propertyHash;
    }

    private Vector loadStorageExtentPaths(List disks) throws ConfigMgmtException {
        String methodName = "loadStorageExtentPaths";
        Trace.methodBegin(this, methodName);
        Vector<CIMObjectPath> storageExtentPaths = new Vector<CIMObjectPath>();
        Iterator iter = disks.iterator();
        while (iter.hasNext()) {
            Disk element = (Disk)iter.next();
            if ("enabled".equals(element.getState()) && 2 == element.getStatus()) {
                storageExtentPaths.add(element.getStorageExtentObjectPath());
                continue;
            }
            String message = "Disk in slot number <" + element.getSlotNumber() + "> with status <" + element.getStatus() + "> and state <" + element.getState() + "> not valid for pool creation.";
            Trace.verbose((Object)this, methodName, message);
            ConfigMgmtException cme = new ConfigMgmtException("POOL_CREATE_DISK_OFFLINE_ERROR", message);
            cme.addExceptionContext(element);
            throw cme;
        }
        Trace.verbose((Object)this, methodName, "Number of StorageExtents paths in the Vector: " + storageExtentPaths.size());
        return storageExtentPaths;
    }

    public boolean equals(Object o) {
        boolean result = super.equals(o);
        if (o != null && o instanceof Tray) {
            Tray tray = (Tray)o;
            result = tray.getId() != null && tray.getId().equals(this.getId());
        }
        return result;
    }

    public boolean isDedicatedHotSpareAvailable(BigInteger effectiveDiskCapacity) throws ConfigMgmtException {
        String methodName = "isDedicatedHotSpareAvailable";
        Trace.methodBegin(this, methodName);
        List allTrayDisks = this.getDiskList();
        Iterator iter = allTrayDisks.iterator();
        while (iter.hasNext()) {
            DiskInterface disk = (DiskInterface)iter.next();
            if (!"unassigned".equals(disk.getRole()) || disk.getSlotNumber() == 1 || effectiveDiskCapacity.compareTo(disk.getCapacity()) > 0) continue;
            Trace.verbose((Object)this, methodName, "Disk " + disk.getName() + " available for dedicated hot spare on the tray " + this.getId());
            return true;
        }
        Trace.verbose((Object)this, methodName, "No available disks for dedicated hot spare on the tray: " + this.getId());
        return false;
    }

    public synchronized int getNumRequestedAndExistingRaidGroups() throws ConfigMgmtException {
        int numGroups = 0;
        String METHOD = "getNumRequestedAndExistingRaidGroups";
        Trace.methodBegin(this, "getNumRequestedAndExistingRaidGroups");
        if (this.numRequestedAndExistingRaidGroups < 0) {
            ArrayList rGroups = this.getRaidGroups();
            QueuedPoolData qpd = this.getT4Interface().getQueuedPoolData();
            if (rGroups == null) {
                rGroups = new ArrayList();
            }
            numGroups = rGroups.size();
            for (int i = 0; i < qpd.getNumQueuedPools(); ++i) {
                if (!this.id.equals("" + qpd.getTrayId(i))) continue;
                boolean alreadyCounted = false;
                for (int j = 0; !alreadyCounted && j < rGroups.size(); ++j) {
                    RaidGroupInterface rg = (RaidGroupInterface)rGroups.get(j);
                    if (!rg.getName().equals(qpd.getPoolName(i))) continue;
                    alreadyCounted = true;
                }
                if (alreadyCounted) continue;
                Trace.verbose((Object)this, "getNumRequestedAndExistingRaidGroups", "Found queued pool not created yet: " + qpd.getPoolName(i));
                ++numGroups;
            }
            Trace.verbose((Object)this, "getNumRequestedAndExistingRaidGroups", "Found num raid groups: " + numGroups);
            this.numRequestedAndExistingRaidGroups = numGroups;
        }
        return this.numRequestedAndExistingRaidGroups;
    }

    public boolean areDisksCompatible(TrayInterface dest) throws ConfigMgmtException {
        String METHOD = "areDisksCompatible";
        Trace.methodBegin(this, "areDisksCompatible");
        boolean result = false;
        List srcDisks = this.getDiskList();
        if (dest != null) {
            if (dest.getT4Interface().getClusterName().equals(this.getT4Interface().getClusterName()) && dest.getId().equals(this.getId())) {
                Trace.verbose((Object)this, "areDisksCompatible", "Not compatible: Same tray on same array.");
                return result;
            }
            List destDisks = dest.getDiskList();
            if (destDisks.size() != srcDisks.size()) {
                Trace.verbose((Object)this, "areDisksCompatible", "Not compatible: Different number of disks on tray.");
                return result;
            }
            for (int i = 0; i < srcDisks.size(); ++i) {
                DiskInterface sDisk = (DiskInterface)srcDisks.get(i);
                DiskInterface dDisk = (DiskInterface)destDisks.get(i);
                if (sDisk.getSlotNumber() != dDisk.getSlotNumber()) {
                    Trace.verbose((Object)this, "areDisksCompatible", "Not compatible: Different slots used for disks.");
                    return result;
                }
                if (sDisk.getCapacity().compareTo(dDisk.getCapacity()) == 0) continue;
                Trace.verbose((Object)this, "areDisksCompatible", "Not compatible: Different disk capacity on tray.");
                return result;
            }
            result = true;
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

