/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.mr3;

import com.sun.netstorage.array.mgmt.cfg.core.Constants;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.BadParameterException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.impl.CIMObjectWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.impl.MapElement;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageProfileInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.StorageProfileCommon;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.ent1.StorageProfileParameters;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.mr3.StoragePool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;

public class StorageProfile
extends StorageProfileCommon {
    public String getCIMObjectName() {
        return "SunStorEdge_6120StorageSettingWithHints";
    }

    public String getCIMPropNameForName() {
        return "ElementName";
    }

    public String[] getCIMObjectPropertyNames() {
        return Constants.StorageSettingWithHintsProperties.PROP_LIST;
    }

    public Collection getFieldMap() {
        Trace.methodBegin(this, "getFieldMap");
        ArrayList<MapElement> fieldMap = new ArrayList<MapElement>();
        fieldMap.add(new MapElement("popname", "ElementName", false, false));
        fieldMap.add(new MapElement("description", "Description", false, true));
        fieldMap.add(new MapElement("instanceID", "InstanceID", true, false));
        fieldMap.add(new MapElement("productVersion", "ProductVersion", true, true));
        fieldMap.add(new MapElement("segmentSize", "SegmentSize", false, true));
        fieldMap.add(new MapElement("accessDirectionHint", "AccessDirectionHint", false, true));
        fieldMap.add(new MapElement("accessBandwidthWeight", "AccessBandwidthWeight", false, true));
        fieldMap.add(new MapElement("numberOfDisks", "NumberOfDisks", false, true));
        fieldMap.add(new MapElement("dataRedundancy", "DataRedundancyGoal", false, true));
        fieldMap.add(new MapElement("packageRedundancy", "PackageRedundancyGoal", false, true));
        fieldMap.add(new MapElement("noSinglePointOfFailure", "NoSinglePointOfFailure", false, true));
        fieldMap.add(new MapElement("factoryProfile", "Factory", false, false));
        return fieldMap;
    }

    public Collection getKeyCollection() {
        Trace.methodBegin(this, "getKeyCollection");
        ArrayList<CIMProperty> keyList = new ArrayList<CIMProperty>();
        keyList.add(new CIMProperty("InstanceID", new CIMValue((Object)this.getInstanceID())));
        return keyList;
    }

    public StorageProfileParameters getProfileParameters() {
        StorageProfileParameters param = new StorageProfileParameters();
        param.setName(this.getName());
        param.setDescription(this.getDescription());
        param.setReadAhead(this.isReadAheadEnabled());
        param.setHotSpare(this.dedicatedSpareExists());
        param.setRaidLevel(this.getRAIDLevel());
        param.setSegmentSize(this.getSegmentSize());
        param.setArrayType(this.getArrayType());
        param.setNumDisks(this.getNumberOfDisks());
        return param;
    }

    protected void populatePersistedProfile(StorageProfileInterface persistedProfile) throws ConfigMgmtException, BadParameterException {
        Trace.methodBegin(this, "populatePersistedProfile(StorageProfileInterface)");
        persistedProfile.setDescription(this.getDescription());
        persistedProfile.setSegmentSize(this.getSegmentSize());
        persistedProfile.setReadAhead(this.isReadAheadEnabled());
        persistedProfile.setRAIDLevel(this.getRAIDLevel());
        persistedProfile.setArrayType(this.getArrayType());
        persistedProfile.setNumberOfDisks(this.getNumberOfDisks());
        persistedProfile.setDedicatedSpare(this.dedicatedSpareExists());
    }

    public ArrayList getAssocPools() throws ConfigMgmtException {
        Trace.methodBegin(this, "getAssocPools");
        ArrayList<StoragePool> pools = new ArrayList<StoragePool>();
        try {
            Trace.verbose((Object)this, "getAssocPools", "Querying CIM for associated StoragePools.");
            Enumeration enumeration = null;
            Trace.verbose((Object)this, "getAssocPools", "Returned from querying CIM for StoragePools.");
            if (enumeration != null && enumeration.hasMoreElements()) {
                Trace.verbose((Object)this, "getAssocPools", "StoragePool Instances Found.");
                while (enumeration.hasMoreElements()) {
                    Trace.verbose((Object)this, "getAssocPools", "Creating StoragePool Java Objects.");
                    CIMInstance ci = (CIMInstance)enumeration.nextElement();
                    StoragePool pool = new StoragePool();
                    pool.setInstance(ci);
                    pool.init(this.context);
                    CIMObjectWrapper.populate(pool, pool.getFieldMap(), ci);
                    ArrayList<CIMProperty> prop = new ArrayList<CIMProperty>();
                    prop.add(new CIMProperty("InstanceID", new CIMValue((Object)pool.getInstanceID())));
                    pool.setKey(prop);
                    pools.add(pool);
                    Trace.verbose((Object)this, "getAssocPools", "The instance added to the list: " + pool);
                }
            }
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "getAssocPools", "Failed: " + cme);
            throw cme;
        }
        catch (NullPointerException npe) {
            Trace.error((Object)this, "getAssocPools", "NullPointerException - Null returned when trying to obtain all the StoragePool  instances: " + npe);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - Problems getting all the StoragePool instances.", npe);
        }
        catch (Exception e) {
            Trace.error((Object)this, "getAssocPools", "Exception - Exception thrown when trying to obtain all the StoragePool instances: " + e);
            throw new ConfigMgmtException("error.systemError", "Exception - Problems getting all the StoragePool instances.", e);
        }
        return pools;
    }

    public String toXml() {
        String methodName = "toXml";
        StringBuffer theXml = new StringBuffer(512);
        String lineBuffer = "\n  ";
        theXml.append("<sscs_storage_profile>" + lineBuffer);
        theXml.append("<profile_name>" + this.getName() + "</profile_name>" + lineBuffer);
        theXml.append("<product_version>" + this.getProductVersion() + "</product_version>" + lineBuffer);
        theXml.append("<profile_description>" + this.getDescription() + "</profile_description>" + lineBuffer);
        theXml.append("<raid_level>" + this.getRAIDLevel() + "</raid_level>" + lineBuffer);
        theXml.append("<segment_size>" + StorageProfile.getSegmentSizeString(this.segmentSize) + "</segment_size>" + lineBuffer);
        theXml.append("<read_ahead_mode>" + (this.isReadAheadEnabled() ? "on" : "off") + "</read_ahead_mode>" + lineBuffer);
        theXml.append("<array_type>" + StorageProfile.getArrayTypeString(this.getArrayType()) + "</array_type>" + lineBuffer);
        theXml.append("<number_of_disks>" + this.getNumberOfDisks() + "</number_of_disks>" + lineBuffer);
        theXml.append("<dedicated_hot_spare>" + StorageProfile.getYesOrNoFromBoolean(this.dedicatedSpareExists()) + "</dedicated_hot_spare>" + lineBuffer);
        theXml.append("<factory_profile>" + StorageProfile.getYesOrNoFromBoolean(this.getFactoryProfile()) + "</factory_profile>" + lineBuffer);
        theXml.append("</sscs_storage_profile>\n");
        return theXml.toString();
    }
}

