/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.mr3;

import com.sun.netstorage.array.mgmt.cfg.core.CIMOMHandleWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.MethodCallStatus;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.NoSuchRaidLevelException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.TooManyCIMInstanceException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ZeroCIMInstanceReturnedException;
import com.sun.netstorage.array.mgmt.cfg.core.impl.CIMObjectWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.impl.mr3.InvocationHelper;
import com.sun.netstorage.array.mgmt.cfg.core.ini.Repository;
import com.sun.netstorage.array.mgmt.cfg.core.logic.SearchFilter;
import com.sun.netstorage.array.mgmt.cfg.jobs.business.JobInterface;
import com.sun.netstorage.array.mgmt.cfg.jobs.business.impl.mr3.JobManager;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageProfiles;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageT4sFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageT4sInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.RaidGroupInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageProfile;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageVolumeInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.T4Interface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.mr3.ManageRaidGroups;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.mr3.ManageStorageVolumes;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.mr3.StorageConfigurationServiceBuilder;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.mr3.Tray;
import com.sun.netstorage.array.mgmt.cfg.util.IPUtil;
import com.sun.netstorage.array.mgmt.cfg.util.ItemNotFoundException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import javax.wbem.cim.CIMArgument;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt16;
import javax.wbem.cim.UnsignedInt32;

public class RaidGroup
implements RaidGroupInterface {
    private static final String[] SLOT_PROP_LIST = new String[]{"Number", "Tag", "CreationClassName"};
    private ConfigContext context;
    private CIMOMHandleWrapper cimClient;
    private ArrayList volumes;
    private int raidLevel = -1;
    private BigInteger totalCapacity = null;
    private int numberOfDrives = -1;
    private BigInteger effectiveDiskSize = null;
    private String name;
    private String tee4Name;
    private String t4IpAddress;
    private T4Interface t4Interface;
    private CIMObjectPath t4CIMObjectPath;
    private String instanceId;
    private int numberOfHotSpare = -1;
    private int cimStatus;
    private String status;
    private String state;
    private CIMInstance raidGroupCimInstance;
    private CIMObjectPath raidGroupCimObjPath;
    private Collection mapElementList;
    private ArrayList storageExtCimObjPathList;
    private CIMObjectPath storageConfigServiceObjPath = null;
    private ArrayList diskNumberList = null;
    private int[] slotNumberArray = null;
    private int begDiskNum = 0;
    private int endDiskNum = 0;
    private boolean noSinglePointOfFailure;
    private int dataRedundancy = -1;
    private int spindleRedundancyMax = -1;
    private int spindleRedundancyMin = -1;
    private boolean areStorageCapPropertiesSet = false;
    private Double maxVolumeSizeAvailable;
    public static final String INIT_POOL_JOB_DESCR_PREFIX = "job.description.initializepool + ";
    private boolean profileNameVerified;
    private String profileName;
    private int trayIdInt;
    static /* synthetic */ Class class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$mr3$Tray;

    public RaidGroup() {
        Trace.constructor(this);
    }

    public void init(ConfigContext context) throws ConfigMgmtException {
        Trace.methodBegin(this, "init");
        this.context = context;
        this.cimClient = context.getClient();
        if (this.cimClient == null) {
            Trace.verbose((Object)this, "init", "Config context returned a NULL CIMOMHandleWrapperhandle in RaidGroup object!!!");
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "Null CIMOMHandleWrapper error.");
        }
    }

    public void reload() throws ConfigMgmtException {
        Trace.methodBegin(this, "reload");
        Trace.verbose((Object)this, "reload", "Resetting instance variables to initial state!!");
        this.volumes = null;
        this.raidLevel = -1;
        this.totalCapacity = null;
        this.maxVolumeSizeAvailable = null;
        this.numberOfDrives = -1;
        this.effectiveDiskSize = null;
        this.name = null;
        this.instanceId = null;
        this.trayIdInt = -1;
        this.numberOfHotSpare = -1;
        this.tee4Name = null;
        this.t4IpAddress = null;
        this.cimStatus = -1;
        this.status = null;
        this.state = null;
        this.storageConfigServiceObjPath = null;
        this.diskNumberList = null;
        this.slotNumberArray = null;
        this.begDiskNum = 0;
        this.endDiskNum = 0;
        this.noSinglePointOfFailure = false;
        this.dataRedundancy = -1;
        this.spindleRedundancyMax = -1;
        this.spindleRedundancyMin = -1;
        this.areStorageCapPropertiesSet = false;
        this.profileNameVerified = false;
        this.profileName = null;
        if (this.t4Interface != null) {
            this.t4Interface.reload();
        }
        this.reloadStoragePool();
    }

    public void changeStatus(String status) throws ConfigMgmtException {
        Trace.methodBegin(this, "changeStatus");
        Trace.verbose((Object)this, "changeStatus", "Status value to change into=" + status);
        this.status = status;
        boolean onliningPool = false;
        if (status.equals("online")) {
            this.cimStatus = 4;
            onliningPool = true;
        } else if (status.equals("offline")) {
            this.cimStatus = 15;
        } else {
            throw new ConfigMgmtException("incorrect.method.parameter", "Inappropriate status value.");
        }
        if (onliningPool) {
            boolean profileExists = true;
            StorageProfile profile = null;
            boolean arrayTypeMatches = false;
            ManageStorageProfiles profileManager = ManageStorageProfiles.getInstance();
            try {
                profile = profileManager.getProfile(this.getProfileName());
            }
            catch (ItemNotFoundException infe) {
                profileExists = false;
            }
            if (profileExists) {
                int[] possibleArrayTypes = profileManager.getPossibleArrayTypesForArray(this.getT4Interface().getArrayConfigurationType());
                int profileArrayType = profile.getArrayType();
                for (int i = 0; i < possibleArrayTypes.length; ++i) {
                    if (profileArrayType != possibleArrayTypes[i]) continue;
                    arrayTypeMatches = true;
                    break;
                }
            }
            if (!profileExists || !arrayTypeMatches) {
                Trace.verbose((Object)this, "changeStatus", "Invoking getOrCreateMatchingProfile() and applyNewProfile() methods.");
                profile = profileManager.getOrCreateMatchingProfile(this.getRaidLevel(), this.getNumberOfDrives(), this.getUseHotSpare(), this.getT4Name(), this.context);
                this.applyNewProfile(profile, true);
            }
        }
        if (Trace.isTraceEnabled(this)) {
            Trace.verbose((Object)this, "changeStatus", "Calling CIMObjectWrapper to save new status: " + this.cimStatus);
            Trace.verbose((Object)this, "changeStatus", "StoragePool CIMInstance is null: " + (this.raidGroupCimInstance == null));
            Trace.verbose((Object)this, "changeStatus", "StoragePool CIMInstance is: " + this.raidGroupCimInstance);
        }
        CIMObjectWrapper.save(this, this.mapElementList, this.raidGroupCimInstance, this.cimClient);
        Trace.verbose((Object)this, "changeStatus", "Done changing status!!");
    }

    public void save() throws ConfigMgmtException {
        Trace.methodBegin(this, "save");
    }

    public MethodCallStatus delete() throws ConfigMgmtException {
        Trace.methodBegin(this, "delete");
        MethodCallStatus methodCallStatus = new MethodCallStatus();
        ArrayList<JobInterface> theJobList = new ArrayList<JobInterface>();
        try {
            CIMObjectPath cimDeleteJob;
            if (this.storageConfigServiceObjPath == null) {
                Trace.verbose((Object)this, "delete", "storageConfigServiceObjPath is not loaded yet....");
                Trace.verbose((Object)this, "delete", "calling getStorageConfigServiceFromCIMOM() to get StorageConfigurationService  CIM Object Path!");
                this.storageConfigServiceObjPath = StorageConfigurationServiceBuilder.getInstance(this.cimClient, this.getT4CIMObjectPath());
            }
            CIMArgument[] cimInArguments = new CIMArgument[]{new CIMArgument("Pool", new CIMValue((Object)this.raidGroupCimInstance.getObjectPath())), new CIMArgument("Description", new CIMValue((Object)("job.description.deletepool + " + this.getName())))};
            CIMArgument[] cimOutArguments = new CIMArgument[]{new CIMArgument("Job", new CIMValue(null))};
            Trace.verbose((Object)this, "delete", "Calling invokeMethod() from CIM Client.....");
            CIMValue returnCodeValue = this.cimClient.invokeMethod(this.storageConfigServiceObjPath, "DeleteStoragePool", cimInArguments, cimOutArguments);
            Trace.verbose((Object)this, "delete", "DeleteStoragePool() return code value from CIMOM: " + returnCodeValue);
            int cimReturnCode = ((UnsignedInt32)returnCodeValue.getValue()).intValue();
            Trace.verbose((Object)this, "delete", "DeleteStoragePool() return code from CIMOM: " + cimReturnCode);
            if (cimReturnCode != 0 && cimReturnCode != 4096) {
                Trace.verbose((Object)this, "delete", "CIM return code indicates either failure or other unknown values: this is considered as an Error!!");
                throw new ConfigMgmtException("POOL_DELETE_ERROR", "An error occurred while deleting a StoragePool. CIM returned either a failure or unknown code: " + cimReturnCode);
            }
            Trace.verbose((Object)this, "delete", "CIM return code indicates either success and done, a job to be created, or a job has started: all these are considered Success!!");
            Trace.verbose((Object)this, "delete", "Delete Job has finished: " + (cimReturnCode == 0));
            methodCallStatus.setReturnCode(0);
            if (cimOutArguments.length > 0 && cimOutArguments[0] != null && cimOutArguments[0].getValue() != null && (cimDeleteJob = (CIMObjectPath)cimOutArguments[0].getValue().getValue()) != null) {
                Trace.verbose((Object)this, "delete", "CIM_ConcreteJob is NOT null: getting JobManager to create Java Job object...");
                JobManager jobManager = new JobManager();
                jobManager.init(this.context, null);
                JobInterface deleteJob = jobManager.get(cimDeleteJob, this.tee4Name);
                theJobList.add(deleteJob);
            }
            Trace.verbose((Object)this, "delete", "Number of Job objects in Job array list: " + theJobList.size());
            methodCallStatus.setJobs(theJobList);
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "delete", "Failed: " + cme.getMessage());
            cme.setExceptionKey("POOL_DELETE_ERROR");
            throw cme;
        }
        return methodCallStatus;
    }

    public String getT4Name() {
        Trace.methodBegin(this, "getT4Name");
        if (this.tee4Name == null) {
            this.tee4Name = IPUtil.lookUpHostName(this.t4IpAddress);
        }
        return this.tee4Name;
    }

    public String getT4IpAddress() {
        return this.t4IpAddress;
    }

    public CIMObjectPath getT4CIMObjectPath() throws ConfigMgmtException {
        Trace.methodBegin(this, "getT4CIMObjectPath");
        if (this.t4CIMObjectPath == null) {
            this.findT4FromCIMOM();
        }
        return this.t4CIMObjectPath;
    }

    public T4Interface getT4Interface() throws ConfigMgmtException {
        Trace.methodBegin(this, "getT4Interface");
        if (this.t4Interface == null) {
            this.findT4FromCIMOM();
        }
        return this.t4Interface;
    }

    public int getRaidLevel() throws ConfigMgmtException, NoSuchRaidLevelException, ZeroCIMInstanceReturnedException {
        Trace.methodBegin(this, "getRaidLevel");
        if (this.raidLevel == -1) {
            Trace.verbose((Object)this, "getRaidLevel", "Raid level is not cached...need to get it from CIMOM!!");
            if (!this.areStorageCapPropertiesSet) {
                Trace.verbose((Object)this, "getRaidLevel", "StorageCapabilities properties are NOT loaded yet...");
                Trace.verbose((Object)this, "getRaidLevel", "calling loadStorageCapabilitiesProp() to get them.... ");
                this.loadStorageCapabilitiesProp();
            }
            this.determineRaidLevel();
            Trace.verbose((Object)this, "getRaidLevel", "raidLevel in getRaidLevel() = " + this.raidLevel);
        }
        return this.raidLevel;
    }

    public BigInteger getTotalCapacity() {
        Trace.methodBegin(this, "getTotalCapacity");
        return this.totalCapacity;
    }

    public BigInteger getAvailableCapacity() throws ConfigMgmtException {
        Trace.methodBegin(this, "getAvailableCapacity");
        if (this.maxVolumeSizeAvailable != null) {
            BigDecimal availableCapacity = new BigDecimal(this.maxVolumeSizeAvailable.toString());
            availableCapacity = availableCapacity.multiply(new BigDecimal(new Integer(0x100000).toString()));
            if (Trace.isTraceEnabled(this)) {
                Trace.verbose((Object)this, "getAvailableCapacity", "Available capacity is: " + availableCapacity.toBigInteger());
            }
            return availableCapacity.toBigInteger();
        }
        return null;
    }

    public int getNumberOfDrives() throws ConfigMgmtException, ZeroCIMInstanceReturnedException {
        Trace.methodBegin(this, "getNumberOfDrives");
        if (this.numberOfDrives == -1) {
            Trace.verbose((Object)this, "getNumberOfDrives", "number of drives has not yet found: calling findAllDrivesInRaidGroup() to find all the drives!!");
            this.findAllDrivesInRaidGroup();
        }
        return this.numberOfDrives;
    }

    public String getName() {
        Trace.methodBegin(this, "getName");
        return this.name;
    }

    public String getInstanceId() {
        Trace.methodBegin(this, "getInstanceId");
        return this.instanceId;
    }

    public int getUseHotSpare() throws ConfigMgmtException {
        Trace.methodBegin(this, "getUseHotSpare");
        if (this.numberOfHotSpare == -1) {
            Trace.verbose((Object)this, "getUseHotSpare", "useHotSpare property has not been set yet!!");
            if (this.raidLevel == -1) {
                Trace.verbose((Object)this, "getUseHotSpare", "RAID level for this RAID group has not been set yet!!");
                Trace.verbose((Object)this, "getUseHotSpare", "Calling getRaidLevel() to set the RAID level!!");
                this.getRaidLevel();
            }
            if (this.raidLevel == 1 || this.raidLevel == 5) {
                Trace.verbose((Object)this, "getUseHotSpare", "RAID level is either 1 or 5..need to check if spindleRedundancy is set!!");
                if (!this.areStorageCapPropertiesSet) {
                    Trace.verbose((Object)this, "getUseHotSpare", "StorageCapabilities properties are not loaded....load them now!!");
                    this.loadStorageCapabilitiesProp();
                }
                this.numberOfHotSpare = this.spindleRedundancyMin >= 2 ? 1 : 0;
                Trace.verbose((Object)this, "getUseHotSpare", "number of hot spare? " + this.numberOfHotSpare);
            } else {
                Trace.verbose((Object)this, "getUseHotSpare", "RAID level is NOT 1 or 5: number of hot spare is 0");
                this.numberOfHotSpare = 0;
            }
        }
        return this.numberOfHotSpare;
    }

    public String getStatus() {
        return this.status;
    }

    public String getState() {
        return this.validateStateValue(this.state);
    }

    private String validateStateValue(String state) {
        String tmpState = "Unknown";
        if (state != null && state.trim().length() != 0) {
            if (state.equals("verifying") || state.equals("initializing") || state.equals("reconstructing") || state.equals("reconstructingToStandby") || state.equals("copyingFromStandby") || state.equals("copyingToStandby")) {
                tmpState = state;
            }
        } else if (this.status != null) {
            if (this.status.equals("uninitialized")) {
                tmpState = "ReadyToInitialize";
            } else if (this.status.equals("online")) {
                tmpState = "Ready";
            } else if (this.status.equals("offline")) {
                tmpState = "Idle";
            }
        }
        return tmpState;
    }

    public int getCimStatus() {
        Trace.methodBegin(this, "getCimStatus");
        Trace.verbose((Object)this, "getOtherStatusDesc", "CIM status =" + this.cimStatus);
        return this.cimStatus;
    }

    public int getBeginDiskNumber() throws ConfigMgmtException {
        Trace.methodBegin("this", "getBeginDiskNumber");
        if (this.begDiskNum == 0) {
            if (this.slotNumberArray != null) {
                this.determineBeginAndEndDisks();
            } else {
                Trace.verbose((Object)this, "getBeginDiskNumber", "beg disk num is not set......set it now!");
                Trace.verbose((Object)this, "getBeginDiskNumber", "calling loadDiskNumber() to check if disk number for this raid groups had been loaded!!");
                this.loadDiskNumber();
                if (this.diskNumberList.size() > 0) {
                    this.begDiskNum = (Integer)this.diskNumberList.get(0);
                }
            }
        }
        Trace.verbose((Object)this, "getBeginDiskNumber", "Begin disk number of the Raid Group: " + this.begDiskNum);
        return this.begDiskNum;
    }

    public int getEndDiskNumber() throws ConfigMgmtException {
        Trace.methodBegin("this", "getEndDiskNumber");
        if (this.endDiskNum == 0) {
            if (this.slotNumberArray != null) {
                this.determineBeginAndEndDisks();
            } else {
                Trace.verbose((Object)this, "getEndDiskNumber", "end disk num is not set......set it now!");
                Trace.verbose((Object)this, "getEndDiskNumber", "calling loadDiskNumber() to check if disk number for this raid groups had been loaded!!");
                this.loadDiskNumber();
                if (this.diskNumberList.size() > 0) {
                    if ((Integer)this.diskNumberList.get(this.diskNumberList.size() - 1) == 14 && this.getUseHotSpare() > 0) {
                        Trace.verbose((Object)this, "getEndDiskNumber", "Hot spare is used!!");
                        this.endDiskNum = (Integer)this.diskNumberList.get(this.diskNumberList.size() - 2);
                    } else {
                        Trace.verbose((Object)this, "getEndDiskNumber", "Hot spare is not used!!");
                        this.endDiskNum = (Integer)this.diskNumberList.get(this.diskNumberList.size() - 1);
                    }
                }
            }
        }
        Trace.verbose((Object)this, "getEndDiskNumber", "End disk number of the Raid Group: " + this.endDiskNum);
        return this.endDiskNum;
    }

    public synchronized List getVolumes() throws ConfigMgmtException {
        Trace.methodBegin(this, "getVolumes");
        if (this.volumes == null) {
            Trace.verbose((Object)this, "getVolumes", "Volumes list is not loaded yet....calling findVolumes() to load it");
            this.findVolumes();
        }
        Trace.verbose((Object)this, "getVolumes", "done getting Volumes in RaidGroup: number of volumes in this raid group: " + this.volumes.size());
        for (int i = 0; i < this.volumes.size(); ++i) {
            Trace.verbose((Object)this, "getVolumes", "Volumes " + i + ": name = " + ((StorageVolumeInterface)this.volumes.get(i)).getName());
        }
        return (List)this.volumes.clone();
    }

    public CIMInstance getInstance() {
        Trace.methodBegin(this, "getInstance");
        return this.raidGroupCimInstance;
    }

    public BigInteger getEffectiveDiskSize() throws ConfigMgmtException {
        String methodName = "getEffectiveDiskSize";
        Trace.methodBegin(this, methodName);
        if (this.effectiveDiskSize == null) {
            this.calculateEffectiveDiskSize(this.getTotalCapacity(), this.getNumberOfDrives(), this.getRaidLevel());
        }
        return this.effectiveDiskSize;
    }

    private void calculateEffectiveDiskSize(BigInteger totalCapacity, int numberOfDrives, int raidLevel) throws ConfigMgmtException {
        Trace.methodBegin(this, "calculateEffectiveDiskSize");
        if (raidLevel == 5) {
            this.effectiveDiskSize = totalCapacity.divide(new BigInteger("" + (numberOfDrives - 1)));
        } else if (raidLevel == 1) {
            this.effectiveDiskSize = totalCapacity.divide(new BigInteger("" + numberOfDrives)).multiply(new BigInteger("2"));
        } else if (raidLevel == 0) {
            this.effectiveDiskSize = totalCapacity.divide(new BigInteger("" + numberOfDrives));
        } else {
            throw new NoSuchRaidLevelException("NO_SUCH_RAID_LEVEL", "RAID level " + raidLevel + " is not valid.");
        }
        Trace.verbose((Object)this, "calculateEffectiveDiskSize", "Calculated effective disk size is: " + this.effectiveDiskSize);
    }

    public String getProfileName() throws ConfigMgmtException {
        String methodName = "getProfileName";
        Trace.methodBegin(this, methodName);
        if (!this.areStorageCapPropertiesSet) {
            this.loadStorageCapabilitiesProp();
        }
        if (!this.profileNameVerified) {
            this.verifyProfileName();
        }
        return this.profileName;
    }

    private void verifyProfileName() throws ConfigMgmtException {
        block3: {
            String methodName = "verifyProfileName";
            Trace.methodBegin(this, methodName);
            Repository rep = Repository.getRepository();
            if (rep.getConfigInteger() == 4 || rep.getConfigInteger() == 5) {
                Trace.verbose((Object)this, methodName, "No validation performed since in ENT environment.");
                return;
            }
            ManageStorageProfiles profileManager = ManageStorageProfiles.getInstance();
            try {
                profileManager.getProfile(this.profileName);
                Trace.verbose((Object)this, methodName, "Persisted profile " + this.profileName + " exists.");
            }
            catch (ItemNotFoundException infe) {
                StorageProfile newProfile = profileManager.getOrCreateMatchingProfile(this.getRaidLevel(), this.getNumberOfDrives(), this.getUseHotSpare() > 0 ? 1 : 0, this.getT4Name(), this.context);
                this.profileName = newProfile.getName();
                Trace.verbose((Object)this, methodName, "Matching profile found is: " + this.profileName);
                if (!"storage".equals(this.context.getUser())) break block3;
                this.applyNewProfile(newProfile, true);
                this.areStorageCapPropertiesSet = false;
            }
        }
    }

    public String getTrayId() {
        return this.getTrayIdInt() + "";
    }

    public int getTrayIdInt() {
        return this.trayIdInt;
    }

    public void setNumberOfDrives(int numberOfDrives) {
        Trace.methodBegin(this, "setNumberOfDrives");
        this.numberOfDrives = numberOfDrives;
    }

    public void setTotalCapacity(BigInteger totalCapacity) {
        Trace.methodBegin(this, "setTotalCapacity");
        BigInteger oneMB = BigInteger.valueOf(0x100000L);
        this.totalCapacity = totalCapacity.multiply(oneMB);
    }

    public void setName(String name) {
        Trace.methodBegin(this, "setName");
        this.name = name;
    }

    public void setInstanceId(String instanceId) {
        Trace.methodBegin(this, "setInstanceId");
        this.instanceId = instanceId;
    }

    public void setCimStatus(int cimStatus) {
        Trace.methodBegin(this, "setCimStatus");
        Trace.verbose((Object)this, "setCimStatus", "OperationalStatus returned from CIM: " + cimStatus);
        this.cimStatus = cimStatus;
    }

    public void setCIMInstance(CIMInstance raidGroupCimInstance) {
        Trace.methodBegin(this, "setCIMInstance");
        this.raidGroupCimInstance = raidGroupCimInstance;
        this.raidGroupCimObjPath = raidGroupCimInstance.getObjectPath();
    }

    public void setMaxVolumeSizeAvailable(Double maxVolumeSizeAvailable) {
        this.maxVolumeSizeAvailable = maxVolumeSizeAvailable;
    }

    public void setMapElementList(ArrayList mapElementList) {
        Trace.methodBegin(this, "setMapElementList");
        this.mapElementList = mapElementList;
    }

    public void setT4CIMObjectPath(CIMObjectPath t4CIMObjectPath) {
        Trace.methodBegin(this, "setT4CIMObjectPath");
        this.t4CIMObjectPath = t4CIMObjectPath;
    }

    public void setT4Interface(T4Interface t4Interface) {
        this.t4Interface = t4Interface;
    }

    public void setTrayIdInt(int trayIdInt) {
        this.trayIdInt = trayIdInt;
    }

    public void setT4IpAddress(String t4IpAddress) {
        this.t4IpAddress = t4IpAddress;
    }

    public void setStatus(String status) {
        this.status = this.validateStatusValue(status);
    }

    private String validateStatusValue(String status) {
        String tmpStatus = "Unknown";
        if (status != null) {
            if (status.equals("uninitialized")) {
                tmpStatus = status;
            } else if (status.equals("mounted")) {
                tmpStatus = "online";
            } else if (status.equals("unmounted")) {
                tmpStatus = "offline";
            }
        }
        return tmpStatus;
    }

    public void setState(String state) {
        this.state = state;
    }

    public void addDiskNumber(int diskNumber) {
        Trace.methodBegin(this, "addDiskNumber");
        if (this.slotNumberArray == null) {
            Trace.verbose((Object)this, "addDiskNumber", "slotNumberArray is null: instantiate one!!");
            this.slotNumberArray = new int[14];
        }
        this.slotNumberArray[diskNumber - 1] = diskNumber;
    }

    private void loadDiskNumber() throws ConfigMgmtException {
        Trace.methodBegin(this, "loadDiskNumber");
        if (this.diskNumberList == null) {
            Trace.verbose((Object)this, "loadDiskNumber", "diskNumberList is null....need to check slotNumberArray!");
            if (this.slotNumberArray == null) {
                Trace.verbose((Object)this, "loadDiskNumber", "slotNumberArray is also null....no disk number data has been loaded into RaidGroupcalling findAllDriveNumberFromCIMOM() to load them!");
                this.findAllDriveNumberFromCIMOM();
            } else {
                Trace.verbose((Object)this, "loadDiskNumber", "slotNumberArray contains disk number data...load diskNumber data to diskNumberList!");
                this.diskNumberList = new ArrayList();
                for (int i = 0; i < this.slotNumberArray.length; ++i) {
                    if (this.slotNumberArray[i] == 0) continue;
                    Trace.verbose((Object)this, "loadDiskNumber", "Loading disk number " + this.slotNumberArray[i] + " into diskNumberList!");
                    this.diskNumberList.add(new Integer(this.slotNumberArray[i]));
                }
            }
        } else {
            Trace.verbose((Object)this, "loadDiskNumber", "diskNumberList is already loaded with diskNumber data!");
        }
    }

    private void reloadStoragePool() throws ConfigMgmtException {
        Trace.methodBegin(this, "reloadStoragePool");
        try {
            Trace.verbose((Object)this, "reloadStoragePool", "Getting a new StoragePool CIMInstance!!");
            CIMInstance newRaidGroupCimInstance = this.cimClient.getInstance(this.raidGroupCimObjPath, false, true, false, ManageRaidGroups.STORAGE_POOL_PROP_LIST);
            Trace.verbose((Object)this, "reloadStoragePool", "Setting properties from new StoragePool CIMInstance to this RaidGroup object using CIMObjectWrapper.poplate()");
            CIMObjectWrapper.populate(this, this.mapElementList, newRaidGroupCimInstance);
            this.raidGroupCimInstance = newRaidGroupCimInstance;
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "reloadStoragePool", "Failed: " + cme.getMessage());
            throw cme;
        }
    }

    private void findVolumes() throws ConfigMgmtException {
        Trace.methodBegin(this, "findVolumes");
        this.volumes = new ArrayList();
        Trace.verbose((Object)this, "findVolumes", "Getting Volumes Manager from same package for Volumes!!");
        ManageStorageVolumes manageStorageVols = new ManageStorageVolumes();
        manageStorageVols.setScope(this);
        manageStorageVols.init(this.context, null);
        this.volumes = (ArrayList)manageStorageVols.getItemList();
        Trace.verbose((Object)this, "findVolumes", "done getting Volumes in RaidGroup: number of volumes in this raid group: " + this.volumes.size());
        for (int i = 0; i < this.volumes.size(); ++i) {
            Trace.verbose((Object)this, "findVolumes", "Volumes " + i + ": name = " + ((StorageVolumeInterface)this.volumes.get(i)).getName());
        }
    }

    private void findAllDriveNumberFromCIMOM() throws ConfigMgmtException {
        Trace.methodBegin(this, "findAllDriveNumberFromCIMOM");
        if (this.storageExtCimObjPathList == null) {
            Trace.verbose((Object)this, "findAllDriveNumberFromCIMOM", "Calling findAllDrivesInRaidGroup() to get all StorageExtent associated with the RaidGroup!");
            this.findAllDrivesInRaidGroup();
        }
        if (this.slotNumberArray == null) {
            Trace.verbose((Object)this, "findAllDriveNumberFromCIMOM", "slotNumberArray is null: instantiate one!!");
            this.slotNumberArray = new int[14];
        }
        boolean okay = true;
        boolean slotCount = false;
        boolean phyPackCount = false;
        boolean diskDriveCount = false;
        boolean storageVolCount = false;
        String problemObject = "";
        try {
            Trace.verbose((Object)this, "findAllDriveNumberFromCIMOM", "Now....start walking from StorageExtent to Slot to get slot numbers for all drives in RaidGroup!");
            for (int extentIndex = 0; extentIndex < this.storageExtCimObjPathList.size(); ++extentIndex) {
                CIMObjectPath storageExtentObjPath = (CIMObjectPath)this.storageExtCimObjPathList.get(extentIndex);
                CIMObjectPath spindleStorVolObjPath = this.walkToSpindleStorageVolume(storageExtentObjPath);
                CIMObjectPath diskDriveObjPath = this.walkToDiskDrive(spindleStorVolObjPath);
                CIMObjectPath phyPackageObjPath = this.walkToPhysicalPackage(diskDriveObjPath);
                CIMInstance slotCIMInstance = this.walkToSlot(phyPackageObjPath);
                int slotNumber = ((UnsignedInt16)slotCIMInstance.getProperty("Number").getValue().getValue()).intValue();
                Trace.verbose((Object)this, "findAllDriveNumberFromCIMOM", "Found Slot number!! Slot (disk) number: " + slotNumber);
                this.slotNumberArray[slotNumber - 1] = slotNumber;
            }
            if (this.diskNumberList == null) {
                this.diskNumberList = new ArrayList();
            }
            Trace.verbose((Object)this, "findAllDriveNumberFromCIMOM", "All the drives are located from StoragePool to Slot...now load all disk numbers into a list!!");
            for (int i = 0; i < this.slotNumberArray.length; ++i) {
                if (this.slotNumberArray[i] == 0) continue;
                this.diskNumberList.add(new Integer(this.slotNumberArray[i]));
            }
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "findAllDriveNumberFromCIMOM", "Failed: " + cme.getMessage());
            throw cme;
        }
    }

    private CIMInstance walkToSlot(CIMObjectPath phyPackageObjPath) throws ConfigMgmtException, ZeroCIMInstanceReturnedException, TooManyCIMInstanceException {
        Trace.verbose((Object)this, "findAllDriveNumberFromCIMOM", "Getting Slot Enumeration!!");
        Enumeration enumSlot = this.cimClient.associators(phyPackageObjPath, "SunStorEdge_6120PackageInSlot", "SunStorEdge_6120Slot", "Dependent", "Antecedent", true, true, SLOT_PROP_LIST);
        CIMInstance slotCIMInstance = CIMObjectWrapper.singleInstance(enumSlot, "Slot");
        Trace.verbose((Object)this, "findAllDriveNumberFromCIMOM", "enumSlot is null? " + (enumSlot == null));
        return slotCIMInstance;
    }

    private CIMObjectPath walkToPhysicalPackage(CIMObjectPath diskDriveObjPath) throws ConfigMgmtException, ZeroCIMInstanceReturnedException, TooManyCIMInstanceException {
        Trace.verbose((Object)this, "findAllDriveNumberFromCIMOM", "Getting PhysicalPackage Enumeration!!");
        Enumeration enumPhyPackage = this.cimClient.associatorNames(diskDriveObjPath, "SunStorEdge_6120Realizes", "SunStorEdge_6120PhysicalPackage", "Dependent", "Antecedent");
        CIMObjectPath phyPackageObjPath = CIMObjectWrapper.singleInstanceOfPath(enumPhyPackage, "PhysicalPackage");
        Trace.verbose((Object)this, "findAllDriveNumberFromCIMOM", "enumPhyPackage is null? " + (enumPhyPackage == null));
        return phyPackageObjPath;
    }

    private CIMObjectPath walkToDiskDrive(CIMObjectPath spindleStorVolObjPath) throws ConfigMgmtException, ZeroCIMInstanceReturnedException, TooManyCIMInstanceException {
        Trace.verbose((Object)this, "findAllDriveNumberFromCIMOM", "Getting DiskDrive!!");
        Enumeration enumDiskDrive = this.cimClient.associatorNames(spindleStorVolObjPath, "SunStorEdge_6120MediaPresent", "SunStorEdge_6120DiskDrive", "Dependent", "Antecedent");
        CIMObjectPath diskDriveObjPath = CIMObjectWrapper.singleInstanceOfPath(enumDiskDrive, "DiskDrive");
        Trace.verbose((Object)this, "findAllDriveNumberFromCIMOM", "enumDiskDrive is null? " + (enumDiskDrive == null));
        return diskDriveObjPath;
    }

    private CIMObjectPath walkToSpindleStorageVolume(CIMObjectPath storageExtentObjPath) throws ConfigMgmtException, ZeroCIMInstanceReturnedException, TooManyCIMInstanceException {
        Trace.verbose((Object)this, "findAllDriveNumberFromCIMOM", "Getting StorageVolume Enumeration!!");
        Enumeration enumStorageVol = this.cimClient.associatorNames(storageExtentObjPath, "SunStorEdge_6120BasedOn", "SunStorEdge_6120SpindleStorageVolume", "Antecedent", "Dependent");
        CIMObjectPath storageVolCIMObjPath = CIMObjectWrapper.singleInstanceOfPath(enumStorageVol, "SpindleStorageVolume");
        Trace.verbose((Object)this, "findAllDriveNumberFromCIMOM", "enumStorageVol is null? " + (enumStorageVol == null));
        return storageVolCIMObjPath;
    }

    private void findAllDrivesInRaidGroup() throws ConfigMgmtException {
        Trace.methodBegin(this, "findAllDrivesInRaidGroup");
        int numOfStorageExtent = 0;
        this.storageExtCimObjPathList = new ArrayList();
        try {
            Enumeration enumStorageExt = this.cimClient.associatorNames(this.raidGroupCimObjPath, "SunStorEdge_6120ExtentConcreteComponent", "SunStorEdge_6120StorageExtent", "GroupComponent", "PartComponent");
            Trace.verbose((Object)this, "findAllDrivesInRaidGroup", "enumStorageExt is null? " + (enumStorageExt == null));
            int i = 1;
            while (enumStorageExt.hasMoreElements()) {
                this.storageExtCimObjPathList.add(enumStorageExt.nextElement());
                ++numOfStorageExtent;
                ++i;
            }
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "findAllDrivesInRaidGroup", "Failed: " + cme.getMessage());
            throw cme;
        }
        Trace.verbose((Object)this, "findAllDrivesInRaidGroup", "number of StorageExtent found: " + numOfStorageExtent);
        this.numberOfDrives = numOfStorageExtent;
    }

    private void findT4FromCIMOM() throws ConfigMgmtException {
        String methodName = "findT4FromCIMOM";
        Trace.methodBegin(this, methodName);
        SearchFilter t4Filter = new SearchFilter("Name", this.getT4Name());
        ManageT4sInterface mT4s = ManageT4sFactory.getManager();
        mT4s.init(this.context, t4Filter);
        ArrayList t4s = (ArrayList)mT4s.getItemList();
        if (t4s.size() != 1) {
            Trace.verbose((Object)this, methodName, "ManageT4s returned zero or more then one element.");
            if (t4s.isEmpty()) {
                throw new ConfigMgmtException("ZERO_CIM_INSTANCE_RETURNED", "ManageT4s did not return any instances.");
            }
            throw new ConfigMgmtException("TOOMANY_CIM_INSTANCE_RETURNED", "ManageT4s returned more than one instance.");
        }
        T4Interface t4 = (T4Interface)t4s.get(0);
        this.setT4Interface(t4);
        this.setT4CIMObjectPath(t4.getInstance().getObjectPath());
        Trace.verbose((Object)this, methodName, "t4CIMObjectPath = " + this.t4CIMObjectPath);
    }

    private void loadStorageCapabilitiesProp() throws ConfigMgmtException, ZeroCIMInstanceReturnedException, TooManyCIMInstanceException {
        Trace.methodBegin(this, "loadStorageCapabilitiesProp");
        try {
            CIMInstance cimStorageCap;
            String[] storageCapPropList = new String[]{"NoSinglePointOfFailure", "DataRedundancyMax", "PackageRedundancyMax", "Description", "PackageRedundancyMin", "PackageRedundancyDefault"};
            Trace.verbose((Object)this, "loadStorageCapabilitiesProp", "walking the association to from StoragePool to StorageCapabilities");
            Enumeration enumStorageCap = this.cimClient.associators(this.raidGroupCimObjPath, "SunStorEdge_6120PoolElementCapabilities", "SunStorEdge_6120PoolStorageCapabilities", "ManagedElement", "Capabilities", true, true, storageCapPropList);
            Trace.verbose((Object)this, "loadStorageCapabilitiesProp", "enumStorageCap is null: " + (enumStorageCap == null));
            if (enumStorageCap.hasMoreElements()) {
                Trace.verbose((Object)this, "loadStorageCapabilitiesProp", "StorageCapabilities enum has elements......");
                cimStorageCap = (CIMInstance)enumStorageCap.nextElement();
                this.noSinglePointOfFailure = (Boolean)cimStorageCap.getProperty("NoSinglePointOfFailure").getValue().getValue();
                Trace.verbose((Object)this, "loadStorageCapabilitiesProp", "noSinglePointOfFailure = " + this.noSinglePointOfFailure);
                this.dataRedundancy = ((UnsignedInt16)cimStorageCap.getProperty("DataRedundancyMax").getValue().getValue()).intValue();
                Trace.verbose((Object)this, "loadStorageCapabilitiesProp", "dataRedundancyMax = " + this.dataRedundancy);
                UnsignedInt16 spindleRedundancyMaxValue = (UnsignedInt16)cimStorageCap.getProperty("PackageRedundancyMax").getValue().getValue();
                if (spindleRedundancyMaxValue != null) {
                    this.spindleRedundancyMax = spindleRedundancyMaxValue.intValue();
                    this.spindleRedundancyMin = ((UnsignedInt16)cimStorageCap.getProperty("PackageRedundancyMin").getValue().getValue()).intValue();
                    Trace.verbose((Object)this, "loadStorageCapabilitiesProp", "Firmware version 3.1 and up - spindleRedundancyMin = " + this.spindleRedundancyMin + " and spindleRedundancyMax = " + this.spindleRedundancyMax);
                } else {
                    this.spindleRedundancyMax = this.spindleRedundancyMin = ((UnsignedInt16)cimStorageCap.getProperty("PackageRedundancyDefault").getValue().getValue()).intValue();
                    Trace.verbose((Object)this, "loadStorageCapabilitiesProp", "Firmware version below 3.1 - spindleRedundancyMin = spindleRedundancyMax = " + this.spindleRedundancyMin);
                }
            } else {
                Trace.verbose((Object)this, "loadStorageCapabilitiesProp", "Zero StorageCapabilities CIM object from association call!");
                throw new ZeroCIMInstanceReturnedException("ZERO_CIM_INSTANCE_RETURNED", "An exception occurred while getting properties to determine Raid Group RAID level and use hot spare.");
            }
            this.profileName = (String)cimStorageCap.getProperty("Description").getValue().getValue();
            Trace.verbose((Object)this, "loadStorageCapabilitiesProp", "profileName = " + this.profileName);
            this.areStorageCapPropertiesSet = true;
            if (enumStorageCap.hasMoreElements()) {
                Trace.verbose((Object)this, "loadStorageCapabilitiesProp", "Too many StorageCapabilities CIM objects returned from association call when only expecting one!!!");
                throw new TooManyCIMInstanceException("TOOMANY_CIM_INSTANCE_RETURNED", "An exception occurred while getting properties to determine Raid Group RAID level and use hot spare.");
            }
        }
        catch (NullPointerException npe) {
            Trace.verbose((Object)this, "Null value returned while loading PoolStorageCapabilities properties.", (Throwable)npe);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "Null value returned error.", npe);
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "loadStorageCapabilitiesProp", "Failed: " + cme.getMessage());
            throw cme;
        }
    }

    private void determineRaidLevel() throws NoSuchRaidLevelException {
        Trace.methodBegin(this, "determineRaidLevel");
        Trace.verbose((Object)this, "determineRaidLevel", "going through criteria to determine RAID level finally.....");
        if (!this.noSinglePointOfFailure && this.dataRedundancy == 1 && this.spindleRedundancyMax == 0) {
            this.raidLevel = 0;
        } else if (this.noSinglePointOfFailure && this.dataRedundancy == 2 && this.spindleRedundancyMax >= 1) {
            this.raidLevel = 1;
        } else if (this.noSinglePointOfFailure && this.dataRedundancy == 1 && this.spindleRedundancyMax >= 1) {
            this.raidLevel = 5;
        } else {
            Trace.verbose((Object)this, "determineRaidLevel", "RAID level cannot be determined!");
            Trace.verbose((Object)this, "determineRaidLevel", "noSinglePointOfFailure: " + this.noSinglePointOfFailure);
            Trace.verbose((Object)this, "determineRaidLevel", "dataRedundancy:" + this.dataRedundancy);
            Trace.verbose((Object)this, "determineRaidLevel", "spindleRedundancyMax: " + this.spindleRedundancyMax);
            throw new NoSuchRaidLevelException("NO_SUCH_RAID_LEVEL", "RAID level cannot be determined based on the given parameters.");
        }
        Trace.verbose((Object)this, "determineRaidLevel", "Raid Level is: " + this.raidLevel);
    }

    public MethodCallStatus initialize() throws ConfigMgmtException {
        String methodName = "initialize";
        Trace.methodBegin(this, methodName);
        try {
            InvocationHelper helper = new InvocationHelper();
            MethodCallStatus methodCallStatus = new MethodCallStatus();
            CIMArgument[] inArgs = this.buildInArgsForInitialize(this.getName(), this.raidGroupCimObjPath);
            CIMArgument[] outArgs = new CIMArgument[]{new CIMArgument("Job", new CIMValue(null))};
            CIMObjectPath confServiceObjectPath = StorageConfigurationServiceBuilder.getInstance(this.cimClient, this.getT4CIMObjectPath());
            Trace.verbose((Object)this, methodName, "Configuration service object path is: " + confServiceObjectPath);
            ArrayList jobLinks = new ArrayList();
            Trace.verbose((Object)this, methodName, "Input parameters for invoke method initialized.");
            helper.invoke(null, this.context, methodCallStatus, inArgs, outArgs, confServiceObjectPath, "InitializeStoragePool", jobLinks);
            Trace.verbose((Object)this, methodName, "Came back from invoke() method with return code: " + methodCallStatus.getReturnCode());
            return methodCallStatus;
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, methodName, "Failed: " + cme.getMessage());
            cme.setExceptionKey("POOL_INITIALIZE_ERROR");
            throw cme;
        }
    }

    private CIMArgument[] buildInArgsForInitialize(String poolName, CIMObjectPath poolObjectPath) {
        Trace.methodBegin(this, "buildInArgsForInitialize");
        CIMArgument[] cimInArgs = new CIMArgument[]{new CIMArgument("Pool", new CIMValue((Object)poolObjectPath)), new CIMArgument("JobDescription", new CIMValue((Object)(INIT_POOL_JOB_DESCR_PREFIX + poolName)))};
        return cimInArgs;
    }

    public void applyNewProfile(StorageProfile newProfile, boolean profileNameOnly) throws ConfigMgmtException {
        String methodName = "applyNewProfile";
        Trace.methodBegin(this, methodName);
        if (newProfile == null) {
            ConfigMgmtException cme = new ConfigMgmtException("NULL_VALUE_RETURNED", "Null value passed for storage profile.");
            Trace.verbose((Object)this, methodName, "Null value passed for storage profile.");
            throw cme;
        }
        Trace.verbose((Object)this, methodName, "Applying profile " + newProfile.getName() + " to pool " + this.getName());
        if (!profileNameOnly && !this.getT4Interface().isFeatureSupported(4)) {
            profileNameOnly = true;
        }
        CIMObjectPath storageSettingPath = null;
        storageSettingPath = profileNameOnly ? this.getStorageSettingObjectPath(newProfile.getName(), this.cimClient) : Tray.getStorageSettingObjectPath(newProfile.getRaidLevel(), newProfile.getDedicatedHotSpare() == 1, newProfile.getName(), this.cimClient);
        this.persistProfileChanges(storageSettingPath);
        if (profileNameOnly) {
            this.profileName = newProfile.getName();
        } else {
            this.reload();
        }
    }

    private void persistProfileChanges(CIMObjectPath storageSettingPath) throws ConfigMgmtException {
        String methodName = "persistProfileChanges";
        Trace.methodBegin(this, methodName);
        CIMArgument[] outArgs = new CIMArgument[]{new CIMArgument("Job", new CIMValue(null)), new CIMArgument("Size", new CIMValue(null)), new CIMArgument("Pool")};
        CIMArgument[] inArgs = new CIMArgument[]{new CIMArgument("InstanceName", new CIMValue((Object)this.getName())), new CIMArgument("Goal", new CIMValue((Object)storageSettingPath)), new CIMArgument("Size", new CIMValue(null)), new CIMArgument("InPool", new CIMValue(null)), new CIMArgument("InExtents", new CIMValue(null)), new CIMArgument("Pool", new CIMValue((Object)this.raidGroupCimInstance.getObjectPath()))};
        if (this.storageConfigServiceObjPath == null) {
            Trace.verbose((Object)this, methodName, "storageConfigServiceObjPath is not loaded yet....");
            Trace.verbose((Object)this, methodName, "calling getStorageConfigServiceFromCIMOM() to get StorageConfigurationService  CIM Object Path!");
            this.storageConfigServiceObjPath = StorageConfigurationServiceBuilder.getInstance(this.cimClient, this.getT4CIMObjectPath());
        }
        CIMValue returnValue = this.cimClient.invokeMethod(this.storageConfigServiceObjPath, "CreateOrModifyStoragePool", inArgs, outArgs);
        int result = ((UnsignedInt32)returnValue.getValue()).intValue();
        Trace.verbose((Object)this, methodName, "Extrinsic method invoked with the result: " + result);
        if (result != 0) {
            ConfigMgmtException cme = new ConfigMgmtException("EXTRINSIC_CIM_METHOD_EXCEPTION", "Error return code <" + result + ">" + "when trying to persist profile name.");
            Trace.error((Object)this, cme);
            throw cme;
        }
    }

    private CIMObjectPath getStorageSettingObjectPath(String profileName, CIMOMHandleWrapper handle) throws ConfigMgmtException {
        String methodName = "getStorageSettingObjectPath";
        Trace.methodBegin(this, methodName);
        CIMObjectPath cop = new CIMObjectPath("SunStorEdge_6120StorageSetting");
        CIMClass proto = handle.getClass(cop, false, true, false, null);
        CIMInstance setting = proto.newInstance();
        try {
            setting.setProperty("Description", new CIMValue((Object)profileName));
        }
        catch (CIMException ce) {
            Trace.verbose((Object)this, "getStorageSettingObjectPath", "Set Property Failed.");
            throw new ConfigMgmtException("CIM_SET_PROPERTY_FAILED", "Set Property Failed.", (Exception)((Object)ce));
        }
        CIMObjectPath settingPath = this.cimClient.createInstance(new CIMObjectPath("SunStorEdge_6120SystemSetting"), setting);
        Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$mr3$Tray == null ? (class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$mr3$Tray = RaidGroup.class$("com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.mr3.Tray")) : class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$mr3$Tray, methodName, "Created PoolStorageSetting path is:" + settingPath);
        return settingPath;
    }

    private void determineBeginAndEndDisks() {
        int begin = 0;
        int end = 0;
        if (this.slotNumberArray != null) {
            for (int i = 0; i < this.slotNumberArray.length; ++i) {
                if (this.slotNumberArray[i] == 0) continue;
                if (begin == 0 || begin > this.slotNumberArray[i]) {
                    begin = this.slotNumberArray[i];
                }
                if (end != 0 && end >= this.slotNumberArray[i]) continue;
                end = this.slotNumberArray[i];
            }
            this.begDiskNum = begin;
            this.endDiskNum = end;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

