/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.mr3;

import com.sun.netstorage.array.mgmt.cfg.core.CIMOMHandleWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.MethodCallStatus;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.BadParameterException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.impl.CIMObjectWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.impl.mr3.InvocationHelper;
import com.sun.netstorage.array.mgmt.cfg.core.logic.SearchFilter;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.MirrorComponentInterface;
import com.sun.netstorage.array.mgmt.cfg.dataservices.business.MirroredVolumeInterface;
import com.sun.netstorage.array.mgmt.cfg.jobs.business.impl.mr3.Job;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.InstanceWrapper;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageRaidGroupsFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageRaidGroupsInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageVolumesInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageT4sFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageT4sInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.RaidGroupInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StoragePoolInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageVolumeInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.T4Interface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.VDiskInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.mr3.CreateStorageVolumeCompletion;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.mr3.RaidGroup;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.mr3.StorageConfigurationServiceBuilder;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.mr3.StorageVolume;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.mr3.T4;
import com.sun.netstorage.array.mgmt.cfg.util.ItemNotFoundException;
import java.math.BigInteger;
import java.text.CollationKey;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.wbem.cim.CIMArgument;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt16;
import javax.wbem.cim.UnsignedInt64;

public class ManageStorageVolumes
implements ManageStorageVolumesInterface {
    private ConfigContext context;
    private CIMOMHandleWrapper handle;
    private SearchFilter filter;
    private InstanceWrapper scope;
    private int restriction = -1;
    private ArrayList volumes;

    public void init(ConfigContext context, SearchFilter filter) throws ConfigMgmtException {
        Trace.methodBegin(this, "init");
        this.context = context;
        this.filter = filter;
        this.handle = context.getClient();
        if (this.handle == null) {
            Trace.verbose((Object)this, "init", "CIMOMHandleWrapper object is null.");
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "CIMOMHandleWrapper object is null.");
        }
        this.volumes = new ArrayList();
        Enumeration enumeration = null;
        boolean setRaidGroupPropsInVolume = false;
        List<InstanceWrapper> raidGroups = new ArrayList<InstanceWrapper>();
        try {
            if (this.scope != null) {
                Trace.verbose((Object)this, "init", "The scope is: " + this.scope);
                if (this.scope instanceof T4) {
                    enumeration = this.allVolumesPerT4(((T4)this.scope).getClusterName());
                    if (enumeration.hasMoreElements()) {
                        raidGroups = ((T4)this.scope).getRaidGroups();
                        setRaidGroupPropsInVolume = true;
                    }
                } else if (this.scope instanceof RaidGroup) {
                    enumeration = this.allVolumesPerPool();
                    if (enumeration.hasMoreElements()) {
                        raidGroups.add(this.scope);
                        setRaidGroupPropsInVolume = true;
                    }
                } else {
                    Trace.verbose((Object)this, "init", "Wrong scope set: " + this.scope);
                    new ConfigMgmtException("error.scope.required", "Wrong scope set: " + this.scope);
                }
            } else {
                enumeration = this.allVolumes();
            }
            if (enumeration != null) {
                HashSet<String> devIdsFirstTime = new HashSet<String>();
                HashSet<String> devIdsMoreThanOnce = new HashSet<String>();
                if (this.restriction == 0) {
                    Trace.verbose((Object)this, "init", "Doing exec query.");
                    String query = "Select * from SunStorEdge_6120MappedProtocolControllerForUnit";
                    if (this.scope != null && this.scope instanceof T4) {
                        query = query + " where SystemName= '" + ((T4)this.scope).getClusterName() + "'";
                    }
                    Enumeration eq = CIMObjectWrapper.execQuery(this.handle, query);
                    Pattern regex = Pattern.compile("\\bDeviceID=\\\\?\"(\\w+)\\\\?\"");
                    while (eq != null && eq.hasMoreElements()) {
                        try {
                            CIMInstance ci = (CIMInstance)eq.nextElement();
                            if (ci == null) {
                                Trace.verbose((Object)this, "init", "Found null MappedSCSILUN.");
                                continue;
                            }
                            CIMObjectPath p = (CIMObjectPath)ci.getProperty("Dependent").getValue().getValue();
                            String rep = p.toString();
                            Trace.verbose((Object)this, "init", "Examining object path for DeviceID: " + rep);
                            Matcher match = regex.matcher(rep);
                            if (match.find()) {
                                if (match.groupCount() > 0) {
                                    String devId = match.group(1);
                                    if (devIdsFirstTime.contains(devId)) {
                                        devIdsMoreThanOnce.add(devId);
                                        Trace.verbose((Object)this, "init", "adding for subsequent time: " + devId);
                                        continue;
                                    }
                                    devIdsFirstTime.add(devId);
                                    Trace.verbose((Object)this, "init", "adding for first time: " + devId);
                                    continue;
                                }
                                Trace.verbose((Object)this, "init", "Unable to find group DeviceID value in: " + rep);
                                continue;
                            }
                            Trace.verbose((Object)this, "init", "Unable to find DeviceID value in: " + rep);
                        }
                        catch (Exception e) {
                            Trace.verbose((Object)this, "init", (Throwable)e);
                        }
                    }
                }
                while (enumeration.hasMoreElements()) {
                    CIMInstance ci = (CIMInstance)enumeration.nextElement();
                    Trace.verbose((Object)this, "init", "The instance we've got: " + ci.getObjectPath());
                    if (filter != null && !filter.isEmpty() && !filter.passesFilter(ci)) continue;
                    StorageVolume sv = new StorageVolume();
                    sv.setInstance(ci);
                    sv.init(context);
                    CIMObjectWrapper.populate(sv, sv.getFieldMap(), ci);
                    if (this.restriction != 0 || !devIdsMoreThanOnce.contains(sv.getDeviceID())) {
                        if (setRaidGroupPropsInVolume) {
                            this.setRaidGroupPropsInVolume(sv, raidGroups);
                        }
                        this.volumes.add(sv);
                        Trace.verbose((Object)this, "init", "The StorageVolume added to the list: " + sv);
                        continue;
                    }
                    if (!Trace.isTraceEnabled(this)) continue;
                    Trace.verbose((Object)this, "init", "StorageVolume failed restriction: " + sv.getName());
                }
                Trace.verbose((Object)this, "init", "Performing sort");
                Collections.sort(this.volumes, new VolumeComparator(context.getLocale()));
            } else {
                Trace.verbose((Object)this, "init", "No instance returned when trying to obtain the list of StorageVolumes");
            }
        }
        catch (NullPointerException npe) {
            Trace.verbose((Object)this, "init", "NullPointerException - Null returned when trying to obtain all the StorageVolume instances.");
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "NullPointerException - Problems getting all the StorageVolume instances.", npe);
        }
    }

    private Enumeration allVolumesPerT4(String ipAddr) throws ConfigMgmtException {
        Trace.methodBegin(this, "allVolumesPerT4");
        try {
            Trace.verbose((Object)this, "allVolumesPerT4", "The scope is T4.");
            Enumeration enumeration = CIMObjectWrapper.execQuery(this.handle, "select * from SunStorEdge_6120StorageVolume where SystemName = '" + ipAddr + "'");
            return enumeration;
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "allVolumesPerT4", "Failed: " + cme.getMessage());
            throw cme;
        }
    }

    private Enumeration allVolumesPerPool() throws ConfigMgmtException {
        Trace.methodBegin(this, "allVolumesPerPool");
        try {
            Trace.verbose((Object)this, "allVolumesPerPool", "The scope is StoragePool.");
            Enumeration enumeration = this.handle.associators(this.scope.getInstance().getObjectPath(), "SunStorEdge_6120AllocatedFromStoragePool", "SunStorEdge_6120StorageVolume", "Antecedent", "Dependent", true, false, StorageVolume.PROPERTY_NAMES);
            return enumeration;
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "allVolumesPerPool", "Failed: " + cme.getMessage());
            throw cme;
        }
    }

    private Enumeration allVolumes() throws ConfigMgmtException {
        Trace.methodBegin(this, "allVolumes");
        try {
            Enumeration enumeration = this.handle.enumerateInstances(new CIMObjectPath("SunStorEdge_6120StorageVolume"), false, false, true, false, StorageVolume.PROPERTY_NAMES);
            Trace.verbose((Object)this, "allVolumes", "Came back from enumerating all StorageVolume instances.");
            return enumeration;
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "allVolumes", "Failed: " + cme.getMessage());
            throw cme;
        }
    }

    private void setRaidGroupPropsInVolume(StorageVolume sv, List raidGroups) throws ConfigMgmtException {
        String methodName = "setRaidGroupPropsInVolume";
        Trace.methodBegin(this, methodName);
        Iterator iter = raidGroups.iterator();
        while (iter.hasNext()) {
            RaidGroup raidGroup = (RaidGroup)iter.next();
            if (!sv.getRaidGroupName().equals(raidGroup.getName())) continue;
            sv.setProfileName(raidGroup.getProfileName());
            sv.setTrayId(raidGroup.getTrayId());
            sv.setStatus(raidGroup.getStatus());
            return;
        }
        Trace.verbose((Object)this, methodName, "Not able to find a pool for the volume: " + sv.getName());
    }

    public List getItemList() throws ConfigMgmtException {
        Trace.methodBegin(this, "getItemList");
        return this.volumes;
    }

    public ArrayList getItemsBySystem() throws ConfigMgmtException {
        Trace.methodBegin(this, "getItemsBySystem");
        return this.volumes;
    }

    public void setScope(InstanceWrapper scope) {
        Trace.methodBegin(this, "setScope");
        this.scope = scope;
    }

    public MethodCallStatus createVolume(String name, String t4Name, String raidGroupName, BigInteger size, String volumePermissions, int lun, String volumeGroup) throws ConfigMgmtException {
        Trace.methodBegin(this, "createVolume");
        try {
            SearchFilter t4Filter = new SearchFilter("Name", t4Name);
            ManageT4sInterface mT4s = ManageT4sFactory.getManager();
            mT4s.init(this.context, t4Filter);
            ArrayList t4s = (ArrayList)mT4s.getItemList();
            if (t4s.size() == 1) {
                T4Interface t4 = (T4Interface)t4s.get(0);
                Trace.verbose((Object)this, "createVolume", "We got T4 object.");
                SearchFilter rgFilter = new SearchFilter("ElementName", raidGroupName);
                ManageRaidGroupsInterface manageRaidGroups = ManageRaidGroupsFactory.getManager();
                manageRaidGroups.setScope(t4);
                manageRaidGroups.init(this.context, rgFilter);
                ArrayList raidGroups = (ArrayList)manageRaidGroups.getItemList();
                if (raidGroups.size() == 1) {
                    RaidGroupInterface raidGroup = (RaidGroupInterface)raidGroups.get(0);
                    Trace.verbose((Object)this, "createVolume", "We got RaidGroup object.");
                    MethodCallStatus mcs = this.createVolume(name, t4, raidGroup, size, volumePermissions, lun, volumeGroup);
                    return mcs;
                }
                Trace.verbose((Object)this, "createVolume", "ManageRaidGroups returned zero or more then one element.");
                if (raidGroups.isEmpty()) {
                    throw new ConfigMgmtException("ZERO_CIM_INSTANCE_RETURNED", "ManageRaidGroups did not return any instances.");
                }
                throw new ConfigMgmtException("TOOMANY_CIM_INSTANCE_RETURNED", "ManageRaidGroups returned more than one instance.");
            }
            Trace.verbose((Object)this, "createVolume", "ManageT4s returned zero or more then one element.");
            if (t4s.isEmpty()) {
                throw new ConfigMgmtException("ZERO_CIM_INSTANCE_RETURNED", "ManageT4s did not return any instances.");
            }
            throw new ConfigMgmtException("TOOMANY_CIM_INSTANCE_RETURNED", "ManageT4s returned more than one instance.");
        }
        catch (NullPointerException npe) {
            Trace.verbose((Object)this, "createVolume", "NullPointerException - Null returned when trying to create the StorageVolume.");
            throw new ConfigMgmtException("VOLUME_CREATE_ERROR", "Problems creating the StorageVolume.", npe);
        }
    }

    public MethodCallStatus createVolume(String name, T4Interface t4, RaidGroupInterface raidGroup, BigInteger size, String volumePermissions, int lun, String volumeGroup) throws ConfigMgmtException {
        Trace.methodBegin(this, "createVolume");
        Trace.verbose((Object)this, "createVolume", "In params: lun: " + lun + " volPermissions: " + volumePermissions);
        if (t4.getHealthStatus() == 3 || t4.getHealthStatus() == 6) {
            String message = "Health status of T4 is: " + t4.getHealthStatus();
            Trace.verbose((Object)this, "createVolume", message);
            new ConfigMgmtException("VOLUME_CREATE_ERROR_DEGRADED", message);
        }
        try {
            InvocationHelper helper = new InvocationHelper();
            MethodCallStatus methodCallStatus = new MethodCallStatus();
            CreateStorageVolumeCompletion volumeCompletion = null;
            if (volumeGroup != null && volumeGroup.trim().length() > 0) {
                volumeCompletion = new CreateStorageVolumeCompletion(name, t4.getName(), raidGroup.getName(), volumeGroup);
                methodCallStatus.addTaskToList(volumeCompletion);
            }
            CIMArgument[] inArgs = this.getInArgs(name, raidGroup, size, lun, volumePermissions);
            CIMArgument[] outArgs = new CIMArgument[]{new CIMArgument("Job", new CIMValue(null)), new CIMArgument("Size", new CIMValue(null)), new CIMArgument("TheElement", new CIMValue(null))};
            CIMObjectPath confServiceObjectPath = StorageConfigurationServiceBuilder.getInstance(this.handle, t4.getInstance().getObjectPath());
            Trace.verbose((Object)this, "createVolume", "Configuration service object path is: " + confServiceObjectPath);
            ArrayList jobLinks = new ArrayList();
            Trace.verbose((Object)this, "createVolume", "Input parameters for invoke method initialized.");
            helper.invoke(volumeCompletion, this.context, methodCallStatus, inArgs, outArgs, confServiceObjectPath, "CreateMappedElementFromStoragePool", jobLinks);
            Trace.verbose((Object)this, "createVolume", "Came back from invoke() method with return code: " + methodCallStatus.getReturnCode());
            return methodCallStatus;
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "createVolume", "Failed: " + cme.getMessage());
            cme.setExceptionKey("VOLUME_CREATE_ERROR");
            throw cme;
        }
    }

    public int[] getAvailableLUNNumbers(T4Interface t4) throws ConfigMgmtException {
        Trace.methodBegin(this, "getAvailableLUNNumbers");
        HashSet<String> takenLuns = new HashSet<String>();
        try {
            if (t4 != null) {
                Trace.verbose((Object)this, "getAvailableLUNNumbers", "T4 instance passed not null.");
                Enumeration volEnum = CIMObjectWrapper.execQuery(this.handle, "Select * from SunStorEdge_6120StorageVolume where SystemName = '" + t4.getClusterName() + "'");
                if (volEnum != null) {
                    Trace.verbose((Object)this, "getAvailableLUNNumbers", "Came back from enumerating MAPPEDSCSILUNs");
                    while (volEnum.hasMoreElements()) {
                        CIMInstance luni = (CIMInstance)volEnum.nextElement();
                        String lun = (String)luni.getProperty("DeviceNumber").getValue().getValue();
                        takenLuns.add(lun);
                        Trace.verbose((Object)this, "getAvailableLUNNumbers", "LUN taken: " + lun);
                    }
                }
            } else {
                Trace.verbose((Object)this, "getAvailableLUNNumbers", "T4 or T4 instance passed is null.");
                throw new ConfigMgmtException("NULL_VALUE_RETURNED", "T4 or T4 instance passed is null in getAvailableLUNNumbers method.");
            }
            HashSet requestedLuns = this.getRequestedLUNsForT4(this.context, t4.getClusterName());
            int maxVolumes = t4.getMaxNumberOfVolumes();
            Vector<String> freeLunsVector = new Vector<String>();
            for (int i = 0; i < maxVolumes; ++i) {
                String iVal = new String(i + "");
                if (!takenLuns.contains(iVal) && !requestedLuns.contains(iVal)) {
                    freeLunsVector.add(iVal);
                    Trace.verbose((Object)this, "getAvailableLUNNumbers", "Free LUN number added: " + i);
                    continue;
                }
                if (!Trace.isTraceEnabled(this)) continue;
                Trace.verbose((Object)this, "getAvailableLUNNumbers", "LUN: " + i + " is taken.");
                if (!requestedLuns.contains(iVal)) continue;
                Trace.verbose((Object)this, "getAvailableLUNNumbers", "LUN is actually on request.");
            }
            int[] freeLunsArray = new int[freeLunsVector.size()];
            for (int i = 0; i < freeLunsVector.size(); ++i) {
                freeLunsArray[i] = Integer.parseInt((String)freeLunsVector.get(i), 10);
            }
            return freeLunsArray;
        }
        catch (NumberFormatException nfe) {
            Trace.verbose((Object)this, "getAvailableLUNNumbers", (Throwable)nfe);
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "Problems getting the lun numbers (parseInt method failed).", nfe);
        }
        catch (NullPointerException npe) {
            Trace.verbose((Object)this, "getAvailableLUNNumbers", "NullPointerException - Null returned when trying to get all available LUN numbers.");
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "Problems getting all available LUN numbers.", npe);
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "getAvailableLUNNumber", "Failed: " + cme.getMessage());
            throw cme;
        }
    }

    private CIMArgument[] getInArgs(String name, RaidGroupInterface raidGroup, BigInteger size, int lun, String volPermissions) {
        Trace.methodBegin(this, "getInArgs");
        CIMArgument[] inArgs = new CIMArgument[9];
        int argCount = 0;
        inArgs[argCount++] = new CIMArgument("InstanceName", new CIMValue((Object)name));
        inArgs[argCount++] = new CIMArgument("ElementType", new CIMValue((Object)new UnsignedInt16(2)));
        inArgs[argCount++] = new CIMArgument("Goal", new CIMValue(null));
        inArgs[argCount++] = new CIMArgument("Size", new CIMValue((Object)new UnsignedInt64(size)));
        inArgs[argCount++] = new CIMArgument("InPool", new CIMValue((Object)raidGroup.getInstance().getObjectPath()));
        inArgs[argCount++] = new CIMArgument("TheElement", new CIMValue(null));
        inArgs[argCount++] = new CIMArgument("Description", new CIMValue((Object)("job.description.createvolume + " + name)));
        inArgs[argCount++] = lun > 0 ? new CIMArgument("DeviceNumber", new CIMValue((Object)new UnsignedInt16(lun))) : new CIMArgument("DeviceNumber", new CIMValue(null));
        int iVolPerm = this.mapPerToInt(volPermissions);
        inArgs[argCount++] = new CIMArgument("AccessMode", new CIMValue((Object)new UnsignedInt16(iVolPerm)));
        return inArgs;
    }

    public VolumeComparator getVolumeComparator(Locale l) {
        return new VolumeComparator(l);
    }

    private HashSet getRequestedLUNsForT4(ConfigContext context, String ipAddr) throws ConfigMgmtException {
        Trace.methodBegin(this, "getRequestedLUNsForT4");
        HashSet<String> luns = new HashSet<String>();
        Enumeration jobs = CIMObjectWrapper.execQuery(context.getClient(), "Select * from SunStorEdge_6120CreateMappedStorageVolumeJob where SystemName = '" + ipAddr + "'");
        while (jobs.hasMoreElements()) {
            CIMInstance ci = (CIMInstance)jobs.nextElement();
            Job j = new Job(ci, context, ipAddr);
            if (!j.isActive()) continue;
            CIMProperty lun = ci.getProperty("DeviceNumber");
            if (lun != null && lun.getValue() != null && lun.getValue().getValue() != null) {
                luns.add("" + ((UnsignedInt16)lun.getValue().getValue()).intValue());
                continue;
            }
            if (!Trace.isTraceEnabled(this)) continue;
            Trace.verbose((Object)this, "getRequestedLUNsForT4", "Found null LUN for object path: " + ci.getObjectPath());
        }
        if (Trace.isTraceEnabled(this)) {
            Trace.verbose((Object)this, "getRequestedLUNsForT4", "Have requested LUNs size of: " + luns.size());
        }
        return luns;
    }

    private int mapPerToInt(String permissions) {
        int i = -1;
        if (permissions.equalsIgnoreCase("None")) {
            i = 2;
        } else if (permissions.equals("Read/Write")) {
            i = 3;
        } else if (permissions.equals("Read-only")) {
            i = 4;
        } else if (permissions.equals("ro")) {
            i = 4;
        } else if (permissions.equals("rw")) {
            i = 3;
        }
        return i;
    }

    public void setRestriction(int restriction) {
        Trace.methodBegin(this, "setRestriction");
        this.restriction = restriction;
    }

    public ArrayList getItemsByStorageDomain(String name) throws ConfigMgmtException {
        return null;
    }

    public ArrayList getItemsByStoragePool(String poolName, String domainName) throws ConfigMgmtException, ItemNotFoundException {
        return null;
    }

    public ArrayList getItemsByStorageProfile(String name) throws ConfigMgmtException, ItemNotFoundException {
        return null;
    }

    public ArrayList getItemsByVDisk(String name) throws ConfigMgmtException, ItemNotFoundException {
        return null;
    }

    public ArrayList getItemsByArray(String arrayName) throws ConfigMgmtException, ItemNotFoundException {
        return null;
    }

    public ArrayList getItemsByTray(String arrayName, String trayId) throws ConfigMgmtException, ItemNotFoundException {
        return null;
    }

    public ArrayList getItemsByDisk(String arrayName, String trayId, int diskId) throws ConfigMgmtException, ItemNotFoundException {
        return null;
    }

    public StorageVolumeInterface getItemByName(String volName, String poolName, String domainName) throws ConfigMgmtException, ItemNotFoundException {
        return null;
    }

    public StorageVolumeInterface getItemByName(String name) throws ConfigMgmtException {
        return null;
    }

    public StorageVolumeInterface getByKey(Collection key) throws ConfigMgmtException {
        return null;
    }

    public String getNextAvailableName() throws ConfigMgmtException {
        return null;
    }

    public MethodCallStatus createStorageVolume(String name, String description, int snapNum, int snapChange, BigInteger size, String storagePoolName, String storageDomainName) throws ConfigMgmtException {
        return null;
    }

    public MethodCallStatus createStorageVolume(String name, String description, int snapNum, int snapChange, BigInteger size, String storagePoolName, String storageDomainName, boolean stripeAll) throws ConfigMgmtException, BadParameterException, ItemNotFoundException {
        return null;
    }

    public MethodCallStatus delete(Collection key) throws ConfigMgmtException {
        return null;
    }

    public void validateName(String name) throws ConfigMgmtException, BadParameterException {
    }

    public void validateDescription(String description) throws BadParameterException {
    }

    public ArrayList getMirroredItemsByStorageDomain(String name) throws ConfigMgmtException, ItemNotFoundException {
        return new ArrayList();
    }

    public ArrayList getMirroredItemsBySystem() throws ConfigMgmtException {
        return null;
    }

    public MirroredVolumeInterface getMirroredItemByName(String mirrorName, String domainName) throws ConfigMgmtException, ItemNotFoundException {
        return null;
    }

    public MirrorComponentInterface getMirrorComponentByName(String mirrorComponentName, String domainName) throws ConfigMgmtException, ItemNotFoundException {
        return null;
    }

    public MirroredVolumeInterface getMirrorByKey(Collection key) throws ConfigMgmtException {
        return null;
    }

    public MirrorComponentInterface getMirrorComponentByKey(Collection key) throws ConfigMgmtException {
        return null;
    }

    public MethodCallStatus createMirror(String description, Vector sourceComponents, int snapNum, int snapChange, int snapComponent, int resilverPriority, Vector logStoragePools) throws ConfigMgmtException, BadParameterException, ItemNotFoundException {
        return null;
    }

    public MethodCallStatus createMirror(String name, String description, int snapNum, int snapChange, BigInteger size, String storagePoolName, String storageDomainName, int numComponents, int resilverPriority) throws ConfigMgmtException, BadParameterException, ItemNotFoundException {
        return null;
    }

    public MethodCallStatus createVLV(String name, VDiskInterface vdisk, String storagePoolName, String storageDomainName) throws ConfigMgmtException, BadParameterException, ItemNotFoundException {
        return null;
    }

    public ArrayList getItemsByStoragePool(StoragePoolInterface pool) throws ConfigMgmtException {
        return null;
    }

    public class VolumeComparator
    implements Comparator {
        Collator collator = null;

        public VolumeComparator(Locale loc) {
            this.collator = loc != null ? Collator.getInstance(loc) : Collator.getInstance();
        }

        public int compare(Object element1, Object element2) {
            CollationKey key1 = null;
            CollationKey key2 = null;
            if (element1 instanceof StorageVolume && element2 instanceof StorageVolume) {
                key1 = this.collator.getCollationKey(((StorageVolume)element1).getName());
                key2 = this.collator.getCollationKey(((StorageVolume)element2).getName());
            } else {
                key1 = this.collator.getCollationKey(element1.toString());
                key2 = this.collator.getCollationKey(element2.toString());
            }
            return key1.compareTo(key2);
        }
    }
}

