/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.mr3;

import com.sun.netstorage.array.mgmt.cfg.core.CIMOMHandleWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.CoreManagedObjectInterface;
import com.sun.netstorage.array.mgmt.cfg.core.MethodCallStatus;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.impl.CIMObjectWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.impl.mr3.InvocationHelper;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.DiskInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageDisksFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageDisksInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageTraysFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageTraysInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.T4Interface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.TrayInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.mr3.StorageConfigurationServiceBuilder;
import com.sun.netstorage.array.mgmt.logger.LogAPI;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.wbem.cim.CIMArgument;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMValue;

class ManageArraySpares {
    private static final int MAX_POOL_SIZE = 8;
    private static final int SLOT_1 = 1;
    private T4Interface _t4 = null;
    private ConfigContext _context = null;
    private CIMOMHandleWrapper _cimClient = null;
    private CIMObjectPath _t4CimObjectPath = null;
    private ManageDisksInterface _mdisks = null;
    private List _disks = null;
    private ManageTraysInterface _mtrays = null;
    private List _trays = null;
    private List _ahsPool = null;
    private int _maxPoolSize = -1;
    private List _newAhsPool = null;

    ManageArraySpares() {
    }

    public void init(ConfigContext context, T4Interface t4) throws ConfigMgmtException {
        String methodName = "init";
        Trace.methodBegin(this, "init");
        this._t4 = t4;
        this._context = context;
        this._cimClient = context.getClient();
        if (this._mdisks == null) {
            this._mdisks = ManageDisksFactory.getManager();
            this._mdisks.setScope(t4);
            this._mdisks.init(context, null);
        }
        this._disks = this._mdisks.getItemList();
        this._ahsPool = new ArrayList();
        this._maxPoolSize = 0;
        for (int i = 0; i < this._disks.size(); ++i) {
            DiskInterface next = (DiskInterface)this._disks.get(i);
            String role = next.getRole();
            if (role.equals("unassigned")) {
                if (next.getSlotNumber() == 1) continue;
                ++this._maxPoolSize;
                continue;
            }
            if (!role.equals("globalStandbyDisk")) continue;
            this._ahsPool.add(next);
            ++this._maxPoolSize;
        }
        if (this._maxPoolSize > 8) {
            this._maxPoolSize = 8;
        }
    }

    public int getMaxAhsPoolSizeAllowed() {
        return this._maxPoolSize;
    }

    public int getAhsPoolSize() {
        String methodName = "getAhsPoolSize";
        Trace.methodBegin(this, "getAhsPoolSize");
        if (this._newAhsPool != null) {
            return this._newAhsPool.size();
        }
        return this._ahsPool.size();
    }

    public MethodCallStatus save() throws ConfigMgmtException {
        String methodName = "save";
        Trace.methodBegin(this, methodName);
        MethodCallStatus methodCallStatus = new MethodCallStatus();
        if (this._newAhsPool == null || this._newAhsPool.size() == this._ahsPool.size()) {
            Trace.verbose((Object)this, methodName, "no change in size, done");
            methodCallStatus.setReturnCode(0);
            return methodCallStatus;
        }
        String[] logargs = new String[]{this._t4.getName()};
        try {
            InvocationHelper helper = new InvocationHelper();
            Vector<CIMObjectPath> storageExtVector = new Vector<CIMObjectPath>();
            for (int i = 0; i < this._newAhsPool.size(); ++i) {
                DiskInterface disk = (DiskInterface)this._newAhsPool.get(i);
                if (Trace.isTraceEnabled(this)) {
                    Trace.verbose((Object)this, "save", "Disk to add to ahs:" + disk.getStorageExtentObjectPath());
                }
                storageExtVector.add(disk.getStorageExtentObjectPath());
            }
            CIMArgument[] inArgs = this.buildInArgsForInitialize(this.getSparedSetCimObjPath(), storageExtVector);
            CIMArgument[] outArgs = new CIMArgument[]{new CIMArgument("Job", new CIMValue(null)), new CIMArgument("SparedSet", new CIMValue(null))};
            if (this._t4CimObjectPath == null) {
                Trace.verbose((Object)this, methodName, "T4 CIM object path needed to get StorageConfigurationService but not cached yet.");
                this._t4CimObjectPath = this._t4.getInstance().getObjectPath();
            }
            CIMObjectPath confServiceObjectPath = StorageConfigurationServiceBuilder.getInstance(this._cimClient, this._t4CimObjectPath);
            Trace.verbose((Object)this, methodName, "Configuration service object path is: " + confServiceObjectPath);
            ArrayList jobLinks = new ArrayList();
            Trace.verbose((Object)this, methodName, "Input parameters for invoke method initialized.");
            helper.invoke(null, this._context, methodCallStatus, inArgs, outArgs, confServiceObjectPath, "CreateOrModifyArraySparedSet", jobLinks);
            Trace.verbose((Object)this, methodName, "Came back from invoke() method with return code: " + methodCallStatus.getReturnCode());
            LogAPI.staticLog((String)"ARRAY_SPARE_CHANGE", (String[])logargs, (String[])new String[0]);
            this._mdisks = null;
            this._mtrays = null;
            this.init(this._context, this._t4);
            return methodCallStatus;
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, methodName, "Failed: " + cme.getMessage());
            LogAPI.staticLog((String)"ARRAY_SPARE_CHANGE_ERROR", (String[])logargs, (String[])new String[0]);
            cme.setExceptionKey("AHS_SAVE_FAILURE");
            throw cme;
        }
    }

    public List setAhsPoolSize(int newAhsPoolSize) throws ConfigMgmtException {
        String methodName = "setAhsPoolSize";
        Trace.methodBegin(this, "setAhsPoolSize");
        if (newAhsPoolSize == this._ahsPool.size()) {
            Trace.verbose((Object)this, "setAhsPoolSize", "new size = old size");
            return this._ahsPool;
        }
        if (newAhsPoolSize > 8) {
            throw new ConfigMgmtException("MAX_AHS_DISK_FAILURE", "requested ahs pool size exceeds max: 8");
        }
        if (this._mtrays == null) {
            this._mtrays = ManageTraysFactory.getManager();
            this._mtrays.setScope(this._t4);
            this._mtrays.init(this._context, null);
        }
        this._trays = this._mtrays.getItemList();
        this._newAhsPool = new ArrayList();
        this._newAhsPool.addAll(this._ahsPool);
        if (newAhsPoolSize > this._ahsPool.size()) {
            this.addAhsDrives(newAhsPoolSize);
        } else {
            this.removeAhsDrives(newAhsPoolSize);
        }
        return this._newAhsPool;
    }

    public List removeAllAhsDrivesOnTray(int trayId) throws ConfigMgmtException {
        String methodName = "removeAllAhsDrivesOnTray";
        Trace.methodBegin(this, "removeAllAhsDrivesOnTray");
        if (this._ahsPool == null) {
            Trace.error((Object)this, "removeAllAhsDrivesOnTray", "ManageArraySpares not initialized");
            throw new ConfigMgmtException("NULL_VALUE_RETURNED", "ManageArraySpares not initialized.");
        }
        this._newAhsPool = new ArrayList();
        for (int i = 0; i < this._ahsPool.size(); ++i) {
            DiskInterface next = (DiskInterface)this._ahsPool.get(i);
            if (next.getTrayId() == trayId) continue;
            this._newAhsPool.add(next);
        }
        return this._newAhsPool;
    }

    private void addAhsDrives(int totalPoolSize) throws ConfigMgmtException {
        String methodName = "addAhsDrives";
        Trace.methodBegin(this, "addAhsDrives");
        ArrayList disksToAdd = new ArrayList();
        for (int currentSize = this._ahsPool.size(); totalPoolSize > currentSize; ++currentSize) {
            ArrayList<TrayInterface> minTrays = new ArrayList<TrayInterface>();
            ArrayList<TrayInterface> minControllerTrays = new ArrayList<TrayInterface>();
            int min = -1;
            for (int i = 0; i < this._trays.size(); ++i) {
                TrayInterface next = (TrayInterface)this._trays.get(i);
                Trace.verbose((Object)this, "addAhsDrives", "checking " + next.getId());
                int alreadyAdded = 0;
                Iterator iter = disksToAdd.iterator();
                while (iter.hasNext()) {
                    DiskInterface iterDisk = (DiskInterface)iter.next();
                    if (iterDisk.getTrayId() != Integer.parseInt(next.getId())) continue;
                    ++alreadyAdded;
                }
                if (!this.isTrayAvailableForAhsAdd(alreadyAdded, next)) {
                    Trace.verbose((Object)this, "addAhsDrives", "none available");
                    continue;
                }
                int numberOfAhs = next.getNumberOfDisksInRole("globalStandbyDisk");
                numberOfAhs += alreadyAdded;
                if (minTrays.size() == 0) {
                    minTrays.add(next);
                    min = numberOfAhs;
                    if (next.getTrayType() == 17) {
                        minControllerTrays.add(next);
                    }
                } else if (numberOfAhs < min) {
                    minTrays.clear();
                    minTrays.add(next);
                    min = numberOfAhs;
                    minControllerTrays.clear();
                    if (next.getTrayType() == 17) {
                        minControllerTrays.add(next);
                    }
                } else if (numberOfAhs == min) {
                    minTrays.add(next);
                    if (next.getTrayType() == 17) {
                        minControllerTrays.add(next);
                    }
                }
                Trace.verbose((Object)this, "addAhsDrives", "min: " + min);
            }
            if (minTrays.size() == 0) {
                Trace.verbose((Object)this, "addAhsDrives", "no room to add ahs drive");
                throw new ConfigMgmtException("ADD_AHS_DISK_FAILURE", "no free disks to add to ahs");
            }
            TrayInterface theTray = null;
            theTray = minControllerTrays.size() > 0 ? this.findSmallestTrayId(minControllerTrays) : this.findSmallestTrayId(minTrays);
            Trace.verbose((Object)this, "addAhsDrives", "got a tray: " + theTray.getId());
            this.addAhsToTray(theTray, disksToAdd);
        }
        this._newAhsPool.addAll(disksToAdd);
    }

    private void addAhsToTray(TrayInterface tray, List disksToAdd) throws ConfigMgmtException {
        String methodName = "addAhsToTray";
        Trace.methodBegin(this, "addAhsToTray");
        CoreManagedObjectInterface theDisk = null;
        int maxSlot = -1;
        List disks = tray.getDiskList();
        for (int i = 0; i < disks.size(); ++i) {
            DiskInterface next = (DiskInterface)disks.get(i);
            if (!next.getRole().equals("unassigned")) continue;
            Trace.verbose((Object)this, "addAhsToTray", "Found UNASSIGNED at " + next.getSlotNumber());
            boolean found = false;
            Iterator iter = disksToAdd.iterator();
            while (iter.hasNext()) {
                DiskInterface thisDisk = (DiskInterface)iter.next();
                if (thisDisk.getSlotNumber() != next.getSlotNumber() || thisDisk.getTrayId() != next.getTrayId()) continue;
                found = true;
            }
            if (found) continue;
            if (theDisk == null) {
                theDisk = next;
                maxSlot = theDisk.getSlotNumber();
                continue;
            }
            if (next.getSlotNumber() <= maxSlot) continue;
            theDisk = next;
            maxSlot = theDisk.getSlotNumber();
        }
        if (theDisk == null) {
            throw new ConfigMgmtException("ADD_AHS_DISK_FAILURE", "no free disks to add to ahs");
        }
        disksToAdd.add(theDisk);
        Trace.verbose((Object)this, "addAhsToTray", "Added AHS: " + theDisk.getName());
    }

    private void removeAhsFromTray(TrayInterface tray, List disksToRemove) throws ConfigMgmtException {
        String methodName = "removeAhsFromTray";
        Trace.methodBegin(this, "removeAhsFromTray");
        CoreManagedObjectInterface theDisk = null;
        int minSlot = -1;
        List disks = tray.getDiskList();
        for (int i = 0; i < disks.size(); ++i) {
            DiskInterface next = (DiskInterface)disks.get(i);
            if (!next.getRole().equals("globalStandbyDisk")) continue;
            boolean found = false;
            Iterator iter = disksToRemove.iterator();
            while (iter.hasNext()) {
                DiskInterface iterDisk = (DiskInterface)iter.next();
                if (iterDisk != next) continue;
                found = true;
            }
            if (found) continue;
            if (theDisk == null) {
                theDisk = next;
                minSlot = theDisk.getSlotNumber();
                continue;
            }
            if (next.getSlotNumber() >= minSlot) continue;
            theDisk = next;
            minSlot = theDisk.getSlotNumber();
        }
        if (theDisk == null) {
            throw new ConfigMgmtException("REMOVE_AHS_DISK_FAILURE", "no ahs disks to remove");
        }
        disksToRemove.add(theDisk);
        Trace.verbose((Object)this, "removeAhsFromTray", "Removed AHS: " + theDisk.getName());
    }

    private boolean isTrayAvailableForAhsAdd(int alreadyAdded, TrayInterface tray) throws ConfigMgmtException {
        String methodName = "isTrayAvailableForAhsAdd";
        Trace.methodBegin(this, "isTrayAvailableForAhsAdd");
        int unassigned = tray.getNumberOfDisksInRole("unassigned");
        Trace.verbose((Object)this, "isTrayAvailableForAhsAdd", "unassigned: " + (unassigned -= alreadyAdded));
        if (unassigned == 0) {
            return false;
        }
        if (unassigned > 1) {
            return true;
        }
        List disks = tray.getDiskList();
        for (int i = 0; i < disks.size(); ++i) {
            DiskInterface next = (DiskInterface)disks.get(i);
            if (next.getSlotNumber() != 1) continue;
            return !next.getRole().equals("unassigned");
        }
        Trace.verbose((Object)this, "isTrayAvailableForAhsAdd", "returning false by default");
        return false;
    }

    private TrayInterface findSmallestTrayId(List trayList) {
        String methodName = "findSmallestTrayId";
        Trace.methodBegin(this, "findSmallestTrayId");
        if (trayList.size() == 1) {
            Trace.verbose((Object)this, "findSmallestTrayId", "only one, done");
            return (TrayInterface)trayList.get(0);
        }
        String minTrayId = null;
        TrayInterface minTray = null;
        for (int j = 0; j < trayList.size(); ++j) {
            TrayInterface next = (TrayInterface)trayList.get(j);
            if (minTrayId == null) {
                minTrayId = next.getId();
                minTray = next;
            } else if (minTrayId.compareTo(next.getId()) > 0) {
                minTrayId = next.getId();
                minTray = next;
            }
            Trace.verbose((Object)this, "findSmallestTrayId", "minTrayId: " + minTrayId);
        }
        return minTray;
    }

    private void removeAhsDrives(int totalPoolSize) throws ConfigMgmtException {
        String methodName = "removeAhsDrives";
        Trace.methodBegin(this, "removeAhsDrives");
        ArrayList disksToRemove = new ArrayList();
        for (int currentSize = this._ahsPool.size(); currentSize > totalPoolSize; --currentSize) {
            ArrayList<TrayInterface> maxTrays = new ArrayList<TrayInterface>();
            ArrayList<TrayInterface> maxExpansionTrays = new ArrayList<TrayInterface>();
            int max = -1;
            for (int i = 0; i < this._trays.size(); ++i) {
                TrayInterface next = (TrayInterface)this._trays.get(i);
                Trace.verbose((Object)this, "removeAhsDrives", "checking " + next.getId());
                int alreadyRemoved = 0;
                Iterator iter = disksToRemove.iterator();
                while (iter.hasNext()) {
                    DiskInterface iterDisk = (DiskInterface)iter.next();
                    if (iterDisk.getTrayId() != Integer.parseInt(next.getId())) continue;
                    ++alreadyRemoved;
                }
                int numberOfAhs = next.getNumberOfDisksInRole("globalStandbyDisk");
                numberOfAhs -= alreadyRemoved;
                if (maxTrays.size() == 0) {
                    maxTrays.add(next);
                    max = numberOfAhs;
                    if (next.getTrayType() == 18) {
                        maxExpansionTrays.add(next);
                    }
                } else if (numberOfAhs > max) {
                    maxTrays.clear();
                    maxTrays.add(next);
                    max = numberOfAhs;
                    maxExpansionTrays.clear();
                    if (next.getTrayType() == 18) {
                        maxExpansionTrays.add(next);
                    }
                } else if (numberOfAhs == max) {
                    maxTrays.add(next);
                    if (next.getTrayType() == 18) {
                        maxExpansionTrays.add(next);
                    }
                }
                Trace.verbose((Object)this, "removeAhsDrives", "max: " + max);
            }
            if (maxTrays.size() == 0) {
                Trace.verbose((Object)this, "removeAhsDrives", "none found");
                throw new ConfigMgmtException("REMOVE_AHS_DISK_FAILURE", "no ahs disks to remove");
            }
            TrayInterface theTray = null;
            theTray = maxExpansionTrays.size() > 0 ? this.findHighestTrayId(maxExpansionTrays) : this.findHighestTrayId(maxTrays);
            Trace.verbose((Object)this, "removeAhsDrives", "found it: " + theTray.getId());
            this.removeAhsFromTray(theTray, disksToRemove);
        }
        Iterator toRemoveIter = disksToRemove.iterator();
        while (toRemoveIter.hasNext()) {
            DiskInterface iterDisk = (DiskInterface)toRemoveIter.next();
            for (int i = 0; i < this._newAhsPool.size(); ++i) {
                DiskInterface next = (DiskInterface)this._newAhsPool.get(i);
                if (iterDisk.getTrayId() != next.getTrayId() || iterDisk.getSlotNumber() != next.getSlotNumber()) continue;
                this._newAhsPool.remove(i);
            }
        }
    }

    private TrayInterface findHighestTrayId(List trayList) {
        String methodName = "findHighestTrayId";
        Trace.methodBegin(this, "findHighestTrayId");
        if (trayList.size() == 1) {
            return (TrayInterface)trayList.get(0);
        }
        String maxTrayId = null;
        TrayInterface maxTray = null;
        for (int j = 0; j < trayList.size(); ++j) {
            TrayInterface next = (TrayInterface)trayList.get(j);
            Trace.verbose((Object)this, "findHighestTrayId", "checking id: " + next.getId());
            if (maxTrayId == null) {
                maxTrayId = next.getId();
                maxTray = next;
            } else if (maxTrayId.compareTo(next.getId()) < 0) {
                maxTrayId = next.getId();
                maxTray = next;
            }
            Trace.verbose((Object)this, "findHighestTrayId", "max: " + maxTrayId);
        }
        return maxTray;
    }

    private CIMArgument[] buildInArgsForInitialize(CIMObjectPath sparedSetObjectPath, Vector storageExtVector) {
        String methodName = "buildInArgsForInitialize";
        Trace.methodBegin(this, "buildInArgsForInitialize");
        CIMArgument[] cimInArgs = new CIMArgument[3];
        Vector<String> v = new Vector<String>();
        Enumeration theEnum = storageExtVector.elements();
        while (theEnum.hasMoreElements()) {
            v.add(theEnum.nextElement().toString());
        }
        cimInArgs[0] = new CIMArgument("RedundantExtents", new CIMValue(v));
        Trace.verbose((Object)this, "buildInArgsForInitialize", "ssop: " + sparedSetObjectPath);
        cimInArgs[1] = new CIMArgument("SparedSet", new CIMValue((Object)sparedSetObjectPath));
        cimInArgs[2] = new CIMArgument("JobDescription", new CIMValue((Object)""));
        return cimInArgs;
    }

    private CIMObjectPath getSparedSetCimObjPath() throws ConfigMgmtException {
        String methodName = "getSparedSetCimObjPath";
        Trace.methodBegin(this, "getSparedSetCimObjPath");
        Enumeration theEnum = null;
        try {
            String queryString = "select * from SunStorEdge_6120ArraySparedSet where InstanceId = 'StorEdge 6120 " + this._t4.getClusterName() + " Array Spares" + "'";
            Trace.verbose((Object)this, "getSparedSetCimObjPath", "ArraySparedSet Query string created: " + queryString);
            theEnum = CIMObjectWrapper.execQuery(this._cimClient, queryString);
        }
        catch (ConfigMgmtException cme) {
            Trace.error((Object)this, "getSparedSetCimObjPath ", "Failed: " + cme.getMessage());
            throw cme;
        }
        if (theEnum != null && theEnum.hasMoreElements()) {
            CIMInstance instance = (CIMInstance)theEnum.nextElement();
            if (theEnum.hasMoreElements()) {
                String message = "More than one ArraySparedSet InstanceId instance returned for the array: " + this._t4.getName();
                Trace.verbose((Object)this, "getSparedSetCimObjPath", message);
                throw new ConfigMgmtException("TOOMANY_CIM_INSTANCE_RETURNED", message);
            }
            return instance.getObjectPath();
        }
        String message = "No ArraySparedSet InstanceId instances returned for the array: " + this._t4.getName();
        Trace.verbose((Object)this, "getSparedSetCimObjPath", message);
        throw new ConfigMgmtException("ZERO_CIM_INSTANCE_RETURNED", message);
    }

    protected void setManageTrays(ManageTraysInterface mtrays) {
        this._mtrays = mtrays;
    }

    protected void setManageDisks(ManageDisksInterface mdisks) {
        this._mdisks = mdisks;
    }

    protected List getAhsPool() {
        return this._ahsPool;
    }
}

