/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.mr3;

import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Constants;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.BadParameterException;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.impl.CIMObjectWrapper;
import com.sun.netstorage.array.mgmt.cfg.core.impl.MapElement;
import com.sun.netstorage.array.mgmt.cfg.core.impl.MapUint64ToBigInteger;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.FiberChannelPortInterface;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Set;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;

public class FiberChannelPort
implements FiberChannelPortInterface,
Constants.FiberChannelProperties {
    private Collection fieldMap;
    private int preferredSpeed;
    private int topology;
    private BigInteger actualSpeed;
    private boolean autoSense;
    private int portType;
    private CIMObjectPath currentT4;
    private String currentT4IpAddr;
    private ConfigContext context;
    private CIMInstance instance;
    static /* synthetic */ Class class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$mr3$FiberChannelPort;

    public FiberChannelPort(ConfigContext context, CIMObjectPath currentT4, String currentT4IpAddr) {
        this.currentT4 = currentT4;
        this.context = context;
        this.currentT4IpAddr = currentT4IpAddr;
    }

    public int getPreferredSpeed() {
        return this.preferredSpeed;
    }

    public int getTopology() {
        return this.topology;
    }

    public void setTopology(int topolgy) throws IllegalArgumentException {
        this.topology = topolgy;
    }

    public BigInteger getActualSpeed() {
        return this.actualSpeed;
    }

    public void init(ConfigContext context) throws ConfigMgmtException {
        this.context = context;
        CIMObjectWrapper.populate(this, this.getFieldMap(), this.getInstance());
        if (this.isAutoSense()) {
            this.setPreferredSpeed(0);
        } else if (Constants.FiberChannelProperties.ONE_GIGABYTE.equals(this.getActualSpeed())) {
            this.setPreferredSpeed(1);
        } else if (Constants.FiberChannelProperties.TWO_GIGABYTE.equals(this.getActualSpeed())) {
            this.setPreferredSpeed(2);
        } else {
            throw new ConfigMgmtException("CIM_VALUE_OUT_OF_RANGE", "Retrieved Fiber Channel Port Speed not equal to one or two gigabytes.");
        }
    }

    public void save() throws ConfigMgmtException {
        Trace.methodBegin(this, "save");
        CIMObjectWrapper.save(this, this.getFieldMap(), this.getInstance(), this.context.getClient());
    }

    public void reload() throws ConfigMgmtException {
        this.instance = null;
        this.init(this.context);
    }

    public Collection getFieldMap() {
        Trace.methodBegin(this, "getFieldMap");
        if (null == this.fieldMap) {
            this.fieldMap = new ArrayList();
            this.fieldMap.add(new MapUint64ToBigInteger("actualSpeed", "Speed"));
            this.fieldMap.add(new MapElement("autoSense", "AutoSense"));
            this.fieldMap.add(new MapElement("topology", "PortType"));
        }
        return this.fieldMap;
    }

    public void setActualSpeed(BigInteger actualSpeed) {
        this.actualSpeed = actualSpeed;
    }

    public void setPreferredSpeed(int preferredSpeed) {
        switch (preferredSpeed) {
            case 0: {
                this.setAutoSense(true);
                break;
            }
            case 1: {
                this.setAutoSense(false);
                this.setActualSpeed(Constants.FiberChannelProperties.ONE_GIGABYTE);
                break;
            }
            case 2: {
                this.setAutoSense(false);
                this.setActualSpeed(Constants.FiberChannelProperties.TWO_GIGABYTE);
            }
        }
        this.preferredSpeed = preferredSpeed;
    }

    public boolean isAutoSense() {
        return this.autoSense;
    }

    public void setAutoSense(boolean autoSense) {
        this.autoSense = autoSense;
    }

    protected CIMInstance getInstance() throws ConfigMgmtException {
        Trace.methodBegin(this, "getInstance");
        if (null == this.instance) {
            try {
                Enumeration fcEnum = CIMObjectWrapper.execQuery(this.context.getClient(), "Select * from SunStorEdge_6120FCPort where SystemName = '" + this.currentT4IpAddr + "'");
                if (fcEnum == null || !fcEnum.hasMoreElements()) {
                    throw new ConfigMgmtException("Zero CIM Instances Returned for FCPort", "ZERO_CIM_INSTANCE_RETURNED");
                }
                this.instance = (CIMInstance)fcEnum.nextElement();
            }
            catch (ConfigMgmtException cme) {
                Trace.error((Object)this, "getInstance", "Failed: " + cme.getMessage());
                throw cme;
            }
        }
        return this.instance;
    }

    protected CIMInstance getInstanceAsGoodCIMClient() throws ConfigMgmtException {
        Trace.methodBegin(this, "getInstanceAsGoodCIMClient");
        if (null == this.instance) {
            try {
                Enumeration csEnum = this.context.getClient().associatorNames(this.currentT4, "SunStorEdge_6120ComponentCS", "SunStorEdge_6120ControllerSystem", "GroupComponent", "PartComponent");
                if (!csEnum.hasMoreElements()) {
                    throw new ConfigMgmtException("Zero CIM Instances Returned for Controller System", "ZERO_CIM_INSTANCE_RETURNED");
                }
                Trace.verbose(class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$mr3$FiberChannelPort == null ? (class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$mr3$FiberChannelPort = FiberChannelPort.class$("com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.mr3.FiberChannelPort")) : class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$mr3$FiberChannelPort, "getInstanceAsGoodCIMClient", "We are back from enumerating ControllerSystems.");
                Enumeration fcEnum = this.context.getClient().associators((CIMObjectPath)csEnum.nextElement(), "SunStorEdge_6120PortSystemDevice", "SunStorEdge_6120FCPort", "GroupComponent", "PartComponent", true, false, null);
                if (!fcEnum.hasMoreElements()) {
                    throw new ConfigMgmtException("Zero CIM Instances Returned for FCPort", "ZERO_CIM_INSTANCE_RETURNED");
                }
                this.instance = (CIMInstance)fcEnum.nextElement();
            }
            catch (ConfigMgmtException cme) {
                Trace.error(class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$mr3$FiberChannelPort == null ? (class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$mr3$FiberChannelPort = FiberChannelPort.class$("com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.mr3.FiberChannelPort")) : class$com$sun$netstorage$array$mgmt$cfg$mgmt$business$impl$mr3$FiberChannelPort, "getInstanceAsGoodCIMClient", "Failed: " + cme.getMessage());
                throw cme;
            }
        }
        return this.instance;
    }

    public String getPortName() {
        return null;
    }

    public int getLinkState() {
        return 0;
    }

    public int getHardwareState() {
        return 0;
    }

    public String getPortID() {
        return null;
    }

    public String getPortWWN() {
        return null;
    }

    public String getNodeWWN() {
        return null;
    }

    public int getPortType() {
        return 0;
    }

    public String getUptime() {
        return null;
    }

    public int getIDConfigured() {
        return 0;
    }

    public int getIDOperational() {
        return 0;
    }

    public int getSpeedConfigured() {
        return 0;
    }

    public int getSpeedOperational() {
        return 0;
    }

    public Set getClassesCapable() {
        return null;
    }

    public Set getClassesOperational() {
        return null;
    }

    public Set getProtocolsCapable() {
        return null;
    }

    public Set getProtocolsOperational() {
        return null;
    }

    public String getModuleType() {
        return null;
    }

    public String getFcUnitType() {
        return null;
    }

    public BigInteger getErrorCount() {
        return null;
    }

    public BigInteger getWriteCommands() {
        return null;
    }

    public BigInteger getReadCommands() {
        return null;
    }

    public BigInteger getBytesWritten() {
        return null;
    }

    public BigInteger getBytesRead() {
        return null;
    }

    public BigInteger getLoopResetEvents() {
        return null;
    }

    public BigInteger getLoopDownEvents() {
        return null;
    }

    public BigInteger getLinkSyncLossCount() {
        return null;
    }

    public BigInteger getLinkFailureCount() {
        return null;
    }

    public BigInteger getLinkDownCount() {
        return null;
    }

    public BigInteger getPrimSeqProtoErrorCount() {
        return null;
    }

    public BigInteger getCRCErrors() {
        return null;
    }

    public BigInteger getInvalidTransWords() {
        return null;
    }

    public ArrayList getAssociatedInitiators() throws ConfigMgmtException {
        return null;
    }

    public Collection getKey() {
        return null;
    }

    public void setIDConfigured(int fcID) throws BadParameterException {
    }

    public void setSpeedConfigured(int speed) throws BadParameterException {
    }

    public boolean isReplicationEnabled() {
        return false;
    }

    public int getPortStyle() {
        return 1;
    }

    public void setReplicationEnabled(boolean enabled) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

