/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.mr3;

import com.sun.netstorage.array.mgmt.cfg.access.business.ManageVolumeGroupsFactory;
import com.sun.netstorage.array.mgmt.cfg.access.business.ManageVolumeGroupsInterface;
import com.sun.netstorage.array.mgmt.cfg.access.business.VolumeGroupInterface;
import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.logic.SearchFilter;
import com.sun.netstorage.array.mgmt.cfg.jobs.business.JobCompletionInterface;
import com.sun.netstorage.array.mgmt.cfg.jobs.business.impl.mr3.JobLink;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageVolumesFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageVolumesInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageT4sFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageT4sInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.T4Interface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.mr3.StorageVolume;
import com.sun.netstorage.array.mgmt.logger.LogAPI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class CreateStorageVolumeCompletion
implements JobCompletionInterface {
    private String volumeName;
    private String t4Name;
    private String poolName;
    private String volumeGroupName;
    private int executeCount = 0;
    private boolean isDone = false;
    private ArrayList preReqs = new ArrayList();

    public CreateStorageVolumeCompletion(String volumeName, String t4Name, String poolName, String volumeGroupName) {
        Trace.constructor(this);
        this.volumeName = volumeName;
        this.t4Name = t4Name;
        this.poolName = poolName;
        this.volumeGroupName = volumeGroupName;
        Trace.verbose((Object)this, "CreateStorageVolumeCompletion", "Values passed to constructor - volumeName: " + volumeName + " t4Name: " + t4Name + " volumeGroupName: " + volumeGroupName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobLink[] execute(ConfigContext cc) throws ConfigMgmtException {
        Trace.methodBegin(this, "execute");
        ++this.executeCount;
        try {
            StorageVolume newVolume = null;
            T4Interface t4 = null;
            ManageT4sInterface manageT4s = ManageT4sFactory.getManager();
            manageT4s.init(cc, null);
            t4 = manageT4s.getT4ByName(this.t4Name);
            Trace.verbose((Object)this, "execute", "Searching for volume: " + this.volumeName);
            SearchFilter filter = new SearchFilter("OtherIdentifyingInfo", this.volumeName);
            ManageStorageVolumesInterface manageStorageVolumes = ManageStorageVolumesFactory.getManager();
            manageStorageVolumes.setScope(t4);
            manageStorageVolumes.init(cc, filter);
            List volumes = manageStorageVolumes.getItemList();
            if (volumes.size() != 1) {
                Trace.verbose((Object)this, "execute", "ManageStorageVolumes wrong number of elements.");
                if (volumes.isEmpty()) {
                    throw new ConfigMgmtException("ZERO_CIM_INSTANCE_RETURNED", "ManageStorageVolumes did not return any instances.");
                }
                throw new ConfigMgmtException("TOOMANY_CIM_INSTANCE_RETURNED", "ManageStorageVolumes returned more than one instance.");
            }
            newVolume = (StorageVolume)volumes.get(0);
            String[] args = new String[]{this.volumeName, this.t4Name, newVolume.getRaidGroupName()};
            try {
                if (this.volumeGroupName != null && this.volumeGroupName.trim().length() > 0) {
                    ManageVolumeGroupsInterface volumeGroupsManager = ManageVolumeGroupsFactory.getManager();
                    volumeGroupsManager.setScope(t4);
                    volumeGroupsManager.init(cc, null);
                    List volumeGroups = volumeGroupsManager.getItemList();
                    Iterator iter = volumeGroups.iterator();
                    while (iter.hasNext()) {
                        VolumeGroupInterface volumeGroup = (VolumeGroupInterface)iter.next();
                        if (!this.volumeGroupName.equals(volumeGroup.getName())) continue;
                        volumeGroup.addVolumeToGroup(newVolume);
                        Trace.verbose((Object)this, "execute", "Volume added to the group: " + volumeGroup.getName());
                    }
                    Trace.verbose((Object)this, "execute", "Volume added to all selected groups.");
                }
            }
            catch (ConfigMgmtException cme) {
                Trace.verbose((Object)this, "execute", "Exception when trying add volume to the volume groups.");
                LogAPI.staticLog((String)"VOLUME_CREATE_ERROR", (String[])args, (String[])new String[0]);
            }
        }
        finally {
            this.cleanup();
        }
        return new JobLink[0];
    }

    public void cleanup() {
        Trace.methodBegin(this, "cleanup");
        this.isDone = true;
    }

    public boolean isDone() {
        return this.isDone;
    }

    public int getExecuteCount() {
        return this.executeCount;
    }

    public String getErrorKey() {
        return "VOLUME_CREATE_ERROR";
    }

    public String[] getErrorSubstitutions() {
        String[] substitutions = new String[]{this.volumeName, this.t4Name, this.poolName};
        return substitutions;
    }

    public ArrayList getPrerequisiteTasks() {
        return this.preReqs;
    }

    public void addPrerequisiteTasks(Collection jobs) {
        this.preReqs.addAll(jobs);
    }

    public boolean isReadyToRun(ConfigContext cc) {
        return true;
    }
}

