/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.mr3;

import com.sun.netstorage.array.mgmt.cfg.core.ConfigContext;
import com.sun.netstorage.array.mgmt.cfg.core.MethodCallStatus;
import com.sun.netstorage.array.mgmt.cfg.core.Trace;
import com.sun.netstorage.array.mgmt.cfg.core.exception.ConfigMgmtException;
import com.sun.netstorage.array.mgmt.cfg.core.logic.SearchFilter;
import com.sun.netstorage.array.mgmt.cfg.jobs.business.JobCompletionInterface;
import com.sun.netstorage.array.mgmt.cfg.jobs.business.impl.mr3.JobLink;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageVolumesFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageStorageVolumesInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageT4sFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageT4sInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageTraysFactory;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.ManageTraysInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.StorageVolumeInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.T4Interface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.TrayInterface;
import com.sun.netstorage.array.mgmt.cfg.mgmt.business.impl.mr3.RaidGroup;
import com.sun.netstorage.array.mgmt.logger.LogAPI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;

public class CloneTrayJobCompletion
implements JobCompletionInterface {
    private String destT4Name;
    private String sourceT4Name;
    private TrayInterface sourceTray;
    private TrayInterface destTray;
    private String sourceTrayId;
    private String destTrayId;
    private int executeCount = 0;
    private boolean isDone = false;
    private ArrayList preReqs = new ArrayList();

    public CloneTrayJobCompletion(String argDestT4Name, String argSourceT4Name, TrayInterface argSourceTray, TrayInterface argDestTray) throws ConfigMgmtException {
        this.destT4Name = argDestT4Name;
        this.sourceT4Name = argSourceT4Name;
        this.sourceTray = argSourceTray;
        this.destTray = argDestTray;
        this.sourceTrayId = argSourceTray.getId();
        this.destTrayId = argDestTray.getId();
    }

    public String getErrorKey() {
        return "ARRAY_DUPLICATE_TRAY_FROM_SOURCE_ERROR";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobLink[] execute(ConfigContext cc) throws ConfigMgmtException {
        Trace.methodBegin(this, "execute");
        ++this.executeCount;
        try {
            this.sourceTray = this.getTrayInterface(cc, this.sourceT4Name, this.sourceTrayId);
            this.destTray = this.getTrayInterface(cc, this.destT4Name, this.destTrayId);
            ManageStorageVolumesInterface manageStorageVolumes = ManageStorageVolumesFactory.getManager();
            manageStorageVolumes.init(cc, null);
            if (this.sourceT4Name.equals(this.destT4Name)) {
                JobLink[] jobLinkArray = new JobLink[]{};
                return jobLinkArray;
            }
            ArrayList sourceRaidGroups = (ArrayList)this.sourceTray.getRaidGroups();
            if (sourceRaidGroups == null || sourceRaidGroups.size() == 0) {
                JobLink[] jobLinkArray = new JobLink[]{};
                return jobLinkArray;
            }
            for (int i = 0; i < sourceRaidGroups.size(); ++i) {
                RaidGroup rg = (RaidGroup)sourceRaidGroups.get(i);
                Iterator iterator = rg.getVolumes().iterator();
                while (iterator.hasNext()) {
                    StorageVolumeInterface storageVolume = (StorageVolumeInterface)iterator.next();
                    Trace.verbose((Object)this, "execute", "Calling createVolume to create StorageVolume.");
                    MethodCallStatus status = manageStorageVolumes.createVolume(storageVolume.getName(), this.destT4Name, rg.getName(), storageVolume.getSize(), storageVolume.getVolumePermissions(), storageVolume.getLUN(), null);
                }
            }
        }
        catch (Exception e) {
            Trace.verbose((Object)this, "execute", (Throwable)e);
            LogAPI.staticLog((String)this.getErrorKey(), (String[])this.getErrorSubstitutions(), (String[])new String[0]);
        }
        finally {
            this.cleanup();
        }
        return new JobLink[0];
    }

    public String[] getErrorSubstitutions() {
        String[] substitutions = new String[]{this.destT4Name, this.destTray.getId(), this.sourceTray.getId()};
        return substitutions;
    }

    public void cleanup() {
        Trace.methodBegin(this, "cleanup");
        this.isDone = true;
    }

    public boolean isDone() {
        return this.isDone;
    }

    public int getExecuteCount() {
        return this.executeCount;
    }

    public ArrayList getPrerequisiteTasks() {
        return this.preReqs;
    }

    public void addPrerequisiteTasks(Collection jobs) {
        this.preReqs.addAll(jobs);
    }

    public boolean isReadyToRun(ConfigContext cc) {
        return true;
    }

    private TrayInterface getTrayInterface(ConfigContext cc, String t4Name, String id) throws ConfigMgmtException {
        ManageT4sInterface mt4 = ManageT4sFactory.getManager();
        mt4.init(cc, null);
        T4Interface t4 = mt4.getT4ByName(t4Name);
        if (t4 == null) {
            throw new ConfigMgmtException("Zero CIM Instances Returned for array", "ZERO_CIM_INSTANCE_RETURNED");
        }
        ManageTraysInterface mTray = ManageTraysFactory.getManager();
        mTray.setScope(t4);
        SearchFilter sf = new SearchFilter("Tag", Pattern.compile(":" + id + "$"));
        mTray.init(cc, sf);
        List trays = mTray.getItemList();
        if (trays == null || trays.size() == 0) {
            throw new ConfigMgmtException("Zero CIM Instances Returned for Tray", "ZERO_CIM_INSTANCE_RETURNED");
        }
        TrayInterface tray = (TrayInterface)trays.get(0);
        return tray;
    }
}

